"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FetchTransport = void 0;
var faro_core_1 = require("@grafana/faro-core");
var sessionManager_1 = require("../../instrumentations/session/sessionManager");
var sessionManagerUtils_1 = require("../../instrumentations/session/sessionManager/sessionManagerUtils");
var DEFAULT_BUFFER_SIZE = 30;
var DEFAULT_CONCURRENCY = 5; // chrome supports 10 total, firefox 17
var DEFAULT_RATE_LIMIT_BACKOFF_MS = 5000;
var BEACON_BODY_SIZE_LIMIT = 60000;
var TOO_MANY_REQUESTS = 429;
var ACCEPTED = 202;
var FetchTransport = /** @class */ (function (_super) {
    __extends(FetchTransport, _super);
    function FetchTransport(options) {
        var _this = this;
        var _a, _b, _c, _d;
        _this = _super.call(this) || this;
        _this.options = options;
        _this.name = '@grafana/faro-web-sdk:transport-fetch';
        _this.version = faro_core_1.VERSION;
        _this.disabledUntil = new Date();
        _this.rateLimitBackoffMs = (_a = options.defaultRateLimitBackoffMs) !== null && _a !== void 0 ? _a : DEFAULT_RATE_LIMIT_BACKOFF_MS;
        _this.getNow = (_b = options.getNow) !== null && _b !== void 0 ? _b : (function () { return Date.now(); });
        _this.promiseBuffer = (0, faro_core_1.createPromiseBuffer)({
            size: (_c = options.bufferSize) !== null && _c !== void 0 ? _c : DEFAULT_BUFFER_SIZE,
            concurrency: (_d = options.concurrency) !== null && _d !== void 0 ? _d : DEFAULT_CONCURRENCY,
        });
        return _this;
    }
    FetchTransport.prototype.send = function (items) {
        return __awaiter(this, void 0, void 0, function () {
            var err_1;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        if (this.disabledUntil > new Date(this.getNow())) {
                            this.logWarn("Dropping transport item due to too many requests. Backoff until ".concat(this.disabledUntil));
                            return [2 /*return*/, Promise.resolve()];
                        }
                        return [4 /*yield*/, this.promiseBuffer.add(function () {
                                var body = JSON.stringify((0, faro_core_1.getTransportBody)(items));
                                var _a = _this.options, url = _a.url, requestOptions = _a.requestOptions, apiKey = _a.apiKey;
                                var _b = requestOptions !== null && requestOptions !== void 0 ? requestOptions : {}, headers = _b.headers, restOfRequestOptions = __rest(_b, ["headers"]);
                                var sessionId;
                                var sessionMeta = _this.metas.value.session;
                                if (sessionMeta != null) {
                                    sessionId = sessionMeta.id;
                                }
                                return fetch(url, __assign({ method: 'POST', headers: __assign(__assign(__assign({ 'Content-Type': 'application/json' }, (headers !== null && headers !== void 0 ? headers : {})), (apiKey ? { 'x-api-key': apiKey } : {})), (sessionId ? { 'x-faro-session-id': sessionId } : {})), body: body, keepalive: body.length <= BEACON_BODY_SIZE_LIMIT }, (restOfRequestOptions !== null && restOfRequestOptions !== void 0 ? restOfRequestOptions : {})))
                                    .then(function (response) { return __awaiter(_this, void 0, void 0, function () {
                                    var sessionExpired;
                                    return __generator(this, function (_a) {
                                        if (response.status === ACCEPTED) {
                                            sessionExpired = response.headers.get('X-Faro-Session-Status') === 'invalid';
                                            if (sessionExpired) {
                                                this.extendFaroSession(this.config, this.logDebug);
                                            }
                                        }
                                        if (response.status === TOO_MANY_REQUESTS) {
                                            this.disabledUntil = this.getRetryAfterDate(response);
                                            this.logWarn("Too many requests, backing off until ".concat(this.disabledUntil));
                                        }
                                        // read the body so the connection can be closed
                                        response.text().catch(faro_core_1.noop);
                                        return [2 /*return*/, response];
                                    });
                                }); })
                                    .catch(function (err) {
                                    _this.logError('Failed sending payload to the receiver\n', JSON.parse(body), err);
                                });
                            })];
                    case 1:
                        _a.sent();
                        return [3 /*break*/, 3];
                    case 2:
                        err_1 = _a.sent();
                        this.logError(err_1);
                        return [3 /*break*/, 3];
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    FetchTransport.prototype.getIgnoreUrls = function () {
        var _a;
        return [this.options.url].concat((_a = this.config.ignoreUrls) !== null && _a !== void 0 ? _a : []);
    };
    FetchTransport.prototype.isBatched = function () {
        return true;
    };
    FetchTransport.prototype.getRetryAfterDate = function (response) {
        var now = this.getNow();
        var retryAfterHeader = response.headers.get('Retry-After');
        if (retryAfterHeader) {
            var delay = Number(retryAfterHeader);
            if (!isNaN(delay)) {
                return new Date(delay * 1000 + now);
            }
            var date = Date.parse(retryAfterHeader);
            if (!isNaN(date)) {
                return new Date(date);
            }
        }
        return new Date(now + this.rateLimitBackoffMs);
    };
    FetchTransport.prototype.extendFaroSession = function (config, logDebug) {
        var SessionExpiredString = "Session expired";
        var sessionTrackingConfig = config.sessionTracking;
        if (sessionTrackingConfig === null || sessionTrackingConfig === void 0 ? void 0 : sessionTrackingConfig.enabled) {
            var _a = (0, sessionManager_1.getSessionManagerByConfig)(sessionTrackingConfig), fetchUserSession = _a.fetchUserSession, storeUserSession = _a.storeUserSession;
            (0, sessionManagerUtils_1.getUserSessionUpdater)({ fetchUserSession: fetchUserSession, storeUserSession: storeUserSession })({ forceSessionExtend: true });
            logDebug("".concat(SessionExpiredString, " created new session."));
        }
        else {
            logDebug("".concat(SessionExpiredString, "."));
        }
    };
    return FetchTransport;
}(faro_core_1.BaseTransport));
exports.FetchTransport = FetchTransport;
//# sourceMappingURL=transport.js.map