"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPageMeta = void 0;
var faro_core_1 = require("@grafana/faro-core");
var currentHref;
var pageId;
function createPageMeta(_a) {
    var _b = _a === void 0 ? {} : _a, generatePageId = _b.generatePageId, initialPageMeta = _b.initialPageMeta;
    var pageMeta = function () {
        var locationHref = location.href;
        if ((0, faro_core_1.isFunction)(generatePageId) && currentHref !== locationHref) {
            currentHref = locationHref;
            pageId = generatePageId(location);
        }
        return {
            page: __assign(__assign({ url: locationHref }, (pageId ? { id: pageId } : {})), initialPageMeta),
        };
    };
    return pageMeta;
}
exports.createPageMeta = createPageMeta;
//# sourceMappingURL=meta.js.map