"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebVitalsInstrumentation = void 0;
var faro_core_1 = require("@grafana/faro-core");
var webVitalsBasic_1 = require("./webVitalsBasic");
var webVitalsWithAttribution_1 = require("./webVitalsWithAttribution");
var WebVitalsInstrumentation = /** @class */ (function (_super) {
    __extends(WebVitalsInstrumentation, _super);
    function WebVitalsInstrumentation() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.name = '@grafana/faro-web-sdk:instrumentation-web-vitals';
        _this.version = faro_core_1.VERSION;
        return _this;
    }
    WebVitalsInstrumentation.prototype.initialize = function () {
        this.logDebug('Initializing');
        var webVitals = this.intializeWebVitalsInstrumentation();
        webVitals.initialize();
    };
    WebVitalsInstrumentation.prototype.intializeWebVitalsInstrumentation = function () {
        var _a;
        if ((_a = this.config) === null || _a === void 0 ? void 0 : _a.trackWebVitalsAttribution) {
            return new webVitalsWithAttribution_1.WebVitalsWithAttribution(this.api.pushMeasurement, this.config.webVitalsInstrumentation);
        }
        return new webVitalsBasic_1.WebVitalsBasic(this.api.pushMeasurement, this.config.webVitalsInstrumentation);
    };
    return WebVitalsInstrumentation;
}(faro_core_1.BaseInstrumentation));
exports.WebVitalsInstrumentation = WebVitalsInstrumentation;
//# sourceMappingURL=instrumentation.js.map