"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getStackFramesFromError = void 0;
var faro_core_1 = require("@grafana/faro-core");
var buildStackFrame_1 = require("./buildStackFrame");
var const_1 = require("./const");
var getDataFromSafariExtensions_1 = require("./getDataFromSafariExtensions");
function getStackFramesFromError(error) {
    var lines = [];
    if (error.stacktrace) {
        lines = error.stacktrace.split(const_1.newLineString).filter(function (_line, idx) { return idx % 2 === 0; });
    }
    else if (error.stack) {
        lines = error.stack.split(const_1.newLineString);
    }
    var stackFrames = lines.reduce(function (acc, line, idx) {
        var _a, _b;
        var parts;
        var func;
        var filename;
        var lineno;
        var colno;
        if ((parts = const_1.webkitLineRegex.exec(line))) {
            func = parts[1];
            filename = parts[2];
            lineno = parts[3];
            colno = parts[4];
            if (filename === null || filename === void 0 ? void 0 : filename.startsWith(const_1.webkitEvalString)) {
                var submatch = const_1.webkitEvalRegex.exec(filename);
                if (submatch) {
                    filename = submatch[1];
                    lineno = submatch[2];
                    colno = submatch[3];
                }
            }
            filename = (filename === null || filename === void 0 ? void 0 : filename.startsWith(const_1.webkitAddressAtString))
                ? filename.substring(const_1.webkitAddressAtStringLength)
                : filename;
            _a = (0, getDataFromSafariExtensions_1.getDataFromSafariExtensions)(func, filename), func = _a[0], filename = _a[1];
        }
        else if ((parts = const_1.firefoxLineRegex.exec(line))) {
            func = parts[1];
            filename = parts[3];
            lineno = parts[4];
            colno = parts[5];
            if (!!filename && filename.includes(const_1.firefoxEvalString)) {
                var submatch = const_1.firefoxEvalRegex.exec(filename);
                if (submatch) {
                    func = func || const_1.evalString;
                    filename = submatch[1];
                    lineno = submatch[2];
                }
            }
            else if (idx === 0 && !colno && (0, faro_core_1.isNumber)(error.columnNumber)) {
                colno = String(error.columnNumber + 1);
            }
            _b = (0, getDataFromSafariExtensions_1.getDataFromSafariExtensions)(func, filename), func = _b[0], filename = _b[1];
        }
        if (filename || func) {
            acc.push((0, buildStackFrame_1.buildStackFrame)(filename, func, lineno ? Number(lineno) : undefined, colno ? Number(colno) : undefined));
        }
        return acc;
    }, []);
    if (const_1.reactMinifiedRegex.test(error.message)) {
        return stackFrames.slice(1);
    }
    return stackFrames;
}
exports.getStackFramesFromError = getStackFramesFromError;
//# sourceMappingURL=getStackFramesFromError.js.map