export interface PromiseBufferOptions {
    concurrency: number;
    size: number;
}
export type PromiseProducer<T> = () => PromiseLike<T>;
export interface PromiseBuffer<T> {
    add(promiseProducer: PromiseProducer<T>): PromiseLike<T>;
}
export interface BufferItem<T> {
    producer: PromiseProducer<T>;
    resolve: (value: T) => void;
    reject: (reason?: any) => void;
}
export declare function createPromiseBuffer<T>(options: PromiseBufferOptions): PromiseBuffer<T>;
