"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var is_1 = require("./is");
describe('Meta API', function () {
    beforeEach(function () {
        jest.resetAllMocks();
        jest.restoreAllMocks();
    });
    it('isEmpty() determines the empty state of a given  value', function () {
        expect((0, is_1.isEmpty)(null)).toBe(true);
        expect((0, is_1.isEmpty)(undefined)).toBe(true);
        expect((0, is_1.isEmpty)('')).toBe(true);
        expect((0, is_1.isEmpty)([])).toBe(true);
        expect((0, is_1.isEmpty)({})).toBe(true);
        expect((0, is_1.isEmpty)(0)).toBe(false);
        expect((0, is_1.isEmpty)('0')).toBe(false);
        expect((0, is_1.isEmpty)([0])).toBe(false);
        expect((0, is_1.isEmpty)({ key: 'value' })).toBe(false);
    });
});
//# sourceMappingURL=is.test.js.map