"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deepEqual = void 0;
var is_1 = require("./is");
// This function was inspired by fast-deep-equal
// fast-deep-equal has issues with Rollup and also it checks for some edge cases that we don't need
function deepEqual(a, b) {
    if (a === b) {
        return true;
    }
    // Using isTypeOf instead of isNumber as isNumber also checks against NaN
    if ((0, is_1.isTypeof)(a, 'number') && isNaN(a)) {
        return (0, is_1.isTypeof)(b, 'number') && isNaN(b);
    }
    var aIsArray = (0, is_1.isArray)(a);
    var bIsArray = (0, is_1.isArray)(b);
    if (aIsArray !== bIsArray) {
        return false;
    }
    if (aIsArray && bIsArray) {
        var length_1 = a.length;
        if (length_1 !== b.length) {
            return false;
        }
        for (var idx = length_1; idx-- !== 0;) {
            if (!deepEqual(a[idx], b[idx])) {
                return false;
            }
        }
        return true;
    }
    var aIsObject = (0, is_1.isObject)(a);
    var bIsObject = (0, is_1.isObject)(b);
    if (aIsObject !== bIsObject) {
        return false;
    }
    if (a && b && aIsObject && bIsObject) {
        var aKeys = Object.keys(a);
        var bKeys = Object.keys(b);
        var aLength = aKeys.length;
        var bLength = bKeys.length;
        if (aLength !== bLength) {
            return false;
        }
        for (var _i = 0, aKeys_1 = aKeys; _i < aKeys_1.length; _i++) {
            var aKey = aKeys_1[_i];
            if (!bKeys.includes(aKey)) {
                return false;
            }
        }
        for (var _a = 0, aKeys_2 = aKeys; _a < aKeys_2.length; _a++) {
            var aKey = aKeys_2[_a];
            if (!deepEqual(a[aKey], b[aKey])) {
                return false;
            }
        }
        return true;
    }
    return false;
}
exports.deepEqual = deepEqual;
//# sourceMappingURL=deepEqual.js.map