"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @jest-environment jsdom
 */
var __1 = require("..");
var batchExecutor_1 = require("./batchExecutor");
var generateTransportItem = function (randomMeta) { return ({
    type: __1.TransportItemType.LOG,
    payload: {
        context: {},
        level: __1.LogLevel.INFO,
        message: 'hi',
        timestamp: '2023-01-27T09:53:01.035Z',
    },
    meta: {
        sdk: {
            name: randomMeta ? (Math.random() + 1).toString(36).substring(7) : 'test-sdk',
        },
    },
}); };
describe('BatchExecutor', function () {
    it('tests instantiating BatchExecutor class', function () {
        var sendSpy = jest.fn();
        var be = new batchExecutor_1.BatchExecutor(sendSpy);
        expect(be).toBeInstanceOf(batchExecutor_1.BatchExecutor);
    });
    describe('config options', function () {
        afterEach(function () {
            jest.restoreAllMocks();
        });
        beforeAll(function () {
            jest.useFakeTimers();
        });
        it('tests send when exceeding batch size', function () {
            var mockSendFunction = jest.fn();
            var item = generateTransportItem();
            var be = new batchExecutor_1.BatchExecutor(mockSendFunction, {
                sendTimeout: 1,
                itemLimit: 2,
            });
            be.addItem(item);
            expect(mockSendFunction).not.toBeCalled();
            be.addItem(item);
            expect(mockSendFunction).toBeCalledTimes(1);
        });
        it('tests send with empty buffer', function () {
            var mockSendFunction = jest.fn();
            new batchExecutor_1.BatchExecutor(mockSendFunction, {
                sendTimeout: 1,
            });
            jest.advanceTimersByTime(2);
            expect(mockSendFunction).not.toBeCalled();
        });
        it('tests send when "visibilitychange" event is emitted and visibilityState changes', function () {
            var mockSendFunction = jest.fn();
            var item = generateTransportItem();
            var be = new batchExecutor_1.BatchExecutor(mockSendFunction, {
                sendTimeout: 1,
            });
            be.addItem(item);
            Object.defineProperty(document, 'visibilityState', {
                configurable: true,
                get: function () {
                    return 'hidden';
                },
            });
            document.dispatchEvent(new Event('visibilitychange'));
            expect(mockSendFunction).toBeCalledTimes(1);
        });
        it('tests send when "visibilitychange" event is emitted and visibilityState changes to visible', function () {
            var mockSendFunction = jest.fn();
            var item = generateTransportItem();
            var be = new batchExecutor_1.BatchExecutor(mockSendFunction, {
                sendTimeout: 1,
            });
            be.addItem(item);
            Object.defineProperty(document, 'visibilityState', {
                configurable: true,
                get: function () {
                    return 'visible';
                },
            });
            document.dispatchEvent(new Event('visibilitychange'));
            expect(mockSendFunction).toBeCalledTimes(0);
        });
        it('tests send when starting paused', function () {
            var mockSendFunction = jest.fn();
            var item = generateTransportItem();
            var be = new batchExecutor_1.BatchExecutor(mockSendFunction, {
                sendTimeout: 1,
                paused: true,
            });
            be.addItem(item);
            jest.advanceTimersByTime(2);
            expect(mockSendFunction).not.toBeCalled();
        });
        it('tests send when paused', function () {
            var mockSendFunction = jest.fn();
            var item = generateTransportItem();
            var be = new batchExecutor_1.BatchExecutor(mockSendFunction, {
                sendTimeout: 1,
            });
            be.addItem(item);
            be.pause();
            jest.advanceTimersByTime(2);
            expect(mockSendFunction).not.toBeCalled();
        });
        it('tests send when unpaused', function () {
            var mockSendFunction = jest.fn();
            var item = generateTransportItem();
            var be = new batchExecutor_1.BatchExecutor(mockSendFunction, {
                sendTimeout: 1,
            });
            be.addItem(item);
            be.pause();
            jest.advanceTimersByTime(2);
            be.start();
            expect(mockSendFunction).not.toBeCalled();
            jest.advanceTimersByTime(2);
            expect(mockSendFunction).toBeCalledTimes(1);
        });
        it('tests groupItems', function () {
            var be = new batchExecutor_1.BatchExecutor(function () { }, {
                sendTimeout: 1,
            });
            var itemsWithSameMeta = __spreadArray([], Array(3), true).map(function () { return generateTransportItem(false); });
            var itemsWithRandomMeta = __spreadArray([], Array(5), true).map(function () { return generateTransportItem(true); });
            var groups = be.groupItems(__spreadArray(__spreadArray([], itemsWithSameMeta, true), itemsWithRandomMeta, true));
            expect(groups).toHaveLength(itemsWithRandomMeta.length + 1);
        });
        it('tests grouping', function () {
            var mockSendFunction = jest.fn();
            var be = new batchExecutor_1.BatchExecutor(mockSendFunction, {
                sendTimeout: 1,
            });
            be.start();
            var item = generateTransportItem();
            be.addItem(__assign(__assign({}, item), { meta: {
                    sdk: {
                        name: 'foo',
                    },
                } }));
            be.addItem(__assign(__assign({}, item), { meta: {
                    sdk: {
                        name: 'foo',
                    },
                } }));
            be.addItem(__assign(__assign({}, item), { meta: {
                    sdk: {
                        name: 'bar',
                    },
                } }));
            jest.advanceTimersByTime(2);
            expect(mockSendFunction).toBeCalledTimes(2);
        });
    });
});
//# sourceMappingURL=batchExecutor.test.js.map