"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var initialize_1 = require("../../initialize");
var testUtils_1 = require("../../testUtils");
describe('api.measurements', function () {
    function createAPI(_a) {
        var _b = _a === void 0 ? { dedupe: true } : _a, dedupe = _b.dedupe;
        var transport = new testUtils_1.MockTransport();
        var config = (0, testUtils_1.mockConfig)({
            dedupe: dedupe,
            transports: [transport],
        });
        var api = (0, initialize_1.initializeFaro)(config).api;
        return [api, transport];
    }
    describe('pushMeasurement', function () {
        var api;
        var transport;
        beforeEach(function () {
            var _a;
            _a = createAPI(), api = _a[0], transport = _a[1];
        });
        describe('Filtering', function () {
            it('filters the same measurement', function () {
                var measurement = {
                    type: 'custom',
                    values: {
                        a: 1,
                    },
                };
                api.pushMeasurement(measurement);
                expect(transport.items).toHaveLength(1);
                api.pushMeasurement(measurement);
                expect(transport.items).toHaveLength(1);
            });
            it('filters the same measurement with the same context', function () {
                var measurement = {
                    type: 'custom',
                    values: {
                        a: 1,
                    },
                };
                var context = { foo: 'bar' };
                api.pushMeasurement(measurement, { context: context });
                expect(transport.items).toHaveLength(1);
                api.pushMeasurement(measurement, { context: context });
                expect(transport.items).toHaveLength(1);
            });
            it("doesn't filter events with different context", function () {
                var measurement = {
                    type: 'custom',
                    values: {
                        a: 1,
                    },
                };
                api.pushMeasurement(measurement, { context: { foo: 'bar' } });
                expect(transport.items).toHaveLength(1);
                api.pushMeasurement(measurement, { context: { bar: 'baz' } });
                expect(transport.items).toHaveLength(2);
            });
            it("doesn't filter measurements with same type and partially same values", function () {
                var measurement1 = {
                    type: 'custom',
                    values: {
                        a: 1,
                    },
                };
                var measurement2 = __assign(__assign({}, measurement1), { values: __assign(__assign({}, measurement1.values), { b: 2 }) });
                api.pushMeasurement(measurement1);
                expect(transport.items).toHaveLength(1);
                api.pushMeasurement(measurement2);
                expect(transport.items).toHaveLength(2);
            });
            it("doesn't filter measurements with different type and same values", function () {
                var measurement1 = {
                    type: 'custom',
                    values: {
                        a: 1,
                    },
                };
                var measurement2 = __assign(__assign({}, measurement1), { type: 'web-vitals' });
                api.pushMeasurement(measurement1);
                expect(transport.items).toHaveLength(1);
                api.pushMeasurement(measurement2);
                expect(transport.items).toHaveLength(2);
            });
            it("filters a measurement and doesn't filter the next different one", function () {
                var measurement1 = {
                    type: 'custom',
                    values: {
                        a: 1,
                    },
                };
                var measurement2 = __assign(__assign({}, measurement1), { type: 'web-vitals' });
                api.pushMeasurement(measurement1);
                expect(transport.items).toHaveLength(1);
                api.pushMeasurement(measurement1);
                expect(transport.items).toHaveLength(1);
                api.pushMeasurement(measurement2);
                expect(transport.items).toHaveLength(2);
            });
            it("doesn't filter when dedupe is false", function () {
                var _a;
                _a = createAPI({ dedupe: false }), api = _a[0], transport = _a[1];
                var measurement = {
                    type: 'custom',
                    values: {
                        a: 1,
                    },
                };
                api.pushMeasurement(measurement);
                expect(transport.items).toHaveLength(1);
                api.pushMeasurement(measurement);
                expect(transport.items).toHaveLength(2);
            });
            it("doesn't filter when skipDedupe is true", function () {
                var measurement = {
                    type: 'custom',
                    values: {
                        a: 1,
                    },
                };
                api.pushMeasurement(measurement);
                expect(transport.items).toHaveLength(1);
                api.pushMeasurement(measurement, { skipDedupe: true });
                expect(transport.items).toHaveLength(2);
            });
            it('uses traceId and spanId from custom context', function () {
                var _a;
                var spanContext = {
                    traceId: 'my-trace-id',
                    spanId: 'my-span-id',
                };
                var measurement = {
                    type: 'custom',
                    values: {
                        a: 1,
                    },
                };
                api.pushMeasurement(measurement, { spanContext: spanContext });
                expect(transport.items).toHaveLength(1);
                expect(((_a = transport.items[0]) === null || _a === void 0 ? void 0 : _a.payload).trace).toStrictEqual({
                    trace_id: 'my-trace-id',
                    span_id: 'my-span-id',
                });
            });
        });
        it('Sets the timestamp to the provided custom timestamp', function () {
            var _a;
            api.pushMeasurement({
                type: 'custom',
                values: {
                    a: 1,
                },
            }, { timestampOverwriteMs: 123 });
            expect(transport.items).toHaveLength(1);
            expect(((_a = transport.items[0]) === null || _a === void 0 ? void 0 : _a.payload).timestamp).toBe('1970-01-01T00:00:00.123Z');
        });
        it('stringifies all values in the attributes object', function () {
            var _a;
            api.pushEvent('test', {
                // @ts-expect-error
                a: 1,
                b: 'foo',
                // @ts-expect-error
                c: true,
                // @ts-expect-error
                d: { e: 'bar' },
                // @ts-expect-error
                g: null,
                // @ts-expect-error
                h: undefined,
                // @ts-expect-error
                i: [1, 2, 3],
            });
            // @ts-expect-error
            expect((_a = transport.items[0]) === null || _a === void 0 ? void 0 : _a.payload.attributes).toStrictEqual({
                a: '1',
                b: 'foo',
                c: 'true',
                d: '{"e":"bar"}',
                g: 'null',
                h: 'undefined',
                i: '[1,2,3]',
            });
        });
    });
});
//# sourceMappingURL=initialize.test.js.map