"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeLogsAPI = void 0;
var transports_1 = require("../../transports");
var utils_1 = require("../../utils");
var date_1 = require("../../utils/date");
var const_1 = require("./const");
function initializeLogsAPI(_unpatchedConsole, internalLogger, config, metas, transports, tracesApi) {
    var _a;
    internalLogger.debug('Initializing logs API');
    var lastPayload = null;
    var logArgsSerializer = (_a = config.logArgsSerializer) !== null && _a !== void 0 ? _a : const_1.defaultLogArgsSerializer;
    var pushLog = function (args, _a) {
        var _b = _a === void 0 ? {} : _a, context = _b.context, level = _b.level, skipDedupe = _b.skipDedupe, spanContext = _b.spanContext, timestampOverwriteMs = _b.timestampOverwriteMs;
        try {
            var item = {
                type: transports_1.TransportItemType.LOG,
                payload: {
                    message: logArgsSerializer(args),
                    level: level !== null && level !== void 0 ? level : utils_1.defaultLogLevel,
                    context: (0, utils_1.stringifyObjectValues)(context),
                    timestamp: timestampOverwriteMs ? (0, date_1.timestampToIsoString)(timestampOverwriteMs) : (0, utils_1.getCurrentTimestamp)(),
                    trace: spanContext
                        ? {
                            trace_id: spanContext.traceId,
                            span_id: spanContext.spanId,
                        }
                        : tracesApi.getTraceContext(),
                },
                meta: metas.value,
            };
            var testingPayload = {
                message: item.payload.message,
                level: item.payload.level,
                context: item.payload.context,
            };
            if (!skipDedupe && config.dedupe && !(0, utils_1.isNull)(lastPayload) && (0, utils_1.deepEqual)(testingPayload, lastPayload)) {
                internalLogger.debug('Skipping log push because it is the same as the last one\n', item.payload);
                return;
            }
            lastPayload = testingPayload;
            internalLogger.debug('Pushing log\n', item);
            transports.execute(item);
        }
        catch (err) {
            internalLogger.error('Error pushing log\n', err);
        }
    };
    return {
        pushLog: pushLog,
    };
}
exports.initializeLogsAPI = initializeLogsAPI;
//# sourceMappingURL=initialize.js.map