import { BaseTransport } from '../transports';
import { VERSION } from '../version';
export class MockTransport extends BaseTransport {
    constructor(ignoreURLs = []) {
        super();
        this.ignoreURLs = ignoreURLs;
        this.name = '@grafana/transport-mock';
        this.version = VERSION;
        this.items = [];
    }
    send(items) {
        this.items.push(...items);
    }
    isBatched() {
        return true;
    }
    getIgnoreUrls() {
        return this.ignoreURLs;
    }
}
//# sourceMappingURL=mockTransport.js.map