"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const classnames_1 = __importDefault(require("classnames"));
const react_1 = __importDefault(require("react"));
/**
 * Base CSS class.
 * @private
 */
const baseClass = 'react-auto-scroll';
/**
 * Get a random string.
 * @private
 */
const getRandomString = () => Math.random()
    .toString(36)
    .slice(2, 15);
/**
 * AutoScroll component.
 */
exports.default = ({ checkBoxId = getRandomString(), children, className, height, optionText = 'Auto scroll', preventInteraction = false, scrollBehavior = 'smooth', showOption = true, }) => {
    const [autoScroll, setAutoScroll] = react_1.default.useState(true);
    const containerElement = react_1.default.useRef(null);
    const cls = classnames_1.default(baseClass, className, {
        [`${baseClass}--empty`]: react_1.default.Children.count(children) === 0,
        [`${baseClass}--prevent-interaction`]: preventInteraction,
        [`${baseClass}--showOption`]: showOption,
    });
    const style = {
        height,
        overflow: 'auto',
        scrollBehavior: 'auto',
        pointerEvents: preventInteraction ? 'none' : 'auto',
    };
    // Handle mousewheel events on the scroll container.
    const onWheel = () => {
        const { current } = containerElement;
        if (current && showOption) {
            setAutoScroll(current.scrollTop + current.offsetHeight === current.scrollHeight);
        }
    };
    // Apply the scroll behavior property after the first render,
    // so that the initial render is scrolled all the way to the bottom.
    react_1.default.useEffect(() => {
        setTimeout(() => {
            const { current } = containerElement;
            if (current) {
                current.style.scrollBehavior = scrollBehavior;
            }
        }, 0);
    }, [containerElement, scrollBehavior]);
    // When the children are updated, scroll the container
    // to the bottom.
    react_1.default.useEffect(() => {
        if (!autoScroll) {
            return;
        }
        const { current } = containerElement;
        if (current) {
            current.scrollTop = current.scrollHeight;
        }
    }, [children, containerElement, autoScroll]);
    return (react_1.default.createElement("div", { className: cls },
        react_1.default.createElement("div", { className: `${baseClass}__scroll-container`, onWheel: onWheel, ref: containerElement, style: style }, children),
        showOption && !preventInteraction && (react_1.default.createElement("div", { className: `${baseClass}__option` },
            react_1.default.createElement("input", { checked: autoScroll, className: `${baseClass}__option-input`, id: `${baseClass}__option-input-${checkBoxId}`, onChange: () => setAutoScroll(!autoScroll), type: "checkbox" }),
            react_1.default.createElement("label", { className: `${baseClass}__option-text`, htmlFor: `${baseClass}__option-input-${checkBoxId}` }, optionText)))));
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQXV0b1Njcm9sbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9BdXRvU2Nyb2xsLnRzeCJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDREQUFvQztBQUNwQyxrREFBMEI7QUFxQjFCOzs7R0FHRztBQUNILE1BQU0sU0FBUyxHQUFHLG1CQUFtQixDQUFDO0FBRXRDOzs7R0FHRztBQUNILE1BQU0sZUFBZSxHQUFHLEdBQUcsRUFBRSxDQUMzQixJQUFJLENBQUMsTUFBTSxFQUFFO0tBQ1YsUUFBUSxDQUFDLEVBQUUsQ0FBQztLQUNaLEtBQUssQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUM7QUFFbEI7O0dBRUc7QUFDSCxrQkFBZSxDQUFDLEVBQ2QsVUFBVSxHQUFHLGVBQWUsRUFBRSxFQUM5QixRQUFRLEVBQ1IsU0FBUyxFQUNULE1BQU0sRUFDTixVQUFVLEdBQUcsYUFBYSxFQUMxQixrQkFBa0IsR0FBRyxLQUFLLEVBQzFCLGNBQWMsR0FBRyxRQUFRLEVBQ3pCLFVBQVUsR0FBRyxJQUFJLEdBQ1gsRUFBRSxFQUFFO0lBQ1YsTUFBTSxDQUFDLFVBQVUsRUFBRSxhQUFhLENBQUMsR0FBRyxlQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxDQUFDO0lBQ3pELE1BQU0sZ0JBQWdCLEdBQUcsZUFBSyxDQUFDLE1BQU0sQ0FBaUIsSUFBSSxDQUFDLENBQUM7SUFDNUQsTUFBTSxHQUFHLEdBQUcsb0JBQVUsQ0FBQyxTQUFTLEVBQUUsU0FBUyxFQUFFO1FBQzNDLENBQUMsR0FBRyxTQUFTLFNBQVMsQ0FBQyxFQUFFLGVBQUssQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUM7UUFDN0QsQ0FBQyxHQUFHLFNBQVMsdUJBQXVCLENBQUMsRUFBRSxrQkFBa0I7UUFDekQsQ0FBQyxHQUFHLFNBQVMsY0FBYyxDQUFDLEVBQUUsVUFBVTtLQUN6QyxDQUFDLENBQUM7SUFDSCxNQUFNLEtBQUssR0FBRztRQUNaLE1BQU07UUFDTixRQUFRLEVBQUUsTUFBTTtRQUNoQixjQUFjLEVBQUUsTUFBTTtRQUN0QixhQUFhLEVBQUUsa0JBQWtCLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsTUFBTTtLQUMzQyxDQUFDO0lBRVgsb0RBQW9EO0lBQ3BELE1BQU0sT0FBTyxHQUFHLEdBQUcsRUFBRTtRQUNuQixNQUFNLEVBQUUsT0FBTyxFQUFFLEdBQUcsZ0JBQWdCLENBQUM7UUFFckMsSUFBSSxPQUFPLElBQUksVUFBVSxFQUFFO1lBQ3pCLGFBQWEsQ0FBQyxPQUFPLENBQUMsU0FBUyxHQUFHLE9BQU8sQ0FBQyxZQUFZLEtBQUssT0FBTyxDQUFDLFlBQVksQ0FBQyxDQUFDO1NBQ2xGO0lBQ0gsQ0FBQyxDQUFDO0lBRUYsNkRBQTZEO0lBQzdELG9FQUFvRTtJQUNwRSxlQUFLLENBQUMsU0FBUyxDQUFDLEdBQUcsRUFBRTtRQUNuQixVQUFVLENBQUMsR0FBRyxFQUFFO1lBQ2QsTUFBTSxFQUFFLE9BQU8sRUFBRSxHQUFHLGdCQUFnQixDQUFDO1lBRXJDLElBQUksT0FBTyxFQUFFO2dCQUNYLE9BQU8sQ0FBQyxLQUFLLENBQUMsY0FBYyxHQUFHLGNBQWMsQ0FBQzthQUMvQztRQUNILENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztJQUNSLENBQUMsRUFBRSxDQUFDLGdCQUFnQixFQUFFLGNBQWMsQ0FBQyxDQUFDLENBQUM7SUFFdkMsc0RBQXNEO0lBQ3RELGlCQUFpQjtJQUNqQixlQUFLLENBQUMsU0FBUyxDQUFDLEdBQUcsRUFBRTtRQUNuQixJQUFJLENBQUMsVUFBVSxFQUFFO1lBQ2YsT0FBTztTQUNSO1FBRUQsTUFBTSxFQUFFLE9BQU8sRUFBRSxHQUFHLGdCQUFnQixDQUFDO1FBRXJDLElBQUksT0FBTyxFQUFFO1lBQ1gsT0FBTyxDQUFDLFNBQVMsR0FBRyxPQUFPLENBQUMsWUFBWSxDQUFDO1NBQzFDO0lBQ0gsQ0FBQyxFQUFFLENBQUMsUUFBUSxFQUFFLGdCQUFnQixFQUFFLFVBQVUsQ0FBQyxDQUFDLENBQUM7SUFFN0MsT0FBTyxDQUNMLHVDQUFLLFNBQVMsRUFBRSxHQUFHO1FBQ2pCLHVDQUNFLFNBQVMsRUFBRSxHQUFHLFNBQVMsb0JBQW9CLEVBQzNDLE9BQU8sRUFBRSxPQUFPLEVBQ2hCLEdBQUcsRUFBRSxnQkFBZ0IsRUFDckIsS0FBSyxFQUFFLEtBQUssSUFFWCxRQUFRLENBQ0w7UUFFTCxVQUFVLElBQUksQ0FBQyxrQkFBa0IsSUFBSSxDQUNwQyx1Q0FBSyxTQUFTLEVBQUUsR0FBRyxTQUFTLFVBQVU7WUFDcEMseUNBQ0UsT0FBTyxFQUFFLFVBQVUsRUFDbkIsU0FBUyxFQUFFLEdBQUcsU0FBUyxnQkFBZ0IsRUFDdkMsRUFBRSxFQUFFLEdBQUcsU0FBUyxrQkFBa0IsVUFBVSxFQUFFLEVBQzlDLFFBQVEsRUFBRSxHQUFHLEVBQUUsQ0FBQyxhQUFhLENBQUMsQ0FBQyxVQUFVLENBQUMsRUFDMUMsSUFBSSxFQUFDLFVBQVUsR0FDZjtZQUVGLHlDQUNFLFNBQVMsRUFBRSxHQUFHLFNBQVMsZUFBZSxFQUN0QyxPQUFPLEVBQUUsR0FBRyxTQUFTLGtCQUFrQixVQUFVLEVBQUUsSUFFbEQsVUFBVSxDQUNMLENBQ0osQ0FDUCxDQUNHLENBQ1AsQ0FBQztBQUNKLENBQUMsQ0FBQyJ9