/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.PathTokenizer;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Reference;

public class Path
extends DataType
implements Cloneable {
    private Vector elements;
    private Project project;
    public static Path systemClasspath = new Path(null, System.getProperty("java.class.path"));

    public Path(Project project) {
        this.project = project;
        this.elements = new Vector();
    }

    public Path(Project p, String path) {
        this(p);
        this.createPathElement().setPath(path);
    }

    public void addExisting(Path source) {
        String[] list = source.list();
        int i = 0;
        while (i < list.length) {
            File f = null;
            f = this.project != null ? this.project.resolveFile(list[i]) : new File(list[i]);
            if (f.exists()) {
                this.setLocation(f);
            }
            ++i;
        }
    }

    public void addFileset(FileSet fs) throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.elements.addElement(fs);
        this.checked = false;
    }

    private static void addUnlessPresent(Vector v, String s) {
        if (v.indexOf(s) == -1) {
            v.addElement(s);
        }
    }

    public void append(Path other) {
        if (other == null) {
            return;
        }
        String[] l = other.list();
        int i = 0;
        while (i < l.length) {
            if (this.elements.indexOf(l[i]) == -1) {
                this.elements.addElement(l[i]);
            }
            ++i;
        }
    }

    public Object clone() {
        Path p = new Path(this.project);
        p.append(this);
        return p;
    }

    public Path createPath() throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        Path p = new Path(this.project);
        this.elements.addElement(p);
        this.checked = false;
        return p;
    }

    public PathElement createPathElement() throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        PathElement pe = new PathElement();
        this.elements.addElement(pe);
        return pe;
    }

    protected void dieOnCircularReference(Stack stk, Project p) throws BuildException {
        if (this.checked) {
            return;
        }
        Enumeration enumeration = this.elements.elements();
        while (enumeration.hasMoreElements()) {
            Object o = enumeration.nextElement();
            if (o instanceof Reference) {
                o = ((Reference)o).getReferencedObject(p);
            }
            if (!(o instanceof DataType)) continue;
            if (stk.contains(o)) {
                throw this.circularReference();
            }
            stk.push(o);
            ((DataType)o).dieOnCircularReference(stk, p);
            stk.pop();
        }
        this.checked = true;
    }

    public String[] list() {
        if (!this.checked) {
            Stack<Path> stk = new Stack<Path>();
            stk.push(this);
            this.dieOnCircularReference(stk, this.project);
        }
        Vector result = new Vector(2 * this.elements.size());
        int i = 0;
        while (i < this.elements.size()) {
            String[] parts;
            Reference r;
            Object o = this.elements.elementAt(i);
            if (o instanceof Reference && !((o = (r = (Reference)o).getReferencedObject(this.project)) instanceof Path)) {
                String msg = String.valueOf(r.getRefId()) + " doesn't denote a path";
                throw new BuildException(msg);
            }
            if (o instanceof String) {
                Path.addUnlessPresent(result, (String)o);
            } else if (o instanceof PathElement) {
                parts = ((PathElement)o).getParts();
                if (parts == null) {
                    throw new BuildException("You must either set location or path on <pathelement>");
                }
                int j = 0;
                while (j < parts.length) {
                    Path.addUnlessPresent(result, parts[j]);
                    ++j;
                }
            } else if (o instanceof Path) {
                parts = ((Path)o).list();
                int j = 0;
                while (j < parts.length) {
                    Path.addUnlessPresent(result, parts[j]);
                    ++j;
                }
            } else if (o instanceof FileSet) {
                FileSet fs = (FileSet)o;
                DirectoryScanner ds = fs.getDirectoryScanner(this.project);
                String[] s = ds.getIncludedFiles();
                File dir = fs.getDir(this.project);
                int j = 0;
                while (j < s.length) {
                    String canonicalPath;
                    File f = new File(dir, s[j]);
                    try {
                        canonicalPath = f.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        canonicalPath = f.getAbsolutePath();
                    }
                    Path.addUnlessPresent(result, Path.translateFile(canonicalPath));
                    ++j;
                }
            }
            ++i;
        }
        Object[] res = new String[result.size()];
        result.copyInto(res);
        return res;
    }

    private static String resolveFile(Project project, String relativeName) {
        if (project != null) {
            File f = project.resolveFile(relativeName);
            try {
                return f.getCanonicalPath();
            }
            catch (IOException e) {
                project.log(e.getMessage(), 1);
                return f.getAbsolutePath();
            }
        }
        return relativeName;
    }

    public void setLocation(File location) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createPathElement().setLocation(location);
    }

    public void setPath(String path) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createPathElement().setPath(path);
    }

    public void setRefid(Reference r) throws BuildException {
        if (!this.elements.isEmpty()) {
            throw this.tooManyAttributes();
        }
        this.elements.addElement(r);
        super.setRefid(r);
    }

    public int size() {
        return this.list().length;
    }

    public String toString() {
        String[] list = this.list();
        if (list.length == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer(list[0].toString());
        int i = 1;
        while (i < list.length) {
            result.append(File.pathSeparatorChar);
            result.append(list[i]);
            ++i;
        }
        return result.toString();
    }

    public static String translateFile(String source) {
        if (source == null) {
            return "";
        }
        StringBuffer result = new StringBuffer(source);
        int i = 0;
        while (i < result.length()) {
            Path.translateFileSep(result, i);
            ++i;
        }
        return result.toString();
    }

    protected static boolean translateFileSep(StringBuffer buffer, int pos) {
        if (buffer.charAt(pos) == '/' || buffer.charAt(pos) == '\\') {
            buffer.setCharAt(pos, File.separatorChar);
            return true;
        }
        return false;
    }

    public static String[] translatePath(Project project, String source) {
        Vector<String> result = new Vector<String>();
        if (source == null) {
            return new String[0];
        }
        PathTokenizer tok = new PathTokenizer(source);
        StringBuffer element = new StringBuffer();
        while (tok.hasMoreTokens()) {
            element.setLength(0);
            element.append(Path.resolveFile(project, tok.nextToken()));
            int i = 0;
            while (i < element.length()) {
                Path.translateFileSep(element, i);
                ++i;
            }
            result.addElement(element.toString());
        }
        Object[] res = new String[result.size()];
        result.copyInto(res);
        return res;
    }

    public class PathElement {
        private String[] parts;

        public String[] getParts() {
            return this.parts;
        }

        public void setLocation(File loc) {
            try {
                this.parts = new String[]{Path.translateFile(loc.getCanonicalPath())};
            }
            catch (IOException e) {
                if (Path.this.project != null) {
                    Path.this.project.log(e.getMessage(), 1);
                }
                this.parts = new String[]{Path.translateFile(loc.getAbsolutePath())};
            }
        }

        public void setPath(String path) {
            this.parts = Path.translatePath(Path.this.project, path);
        }
    }
}

