/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;

public class ExecTask
extends Task {
    private String os;
    private File out;
    private File dir;
    protected boolean failOnError = false;
    private Integer timeout = null;
    private Environment env = new Environment();
    protected Commandline cmdl = new Commandline();
    private FileOutputStream fos = null;

    public void addEnv(Environment.Variable var) {
        this.env.addVariable(var);
    }

    protected void checkConfiguration() throws BuildException {
        if (this.cmdl.getExecutable() == null) {
            throw new BuildException("no executable specified", this.location);
        }
    }

    public Commandline.Argument createArg() {
        return this.cmdl.createArgument();
    }

    protected ExecuteStreamHandler createHandler() throws BuildException {
        if (this.out != null) {
            try {
                this.fos = new FileOutputStream(this.out);
                this.log("Output redirected to " + this.out, 3);
                return new PumpStreamHandler(this.fos);
            }
            catch (FileNotFoundException fne) {
                throw new BuildException("Cannot write to " + this.out, fne, this.location);
            }
            catch (IOException ioe) {
                throw new BuildException("Cannot write to " + this.out, ioe, this.location);
            }
        }
        return new LogStreamHandler(this, 2, 1);
    }

    protected ExecuteWatchdog createWatchdog() throws BuildException {
        if (this.timeout == null) {
            return null;
        }
        return new ExecuteWatchdog(this.timeout);
    }

    public void execute() throws BuildException {
        this.checkConfiguration();
        if (this.isValidOs()) {
            this.runExec(this.prepareExec());
        }
    }

    protected boolean isValidOs() {
        String myos = System.getProperty("os.name");
        this.log("Myos = " + myos, 3);
        if (this.os != null && this.os.indexOf(myos) < 0) {
            this.log("Not found in " + this.os, 3);
            return false;
        }
        return true;
    }

    protected void logFlush() {
        try {
            if (this.fos != null) {
                this.fos.close();
            }
        }
        catch (IOException iOException) {}
    }

    protected Execute prepareExec() throws BuildException {
        if (this.dir == null) {
            this.dir = this.project.getBaseDir();
        }
        this.log(this.cmdl.toString(), 3);
        Execute exe = new Execute(this.createHandler(), this.createWatchdog());
        exe.setAntRun(this.project);
        exe.setWorkingDirectory(this.dir);
        String[] environment = this.env.getVariables();
        if (environment != null) {
            int i = 0;
            while (i < environment.length) {
                this.log("Setting environment variable: " + environment[i], 3);
                ++i;
            }
        }
        exe.setEnvironment(environment);
        return exe;
    }

    protected void runExec(Execute exe) throws BuildException {
        int err = -1;
        try {
            try {
                exe.setCommandline(this.cmdl.getCommandline());
                err = exe.execute();
                if (err != 0) {
                    if (this.failOnError) {
                        throw new BuildException("Exec returned: " + err, this.location);
                    }
                    this.log("Result: " + err, 0);
                }
            }
            catch (IOException e) {
                throw new BuildException("Execute failed: " + e, e, this.location);
            }
            Object var4_4 = null;
            this.logFlush();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.logFlush();
            throw throwable;
        }
    }

    public void setCommand(Commandline cmdl) {
        this.log("The command attribute is deprecated. Please use the executable attribute and nested arg elements.", 1);
        this.cmdl = cmdl;
    }

    public void setDir(File d) {
        this.dir = d;
    }

    public void setExecutable(String value) {
        this.cmdl.setExecutable(value);
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public void setOutput(File out) {
        this.out = out;
    }

    public void setTimeout(Integer value) {
        this.timeout = value;
    }
}

