/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.ExecuteOn;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;

public class Chmod
extends ExecuteOn {
    private FileSet defaultSet = new FileSet();
    private boolean havePerm = false;

    public Chmod() {
        super.setExecutable("chmod");
        super.setParallel(true);
    }

    protected void checkConfiguration() {
        if (!this.havePerm) {
            throw new BuildException("Required attribute perm not set in chmod", this.location);
        }
        if (this.defaultSet.getDir(this.project) != null) {
            this.addFileset(this.defaultSet);
        }
        super.checkConfiguration();
    }

    public PatternSet.NameEntry createExclude() {
        return this.defaultSet.createExclude();
    }

    public PatternSet.NameEntry createInclude() {
        return this.defaultSet.createInclude();
    }

    public PatternSet createPatternSet() {
        return this.defaultSet.createPatternSet();
    }

    protected boolean isValidOs() {
        return System.getProperty("path.separator").equals(":") && (!System.getProperty("os.name").startsWith("Mac") || System.getProperty("os.name").endsWith("X")) && super.isValidOs();
    }

    public void setCommand(String e) {
        throw new BuildException(String.valueOf(this.taskType) + " doesn't support the command attribute", this.location);
    }

    public void setDefaultexcludes(boolean useDefaultExcludes) {
        this.defaultSet.setDefaultexcludes(useDefaultExcludes);
    }

    public void setDir(File src) {
        this.defaultSet.setDir(src);
    }

    public void setExcludes(String excludes) {
        this.defaultSet.setExcludes(excludes);
    }

    public void setExecutable(String e) {
        throw new BuildException(String.valueOf(this.taskType) + " doesn't support the executable attribute", this.location);
    }

    public void setFile(File src) {
        FileSet fs = new FileSet();
        fs.setDir(new File(src.getParent()));
        fs.createInclude().setName(src.getName());
        this.addFileset(fs);
    }

    public void setIncludes(String includes) {
        this.defaultSet.setIncludes(includes);
    }

    public void setPerm(String perm) {
        this.createArg().setValue(perm);
        this.havePerm = true;
    }
}

