
using System;

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE

namespace Saxon.Api 
{


/// <summary>
/// Feature defines a set of constants, representing the details of Saxon configuration
/// options which can be supplied to the Saxon method <c>Processor.SetProperty()</c>,
/// and to other interfaces.
/// </summary>

public class Feature<T> {
    
    private net.sf.saxon.lib.Feature jfeature;

    private Feature(String name) {
        jfeature = net.sf.saxon.lib.Feature.byName(name);
    }
    
    private Feature(net.sf.saxon.lib.Feature jf) {
        this.jfeature = jf;
    }
    
    /// <summary>
    /// Get the <c>Feature</c> object by string value name
    /// </summary>
    /// <param name="name">The feature name</param>
    /// <returns>The <c>Feature</c> object</returns>

    public static Feature<T> byName(String name) {
        return new Feature<T>(name);
    }
    
    /// <summary>
	/// The underlying <c>net.sf.saxon.lib.Feature</c> object in the Java implementation
    /// </summary>
    /// <remarks>
    /// <para>This property provides access to the internal Java <c>Feature</c> object in the 
    /// Saxon engine that is wrapped in the .NET API.</para> 
	/// <para>Information about the returned <see cref="net.sf.saxon.lib.Feature"/> object 
	/// is included in the Saxon JavaDoc docmentation.
    /// </para>
    /// </remarks>
        
	public net.sf.saxon.lib.Feature JFeature
    {
        get { return jfeature; }
    }



    /// <summary>ALLOW_EXTERNAL_FUNCTIONS determines whether calls to reflexive external functions are
    ///                allowed.
    /// </summary>
    /// <remarks>
    ///            <para>More specifically, if set to <b>false</b> it disallows all of the
    ///                following:</para>
    ///            <list>
    ///                <item>Calls to reflexive Java extension functions</item>
    ///                <item>Use of the XSLT <code>system-property()</code> function to access Java system
    ///                    properties</item>
    ///                <item>Use of a URI in the <code>href</code> attribute of an <code>xsl:result-document</code> instruction</item>
    ///                <item>Calls to XSLT extension instructions</item>
    ///            </list>
    ///            <para>The default value is <b>true</b>. The setting <b>false</b> is recommended in an
    ///                environment where untrusted stylesheets may be executed.</para>
    ///            <para>This option does not disable use of the <code>doc()</code> function or similar
    ///                functions to access the filestore of the machine where the transformation or query
    ///                is running. That should be done using a user-supplied <code>URIResolver</code>.</para>
    ///            <para>Note that integrated extension functions are trusted; calls to such functions are
    ///                allowed even if this configuration option is false. In cases where an integrated
    ///                extension function is used to load and execute untrusted code, it should check this
    ///                configuration option before doing so.</para>
    ///            <para>If the value of the property is false, then it will also be set to false on any new
    ///            Configuration created using the <code>fn:transform()</code> function.</para>
    ///        
    /// </remarks>

    public static Feature<bool> ALLOW_EXTERNAL_FUNCTIONS = new Feature<bool>(
            net.sf.saxon.lib.Feature.ALLOW_EXTERNAL_FUNCTIONS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>ALLOW_MULTITHREADING determines whether multi-threading is allowed.
    /// </summary>
    /// <remarks>
    ///            <para>If true (the default), the presence of the attribute <code>saxon:threads="N"</code>
    ///                on an <code>xsl:for-each</code> instruction, when running under Saxon-EE, causes
    ///                multi-threaded execution. If set to false, the value of the
    ///                    <code>saxon:threads</code> argument is ignored.</para>
    ///            <para>Setting the value to false also disables asynchronous processing of
    ///                    <code>xsl:result-document</code> instructions.</para>
    ///            <para>The default value is true if Saxon-EE is in use, false otherwise.</para>
    ///        
    /// </remarks>

    public static Feature<bool> ALLOW_MULTITHREADING = new Feature<bool>(
            net.sf.saxon.lib.Feature.ALLOW_MULTITHREADING);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>ALLOW_OLD_JAVA_URI_FORMAT determines whether extension function calls to
    ///                dynamically-loaded Java extension functions may use the URI format supported in
    ///                older Saxon releases.
    /// </summary>
    /// <remarks>
    ///            <para>If the value is false (the default), the only URI format accepted is (for example)
    ///                "java:java.util.Date" - that is, a URI consisting of the string "java:" followed by
    ///                the Java qualified class name of the class containing the implementation of the
    ///                extension function.</para>
    ///            <para>If the value is true, then in addition to this format, the following are accepted:
    ///                (a) the Java class name on its own ("java.util.Date"), and (b) any URI in which the
    ///                Java class name follows the last "/" character (for example
    ///                "http://my.com/extensions/java.util.Date"). This last format was originally provided
    ///                for compatibility with xt and xalan, but it causes problems because it leads to
    ///                unnecessary attempts to load spurious classes when the user did not intend the URI
    ///                to represent a dynamically-loaded Java class.</para>
    ///        
    /// </remarks>

    public static Feature<bool> ALLOW_OLD_JAVA_URI_FORMAT = new Feature<bool>(
            net.sf.saxon.lib.Feature.ALLOW_OLD_JAVA_URI_FORMAT);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This flag must be set to enable use of extensions to XPath, XQuery and XSLT
    ///                syntax that go beyond what is allowed by the extensibility mechanisms in the spec.
    ///                In some cases these extensions are experimental and may not be carried forward to future
    ///            Saxon releases.
    /// </summary>
    /// <remarks>
    ///            <para>Syntax extensions in Saxon 10 include the use of type aliases (<code>type(...)</code> where
    ///                an item type is expected, and <code>declare type NAME = item-type</code> in the XQuery Prolog); 
    ///                and simple inline functions (for example <code>.{. + 1}</code>).</para>
    ///        
    /// </remarks>

    public static Feature<bool> ALLOW_SYNTAX_EXTENSIONS = new Feature<bool>(
            net.sf.saxon.lib.Feature.ALLOW_SYNTAX_EXTENSIONS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>ASSERTIONS_CAN_SEE_COMMENTS determines whether comment and processing instructions in
    ///                a document being validated are visible to assertions in an XSD 1.1 schema.
    /// </summary>
    /// <remarks>
    ///            <para>If the value is false (the default), comments and processing instructions are
    ///                stripped from the view of the document that is made visible to the XPath expression
    ///                that implements the assertion. If this creates adjacent text nodes, they are
    ///                collapsed into a single text node.</para>
    ///            <para>If the value is true, then comments and processing instructions are visible to the
    ///                XPath assertion.</para>
    ///        
    /// </remarks>

    public static Feature<bool> ASSERTIONS_CAN_SEE_COMMENTS = new Feature<bool>(
            net.sf.saxon.lib.Feature.ASSERTIONS_CAN_SEE_COMMENTS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>The supplied <code>CollationURIResolver</code> is used to process any collation URIs
    ///                found in the query or stylesheet, returning an object of class
    ///                    <see cref="net.sf.saxon.lib.StringCollator" /> that implements the requested
    ///                collation.
    /// </summary>

    public static Feature<net.sf.saxon.lib.CollationURIResolver> COLLATION_URI_RESOLVER = new Feature<net.sf.saxon.lib.CollationURIResolver>(
            net.sf.saxon.lib.Feature.COLLATION_URI_RESOLVER);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>The supplied class is instantiated and the resulting instance is used as the value of
    ///                the <see cref="COLLATION_URI_RESOLVER" /> property.
    /// </summary>

    public static Feature<String> COLLATION_URI_RESOLVER_CLASS = new Feature<String>(
            net.sf.saxon.lib.Feature.COLLATION_URI_RESOLVER_CLASS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>The supplied <code>CollectionFinder</code> is used to retrieve a <see cref="net.sf.saxon.lib.ResourceCollection" /> object given by any URI defined in
    ///                calls to the <code>collection()</code> or the <code>uri-collection()</code> function.
    /// </summary>
    /// <remarks>
    ///            <para>If the argument is not specified then a default <code>ResourceCollection</code> should be handled.
    ///                <code>CollectionFinder</code> returns a <see cref="net.sf.saxon.lib.ResourceCollection" /> which is used to map the URI of collection into a
    ///                sequence of <see cref="net.sf.saxon.lib.Resource" /> objects
    ///                (which are then resolved in the same way as URIs passed to the <code>doc()</code>
    ///                function), or it may return an item (typically a node but can handle JSON documents).</para>
    ///        
    /// </remarks>

    public static Feature<net.sf.saxon.lib.CollectionFinder> COLLECTION_FINDER = new Feature<net.sf.saxon.lib.CollectionFinder>(
            net.sf.saxon.lib.Feature.COLLECTION_FINDER);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>The supplied class is instantiated and the resulting instance is used as the value of
    ///                the <see cref="COLLECTION_FINDER" /> property.
    /// </summary>

    public static Feature<String> COLLECTION_FINDER_CLASS = new Feature<String>(
            net.sf.saxon.lib.Feature.COLLECTION_FINDER_CLASS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>If run-time tracing of stylesheet or query execution is required, then the code must
    ///                be compiled with tracing enabled.
    /// </summary>
    /// <remarks>
    ///            <para>Default is false. This option causes code to be
    ///                compiled that makes calls to a <see cref="net.sf.saxon.lib.TraceListener" />, but this
    ///                has no effect unless a <code>TraceListener</code> is registered at execution
    ///                time.</para>
    ///        
    /// </remarks>

    public static Feature<bool> COMPILE_WITH_TRACING = new Feature<bool>(
            net.sf.saxon.lib.Feature.COMPILE_WITH_TRACING);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This attribute cannot be set on the <see cref="net.sf.saxon.Configuration" /> itself,
    ///                but it can be set on various JAXP factory objects such as a
    ///                <code>TransformerFactory</code> or <code>DocumentBuilderFactory</code>, to
    ///                ensure that several such factories use the same <code>Configuration</code>.
    /// </summary>
    /// <remarks>
    ///            <para>Note that other configuration options are held in the <code>Configuration</code> object,
    ///                so setting this attribute will cancel all others that have been set. Also, if two
    ///                factories share the same <code>Configuration</code>, then setting an attribute on
    ///                one affects all the others.</para>
    ///        
    /// </remarks>

    public static Feature<net.sf.saxon.Configuration> CONFIGURATION = new Feature<net.sf.saxon.Configuration>(
            net.sf.saxon.lib.Feature.CONFIGURATION);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Defines a configuration file to be applied to the configuration.
    /// </summary>
    /// <remarks>
    ///            <para>This attribute cannot be set on the <see cref="net.sf.saxon.Configuration" /> itself, but it can be
    ///                set on various JAXP factory objects such as a <code>TransformerFactory</code> or
    ///                    <code>DocumentBuilderFactory</code>. It is particularly useful when running
    ///                transformations via the Ant xslt task, where it can be set as follows to define all
    ///                configuration settings: </para>
    ///            <para><code>&lt;factory name="net.sf.saxon.TransformerFactoryImpl"&gt; &lt;attribute
    ///                    name="http://saxon.sf.net/feature/configuration-file"
    ///                    value="c:/saxon/config.xml"/&gt; &lt;/factory&gt;</code>
    ///            </para>
    ///        
    /// </remarks>

    public static Feature<String> CONFIGURATION_FILE = new Feature<String>(
            net.sf.saxon.lib.Feature.CONFIGURATION_FILE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This option is set to indicate that bytecode generation should be run in debugging
    ///                mode; it injects diagnostic tracing calls into the generated bytecode. This should
    ///                be used only if requested by Saxonica support to diagnose a problem related to
    ///                bytecode generation.
    /// </summary>

    public static Feature<bool> DEBUG_BYTE_CODE = new Feature<bool>(
            net.sf.saxon.lib.Feature.DEBUG_BYTE_CODE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This option is relevant only if <code>DISPLAY_BYTE_CODE</code> is set to true. It
    ///                defines a directory to which files containing bytecode in human-readable form will
    ///                be written. There will be one such file for each generated class, with a filename
    ///                designed to give some kind of clue as to its relationship to the source code.
    /// </summary>
    /// <remarks>
    ///            <para>The default value is the directory <code>saxonByteCode</code> within the current
    ///                working directory.</para>
    ///            <para>The named directory is created if it does not already exist.</para>
    ///            <para>Because the generation of class names involves random numbers, files will tend to
    ///                accumulate in the supplied directory, even when the same source code is compiled
    ///                repeatedly.</para>
    ///        
    /// </remarks>

    public static Feature<String> DEBUG_BYTE_CODE_DIR = new Feature<String>(
            net.sf.saxon.lib.Feature.DEBUG_BYTE_CODE_DIR);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This option determines the collation that is used for comparing strings when no
    ///                explicit collation is requested. It is not necessary for this collation to exist (or
    ///                to have been registered) when setting this option; it only needs to exist by the
    ///                time it is used.
    /// </summary>
    /// <remarks>
    ///            <para>In XSLT it is possible to override this setting using the
    ///                    <code>[xsl:]default-collation</code> attribute on any stylesheet element. In
    ///                XQuery, it can be overridden using the <code>declare default collation</code>
    ///                declaration in the query prolog, or via a setter method in class
    ///                    <see cref="net.sf.saxon.query.StaticQueryContext" />.</para>
    ///            <para>If no value is specified, the Unicode codepoint collation is used.</para>
    ///        
    /// </remarks>

    public static Feature<String> DEFAULT_COLLATION = new Feature<String>(
            net.sf.saxon.lib.Feature.DEFAULT_COLLATION);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This determines the collection that is used when the <code>fn:collection()</code>
    ///                function is called with no arguments; the effect is the same as if it were called
    ///                passing the URI that is the value of this configuration property.
    /// </summary>

    public static Feature<String> DEFAULT_COLLECTION = new Feature<String>(
            net.sf.saxon.lib.Feature.DEFAULT_COLLECTION);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This determines the country that is used by <code>format-date()</code> and similar
    ///                functions if no country code is supplied explicitly. If no value is given for this
    ///                property, the default is taken from the Java Locale, which in turn typically depends
    ///                on settings for the current user in the operating system.
    /// </summary>

    public static Feature<String> DEFAULT_COUNTRY = new Feature<String>(
            net.sf.saxon.lib.Feature.DEFAULT_COUNTRY);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This option determines the language that is used by <code>format-date()</code>,
    ///                    <code>xsl:number</code> and similar constructs if no language code is supplied
    ///                explicitly. If no value is given for this property, the default is taken from the
    ///                Java Locale, which in turn typically depends on settings for the current user in the
    ///                operating system.
    /// </summary>

    public static Feature<String> DEFAULT_LANGUAGE = new Feature<String>(
            net.sf.saxon.lib.Feature.DEFAULT_LANGUAGE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Determines which regular expression engine should be used for evaluating regular expressions occuring in constructs
    ///            such as <code>fn:matches()</code>, <code>fn:replace</code>, and <code>xsl:analyze-string</code>, and also
    ///            in the pattern facet of a schema.
    /// </summary>
    /// <remarks>
    ///            <para>On the Java platform the permitted values are "S" (default), and "J". The value "J" selects the regex engine
    ///            provided in the JDK in preference to the Saxon regular expression engine. This means that regular expressions must
    ///            follow the Java syntax and semantics rather than the XPath syntax and semantics.</para>
    ///            <para>On the .NET platform the permitted values are "S" (default), "J", and "N". The value "J" selects the regex engine
    ///                provided in the IKVMC run-time, which is derived from OpenJDK. The value "N" selects the regex engine provided
    ///            in the Microsoft .NET platform. In each case, the regular expression must follow the syntax and semantics of the selected
    ///            regex engine.</para>
    ///            <para>The choice of regular expression may be overridden in a particular invocation by appending the value ";s",
    ///            ";j", or ";n" to the flags argument of the relevant call. (This does not apply to XSD patterns, where no flags argument is available)</para>
    ///            <para>Use of this feature is not conformant with W3C specifications. Use of the setting "N", however, can be useful
    ///            when schemas have been written with the Microsoft schema processor in mind, since this uses the Microsoft regular
    ///            expression dialect rather than the W3C dialect.</para>
    ///        
    /// </remarks>

    public static Feature<String> DEFAULT_REGEX_ENGINE = new Feature<String>(
            net.sf.saxon.lib.Feature.DEFAULT_REGEX_ENGINE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This option disables the <code>xsl:evaluate</code> instruction.
    /// </summary>
    /// <remarks>
    ///            <para>If set at stylesheet compile time, the feature is statically disabled. If set at 
    ///                run-time it is dynamically disabled. (These terms are defined in the XSLT 3.0 spec.)
    ///                By default, the feature is enabled.</para>
    ///            <para><i>The XSLT 3.0 specification requires conformant processors to provide a way of
    ///                disabling <code>xsl:evaluate</code>. This shouldn't be taken as meaning that 
    ///                <code>xsl:evaluate</code> poses particular security risks. The main reason for disabling it
    ///                is if you want to carry out static analysis or inspection of stylesheet code to see what 
    ///                features it uses. But if you're doing such inspection, it's not difficult to check that
    ///                <code>xsl:evaluate</code> is only being used to execute trusted code. Note also that
    ///                <code>fn:transform()</code> can similarly be used to execute dynamically-constructed code,
    ///                and there is no switch to disable that function.</i></para>
    ///        
    /// </remarks>

    public static Feature<bool> DISABLE_XSL_EVALUATE = new Feature<bool>(
            net.sf.saxon.lib.Feature.DISABLE_XSL_EVALUATE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This option is set to indicate that bytecode generation should be run in display
    ///                mode. The effect is to output files (one per class) containing a human-readable
    ///                print of the generated bytecode. The files are placed in the directory identified by
    ///                the <code>DEBUG_BYTE_CODE_DIR</code> option.
    /// </summary>

    public static Feature<bool> DISPLAY_BYTE_CODE = new Feature<bool>(
            net.sf.saxon.lib.Feature.DISPLAY_BYTE_CODE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>If true, the XML parser is requested to perform validation of source documents
    ///                against their DTD. Default is false.
    /// </summary>
    /// <remarks>
    ///            <para>This option establishes a default for use whenever source documents (not stylesheets
    ///                or schema documents) are parsed. The option can be overridden for individual
    ///                documents by setting the <see cref="net.sf.saxon.lib.ParseOptions" /> for that
    ///                individual document, for example from a <code>URIResolver</code>.</para>
    ///        
    /// </remarks>

    public static Feature<bool> DTD_VALIDATION = new Feature<bool>(
            net.sf.saxon.lib.Feature.DTD_VALIDATION);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This option determines whether DTD validation failures should be treated as
    ///                recoverable. If the option is set, a validation failure is reported as a warning
    ///                rather than an error. The default is false.
    /// </summary>
    /// <remarks>
    ///            <para>This option establishes a default for use whenever source documents (not stylesheets
    ///                or schema documents) are parsed. The option can be overridden for individual
    ///                documents by setting the <see cref="net.sf.saxon.lib.ParseOptions" /> for that
    ///                individual document, for example from a <code>URIResolver</code>.</para>
    ///        
    /// </remarks>

    public static Feature<bool> DTD_VALIDATION_RECOVERABLE = new Feature<bool>(
            net.sf.saxon.lib.Feature.DTD_VALIDATION_RECOVERABLE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Forces Saxon to do eager evaluation of expressions in contexts where normally it would do lazy evaluation,
    ///                for example when evaluating variables and function results. This can make for easier debugging.
    /// </summary>
    /// <remarks>
    ///            <para>Note that this only applies to situations where Saxon would normally save a <code>Closure</code>
    ///            object as the result of an expression. It does not prevent Saxon from using pipelined evaluation of
    ///            intermediate expressions using iterators.</para>
    ///        
    /// </remarks>

    public static Feature<bool> EAGER_EVALUATION = new Feature<bool>(
            net.sf.saxon.lib.Feature.EAGER_EVALUATION);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>The supplied class is instantiated and the resulting <code>EntityResolver</code> is
    ///                used whenever Saxon itself creates an <code>XMLReader</code> for parsing source
    ///                documents. It is not used with a user-supplied <code>XMLReader</code>.
    /// </summary>
    /// <remarks>
    ///            <para>The default value is <see cref="net.sf.saxon.lib.StandardEntityResolver" />. This is an entity
    ///                resolver that recognizes the names of many standard W3C DTDs and external entity
    ///                files, and resolves them against local copies issued with the Saxon software, to
    ///                avoid the need to fetch them from the web.</para>
    ///            <para>The property can be set to a zero-length string, in which case no
    ///                    <code>EntityResolver</code> will be used.</para>
    ///
    ///        
    /// </remarks>

    public static Feature<String> ENTITY_RESOLVER_CLASS = new Feature<String>(
            net.sf.saxon.lib.Feature.ENTITY_RESOLVER_CLASS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Setting the <code>ENVIRONMENT_VARIABLE_RESOLVER</code> causes the supplied object to
    ///                be registered as the environment variable resolver for the
    ///                    <code>Configuration</code>. The setting is global: it affects all queries and
    ///                transformations using this configuration.
    /// </summary>
    /// <remarks>
    ///            <para>The environment variable resolver is used when the XPath functions
    ///                    <code>available-environment-variables()</code> or
    ///                    <code>environment-variable()</code> are called. Saxon essentially delegates the
    ///                evaluation of the function to the external resolver.</para>
    ///        
    /// </remarks>

    public static Feature<net.sf.saxon.lib.EnvironmentVariableResolver> ENVIRONMENT_VARIABLE_RESOLVER = new Feature<net.sf.saxon.lib.EnvironmentVariableResolver>(
            net.sf.saxon.lib.Feature.ENVIRONMENT_VARIABLE_RESOLVER);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Setting <code>ENVIRONMENT_VARIABLE_RESOLVER_CLASS</code> causes an instance of the
    ///                supplied class to be created, and registered as the environment variable resolver
    ///                for the <code>Configuration</code>. The setting is global: it affects all queries
    ///                and transformations using this configuration.
    /// </summary>
    /// <remarks>
    ///            <para>The environment variable resolver is used when the XPath functions
    ///                    <code>available-environment-variables()</code> or
    ///                    <code>environment-variable()</code> are called. Saxon essentially delegates the
    ///                evaluation of the function to the external resolver.</para>
    ///        
    /// </remarks>

    public static Feature<String> ENVIRONMENT_VARIABLE_RESOLVER_CLASS = new Feature<String>(
            net.sf.saxon.lib.Feature.ENVIRONMENT_VARIABLE_RESOLVER_CLASS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary><code>ERROR_LISTENER_CLASS</code> is the name of the class used to implement the JAXP
    ///                <code>ErrorListener</code>. This is used both at compile time and at run-time.
    /// </summary>
    /// <remarks>
    ///            <para>Currently if this option is specified, the class is instantiated, and the same
    ///                instance is used for all processes running under this configuration. This may change
    ///                in future so that a new instance is created for each compilation or evaluation.</para>
    ///            <para>Finer control can be obtained by setting the <code>ErrorListener</code> for a
    ///                specific XSLT or XQuery compilation or evaluation.</para>
    ///        
    /// </remarks>

    public static Feature<String> ERROR_LISTENER_CLASS = new Feature<String>(
            net.sf.saxon.lib.Feature.ERROR_LISTENER_CLASS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary><code>EXPAND_ATTRIBUTE_DEFAULTS</code> determines whether fixed and default values
    ///                defined in a schema or DTD will be expanded (both on input and on output documents,
    ///                if validation is requested).
    /// </summary>
    /// <remarks>
    ///            <para>By default (and for conformance with the specification)
    ///                validation against a DTD or schema will cause default values defined in the schema
    ///                or DTD to be inserted into the document. Setting this feature to false suppresses
    ///                this behavior. In the case of DTD-defined defaults this only works if the XML parser
    ///                reports whether each attribute was specified in the source or generated by expanding
    ///                a default value. Not all XML parsers report this information.</para>
    ///        
    /// </remarks>

    public static Feature<bool> EXPAND_ATTRIBUTE_DEFAULTS = new Feature<bool>(
            net.sf.saxon.lib.Feature.EXPAND_ATTRIBUTE_DEFAULTS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary><code>EXPATH_FILE_DELETE_TEMPORARY_FILES</code> determines whether temporary files
    ///                and directories created in the EXPath File module should be automatically deleted on
    ///                closure of the JVM.
    /// </summary>
    /// <remarks>
    ///            <para>The default value is <b>false</b>, to align with the standard. The setting
    ///                    <b>false</b> is recommended when external 'sweep-up' features aren't
    ///                available.</para>
    ///        
    /// </remarks>

    public static Feature<bool> EXPATH_FILE_DELETE_TEMPORARY_FILES = new Feature<bool>(
            net.sf.saxon.lib.Feature.EXPATH_FILE_DELETE_TEMPORARY_FILES);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>By default, Saxon-EE attempts to generate Java bytecode for evaluation of parts of a
    ///                query or stylesheet that are amenable to such treatment. Setting this option to
    ///                false disables this.
    /// </summary>
    /// <remarks>
    ///            <para>For backwards compatibility, this option when used at the level of <code>Configuration.setConfigurationProperty()</code>
    ///            can also be used to set the value of <code>THRESHOLD_FOR_HOTSPOT_BYTECODE</code>. If the value on that interface is supplied
    ///            as an integer (or a string in the form of an integer) then a value of 1 or more sets the threshold for hotspot detection, while
    ///            a value of zero or less disables bytecode generation entirely. On other interfaces the value of the property must be a boolean.</para>
    ///        
    /// </remarks>

    public static Feature<bool> GENERATE_BYTE_CODE = new Feature<bool>(
            net.sf.saxon.lib.Feature.GENERATE_BYTE_CODE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>If this option is set to true, then when a <code>SAXSource</code> is supplied as the
    ///                input to an XSLT transformation, Saxon will ignore the <code>XMLReader</code>
    ///                supplied in the <code>SAXSource</code> (in fact, it will modify the supplied
    ///                    <code>SAXSource</code> setting the <code>XMLReader</code> to null) and use an
    ///                    <code>XMLReader</code> created using the value of the
    ///                    <code>SOURCE_PARSER_CLASS</code> option in preference.
    /// </summary>
    /// <remarks>
    ///            <para>The defining use case for this feature is when calling a Saxon transformation from
    ///                Ant. Ant always supplies the source document as a <code>SAXSource</code> using a
    ///                parser instantiated using the default JAXP mechanism. A different parser set using
    ///                the property <code>http://saxon.sf.net/feature/sourceParserClass</code> will
    ///                normally be ignored in this case; setting the <code>ignoreSAXSourceParser</code>
    ///                option overrides this. This is especially useful if the input format is not in fact
    ///                XML, but some other format converted to a SAX event stream by means of a custom
    ///                parser.</para>
    ///        
    /// </remarks>

    public static Feature<bool> IGNORE_SAX_SOURCE_PARSER = new Feature<bool>(
            net.sf.saxon.lib.Feature.IGNORE_SAX_SOURCE_PARSER);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary><code>IMPLICIT_SCHEMA_IMPORTS</code> allows reference to schema components without an <code>xs:import</code> for the relevant namespace being
    ///                present in the containing schema document. 
    /// </summary>
    /// <remarks>
    ///            <para>This only works if the referenced components are already present among the schema components known to the configuration, perhaps
    ///            because they were part of a different schema, or because there are cyclic references within a schema.</para>
    ///            <para>This option is not conformant with the XSD specification, which requires explicit <code>xs:import</code> declarations
    ///            for all cross-namespace component references. However, some "industry-standard" schemas are known to violate this rule,
    ///            and setting this option allows such schemas to be loaded by Saxon.</para>
    ///        
    /// </remarks>

    public static Feature<bool> IMPLICIT_SCHEMA_IMPORTS = new Feature<bool>(
            net.sf.saxon.lib.Feature.IMPLICIT_SCHEMA_IMPORTS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary><code>LAZY_CONSTRUCTION_MODE</code> determines whether temporary trees are
    ///                constructed lazily. The default setting is false; there are a few situations (but
    ///                not many) where setting this to true can give a performance benefit (especially a
    ///                memory saving).
    /// </summary>
    /// <remarks>
    ///            <para>The option is most likely to be effective when executing XQuery in "pull" mode, that
    ///                is, when the client calls the query processor to deliver the result as a stream of
    ///                nodes, rather than running the query and piping the results into a serializer.</para>
    ///        
    /// </remarks>

    public static Feature<bool> LAZY_CONSTRUCTION_MODE = new Feature<bool>(
            net.sf.saxon.lib.Feature.LAZY_CONSTRUCTION_MODE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary><code>LICENSE_FILE_LOCATION</code> holds the filename in which the Saxon license file
    ///                is held.
    /// </summary>
    /// <remarks>
    ///            <para>This is the full file name, for example <code>c:/saxon/license/license.lic</code>. 
    ///                Setting this property causes Saxon to
    ///                immediately read the specified file and register the license data, assuming it can
    ///                be found at this location. The property is not recognized for reading, and it is not
    ///                recognized for writing except in Saxon-PE and Saxon-EE.</para>
    ///        
    /// </remarks>

    public static Feature<String> LICENSE_FILE_LOCATION = new Feature<String>(
            net.sf.saxon.lib.Feature.LICENSE_FILE_LOCATION);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Default is false. If true, line and column number information is retained for all
    ///                source documents. This information is accessible using the
    ///                    <code>saxon:line-number()</code> and <code>saxon:column-number()</code>
    ///                extension functions.
    /// </summary>
    /// <remarks>
    ///            <para>Note that the information is only as good as the XML parser supplies. SAX parsers
    ///                generally report the position of an element node using the line and column number of
    ///                the "&gt;" character that forms the last character of the start tag.</para>
    ///            <para>When this option is set, location information attached to a node (system ID, line
    ///            number, and column number) is retained when the node is copied. This has the side effect
    ///            that the base URI of a node is also copied, which in some cases runs contrary to the
    ///            XSLT or XQuery specification.</para>
    ///        
    /// </remarks>

    public static Feature<bool> LINE_NUMBERING = new Feature<bool>(
            net.sf.saxon.lib.Feature.LINE_NUMBERING);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Setting the <code>MARK_DEFAULTED_ATTRIBUTES</code> option causes Saxon to retain details of attributes
    ///            that were notified by the XML parser as being defaulted (that is, the attribute was not present in the instance
    ///            document but was defined by a default value in a DTD or schema). This information is available to applications
    ///            via the <code>saxon:is-defaulted()</code> extension function.
    /// </summary>
    /// <remarks>
    ///            <para>Note: information about defaulted attributes is retained automatically where the attribute is processed
    ///            using Saxon's schema processor; but in the case where the information comes from an external XML parser, it
    ///            is retained only if this option is set.</para>
    ///        
    /// </remarks>

    public static Feature<bool> MARK_DEFAULTED_ATTRIBUTES = new Feature<bool>(
            net.sf.saxon.lib.Feature.MARK_DEFAULTED_ATTRIBUTES);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Places a limit on the number of classes for which Saxon will generate bytecode.
    /// </summary>
    /// <remarks>
    ///            <para>If bytecode generation is enabled, Saxon will generate bytecode for frequently used constructs appearing
    ///                in stylesheets or queries. This can become problematic if a configuration uses a very large number
    ///                of different stylesheets and queries, because it creates memory pressure (in some environments classes
    ///                are never garbage collected). When this limit (which defaults to 10,000) is exceeded, no more bytecode
    ///            is generated, and queries/stylesheets are interpreted instead.</para>
    ///        
    /// </remarks>

    public static Feature<int> MAX_COMPILED_CLASSES = new Feature<int>(
            net.sf.saxon.lib.Feature.MAX_COMPILED_CLASSES);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Use the specified <code>Receiver</code> to process the output from
    ///                    <code>xsl:message</code>. The class must implement the
    ///                    <code>net.sf.saxon.event.Receiver</code> interface. This interface is similar to
    ///                a SAX <code>ContentHandler</code>, in that it takes a stream of events to generate
    ///                output.
    /// </summary>
    /// <remarks>
    ///            <para>By default the standard XML emitter is used, configured to write to the standard
    ///                error stream, and to include no XML declaration. </para>
    ///            <para>In general the content of a message is an XML fragment. Each message is output as a
    ///                new document. The sequence of calls to this <code>Receiver</code> is as follows:
    ///                there is a single <code>open()</code> call at the start of the transformation, and a
    ///                single <code>close()</code> call at the end; and each evaluation of an
    ///                    <code>xsl:message</code> instruction starts with a <code>startDocument()</code>
    ///                call and ends with <code>endDocument()</code>. </para>
    ///            <para>The <code>startDocument()</code> event has a <code>properties</code> argument
    ///                indicating whether <code>terminate="yes"</code> was specified, and the
    ///                    <code>locationId</code> on calls such as <code>startElement()</code> and
    ///                    <code>characters()</code> can be used to identify the location in the stylesheet
    ///                where the message data originated (this is achieved by passing the supplied
    ///                    <code>locationId</code> in a call to
    ///                    <code>getPipelineConfiguration().getLocator().getSystemId(locationId)</code>, or
    ///                to <code>getLineNumber()</code> on the same object). </para>
    ///            <para>Select the class <code>net.sf.saxon.event.MessageWarner</code> to have
    ///                    <code>xsl:message</code> output notified to the JAXP <code>ErrorListener</code>,
    ///                as described in the JAXP documentation.</para>
    ///        
    /// </remarks>

    public static Feature<String> MESSAGE_EMITTER_CLASS = new Feature<String>(
            net.sf.saxon.lib.Feature.MESSAGE_EMITTER_CLASS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Affects XQuery only. An instance of a user-written class implementing Saxon's
    ///                    <see cref="net.sf.saxon.lib.ModuleURIResolver" /> interface. This is used to
    ///                process any URIs used in <code>import module</code> directives in XQuery.
    /// </summary>

    public static Feature<net.sf.saxon.lib.ModuleURIResolver> MODULE_URI_RESOLVER = new Feature<net.sf.saxon.lib.ModuleURIResolver>(
            net.sf.saxon.lib.Feature.MODULE_URI_RESOLVER);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Affects XQuery only. The name of a user-written class implementing Saxon's
    ///                    <see cref="net.sf.saxon.lib.ModuleURIResolver" /> interface. This is used to
    ///                process any URIs used in <code>import module</code> directives in XQuery.
    /// </summary>

    public static Feature<String> MODULE_URI_RESOLVER_CLASS = new Feature<String>(
            net.sf.saxon.lib.Feature.MODULE_URI_RESOLVER_CLASS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>When set from the Transform or Query command line, a report on bytecode generation is
    ///                produced at the end of the transformation or query.
    /// </summary>
    /// <remarks>
    ///            <para>When set from an application, the bytecode report is produced only on request, by
    ///                calling <code>Configuration.createByteCodeReport(fileName)</code>.</para>
    ///            <para>The bytecode report is an XML file containing one entry for each expression that has
    ///                been compiled into bytecode. Each entry contains the following details, where
    ///                applicable:</para>
    ///                <list>
    ///                <item><code>text</code> Abbreviated text of the expression</item>
    ///                <item><code>intCount</code> Number of times the expression was evaluated in the interpreter</item>
    ///                <item><code>intTime</code> Cumulative time spent evaluating the expression (including subexpressions) in the interpreter</item>
    ///                <item><code>bcCount</code> Number of times the expression was evaluated as byte-code</item>
    ///                <item><code>bcTime</code> Cumulative time spent evaluating the expression (including subexpressions) as byte-code</item>
    ///                <item><code>compileTime</code> Time spent generating bytecode for the expression</item>
    ///                <item><code>ratio</code> Average byte-code execution time as a proportion of average interpreted execution time</item>
    ///                <item><code>ebv</code> Number of evaluations of the expressions <code>effectiveBooleanValue()</code> method</item>
    ///                <item><code>eval</code> Number of evaluations of the expressions <code>evaluateItem()</code> method</item>
    ///                <item><code>iterate</code> Number of evaluations of the expressions <code>iterate()</code> method</item>
    ///                <item><code>process</code> Number of evaluations of the expressions <code>process()</code> method</item>
    ///                <item><code>module</code> URI of the module containing the expression</item>
    ///                <item><code>line</code> Line number of the expression within this module</item>
    ///            </list>
    ///        
    /// </remarks>

    public static Feature<bool> MONITOR_HOT_SPOT_BYTE_CODE = new Feature<bool>(
            net.sf.saxon.lib.Feature.MONITOR_HOT_SPOT_BYTE_CODE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Affects schema construction (whether for standalone validation, or in the context of
    ///                XSLT or XQuery).
    /// </summary>
    /// <remarks>
    ///            <para>If set to true, the schema processor attempts to fetch a schema
    ///                document appearing in an <code>xs:import</code> directive, whether or not a schema
    ///                for that namespace has already been loaded, unless the absolute URI formed from the
    ///                    <code>schemaLocation</code> is the same as the absolute URI that was used to
    ///                load that namespace. If set to false, the schema processor ignores the
    ///                    <code>schemaLocation</code> on an <code>xs:import</code> declaration if schema
    ///                components for the requested namespace are already available. Note that setting the
    ///                value to true might cause spurious errors due to like-named schema components being
    ///                loaded more than once. On the other hand, setting the value to false might result in
    ///                validation failing because schema components are missing.</para>
    ///            <para>Note: Both settings are conformant with the W3C recommendation, which leaves the
    ///                details implementation-defined. It is possible (and advisable) to write schemas in
    ///                such a way that this setting makes no difference, by ensuring that all imports for a
    ///                particular namespace go via a "home" schema document for that namespace, where the
    ///                home schema document contains <code>xs:include</code> declarations for all the
    ///                schema documents defining components in that namespace.</para>
    ///        
    /// </remarks>

    public static Feature<bool> MULTIPLE_SCHEMA_IMPORTS = new Feature<bool>(
            net.sf.saxon.lib.Feature.MULTIPLE_SCHEMA_IMPORTS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Indicates that the supplied <code>NamePool</code> should be used as the target
    ///                (run-time) <code>NamePool</code> by all stylesheets compiled (using
    ///                <code>newTemplates()</code>) after this call on <code>setAttribute</code>.
    /// </summary>
    /// <remarks>
    ///            <para>Normally a single system-allocated <code>NamePool</code> is used for all stylesheets
    ///                compiled while the Java VM remains loaded; this attribute allows user control over
    ///                the allocation of name pools. Note that source trees used as input to a
    ///                transformation must be built using the same <code>NamePool</code> that is used when
    ///                the stylesheet is compiled: this will happen automatically if the input to a
    ///                transformation is supplied as a <code>SAXSource</code> or <code>StreamSource</code>
    ///                but it is under user control if you build the source tree yourself.</para>
    ///            <para>This option can be used to make two <code>Configuration</code> objects share a
    ///                    <code>NamePool</code> even though they differ in other respects.</para>
    ///        
    /// </remarks>

    public static Feature<net.sf.saxon.om.NamePool> NAME_POOL = new Feature<net.sf.saxon.om.NamePool>(
            net.sf.saxon.lib.Feature.NAME_POOL);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary><code>OCCURRENCE_LIMITS</code> determines the largest values of
    ///                <code>minOccurs</code> and <code>maxOccurs</code> that can be accommodated when
    ///                compiling an "expanded" finite state machine to represent an XSD content model
    ///                grammar.
    /// </summary>
    /// <remarks>
    ///            <para>These limits do not apply in the common cases where the grammar can be
    ///                implemented using a counting finite-state-machine, but in those cases where this is
    ///                not possible, any <code>minOccurs</code> value greater than the first integer is
    ///                reduced to the value of the first integer, and any <code>maxOccurs</code> value
    ///                greater than the second integer is treated as "unbounded".</para>
    ///            <para>Setting these values too high may cause an <code>OutOfMemoryException</code> since
    ///                the size of the finite state machine constructed by Saxon increases linearly with
    ///                the values of <code>minOccurs</code> and <code>maxOccurs</code>.</para>
    ///        
    /// </remarks>

    public static Feature<Object> OCCURRENCE_LIMITS = new Feature<Object>(
            net.sf.saxon.lib.Feature.OCCURRENCE_LIMITS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Allows individual optimizations to be enabled or disabled selectively.
    /// </summary>
    /// <remarks>
    ///            <para>There is a set of single-letter flags identifying particular optimizations:</para>
    ///            <list>
    ///                <item>c: generate bytecode</item>
    ///                <item>e: cache regular expressions</item>
    ///                <item>f: inline functions</item>
    ///                <item>g: extract global variables</item>
    ///                <item>j: just-in-time compilation of template rules</item>
    ///                <item>k: create keys</item>
    ///                <item>l: loop lifting</item>
    ///                <item>m: miscellaneous</item>
    ///                <item>n: constant folding</item>
    ///                <item>r: template rule-sets</item>
    ///                <item>s: extract common subexpressions</item>
    ///                <item>v: inline variables</item>
    ///                <item>w: create switch statements</item>
    ///                <item>x: index predicates</item>
    ///            </list>
    ///            <para>A value such as <code>gs</code> runs with only the selected optimizations;
    ///                <code>-gs</code> runs with the selected optimizations disabled and all others enabled. The
    ///                value <code>0</code> suppresses all optimizations. The default is full optimization; this
    ///                feature allows optimization to be suppressed in cases where reducing compile time is
    ///                important, or where optimization gets in the way of debugging, or causes extension
    ///                functions with side-effects to behave unpredictably. (Note however, that even with
    ///                no optimization, lazy evaluation may still cause the evaluation order to be not as
    ///                expected.) </para>
    ///            <para><i>Note that disabling optimizations may prevent streamed execution. This is because
    ///            there are cases where streamed execution is only possible because the optimizer is able to detect
    ///            that sorting nodes into document order is unnecessary.</i></para>
    ///        
    /// </remarks>

    public static Feature<Object> OPTIMIZATION_LEVEL = new Feature<Object>(
            net.sf.saxon.lib.Feature.OPTIMIZATION_LEVEL);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>The supplied <code>OutputURIResolver</code> will be used to resolve URIs of secondary
    ///                result documents selected in the <code>href</code> attribute of the XSLT
    ///                    <code>xsl:result-document</code> instruction.
    /// </summary>

    public static Feature<net.sf.saxon.lib.OutputURIResolver> OUTPUT_URI_RESOLVER = new Feature<net.sf.saxon.lib.OutputURIResolver>(
            net.sf.saxon.lib.Feature.OUTPUT_URI_RESOLVER);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>The supplied class will be instantiated, and the resulting
    ///                    <code>OutputURIResolver</code> will be used to resolve URIs of secondary result
    ///                documents selected in the <code>href</code> attribute of the XSLT
    ///                    <code>xsl:result-document</code> instruction.
    /// </summary>

    public static Feature<String> OUTPUT_URI_RESOLVER_CLASS = new Feature<String>(
            net.sf.saxon.lib.Feature.OUTPUT_URI_RESOLVER_CLASS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>If true, calls on the <code>doc()</code> and <code>document()</code> functions, if
    ///                their arguments are known at compile time, will be evaluated at compile time, and
    ///                the resulting document will be stored as part of the Saxon
    ///                <see cref="net.sf.saxon.Configuration" /> and shared by all queries and
    ///                transformations running within that <code>Configuration</code>.
    /// </summary>
    /// <remarks>
    ///            <para>This is useful for reference documents that have stable content and are used by many different 
    ///                queries and transformations. The default is false, which means each query or transformation
    ///                will reload the document from disk.</para>
    ///            <para>In XSLT 3.0 a better way of having external documents pre-loaded at stylesheet
    ///                compile time is to use the new facility of static global variables.</para>
    ///        
    /// </remarks>

    public static Feature<bool> PRE_EVALUATE_DOC_FUNCTION = new Feature<bool>(
            net.sf.saxon.lib.Feature.PRE_EVALUATE_DOC_FUNCTION);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Relevant only on .NET, determines whether the Java Classpath parser is used in
    ///                preference to the Microsoft .NET parser.
    /// </summary>
    /// <remarks>
    ///            <para>This option has no effect on the Java platform. The default is <b>true</b>. When
    ///                running on the .NET platform, if the option is true it causes the Apache Xerces
    ///                parser (cross-compiled using IKVMC) to be used in preference to the .NET XML parser.
    ///                If false the .NET XML parser (<code>System.Xml.XmlTextReader</code>) is used. One
    ///                reason for providing this option is that the .NET XML parser does not report ID
    ///                attributes, which means that the <code>id()</code> function does not work.</para>
    ///        
    /// </remarks>

    public static Feature<bool> PREFER_JAXP_PARSER = new Feature<bool>(
            net.sf.saxon.lib.Feature.PREFER_JAXP_PARSER);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>True if the standard URI resolver is to recognize query parameters included in the
    ///                URI (for example, <code>?validation=strict</code>). Such parameters can then be used
    ///                in URIs passed to the <code>doc()</code> or <code>document()</code> functions. The
    ///                default is false.
    /// </summary>
    /// <remarks>
    ///            <para>This option has no effect if a user-supplied <code>URIResolver</code> is in use,
    ///                unless the user-supplied <code>URIResolver</code> chooses to inherit this
    ///                functionality from the standard <code>URIResolver</code>.</para>
    ///            <para>The allowed parameters are: <code>validation=strict|lax|strip</code> to perform schema
    ///                validation (see <span class="link" data-href="/sourcedocs/validation">Validation of
    ///                    Source Documents</span>); <code>strip-space=yes|ignorable|no</code> to control whitespace
    ///                stripping (see <span class="link" data-href="/sourcedocs/whitespace">Whitespace
    ///                    Stripping in Source Documents</span>); <code>parser=full.class.name</code> to
    ///                determine the name of the parser (XMLReader) to be used (see <span class="link" data-href="/sourcedocs/controlling-parsing">Controlling Parsing of Source
    ///                    Documents</span>); and <code>xinclude=yes|no</code> to control whether XInclude
    ///                processing takes place, assuming the XML parser supports it (see <span class="link" data-href="/sourcedocs/XInclude">XInclude processing</span>).</para>
    ///        
    /// </remarks>

    public static Feature<bool> RECOGNIZE_URI_QUERY_PARAMETERS = new Feature<bool>(
            net.sf.saxon.lib.Feature.RECOGNIZE_URI_QUERY_PARAMETERS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>At one time this property controlled how recoverable errors were handled
    ///                (fatal error, warning, or ignored). XSLT 3.0 has eliminated all recoverable errors from the
    ///                specification, so the property is now deprecated.
    /// </summary>

    public static Feature<int> RECOVERY_POLICY = new Feature<int>(
            net.sf.saxon.lib.Feature.RECOVERY_POLICY);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>At one time this property controlled how recoverable errors were handled
    ///                (fatal error, warning, or ignored). XSLT 3.0 has eliminated all recoverable errors from the
    ///                specification, so the property is now deprecated.
    /// </summary>

    public static Feature<String> RECOVERY_POLICY_NAME = new Feature<String>(
            net.sf.saxon.lib.Feature.RECOVERY_POLICY_NAME);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Indicates the maximum number of threads to be used for processing
    ///                    <code>xsl:result-document</code> instructions in parallel. If the maximum number
    ///                of threads are already in use, the <code>xsl:result-document</code> instruction will
    ///                be executed synchronously within its parent thread.
    /// </summary>
    /// <remarks>
    ///            <para>The default value is initialized to
    ///                    <code>Runtime.getRuntime().availableProcessors()</code> which is intended to
    ///                represent the number of "processors" (under some definition) available from the
    ///                hardware.</para>
    ///            <para>The limit applies per <code>Configuration</code>. If multiple workloads are running
    ///                on the same server under separate Saxon <code>Configuration</code> objects, then it
    ///                may be desirable to lower the limit.</para>
    ///            <para>Setting a value of zero or one suppresses multithreading entirely. This can also be
    ///                achieved (for a specific <code>xsl:result-document</code> instruction) by setting
    ///                the attribute <code>saxon:asynchronous="no"</code> in the stylesheet. Suppressing
    ///                multithreading may be desirable in a stylesheet that calls extension functions with
    ///                side-effects.</para>
    ///        
    /// </remarks>

    public static Feature<int> RESULT_DOCUMENT_THREADS = new Feature<int>(
            net.sf.saxon.lib.Feature.RESULT_DOCUMENT_THREADS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>If set to true, indicates that when input is obtained from a SAX parser, the
    ///                DTD-based attribute type notified by the XML parser should be used to set the type
    ///                annotation of the resulting node: for example a DTD type of NMTOKENS results in a
    ///                type annotation of xs:NMTOKENS. 
    /// </summary>
    /// <remarks>
    ///            <para>This option is retained for backwards compatibility (at some time in the past, it was
    ///                the default), but is deprecated.</para>
    ///        
    /// </remarks>

    public static Feature<bool> RETAIN_DTD_ATTRIBUTE_TYPES = new Feature<bool>(
            net.sf.saxon.lib.Feature.RETAIN_DTD_ATTRIBUTE_TYPES);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>The supplied <code>SchemaURIResolver</code> will be used to resolve URIs of schema
    ///                documents referenced in <code>xsl:import-schema</code> declarations in XSLT,
    ///                    <code>import schema</code> in XQuery, references from one schema document to
    ///                another using <code>xs:include</code> or <code>xs:import</code>, and references from
    ///                an instance document to a schema using <code>xsi:schemaLocation</code>.
    /// </summary>

    public static Feature<net.sf.saxon.lib.SchemaURIResolver> SCHEMA_URI_RESOLVER = new Feature<net.sf.saxon.lib.SchemaURIResolver>(
            net.sf.saxon.lib.Feature.SCHEMA_URI_RESOLVER);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>The name of a class that implements the interface <code>SchemaURIResolver</code>;
    ///                this class will be instantiated and the resulting instance will be used as the value
    ///                of the <see cref="SCHEMA_URI_RESOLVER" /> property.
    /// </summary>

    public static Feature<String> SCHEMA_URI_RESOLVER_CLASS = new Feature<String>(
            net.sf.saxon.lib.Feature.SCHEMA_URI_RESOLVER_CLASS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Indicates whether and how schema validation should be applied to source
    ///                documents.
    /// </summary>

    public static Feature<int> SCHEMA_VALIDATION = new Feature<int>(
            net.sf.saxon.lib.Feature.SCHEMA_VALIDATION);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Indicates whether and how schema validation should be applied to source
    ///                documents.
    /// </summary>

    public static Feature<String> SCHEMA_VALIDATION_MODE = new Feature<String>(
            net.sf.saxon.lib.Feature.SCHEMA_VALIDATION_MODE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>The class will be instantiated and the resulting <code>SerializerFactory</code> will
    ///                be used to create the serialization pipeline for XSLT and XQuery results.
    /// </summary>
    /// <remarks>
    ///            <para>By subclassing the standard <code>SerializerFactory</code> it is possible to customize
    ///                many aspects of the output produced by the Serializer, or to introduce new
    ///                serialization methods and parameters.</para>
    ///        
    /// </remarks>

    public static Feature<String> SERIALIZER_FACTORY_CLASS = new Feature<String>(
            net.sf.saxon.lib.Feature.SERIALIZER_FACTORY_CLASS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>XML parser used for source documents.
    /// </summary>
    /// <remarks>
    ///            <para>The class will be instantiated. If it is an <code>XMLReader</code> it is used
    ///                directly; if it is a <code>SAXParserFactory</code> it is used to instantiate an
    ///                    <code>XMLReader</code>. The resulting <code>XMLReader</code> will be used to
    ///                parse source documents (that is, the principal source document plus any secondary
    ///                source documents read using the <code>doc()</code>, <code>document()</code>, or
    ///                    <code>collection()</code> function).</para>
    ///            <para>Note that the selected parser is used only when the input is supplied in the form of
    ///                a <code>StreamSource</code>; it is ignored when a <code>SAXSource</code> with a
    ///                pre-initialized <code>XMLReader</code> is supplied. A consequence is that this
    ///                configuration option has no effect when running transformations from an Ant script,
    ///                since the Ant <code>xslt</code> task always supplies the input in the form of a
    ///                    <code>SAXSource</code>.</para>
    ///        
    /// </remarks>

    public static Feature<String> SOURCE_PARSER_CLASS = new Feature<String>(
            net.sf.saxon.lib.Feature.SOURCE_PARSER_CLASS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>On interfaces that allow an <code>org.xml.sax.Source</code> to be supplied, if a kind
    ///                of <code>Source</code> is provided that Saxon does not recognize, it will be passed
    ///                to the user-supplied <code>SourceResolver</code>, which has the opportunity to
    ///                convert it to a kind of <code>Source</code> that Saxon does recognize. This allows
    ///                new kinds of input to be supplied as input to Saxon's query, transformation, and
    ///                validation engines.
    /// </summary>

    public static Feature<String> SOURCE_RESOLVER_CLASS = new Feature<String>(
            net.sf.saxon.lib.Feature.SOURCE_RESOLVER_CLASS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary><code>STABLE_COLLECTION_URI</code>, if set, indicates that collections returned by
    ///                the <code>fn:collection()</code> and <code>fn:uri-collection()</code> functions
    ///                should be <i>stable</i>, that is, repeated calls on these functions with the same
    ///                collection URI (within the scope of a single query or transformation) should return
    ///                identical results.
    /// </summary>
    /// <remarks>
    ///            <para>Setting this option may be expensive because it requires that the entire collection
    ///                be saved in memory; it is rarely necessary in practice, but is required for strict
    ///                conformance with the W3C specifications.</para>
    ///            <para>It is also possible to indicate that a collection is stable by means of the
    ///                    <code>CollectionFinder</code> API.</para>
    ///        
    /// </remarks>

    public static Feature<bool> STABLE_COLLECTION_URI = new Feature<bool>(
            net.sf.saxon.lib.Feature.STABLE_COLLECTION_URI);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary><code>STABLE_UNPARSED_TEXT</code>, if set, indicates that the results returned by
    ///                repeated calls of <code>unparsed-text()</code>, <code>unparsed-text-lines()</code>,
    ///                and <code>unparsed-text-available()</code> are consistent: calling these functions
    ///                twice during the evaluation of a stylesheet or query will return the same
    ///                results.
    /// </summary>
    /// <remarks>
    ///            <para>Setting this option may be expensive because it requires that the file contents be
    ///                saved in memory; it is rarely necessary in practice, but is required for strict
    ///                conformance with the W3C specifications.</para>
    ///        
    /// </remarks>

    public static Feature<bool> STABLE_UNPARSED_TEXT = new Feature<bool>(
            net.sf.saxon.lib.Feature.STABLE_UNPARSED_TEXT);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary><code>STANDARD_ERROR_OUTPUT_FILE</code> is the name of a file to which Saxon will
    ///                redirect output that would otherwise go to the operating system standard error
    ///                stream (System.err). This is the fallback destination for various tracing and
    ///                diagnostic output. In some cases a more specific mechanism exists to select the
    ///                destination for particular kinds of output.
    /// </summary>
    /// <remarks>
    ///            <para>Note that if the <code>Configuration</code> is used in more than one processing
    ///                thread, the messages from different threads will be interleaved in the output file.
    ///                A more selective approach is to use a different <code>ErrorListener</code> in
    ///                different processing threads, and arrange for each <code>ErrorListener</code> to
    ///                write to its own logging destination.</para>
    ///        
    /// </remarks>

    public static Feature<String> STANDARD_ERROR_OUTPUT_FILE = new Feature<String>(
            net.sf.saxon.lib.Feature.STANDARD_ERROR_OUTPUT_FILE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>The <code>STREAMABILITY</code> option can be used to disable streaming.
    /// </summary>
    /// <remarks>
    ///            <para>In earlier Saxon releases a third value "extended" was supported, to enable Saxon
    ///                streaming extensions. Since nearly all these extensions found their way into the W3C
    ///                specification, the distinction between "standard" and "extended" became meaningless,
    ///                so the value "extended" has been dropped.</para>
    ///            <para>The value "off" causes Saxon to behave as a non-streaming processor; that is, it does
    ///                not analyze constructs that are declared streamable, and it processes them as if
    ///                streaming were not requested. This is the only option available when using a Saxon
    ///                version or license that does not enable streaming.</para>
    ///            <para>The value "standard" is a misnomer. For strict adherence to W3C streamability rules,
    ///                set the property <code>STRICT_STREAMABILITY</code>. The streamability rules applied
    ///                by default are (in nearly all cases) identical to the W3C rules, but by default they
    ///                are applied to the expression tree after type-checking and optimization, which makes
    ///                some constructs streamable that would not be so otherwise.</para>
    ///            <para>Whichever option is chosen, the <code>STREAMING_FALLBACK</code> option can be used to
    ///                control what happens when code is deemed non-streamable; it provides a choice
    ///                between throwing a static (compile-time) error, and falling back to a non-streaming
    ///                implementation.</para>
    ///        
    /// </remarks>

    public static Feature<String> STREAMABILITY = new Feature<String>(
            net.sf.saxon.lib.Feature.STREAMABILITY);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Causes the XSLT processor to verify that constructs that are declared streamable are
    ///                in fact "guaranteed streamable" according to the W3C rules.
    /// </summary>
    /// <remarks>
    ///            <para>Normally, Saxon performs a variety of simplifications and optimizations on the
    ///                expression tree before performing streamability analysis. Sometimes these tree
    ///                rewrites will turn a non-streamable expression into a streamable one. An obvious
    ///                example is variable inlining: the expression <code>let $x := ./item/price return
    ///                    sum($x)</code> is not streamable, but the rewritten form
    ///                    <code>sum(./item/price)</code> is.</para>
    ///            <para>The XSLT 3.0 specification requires conformant streaming processors to have a mode of
    ///                operation in which the streamability rules are enforced as they appear in the spec,
    ///                and this option enables this mode.</para>
    ///            <para>This analysis is expensive, and should only be used during development when testing
    ///                stylesheet code for portability. When this mode is enabled, Saxon applies the
    ///                streamability rules at the earliest possible stage of processing; it then performs
    ///                its normal type checking and optimization phases, before doing a second stage of
    ///                streamability analysis to construct a streamed execution plan.</para>
    ///        
    /// </remarks>

    public static Feature<bool> STRICT_STREAMABILITY = new Feature<bool>(
            net.sf.saxon.lib.Feature.STRICT_STREAMABILITY);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>If the <code>STREAMING_FALLBACK</code> option is set, then constructs for which
    ///                streaming is requested (such as templates in a streaming mode, the
    ///                    <code>xsl:source-document</code> instruction with attribute
    ///                    <code>streamable="yes"</code>, and streamable accumulators) will be executed in
    ///                non-streaming mode if the code is not actually streamable. A compile-time warning
    ///                will always be given when the fallback option is taken.
    /// </summary>

    public static Feature<bool> STREAMING_FALLBACK = new Feature<bool>(
            net.sf.saxon.lib.Feature.STREAMING_FALLBACK);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Indicates whether all whitespace, no whitespace, or whitespace in elements defined in
    ///                a DTD or schema as having element-only content should be stripped from source
    ///                documents.
    /// </summary>
    /// <remarks>
    ///            <para>The default is "ignorable". This whitespace stripping is additional to
    ///                any stripping done as a result of the <code>xsl:strip-space</code> declaration in an
    ///                XSLT stylesheet.</para>
    ///        
    /// </remarks>

    public static Feature<String> STRIP_WHITESPACE = new Feature<String>(
            net.sf.saxon.lib.Feature.STRIP_WHITESPACE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>XML parser used for stylesheets and schema documents.
    /// </summary>
    /// <remarks>
    ///            <para>The class will be instantiated. If it is an <code>XMLReader</code> it is used
    ///                directly; if it is a <code>SAXParserFactory</code> it is used to instantiate an
    ///                    <code>XMLReader</code>. The resulting <code>XMLReader</code> will be used to
    ///                parse stylesheet documents (that is, the principal stylesheet module plus any
    ///                secondary source documents read using <code>xsl:include</code> or
    ///                    <code>xsl:import</code>) and also schema documents.</para>
    ///        
    /// </remarks>

    public static Feature<String> STYLE_PARSER_CLASS = new Feature<String>(
            net.sf.saxon.lib.Feature.STYLE_PARSER_CLASS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This is set to true to suppress the warning otherwise issued by command-line
    ///                interfaces indicating that an evaluation license is in use and is due to expire in a
    ///                set number of days.
    /// </summary>

    public static Feature<bool> SUPPRESS_EVALUATION_EXPIRY_WARNING = new Feature<bool>(
            net.sf.saxon.lib.Feature.SUPPRESS_EVALUATION_EXPIRY_WARNING);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Suppresses all warnings issued by the XPath and XQuery parsers.
    /// </summary>
    /// <remarks>
    ///            <para>Examples of warnings that are suppressed are the warning produced when keywords such
    ///                as <code>true</code> and <code>return</code> are interpreted as element names.</para>
    ///        
    /// </remarks>

    public static Feature<bool> SUPPRESS_XPATH_WARNINGS = new Feature<bool>(
            net.sf.saxon.lib.Feature.SUPPRESS_XPATH_WARNINGS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This is set to true to suppress the warning when there is no commonality between the
    ///                namespaces used in stylesheet match patterns and the namespaces used in the source
    ///                document.
    /// </summary>

    public static Feature<bool> SUPPRESS_XSLT_NAMESPACE_CHECK = new Feature<bool>(
            net.sf.saxon.lib.Feature.SUPPRESS_XSLT_NAMESPACE_CHECK);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Indicates how often an XSD simple type definition must be used before Saxon generates
    ///                bytecode to implement validation of input data against that type.
    /// </summary>
    /// <remarks>
    ///            <para>By default, Saxon-EE generates Java bytecode to speed up the validation of input
    ///                strings against user-defined simple types after the type has been used 100 times
    ///                (during the life of a Saxon Configuration). This threshold may be changed using this
    ///                configuration option. It may be useful to raise the threshold if the number of
    ///                user-defined types is large, and the bytecode is creating memory pressure.</para>
    ///        
    /// </remarks>

    public static Feature<int> THRESHOLD_FOR_COMPILING_TYPES = new Feature<int>(
            net.sf.saxon.lib.Feature.THRESHOLD_FOR_COMPILING_TYPES);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This is set to true to cause basic timing and tracing information to be output to the
    ///                standard error output stream.
    /// </summary>
    /// <remarks>
    ///            <para>The name of the feature is poorly chosen, since much
    ///                of the information that is output has nothing to do with timing, for example the
    ///                names of output files for <code>xsl:result-document</code> are traced, as are the
    ///                names of schema documents loaded.</para>
    ///        
    /// </remarks>

    public static Feature<bool> TIMING = new Feature<bool>(
            net.sf.saxon.lib.Feature.TIMING);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>If this option is set, Saxon will output (to the standard error output) progress
    ///                information about its attempts to locate and disambiguate references to reflexive
    ///                Java extension functions. This is useful for diagnostics if the XQuery or XSLT
    ///                compiler is failing to locate user-written extension functions.
    /// </summary>

    public static Feature<bool> TRACE_EXTERNAL_FUNCTIONS = new Feature<bool>(
            net.sf.saxon.lib.Feature.TRACE_EXTERNAL_FUNCTIONS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>The <code>TraceListener</code> will be notified of significant events occurring
    ///                during a query or transformation, for tracing or debugging purposes.
    /// </summary>
    /// <remarks>
    ///            <para>Setting a <code>TraceListener</code> automatically sets the
    ///                    <see cref="COMPILE_WITH_TRACING" /> option.</para>
    ///            <para>Avoid this option if more than one transformation or query is running concurrently:
    ///                use the feature <see cref="TRACE_LISTENER_CLASS" />
    ///                instead. Alternatively, it is possible to set a <code>TraceListener</code> for an
    ///                individual query or transformation.</para>
    ///        
    /// </remarks>

    public static Feature<net.sf.saxon.lib.TraceListener> TRACE_LISTENER = new Feature<net.sf.saxon.lib.TraceListener>(
            net.sf.saxon.lib.Feature.TRACE_LISTENER);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>The class will be instantiated once for each query or transformation, and the
    ///                resulting <code>TraceListener</code> will be notified of significant events
    ///                occurring during that query or transformation, for tracing or debugging
    ///                purposes.
    /// </summary>
    /// <remarks>
    ///            <para>Setting a <code>TraceListener</code> automatically sets the
    ///                    <see cref="COMPILE_WITH_TRACING" /> option.</para>
    ///        
    /// </remarks>

    public static Feature<String> TRACE_LISTENER_CLASS = new Feature<String>(
            net.sf.saxon.lib.Feature.TRACE_LISTENER_CLASS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>When trace listening is switched on (for example by using -T on the command line),
    ///                this file will be supplied to the trace listener to use as the output destination.
    ///                If the option is not supplied, trace listener output is sent to the standard error
    ///                stream.
    /// </summary>

    public static Feature<String> TRACE_LISTENER_OUTPUT_FILE = new Feature<String>(
            net.sf.saxon.lib.Feature.TRACE_LISTENER_OUTPUT_FILE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>If this option is set, Saxon will output (to the standard error output) detailed
    ///                information about the rewrites to the expression tree made by the optimizer. This
    ///                information is mainly useful for internal system debugging, but it is also possible
    ///                to digest it to analyze the ways in which the expression has been optimized for the
    ///                purpose of performance analysis and tuning.
    /// </summary>

    public static Feature<bool> TRACE_OPTIMIZER_DECISIONS = new Feature<bool>(
            net.sf.saxon.lib.Feature.TRACE_OPTIMIZER_DECISIONS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Selects an implementation of the Saxon tree model. The default is
    ///                    <code>TINY_TREE</code>.
    /// </summary>
    /// <remarks>
    ///            <para>For running XQuery Update, use the linked tree, because it is the only implementation
    ///                that is updateable.</para>
    ///        
    /// </remarks>

    public static Feature<int> TREE_MODEL = new Feature<int>(
            net.sf.saxon.lib.Feature.TREE_MODEL);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Selects an implementation of the Saxon tree model. The default is
    ///                    <code>tinyTree</code>.
    /// </summary>
    /// <remarks>
    ///            <para>For running XQuery Update, use the linked tree, because it is the only implementation
    ///                that is updateable.</para>
    ///        
    /// </remarks>

    public static Feature<String> TREE_MODEL_NAME = new Feature<String>(
            net.sf.saxon.lib.Feature.TREE_MODEL_NAME);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>The supplied <code>UnparsedTextURIResolver</code> will be used to resolve
    ///                (dereference) all URIs specifed in calls to the <code>unparsed-text()</code>,
    ///                    <code>unparsed-text-lines()</code>, and <code>unparsed-text-available()</code>
    ///                functions.
    /// </summary>

    public static Feature<net.sf.saxon.lib.UnparsedTextURIResolver> UNPARSED_TEXT_URI_RESOLVER = new Feature<net.sf.saxon.lib.UnparsedTextURIResolver>(
            net.sf.saxon.lib.Feature.UNPARSED_TEXT_URI_RESOLVER);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>An instance of the specified <code>UnparsedTextURIResolver</code> class will be
    ///                created, and used to resolve (dereference) all URIs specifed in calls to the
    ///                    <code>unparsed-text()</code>, <code>unparsed-text-lines()</code>, and
    ///                    <code>unparsed-text-available()</code> functions.
    /// </summary>

    public static Feature<String> UNPARSED_TEXT_URI_RESOLVER_CLASS = new Feature<String>(
            net.sf.saxon.lib.Feature.UNPARSED_TEXT_URI_RESOLVER_CLASS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>An instance of the specified <code>URIResolver</code> class will be created, and used
    ///                to resolve (dereference) all URIs specifed in calls to the <code>doc()</code> and
    ///                    <code>document()</code> functions, as well as URIs used in
    ///                    <code>xsl:include</code> and <code>xsl:import</code> and location hints for
    ///                XQuery modules and XSD schema documents.
    /// </summary>

    public static Feature<String> URI_RESOLVER_CLASS = new Feature<String>(
            net.sf.saxon.lib.Feature.URI_RESOLVER_CLASS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This option determines whether a <code>TransformerHandler</code> created with this
    ///                    <code>TransformerFactory</code> or <code>Configuration</code> recognizes the
    ///                JAXP-defined processing instructions <code>Result.PI_DISABLE_OUTPUT_ESCAPING</code>
    ///                and <code>Result.PI_ENABLE_OUTPUT_ESCAPING</code> in the input stream as
    ///                instructions to disable or to re-enable output escaping. The default value is
    ///                    <b>false</b>.
    /// </summary>

    public static Feature<bool> USE_PI_DISABLE_OUTPUT_ESCAPING = new Feature<bool>(
            net.sf.saxon.lib.Feature.USE_PI_DISABLE_OUTPUT_ESCAPING);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This option is relevant only when the TinyTree is used; it determines whether (for a
    ///                validated document) a cache will be maintained containing the typed values of nodes.
    /// </summary>
    /// <remarks>
    ///            <para>Typed values are held in the cache only for elements and attributes whose type is
    ///                other than string, untypedAtomic, or anyURI. The default value is true. Setting this
    ///                value to false can reduce memory requirements at the cost of requiring recomputation
    ///                of typed values on each access.</para>
    ///        
    /// </remarks>

    public static Feature<bool> USE_TYPED_VALUE_CACHE = new Feature<bool>(
            net.sf.saxon.lib.Feature.USE_TYPED_VALUE_CACHE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This option determines whether or not to use the <code>xsi:schemaLocation</code>
    ///                    and<code> xsi:noNamespaceSchemaLocation</code> attributes in an instance
    ///                document to locate a schema for validation.
    /// </summary>
    /// <remarks>
    ///            <para>Note, these attribute are only consulted if validation is requested; the presence of
    ///                one of these attributes never by itself triggers validation.</para>
    ///        
    /// </remarks>

    public static Feature<bool> USE_XSI_SCHEMA_LOCATION = new Feature<bool>(
            net.sf.saxon.lib.Feature.USE_XSI_SCHEMA_LOCATION);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This option determines whether non-fatal validation errors in XQuery or XSLT result
    ///                documents should result in comments being inserted into the result tree. The
    ///                command-line flag <code>-outval:recover</code> sets both this option and the
    ///                    <see cref="VALIDATION_WARNINGS" /> option.
    /// </summary>

    public static Feature<bool> VALIDATION_COMMENTS = new Feature<bool>(
            net.sf.saxon.lib.Feature.VALIDATION_COMMENTS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This option indicates (if true) that errors occuring while validating a final result
    ///                tree are not to be treated as fatal.
    /// </summary>
    /// <remarks>
    ///            <para>Regardless of the setting of this option, all validation errors are reported to the
    ///                    <code>error()</code> method of the <code>ErrorListener</code>, and validation is
    ///                terminated if the <code>error()</code> method throws an exception, or if the error
    ///                limit set in the <code>ParseOptions</code> object is reached.</para>
    ///            <para>This option primarily controls what happens at the end of a validation episode. If
    ///                the validation episode detected one or more validation errors, then when this option
    ///                is off, an exception is thrown, which will normally result in any query or
    ///                stylesheet failing with a dynamic error, and no output file being written. If the
    ///                option is on, no exception is thrown, and the output is written as if validation had
    ///                been successful. Note in this case that any type annotations present in a result
    ///                document are unreliable.</para>
    ///            <para>If this option is set when running XSLT or XQuery, it is ignored as far as input
    ///                files are concerned: validation errors in input files are still fatal. However, if
    ///                the option is set and a validation error occurs in a final output file, the output
    ///                file is still written and the process terminates as if successful.</para>
    ///            <para>The detailed interpretation of this option changed in Saxon 9.5.</para>
    ///        
    /// </remarks>

    public static Feature<bool> VALIDATION_WARNINGS = new Feature<bool>(
            net.sf.saxon.lib.Feature.VALIDATION_WARNINGS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Indicates whether a warning message should be notified (to the
    ///                <code>ErrorListener</code>) if running Saxon against an XSLT stylesheet that
    ///                specifies <code>version="1.0"</code>.
    /// </summary>
    /// <remarks>
    ///            <para>From Saxon 9.8, the warning is no longer output (since XSLT 3.0 does not require
    ///                it), so this option is ignored.</para>
    ///            
    ///        
    /// </remarks>

    public static Feature<bool> VERSION_WARNING = new Feature<bool>(
            net.sf.saxon.lib.Feature.VERSION_WARNING);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Indicates whether source documents should have any XInclude directives expanded.
    /// </summary>
    /// <remarks>
    ///            <para>The default is false. The option applies to all input XML documents, including
    ///                stylesheets and schema documents. It can be overridden for individual documents
    ///                using the <see cref="net.sf.saxon.lib.ParseOptions" /> class.</para>
    ///            <para>This option relies on support in the underlying XML parser. If the XML parser does
    ///                not support XInclude processing, setting this option results in a parsing failure.</para>
    ///        
    /// </remarks>

    public static Feature<bool> XINCLUDE = new Feature<bool>(
            net.sf.saxon.lib.Feature.XINCLUDE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This determines the XML version used by the <code>Configuration</code>.
    /// </summary>
    /// <remarks>
    ///            <para>Note that source documents specifying <code>xml version="1.0"</code> or
    ///                    <code>"1.1"</code> are accepted regardless of this setting. The effect of this
    ///                switch is to change the validation rules for types such as <code>xs:Name</code> and
    ///                    <code>xs:NCName</code>, to change the characters allowed in names within XPath
    ///                expressions (etc.), to change the meaning of <code>\i</code> and <code>\c</code> in
    ///                regular expressions, and to determine whether the serializer allows XML 1.1
    ///                documents to be constructed. </para>
    ///            <para>The default is currently 1.0, but may change.</para>
    ///        
    /// </remarks>

    public static Feature<String> XML_VERSION = new Feature<String>(
            net.sf.saxon.lib.Feature.XML_VERSION);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Sets the value of a parser feature flag. The feature name is any fully-qualified
    ///                URI.
    /// </summary>
    /// <remarks>
    ///            <para>For example if the parser supports a feature
    ///                    <code>http://xml.org/sax/features/external-parameter-entities</code> then this
    ///                can be set by setting the value of the Configuration property:
    ///                    <code>http://saxon.sf.net/feature/parserFeature?uri=http%3A//xml.org/sax/features/external-parameter-entities</code>
    ///                to true.</para>
    ///        
    /// </remarks>

    public static Feature<bool> XML_PARSER_FEATURE = new Feature<bool>(
            net.sf.saxon.lib.Feature.XML_PARSER_FEATURE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Sets the value of a parser property flag. The property name is any fully-qualified
    ///                URI.
    /// </summary>
    /// <remarks>
    ///            <para>For example if the parser supports a property
    ///                    <code>http://apache.org/xml/properties/schema/external-schemaLocation</code>
    ///                then this can be set using the value of the Configuration property:
    ///                    <code>http://saxon.sf.net/feature/parserProperty?uri=http%3A//apache.org/xml/properties/schema/external-schemaLocation</code>
    ///                to the required value.</para>
    ///        
    /// </remarks>

    public static Feature<bool> XML_PARSER_PROPERTY = new Feature<bool>(
            net.sf.saxon.lib.Feature.XML_PARSER_PROPERTY);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Determines whether XQuery Update syntax is accepted.
    /// </summary>
    /// <remarks>
    ///            <para>If true, update syntax is accepted, if false, it is not accepted. Setting the value to 
    ///                true does not mean that the query has to use update syntax, only that it may do so.</para>
    ///            <para>From Saxon 9.6, XQuery Update syntax and XQuery 3.0 syntax can be mixed, although
    ///                this combination is not defined by any W3C specification at the time of writing.</para>
    ///            <para>This option can be set for a particular XQuery compilation. When the option is set at
    ///                the <code>Configuration</code> level, it acts as a default.</para>
    ///            <para>On the command line, this option is combined with the option "discard" which
    ///                indicates that updates are allowed, but the updates are not written back to
    ///                filestore. This does not correspond to any option in the Java API, where writing an
    ///                updated document back to filestore only happens if explicitly requested.</para>
    ///        
    /// </remarks>

    public static Feature<bool> XQUERY_ALLOW_UPDATE = new Feature<bool>(
            net.sf.saxon.lib.Feature.XQUERY_ALLOW_UPDATE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This option defines the default value of the construction mode in the XQuery static
    ///                context (overridable in the query prolog).
    /// </summary>
    /// <remarks>
    ///            <para>This option can be set for a particular XQuery compilation. When the option is set at
    ///                the <code>Configuration</code> level, it acts as a default.</para>
    ///        
    /// </remarks>

    public static Feature<String> XQUERY_CONSTRUCTION_MODE = new Feature<String>(
            net.sf.saxon.lib.Feature.XQUERY_CONSTRUCTION_MODE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This property defines the default namespace for elements and types that are not
    ///                qualified by a namespace prefix.
    /// </summary>
    /// <remarks>
    ///            <para>This option can be set for a particular XQuery compilation. When the option is set at
    ///                the <code>Configuration</code> level, it acts as a default.</para>
    ///        
    /// </remarks>

    public static Feature<Object> XQUERY_DEFAULT_ELEMENT_NAMESPACE = new Feature<Object>(
            net.sf.saxon.lib.Feature.XQUERY_DEFAULT_ELEMENT_NAMESPACE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This property defines the default namespace for function names that are not qualified
    ///                by a namespace prefix.
    /// </summary>
    /// <remarks>
    ///            <para>This option can be set for a particular XQuery compilation. When the option is set at
    ///                the <code>Configuration</code> level, it acts as a default.</para>
    ///        
    /// </remarks>

    public static Feature<Object> XQUERY_DEFAULT_FUNCTION_NAMESPACE = new Feature<Object>(
            net.sf.saxon.lib.Feature.XQUERY_DEFAULT_FUNCTION_NAMESPACE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This property defines how the empty sequence is handled in XQuery sorting (the "order
    ///                by" clause). If true, <code>()</code> comes at the start of the sorted sequence; if
    ///                false, it comes last.
    /// </summary>
    /// <remarks>
    ///            <para>This option can be set for a particular XQuery compilation. When the option is set at
    ///                the <code>Configuration</code> level, it acts as a default.</para>
    ///        
    /// </remarks>

    public static Feature<bool> XQUERY_EMPTY_LEAST = new Feature<bool>(
            net.sf.saxon.lib.Feature.XQUERY_EMPTY_LEAST);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This property defines the default value of the <code>inherit-namespaces</code>
    ///                property in the XQuery static context.
    /// </summary>
    /// <remarks>
    ///            <para>This option can be set for a particular XQuery compilation. When the option is set at
    ///                the <code>Configuration</code> level, it acts as a default.</para>
    ///        
    /// </remarks>

    public static Feature<bool> XQUERY_INHERIT_NAMESPACES = new Feature<bool>(
            net.sf.saxon.lib.Feature.XQUERY_INHERIT_NAMESPACES);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>If the value is false, then when an <code>import module</code> declaration is
    ///                encountered for a module URI that is already among the known loaded modules (or
    ///                modules in the process of being compiled), the <code>import module</code> is treated
    ///                as a reference to the existing module. If the value is true, the system first checks
    ///                whether the supplied "location hints" match the known location of the existing
    ///                module, and the existing module is used only if there is a match.
    /// </summary>

    public static Feature<bool> XQUERY_MULTIPLE_MODULE_IMPORTS = new Feature<bool>(
            net.sf.saxon.lib.Feature.XQUERY_MULTIPLE_MODULE_IMPORTS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This property defines whether "boundary space" (insignificant space in direct element
    ///                constructors) should be retained or not.
    /// </summary>
    /// <remarks>
    ///            <para>This option can be set for a particular XQuery compilation. When the option is set at
    ///                the <code>Configuration</code> level, it acts as a default.</para>
    ///        
    /// </remarks>

    public static Feature<bool> XQUERY_PRESERVE_BOUNDARY_SPACE = new Feature<bool>(
            net.sf.saxon.lib.Feature.XQUERY_PRESERVE_BOUNDARY_SPACE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This property defines whether unused namespace declarations are retained by XQuery
    ///                element copy operations.
    /// </summary>
    /// <remarks>
    ///            <para>This option can be set for a particular XQuery compilation. When the option is set at
    ///                the <code>Configuration</code> level, it acts as a default.</para>
    ///        
    /// </remarks>

    public static Feature<bool> XQUERY_PRESERVE_NAMESPACES = new Feature<bool>(
            net.sf.saxon.lib.Feature.XQUERY_PRESERVE_NAMESPACES);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This property defines the default expected context item type for a query.
    /// </summary>
    /// <remarks>
    ///            <para>This option can be set for a particular XQuery compilation. When the option is set at
    ///                the <code>Configuration</code> level, it acts as a default.</para>
    ///        
    /// </remarks>

    public static Feature<String> XQUERY_REQUIRED_CONTEXT_ITEM_TYPE = new Feature<String>(
            net.sf.saxon.lib.Feature.XQUERY_REQUIRED_CONTEXT_ITEM_TYPE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>A query will automatically be schema-aware if it contains an <code>import
    ///                    schema</code> declaration. This property allows a query to be marked as
    ///                schema-aware even if it contains no <code>import schema</code> declaration. It is
    ///                necessary for a query to be compiled as schema-aware if it is to handle typed
    ///                (validated) input documents in which nodes have type annotations based on their
    ///                schema-defined type.
    /// </summary>
    /// <remarks>
    ///            <para>This option can be set for a particular XQuery compilation. When the option is set at
    ///                the <code>Configuration</code> level, it acts as a default.</para>
    ///        
    /// </remarks>

    public static Feature<bool> XQUERY_SCHEMA_AWARE = new Feature<bool>(
            net.sf.saxon.lib.Feature.XQUERY_SCHEMA_AWARE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>The specified class is instantiated to create an <code>ErrorListener</code>, and all
    ///                reports of static errors in a query will go to this <code>ErrorListener</code>.
    /// </summary>
    /// <remarks>
    ///            <para>This option can be set for a particular XQuery compilation. When the option is set at
    ///                the <code>Configuration</code> level, it acts as a default.</para>
    ///            <para>In the absence of this property, the global <code>ErrorListener</code> specified as
    ///                the value of the <see cref="ERROR_LISTENER_CLASS" />
    ///                property is used.</para>
    ///        
    /// </remarks>

    public static Feature<String> XQUERY_STATIC_ERROR_LISTENER_CLASS = new Feature<String>(
            net.sf.saxon.lib.Feature.XQUERY_STATIC_ERROR_LISTENER_CLASS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This property determines the version of XQuery used by the
    ///                <code>Configuration</code>.
    /// </summary>
    /// <remarks>
    ///            <para>From Saxon 9.8, an XQuery 3.1 processor is always used by default. So setting this
    ///                property has no effect.</para>
    ///            
    ///        
    /// </remarks>

    public static Feature<String> XQUERY_VERSION = new Feature<String>(
            net.sf.saxon.lib.Feature.XQUERY_VERSION);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This property determines the version of XML Schema used by the
    ///                <code>Configuration</code>.
    /// </summary>
    /// <remarks>
    ///            <para>From Saxon 9.8, the default is XSD 1.1. If XSD 1.0 is
    ///                selected, XSD 1.1 features will be rejected, with the exception of the version
    ///                control attributes that allow sections of the schema to be marked as requiring XSD
    ///                1.0 or XSD 1.1.</para>
    ///        
    /// </remarks>

    public static Feature<String> XSD_VERSION = new Feature<String>(
            net.sf.saxon.lib.Feature.XSD_VERSION);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This property indicates whether assertions (XSLT 3.0 xsl:assert instructions) are
    ///                enabled or disabled. They are disabled by default. Setting this property on causes
    ///                assertions to be enabled at compile time for all XSLT packages compiled using the
    ///                default configuration options.
    /// </summary>
    /// <remarks>
    ///            <para>This option can be set for a particular XSLT compilation. When the option is set at
    ///                the <code>Configuration</code> level (or on a <code>TransformerFactory</code>), it
    ///                acts as a default.</para>
    ///            <para>If assertions have been enabled at compile time for a particular package, they can
    ///                still be disabled at run-time (for all packages) by setting an option on the
    ///                    <code>Xslt30Transformer</code>. But if assertions were disabled at compile time,
    ///                enabling them at run-time has no effect.</para>
    ///        
    /// </remarks>

    public static Feature<bool> XSLT_ENABLE_ASSERTIONS = new Feature<bool>(
            net.sf.saxon.lib.Feature.XSLT_ENABLE_ASSERTIONS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This property indicates the name of a mode within a stylesheet in which execution
    ///                (using template rules) should begin.
    /// </summary>
    /// <remarks>
    ///            <para>This option can be set for a particular XSLT transformation. When the option is set
    ///                at the <code>Configuration</code> (or on a <code>TransformerFactory</code>), it acts
    ///                as a default.</para>
    ///        
    /// </remarks>

    public static Feature<String> XSLT_INITIAL_MODE = new Feature<String>(
            net.sf.saxon.lib.Feature.XSLT_INITIAL_MODE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This property indicates the name of a named template within a stylesheet where
    ///                execution should begin.
    /// </summary>
    /// <remarks>
    ///            <para>This option can be set for a particular XSLT transformation. When the option is set
    ///                at the <code>Configuration</code> level (or on a <code>TransformerFactory</code>),
    ///                it acts as a default.</para>
    ///            <para>Specifically, if the transformation is performed using the <code>transform()</code>
    ///                method of class <code>net.sf.saxon.s9api.XsltTransformer</code>, then the transformation
    ///                will proceed by calling the relevant named template, rather than by applying templates
    ///                to the supplied source node. It will also affect other APIs built on top of the 
    ///                <code>XsltTransformer</code>, notably the JAXP transformation interface, which in turn
    ///                is used by many higher-level interfaces such as Ant. Indeed, the main purpose of this
    ///                configuration option is to allow named-template stylesheet invocation using the JAXP 
    ///                interface, which was designed without this feature in mind.</para>
    ///            <para>This configuration option is ignored when using an <code>net.sf.saxon.s9api.Xslt30Transformer</code>,
    ///                or other interfaces built on top of an <code>Xslt30Transformer</code>, for example the
    ///                <code>net.sf.saxon.Transform</code> command line interface.</para>
    ///        
    /// </remarks>

    public static Feature<String> XSLT_INITIAL_TEMPLATE = new Feature<String>(
            net.sf.saxon.lib.Feature.XSLT_INITIAL_TEMPLATE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This property indicates whether stylesheets should be compiled with the ability to
    ///                handle schema-typed input documents. By default a stylesheet is compiled to handle
    ///                such input if it contains an <code>xsl:import-schema</code> instruction, and not
    ///                otherwise. It is necessary for a stylesheet to be compiled as schema-aware if it is
    ///                to handle typed (validated) input documents in which nodes have type annotations
    ///                based on their schema-defined type.
    /// </summary>
    /// <remarks>
    ///            <para>This option can be set for a particular XSLT compilation. When the option is set at
    ///                the <code>Configuration</code> level (or on a <code>TransformerFactory</code>), it
    ///                acts as a default.</para>
    ///        
    /// </remarks>

    public static Feature<bool> XSLT_SCHEMA_AWARE = new Feature<bool>(
            net.sf.saxon.lib.Feature.XSLT_SCHEMA_AWARE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>The specified class is instantiated to create an <code>ErrorListener</code>, and all
    ///                reports of static errors in a stylesheet will go to this
    ///                <code>ErrorListener</code>.
    /// </summary>
    /// <remarks>
    ///            <para>This option can be set for a particular XSLT compilation. When the option is set at
    ///                the <code>Configuration</code> level (or on a <code>TransformerFactory</code>), it
    ///                acts as a default.</para>
    ///            <para>In the absence of this property, the global <code>ErrorListener</code> specified as
    ///                the value of the <see cref="ERROR_LISTENER_CLASS" />
    ///                property is used.</para>
    ///        
    /// </remarks>

    public static Feature<String> XSLT_STATIC_ERROR_LISTENER_CLASS = new Feature<String>(
            net.sf.saxon.lib.Feature.XSLT_STATIC_ERROR_LISTENER_CLASS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This property defines a <code>URIResolver</code> used when dereferencing the URIs
    ///                that appear in the <code>href</code> attributes of the <code>xsl:include</code> and
    ///                    <code>xsl:import</code> declarations. Note that this defaults to the setting of
    ///                the global <code>URI_RESOLVER</code> property.
    /// </summary>
    /// <remarks>
    ///            <para>This option can be set for a particular XSLT compilation. When the option is set at
    ///                the <code>Configuration</code> level (or on a <code>TransformerFactory</code>), it
    ///                acts as a default.</para>
    ///            <para>In the absence of this property, the global <code>URIResolver</code> specified as the
    ///                value of the <see cref="URI_RESOLVER_CLASS" /> property
    ///                is used.</para>
    ///        
    /// </remarks>

    public static Feature<String> XSLT_STATIC_URI_RESOLVER_CLASS = new Feature<String>(
            net.sf.saxon.lib.Feature.XSLT_STATIC_URI_RESOLVER_CLASS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This property determines the version of XSLT to be supported by default.
    /// </summary>
    /// <remarks>
    ///            <para>From Saxon 9.8, an XSLT 3.0 processor is always used by default. So setting this
    ///                property has no effect.</para>
    ///            
    ///        
    /// </remarks>

    public static Feature<String> XSLT_VERSION = new Feature<String>(
            net.sf.saxon.lib.Feature.XSLT_VERSION);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This property sets a limit on the amount of backtracking performed during regular expression evaluation.
    /// </summary>
    /// <remarks>
    ///            <para>The default is 10000000 (ten million) which typically represents an evaluation time of about ten seconds.
    ///            After this time, evaluation of the regular expression will fail rather than making further attempts to find a
    ///            match. If this limit is reached, it often suggests that there might be a better way of writing the regular expression.
    ///            The value can be set to -1 (minus one) to mean "unlimited".</para>
    ///            <para>Excessive backtracking is usually caused by nested loops in the regular expression, combined with processing
    ///            of long input strings. Try to ensure that when nested loops are used, there is an unambiguous condition that causes
    ///            the inner loop to terminate. For example <code>(/[^/]*)+</code> is fine (it matches a sequence of path segments separated
    ///                by <code>/</code> characters), because the presence of <code>/</code> forces the inner loop to terminate. By contrast,
    ///                <code>(/.*)+</code> matches the same input, but in many different ways, which could lead to excessive backtracking
    ///            to no useful purpose.</para>
    ///        
    /// </remarks>

    public static Feature<int> REGEX_BACKTRACKING_LIMIT = new Feature<int>(
            net.sf.saxon.lib.Feature.REGEX_BACKTRACKING_LIMIT);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>The XSD 1.1 specification states that XPath version 2.0 is used for expressions appearing in assertions and type
    ///                alternatives. This option allows XPath 3.0 or 3.1 to be used instead.
    /// </summary>
    /// <remarks>
    ///            <para>The recognized values are the integers 20, 30, and 31 representing versions 2.0, 3.0, and 3.1 respectively.</para>           
    ///        
    /// </remarks>

    public static Feature<int> XPATH_VERSION_FOR_XSD = new Feature<int>(
            net.sf.saxon.lib.Feature.XPATH_VERSION_FOR_XSD);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>The XSLT 3.0 specification states that processors are required to support XPath 3.0 expressions within stylesheets, together
    ///                with some extensions (maps) selected from the XPath 3.1 specification. Support for the full syntax of XPath 3.1 is
    ///                optional, but it is the default in Saxon. This option allows a different XPath language level to be selected.
    /// </summary>
    /// <remarks>
    ///            <para>The integer values 20, 30, and 31 denote XPath 2.0, 3.0, and 3.1 respectively, while the value 305 denotes XPath 3.0
    ///                with the extensions defined in the XSLT 3.0 specification.</para>
    ///        
    /// </remarks>

    public static Feature<int> XPATH_VERSION_FOR_XSLT = new Feature<int>(
            net.sf.saxon.lib.Feature.XPATH_VERSION_FOR_XSLT);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Saxon-EE performs inlining of user-defined functions that are sufficiently simple: they must not be recursive,
    ///                and they must be below a certain size. This option defines the size.
    /// </summary>
    /// <remarks>
    ///            <para>The value is (roughly) the number of nodes in the expression tree representing the function body. This
    ///                includes both explicit subexpressions, and subexpressions added by Saxon itself to perform implicit
    ///                operations such as type checking or conversion of function arguments. The default value is 100.</para>
    ///        
    /// </remarks>

    public static Feature<int> THRESHOLD_FOR_FUNCTION_INLINING = new Feature<int>(
            net.sf.saxon.lib.Feature.THRESHOLD_FOR_FUNCTION_INLINING);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>Saxon-EE generates bytecode to give faster execution of frequently-evaluated subexpressions.
    ///                Bytecode is generated when a candidate expression has been evaluated a certain number of
    ///                times, controlled by this parameter.
    ///            
    /// </summary>
    /// <remarks>
    ///            <para>Setting this parameter to 0 (or any negative value) has the effect of disabling bytecode
    ///                generation completely. Setting the parameter to a positive value has the effect of enabling
    ///                bytecode generation if it is not already enabled. Setting the value to 1 (one) causes bytecode
    ///                to be generated for candidate expressions the first time it is executed.</para>
    ///        
    /// </remarks>

    public static Feature<int> THRESHOLD_FOR_HOTSPOT_BYTE_CODE = new Feature<int>(
            net.sf.saxon.lib.Feature.THRESHOLD_FOR_HOTSPOT_BYTE_CODE);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>The value is a comma-separated list of permitted protocols. A protocol is the 
    ///                scheme portion of a URI, or in the case of the JAR protocol, "jar" 
    ///                plus the scheme portion separated by colon. The value "all" gives access
    ///                to all protocols (which is the default). The value "" (empty string) disallows
    ///                all external resource access. (The format is thus the same as for 
    ///                <code>XMLConstants.ACCESS_EXTERNAL_SCHEMA</code> and similar attributes.)
    ///            
    /// </summary>
    /// <remarks>
    ///            <para>The value constrains access by Saxon (but not by underlying software, such
    ///                as the XML parser) to resources including the following:</para>
    ///            
    ///            <list>
    ///                <item>Stylesheet modules</item>
    ///                <item>Schema documents</item>
    ///                <item>Query modules</item>
    ///                <item>Documents referenced from a stylesheet or query using functions such
    ///                    as <code>fn:doc</code>, <code>fn:document</code>, <code>fn:unparsed-text</code>,
    ///                    <code>fn:collection</code>, <code>fn:json-doc</code>, <code>fn:transform</code>, or by the
    ///                    <code>xsl:source-document</code> instruction.</item>
    ///                <item>Resources obtained using Saxon-supplied extension functions such as
    ///                    those in the EXPath file library (but it does not affect user-supplied
    ///                    extension functions).</item>
    ///            </list>
    ///            <para>The constraint applies to the URI used to request
    ///                the resource; the constraint is applied by the standard URI resolvers, but if 
    ///                user-supplied resolvers are used (such as a <code>URIResolver</code>), they can decide
    ///                whether to apply the restrictions or not.</para>
    ///            <para>The constraint applies to URIs used as locations or location hints, not to URIs used as names. So
    ///            for XSD it applies to a schemaLocation, not a targetNamespace; for XQuery it applies to module
    ///            location hints, not to module URIs. In the case of XSLT packages, resolution from a package name
    ///            to a location is always under user/application control, so Saxon imposes no restrictions.</para>
    ///            <para>The format is the same as for <code>XMLConstants.ACCESS_EXTERNAL_SCHEMA</code>: either <code>"all"</code> to allow
    ///                all schemes/protocols, or a comma-separated list of scheme names such as <code>"http"</code>, <code>"file"</code>, <code>"ftp"</code>.
    ///                For a JAR file scheme, use the format <code>"jar:<i>scheme</i>"</code>, for example <code>"jar:file"</code>. A zero-length
    ///                string disallows all schemes.</para>
    ///        
    /// </remarks>

    public static Feature<Object> ALLOWED_PROTOCOLS = new Feature<Object>(
            net.sf.saxon.lib.Feature.ALLOWED_PROTOCOLS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>By default, Saxon attempts to ensure that the run-time code contains no links to the original source stylesheet tree.
    ///                This allows the garbage collector to free memory.
    ///            
    /// </summary>
    /// <remarks>
    ///            <para>If this option is set, then <code>Location</code> objects held in the run-time expression tree may contain a link
    ///                to an element node in the source stylesheet, enabling a user-written <code>ErrorListener</code> to produce
    ///                improved diagnostics. This may be an appropriate setting to use, for example, in an IDE.</para>
    ///            <para>Links to source nodes are not retained in an exported SEF file, regardless of this setting.</para>
    ///        
    /// </remarks>

    public static Feature<bool> RETAIN_NODE_FOR_DIAGNOSTICS = new Feature<bool>(
            net.sf.saxon.lib.Feature.RETAIN_NODE_FOR_DIAGNOSTICS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>The W3C XSD specification (both 1.0 and 1.1) states that an unresolved
    ///        reference to an absent schema component does not automatically make the schema
    ///        invalid; the schema should be usable for validation provided that the missing
    ///        components are not actually needed in a particular validation episode.
    ///      
    /// </summary>
    /// <remarks>
    ///      <para>However, the W3C XSD conformance tests treat such an unresolved reference
    ///      as an error; the test is expected to report the schema as invalid. And this
    ///      is the way most schema processors actually operate, and probably what most
    ///      users would expect.</para>
    ///      <para>By default, the Saxon schema processor reports an unresolved reference
    ///      as an error in the schema.</para>
    ///      <para>If this option is set, then Saxon attempts to repair the schema so that
    ///      it is usable for validation, by substituting the missing components with default
    ///      components: for example if an attribute declaration refers to a type that has
    ///      not been defined, then <code>xs:error</code> is substituted, making any instance
    ///      of the attribute invalid.</para>
    ///      
    /// </remarks>

    public static Feature<bool> ALLOW_UNRESOLVED_SCHEMA_COMPONENTS = new Feature<bool>(
            net.sf.saxon.lib.Feature.ALLOW_UNRESOLVED_SCHEMA_COMPONENTS);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /// <summary>This is used by the standard Collection Finder and may not be relevant
    ///                if a custom Collection Finder is in use.
    ///            
    /// </summary>
    /// <remarks>
    ///            <para>If the absolutized URI passed to the collection() function matches
    ///            this pattern, then the URI will be treated as a reference to a ZIP file
    ///            (and will therefore fail if the URI does not resolve to a resource that can
    ///            be opened as a ZIP file).</para>
    ///            
    ///        
    /// </remarks>

    public static Feature<String> ZIP_URI_PATTERN = new Feature<String>(
            net.sf.saxon.lib.Feature.ZIP_URI_PATTERN);

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


} 
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2018 Saxonica Limited.
// This Source Code Form is subject to the terms of the Mozilla Public License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can obtain one at http://mozilla.org/MPL/2.0/.
// This Source Code Form is "Incompatible With Secondary Licenses", as defined by the Mozilla Public License, v. 2.0.
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
