# mmh3 Contributing Guidelines

Thank you for your interest in contributing to the `mmh3` project!

Read [README.md](../README.md) to get an overview of the `mmh3` project,
and follow our [Code of Conduct](./CODE_OF_CONDUCT.md)
(ACM Code of Ethics and Professional Conduct).

## Issues

You can contribute to our project by
simply submitting a bug report or a feature suggestion
through the [issue tracker](https://github.com/hajimes/mmh3/issues).

Before submitting a new issue, it's a good idea to check [Known Issues section on README](https://github.com/hajimes/mmh3#known-issues).

## Maintaining and developing the project

### Project structure

As of 4.1.0, the layout of the project is as follows:

- `src/mmh3`
  - `mmh3module.c`: the main file that serves as the interface between Python and the MurmurHash3 c implementations.
  - `murmurhash.c`: implementations of the MurmurHash3 family. Auto-generated from Austin Appleby's original code. DO NOT edit this file manually. See [README in the util directory](../util/README.md) for details.
  - `murmurhash.h`: headers and macros for MurmurHash3. Auto-generated from `util/refresh.py`. DO NOT edit this file manually.
  - `hashlib.h`: taken from [CPython's code base](https://github.com/python/cpython/blob/9ce0f48e918860ffa32751a85b0fe7967723e2e3/Modules/hashlib.h).
- `util`
  - `refresh.py`: file that generates `src/mmh3/murmurhash.c` and `src/mmh3/murmurhash.h` from the original MurmurHash3 C++ code. Edit this file to modify the contents of these files.

### Testing

Before submitting your changes, make sure to run the project's tests to ensure
that everything is working as expected.
At least you should run `pytest` and `mypy --strict tests`
from the project root directory.

#### (Optional) Testing on s390x

When you have modified the code in a way which may cause endian issues, you may want
to locally test on s390x, the only big-endian platform officially supported by
Python.

[*Emulating a big-endian s390x with QEMU*](https://til.simonwillison.net/docker/emulate-s390x-with-qemu)
by Simon Willison is a good introduction to Docker/QEMU settings for emulating
s390x.

### Pull request

Once you've pushed your changes to your fork, you can
[create a pull request (PR)](https://github.com/hajimes/mmh3/pulls) on the main
project repository. Please provide a clear and detailed description of your
changes in the PR, and reference any related issues.