// Copyright (c) 2012 Ecma International.  All rights reserved.
// Ecma International makes this code available under the terms and conditions set
// forth on http://hg.ecmascript.org/tests/test262/raw-file/tip/LICENSE (the
// "Use Terms").   Any redistribution of this code must retain the above
// copyright and this notice and otherwise comply with the Use Terms.

/*---
es5id: 15.4.4.15-2-11
description: >
    Array.prototype.lastIndexOf - 'length' is own accessor property
    without a get function on an Array-like object
includes: [runTestCase.js]
---*/

function testcase() {

        var obj = { 0: 1 };
        Object.defineProperty(obj, "length", {
            set: function () { },
            configurable: true
        });

        return Array.prototype.lastIndexOf.call(obj, 1) === -1;
    }
runTestCase(testcase);
