; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=amdgcn -mcpu=hawaii < %s | FileCheck -check-prefixes=CI,CI-SAFE %s
; RUN: llc -march=amdgcn -mcpu=fiji < %s | FileCheck -check-prefixes=VI,VI-SAFE %s
; RUN: llc -march=amdgcn -mcpu=gfx1100 < %s | FileCheck -check-prefixes=GFX11,GFX11-SAFE %s

; RUN: llc -march=amdgcn -mcpu=hawaii -enable-no-signed-zeros-fp-math < %s | FileCheck -check-prefixes=CI,CI-NSZ %s
; RUN: llc -march=amdgcn -mcpu=fiji -enable-no-signed-zeros-fp-math < %s | FileCheck -check-prefixes=VI,VI-NSZ %s
; RUN: llc -march=amdgcn -mcpu=gfx1100 -enable-no-signed-zeros-fp-math < %s | FileCheck -check-prefixes=GFX11,GFX11-NSZ %s

define half @add_select_fabs_fabs_f16(i32 %c, half %x, half %y, half %z) {
; CI-LABEL: add_select_fabs_fabs_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; CI-NEXT:    v_add_f32_e64 v0, |v0|, v3
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fabs_fabs_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-NEXT:    v_add_f16_e64 v0, |v0|, v3
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fabs_fabs_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_f16_e64 v0, |v0|, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fabs.x = call half @llvm.fabs.f16(half %x)
  %fabs.y = call half @llvm.fabs.f16(half %y)
  %select = select i1 %cmp, half %fabs.x, half %fabs.y
  %add = fadd half %select, %z
  ret half %add
}

define { half, half } @add_select_multi_use_lhs_fabs_fabs_f16(i32 %c, half %x, half %y, half %w, half %z) {
; CI-LABEL: add_select_multi_use_lhs_fabs_fabs_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; CI-NEXT:    v_add_f32_e64 v0, |v0|, v4
; CI-NEXT:    v_add_f32_e64 v1, |v1|, v3
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_multi_use_lhs_fabs_fabs_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-NEXT:    v_add_f16_e64 v0, |v0|, v4
; VI-NEXT:    v_add_f16_e64 v1, |v1|, v3
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_multi_use_lhs_fabs_fabs_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc_lo
; GFX11-NEXT:    v_add_f16_e64 v1, |v1|, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_add_f16_e64 v0, |v0|, v4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fabs.x = call half @llvm.fabs.f16(half %x)
  %fabs.y = call half @llvm.fabs.f16(half %y)
  %select = select i1 %cmp, half %fabs.x, half %fabs.y
  %add0 = fadd half %select, %z
  %add1 = fadd half %fabs.x, %w
  %insert.0 = insertvalue { half, half } poison, half %add0, 0
  %insert.1 = insertvalue { half, half } %insert.0, half %add1, 1
  ret { half, half } %insert.1
}

define { half, half } @add_select_multi_store_use_lhs_fabs_fabs_f16(i32 %c, half %x, half %y, half %z) {
; CI-LABEL: add_select_multi_store_use_lhs_fabs_fabs_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v1
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_and_b32_e32 v1, 0x7fffffff, v4
; CI-NEXT:    v_cndmask_b32_e32 v0, v2, v4, vcc
; CI-NEXT:    v_add_f32_e64 v0, |v0|, v3
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_multi_store_use_lhs_fabs_fabs_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_and_b32_e32 v4, 0x7fff, v1
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-NEXT:    v_add_f16_e64 v0, |v0|, v3
; VI-NEXT:    v_mov_b32_e32 v1, v4
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_multi_store_use_lhs_fabs_fabs_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc_lo
; GFX11-NEXT:    v_and_b32_e32 v1, 0x7fff, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_add_f16_e64 v0, |v0|, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fabs.x = call half @llvm.fabs.f16(half %x)
  %fabs.y = call half @llvm.fabs.f16(half %y)
  %select = select i1 %cmp, half %fabs.x, half %fabs.y
  %add0 = fadd half %select, %z
  %insert.0 = insertvalue { half, half } poison, half %add0, 0
  %insert.1 = insertvalue { half, half } %insert.0, half %fabs.x, 1
  ret { half, half } %insert.1
}

define { half, half } @add_select_multi_use_rhs_fabs_fabs_f16(i32 %c, half %x, half %y, half %z, half %w) {
; CI-LABEL: add_select_multi_use_rhs_fabs_fabs_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; CI-NEXT:    v_add_f32_e64 v0, |v0|, v3
; CI-NEXT:    v_add_f32_e64 v1, |v2|, v4
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_multi_use_rhs_fabs_fabs_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-NEXT:    v_add_f16_e64 v0, |v0|, v3
; VI-NEXT:    v_add_f16_e64 v1, |v2|, v4
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_multi_use_rhs_fabs_fabs_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc_lo
; GFX11-NEXT:    v_add_f16_e64 v1, |v2|, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_add_f16_e64 v0, |v0|, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fabs.x = call half @llvm.fabs.f16(half %x)
  %fabs.y = call half @llvm.fabs.f16(half %y)
  %select = select i1 %cmp, half %fabs.x, half %fabs.y
  %add0 = fadd half %select, %z
  %add1 = fadd half %fabs.y, %w
  %insert.0 = insertvalue { half, half } poison, half %add0, 0
  %insert.1 = insertvalue { half, half } %insert.0, half %add1, 1
  ret { half, half } %insert.1
}

define half @add_select_fabs_var_f16(i32 %c, half %x, half %y, half %z) {
; CI-LABEL: add_select_fabs_var_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e64 v1, |v1|
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; CI-NEXT:    v_add_f32_e32 v0, v0, v3
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fabs_var_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v1, 0x7fff, v1
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-NEXT:    v_add_f16_e32 v0, v0, v3
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fabs_var_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v1, 0x7fff, v1
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc_lo
; GFX11-NEXT:    v_add_f16_e32 v0, v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fabs.x = call half @llvm.fabs.f16(half %x)
  %select = select i1 %cmp, half %fabs.x, half %y
  %add = fadd half %select, %z
  ret half %add
}

define half @add_select_fabs_negk_f16(i32 %c, half %x, half %y) {
; CI-LABEL: add_select_fabs_negk_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e64 v1, |v1|
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cndmask_b32_e32 v0, -1.0, v1, vcc
; CI-NEXT:    v_add_f32_e32 v0, v0, v2
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fabs_negk_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v1, 0x7fff, v1
; VI-NEXT:    v_mov_b32_e32 v3, 0xbc00
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; VI-NEXT:    v_add_f16_e32 v0, v0, v2
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fabs_negk_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v1, 0x7fff, v1
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0xbc00, v1, vcc_lo
; GFX11-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fabs = call half @llvm.fabs.f16(half %x)
  %select = select i1 %cmp, half %fabs, half -1.0
  %add = fadd half %select, %y
  ret half %add
}

; FIXME: fabs should fold away
define half @add_select_fabs_negk_negk_f16(i32 %c, half %x) {
; CI-LABEL: add_select_fabs_negk_negk_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e64 v0, -1.0, -2.0, vcc
; CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NEXT:    v_add_f32_e64 v0, |v0|, v1
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fabs_negk_negk_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, 0xbc00
; VI-NEXT:    v_mov_b32_e32 v3, 0xc000
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; VI-NEXT:    v_add_f16_e64 v0, |v0|, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fabs_negk_negk_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v2, 0xc000
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0xbc00, v2, vcc_lo
; GFX11-NEXT:    v_add_f16_e64 v0, |v0|, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %select = select i1 %cmp, half -2.0, half -1.0
  %fabs = call half @llvm.fabs.f16(half %select)
  %add = fadd half %fabs, %x
  ret half %add
}

define half @add_select_posk_posk_f16(i32 %c, half %x) {
; CI-LABEL: add_select_posk_posk_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e64 v0, 1.0, 2.0, vcc
; CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NEXT:    v_add_f32_e32 v0, v0, v1
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_posk_posk_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, 0x3c00
; VI-NEXT:    v_mov_b32_e32 v3, 0x4000
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; VI-NEXT:    v_add_f16_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_posk_posk_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v2, 0x4000
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x3c00, v2, vcc_lo
; GFX11-NEXT:    v_add_f16_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %select = select i1 %cmp, half 2.0, half 1.0
  %add = fadd half %select, %x
  ret half %add
}

define half @add_select_negk_fabs_f16(i32 %c, half %x, half %y) {
; CI-LABEL: add_select_negk_fabs_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e64 v1, |v1|
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cndmask_b32_e32 v0, -1.0, v1, vcc
; CI-NEXT:    v_add_f32_e32 v0, v0, v2
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_negk_fabs_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v1, 0x7fff, v1
; VI-NEXT:    v_mov_b32_e32 v3, 0xbc00
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; VI-NEXT:    v_add_f16_e32 v0, v0, v2
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_negk_fabs_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v1, 0x7fff, v1
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0xbc00, v1, vcc_lo
; GFX11-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fabs = call half @llvm.fabs.f16(half %x)
  %select = select i1 %cmp, half -1.0, half %fabs
  %add = fadd half %select, %y
  ret half %add
}

define half @add_select_negliteralk_fabs_f16(i32 %c, half %x, half %y) {
; CI-LABEL: add_select_negliteralk_fabs_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_mov_b32_e32 v3, 0xc4800000
; CI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e64 v1, |v1|
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; CI-NEXT:    v_add_f32_e32 v0, v0, v2
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_negliteralk_fabs_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v1, 0x7fff, v1
; VI-NEXT:    v_mov_b32_e32 v3, 0xe400
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; VI-NEXT:    v_add_f16_e32 v0, v0, v2
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_negliteralk_fabs_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v1, 0x7fff, v1
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0xe400, v1, vcc_lo
; GFX11-NEXT:    v_add_f16_e32 v0, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fabs = call half @llvm.fabs.f16(half %x)
  %select = select i1 %cmp, half -1024.0, half %fabs
  %add = fadd half %select, %y
  ret half %add
}

define half @add_select_fabs_posk_f16(i32 %c, half %x, half %y) {
; CI-LABEL: add_select_fabs_posk_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cndmask_b32_e32 v0, 1.0, v1, vcc
; CI-NEXT:    v_add_f32_e64 v0, |v0|, v2
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fabs_posk_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v3, 0x3c00
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; VI-NEXT:    v_add_f16_e64 v0, |v0|, v2
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fabs_posk_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x3c00, v1, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_f16_e64 v0, |v0|, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fabs = call half @llvm.fabs.f16(half %x)
  %select = select i1 %cmp, half %fabs, half 1.0
  %add = fadd half %select, %y
  ret half %add
}

define half @add_select_posk_fabs_f16(i32 %c, half %x, half %y) {
; CI-LABEL: add_select_posk_fabs_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cndmask_b32_e32 v0, 1.0, v1, vcc
; CI-NEXT:    v_add_f32_e64 v0, |v0|, v2
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_posk_fabs_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v3, 0x3c00
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; VI-NEXT:    v_add_f16_e64 v0, |v0|, v2
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_posk_fabs_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x3c00, v1, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_f16_e64 v0, |v0|, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fabs = call half @llvm.fabs.f16(half %x)
  %select = select i1 %cmp, half 1.0, half %fabs
  %add = fadd half %select, %y
  ret half %add
}

define half @add_select_fneg_fneg_f16(i32 %c, half %x, half %y, half %z) {
; CI-LABEL: add_select_fneg_fneg_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; CI-NEXT:    v_sub_f32_e32 v0, v3, v0
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fneg_fneg_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-NEXT:    v_sub_f16_e32 v0, v3, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fneg_fneg_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_sub_f16_e32 v0, v3, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fneg.x = fneg half %x
  %fneg.y = fneg half %y
  %select = select i1 %cmp, half %fneg.x, half %fneg.y
  %add = fadd half %select, %z
  ret half %add
}

define { half, half } @add_select_multi_use_lhs_fneg_fneg_f16(i32 %c, half %x, half %y, half %z, half %w) {
; CI-LABEL: add_select_multi_use_lhs_fneg_fneg_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; CI-NEXT:    v_sub_f32_e32 v0, v3, v0
; CI-NEXT:    v_sub_f32_e32 v1, v4, v1
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_multi_use_lhs_fneg_fneg_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-NEXT:    v_sub_f16_e32 v0, v3, v0
; VI-NEXT:    v_sub_f16_e32 v1, v4, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_multi_use_lhs_fneg_fneg_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc_lo
; GFX11-NEXT:    v_sub_f16_e32 v1, v4, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_sub_f16_e32 v0, v3, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fneg.x = fneg half %x
  %fneg.y = fneg half %y
  %select = select i1 %cmp, half %fneg.x, half %fneg.y
  %add0 = fadd half %select, %z
  %add1 = fadd half %fneg.x, %w
  %insert.0 = insertvalue { half, half } poison, half %add0, 0
  %insert.1 = insertvalue { half, half } %insert.0, half %add1, 1
  ret { half, half } %insert.1
}

define { half, half } @add_select_multi_store_use_lhs_fneg_fneg_f16(i32 %c, half %x, half %y, half %z) {
; CI-LABEL: add_select_multi_store_use_lhs_fneg_fneg_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v1
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cvt_f32_f16_e64 v1, -v1
; CI-NEXT:    v_cndmask_b32_e32 v0, v2, v4, vcc
; CI-NEXT:    v_sub_f32_e32 v0, v3, v0
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_multi_store_use_lhs_fneg_fneg_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_xor_b32_e32 v4, 0x8000, v1
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-NEXT:    v_sub_f16_e32 v0, v3, v0
; VI-NEXT:    v_mov_b32_e32 v1, v4
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_multi_store_use_lhs_fneg_fneg_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc_lo
; GFX11-NEXT:    v_xor_b32_e32 v1, 0x8000, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_sub_f16_e32 v0, v3, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fneg.x = fneg half %x
  %fneg.y = fneg half %y
  %select = select i1 %cmp, half %fneg.x, half %fneg.y
  %add0 = fadd half %select, %z
  %insert.0 = insertvalue { half, half } poison, half %add0, 0
  %insert.1 = insertvalue { half, half } %insert.0, half %fneg.x, 1
  ret { half, half } %insert.1
}

define { half, half } @add_select_multi_use_rhs_fneg_fneg_f16(i32 %c, half %x, half %y, half %z, half %w) {
; CI-LABEL: add_select_multi_use_rhs_fneg_fneg_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; CI-NEXT:    v_sub_f32_e32 v0, v3, v0
; CI-NEXT:    v_sub_f32_e32 v1, v4, v2
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_multi_use_rhs_fneg_fneg_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-NEXT:    v_sub_f16_e32 v0, v3, v0
; VI-NEXT:    v_sub_f16_e32 v1, v4, v2
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_multi_use_rhs_fneg_fneg_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc_lo
; GFX11-NEXT:    v_sub_f16_e32 v1, v4, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_sub_f16_e32 v0, v3, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fneg.x = fneg half %x
  %fneg.y = fneg half %y
  %select = select i1 %cmp, half %fneg.x, half %fneg.y
  %add0 = fadd half %select, %z
  %add1 = fadd half %fneg.y, %w
  %insert.0 = insertvalue { half, half } poison, half %add0, 0
  %insert.1 = insertvalue { half, half } %insert.0, half %add1, 1
  ret { half, half } %insert.1
}

define half @add_select_fneg_var_f16(i32 %c, half %x, half %y, half %z) {
; CI-LABEL: add_select_fneg_var_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e64 v1, -v1
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; CI-NEXT:    v_add_f32_e32 v0, v0, v3
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fneg_var_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_xor_b32_e32 v1, 0x8000, v1
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-NEXT:    v_add_f16_e32 v0, v0, v3
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fneg_var_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_xor_b32_e32 v1, 0x8000, v1
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc_lo
; GFX11-NEXT:    v_add_f16_e32 v0, v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fneg.x = fneg half %x
  %select = select i1 %cmp, half %fneg.x, half %y
  %add = fadd half %select, %z
  ret half %add
}

define half @add_select_fneg_negk_f16(i32 %c, half %x, half %y) {
; CI-LABEL: add_select_fneg_negk_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cndmask_b32_e32 v0, 1.0, v1, vcc
; CI-NEXT:    v_sub_f32_e32 v0, v2, v0
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fneg_negk_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v3, 0x3c00
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; VI-NEXT:    v_sub_f16_e32 v0, v2, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fneg_negk_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x3c00, v1, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_sub_f16_e32 v0, v2, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fneg.x = fneg half %x
  %select = select i1 %cmp, half %fneg.x, half -1.0
  %add = fadd half %select, %y
  ret half %add
}

define half @add_select_fneg_inv2pi_f16(i32 %c, half %x, half %y) {
; CI-LABEL: add_select_fneg_inv2pi_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_mov_b32_e32 v3, 0xbe230000
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; CI-NEXT:    v_sub_f32_e32 v0, v2, v0
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fneg_inv2pi_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v3, 0xb118
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; VI-NEXT:    v_sub_f16_e32 v0, v2, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fneg_inv2pi_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0xb118, v1, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_sub_f16_e32 v0, v2, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fneg.x = fneg half %x
  %select = select i1 %cmp, half %fneg.x, half 0xH3118
  %add = fadd half %select, %y
  ret half %add
}

define half @add_select_fneg_neginv2pi_f16(i32 %c, half %x, half %y) {
; CI-LABEL: add_select_fneg_neginv2pi_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_mov_b32_e32 v3, 0x3e230000
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; CI-NEXT:    v_sub_f32_e32 v0, v2, v0
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fneg_neginv2pi_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v3, 0x3118
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; VI-NEXT:    v_sub_f16_e32 v0, v2, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fneg_neginv2pi_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x3118, v1, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_sub_f16_e32 v0, v2, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fneg.x = fneg half %x
  %select = select i1 %cmp, half %fneg.x, half 0xHB118
  %add = fadd half %select, %y
  ret half %add
}

define half @add_select_negk_negk_f16(i32 %c, half %x) {
; CI-LABEL: add_select_negk_negk_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e64 v0, -1.0, -2.0, vcc
; CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NEXT:    v_add_f32_e32 v0, v0, v1
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_negk_negk_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, 0xbc00
; VI-NEXT:    v_mov_b32_e32 v3, 0xc000
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; VI-NEXT:    v_add_f16_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_negk_negk_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v2, 0xc000
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0xbc00, v2, vcc_lo
; GFX11-NEXT:    v_add_f16_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %select = select i1 %cmp, half -2.0, half -1.0
  %add = fadd half %select, %x
  ret half %add
}

define half @add_select_negliteralk_negliteralk_f16(i32 %c, half %x) {
; CI-LABEL: add_select_negliteralk_negliteralk_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_mov_b32_e32 v2, 0xc5800000
; CI-NEXT:    v_mov_b32_e32 v3, 0xc5000000
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; CI-NEXT:    v_add_f32_e32 v0, v0, v1
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_negliteralk_negliteralk_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, 0xec00
; VI-NEXT:    v_mov_b32_e32 v3, 0xe800
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; VI-NEXT:    v_add_f16_e32 v0, v0, v1
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_negliteralk_negliteralk_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v2, 0xe800
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0xec00, v2, vcc_lo
; GFX11-NEXT:    v_add_f16_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %select = select i1 %cmp, half -2048.0, half -4096.0
  %add = fadd half %select, %x
  ret half %add
}

define half @add_select_fneg_negk_negk_f16(i32 %c, half %x) {
; CI-LABEL: add_select_fneg_negk_negk_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cndmask_b32_e64 v0, -1.0, -2.0, vcc
; CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NEXT:    v_sub_f32_e32 v0, v1, v0
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fneg_negk_negk_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v2, 0xbc00
; VI-NEXT:    v_mov_b32_e32 v3, 0xc000
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v3, vcc
; VI-NEXT:    v_sub_f16_e32 v0, v1, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fneg_negk_negk_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v2, 0xc000
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0xbc00, v2, vcc_lo
; GFX11-NEXT:    v_sub_f16_e32 v0, v1, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %select = select i1 %cmp, half -2.0, half -1.0
  %fneg.x = fneg half %select
  %add = fadd half %fneg.x, %x
  ret half %add
}

define half @add_select_negk_fneg_f16(i32 %c, half %x, half %y) {
; CI-LABEL: add_select_negk_fneg_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cndmask_b32_e32 v0, 1.0, v1, vcc
; CI-NEXT:    v_sub_f32_e32 v0, v2, v0
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_negk_fneg_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v3, 0x3c00
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; VI-NEXT:    v_sub_f16_e32 v0, v2, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_negk_fneg_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x3c00, v1, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_sub_f16_e32 v0, v2, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fneg.x = fneg half %x
  %select = select i1 %cmp, half -1.0, half %fneg.x
  %add = fadd half %select, %y
  ret half %add
}

define half @add_select_fneg_posk_f16(i32 %c, half %x, half %y) {
; CI-LABEL: add_select_fneg_posk_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cndmask_b32_e32 v0, -1.0, v1, vcc
; CI-NEXT:    v_sub_f32_e32 v0, v2, v0
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fneg_posk_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v3, 0xbc00
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; VI-NEXT:    v_sub_f16_e32 v0, v2, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fneg_posk_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0xbc00, v1, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_sub_f16_e32 v0, v2, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fneg.x = fneg half %x
  %select = select i1 %cmp, half %fneg.x, half 1.0
  %add = fadd half %select, %y
  ret half %add
}

define half @add_select_posk_fneg_f16(i32 %c, half %x, half %y) {
; CI-LABEL: add_select_posk_fneg_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cndmask_b32_e32 v0, -1.0, v1, vcc
; CI-NEXT:    v_sub_f32_e32 v0, v2, v0
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_posk_fneg_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v3, 0xbc00
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; VI-NEXT:    v_sub_f16_e32 v0, v2, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_posk_fneg_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0xbc00, v1, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_sub_f16_e32 v0, v2, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fneg.x = fneg half %x
  %select = select i1 %cmp, half 1.0, half %fneg.x
  %add = fadd half %select, %y
  ret half %add
}

define half @add_select_negfabs_fabs_f16(i32 %c, half %x, half %y, half %z) {
; CI-LABEL: add_select_negfabs_fabs_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e64 v1, -|v1|
; CI-NEXT:    v_cvt_f32_f16_e64 v2, |v2|
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; CI-NEXT:    v_add_f32_e32 v0, v0, v3
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_negfabs_fabs_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_or_b32_e32 v1, 0x8000, v1
; VI-NEXT:    v_and_b32_e32 v2, 0x7fff, v2
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-NEXT:    v_add_f16_e32 v0, v0, v3
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_negfabs_fabs_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_or_b32_e32 v1, 0x8000, v1
; GFX11-NEXT:    v_and_b32_e32 v2, 0x7fff, v2
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc_lo
; GFX11-NEXT:    v_add_f16_e32 v0, v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fabs.x = call half @llvm.fabs.f16(half %x)
  %fneg.fabs.x = fsub half -0.000000e+00, %fabs.x
  %fabs.y = call half @llvm.fabs.f16(half %y)
  %select = select i1 %cmp, half %fneg.fabs.x, half %fabs.y
  %add = fadd half %select, %z
  ret half %add
}

define half @add_select_fabs_negfabs_f16(i32 %c, half %x, half %y, half %z) {
; CI-LABEL: add_select_fabs_negfabs_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e64 v1, |v1|
; CI-NEXT:    v_cvt_f32_f16_e64 v2, -|v2|
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; CI-NEXT:    v_add_f32_e32 v0, v0, v3
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fabs_negfabs_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v1, 0x7fff, v1
; VI-NEXT:    v_or_b32_e32 v2, 0x8000, v2
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-NEXT:    v_add_f16_e32 v0, v0, v3
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fabs_negfabs_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v1, 0x7fff, v1
; GFX11-NEXT:    v_or_b32_e32 v2, 0x8000, v2
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc_lo
; GFX11-NEXT:    v_add_f16_e32 v0, v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fabs.x = call half @llvm.fabs.f16(half %x)
  %fabs.y = call half @llvm.fabs.f16(half %y)
  %fneg.fabs.y = fsub half -0.000000e+00, %fabs.y
  %select = select i1 %cmp, half %fabs.x, half %fneg.fabs.y
  %add = fadd half %select, %z
  ret half %add
}

define half @add_select_neg_fabs_f16(i32 %c, half %x, half %y, half %z) {
; CI-LABEL: add_select_neg_fabs_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e64 v1, -v1
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NEXT:    v_cvt_f32_f16_e64 v2, |v2|
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; CI-NEXT:    v_add_f32_e32 v0, v0, v3
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_neg_fabs_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_xor_b32_e32 v1, 0x8000, v1
; VI-NEXT:    v_and_b32_e32 v2, 0x7fff, v2
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-NEXT:    v_add_f16_e32 v0, v0, v3
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_neg_fabs_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_xor_b32_e32 v1, 0x8000, v1
; GFX11-NEXT:    v_and_b32_e32 v2, 0x7fff, v2
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc_lo
; GFX11-NEXT:    v_add_f16_e32 v0, v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fneg.x = fsub half -0.000000e+00, %x
  %fabs.y = call half @llvm.fabs.f16(half %y)
  %select = select i1 %cmp, half %fneg.x, half %fabs.y
  %add = fadd half %select, %z
  ret half %add
}

define half @add_select_fabs_neg_f16(i32 %c, half %x, half %y, half %z) {
; CI-LABEL: add_select_fabs_neg_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e64 v2, -v2
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e64 v1, |v1|
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; CI-NEXT:    v_add_f32_e32 v0, v0, v3
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_fabs_neg_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v1, 0x7fff, v1
; VI-NEXT:    v_xor_b32_e32 v2, 0x8000, v2
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-NEXT:    v_add_f16_e32 v0, v0, v3
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_fabs_neg_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v1, 0x7fff, v1
; GFX11-NEXT:    v_xor_b32_e32 v2, 0x8000, v2
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc_lo
; GFX11-NEXT:    v_add_f16_e32 v0, v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fabs.x = call half @llvm.fabs.f16(half %x)
  %fneg.y = fsub half -0.000000e+00, %y
  %select = select i1 %cmp, half %fabs.x, half %fneg.y
  %add = fadd half %select, %z
  ret half %add
}

define half @add_select_neg_negfabs_f16(i32 %c, half %x, half %y, half %z) {
; CI-LABEL: add_select_neg_negfabs_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NEXT:    v_cvt_f32_f16_e64 v2, |v2|
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; CI-NEXT:    v_sub_f32_e32 v0, v3, v0
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_neg_negfabs_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v2, 0x7fff, v2
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-NEXT:    v_sub_f16_e32 v0, v3, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_neg_negfabs_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v2, 0x7fff, v2
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc_lo
; GFX11-NEXT:    v_sub_f16_e32 v0, v3, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fneg.x = fsub half -0.000000e+00, %x
  %fabs.y = call half @llvm.fabs.f16(half %y)
  %fneg.fabs.y = fsub half -0.000000e+00, %fabs.y
  %select = select i1 %cmp, half %fneg.x, half %fneg.fabs.y
  %add = fadd half %select, %z
  ret half %add
}

define half @add_select_negfabs_neg_f16(i32 %c, half %x, half %y, half %z) {
; CI-LABEL: add_select_negfabs_neg_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e64 v1, |v1|
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; CI-NEXT:    v_sub_f32_e32 v0, v3, v0
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: add_select_negfabs_neg_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_and_b32_e32 v1, 0x7fff, v1
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc
; VI-NEXT:    v_sub_f16_e32 v0, v3, v0
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: add_select_negfabs_neg_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v1, 0x7fff, v1
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v1, v2, vcc_lo
; GFX11-NEXT:    v_sub_f16_e32 v0, v3, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fabs.x = call half @llvm.fabs.f16(half %x)
  %fneg.fabs.x = fsub half -0.000000e+00, %fabs.x
  %fneg.y = fsub half -0.000000e+00, %y
  %select = select i1 %cmp, half %fneg.y, half %fneg.fabs.x
  %add = fadd half %select, %z
  ret half %add
}

define half @mul_select_negfabs_posk_f16(i32 %c, half %x, half %y) {
; CI-LABEL: mul_select_negfabs_posk_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e64 v1, -|v1|
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cndmask_b32_e32 v0, 4.0, v1, vcc
; CI-NEXT:    v_mul_f32_e32 v0, v0, v2
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: mul_select_negfabs_posk_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_or_b32_e32 v1, 0x8000, v1
; VI-NEXT:    v_mov_b32_e32 v3, 0x4400
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; VI-NEXT:    v_mul_f16_e32 v0, v0, v2
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: mul_select_negfabs_posk_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_or_b32_e32 v1, 0x8000, v1
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x4400, v1, vcc_lo
; GFX11-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fabs.x = call half @llvm.fabs.f16(half %x)
  %fneg.fabs.x = fsub half -0.000000e+00, %fabs.x
  %select = select i1 %cmp, half %fneg.fabs.x, half 4.0
  %add = fmul half %select, %y
  ret half %add
}

define half @mul_select_posk_negfabs_f16(i32 %c, half %x, half %y) {
; CI-LABEL: mul_select_posk_negfabs_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e64 v1, -|v1|
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cndmask_b32_e32 v0, 4.0, v1, vcc
; CI-NEXT:    v_mul_f32_e32 v0, v0, v2
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: mul_select_posk_negfabs_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_or_b32_e32 v1, 0x8000, v1
; VI-NEXT:    v_mov_b32_e32 v3, 0x4400
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; VI-NEXT:    v_mul_f16_e32 v0, v0, v2
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: mul_select_posk_negfabs_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_or_b32_e32 v1, 0x8000, v1
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x4400, v1, vcc_lo
; GFX11-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fabs.x = call half @llvm.fabs.f16(half %x)
  %fneg.fabs.x = fsub half -0.000000e+00, %fabs.x
  %select = select i1 %cmp, half 4.0, half %fneg.fabs.x
  %add = fmul half %select, %y
  ret half %add
}

define half @mul_select_negfabs_negk_f16(i32 %c, half %x, half %y) {
; CI-LABEL: mul_select_negfabs_negk_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e64 v1, -|v1|
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cndmask_b32_e32 v0, -4.0, v1, vcc
; CI-NEXT:    v_mul_f32_e32 v0, v0, v2
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: mul_select_negfabs_negk_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_or_b32_e32 v1, 0x8000, v1
; VI-NEXT:    v_mov_b32_e32 v3, 0xc400
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; VI-NEXT:    v_mul_f16_e32 v0, v0, v2
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: mul_select_negfabs_negk_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_or_b32_e32 v1, 0x8000, v1
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0xc400, v1, vcc_lo
; GFX11-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fabs.x = call half @llvm.fabs.f16(half %x)
  %fneg.fabs.x = fsub half -0.000000e+00, %fabs.x
  %select = select i1 %cmp, half %fneg.fabs.x, half -4.0
  %add = fmul half %select, %y
  ret half %add
}

define half @mul_select_negk_negfabs_f16(i32 %c, half %x, half %y) {
; CI-LABEL: mul_select_negk_negfabs_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e64 v1, -|v1|
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cndmask_b32_e32 v0, -4.0, v1, vcc
; CI-NEXT:    v_mul_f32_e32 v0, v0, v2
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: mul_select_negk_negfabs_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_or_b32_e32 v1, 0x8000, v1
; VI-NEXT:    v_mov_b32_e32 v3, 0xc400
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v3, v1, vcc
; VI-NEXT:    v_mul_f16_e32 v0, v0, v2
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: mul_select_negk_negfabs_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_or_b32_e32 v1, 0x8000, v1
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0xc400, v1, vcc_lo
; GFX11-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fabs.x = call half @llvm.fabs.f16(half %x)
  %fneg.fabs.x = fsub half -0.000000e+00, %fabs.x
  %select = select i1 %cmp, half -4.0, half %fneg.fabs.x
  %add = fmul half %select, %y
  ret half %add
}

; --------------------------------------------------------------------------------
; Don't fold if fneg can fold into the source
; --------------------------------------------------------------------------------

define half @select_fneg_posk_src_add_f16(i32 %c, half %x, half %y) {
; CI-SAFE-LABEL: select_fneg_posk_src_add_f16:
; CI-SAFE:       ; %bb.0:
; CI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-SAFE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-SAFE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-SAFE-NEXT:    v_add_f32_e32 v1, 4.0, v1
; CI-SAFE-NEXT:    v_cndmask_b32_e64 v0, 2.0, -v1, vcc
; CI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: select_fneg_posk_src_add_f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_add_f16_e32 v1, 4.0, v1
; VI-SAFE-NEXT:    v_xor_b32_e32 v1, 0x8000, v1
; VI-SAFE-NEXT:    v_mov_b32_e32 v2, 0x4000
; VI-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-SAFE-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: select_fneg_posk_src_add_f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_add_f16_e32 v1, 4.0, v1
; GFX11-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v1, 0x8000, v1
; GFX11-SAFE-NEXT:    v_cndmask_b32_e32 v0, 0x4000, v1, vcc_lo
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; CI-NSZ-LABEL: select_fneg_posk_src_add_f16:
; CI-NSZ:       ; %bb.0:
; CI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NSZ-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NSZ-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NSZ-NEXT:    v_sub_f32_e32 v1, -4.0, v1
; CI-NSZ-NEXT:    v_cndmask_b32_e32 v0, 2.0, v1, vcc
; CI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: select_fneg_posk_src_add_f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_sub_f16_e32 v1, -4.0, v1
; VI-NSZ-NEXT:    v_mov_b32_e32 v2, 0x4000
; VI-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NSZ-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: select_fneg_posk_src_add_f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_sub_f16_e32 v1, -4.0, v1
; GFX11-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NSZ-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NSZ-NEXT:    v_cndmask_b32_e32 v0, 0x4000, v1, vcc_lo
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %add = fadd half %x, 4.0
  %fneg = fneg half %add
  %select = select i1 %cmp, half %fneg, half 2.0
  ret half %select
}

define half @select_fneg_posk_src_sub_f16(i32 %c, half %x) {
; CI-SAFE-LABEL: select_fneg_posk_src_sub_f16:
; CI-SAFE:       ; %bb.0:
; CI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-SAFE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-SAFE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-SAFE-NEXT:    v_add_f32_e32 v1, -4.0, v1
; CI-SAFE-NEXT:    v_cndmask_b32_e64 v0, 2.0, -v1, vcc
; CI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: select_fneg_posk_src_sub_f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_add_f16_e32 v1, -4.0, v1
; VI-SAFE-NEXT:    v_xor_b32_e32 v1, 0x8000, v1
; VI-SAFE-NEXT:    v_mov_b32_e32 v2, 0x4000
; VI-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-SAFE-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: select_fneg_posk_src_sub_f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_add_f16_e32 v1, -4.0, v1
; GFX11-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v1, 0x8000, v1
; GFX11-SAFE-NEXT:    v_cndmask_b32_e32 v0, 0x4000, v1, vcc_lo
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; CI-NSZ-LABEL: select_fneg_posk_src_sub_f16:
; CI-NSZ:       ; %bb.0:
; CI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NSZ-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NSZ-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NSZ-NEXT:    v_sub_f32_e32 v1, 4.0, v1
; CI-NSZ-NEXT:    v_cndmask_b32_e32 v0, 2.0, v1, vcc
; CI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: select_fneg_posk_src_sub_f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_sub_f16_e32 v1, 4.0, v1
; VI-NSZ-NEXT:    v_mov_b32_e32 v2, 0x4000
; VI-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NSZ-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: select_fneg_posk_src_sub_f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_sub_f16_e32 v1, 4.0, v1
; GFX11-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NSZ-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NSZ-NEXT:    v_cndmask_b32_e32 v0, 0x4000, v1, vcc_lo
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %add = fsub half %x, 4.0
  %fneg = fneg half %add
  %select = select i1 %cmp, half %fneg, half 2.0
  ret half %select
}

define half @select_fneg_posk_src_mul_f16(i32 %c, half %x) {
; CI-LABEL: select_fneg_posk_src_mul_f16:
; CI:       ; %bb.0:
; CI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NEXT:    v_mul_f32_e32 v1, -4.0, v1
; CI-NEXT:    v_cndmask_b32_e32 v0, 2.0, v1, vcc
; CI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: select_fneg_posk_src_mul_f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mul_f16_e32 v1, -4.0, v1
; VI-NEXT:    v_mov_b32_e32 v2, 0x4000
; VI-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: select_fneg_posk_src_mul_f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f16_e32 v1, -4.0, v1
; GFX11-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, 0x4000, v1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %mul = fmul half %x, 4.0
  %fneg = fneg half %mul
  %select = select i1 %cmp, half %fneg, half 2.0
  ret half %select
}

define half @select_fneg_posk_src_fma_f16(i32 %c, half %x, half %z) {
; CI-SAFE-LABEL: select_fneg_posk_src_fma_f16:
; CI-SAFE:       ; %bb.0:
; CI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-SAFE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-SAFE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-SAFE-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-SAFE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-SAFE-NEXT:    v_fma_f32 v1, v1, 4.0, v2
; CI-SAFE-NEXT:    v_cndmask_b32_e64 v0, 2.0, -v1, vcc
; CI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: select_fneg_posk_src_fma_f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_fma_f16 v1, v1, 4.0, v2
; VI-SAFE-NEXT:    v_xor_b32_e32 v1, 0x8000, v1
; VI-SAFE-NEXT:    v_mov_b32_e32 v2, 0x4000
; VI-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-SAFE-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: select_fneg_posk_src_fma_f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_fmac_f16_e32 v2, 4.0, v1
; GFX11-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v1, 0x8000, v2
; GFX11-SAFE-NEXT:    v_cndmask_b32_e32 v0, 0x4000, v1, vcc_lo
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; CI-NSZ-LABEL: select_fneg_posk_src_fma_f16:
; CI-NSZ:       ; %bb.0:
; CI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NSZ-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NSZ-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NSZ-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NSZ-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NSZ-NEXT:    v_fma_f32 v1, v1, -4.0, -v2
; CI-NSZ-NEXT:    v_cndmask_b32_e32 v0, 2.0, v1, vcc
; CI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: select_fneg_posk_src_fma_f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_fma_f16 v1, v1, -4.0, -v2
; VI-NSZ-NEXT:    v_mov_b32_e32 v2, 0x4000
; VI-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NSZ-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: select_fneg_posk_src_fma_f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_fma_f16 v1, v1, -4.0, -v2
; GFX11-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NSZ-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NSZ-NEXT:    v_cndmask_b32_e32 v0, 0x4000, v1, vcc_lo
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fma = call half @llvm.fma.f16(half %x, half 4.0, half %z)
  %fneg = fneg half %fma
  %select = select i1 %cmp, half %fneg, half 2.0
  ret half %select
}

define half @select_fneg_posk_src_fmad_f16(i32 %c, half %x, half %z) {
; CI-SAFE-LABEL: select_fneg_posk_src_fmad_f16:
; CI-SAFE:       ; %bb.0:
; CI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-SAFE-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-SAFE-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-SAFE-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-SAFE-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-SAFE-NEXT:    v_mul_f32_e32 v1, 4.0, v1
; CI-SAFE-NEXT:    v_add_f32_e32 v1, v1, v2
; CI-SAFE-NEXT:    v_cndmask_b32_e64 v0, 2.0, -v1, vcc
; CI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SAFE-LABEL: select_fneg_posk_src_fmad_f16:
; VI-SAFE:       ; %bb.0:
; VI-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SAFE-NEXT:    v_fma_f16 v1, v1, 4.0, v2
; VI-SAFE-NEXT:    v_xor_b32_e32 v1, 0x8000, v1
; VI-SAFE-NEXT:    v_mov_b32_e32 v2, 0x4000
; VI-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-SAFE-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SAFE-LABEL: select_fneg_posk_src_fmad_f16:
; GFX11-SAFE:       ; %bb.0:
; GFX11-SAFE-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SAFE-NEXT:    v_fmac_f16_e32 v2, 4.0, v1
; GFX11-SAFE-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-SAFE-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SAFE-NEXT:    v_xor_b32_e32 v1, 0x8000, v2
; GFX11-SAFE-NEXT:    v_cndmask_b32_e32 v0, 0x4000, v1, vcc_lo
; GFX11-SAFE-NEXT:    s_setpc_b64 s[30:31]
;
; CI-NSZ-LABEL: select_fneg_posk_src_fmad_f16:
; CI-NSZ:       ; %bb.0:
; CI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CI-NSZ-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NSZ-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; CI-NSZ-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NSZ-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NSZ-NEXT:    v_mul_f32_e32 v1, -4.0, v1
; CI-NSZ-NEXT:    v_sub_f32_e32 v1, v1, v2
; CI-NSZ-NEXT:    v_cndmask_b32_e32 v0, 2.0, v1, vcc
; CI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; VI-NSZ-LABEL: select_fneg_posk_src_fmad_f16:
; VI-NSZ:       ; %bb.0:
; VI-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NSZ-NEXT:    v_fma_f16 v1, v1, -4.0, -v2
; VI-NSZ-NEXT:    v_mov_b32_e32 v2, 0x4000
; VI-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v0
; VI-NSZ-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; VI-NSZ-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-NSZ-LABEL: select_fneg_posk_src_fmad_f16:
; GFX11-NSZ:       ; %bb.0:
; GFX11-NSZ-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NSZ-NEXT:    v_fma_f16 v1, v1, -4.0, -v2
; GFX11-NSZ-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0, v0
; GFX11-NSZ-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NSZ-NEXT:    v_cndmask_b32_e32 v0, 0x4000, v1, vcc_lo
; GFX11-NSZ-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %c, 0
  %fmad = call half @llvm.fmuladd.f16(half %x, half 4.0, half %z)
  %fneg = fneg half %fmad
  %select = select i1 %cmp, half %fneg, half 2.0
  ret half %select
}

declare half @llvm.fabs.f16(half) #0
declare half @llvm.fma.f16(half, half, half) #0
declare half @llvm.fmuladd.f16(half, half, half) #0

attributes #0 = { nocallback nofree nosync nounwind speculatable willreturn memory(none) }
