#!/bin/bash

. ../../../prepare.inc.sh
. ../../../toolbox.inc.sh

if [ $have_restrict_keyring = 0 ]
then
    toolbox_skip_test $TEST "SKIPPING DUE TO LACK OF KEYRING RESTRICTION"
    exit 0
fi

# ---- certs ----
# Note: 2044-03-06 expiration

# Root CA 1
cacert1="\x30\x82\x03\xac\x30\x82\x02\x94\xa0\x03\x02\x01\x02\x02\x09\x00"
cacert1+="\x8d\x38\x41\x1b\x39\xdd\x00\xf8\x30\x0d\x06\x09\x2a\x86\x48\x86"
cacert1+="\xf7\x0d\x01\x01\x0b\x05\x00\x30\x41\x31\x0d\x30\x0b\x06\x03\x55"
cacert1+="\x04\x0a\x0c\x04\x4f\x72\x67\x31\x31\x10\x30\x0e\x06\x03\x55\x04"
cacert1+="\x03\x0c\x07\x49\x73\x73\x75\x65\x72\x31\x31\x1e\x30\x1c\x06\x09"
cacert1+="\x2a\x86\x48\x86\xf7\x0d\x01\x09\x01\x16\x0f\x63\x61\x31\x40\x65"
cacert1+="\x78\x61\x6d\x70\x6c\x65\x2e\x63\x6f\x6d\x30\x1e\x17\x0d\x31\x36"
cacert1+="\x31\x30\x31\x39\x32\x32\x35\x34\x32\x35\x5a\x17\x0d\x34\x34\x30"
cacert1+="\x33\x30\x36\x32\x32\x35\x34\x32\x35\x5a\x30\x41\x31\x0d\x30\x0b"
cacert1+="\x06\x03\x55\x04\x0a\x0c\x04\x4f\x72\x67\x31\x31\x10\x30\x0e\x06"
cacert1+="\x03\x55\x04\x03\x0c\x07\x49\x73\x73\x75\x65\x72\x31\x31\x1e\x30"
cacert1+="\x1c\x06\x09\x2a\x86\x48\x86\xf7\x0d\x01\x09\x01\x16\x0f\x63\x61"
cacert1+="\x31\x40\x65\x78\x61\x6d\x70\x6c\x65\x2e\x63\x6f\x6d\x30\x82\x01"
cacert1+="\x22\x30\x0d\x06\x09\x2a\x86\x48\x86\xf7\x0d\x01\x01\x01\x05\x00"
cacert1+="\x03\x82\x01\x0f\x00\x30\x82\x01\x0a\x02\x82\x01\x01\x00\xc4\x38"
cacert1+="\x65\x78\x96\x72\x2b\x81\x11\x01\xea\xc0\x30\xe9\xfd\x8f\xa4\x34"
cacert1+="\x49\x0e\x39\x94\x4c\x11\x6f\xa2\x95\xe3\x93\xb9\xdd\x8c\x7f\x8c"
cacert1+="\xb5\xad\xe3\x62\x08\x4f\x8d\x52\x64\xfa\xcb\xdb\xe3\x3b\x58\xc3"
cacert1+="\x71\x3d\x5e\xa3\x4f\xee\xcc\xe4\x7f\x33\xf6\xda\x76\x36\x49\x3b"
cacert1+="\x96\x87\xdb\x24\x77\xf7\x03\xd0\x9b\x58\x4c\x28\x74\x86\x7e\xc2"
cacert1+="\xd2\xea\x34\x67\xdc\xce\x16\x67\xef\xa6\x1e\xbf\xd5\xe1\x55\x0a"
cacert1+="\xa3\x2f\x3b\xe5\x3d\xd6\xdb\x5c\xe8\x6b\xb9\x09\x16\xbe\x5e\x39"
cacert1+="\xdd\xfb\xd6\x60\xfd\x41\x7b\xfa\xe5\x22\x34\x73\xcd\xcd\x71\xd0"
cacert1+="\xca\xbc\xdf\x4d\x60\xb0\x16\xf2\x66\xe0\x79\x1a\xb1\x79\xed\xe2"
cacert1+="\xa8\x21\xec\x7a\xc0\x65\x72\x04\xae\x03\x6a\x34\x8f\x52\x1b\x7d"
cacert1+="\x13\xd6\x01\xb4\x12\x3f\xc0\x00\x9d\x7d\x47\xf2\x2b\x7a\x34\x6c"
cacert1+="\xac\x70\xf0\xcc\xd7\x69\x36\x4e\x77\x8e\x7b\xdb\xa9\xeb\xc7\xfc"
cacert1+="\x47\x2c\x74\xad\x4c\x03\x74\xe1\xa6\x60\x9f\xe1\xc5\xf1\xb4\xa4"
cacert1+="\x65\xbf\xb9\x74\x9c\x22\x36\x8c\xd5\x9e\xef\xdd\x23\x9d\x49\x37"
cacert1+="\x8d\x7a\xdb\xf1\x63\x23\x7e\x06\x8e\x96\x66\x2f\xbd\x5e\xf2\x53"
cacert1+="\xb4\xc7\xb3\x0c\xb2\x85\x46\xf5\x4c\xec\x92\x38\x5d\x33\x02\x03"
cacert1+="\x01\x00\x01\xa3\x81\xa6\x30\x81\xa3\x30\x0f\x06\x03\x55\x1d\x13"
cacert1+="\x04\x08\x30\x06\x01\x01\xff\x02\x01\x00\x30\x1d\x06\x03\x55\x1d"
cacert1+="\x0e\x04\x16\x04\x14\xa6\x90\x37\x33\x55\x73\x58\xcd\x8a\x4c\xaa"
cacert1+="\xcb\x4a\xe7\x54\x0e\x00\x81\x7e\xe8\x30\x71\x06\x03\x55\x1d\x23"
cacert1+="\x04\x6a\x30\x68\x80\x14\xa6\x90\x37\x33\x55\x73\x58\xcd\x8a\x4c"
cacert1+="\xaa\xcb\x4a\xe7\x54\x0e\x00\x81\x7e\xe8\xa1\x45\xa4\x43\x30\x41"
cacert1+="\x31\x0d\x30\x0b\x06\x03\x55\x04\x0a\x0c\x04\x4f\x72\x67\x31\x31"
cacert1+="\x10\x30\x0e\x06\x03\x55\x04\x03\x0c\x07\x49\x73\x73\x75\x65\x72"
cacert1+="\x31\x31\x1e\x30\x1c\x06\x09\x2a\x86\x48\x86\xf7\x0d\x01\x09\x01"
cacert1+="\x16\x0f\x63\x61\x31\x40\x65\x78\x61\x6d\x70\x6c\x65\x2e\x63\x6f"
cacert1+="\x6d\x82\x09\x00\x8d\x38\x41\x1b\x39\xdd\x00\xf8\x30\x0d\x06\x09"
cacert1+="\x2a\x86\x48\x86\xf7\x0d\x01\x01\x0b\x05\x00\x03\x82\x01\x01\x00"
cacert1+="\x85\x84\x97\x71\xd8\x1a\xb5\xc0\x90\xbb\x95\x14\x19\xd7\x76\x30"
cacert1+="\xf8\x42\x02\xad\x7b\x1f\x73\xbe\xf4\x78\x9d\x87\xb1\x99\xcf\xc7"
cacert1+="\x59\xb4\x2f\xf7\x8a\xda\xbb\x07\xa1\x76\x29\x30\x4e\x41\x0f\x7e"
cacert1+="\x97\x9c\xba\xfd\xf4\xc5\x08\x3c\x14\xb0\x7a\x6f\xf1\x67\xb2\xf9"
cacert1+="\xb1\x46\xc8\x83\xfd\xa6\x4f\xc6\x25\x76\xf2\xc1\x11\x92\xba\xfb"
cacert1+="\x25\x85\xe4\x1b\xc6\x92\x79\x63\xc0\x8a\xe7\xfb\x48\x69\x4d\x83"
cacert1+="\x20\xb8\x3d\x8a\x55\xfa\x6d\xe9\x7b\xd1\x96\x75\x0a\x0f\x63\x53"
cacert1+="\x01\x00\xf7\xc3\x28\xa1\xd8\x9e\x41\x6e\x52\xb9\x00\x43\x09\xf2"
cacert1+="\x91\xb7\x06\x5f\xd2\x0c\x42\x03\x67\xd6\x77\xb2\xce\x96\xd4\x73"
cacert1+="\x58\x59\xd9\xf8\x47\xb7\xc7\x23\x96\x65\xeb\xdf\x55\x1b\x1f\xc7"
cacert1+="\xa3\x7c\x7a\x2a\x1b\x95\xec\xf8\xa0\x26\xba\x81\x4b\x94\xb6\x5f"
cacert1+="\xa9\x7d\xb8\x0c\x46\x11\x3a\x70\x3c\xd5\x7c\x60\xd2\x38\x42\x0f"
cacert1+="\xe1\x70\x69\xdc\x4f\x5a\xf9\x65\x45\x97\xbf\x49\xe1\xd2\x59\x5c"
cacert1+="\x8a\xf4\xc4\xe0\x72\xb7\x2d\x4e\xbd\xe6\x69\x9d\x68\x8c\x9c\xfe"
cacert1+="\x4a\xf7\xc0\x0d\xc9\xb9\x92\x50\xff\x5c\x9b\xb9\x9a\x51\xdd\x6c"
cacert1+="\x91\xc7\xa9\x88\x83\xcc\xed\x49\xe7\xcf\x41\xe1\xef\x76\x55\x62"

# Root CA 2
cacert2="\x30\x82\x03\xac\x30\x82\x02\x94\xa0\x03\x02\x01\x02\x02\x09\x00"
cacert2+="\xa7\x75\xd3\x8a\xe3\x8d\x8e\x3c\x30\x0d\x06\x09\x2a\x86\x48\x86"
cacert2+="\xf7\x0d\x01\x01\x0b\x05\x00\x30\x41\x31\x0d\x30\x0b\x06\x03\x55"
cacert2+="\x04\x0a\x0c\x04\x4f\x72\x67\x32\x31\x10\x30\x0e\x06\x03\x55\x04"
cacert2+="\x03\x0c\x07\x49\x73\x73\x75\x65\x72\x32\x31\x1e\x30\x1c\x06\x09"
cacert2+="\x2a\x86\x48\x86\xf7\x0d\x01\x09\x01\x16\x0f\x63\x61\x32\x40\x65"
cacert2+="\x78\x61\x6d\x70\x6c\x65\x2e\x63\x6f\x6d\x30\x1e\x17\x0d\x31\x36"
cacert2+="\x31\x30\x31\x39\x32\x32\x35\x34\x32\x35\x5a\x17\x0d\x34\x34\x30"
cacert2+="\x33\x30\x36\x32\x32\x35\x34\x32\x35\x5a\x30\x41\x31\x0d\x30\x0b"
cacert2+="\x06\x03\x55\x04\x0a\x0c\x04\x4f\x72\x67\x32\x31\x10\x30\x0e\x06"
cacert2+="\x03\x55\x04\x03\x0c\x07\x49\x73\x73\x75\x65\x72\x32\x31\x1e\x30"
cacert2+="\x1c\x06\x09\x2a\x86\x48\x86\xf7\x0d\x01\x09\x01\x16\x0f\x63\x61"
cacert2+="\x32\x40\x65\x78\x61\x6d\x70\x6c\x65\x2e\x63\x6f\x6d\x30\x82\x01"
cacert2+="\x22\x30\x0d\x06\x09\x2a\x86\x48\x86\xf7\x0d\x01\x01\x01\x05\x00"
cacert2+="\x03\x82\x01\x0f\x00\x30\x82\x01\x0a\x02\x82\x01\x01\x00\xa5\xdf"
cacert2+="\x33\xab\xa3\xb0\x60\xb5\x8e\x7f\xdf\x58\xfd\x71\xa0\x39\x40\x7a"
cacert2+="\x4f\xf6\xc8\xec\xbe\xa7\x18\x4b\x4d\xd3\x73\x52\xca\xfa\xee\xa0"
cacert2+="\x06\x21\xd8\x52\xf5\x40\x62\xc1\x4e\xd3\x6d\x9c\xc3\x12\x57\x78"
cacert2+="\x15\x68\x67\x61\x4e\xfd\xfa\x71\xb6\xdc\xf9\x77\x36\x8f\x51\x1c"
cacert2+="\x0a\x19\x42\x8a\x95\x6c\xf8\x2f\xd2\x1a\xe7\x39\x4c\xcd\x07\x62"
cacert2+="\x12\x36\x8a\x5b\x97\x9b\x7a\x94\xce\x4c\x99\x36\x88\xc6\x17\x2c"
cacert2+="\x91\xcd\x95\xa1\x48\x76\x9a\x22\xf8\x87\x84\xde\xc6\xae\x03\xa9"
cacert2+="\x34\x93\xd8\xb3\x4c\x5f\xfb\x8b\x12\x0a\xc5\xad\xa4\x40\x56\xb6"
cacert2+="\x44\x54\x50\xcb\x57\xe0\xb3\x77\x9d\xe2\x10\xa6\xb8\xfc\x21\x67"
cacert2+="\x90\x61\x30\xbe\xfc\x84\xb3\x3a\x1f\x31\x1a\x8a\xc6\x37\x29\x3a"
cacert2+="\x82\x8a\x1a\xa0\xcb\xa0\x65\x8a\x0e\x7d\xae\x03\x5c\x35\xa4\x64"
cacert2+="\x5a\x79\xdd\xe1\xf7\x87\x91\xac\xe1\x67\x76\x48\x17\x05\x57\x01"
cacert2+="\xa6\xf9\x36\x09\x3c\x0e\xc2\xa3\xf9\xfb\xbb\x4d\x05\xf3\x92\x42"
cacert2+="\xf5\x4b\x9b\x2c\xab\xd5\xe8\x7c\x0a\x4a\xe6\x85\xba\x95\x28\xc1"
cacert2+="\x04\x46\x94\x15\x1a\xe3\x61\xd5\x0b\x17\x50\xa7\x92\x98\xaa\x6a"
cacert2+="\xe8\x91\x91\xae\x02\x6e\x35\x4b\x41\xcb\xbe\x02\xad\xb1\x02\x03"
cacert2+="\x01\x00\x01\xa3\x81\xa6\x30\x81\xa3\x30\x0f\x06\x03\x55\x1d\x13"
cacert2+="\x04\x08\x30\x06\x01\x01\xff\x02\x01\x00\x30\x1d\x06\x03\x55\x1d"
cacert2+="\x0e\x04\x16\x04\x14\x44\xfb\x94\xd9\x3d\x4a\x0e\x82\x59\xc6\x90"
cacert2+="\xa1\x38\xfa\x0e\x8c\xc4\x4a\x4f\x77\x30\x71\x06\x03\x55\x1d\x23"
cacert2+="\x04\x6a\x30\x68\x80\x14\x44\xfb\x94\xd9\x3d\x4a\x0e\x82\x59\xc6"
cacert2+="\x90\xa1\x38\xfa\x0e\x8c\xc4\x4a\x4f\x77\xa1\x45\xa4\x43\x30\x41"
cacert2+="\x31\x0d\x30\x0b\x06\x03\x55\x04\x0a\x0c\x04\x4f\x72\x67\x32\x31"
cacert2+="\x10\x30\x0e\x06\x03\x55\x04\x03\x0c\x07\x49\x73\x73\x75\x65\x72"
cacert2+="\x32\x31\x1e\x30\x1c\x06\x09\x2a\x86\x48\x86\xf7\x0d\x01\x09\x01"
cacert2+="\x16\x0f\x63\x61\x32\x40\x65\x78\x61\x6d\x70\x6c\x65\x2e\x63\x6f"
cacert2+="\x6d\x82\x09\x00\xa7\x75\xd3\x8a\xe3\x8d\x8e\x3c\x30\x0d\x06\x09"
cacert2+="\x2a\x86\x48\x86\xf7\x0d\x01\x01\x0b\x05\x00\x03\x82\x01\x01\x00"
cacert2+="\x62\xf7\xbc\xd7\x49\x2d\xa2\x47\x8b\x28\xb3\xd4\x3e\xe6\x76\x00"
cacert2+="\x12\xe6\x15\xe2\xf7\xa5\x20\x0f\xcf\xbd\xa9\x8a\x0f\x97\x38\x57"
cacert2+="\xac\x69\x5f\x76\x90\xdb\x52\x0a\x55\xbe\x6a\x34\xb1\x3e\xef\x45"
cacert2+="\xed\x0a\x55\xe9\x46\xdc\x2c\xe2\xd3\x24\x7e\x3b\x10\x38\x72\x38"
cacert2+="\x98\xae\xda\x55\xe0\x33\x7f\x86\x56\xbb\x12\x7a\x5b\x44\x4b\x8d"
cacert2+="\xf5\xd3\xfb\x83\x1b\x07\x08\xab\x0f\x95\x07\x98\x60\xa1\x6e\x6c"
cacert2+="\x0f\xb8\xa2\xe1\x74\xf4\x43\xd3\x91\x8e\xa0\x40\xea\x9b\x54\x3d"
cacert2+="\x71\x1f\x75\xb4\x59\x67\x47\x95\xeb\x2e\xdc\x37\x1d\xd2\xd8\xe6"
cacert2+="\xe5\x3a\x86\x60\xa4\x2a\xb4\x6e\x7e\x34\x09\x2b\x42\x0e\xe7\x3b"
cacert2+="\x83\x5d\xdd\xee\xc9\xa4\x6c\x65\x49\x0b\x59\x1b\x46\xf1\x46\x2e"
cacert2+="\xf7\x37\x0f\x06\xa1\x85\x33\x38\xee\x11\x89\x62\x3f\xf6\x42\x5e"
cacert2+="\x1b\x6c\xfd\xcd\x4b\xa0\x8a\x71\x74\x27\xef\xbb\x6e\xbe\x68\xfc"
cacert2+="\xb6\xcd\x88\xfe\x0e\x92\xec\xfe\x60\xe1\x26\xce\xee\x0a\x48\x6c"
cacert2+="\x93\x1f\x85\x9f\xd8\x81\xa0\xd7\xfc\x35\xe6\xad\x63\x97\xf5\x12"
cacert2+="\x2f\xdb\xf6\x38\x54\x0e\x6e\x7d\xcc\x88\x64\xa9\x4f\xc1\x6d\x60"
cacert2+="\x03\x5d\x4c\x72\x6a\xa3\xf1\x29\xaa\x62\xf4\xa1\x04\x38\x78\xcd"

# Intermediate CA (signed by CA 2)
intcert="\x30\x82\x03\xa9\x30\x82\x02\x91\xa0\x03\x02\x01\x02\x02\x09\x00"
intcert+="\xfe\x1e\xe6\xa8\x4e\x42\xc4\x72\x30\x0d\x06\x09\x2a\x86\x48\x86"
intcert+="\xf7\x0d\x01\x01\x0b\x05\x00\x30\x41\x31\x0d\x30\x0b\x06\x03\x55"
intcert+="\x04\x0a\x0c\x04\x4f\x72\x67\x32\x31\x10\x30\x0e\x06\x03\x55\x04"
intcert+="\x03\x0c\x07\x49\x73\x73\x75\x65\x72\x32\x31\x1e\x30\x1c\x06\x09"
intcert+="\x2a\x86\x48\x86\xf7\x0d\x01\x09\x01\x16\x0f\x63\x61\x32\x40\x65"
intcert+="\x78\x61\x6d\x70\x6c\x65\x2e\x63\x6f\x6d\x30\x1e\x17\x0d\x31\x36"
intcert+="\x31\x30\x31\x39\x32\x32\x35\x34\x32\x35\x5a\x17\x0d\x34\x34\x30"
intcert+="\x33\x30\x36\x32\x32\x35\x34\x32\x35\x5a\x30\x41\x31\x0d\x30\x0b"
intcert+="\x06\x03\x55\x04\x0a\x0c\x04\x4f\x72\x67\x32\x31\x10\x30\x0e\x06"
intcert+="\x03\x55\x04\x03\x0c\x07\x49\x73\x73\x75\x65\x72\x32\x31\x1e\x30"
intcert+="\x1c\x06\x09\x2a\x86\x48\x86\xf7\x0d\x01\x09\x01\x16\x0f\x63\x61"
intcert+="\x32\x40\x65\x78\x61\x6d\x70\x6c\x65\x2e\x63\x6f\x6d\x30\x82\x01"
intcert+="\x22\x30\x0d\x06\x09\x2a\x86\x48\x86\xf7\x0d\x01\x01\x01\x05\x00"
intcert+="\x03\x82\x01\x0f\x00\x30\x82\x01\x0a\x02\x82\x01\x01\x00\xe2\x07"
intcert+="\xfb\x98\x1b\x29\xd7\x82\x9c\x64\xce\x81\xfb\x8b\x2d\xe1\x44\xa0"
intcert+="\x0e\x2e\xc9\xb6\xb8\x16\x7d\x9a\xcf\xa4\xb7\x21\x2f\xdc\x4c\x79"
intcert+="\xfe\xe4\x34\xc8\x94\x93\xdf\x5a\xdd\x94\x33\xf8\xda\x0d\x17\xb7"
intcert+="\x0a\x4d\x82\x72\x9a\x6f\xfa\xac\x3f\x4a\x1b\x78\x1a\x99\xa3\x24"
intcert+="\x66\x0b\xc4\x72\x2a\xe0\xb4\xbd\xd5\xa1\x06\xbf\xdb\xd0\xdf\x8b"
intcert+="\x15\xee\xa9\x18\x50\x7a\x83\x53\x21\xf7\xbb\x4b\xce\x57\xe8\x8b"
intcert+="\x02\x9d\x3a\x73\x3e\x5d\x67\xa5\x11\xde\xec\xc2\x4e\xbe\xfe\x09"
intcert+="\x40\xfd\x22\xb5\x2e\xb2\x2b\xe7\x07\x81\x0c\x72\xf3\xbf\x22\x55"
intcert+="\xaa\xb9\x02\xb9\x48\x8c\x89\xb6\xf3\x5d\x27\x9a\xd5\xc2\x47\xf9"
intcert+="\xb9\x0c\xb5\x90\xbf\x8b\xee\xd8\x8c\x3d\x2d\xbf\xa1\xb0\xcf\xe2"
intcert+="\xd9\x44\x9b\x88\x66\xb3\x6e\xec\xe6\xaa\x2c\x67\x2e\x6f\x2b\x23"
intcert+="\xd6\xe2\xa1\xb1\x7a\x0d\xb1\x50\x30\xe4\x22\xec\xbf\x87\x28\xcc"
intcert+="\xa0\x73\x42\x4a\xdc\x5d\x2b\x37\x7e\x43\x63\x59\x01\xaa\x9e\xc4"
intcert+="\x4b\xfa\x05\x38\x4d\xc2\xde\x41\xb1\x60\xd1\x4b\xfd\x89\x9e\xe0"
intcert+="\xdf\xff\x21\x91\x1c\x6f\xba\x10\xba\x15\xe3\x44\xf0\x1f\xd8\x43"
intcert+="\x2e\x03\xc7\xf3\x51\xa3\x36\xfd\x25\x71\x4b\x87\x65\x5b\x02\x03"
intcert+="\x01\x00\x01\xa3\x81\xa3\x30\x81\xa0\x30\x0c\x06\x03\x55\x1d\x13"
intcert+="\x04\x05\x30\x03\x01\x01\xff\x30\x1d\x06\x03\x55\x1d\x0e\x04\x16"
intcert+="\x04\x14\xf5\x71\x46\x2e\x96\x8c\x27\x3e\x47\xef\xba\x8a\x2c\x1c"
intcert+="\xb5\x15\x88\xa7\x24\x14\x30\x71\x06\x03\x55\x1d\x23\x04\x6a\x30"
intcert+="\x68\x80\x14\x44\xfb\x94\xd9\x3d\x4a\x0e\x82\x59\xc6\x90\xa1\x38"
intcert+="\xfa\x0e\x8c\xc4\x4a\x4f\x77\xa1\x45\xa4\x43\x30\x41\x31\x0d\x30"
intcert+="\x0b\x06\x03\x55\x04\x0a\x0c\x04\x4f\x72\x67\x32\x31\x10\x30\x0e"
intcert+="\x06\x03\x55\x04\x03\x0c\x07\x49\x73\x73\x75\x65\x72\x32\x31\x1e"
intcert+="\x30\x1c\x06\x09\x2a\x86\x48\x86\xf7\x0d\x01\x09\x01\x16\x0f\x63"
intcert+="\x61\x32\x40\x65\x78\x61\x6d\x70\x6c\x65\x2e\x63\x6f\x6d\x82\x09"
intcert+="\x00\xa7\x75\xd3\x8a\xe3\x8d\x8e\x3c\x30\x0d\x06\x09\x2a\x86\x48"
intcert+="\x86\xf7\x0d\x01\x01\x0b\x05\x00\x03\x82\x01\x01\x00\x53\xb3\x9a"
intcert+="\xfa\x63\xdb\x3e\x20\x7b\x8a\xa3\xc0\x8e\x31\x18\x80\x6a\x75\x8b"
intcert+="\x9c\xdc\x34\xfb\xc6\xd2\x52\x4b\x60\x17\x33\x72\x62\xa4\xf8\xfd"
intcert+="\x7d\x19\x52\x88\x25\x5b\xbe\x86\x46\x75\x8b\x77\x21\xe7\x47\x98"
intcert+="\xf5\x8b\xbc\x09\x1a\x33\xa8\xdf\xdb\x98\x5a\x92\x40\x74\x3e\x65"
intcert+="\xd8\x9e\x56\x65\xbb\x62\x26\xa7\x32\xe2\x4b\x03\xd5\x16\xbe\xb6"
intcert+="\xa7\x23\xb2\xe7\x36\x4f\x11\x05\xd1\x1c\x12\x70\x35\x70\xcb\xe6"
intcert+="\x99\xf8\x4b\x3a\x87\x27\xe5\xe6\x08\x5f\x06\x7e\x83\x85\x9a\x34"
intcert+="\xc2\x8a\xfa\x52\x82\xf7\xbd\x71\xac\xc9\xec\x9b\x9a\x70\xa6\x6b"
intcert+="\x2e\xee\x62\xa3\x0c\x07\xd2\xbd\x8a\xfc\x8a\x4b\xe9\x4a\xe9\x11"
intcert+="\xdd\x6e\xbb\x94\xb8\x9b\xc7\x79\x4d\x82\xdd\x0f\x62\x1d\x84\xf7"
intcert+="\x00\xec\x37\xe5\x56\x5f\x39\x18\x85\x0e\xef\x20\xdf\x3f\x97\x96"
intcert+="\x03\x84\x50\x21\x9d\xe0\x00\x44\x19\x82\x58\x6b\x79\xfa\x32\x34"
intcert+="\x65\x4b\xed\x36\xae\x1a\xd8\x78\xae\x59\xf0\xb8\xb7\xb0\xe3\xb4"
intcert+="\x23\x71\xe7\xda\x18\xff\x6d\x6e\x3b\x8b\xc8\x13\x52\x1c\xc5\xff"
intcert+="\x66\xfd\xe1\x7a\x28\xac\x3e\xe5\x0e\x80\x03\x91\xce\x30\x2b\x98"
intcert+="\x3b\x71\x2f\x37\x80\xf1\x29\xbc\xdb\x42\xa1\x6e\xd0"

# End entity cert (signed by CA 2)
signed="\x30\x82\x03\xa3\x30\x82\x02\x8b\xa0\x03\x02\x01\x02\x02\x09\x00"
signed+="\xfe\x1e\xe6\xa8\x4e\x42\xc4\x73\x30\x0d\x06\x09\x2a\x86\x48\x86"
signed+="\xf7\x0d\x01\x01\x0b\x05\x00\x30\x41\x31\x0d\x30\x0b\x06\x03\x55"
signed+="\x04\x0a\x0c\x04\x4f\x72\x67\x32\x31\x10\x30\x0e\x06\x03\x55\x04"
signed+="\x03\x0c\x07\x49\x73\x73\x75\x65\x72\x32\x31\x1e\x30\x1c\x06\x09"
signed+="\x2a\x86\x48\x86\xf7\x0d\x01\x09\x01\x16\x0f\x63\x61\x32\x40\x65"
signed+="\x78\x61\x6d\x70\x6c\x65\x2e\x63\x6f\x6d\x30\x1e\x17\x0d\x31\x36"
signed+="\x31\x30\x31\x39\x32\x32\x35\x34\x32\x35\x5a\x17\x0d\x34\x34\x30"
signed+="\x33\x30\x36\x32\x32\x35\x34\x32\x35\x5a\x30\x3e\x31\x0c\x30\x0a"
signed+="\x06\x03\x55\x04\x0a\x0c\x03\x4f\x72\x67\x31\x0f\x30\x0d\x06\x03"
signed+="\x55\x04\x03\x0c\x06\x49\x73\x73\x75\x65\x72\x31\x1d\x30\x1b\x06"
signed+="\x09\x2a\x86\x48\x86\xf7\x0d\x01\x09\x01\x16\x0e\x65\x65\x40\x65"
signed+="\x78\x61\x6d\x70\x6c\x65\x2e\x63\x6f\x6d\x30\x82\x01\x22\x30\x0d"
signed+="\x06\x09\x2a\x86\x48\x86\xf7\x0d\x01\x01\x01\x05\x00\x03\x82\x01"
signed+="\x0f\x00\x30\x82\x01\x0a\x02\x82\x01\x01\x00\xa2\xc7\x25\x7d\x83"
signed+="\xb3\xbb\x04\x04\xae\xc1\x53\x85\xdc\x61\x4f\xb9\x5c\x80\x03\x86"
signed+="\x4c\x1b\xbe\x57\x39\xb0\x43\x09\x37\xce\x5d\x98\xcc\x74\x38\xa8"
signed+="\xf6\x6f\x6a\x9e\x3d\xd6\x88\x62\x61\x35\x7f\x85\x73\x06\x48\x1e"
signed+="\x65\x69\xc3\xf4\xf3\x6e\xa2\x79\xfa\x12\xd0\x80\xb4\x11\xc6\x8f"
signed+="\x13\xb5\xc4\x42\xe0\x22\x54\x4a\x46\x47\xaf\x61\xcb\x35\xd2\xea"
signed+="\xe9\x5e\x0d\x0e\xc1\x36\x72\x6a\xd3\xa0\x4e\xe9\xf1\x9e\xbd\xbd"
signed+="\x21\xd6\x8d\x0b\x24\x7a\x8b\xc1\xcc\x52\x48\xc9\xb5\x4f\x1c\xe0"
signed+="\xaf\xe3\x8b\x24\xbb\x34\x9f\x8f\x03\x13\xe8\x2e\xee\xd4\xda\x17"
signed+="\x25\x3f\x2d\xf3\x7e\x33\x3f\x97\x42\xef\xaf\x4c\x35\xb8\x02\x60"
signed+="\xc0\x4f\x20\xbe\x97\xb7\xd3\xc3\x38\x73\x14\x7d\x68\x2a\xab\x04"
signed+="\x96\x81\xde\xe6\x5a\x03\x1e\xd6\x07\xe8\x0a\x38\xc0\xf0\x2b\x54"
signed+="\xb2\x9b\xbd\x54\x72\x8e\x97\x76\x5e\x4c\x80\xb8\x19\xf8\x69\x17"
signed+="\x99\x41\xd9\x61\xb5\x9d\x4c\x8d\xbb\x19\x5f\x39\x7e\xc9\x19\x8d"
signed+="\xdc\xa4\x21\xf1\x32\xfe\x89\x9a\xa3\x92\xe5\x76\x73\x64\x67\x29"
signed+="\x34\x4a\x31\x02\xaa\x35\xaf\x88\x06\x0b\x63\x4d\xe4\xa2\x1f\xaa"
signed+="\x48\x9f\x85\xf5\xc4\xd4\x03\x52\x29\xb7\x51\x02\x03\x01\x00\x01"
signed+="\xa3\x81\xa0\x30\x81\x9d\x30\x09\x06\x03\x55\x1d\x13\x04\x02\x30"
signed+="\x00\x30\x1d\x06\x03\x55\x1d\x0e\x04\x16\x04\x14\xfc\x91\xdf\xb8"
signed+="\x99\x8a\x5c\x07\xee\xb6\x32\xcc\x79\x0b\x31\x0a\x3a\xca\x65\x23"
signed+="\x30\x71\x06\x03\x55\x1d\x23\x04\x6a\x30\x68\x80\x14\x44\xfb\x94"
signed+="\xd9\x3d\x4a\x0e\x82\x59\xc6\x90\xa1\x38\xfa\x0e\x8c\xc4\x4a\x4f"
signed+="\x77\xa1\x45\xa4\x43\x30\x41\x31\x0d\x30\x0b\x06\x03\x55\x04\x0a"
signed+="\x0c\x04\x4f\x72\x67\x32\x31\x10\x30\x0e\x06\x03\x55\x04\x03\x0c"
signed+="\x07\x49\x73\x73\x75\x65\x72\x32\x31\x1e\x30\x1c\x06\x09\x2a\x86"
signed+="\x48\x86\xf7\x0d\x01\x09\x01\x16\x0f\x63\x61\x32\x40\x65\x78\x61"
signed+="\x6d\x70\x6c\x65\x2e\x63\x6f\x6d\x82\x09\x00\xa7\x75\xd3\x8a\xe3"
signed+="\x8d\x8e\x3c\x30\x0d\x06\x09\x2a\x86\x48\x86\xf7\x0d\x01\x01\x0b"
signed+="\x05\x00\x03\x82\x01\x01\x00\x36\x04\xff\x32\x8c\x5e\x7b\x2d\x99"
signed+="\x2e\x84\x2f\xae\xed\x82\x96\x99\xe1\x18\xe0\x8c\xe9\x61\x3c\x0f"
signed+="\xb1\xd7\x53\x5e\x24\x84\xe7\xe9\x19\xaa\xfe\xed\x21\x82\x3b\x6c"
signed+="\xf4\xaa\xe9\x0a\x84\x88\x84\x1a\x46\xc7\xc8\x00\x3f\x94\x86\x2c"
signed+="\xc5\x28\xa3\xac\xbd\x8a\x6f\x53\x38\x7f\x06\x12\x51\xbc\x1b\x4d"
signed+="\x2d\xcb\x63\x65\x4b\x74\x42\x4d\xc8\xd6\x56\x03\xfe\x81\x9b\x52"
signed+="\x3a\xc8\xb7\xcc\xd0\x03\x85\xad\x30\x7c\x3d\x73\xd1\x06\x16\x70"
signed+="\x4a\xcc\x15\xa4\x83\xcf\x54\x0f\xd7\xab\x9a\xf0\xb9\x39\x80\x06"
signed+="\x7f\x75\x45\x2e\xec\x76\xb2\xbd\xb8\xfd\xe3\x38\xdb\x18\x2f\x09"
signed+="\xea\xe3\x1c\xfe\xd2\x6c\xab\xae\xaa\x9c\x47\xfb\xe5\xd6\x0d\xd6"
signed+="\x6f\x42\x5f\x0b\xde\xa3\xc1\xb5\xf7\xaf\x5a\xf1\xab\xe8\xc4\x7c"
signed+="\xeb\xaf\x48\xe4\x5d\x61\xa1\x5b\xf1\x28\x8f\xd0\x58\x1d\x9f\x64"
signed+="\x8b\xf8\xf0\x33\xa6\xeb\x0b\xb2\xc5\x62\x09\xd8\x4c\x72\x4d\xae"
signed+="\x04\xc7\x45\xeb\xdc\xa6\xb2\xf0\xfb\x2b\xb0\x81\xb6\x4f\x3e\x12"
signed+="\x56\x61\x42\x74\x64\x66\x90\xb5\x72\x8f\x09\x8a\x8d\x6c\xc7\x02"
signed+="\x0a\xc8\x51\xe0\x11\x00\x3c\xad\xf2\x5b\x29\xeb\x60\x2f\xb4\xdd"
signed+="\x73\xc0\xb7\xdb\x1f\x6d\xb1"

# End entity cert (signed by intermediate CA)
intsigned="\x30\x82\x03\xa4\x30\x82\x02\x8c\xa0\x03\x02\x01\x02\x02\x09\x00"
intsigned+="\xe5\x03\xc2\x77\xbb\xb3\x95\x45\x30\x0d\x06\x09\x2a\x86\x48\x86"
intsigned+="\xf7\x0d\x01\x01\x0b\x05\x00\x30\x41\x31\x0d\x30\x0b\x06\x03\x55"
intsigned+="\x04\x0a\x0c\x04\x4f\x72\x67\x32\x31\x10\x30\x0e\x06\x03\x55\x04"
intsigned+="\x03\x0c\x07\x49\x73\x73\x75\x65\x72\x32\x31\x1e\x30\x1c\x06\x09"
intsigned+="\x2a\x86\x48\x86\xf7\x0d\x01\x09\x01\x16\x0f\x63\x61\x32\x40\x65"
intsigned+="\x78\x61\x6d\x70\x6c\x65\x2e\x63\x6f\x6d\x30\x1e\x17\x0d\x31\x36"
intsigned+="\x31\x30\x31\x39\x32\x32\x35\x34\x32\x35\x5a\x17\x0d\x34\x34\x30"
intsigned+="\x33\x30\x36\x32\x32\x35\x34\x32\x35\x5a\x30\x3f\x31\x0c\x30\x0a"
intsigned+="\x06\x03\x55\x04\x0a\x0c\x03\x4f\x72\x67\x31\x0f\x30\x0d\x06\x03"
intsigned+="\x55\x04\x03\x0c\x06\x49\x73\x73\x75\x65\x72\x31\x1e\x30\x1c\x06"
intsigned+="\x09\x2a\x86\x48\x86\xf7\x0d\x01\x09\x01\x16\x0f\x65\x65\x63\x40"
intsigned+="\x65\x78\x61\x6d\x70\x6c\x65\x2e\x63\x6f\x6d\x30\x82\x01\x22\x30"
intsigned+="\x0d\x06\x09\x2a\x86\x48\x86\xf7\x0d\x01\x01\x01\x05\x00\x03\x82"
intsigned+="\x01\x0f\x00\x30\x82\x01\x0a\x02\x82\x01\x01\x00\x92\xfd\x9d\x2c"
intsigned+="\x31\xf2\xac\x18\xb3\x73\x7c\xf3\x7c\xd1\xea\x59\x48\xb0\xde\x55"
intsigned+="\xc7\xa3\xf6\xbd\xa4\xd7\x34\x86\xb3\x2d\x38\x8c\xb4\x44\xec\xd0"
intsigned+="\x02\xcf\x9a\xff\xf3\xa7\x9b\x44\xd5\x83\x8a\xb5\x0c\x44\xde\x68"
intsigned+="\x14\xc3\x65\xeb\x34\x64\x90\xff\x00\x7e\x1e\x2e\x97\x12\xf3\x94"
intsigned+="\x24\x08\x73\xeb\x59\x2d\x54\x35\x76\x7a\x43\x97\x7c\xe4\xe8\xa0"
intsigned+="\x2c\x20\x5e\x5b\xc8\xaf\xa7\xf7\x0e\x3e\xc4\x4a\x2c\xd6\xd4\x3a"
intsigned+="\x0e\x20\x70\x33\x57\x46\x12\xbe\x89\xd2\x4a\x17\xde\xca\x9a\xde"
intsigned+="\x7f\x40\xa9\x06\x27\x61\xe2\x4b\x3f\xda\x24\x02\x20\x06\x83\xb2"
intsigned+="\x87\x7e\xa0\xf6\xc7\xfd\x4e\x91\xba\x9f\x32\x9b\x61\x32\x0a\xc0"
intsigned+="\xc1\x21\xaa\xce\xfc\xae\x22\xd9\x85\xc6\xeb\x94\xca\xe3\xb3\x05"
intsigned+="\xf6\x00\xa6\xe4\xc8\xf3\xfe\x3e\xb0\xc0\x4d\x1c\x13\x44\xa2\x61"
intsigned+="\xb0\x3d\xaa\xda\xbe\x60\x69\xbc\x91\x24\x96\x33\x0f\x6d\x12\x51"
intsigned+="\x32\x27\xb3\x5e\x04\x02\x81\x5c\x48\x6b\x50\xcb\xad\x91\xe1\xfa"
intsigned+="\xb1\x00\x56\x00\x22\xd6\x1a\xb6\xad\xf0\x1c\x1a\x30\x58\x0c\x45"
intsigned+="\x6e\xd8\xcc\x50\xbb\xe1\x14\x8a\x20\x6b\xc3\x0b\x32\x66\x43\x9e"
intsigned+="\xf4\x49\x52\x79\x41\x59\x49\xff\x2d\xe1\xbc\x49\x02\x03\x01\x00"
intsigned+="\x01\xa3\x81\xa0\x30\x81\x9d\x30\x09\x06\x03\x55\x1d\x13\x04\x02"
intsigned+="\x30\x00\x30\x1d\x06\x03\x55\x1d\x0e\x04\x16\x04\x14\xf7\xde\x3c"
intsigned+="\x11\x91\x03\x2f\x77\xa7\x71\x1b\xa3\xa1\x73\x36\x01\x66\x29\xcc"
intsigned+="\x2b\x30\x71\x06\x03\x55\x1d\x23\x04\x6a\x30\x68\x80\x14\xf5\x71"
intsigned+="\x46\x2e\x96\x8c\x27\x3e\x47\xef\xba\x8a\x2c\x1c\xb5\x15\x88\xa7"
intsigned+="\x24\x14\xa1\x45\xa4\x43\x30\x41\x31\x0d\x30\x0b\x06\x03\x55\x04"
intsigned+="\x0a\x0c\x04\x4f\x72\x67\x32\x31\x10\x30\x0e\x06\x03\x55\x04\x03"
intsigned+="\x0c\x07\x49\x73\x73\x75\x65\x72\x32\x31\x1e\x30\x1c\x06\x09\x2a"
intsigned+="\x86\x48\x86\xf7\x0d\x01\x09\x01\x16\x0f\x63\x61\x32\x40\x65\x78"
intsigned+="\x61\x6d\x70\x6c\x65\x2e\x63\x6f\x6d\x82\x09\x00\xfe\x1e\xe6\xa8"
intsigned+="\x4e\x42\xc4\x72\x30\x0d\x06\x09\x2a\x86\x48\x86\xf7\x0d\x01\x01"
intsigned+="\x0b\x05\x00\x03\x82\x01\x01\x00\xc3\xce\xd4\x43\x63\x19\xa3\xa2"
intsigned+="\x4c\x84\x26\xeb\x62\x88\xb7\xcd\xe1\x83\xff\x61\x49\x54\xcf\x2e"
intsigned+="\xad\x6e\x68\x1f\xe5\x2a\xd8\xd5\x5a\x92\x1a\xa4\x7a\x23\x74\x0a"
intsigned+="\x7d\x75\xf6\xc6\x3c\x79\x14\xe6\x52\xb1\xfd\xdb\x42\x04\xdb\x79"
intsigned+="\xc4\xfa\x74\x4b\x26\x26\x01\xfc\x70\xc4\xa5\xfb\xd4\x89\x63\xd7"
intsigned+="\xf5\x9b\xd5\xae\xf5\xd4\x8b\x3a\x3c\xc6\x51\x36\xff\xf8\xb3\x21"
intsigned+="\x68\x4d\xa2\xd2\x92\xe2\x5e\x78\xc6\x4a\x10\xa5\x88\x7c\x1e\xf2"
intsigned+="\x1c\x68\xdc\xe9\x8f\x58\xb1\xa6\xe5\xc6\x4d\xdb\xf7\xc9\x66\x2f"
intsigned+="\xd8\xc7\x86\x83\x63\x14\xf3\x4e\x2a\x39\xf2\x2d\x50\x3a\x53\x7d"
intsigned+="\xfb\x91\xe4\x54\x7d\x33\xdf\x13\x63\x6f\x21\x9d\x12\xad\x48\x5d"
intsigned+="\xf9\x41\xa1\x10\x80\xcd\x28\x9a\x4c\x82\x60\xae\x66\xc4\x85\x6f"
intsigned+="\x55\x1e\x5d\x97\x49\x60\x1d\xdb\x26\x31\x1e\x0f\x08\x80\x11\x30"
intsigned+="\x0f\x75\xad\x32\xfd\x28\xe4\xb9\x09\x30\x26\x32\xcd\x32\x83\x0c"
intsigned+="\x4b\x51\x4e\x68\x70\xfc\x5b\x52\x9f\x3f\x27\xe7\xe9\xe2\x89\xa9"
intsigned+="\xc0\x45\x42\xc7\xb7\x6d\x93\xb4\x02\xf4\xdb\xfd\x1c\x32\xc9\x25"
intsigned+="\x4d\x4d\xff\xab\x72\xb5\x78\xb9\xd1\xcc\xdb\x73\x39\x6f\x7c\x84"
intsigned+="\x6c\xc9\xf1\xb5\xcb\x81\x53\x8c"

# Self-signed cert
selfsign="\x30\x82\x03\x9d\x30\x82\x02\x85\xa0\x03\x02\x01\x02\x02\x09\x00"
selfsign+="\xe1\xaa\x44\xda\xac\x8f\x12\x04\x30\x0d\x06\x09\x2a\x86\x48\x86"
selfsign+="\xf7\x0d\x01\x01\x0b\x05\x00\x30\x3e\x31\x0c\x30\x0a\x06\x03\x55"
selfsign+="\x04\x0a\x0c\x03\x4f\x72\x67\x31\x0f\x30\x0d\x06\x03\x55\x04\x03"
selfsign+="\x0c\x06\x49\x73\x73\x75\x65\x72\x31\x1d\x30\x1b\x06\x09\x2a\x86"
selfsign+="\x48\x86\xf7\x0d\x01\x09\x01\x16\x0e\x73\x73\x40\x65\x78\x61\x6d"
selfsign+="\x70\x6c\x65\x2e\x63\x6f\x6d\x30\x1e\x17\x0d\x31\x36\x31\x30\x31"
selfsign+="\x39\x32\x32\x35\x34\x32\x35\x5a\x17\x0d\x34\x34\x30\x33\x30\x36"
selfsign+="\x32\x32\x35\x34\x32\x35\x5a\x30\x3e\x31\x0c\x30\x0a\x06\x03\x55"
selfsign+="\x04\x0a\x0c\x03\x4f\x72\x67\x31\x0f\x30\x0d\x06\x03\x55\x04\x03"
selfsign+="\x0c\x06\x49\x73\x73\x75\x65\x72\x31\x1d\x30\x1b\x06\x09\x2a\x86"
selfsign+="\x48\x86\xf7\x0d\x01\x09\x01\x16\x0e\x73\x73\x40\x65\x78\x61\x6d"
selfsign+="\x70\x6c\x65\x2e\x63\x6f\x6d\x30\x82\x01\x22\x30\x0d\x06\x09\x2a"
selfsign+="\x86\x48\x86\xf7\x0d\x01\x01\x01\x05\x00\x03\x82\x01\x0f\x00\x30"
selfsign+="\x82\x01\x0a\x02\x82\x01\x01\x00\xba\x2e\x4e\x75\x7a\x1f\xf9\xe7"
selfsign+="\x58\xda\x54\xb1\xf5\xcf\x26\xad\x1a\x5d\xd6\xa5\xf7\xf1\xe4\xef"
selfsign+="\x2d\x8c\xc9\x03\x69\x39\x55\xbd\xa2\xb1\x8b\x00\xf1\x08\x21\x4b"
selfsign+="\x1d\x47\xff\x88\x2c\x56\x1a\x90\x2b\xaa\x32\x88\xa0\xa7\xd8\x58"
selfsign+="\x5c\x74\xde\xaa\x8a\x17\x89\xc9\x3c\x6b\x17\x97\x90\x82\x8c\xf6"
selfsign+="\xa1\x1e\x1a\x6e\x30\xb3\x56\xad\x4a\xdb\x50\xb3\x0b\xe2\x70\xdd"
selfsign+="\xf2\x61\xf8\xa6\x8c\xf7\xcb\x2a\xb0\xd3\xd3\x14\x3e\xe6\x80\xe3"
selfsign+="\x32\xd9\x25\x5c\x8f\x40\x5e\xb4\x71\x33\xd8\xfc\x1c\x9f\xd0\x95"
selfsign+="\x90\x56\xe6\x7d\x4e\x39\x6d\xc1\x3a\xd9\x28\x9f\x40\xe7\x13\x17"
selfsign+="\x7c\x9d\xdd\x6b\xd0\xf7\xe9\x68\xfa\xc2\x28\xb3\x45\x12\x5b\xfe"
selfsign+="\x57\x72\x6c\x86\x9f\x18\xd6\xb6\x6b\xc8\x7c\x12\xca\x4e\x2f\xc7"
selfsign+="\x25\x88\x92\x4e\x9f\xdd\x02\x6d\x37\x82\xf1\x8b\xd3\xf5\x6f\xf1"
selfsign+="\x4c\xfa\xd8\x80\xe2\x23\xc6\xb7\x8f\x1e\x76\x45\x91\xc5\xf6\x30"
selfsign+="\x48\x9f\xdb\x56\x31\x24\xed\xc8\xfd\x85\x21\x53\x79\xb0\x96\x51"
selfsign+="\x5a\x1e\x82\x21\x95\x5a\x7f\xf1\x32\x25\x7a\x3c\xb4\x16\x6f\x6e"
selfsign+="\xb8\xf2\xf2\xed\x75\xe9\x8b\x7a\xdb\xee\x5c\xf2\x63\x92\x47\xb7"
selfsign+="\x7f\x07\x53\x8e\x14\x5c\x9e\xb3\x02\x03\x01\x00\x01\xa3\x81\x9d"
selfsign+="\x30\x81\x9a\x30\x09\x06\x03\x55\x1d\x13\x04\x02\x30\x00\x30\x1d"
selfsign+="\x06\x03\x55\x1d\x0e\x04\x16\x04\x14\x6a\x1d\x32\xc2\x5a\x0e\x9d"
selfsign+="\xef\xb3\x59\x2e\x0e\xcf\x2e\x99\x4e\x30\x8d\x61\x1a\x30\x6e\x06"
selfsign+="\x03\x55\x1d\x23\x04\x67\x30\x65\x80\x14\x6a\x1d\x32\xc2\x5a\x0e"
selfsign+="\x9d\xef\xb3\x59\x2e\x0e\xcf\x2e\x99\x4e\x30\x8d\x61\x1a\xa1\x42"
selfsign+="\xa4\x40\x30\x3e\x31\x0c\x30\x0a\x06\x03\x55\x04\x0a\x0c\x03\x4f"
selfsign+="\x72\x67\x31\x0f\x30\x0d\x06\x03\x55\x04\x03\x0c\x06\x49\x73\x73"
selfsign+="\x75\x65\x72\x31\x1d\x30\x1b\x06\x09\x2a\x86\x48\x86\xf7\x0d\x01"
selfsign+="\x09\x01\x16\x0e\x73\x73\x40\x65\x78\x61\x6d\x70\x6c\x65\x2e\x63"
selfsign+="\x6f\x6d\x82\x09\x00\xe1\xaa\x44\xda\xac\x8f\x12\x04\x30\x0d\x06"
selfsign+="\x09\x2a\x86\x48\x86\xf7\x0d\x01\x01\x0b\x05\x00\x03\x82\x01\x01"
selfsign+="\x00\xb6\x43\x7f\xb0\x66\xfd\x00\x99\x0e\x23\x9c\x17\x5e\x11\xe5"
selfsign+="\x1f\x24\x85\xee\x5e\x12\x9b\xa0\xb0\x4f\x24\x8f\xf1\xaf\x78\x01"
selfsign+="\x64\xc4\x32\x0c\x97\xb0\x10\x88\xac\x2c\xf1\xe4\x2c\x51\x0f\x16"
selfsign+="\x6b\xd8\x66\xca\x8e\x63\xda\x41\x36\xec\x75\x3d\x99\xe3\x54\x27"
selfsign+="\xd4\x91\xc7\xcf\x6b\x41\xa8\xa6\xd0\x42\x5e\xe0\x93\xb8\x77\xd2"
selfsign+="\x83\x09\xf7\x56\x1e\x03\xb3\x12\x8f\x22\xa6\x50\xfd\x59\x6e\x22"
selfsign+="\x3f\xc5\xe3\x0b\x76\xb7\x8a\x06\x90\x3a\x91\xdd\x74\x02\x42\x00"
selfsign+="\x21\xb6\x1b\x92\xb9\x34\x84\x36\x89\x2c\xba\xf5\x1c\xa1\xfa\x39"
selfsign+="\x95\x44\x5b\xdc\x44\xaf\x53\x79\x5f\x34\x43\xcc\x91\x01\xce\x8d"
selfsign+="\x6b\x33\xbe\xe3\x25\xaf\xb7\xc6\xa7\x46\x3a\xb5\x94\x37\xcc\xd9"
selfsign+="\xdb\x40\x56\x49\x2f\x4d\x5e\xfb\x7d\xab\x09\xf1\x66\xde\xb6\x67"
selfsign+="\x9f\x80\xc7\xa0\xce\x46\x5a\x10\xb4\xf3\x42\x21\x14\x69\x0c\x4e"
selfsign+="\x25\x6f\xd1\x0a\xc1\x33\x27\xcf\x09\x0e\x10\x83\xb9\x3d\x4f\x0c"
selfsign+="\x2f\x29\x2c\xb3\x19\x37\x3d\x57\x0e\xe3\xbe\x53\x8d\x54\x96\xcd"
selfsign+="\x8f\x6f\x1d\x15\x2b\x28\xfa\x4f\x5c\x0c\x4e\x1d\x9d\xf9\x38\x7a"
selfsign+="\x9d\x44\x3d\x85\x89\xee\x70\xb4\xe6\x73\xe7\x36\x33\x21\xa5\x84"
selfsign+="\x18"


# ---- do the actual testing ----

result=PASS
echo "++++ BEGINNING TEST" >$OUTPUTFILE

# create a keyring for CA keys
marker "ADD CA KEYRING"
create_keyring --new=cakeyring ca @s

# create a keyring using the keys in user CA for validation
marker "ADD RESTRICTED USER KEYRING (parent keyring)"
create_keyring --new=restricted_by_keyring rbkr @s
restrict_keyring $restricted_by_keyring "asymmetric" "key_or_keyring:$cakeyring"

# verify cycle detection
marker "REJECT RESTRICTION CYCLE"
restrict_keyring --fail $cakeyring "asymmetric" "key_or_keyring:$restricted_by_keyring"

# confirm that a restricted keyring cannot be restricted again
marker "REJECT REPEATED RESTRICTION"
restrict_keyring --fail $restricted_by_keyring "asymmetric" "builtin_trusted"

# create a keyring using the keys in builtin CA for validation
marker "ADD RESTRICTED BUILTIN KEYRING"
create_keyring --new=restricted_by_builtin rbb @s
restrict_keyring $restricted_by_builtin "asymmetric" "builtin_trusted"

# add CA certificate to CA keyring
marker "ADD USER SIGNED CERT"
pcreate_key --new=cacert1id "-e $cacert1" asymmetric "" $cakeyring

# attempt validation of signed key
marker "REJECT KEY SIGNED BY UNKNOWN CA"
pcreate_key --fail "-e $signed" asymmetric "" $restricted_by_keyring

# attempt validation of signed key
marker "REJECT KEY NOT SIGNED BY BUILTIN"
pcreate_key --fail "-e $signed" asymmetric "" $restricted_by_builtin

# add another CA certificate to CA keyring
marker "ADD SECOND CA KEY"
pcreate_key --new=cacert2id "-e $cacert2" asymmetric "" $cakeyring

# create a keyring restricted on a single key
marker "ADD RESTRICTED USER KEYRING (parent key)"
create_keyring --new=restricted_by_key rbk @s
restrict_keyring $restricted_by_key "asymmetric" "key_or_keyring:$cacert2id"

# attempt validation of signed key
marker "ADD KEY SIGNED BY KNOWN CA"
pcreate_key --new=signedid "-e $signed" asymmetric "" $restricted_by_keyring
link_key $signedid $restricted_by_key

# confirm that self-signed key cannot be added
marker "REJECT SELF-SIGNED KEY"
pcreate_key --fail "-e $selfsign" asymmetric "" $restricted_by_keyring
pcreate_key --fail "-e $selfsign" asymmetric "" $restricted_by_key

# confirm that the keyring restriction cannot be changed
marker "REJECT RESTRICTION CHANGE"
restrict_keyring --fail $restricted_by_key "asymmetric" "builtin_trusted"

# create two self-restricted keyrings
marker "ADD USER KEYRINGS (self)"
create_keyring --new=restricted_by_self1 rbs1 @s
create_keyring --new=restricted_by_self2 rbs2 @s

# add first certificate (treated as root cert) to self-restricted keyrings
marker "ADD FIRST CERT TO SELF-RESTRICTED KEYRINGS"
link_key $signedid $restricted_by_self1
link_key $cacert2id $restricted_by_self2

# apply restrictions
marker "RESTRICT USER KEYRINGS"
restrict_keyring $restricted_by_self1 "asymmetric" "key_or_keyring:0:chain"
restrict_keyring $restricted_by_self2 "asymmetric" "key_or_keyring:0:chain"

# reject certificate addition to self-restricted keyring
marker "REJECT CERTS FOR SELF-RESTRICTED KEYRING"
link_key --fail $cacert2id $restricted_by_self1
pcreate_key --fail "-e $selfsign" asymmetric "" $restricted_by_self1
pcreate_key --fail "-e $selfsign" asymmetric "" $restricted_by_self2

# add certificate to self-restricted keyring
marker "ADD CERT TO SELF-RESTRICTED KEYRING"
link_key $signedid $restricted_by_self2

# check certificate signed using an intermediate CA
marker "ADD INTERMEDIATE SIGNED CERT TO SELF-RESTRICTED KEYRING"
pcreate_key --new=intcertid "-e $intcert" asymmetric "" $restricted_by_self2
pcreate_key --new=intsignedid "-e $intsigned" asymmetric "" $restricted_by_self2

# check intermediate CA with a parent keyring when CA is missing
marker "REJECT INTERMEDIATE SIGNED CERT WITHOUT INTERMEDIATE CA"
create_keyring --new=restricted_by_int restricted_by_int @s
restrict_keyring $restricted_by_int "asymmetric" "key_or_keyring:$cakeyring:chain"
link_key --fail $intsignedid $restricted_by_int

# check intermediate CA with a parent keyring and valid CA
marker "ADD INTERMEDIATE SIGNED CERT WITH INTERMEDIATE CA"
link_key $intcertid $restricted_by_int
link_key $intsignedid $restricted_by_int

# create a fully-restricted keyring (no links allowed)
marker "ADD FULLY-RESTRICTED KEYRING"
create_keyring --new=fully_restricted fr @s
link_key $cacert2id $fully_restricted
restrict_keyring $fully_restricted

# reject certificate addition to fully-restricted keyring
marker "REJECT CERTS FOR FULLY-RESTRICTED KEYRING"
link_key --fail $cacert2id $fully_restricted
pcreate_key --fail "-e $selfsign" asymmetric "" $fully_restricted

echo "++++ FINISHED TEST: $result" >>$OUTPUTFILE

# --- then report the results in the database ---
toolbox_report_result $TEST $result
