/*
 * Decompiled with CFR 0.152.
 */
package org.fedoraproject.xmvn.tools.subst;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.fedoraproject.xmvn.config.Configurator;
import org.fedoraproject.xmvn.config.ResolverSettings;
import org.fedoraproject.xmvn.locator.ServiceLocator;
import org.fedoraproject.xmvn.locator.ServiceLocatorFactory;
import org.fedoraproject.xmvn.metadata.MetadataRequest;
import org.fedoraproject.xmvn.metadata.MetadataResolver;
import org.fedoraproject.xmvn.metadata.MetadataResult;
import org.fedoraproject.xmvn.tools.subst.ArtifactVisitor;
import org.fedoraproject.xmvn.tools.subst.SubstCliRequest;

public class SubstCli {
    private MetadataResolver metadataResolver;
    private ResolverSettings resolverSettings;

    public SubstCli(Configurator configurator, MetadataResolver metadataResolver) {
        this.metadataResolver = metadataResolver;
        this.resolverSettings = configurator.getConfiguration().getResolverSettings();
    }

    private MetadataResult resolveMetadata(List<String> repos) {
        MetadataRequest request = new MetadataRequest(repos);
        request.setIgnoreDuplicates(this.resolverSettings.isIgnoreDuplicateMetadata().booleanValue());
        MetadataResult result = this.metadataResolver.resolveMetadata(request);
        return result;
    }

    private void run(SubstCliRequest cliRequest) {
        ArrayList<MetadataResult> metadataResults = new ArrayList<MetadataResult>();
        if (cliRequest.getRoot() != null) {
            ArrayList<String> metadataRepos = new ArrayList<String>();
            Path root = Paths.get(cliRequest.getRoot(), new String[0]);
            for (String configuredRepo : this.resolverSettings.getMetadataRepositories()) {
                Path repoPath = Paths.get(configuredRepo, new String[0]);
                if (!repoPath.isAbsolute()) continue;
                metadataRepos.add(root.resolve(Paths.get("/", new String[0]).relativize(repoPath)).toString());
            }
            metadataResults.add(this.resolveMetadata(metadataRepos));
        }
        metadataResults.add(this.resolveMetadata(this.resolverSettings.getMetadataRepositories()));
        ArtifactVisitor visitor = new ArtifactVisitor(cliRequest.isDebug(), metadataResults);
        visitor.setTypes(cliRequest.getTypes());
        visitor.setFollowSymlinks(cliRequest.isFollowSymlinks());
        visitor.setDryRun(cliRequest.isDryRun());
        try {
            for (String path : cliRequest.getParameters()) {
                Files.walkFileTree(Paths.get(path, new String[0]), visitor);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (cliRequest.isStrict() && visitor.getFailureCount() > 0) {
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        try {
            SubstCliRequest cliRequest = new SubstCliRequest(args);
            if (cliRequest.isDebug()) {
                System.setProperty("xmvn.debug", "true");
            }
            ServiceLocator locator = new ServiceLocatorFactory().createServiceLocator();
            Configurator configurator = (Configurator)locator.getService(Configurator.class);
            MetadataResolver metadataResolver = (MetadataResolver)locator.getService(MetadataResolver.class);
            SubstCli cli = new SubstCli(configurator, metadataResolver);
            cli.run(cliRequest);
        }
        catch (Throwable e) {
            if (e.getClass().getName().startsWith("org.fedoraproject.xmvn.it.")) {
                throw (RuntimeException)e;
            }
            System.err.println("Unhandled exception");
            e.printStackTrace();
            System.exit(2);
        }
    }
}

