#[allow(unused_imports)]
use once_cell::sync::Lazy;
use paste::paste;

/// A Struct that contains the data for a spinner.
/// Frames is a Vec of &str, each &str is a frame of the spinner.
/// Interval is the number of milliseconds to wait before moving to the next frame.
#[derive(Debug, Clone)]
pub struct SpinnerFrames {
    pub frames: Vec<&'static str>,
    pub interval: u16,
}

macro_rules! spinner_frames {
  ( $name:expr, [ $( $frame:expr ),* ], $interval:expr ) => {
      paste! {
          #[cfg(feature = $name)]
          pub struct [< $name:camel >];

          #[cfg(feature = $name)]
          impl From<[< $name:camel >]> for SpinnerFrames {
              fn from(_: [< $name:camel >]) -> SpinnerFrames {
                  #[cfg(feature = $name)]
                  [< $name:upper >].clone()
              }
          }

          #[cfg(feature = $name)]
          static [< $name:upper >]: Lazy<SpinnerFrames>
              = Lazy::new(|| SpinnerFrames {
                  interval: $interval,
                  frames: vec![$($frame),*]
          });
      }
  };
}

spinner_frames!(
    "dots",
    ["⠋", "⠙", "⠹", "⠸", "⠼", "⠴", "⠦", "⠧", "⠇", "⠏"],
    80
);

spinner_frames!("dots2", ["⣾", "⣽", "⣻", "⢿", "⡿", "⣟", "⣯", "⣷"], 80);

spinner_frames!(
    "dots3",
    ["⠋", "⠙", "⠚", "⠞", "⠖", "⠦", "⠴", "⠲", "⠳", "⠓"],
    80
);

spinner_frames!(
    "dots4",
    [
        "⠄", "⠆", "⠇", "⠋", "⠙", "⠸", "⠰", "⠠", "⠰", "⠸", "⠙", "⠋", "⠇", "⠆"
    ],
    80
);

spinner_frames!(
    "dots5",
    [
        "⠋", "⠙", "⠚", "⠒", "⠂", "⠂", "⠒", "⠲", "⠴", "⠦", "⠖", "⠒", "⠐", "⠐", "⠒", "⠓", "⠋"
    ],
    80
);

spinner_frames!(
    "dots6",
    [
        "⠁", "⠉", "⠙", "⠚", "⠒", "⠂", "⠂", "⠒", "⠲", "⠴", "⠤", "⠄", "⠄", "⠤", "⠴", "⠲", "⠒", "⠂",
        "⠂", "⠒", "⠚", "⠙", "⠉", "⠁"
    ],
    80
);

spinner_frames!(
    "dots7",
    [
        "⠈", "⠉", "⠋", "⠓", "⠒", "⠐", "⠐", "⠒", "⠖", "⠦", "⠤", "⠠", "⠠", "⠤", "⠦", "⠖", "⠒", "⠐",
        "⠐", "⠒", "⠓", "⠋", "⠉", "⠈"
    ],
    80
);
spinner_frames!(
    "dots8",
    [
        "⠁", "⠁", "⠉", "⠙", "⠚", "⠒", "⠂", "⠂", "⠒", "⠲", "⠴", "⠤", "⠄", "⠄", "⠤", "⠠", "⠠", "⠤",
        "⠦", "⠖", "⠒", "⠐", "⠐", "⠒", "⠓", "⠋", "⠉", "⠈", "⠈"
    ],
    80
);
spinner_frames!("dots9", ["⢹", "⢺", "⢼", "⣸", "⣇", "⡧", "⡗", "⡏"], 80);
spinner_frames!("dots10", ["⢄", "⢂", "⢁", "⡁", "⡈", "⡐", "⡠"], 80);
spinner_frames!("dots11", ["⠁", "⠂", "⠄", "⡀", "⢀", "⠠", "⠐", "⠈"], 80);
spinner_frames!(
    "dots12",
    [
        "⢀⠀", "⡀⠀", "⠄⠀", "⢂⠀", "⡂⠀", "⠅⠀", "⢃⠀", "⡃⠀", "⠍⠀", "⢋⠀", "⡋⠀", "⠍⠁", "⢋⠁", "⡋⠁", "⠍⠉",
        "⠋⠉", "⠋⠉", "⠉⠙", "⠉⠙", "⠉⠩", "⠈⢙", "⠈⡙", "⢈⠩", "⡀⢙", "⠄⡙", "⢂⠩", "⡂⢘", "⠅⡘", "⢃⠨", "⡃⢐",
        "⠍⡐", "⢋⠠", "⡋⢀", "⠍⡁", "⢋⠁", "⡋⠁", "⠍⠉", "⠋⠉", "⠋⠉", "⠉⠙", "⠉⠙", "⠉⠩", "⠈⢙", "⠈⡙", "⠈⠩",
        "⠀⢙", "⠀⡙", "⠀⠩", "⠀⢘", "⠀⡘", "⠀⠨", "⠀⢐", "⠀⡐", "⠀⠠", "⠀⢀", "⠀⡀"
    ],
    80
);
spinner_frames!(
    "dots8bit",
    [
        "⠀", "⠁", "⠂", "⠃", "⠄", "⠅", "⠆", "⠇", "⡀", "⡁", "⡂", "⡃", "⡄", "⡅", "⡆", "⡇", "⠈", "⠉",
        "⠊", "⠋", "⠌", "⠍", "⠎", "⠏", "⡈", "⡉", "⡊", "⡋", "⡌", "⡍", "⡎", "⡏", "⠐", "⠑", "⠒", "⠓",
        "⠔", "⠕", "⠖", "⠗", "⡐", "⡑", "⡒", "⡓", "⡔", "⡕", "⡖", "⡗", "⠘", "⠙", "⠚", "⠛", "⠜", "⠝",
        "⠞", "⠟", "⡘", "⡙", "⡚", "⡛", "⡜", "⡝", "⡞", "⡟", "⠠", "⠡", "⠢", "⠣", "⠤", "⠥", "⠦", "⠧",
        "⡠", "⡡", "⡢", "⡣", "⡤", "⡥", "⡦", "⡧", "⠨", "⠩", "⠪", "⠫", "⠬", "⠭", "⠮", "⠯", "⡨", "⡩",
        "⡪", "⡫", "⡬", "⡭", "⡮", "⡯", "⠰", "⠱", "⠲", "⠳", "⠴", "⠵", "⠶", "⠷", "⡰", "⡱", "⡲", "⡳",
        "⡴", "⡵", "⡶", "⡷", "⠸", "⠹", "⠺", "⠻", "⠼", "⠽", "⠾", "⠿", "⡸", "⡹", "⡺", "⡻", "⡼", "⡽",
        "⡾", "⡿", "⢀", "⢁", "⢂", "⢃", "⢄", "⢅", "⢆", "⢇", "⣀", "⣁", "⣂", "⣃", "⣄", "⣅", "⣆", "⣇",
        "⢈", "⢉", "⢊", "⢋", "⢌", "⢍", "⢎", "⢏", "⣈", "⣉", "⣊", "⣋", "⣌", "⣍", "⣎", "⣏", "⢐", "⢑",
        "⢒", "⢓", "⢔", "⢕", "⢖", "⢗", "⣐", "⣑", "⣒", "⣓", "⣔", "⣕", "⣖", "⣗", "⢘", "⢙", "⢚", "⢛",
        "⢜", "⢝", "⢞", "⢟", "⣘", "⣙", "⣚", "⣛", "⣜", "⣝", "⣞", "⣟", "⢠", "⢡", "⢢", "⢣", "⢤", "⢥",
        "⢦", "⢧", "⣠", "⣡", "⣢", "⣣", "⣤", "⣥", "⣦", "⣧", "⢨", "⢩", "⢪", "⢫", "⢬", "⢭", "⢮", "⢯",
        "⣨", "⣩", "⣪", "⣫", "⣬", "⣭", "⣮", "⣯", "⢰", "⢱", "⢲", "⢳", "⢴", "⢵", "⢶", "⢷", "⣰", "⣱",
        "⣲", "⣳", "⣴", "⣵", "⣶", "⣷", "⢸", "⢹", "⢺", "⢻", "⢼", "⢽", "⢾", "⢿", "⣸", "⣹", "⣺", "⣻",
        "⣼", "⣽", "⣾", "⣿"
    ],
    80
);

spinner_frames!("line", ["-", "\\", "|", "/"], 130);

spinner_frames!("line2", ["⠂", "-", "–", "—", "–", "-"], 100);

spinner_frames!("pipe", ["┤", "┘", "┴", "└", "├", "┌", "┬", "┐"], 100);

spinner_frames!("simple_dots", [".  ", ".. ", "...", "   "], 400);

spinner_frames!(
    "simple_dots_scrolling",
    [".  ", ".. ", "...", " ..", "  .", "   "],
    200
);

spinner_frames!("star", ["✶", "✸", "✹", "✺", "✹", "✷"], 70);

spinner_frames!("star2", ["+", "x", "*"], 80);

spinner_frames!(
    "flip",
    ["_", "_", "_", "-", "`", "`", "'", "´", "-", "_", "_", "_"],
    70
);

spinner_frames!("hamburger", ["☱", "☲", "☴"], 100);

spinner_frames!(
    "grow_vertical",
    ["▁", "▃", "▄", "▅", "▆", "▇", "▆", "▅", "▄", "▃"],
    120
);

spinner_frames!(
    "grow_horizontal",
    ["▏", "▎", "▍", "▌", "▋", "▊", "▉", "▊", "▋", "▌", "▍", "▎"],
    120
);

spinner_frames!("balloon", [" ", ".", "o", "O", "@", "*", " "], 140);

spinner_frames!("balloon2", [".", "o", "O", "°", "O", "o", "."], 120);

spinner_frames!("noise", ["▓", "▒", "░"], 100);

spinner_frames!("bounce", ["⠁", "⠂", "⠄", "⠂"], 120);

spinner_frames!("box_bounce", ["▖", "▘", "▝", "▗"], 120);

spinner_frames!("box_bounce2", ["▌", "▀", "▐", "▄"], 100);

spinner_frames!("triangle", ["◢", "◣", "◤", "◥"], 50);

spinner_frames!("arc", ["◜", "◠", "◝", "◞", "◡", "◟"], 100);

spinner_frames!("circle", ["◡", "⊙", "◠"], 120);

spinner_frames!("square_corners", ["◰", "◳", "◲", "◱"], 180);

spinner_frames!("circle_quarters", ["◴", "◷", "◶", "◵"], 120);

spinner_frames!("circle_halves", ["◐", "◓", "◑", "◒"], 50);

spinner_frames!("squish", ["╫", "╪"], 100);

spinner_frames!("toggle", ["⊶", "⊷"], 250);

spinner_frames!("toggle2", ["▫", "▪"], 80);

spinner_frames!("toggle3", ["□", "■"], 120);

spinner_frames!("toggle4", ["■", "□", "▪", "▫"], 100);

spinner_frames!("toggle5", ["▮", "▯"], 100);

spinner_frames!("toggle6", ["ဝ", "၀"], 300);

spinner_frames!("toggle7", ["⦾", "⦿"], 80);

spinner_frames!("toggle8", ["◍", "◌"], 100);

spinner_frames!("toggle9", ["◉", "◎"], 100);

spinner_frames!("toggle10", ["㊂", "㊀", "㊁"], 100);

spinner_frames!("toggle11", ["⧇", "⧆"], 50);

spinner_frames!("toggle12", ["☗", "☖"], 120);

spinner_frames!("toggle13", ["=", "*", "-"], 80);

spinner_frames!("arrow", ["←", "↖", "↑", "↗", "→", "↘", "↓", "↙"], 100);

spinner_frames!(
    "arrow2",
    ["⬆️ ", "↗️ ", "➡️ ", "↘️ ", "⬇️ ", "↙️ ", "⬅️ ", "↖️ "],
    80
);

spinner_frames!(
    "arrow3",
    ["▹▹▹▹▹", "▸▹▹▹▹", "▹▸▹▹▹", "▹▹▸▹▹", "▹▹▹▸▹", "▹▹▹▹▸"],
    120
);

spinner_frames!(
    "bouncing_bar",
    [
        "[    ]", "[=   ]", "[==  ]", "[=== ]", "[ ===]", "[  ==]", "[   =]", "[    ]", "[   =]",
        "[  ==]", "[ ===]", "[====]", "[=== ]", "[==  ]", "[=   ]"
    ],
    80
);

spinner_frames!(
    "bouncing_ball",
    [
        "( ●    )",
        "(  ●   )",
        "(   ●  )",
        "(    ● )",
        "(     ●)",
        "(    ● )",
        "(   ●  )",
        "(  ●   )",
        "( ●    )",
        "(●     )"
    ],
    80
);

spinner_frames!("smiley", ["😄 ", "😝 "], 200);

spinner_frames!("monkey", ["🙈 ", "🙈 ", "🙉 ", "🙊 "], 300);

spinner_frames!("hearts", ["💛 ", "💙 ", "💜 ", "💚 ", "❤️ "], 100);

spinner_frames!(
    "clock",
    ["🕛 ", "🕐 ", "🕑 ", "🕒 ", "🕓 ", "🕔 ", "🕕 "],
    100
);

spinner_frames!(
    "material",
    [
        "█▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁",
        "██▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁",
        "███▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁",
        "████▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁",
        "██████▁▁▁▁▁▁▁▁▁▁▁▁▁▁",
        "██████▁▁▁▁▁▁▁▁▁▁▁▁▁▁",
        "███████▁▁▁▁▁▁▁▁▁▁▁▁▁",
        "████████▁▁▁▁▁▁▁▁▁▁▁▁",
        "█████████▁▁▁▁▁▁▁▁▁▁▁",
        "█████████▁▁▁▁▁▁▁▁▁▁▁",
        "██████████▁▁▁▁▁▁▁▁▁▁",
        "███████████▁▁▁▁▁▁▁▁▁",
        "█████████████▁▁▁▁▁▁▁",
        "██████████████▁▁▁▁▁▁",
        "██████████████▁▁▁▁▁▁",
        "▁██████████████▁▁▁▁▁",
        "▁██████████████▁▁▁▁▁",
        "▁██████████████▁▁▁▁▁",
        "▁▁██████████████▁▁▁▁",
        "▁▁▁██████████████▁▁▁",
        "▁▁▁▁█████████████▁▁▁",
        "▁▁▁▁██████████████▁▁",
        "▁▁▁▁██████████████▁▁",
        "▁▁▁▁▁██████████████▁",
        "▁▁▁▁▁██████████████▁",
        "▁▁▁▁▁██████████████▁",
        "▁▁▁▁▁▁██████████████",
        "▁▁▁▁▁▁██████████████",
        "▁▁▁▁▁▁▁█████████████",
        "▁▁▁▁▁▁▁█████████████",
        "▁▁▁▁▁▁▁▁████████████",
        "▁▁▁▁▁▁▁▁████████████",
        "▁▁▁▁▁▁▁▁▁███████████",
        "▁▁▁▁▁▁▁▁▁███████████",
        "▁▁▁▁▁▁▁▁▁▁██████████",
        "▁▁▁▁▁▁▁▁▁▁██████████",
        "▁▁▁▁▁▁▁▁▁▁▁▁████████",
        "▁▁▁▁▁▁▁▁▁▁▁▁▁███████",
        "▁▁▁▁▁▁▁▁▁▁▁▁▁▁██████",
        "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁█████",
        "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁█████",
        "█▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁████",
        "██▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁███",
        "██▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁███",
        "███▁▁▁▁▁▁▁▁▁▁▁▁▁▁███",
        "████▁▁▁▁▁▁▁▁▁▁▁▁▁▁██",
        "█████▁▁▁▁▁▁▁▁▁▁▁▁▁▁█",
        "█████▁▁▁▁▁▁▁▁▁▁▁▁▁▁█",
        "██████▁▁▁▁▁▁▁▁▁▁▁▁▁█",
        "████████▁▁▁▁▁▁▁▁▁▁▁▁",
        "█████████▁▁▁▁▁▁▁▁▁▁▁",
        "█████████▁▁▁▁▁▁▁▁▁▁▁",
        "█████████▁▁▁▁▁▁▁▁▁▁▁",
        "█████████▁▁▁▁▁▁▁▁▁▁▁",
        "███████████▁▁▁▁▁▁▁▁▁",
        "████████████▁▁▁▁▁▁▁▁",
        "████████████▁▁▁▁▁▁▁▁",
        "██████████████▁▁▁▁▁▁",
        "██████████████▁▁▁▁▁▁",
        "▁██████████████▁▁▁▁▁",
        "▁██████████████▁▁▁▁▁",
        "▁▁▁█████████████▁▁▁▁",
        "▁▁▁▁▁████████████▁▁▁",
        "▁▁▁▁▁████████████▁▁▁",
        "▁▁▁▁▁▁███████████▁▁▁",
        "▁▁▁▁▁▁▁▁█████████▁▁▁",
        "▁▁▁▁▁▁▁▁█████████▁▁▁",
        "▁▁▁▁▁▁▁▁▁█████████▁▁",
        "▁▁▁▁▁▁▁▁▁█████████▁▁",
        "▁▁▁▁▁▁▁▁▁▁█████████▁",
        "▁▁▁▁▁▁▁▁▁▁▁████████▁",
        "▁▁▁▁▁▁▁▁▁▁▁████████▁",
        "▁▁▁▁▁▁▁▁▁▁▁▁███████▁",
        "▁▁▁▁▁▁▁▁▁▁▁▁███████▁",
        "▁▁▁▁▁▁▁▁▁▁▁▁▁███████",
        "▁▁▁▁▁▁▁▁▁▁▁▁▁███████",
        "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁█████",
        "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁████",
        "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁████",
        "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁████",
        "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁███",
        "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁███",
        "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁██",
        "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁██",
        "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁██",
        "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁█",
        "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁█",
        "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁█",
        "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁",
        "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁",
        "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁",
        "▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁▁"
    ],
    17
);

spinner_frames!("earth", ["🌍 ", "🌎 ", "🌏 "], 180);

spinner_frames!(
    "moon",
    ["🌑 ", "🌒 ", "🌓 ", "🌔 ", "🌕 ", "🌖 ", "🌗 ", "🌘 "],
    80
);

spinner_frames!("runner", ["🚶 ", "🏃 "], 140);

spinner_frames!(
    "pong",
    [
        "▐⠂       ▌",
        "▐⠈       ▌",
        "▐ ⠂      ▌",
        "▐ ⠠      ▌",
        "▐  ⡀     ▌",
        "▐  ⠠     ▌",
        "▐   ⠂    ▌",
        "▐   ⠈    ▌",
        "▐    ⠂   ▌",
        "▐    ⠠   ▌",
        "▐     ⡀  ▌",
        "▐     ⠠  ▌",
        "▐      ⠂ ▌",
        "▐      ⠈ ▌",
        "▐       ⠂▌",
        "▐       ⠠▌",
        "▐       ⡀▌",
        "▐      ⠠ ▌",
        "▐      ⠂ ▌",
        "▐     ⠈  ▌",
        "▐     ⠂  ▌",
        "▐    ⠠   ▌",
        "▐    ⡀   ▌",
        "▐   ⠠    ▌",
        "▐   ⠂    ▌",
        "▐  ⠈     ▌",
        "▐  ⠂     ▌",
        "▐ ⠠      ▌",
        "▐ ⡀      ▌",
        "▐⠠       ▌"
    ],
    80
);

spinner_frames!(
    "shark",
    [
        "▐|\\____________▌",
        "▐_|\\___________▌",
        "▐__|\\__________▌",
        "▐___|\\_________▌",
        "▐____|\\________▌",
        "▐_____|\\_______▌",
        "▐______|\\______▌",
        "▐_______|\\_____▌",
        "▐________|\\____▌",
        "▐_________|\\___▌",
        "▐__________|\\__▌",
        "▐___________|\\_▌",
        "▐____________|\\▌",
        "▐____________/|▌",
        "▐___________/|_▌",
        "▐__________/|__▌",
        "▐_________/|___▌",
        "▐________/|____▌",
        "▐_______/|_____▌",
        "▐______/|______▌",
        "▐_____/|_______▌",
        "▐____/|________▌",
        "▐___/|_________▌",
        "▐__/|__________▌",
        "▐_/|___________▌",
        "▐/|____________▌"
    ],
    120
);

spinner_frames!("dqpb", ["d", "q", "p", "b"], 100);

spinner_frames!(
    "weather",
    [
        "☀️ ", "☀️ ", "☀️ ", "🌤 ", "⛅️ ", "🌥 ", "☁️ ", "🌧 ", "🌨 ", "🌧 ", "🌨 ", "🌧 ", "🌨 ", "⛈ ", "🌨 ",
        "🌧 ", "🌨 ", "☁️ ", "🌥 ", "⛅️ ", "🌤 ", "☀️ ", "☀️ "
    ],
    100
);

spinner_frames!("christmas", ["🌲", "🎄"], 400);

spinner_frames!(
    "grenade",
    [
        "،  ", "′  ", " ´ ", " ‾ ", "  ⸌", "  ⸊", "  |", "  ⁎", "  ⁕", " ෴ ", "  ⁓", "   ", "   ",
        "   "
    ],
    80
);

spinner_frames!("point", ["∙∙∙", "●∙∙", "∙●∙", "∙∙●", "∙∙∙"], 125);

spinner_frames!("layer", ["-", "=", "≡"], 150);

spinner_frames!(
    "beta_wave",
    [
        "ρββββββ",
        "βρβββββ",
        "ββρββββ",
        "βββρβββ",
        "ββββρββ",
        "βββββρβ",
        "ββββββρ"
    ],
    80
);

spinner_frames!(
    "finger_dance",
    ["🤘 ", "🤟 ", "🖖 ", "✋ ", "🤚 ", "👆 "],
    160
);

spinner_frames!(
    "fist_bump",
    [
        "🤜　　　　🤛 ",
        "🤜　　　　🤛 ",
        "🤜　　　　🤛 ",
        "　🤜　　🤛　 ",
        "　　🤜🤛　　 ",
        "　🤜✨🤛　　 ",
        "🤜　✨　🤛　 "
    ],
    80
);

spinner_frames!(
    "soccer_header",
    [
        " 🧑⚽️       🧑 ",
        "🧑  ⚽️      🧑 ",
        "🧑   ⚽️     🧑 ",
        "🧑    ⚽️    🧑 ",
        "🧑     ⚽️   🧑 ",
        "🧑      ⚽️  🧑 ",
        "🧑       ⚽️🧑  ",
        "🧑      ⚽️  🧑 ",
        "🧑     ⚽️   🧑 ",
        "🧑    ⚽️    🧑 ",
        "🧑   ⚽️     🧑 ",
        "🧑  ⚽️      🧑 "
    ],
    80
);

spinner_frames!(
    "mindblown",
    [
        "😐 ", "😐 ", "😮 ", "😮 ", "😦 ", "😦 ", "😧 ", "😧 ", "🤯 ", "💥 ", "✨ ", "　 ", "　 ",
        "　 "
    ],
    160
);

spinner_frames!("speaker", ["🔈 ", "🔉 ", "🔊 ", "🔉 "], 160);

spinner_frames!("orange_pulse", ["🔸 ", "🔶 ", "🟠 ", "🟠 ", "🔶 "], 100);
 
spinner_frames!("blue_pulse", ["🔹 ", "🔷 ", "🔵 ", "🔵 ", "🔷 "], 100);

spinner_frames!(
    "orange_blue_pulse",
    ["🔸 ", "🔶 ", "🟠 ", "🟠 ", "🔶 ", "🔹 ", "🔷 ", "🔵 ", "🔵 ", "🔷 "],
    100
);

spinner_frames!(
    "time_travel",
    [
        "🕛 ", "🕚 ", "🕙 ", "🕘 ", "🕗 ", "🕖 ", "🕕 ", "🕔 ", "🕓 ", "🕒 ", "🕑 ", "🕐 "
    ],
    100
);

spinner_frames!(
    "aesthetic",
    [
        "▰▱▱▱▱▱▱",
        "▰▰▱▱▱▱▱",
        "▰▰▰▱▱▱▱",
        "▰▰▰▰▱▱▱",
        "▰▰▰▰▰▱▱",
        "▰▰▰▰▰▰▱",
        "▰▰▰▰▰▰▰",
        "▰▱▱▱▱▱▱"
    ],
    80
);

spinner_frames!(
    "binary",
    ["010010", "001100", "100101", "111010", "111101", "010111"],
    50
);

spinner_frames!(
    "cute",
    [
        "( ´･ω･)",
        "(　´･ω)",
        "( 　´･)",
        "( 　 ´)",
        "(     )",
        "(`　  )",
        "(･`   )",
        "(ω･`　)",
        "(･ω･` )",
        "(´･ω･`)"
    ],
    100
);
