// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

/*
Package metrics contains the code for reporting metrics.

# Directory Structure

The current directory structure looks like

	metrics
	├── doc.go          // this file
	├── genids/
	│   └── main.go     // tool to generate Go code from metrics.json
	├── ids.go          // autogenerated metric IDs
	├── metrics.go      // implement Add() and AddSlice()
	├── metrics_test.go // tests the metrics package
	├── metrics.json    // list of known metrics
	└── types.go        // definitions of Metric, MetricID, MetricValue
*/
package metrics // import "go.opentelemetry.io/ebpf-profiler/metrics"
