// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	v1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
	monitoringv1alpha1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1alpha1"
)

// DNSSDConfigApplyConfiguration represents a declarative configuration of the DNSSDConfig type for use
// with apply.
type DNSSDConfigApplyConfiguration struct {
	Names           []string                          `json:"names,omitempty"`
	RefreshInterval *v1.Duration                      `json:"refreshInterval,omitempty"`
	Type            *monitoringv1alpha1.DNSRecordType `json:"type,omitempty"`
	Port            *int32                            `json:"port,omitempty"`
}

// DNSSDConfigApplyConfiguration constructs a declarative configuration of the DNSSDConfig type for use with
// apply.
func DNSSDConfig() *DNSSDConfigApplyConfiguration {
	return &DNSSDConfigApplyConfiguration{}
}

// WithNames adds the given value to the Names field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Names field.
func (b *DNSSDConfigApplyConfiguration) WithNames(values ...string) *DNSSDConfigApplyConfiguration {
	for i := range values {
		b.Names = append(b.Names, values[i])
	}
	return b
}

// WithRefreshInterval sets the RefreshInterval field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RefreshInterval field is set to the value of the last call.
func (b *DNSSDConfigApplyConfiguration) WithRefreshInterval(value v1.Duration) *DNSSDConfigApplyConfiguration {
	b.RefreshInterval = &value
	return b
}

// WithType sets the Type field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Type field is set to the value of the last call.
func (b *DNSSDConfigApplyConfiguration) WithType(value monitoringv1alpha1.DNSRecordType) *DNSSDConfigApplyConfiguration {
	b.Type = &value
	return b
}

// WithPort sets the Port field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Port field is set to the value of the last call.
func (b *DNSSDConfigApplyConfiguration) WithPort(value int32) *DNSSDConfigApplyConfiguration {
	b.Port = &value
	return b
}
