// SPDX-License-Identifier: Apache-2.0
//
// Copyright The Prometheus Authors
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//go:build windows

package pdh

import "github.com/prometheus/client_golang/prometheus"

// Conversion factors.
const (
	TicksToSecondScaleFactor       = 1 / 1e7
	WindowsEpoch             int64 = 116444736000000000
)

// Based on https://github.com/leoluk/perflib_exporter/blob/master/collector/mapper.go
//
//goland:noinspection GoUnusedConst
const (
	PERF_COUNTER_RAWCOUNT_HEX           = 0x00000000
	PERF_COUNTER_LARGE_RAWCOUNT_HEX     = 0x00000100
	PERF_COUNTER_TEXT                   = 0x00000b00
	PERF_COUNTER_RAWCOUNT               = 0x00010000
	PERF_COUNTER_LARGE_RAWCOUNT         = 0x00010100
	PERF_DOUBLE_RAW                     = 0x00012000
	PERF_COUNTER_DELTA                  = 0x00400400
	PERF_COUNTER_LARGE_DELTA            = 0x00400500
	PERF_SAMPLE_COUNTER                 = 0x00410400
	PERF_COUNTER_QUEUELEN_TYPE          = 0x00450400
	PERF_COUNTER_LARGE_QUEUELEN_TYPE    = 0x00450500
	PERF_COUNTER_100NS_QUEUELEN_TYPE    = 0x00550500
	PERF_COUNTER_OBJ_TIME_QUEUELEN_TYPE = 0x00650500
	PERF_COUNTER_COUNTER                = 0x10410400
	PERF_COUNTER_BULK_COUNT             = 0x10410500
	PERF_RAW_FRACTION                   = 0x20020400
	PERF_LARGE_RAW_FRACTION             = 0x20020500
	PERF_COUNTER_TIMER                  = 0x20410500
	PERF_PRECISION_SYSTEM_TIMER         = 0x20470500
	PERF_100NSEC_TIMER                  = 0x20510500
	PERF_PRECISION_100NS_TIMER          = 0x20570500
	PERF_OBJ_TIME_TIMER                 = 0x20610500
	PERF_PRECISION_OBJECT_TIMER         = 0x20670500
	PERF_SAMPLE_FRACTION                = 0x20c20400
	PERF_COUNTER_TIMER_INV              = 0x21410500
	PERF_100NSEC_TIMER_INV              = 0x21510500
	PERF_COUNTER_MULTI_TIMER            = 0x22410500
	PERF_100NSEC_MULTI_TIMER            = 0x22510500
	PERF_COUNTER_MULTI_TIMER_INV        = 0x23410500
	PERF_100NSEC_MULTI_TIMER_INV        = 0x23510500
	PERF_AVERAGE_TIMER                  = 0x30020400
	PERF_ELAPSED_TIME                   = 0x30240500
	PERF_COUNTER_NODATA                 = 0x40000200
	PERF_AVERAGE_BULK                   = 0x40020500
	PERF_SAMPLE_BASE                    = 0x40030401
	PERF_AVERAGE_BASE                   = 0x40030402
	PERF_RAW_BASE                       = 0x40030403
	PERF_PRECISION_TIMESTAMP            = 0x40030500
	PERF_LARGE_RAW_BASE                 = 0x40030503
	PERF_COUNTER_MULTI_BASE             = 0x42030500
	PERF_COUNTER_HISTOGRAM_TYPE         = 0x80000000
)

//nolint:gochecknoglobals
var SupportedCounterTypes = map[uint32]prometheus.ValueType{
	PERF_COUNTER_RAWCOUNT_HEX:       prometheus.GaugeValue,
	PERF_COUNTER_LARGE_RAWCOUNT_HEX: prometheus.GaugeValue,
	PERF_COUNTER_RAWCOUNT:           prometheus.GaugeValue,
	PERF_COUNTER_LARGE_RAWCOUNT:     prometheus.GaugeValue,
	PERF_COUNTER_DELTA:              prometheus.CounterValue,
	PERF_COUNTER_COUNTER:            prometheus.CounterValue,
	PERF_COUNTER_BULK_COUNT:         prometheus.CounterValue,
	PERF_RAW_FRACTION:               prometheus.GaugeValue,
	PERF_LARGE_RAW_FRACTION:         prometheus.GaugeValue,
	PERF_100NSEC_TIMER:              prometheus.CounterValue,
	PERF_PRECISION_100NS_TIMER:      prometheus.CounterValue,
	PERF_SAMPLE_FRACTION:            prometheus.GaugeValue,
	PERF_100NSEC_TIMER_INV:          prometheus.CounterValue,
	PERF_ELAPSED_TIME:               prometheus.GaugeValue,
	PERF_SAMPLE_BASE:                prometheus.GaugeValue,
	PERF_RAW_BASE:                   prometheus.GaugeValue,
	PERF_LARGE_RAW_BASE:             prometheus.GaugeValue,
}
