[comment]: <> (Code generated by mdatagen. DO NOT EDIT.)

# vcenter

## Default Metrics

The following metrics are emitted by default. Each of them can be disabled by applying the following configuration:

```yaml
metrics:
  <metric_name>:
    enabled: false
```

### vcenter.cluster.cpu.effective

The effective CPU available to the cluster. This value excludes CPU from hosts in maintenance mode or are unresponsive.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| MHz | Sum | Int | Cumulative | false |

### vcenter.cluster.cpu.limit

The amount of CPU available to the cluster.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| MHz | Sum | Int | Cumulative | false |

### vcenter.cluster.host.count

The number of hosts in the cluster.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| {hosts} | Sum | Int | Cumulative | false |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| effective | Whether the host is effective in the vCenter cluster. | Any Bool | false |

### vcenter.cluster.memory.effective

The effective available memory of the cluster.

This value excludes memory from hosts that are either in maintenance mode or are unresponsive. It also excludes memory used by the VMware Service Console.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| By | Sum | Int | Cumulative | false |

### vcenter.cluster.memory.limit

The available memory of the cluster.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| By | Sum | Int | Cumulative | false |

### vcenter.cluster.vm.count

The number of virtual machines in the cluster.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| {virtual_machines} | Sum | Int | Cumulative | false |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| power_state | The current power state of the virtual machine. | Str: ``on``, ``off``, ``suspended``, ``unknown`` | false |

### vcenter.cluster.vm_template.count

The number of virtual machine templates in the cluster.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| {virtual_machine_templates} | Sum | Int | Cumulative | false |

### vcenter.cluster.vsan.congestions

The congestions of IOs generated by all vSAN clients in the cluster.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| {congestions/s} | Gauge | Double |

### vcenter.cluster.vsan.latency.avg

The overall cluster latency while accessing vSAN storage.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| us | Gauge | Int |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| type | The type of vSAN latency. | Str: ``read``, ``write`` | false |

### vcenter.cluster.vsan.operations

The vSAN IOPs of a cluster.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| {operations/s} | Gauge | Int |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| type | The type of vSAN operation. | Str: ``read``, ``write``, ``unmap`` | false |

### vcenter.cluster.vsan.throughput

The vSAN throughput of a cluster.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| By/s | Gauge | Double |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| direction | The type of vSAN throughput. | Str: ``read``, ``write`` | false |

### vcenter.datacenter.cluster.count

The number of clusters in the datacenter.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| {clusters} | Sum | Int | Cumulative | false |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| status | The current status of the managed entity. | Str: ``red``, ``yellow``, ``green``, ``gray`` | false |

### vcenter.datacenter.cpu.limit

The total amount of CPU available to the datacenter.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| MHz | Sum | Int | Cumulative | false |

### vcenter.datacenter.datastore.count

The number of datastores in the datacenter.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| {datastores} | Sum | Int | Cumulative | false |

### vcenter.datacenter.disk.space

The amount of available and used disk space in the datacenter.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| By | Sum | Int | Cumulative | false |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| disk_state | The state of storage and whether it is already allocated or free. | Str: ``available``, ``used`` | false |

### vcenter.datacenter.host.count

The number of hosts in the datacenter.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| {hosts} | Sum | Int | Cumulative | false |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| status | The current status of the managed entity. | Str: ``red``, ``yellow``, ``green``, ``gray`` | false |
| power_state | The current power state of the host. | Str: ``on``, ``off``, ``standby``, ``unknown`` | false |

### vcenter.datacenter.memory.limit

The total amount of memory available to the datacenter.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| By | Sum | Int | Cumulative | false |

### vcenter.datacenter.vm.count

The number of VM's in the datacenter.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| {virtual_machines} | Sum | Int | Cumulative | false |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| status | The current status of the managed entity. | Str: ``red``, ``yellow``, ``green``, ``gray`` | false |
| power_state | The current power state of the virtual machine. | Str: ``on``, ``off``, ``suspended``, ``unknown`` | false |

### vcenter.datastore.disk.usage

The amount of space in the datastore.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| By | Sum | Int | Cumulative | false |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| disk_state | The state of storage and whether it is already allocated or free. | Str: ``available``, ``used`` | false |

### vcenter.datastore.disk.utilization

The utilization of the datastore.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| % | Gauge | Double |

### vcenter.host.cpu.capacity

Total CPU capacity of the host system.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| MHz | Sum | Int | Cumulative | false |

### vcenter.host.cpu.reserved

The CPU of the host reserved for use by virtual machines.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| MHz | Sum | Int | Cumulative | false |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| cpu_reservation_type | The type of CPU reservation for the host. | Str: ``total``, ``used`` | false |

### vcenter.host.cpu.usage

The amount of CPU used by the host.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| MHz | Sum | Int | Cumulative | false |

### vcenter.host.cpu.utilization

The CPU utilization of the host system.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| % | Gauge | Double |

### vcenter.host.disk.latency.avg

The latency of operations to the host system's disk.

This latency is the sum of the device and kernel read and write latencies. Requires Performance Counter level 2 for metric to populate.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| ms | Gauge | Int |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| direction | The direction of disk latency. | Str: ``read``, ``write`` | false |
| object | The object on the virtual machine or host that is being reported on. | Any Str | false |

### vcenter.host.disk.latency.max

Highest latency value across all disks used by the host.

As measured over the most recent 20s interval. Requires Performance Level 3.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| ms | Gauge | Int |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| object | The object on the virtual machine or host that is being reported on. | Any Str | false |

### vcenter.host.disk.throughput

Average number of kilobytes read from or written to the disk each second.

As measured over the most recent 20s interval. Aggregated disk I/O rate. Requires Performance Level 4.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| {KiBy/s} | Sum | Int | Cumulative | false |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| direction | The direction of disk latency. | Str: ``read``, ``write`` | false |
| object | The object on the virtual machine or host that is being reported on. | Any Str | false |

### vcenter.host.memory.usage

The amount of memory the host system is using.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| MiBy | Sum | Int | Cumulative | false |

### vcenter.host.memory.utilization

The percentage of the host system's memory capacity that is being utilized.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| % | Gauge | Double |

### vcenter.host.network.packet.drop.rate

The rate of packets dropped across each physical NIC (network interface controller) instance on the host.

As measured over the most recent 20s interval.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| {packets/s} | Gauge | Double |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| direction | The direction of network throughput. | Str: ``transmitted``, ``received`` | false |
| object | The object on the virtual machine or host that is being reported on. | Any Str | false |

### vcenter.host.network.packet.error.rate

The rate of packet errors transmitted or received on the host network.

As measured over the most recent 20s interval.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| {errors/s} | Gauge | Double |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| direction | The direction of network throughput. | Str: ``transmitted``, ``received`` | false |
| object | The object on the virtual machine or host that is being reported on. | Any Str | false |

### vcenter.host.network.packet.rate

The rate of packets transmitted or received across each physical NIC (network interface controller) instance on the host.

As measured over the most recent 20s interval.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| {packets/s} | Gauge | Double |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| direction | The direction of network throughput. | Str: ``transmitted``, ``received`` | false |
| object | The object on the virtual machine or host that is being reported on. | Any Str | false |

### vcenter.host.network.throughput

The amount of data that was transmitted or received over the network by the host.

As measured over the most recent 20s interval.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| {KiBy/s} | Sum | Int | Cumulative | false |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| direction | The direction of network throughput. | Str: ``transmitted``, ``received`` | false |
| object | The object on the virtual machine or host that is being reported on. | Any Str | false |

### vcenter.host.network.usage

The sum of the data transmitted and received for all the NIC instances of the host.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| {KiBy/s} | Sum | Int | Cumulative | false |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| object | The object on the virtual machine or host that is being reported on. | Any Str | false |

### vcenter.host.vsan.cache.hit_rate

The host's read IOs which could be satisfied by the local client cache.

As measured over the most recent 5m interval.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| % | Gauge | Int |

### vcenter.host.vsan.congestions

The congestions of IOs generated by all vSAN clients in the host.

As measured over the most recent 5m interval.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| {congestions/s} | Gauge | Double |

### vcenter.host.vsan.latency.avg

The host latency while accessing vSAN storage.

As measured over the most recent 5m interval.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| us | Gauge | Int |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| type | The type of vSAN latency. | Str: ``read``, ``write`` | false |

### vcenter.host.vsan.operations

The vSAN IOPs of a host.

As measured over the most recent 5m interval.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| {operations/s} | Gauge | Int |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| type | The type of vSAN operation. | Str: ``read``, ``write``, ``unmap`` | false |

### vcenter.host.vsan.throughput

The vSAN throughput of a host.

As measured over the most recent 5m interval.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| By/s | Gauge | Double |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| direction | The type of vSAN throughput. | Str: ``read``, ``write`` | false |

### vcenter.resource_pool.cpu.shares

The amount of shares of CPU in the resource pool.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| {shares} | Sum | Int | Cumulative | false |

### vcenter.resource_pool.cpu.usage

The usage of the CPU used by the resource pool.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| MHz | Sum | Int | Cumulative | false |

### vcenter.resource_pool.memory.ballooned

The amount of memory in a resource pool that is ballooned due to virtualization.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| MiBy | Sum | Int | Cumulative | false |

### vcenter.resource_pool.memory.granted

The amount of memory that is granted to VMs in the resource pool from shared and non-shared host memory.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| MiBy | Sum | Int | Cumulative | false |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| type | The type of memory granted. | Str: ``private``, ``shared`` | false |

### vcenter.resource_pool.memory.shares

The amount of shares of memory in the resource pool.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| {shares} | Sum | Int | Cumulative | false |

### vcenter.resource_pool.memory.swapped

The amount of memory that is granted to VMs in the resource pool from the host's swap space.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| MiBy | Sum | Int | Cumulative | false |

### vcenter.resource_pool.memory.usage

The usage of the memory by the resource pool.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| MiBy | Sum | Int | Cumulative | false |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| type | The type of memory usage. | Str: ``guest``, ``host``, ``overhead`` | false |

### vcenter.vm.cpu.readiness

Percentage of time that the virtual machine was ready, but could not get scheduled to run on the physical CPU.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| % | Gauge | Int |

### vcenter.vm.cpu.usage

The amount of CPU used by the VM.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| MHz | Sum | Int | Cumulative | false |

### vcenter.vm.cpu.utilization

The CPU utilization of the VM.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| % | Gauge | Double |

### vcenter.vm.disk.latency.avg

The latency of operations to the virtual machine's disk.

Requires Performance Counter level 2 for metric to populate. As measured over the most recent 20s interval.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| ms | Gauge | Int |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| direction | The direction of disk latency. | Str: ``read``, ``write`` | false |
| disk_type | The type of storage device that is being recorded. | Str: ``virtual``, ``physical`` | false |
| object | The object on the virtual machine or host that is being reported on. | Any Str | false |

### vcenter.vm.disk.latency.max

The highest reported total latency (device and kernel times) over an interval of 20 seconds.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| ms | Gauge | Int |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| object | The object on the virtual machine or host that is being reported on. | Any Str | false |

### vcenter.vm.disk.throughput

Average number of kilobytes read from or written to the virtual disk each second.

As measured over the most recent 20s interval. Requires Performance Level 2.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| {KiBy/s} | Gauge | Int |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| direction | The direction of disk latency. | Str: ``read``, ``write`` | false |
| object | The object on the virtual machine or host that is being reported on. | Any Str | false |

### vcenter.vm.disk.usage

The amount of storage space used by the virtual machine.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| By | Sum | Int | Cumulative | false |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| disk_state | The state of storage and whether it is already allocated or free. | Str: ``available``, ``used`` | false |

### vcenter.vm.disk.utilization

The utilization of storage on the virtual machine.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| % | Gauge | Double |

### vcenter.vm.memory.ballooned

The amount of memory that is ballooned due to virtualization.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| MiBy | Sum | Int | Cumulative | false |

### vcenter.vm.memory.swapped

The portion of memory that is granted to this VM from the host's swap space.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| MiBy | Sum | Int | Cumulative | false |

### vcenter.vm.memory.swapped_ssd

The amount of memory swapped to fast disk device such as SSD.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| KiBy | Sum | Int | Cumulative | false |

### vcenter.vm.memory.usage

The amount of memory that is used by the virtual machine.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| MiBy | Sum | Int | Cumulative | false |

### vcenter.vm.memory.utilization

The memory utilization of the VM.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| % | Gauge | Double |

### vcenter.vm.network.packet.drop.rate

The rate of transmitted or received packets dropped by each vNIC (virtual network interface controller) on the virtual machine.

As measured over the most recent 20s interval.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| {packets/s} | Gauge | Double |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| direction | The direction of network throughput. | Str: ``transmitted``, ``received`` | false |
| object | The object on the virtual machine or host that is being reported on. | Any Str | false |

### vcenter.vm.network.packet.rate

The rate of packets transmitted or received by each vNIC (virtual network interface controller) on the virtual machine.

As measured over the most recent 20s interval.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| {packets/s} | Gauge | Double |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| direction | The direction of network throughput. | Str: ``transmitted``, ``received`` | false |
| object | The object on the virtual machine or host that is being reported on. | Any Str | false |

### vcenter.vm.network.throughput

The amount of data that was transmitted or received over the network of the virtual machine.

As measured over the most recent 20s interval.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| By/s | Sum | Int | Cumulative | false |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| direction | The direction of network throughput. | Str: ``transmitted``, ``received`` | false |
| object | The object on the virtual machine or host that is being reported on. | Any Str | false |

### vcenter.vm.network.usage

The network utilization combined transmit and receive rates during an interval.

As measured over the most recent 20s interval.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| {KiBy/s} | Sum | Int | Cumulative | false |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| object | The object on the virtual machine or host that is being reported on. | Any Str | false |

### vcenter.vm.vsan.latency.avg

The virtual machine latency while accessing vSAN storage.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| us | Gauge | Int |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| type | The type of vSAN latency. | Str: ``read``, ``write`` | false |

### vcenter.vm.vsan.operations

The vSAN IOPs of a virtual machine.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| {operations/s} | Gauge | Int |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| type | The type of vSAN operation. | Str: ``read``, ``write``, ``unmap`` | false |

### vcenter.vm.vsan.throughput

The vSAN throughput of a virtual machine.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| By/s | Gauge | Double |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| direction | The type of vSAN throughput. | Str: ``read``, ``write`` | false |

## Optional Metrics

The following metrics are not emitted by default. Each of them can be enabled by applying the following configuration:

```yaml
metrics:
  <metric_name>:
    enabled: true
```

### vcenter.host.memory.capacity

Total memory  capacity of the host system.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| MiBy | Sum | Double | Cumulative | false |

### vcenter.vm.cpu.time

CPU time spent in idle, ready or wait state.

As measured over the most recent 20s interval.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| % | Gauge | Double |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| cpu_state | CPU time spent in idle, ready or idle state. | Str: ``idle``, ``ready``, ``wait`` | false |
| object | The object on the virtual machine or host that is being reported on. | Any Str | false |

### vcenter.vm.memory.granted

The amount of memory that is granted to a VM.

| Unit | Metric Type | Value Type | Aggregation Temporality | Monotonic |
| ---- | ----------- | ---------- | ----------------------- | --------- |
| MiBy | Sum | Int | Cumulative | false |

### vcenter.vm.network.broadcast.packet.rate

The rate of broadcast packets transmitted or received by each vNIC (virtual network interface controller) on the virtual machine.

As measured over the most recent 20s interval.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| {packets/s} | Gauge | Double |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| direction | The direction of network throughput. | Str: ``transmitted``, ``received`` | false |
| object | The object on the virtual machine or host that is being reported on. | Any Str | false |

### vcenter.vm.network.multicast.packet.rate

The rate of multicast packets transmitted or received by each vNIC (virtual network interface controller) on the virtual machine.

As measured over the most recent 20s interval.

| Unit | Metric Type | Value Type |
| ---- | ----------- | ---------- |
| {packets/s} | Gauge | Double |

#### Attributes

| Name | Description | Values | Optional |
| ---- | ----------- | ------ | -------- |
| direction | The direction of network throughput. | Str: ``transmitted``, ``received`` | false |
| object | The object on the virtual machine or host that is being reported on. | Any Str | false |

## Resource Attributes

| Name | Description | Values | Enabled |
| ---- | ----------- | ------ | ------- |
| vcenter.cluster.name | The name of the vCenter cluster. | Any Str | true |
| vcenter.datacenter.name | The name of the vCenter datacenter. | Any Str | true |
| vcenter.datastore.name | The name of the vCenter datastore. | Any Str | true |
| vcenter.host.name | The hostname of the vCenter ESXi host. | Any Str | true |
| vcenter.resource_pool.inventory_path | The inventory path of the resource pool. | Any Str | true |
| vcenter.resource_pool.name | The name of the resource pool. | Any Str | true |
| vcenter.virtual_app.inventory_path | The inventory path of the vApp. | Any Str | true |
| vcenter.virtual_app.name | The name of the vApp. | Any Str | true |
| vcenter.vm.id | The instance UUID of the virtual machine. | Any Str | true |
| vcenter.vm.name | The name of the virtual machine. | Any Str | true |
| vcenter.vm_template.id | The instance UUID of the virtual machine template. | Any Str | true |
| vcenter.vm_template.name | The name of the virtual machine template. | Any Str | true |
