# Google Pubsub Receiver

<!-- status autogenerated section -->
| Status        |           |
| ------------- |-----------|
| Stability     | [beta]: traces, logs, metrics   |
| Distributions | [contrib] |
| Issues        | [![Open issues](https://img.shields.io/github/issues-search/open-telemetry/opentelemetry-collector-contrib?query=is%3Aissue%20is%3Aopen%20label%3Areceiver%2Fgooglecloudpubsub%20&label=open&color=orange&logo=opentelemetry)](https://github.com/open-telemetry/opentelemetry-collector-contrib/issues?q=is%3Aopen+is%3Aissue+label%3Areceiver%2Fgooglecloudpubsub) [![Closed issues](https://img.shields.io/github/issues-search/open-telemetry/opentelemetry-collector-contrib?query=is%3Aissue%20is%3Aclosed%20label%3Areceiver%2Fgooglecloudpubsub%20&label=closed&color=blue&logo=opentelemetry)](https://github.com/open-telemetry/opentelemetry-collector-contrib/issues?q=is%3Aclosed+is%3Aissue+label%3Areceiver%2Fgooglecloudpubsub) |
| Code coverage | [![codecov](https://codecov.io/github/open-telemetry/opentelemetry-collector-contrib/graph/main/badge.svg?component=receiver_googlecloudpubsub)](https://app.codecov.io/gh/open-telemetry/opentelemetry-collector-contrib/tree/main/?components%5B0%5D=receiver_googlecloudpubsub&displayType=list) |
| [Code Owners](https://github.com/open-telemetry/opentelemetry-collector-contrib/blob/main/CONTRIBUTING.md#becoming-a-code-owner)    | [@alexvanboxel](https://www.github.com/alexvanboxel) |

[beta]: https://github.com/open-telemetry/opentelemetry-collector/blob/main/docs/component-stability.md#beta
[contrib]: https://github.com/open-telemetry/opentelemetry-collector-releases/tree/main/distributions/otelcol-contrib
<!-- end autogenerated section -->

> ⚠️ This is a community-provided module. It has been developed and extensively tested at Collibra, but it is not officially supported by GCP.
 
This receiver gets OTLP messages from a Google Cloud [Pubsub](https://cloud.google.com/pubsub) subscription.

The following configuration options are supported:

* `project` (Optional): The Google Cloud Project of the client connects to.
* `subscription` (Required): The subscription name to receive OTLP data from. The subscription name should be a
  fully qualified resource name (eg: `projects/otel-project/subscriptions/otlp`).
* `encoding` (Optional): The encoding that will be used to received data from the subscription. This can either be
  `otlp_proto_trace`, `otlp_proto_metric`, `otlp_proto_log` or and encoding extension (see `encoding`).  This will only 
  be used as a fallback, when no `content-type` attribute is present.
* `compression` (Optional): The compression that will be used on received data from the subscription. When set it can 
  only be `gzip`. This will only be used as a fallback, when no `content-encoding` attribute is present.
* `endpoint` (Optional): Override the default Pubsub Endpoint, useful when connecting to the PubSub emulator instance
  or switching between [global and regional service endpoints](https://cloud.google.com/pubsub/docs/reference/service_apis_overview#service_endpoints).
* `insecure` (Optional): allows performing “insecure” SSL connections and transfers, useful when connecting to a local
   emulator instance. Only has effect if Endpoint is not ""
* `ignore_encoding_error` (Optional): Ignore errors when the configured encoder fails to decoding a PubSub messages.
  It's advised to set this to `true` when using a custom encoder, and use `receiver.googlecloudpubsub.encoding_error`
  metric to monitor the number of errors. Ignoring the error will cause the receiver to drop the message.

```yaml
receivers:
  googlecloudpubsub:
    project: otel-project
    subscription: projects/otel-project/subscriptions/otlp-logs
```

## Encoding

The `encoding` options allows you to specify Encoding Extensions for decoding messages on the subscription. An
extension need to be configured in the `extensions` section, and added to pipeline in the collectors configuration file.

The following example shows how to use the text encoding extension for ingesting arbitrary text message on a 
subscription, wrapping them in OTLP Log messages. Note that not all extensions support all signals.

```yaml
extensions:
  text_encoding:
    encoding: utf8
    unmarshaling_separator: "\r?\n"

service:
  extensions: [text_encoding]
  pipelines:
    logs:
      receivers: [googlecloudpubsub]
      processors: []
      exporters: [debug]
```

The receiver also supports build in encodings for the native OTLP Protobuf encodings, without the need to specify an 
Encoding Extensions.

| encoding          | description                                    |
|-------------------|------------------------------------------------|
| otlp_proto_trace  | Decode OTLP trace message                      |
| otlp_proto_metric | Decode OTLP trace message                      |
| otlp_proto_log    | Decode OTLP trace message                      |

The build-in encoding `cloud_logging` and `raw_text` where removed since v0.132.0, use the encoding extensions
`googlecloudlogentry` and `text` encoding extension instead.

When no encoding is specified, the receiver will try to discover the type of the data by looking at the `ce-type` and
`content-type` attributes of the message. These message attributes are set by the `googlepubsubexporter`.

| ce-type                           | ce-datacontenttype   | encoding          | description                                    |
|-----------------------------------|----------------------|-------------------|------------------------------------------------|
| org.opentelemetry.otlp.traces.v1  | application/protobuf |                   | Decode OTLP trace message                      |
| org.opentelemetry.otlp.metrics.v1 | application/protobuf |                   | Decode OTLP metric message                     |
| org.opentelemetry.otlp.logs.v1    | application/protobuf |                   | Decode OTLP log message                        |

[Cloud Logging]: https://cloud.google.com/logging
[LogEntry]: https://cloud.google.com/logging/docs/reference/v2/rest/v2/LogEntry
[sink-docs]: https://cloud.google.com/logging/docs/export/configure_export_v2#creating_sink

## Pubsub subscription

The Google Cloud [Pubsub](https://cloud.google.com/pubsub) receiver doesn't automatically create subscriptions, 
it expects the subscription to be created upfront. Security wise it's best to give the collector its own 
service account and give the subscription `Pub/Sub Subscriber` permission.

The subscription should also be of delivery type `Pull`.

### Filtering

When the messages on the subscription are accompanied by the correct attributes and you only need a specific
type in your pipeline, the messages can be [filtered](https://cloud.google.com/pubsub/docs/filtering) on the 
subscription saving on egress fees.

An example of filtering on trace message only: 
```
attributes.ce-type = "org.opentelemetry.otlp.traces.v1"
AND
attributes.content-type = "application/protobuf"
```

