# Syslog Exporter

<!-- status autogenerated section -->
| Status        |           |
| ------------- |-----------|
| Stability     | [alpha]: logs   |
| Distributions | [contrib] |
| Issues        | [![Open issues](https://img.shields.io/github/issues-search/open-telemetry/opentelemetry-collector-contrib?query=is%3Aissue%20is%3Aopen%20label%3Aexporter%2Fsyslog%20&label=open&color=orange&logo=opentelemetry)](https://github.com/open-telemetry/opentelemetry-collector-contrib/issues?q=is%3Aopen+is%3Aissue+label%3Aexporter%2Fsyslog) [![Closed issues](https://img.shields.io/github/issues-search/open-telemetry/opentelemetry-collector-contrib?query=is%3Aissue%20is%3Aclosed%20label%3Aexporter%2Fsyslog%20&label=closed&color=blue&logo=opentelemetry)](https://github.com/open-telemetry/opentelemetry-collector-contrib/issues?q=is%3Aclosed+is%3Aissue+label%3Aexporter%2Fsyslog) |
| Code coverage | [![codecov](https://codecov.io/github/open-telemetry/opentelemetry-collector-contrib/graph/main/badge.svg?component=exporter_syslog)](https://app.codecov.io/gh/open-telemetry/opentelemetry-collector-contrib/tree/main/?components%5B0%5D=exporter_syslog&displayType=list) |
| [Code Owners](https://github.com/open-telemetry/opentelemetry-collector-contrib/blob/main/CONTRIBUTING.md#becoming-a-code-owner)    | [@kasia-kujawa](https://www.github.com/kasia-kujawa), [@rnishtala-sumo](https://www.github.com/rnishtala-sumo), [@andrzej-stencel](https://www.github.com/andrzej-stencel) |

[alpha]: https://github.com/open-telemetry/opentelemetry-collector/blob/main/docs/component-stability.md#alpha
[contrib]: https://github.com/open-telemetry/opentelemetry-collector-releases/tree/main/distributions/otelcol-contrib
<!-- end autogenerated section -->

The Syslog exporter sends logs in [syslog][syslog_wikipedia] format to a remote syslog server.
It supports syslog protocols [RFC5424][RFC5424] and [RFC3164][RFC3164] and can send data over `TCP`, `UDP` or Unix sockets.
The exporter aims to be compatible with the [Syslog receiver][syslog_receiver].
This means that syslog messages received via the Syslog receiver and exported via the Syslog exporter should be unchanged.

## Configuration

**The following configuration options are available**:

- `endpoint` - (required) syslog endpoint
- `network` - (default = `tcp`) tcp/udp/unix
- `port` - (default = `514`) A syslog port, ignored when `network` is set to `unix`
- `protocol` - (default = `rfc5424`) rfc5424/rfc3164
  - `rfc5424` - Expects the syslog messages to be rfc5424 compliant
  - `rfc3164` - Expects the syslog messages to be rfc3164 compliant
- `enable_octet_counting` (default = `false`) - Whether or not to enable rfc6587 octet counting
- `tls` - configuration for TLS/mTLS (applied only when `network` is set to `tcp`)
  - `insecure` (default = `false`) whether to enable client transport security, by default, TLS is enabled.
  - `cert_file` - Path to the TLS cert to use for TLS required connections. Should only be used if `insecure` is set to `false`.
  - `key_file` - Path to the TLS key to use for TLS required connections. Should only be used if `insecure` is set to `false`.
  - `ca_file` - Path to the CA cert. For a client this verifies the server certificate. For a server this verifies client certificates. If empty uses system root CA. Should only be used if `insecure` is set to `false`.
  - `insecure_skip_verify` -  (default = `false`) whether to skip verifying the certificate or not.
  - `min_version` (default = `1.2`) Minimum acceptable TLS version
  - `max_version` (default = `""` handled by [crypto/tls][cryptoTLS] - currently TLS 1.3) Maximum acceptable TLS version.
  - `reload_interval` - Specifies the duration after which the certificate will be reloaded. If not set, it will never be reloaded.
- `retry_on_failure`
  - `enabled` (default = `true`)
  - `initial_interval` (default = `5s`): Time to wait after the first failure before retrying; ignored if `enabled` is `false`
  - `max_interval` (default = 30s): Is the upper bound on backoff; ignored if `enabled` is `false`
  - `max_elapsed_time` (default = `120s`): Is the maximum amount of time spent trying to send a batch; ignored if `enabled` is `false`
- `sending_queue`
  - `enabled` (default = `false`)
  - `num_consumers` (default = `10`): Number of consumers that dequeue batches; ignored if `enabled` is `false`
  - `queue_size` (default = `5000`): Maximum number of batches kept in memory before data; ignored if `enabled` is `false`;
  User should calculate this as `num_seconds * requests_per_second` where:
    - `num_seconds` is the number of seconds to buffer in case of a backend outage
    - `requests_per_second` is the average number of requests per seconds.
  - `storage` (default = `none`): When set, enables persistence and uses the component specified as a storage extension for the [persistent queue][persistent_queue]
- `timeout` (default = 5s) Time to wait per individual attempt to send data to a backend

## Examples

### RFC5424

When configured with `protocol: rfc5424`, the exporter creates one syslog message for each log record,
based on the following record-level attributes of the log.
If an attribute is missing, the default value is used.
The log's timestamp field is used for the syslog message's time.

| Attribute name    | Type   | Default value  |
| ----------------- | ------ | -------------- |
| `appname`         | string | `-`            |
| `hostname`        | string | `-`            |
| `message`         | string | empty string   |
| `msg_id`          | string | `-`            |
| `priority`        | int    | `165`          |
| `proc_id`         | string | `-`            |
| `structured_data` | map    | `-`            |
| `version`         | int    | `1`            |

Here's a simplified representation of an input log record:

```json
{
  "body": "",
  "timeUnixNano": 1065903255003000000,
  "attributes":
  {
    "appname": "su",
    "hostname": "mymachine.example.com",
    "message": "'su root' failed for lonvick on /dev/pts/8",
    "priority": 34,
  }
}
```

And here's the output message based on the above log record:

```console
<34>1 2003-10-11T22:14:15.003Z mymachine.example.com su - - - 'su root' failed for lonvick on /dev/pts/8
```

Here's another example, this includes the structured data and other attributes:

```json
{
  "body": "",
  "timeUnixNano": 1438811939693012000,
  "attributes":
  {
    "appname": "SecureAuth0",
    "hostname": "192.168.2.132",
    "message": "Found the user for retrieving user's profile",
    "msg_id": "ID52020",
    "priority": 86,
    "proc_id": "23108",
    "structured_data":
    {
      "SecureAuth@27389":
      {
        "UserHostAddress":"192.168.2.132",
        "Realm":"SecureAuth0",
        "UserID":"Tester2",
        "PEN":"27389"
      }
    },
    "version": 1
  }
}
```

Output:

```console
<86>1 2015-08-05T21:58:59.693012Z 192.168.2.132 SecureAuth0 23108 ID52020 [SecureAuth@27389 UserHostAddress="192.168.2.132" Realm="SecureAuth0" UserID="Tester2" PEN="27389"] Found the user for retrieving user's profile
```

### RFC3164

When configured with `protocol: rfc3164`, the exporter creates one syslog message for each log record,
based on the following record-level attributes of the log.
If an attribute is missing, the default value is used.
The log's timestamp field is used for the syslog message's time.

| Attribute name    | Type   | Default value  |
| ----------------- | ------ | -------------- |
| `appname`         | string | empty string   |
| `hostname`        | string | `-`            |
| `message`         | string | empty string   |
| `priority`        | int    | `165`          |

Here's a simplified representation of an input log record:

```json
{
  "body": "",
  "timeUnixNano": 1697062455000000000,
  "attributes":
  {
    "appname": "su",
    "hostname": "mymachine",
    "message": "'su root' failed for lonvick on /dev/pts/8",
    "priority": 34
  }
}
```

Output:

```console
<34>Oct 11 22:14:15 mymachine su: 'su root' failed for lonvick on /dev/pts/8
```

Please see [example configurations](./examples/).

[syslog_wikipedia]: https://en.wikipedia.org/wiki/Syslog
[RFC5424]: https://www.rfc-editor.org/rfc/rfc5424
[RFC3164]: https://www.rfc-editor.org/rfc/rfc3164
[syslog_receiver]: https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/syslogreceiver
[cryptoTLS]: https://github.com/golang/go/blob/518889b35cb07f3e71963f2ccfc0f96ee26a51ce/src/crypto/tls/common.go#L706-L709
[persistent_queue]: https://github.com/open-telemetry/opentelemetry-collector/blob/main/exporter/exporterhelper/README.md#persistent-queue
