/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.Action;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class EOFActions {
    private Hashtable actions = new Hashtable();
    private Action defaultAction;
    private int numLexStates;

    public void setNumLexStates(int num) {
        this.numLexStates = num;
    }

    public void add(Vector stateList, Action action) {
        if (stateList != null && stateList.size() > 0) {
            Enumeration states = stateList.elements();
            while (states.hasMoreElements()) {
                this.add((Integer)states.nextElement(), action);
            }
        } else {
            this.defaultAction = action.getHigherPriority(this.defaultAction);
            int i = 0;
            while (i < this.numLexStates) {
                Integer state = new Integer(i);
                if (this.actions.get(state) != null) {
                    Action oldAction = (Action)this.actions.get(state);
                    this.actions.put(state, oldAction.getHigherPriority(action));
                }
                ++i;
            }
        }
    }

    public void add(Integer state, Action action) {
        if (this.actions.get(state) == null) {
            this.actions.put(state, action);
        } else {
            Action oldAction = (Action)this.actions.get(state);
            this.actions.put(state, oldAction.getHigherPriority(action));
        }
    }

    public boolean isEOFAction(Object a) {
        if (a == this.defaultAction) {
            return true;
        }
        Enumeration e = this.actions.elements();
        while (e.hasMoreElements()) {
            if (a != e.nextElement()) continue;
            return true;
        }
        return false;
    }

    public Action getAction(int state) {
        return (Action)this.actions.get(new Integer(state));
    }

    public Action getDefault() {
        return this.defaultAction;
    }

    public int numActions() {
        return this.actions.size();
    }
}

