
package pe

// Autogenerated code from pe_profile.json. Do not edit.

import (
    "encoding/binary"
    "fmt"
    "bytes"
    "io"
    "sort"
    "strings"
    "unicode/utf16"
    "unicode/utf8"
)

var (
   // Depending on autogenerated code we may use this. Add a reference
   // to shut the compiler up.
   _ = bytes.MinRead
   _ = fmt.Sprintf
   _ = utf16.Decode
   _ = binary.LittleEndian
   _ = utf8.RuneError
   _ = sort.Strings
   _ = strings.Join
   _ = io.Copy
)

func indent(text string) string {
    result := []string{}
    lines := strings.Split(text,"\n")
    for _, line := range lines {
         result = append(result, "  " + line)
    }
    return strings.Join(result, "\n")
}


type PeProfile struct {
    Off_CV_RSDS_HEADER_Signature int64
    Off_CV_RSDS_HEADER_GUID int64
    Off_CV_RSDS_HEADER_Age int64
    Off_CV_RSDS_HEADER_Filename int64
    Off_MESSAGE_RESOURCE_BLOCK_LowId int64
    Off_MESSAGE_RESOURCE_BLOCK_HighId int64
    Off_MESSAGE_RESOURCE_BLOCK_OffsetToEntries int64
    Off_MESSAGE_RESOURCE_DATA_NumberOfBlocks int64
    Off_MESSAGE_RESOURCE_DATA__Blocks int64
    Off_MESSAGE_RESOURCE_ENTRY_Length int64
    Off_MESSAGE_RESOURCE_ENTRY_Flags int64
    Off_MESSAGE_RESOURCE_ENTRY_Text int64
    Off_PrefixedString_Length int64
    Off_PrefixedString__Buffer int64
    Off_ResourceString_Length int64
    Off_ResourceString_ValueLength int64
    Off_ResourceString_Type int64
    Off_ResourceString_Key int64
    Off_StringFileInfo_Length int64
    Off_StringFileInfo_ValueLength int64
    Off_StringFileInfo_Type int64
    Off_StringFileInfo_Key int64
    Off_StringTable_Length int64
    Off_StringTable_ValueLength int64
    Off_StringTable_Type int64
    Off_StringTable_Key int64
    Off_VS_VERSIONINFO_Length int64
    Off_VS_VERSIONINFO_ValueLength int64
    Off_VS_VERSIONINFO_Type int64
    Off_VS_VERSIONINFO_szKey int64
    Off_WIN_CERTIFICATE_Length int64
    Off_WIN_CERTIFICATE_Revision int64
    Off_WIN_CERTIFICATE_CertificateType int64
    Off_GENERIC_DIRECTORY_TimeDateStamp int64
    Off_GUID_Data1 int64
    Off_GUID_Data2 int64
    Off_GUID_Data3 int64
    Off_GUID_Data4 int64
    Off_IMAGE_DATA_DIRECTORY_DirSize int64
    Off_IMAGE_DATA_DIRECTORY_VirtualAddress int64
    Off_IMAGE_DEBUG_DIRECTORY_AddressOfRawData int64
    Off_IMAGE_DEBUG_DIRECTORY_TimeDateStamp int64
    Off_IMAGE_DEBUG_DIRECTORY_Type int64
    Off_IMAGE_DOS_HEADER_E_lfanew int64
    Off_IMAGE_DOS_HEADER_E_magic int64
    Off_IMAGE_EXPORT_DIRECTORY_AddressOfFunctions int64
    Off_IMAGE_EXPORT_DIRECTORY_AddressOfNameOrdinals int64
    Off_IMAGE_EXPORT_DIRECTORY_AddressOfNames int64
    Off_IMAGE_EXPORT_DIRECTORY_Base int64
    Off_IMAGE_EXPORT_DIRECTORY_Name int64
    Off_IMAGE_EXPORT_DIRECTORY_NumberOfFunctions int64
    Off_IMAGE_EXPORT_DIRECTORY_NumberOfNames int64
    Off_IMAGE_EXPORT_DIRECTORY_TimeDateStamp int64
    Off_IMAGE_EXPORT_DIRECTORY_ordinals int64
    Off_IMAGE_EXPORT_DIRECTORY_names int64
    Off_IMAGE_EXPORT_DIRECTORY_funcs64 int64
    Off_IMAGE_FILE_HEADER_Characteristics int64
    Off_IMAGE_FILE_HEADER_Machine int64
    Off_IMAGE_FILE_HEADER_NumberOfSections int64
    Off_IMAGE_FILE_HEADER_SizeOfOptionalHeader int64
    Off_IMAGE_FILE_HEADER_TimeDateStamp int64
    Off_IMAGE_FILE_HEADER_TimeDateStampRaw int64
    Off_IMAGE_IMPORT_BY_NAME_Name int64
    Off_IMAGE_IMPORT_DESCRIPTOR_Characteristics int64
    Off_IMAGE_IMPORT_DESCRIPTOR_Name int64
    Off_IMAGE_IMPORT_DESCRIPTOR_OriginalFirstThunk int64
    Off_IMAGE_NT_HEADERS_FileHeader int64
    Off_IMAGE_NT_HEADERS_OptionalHeader int64
    Off_IMAGE_NT_HEADERS_Signature int64
    Off_IMAGE_OPTIONAL_HEADER_CheckSum int64
    Off_IMAGE_OPTIONAL_HEADER_DataDirectory int64
    Off_IMAGE_OPTIONAL_HEADER_ImageBase int64
    Off_IMAGE_OPTIONAL_HEADER_Magic int64
    Off_IMAGE_OPTIONAL_HEADER_SizeOfHeaders int64
    Off_IMAGE_OPTIONAL_HEADER64_DataDirectory int64
    Off_IMAGE_OPTIONAL_HEADER64_ImageBase int64
    Off_IMAGE_OPTIONAL_HEADER64_Magic int64
    Off_IMAGE_OPTIONAL_HEADER64_SizeOfHeaders int64
    Off_IMAGE_RESOURCE_DATA_ENTRY_OffsetToData int64
    Off_IMAGE_RESOURCE_DATA_ENTRY_DataSize int64
    Off_IMAGE_RESOURCE_DATA_ENTRY_CodePage int64
    Off_IMAGE_RESOURCE_DIRECTORY_NumberOfIdEntries int64
    Off_IMAGE_RESOURCE_DIRECTORY_NumberOfNamedEntries int64
    Off_IMAGE_RESOURCE_DIRECTORY_TimeDateStamp int64
    Off_IMAGE_RESOURCE_DIRECTORY__Entries int64
    Off_IMAGE_RESOURCE_DIRECTORY_ENTRY_Type int64
    Off_IMAGE_RESOURCE_DIRECTORY_ENTRY_DataIsDirectory int64
    Off_IMAGE_RESOURCE_DIRECTORY_ENTRY_NameIsString int64
    Off_IMAGE_RESOURCE_DIRECTORY_ENTRY_NameOffset int64
    Off_IMAGE_RESOURCE_DIRECTORY_ENTRY_OffsetToData int64
    Off_IMAGE_RESOURCE_DIRECTORY_ENTRY_OffsetToDirectory int64
    Off_IMAGE_SECTION_HEADER_Characteristics int64
    Off_IMAGE_SECTION_HEADER_Name int64
    Off_IMAGE_SECTION_HEADER_PointerToRawData int64
    Off_IMAGE_SECTION_HEADER_SizeOfRawData int64
    Off_IMAGE_SECTION_HEADER_VirtualAddress int64
    Off_IMAGE_THUNK_DATA32_AddressOfData int64
    Off_IMAGE_THUNK_DATA32_ForwarderString int64
    Off_IMAGE_THUNK_DATA32_Function int64
    Off_IMAGE_THUNK_DATA32_Ordinal int64
    Off_IMAGE_THUNK_DATA64_AddressOfData int64
    Off_IMAGE_THUNK_DATA64_ForwarderString int64
    Off_IMAGE_THUNK_DATA64_Function int64
    Off_IMAGE_THUNK_DATA64_Ordinal int64
}

func NewPeProfile() *PeProfile {
    // Specific offsets can be tweaked to cater for slight version mismatches.
    self := &PeProfile{0,4,20,24,0,4,8,0,4,0,2,4,0,2,0,2,4,6,0,2,4,6,0,2,4,6,0,2,4,6,0,4,6,4,0,4,6,8,4,0,20,4,12,60,0,28,36,32,16,12,20,24,4,0,0,0,18,0,2,16,4,4,2,0,12,0,4,24,0,64,96,28,0,60,112,24,0,60,0,4,8,14,12,4,16,0,4,0,0,4,4,36,0,20,16,12,0,0,0,0,0,0,0,0}
    return self
}

func (self *PeProfile) CV_RSDS_HEADER(reader io.ReaderAt, offset int64) *CV_RSDS_HEADER {
    return &CV_RSDS_HEADER{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) MESSAGE_RESOURCE_BLOCK(reader io.ReaderAt, offset int64) *MESSAGE_RESOURCE_BLOCK {
    return &MESSAGE_RESOURCE_BLOCK{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) MESSAGE_RESOURCE_DATA(reader io.ReaderAt, offset int64) *MESSAGE_RESOURCE_DATA {
    return &MESSAGE_RESOURCE_DATA{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) MESSAGE_RESOURCE_ENTRY(reader io.ReaderAt, offset int64) *MESSAGE_RESOURCE_ENTRY {
    return &MESSAGE_RESOURCE_ENTRY{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) PrefixedString(reader io.ReaderAt, offset int64) *PrefixedString {
    return &PrefixedString{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) ResourceString(reader io.ReaderAt, offset int64) *ResourceString {
    return &ResourceString{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) StringFileInfo(reader io.ReaderAt, offset int64) *StringFileInfo {
    return &StringFileInfo{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) StringTable(reader io.ReaderAt, offset int64) *StringTable {
    return &StringTable{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) VS_VERSIONINFO(reader io.ReaderAt, offset int64) *VS_VERSIONINFO {
    return &VS_VERSIONINFO{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) WIN_CERTIFICATE(reader io.ReaderAt, offset int64) *WIN_CERTIFICATE {
    return &WIN_CERTIFICATE{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) GENERIC_DIRECTORY(reader io.ReaderAt, offset int64) *GENERIC_DIRECTORY {
    return &GENERIC_DIRECTORY{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) GUID(reader io.ReaderAt, offset int64) *GUID {
    return &GUID{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) IMAGE_DATA_DIRECTORY(reader io.ReaderAt, offset int64) *IMAGE_DATA_DIRECTORY {
    return &IMAGE_DATA_DIRECTORY{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) IMAGE_DEBUG_DIRECTORY(reader io.ReaderAt, offset int64) *IMAGE_DEBUG_DIRECTORY {
    return &IMAGE_DEBUG_DIRECTORY{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) IMAGE_DOS_HEADER(reader io.ReaderAt, offset int64) *IMAGE_DOS_HEADER {
    return &IMAGE_DOS_HEADER{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) IMAGE_EXPORT_DIRECTORY(reader io.ReaderAt, offset int64) *IMAGE_EXPORT_DIRECTORY {
    return &IMAGE_EXPORT_DIRECTORY{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) IMAGE_FILE_HEADER(reader io.ReaderAt, offset int64) *IMAGE_FILE_HEADER {
    return &IMAGE_FILE_HEADER{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) IMAGE_IMPORT_BY_NAME(reader io.ReaderAt, offset int64) *IMAGE_IMPORT_BY_NAME {
    return &IMAGE_IMPORT_BY_NAME{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) IMAGE_IMPORT_DESCRIPTOR(reader io.ReaderAt, offset int64) *IMAGE_IMPORT_DESCRIPTOR {
    return &IMAGE_IMPORT_DESCRIPTOR{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) IMAGE_NT_HEADERS(reader io.ReaderAt, offset int64) *IMAGE_NT_HEADERS {
    return &IMAGE_NT_HEADERS{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) IMAGE_OPTIONAL_HEADER(reader io.ReaderAt, offset int64) *IMAGE_OPTIONAL_HEADER {
    return &IMAGE_OPTIONAL_HEADER{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) IMAGE_OPTIONAL_HEADER64(reader io.ReaderAt, offset int64) *IMAGE_OPTIONAL_HEADER64 {
    return &IMAGE_OPTIONAL_HEADER64{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) IMAGE_RESOURCE_DATA_ENTRY(reader io.ReaderAt, offset int64) *IMAGE_RESOURCE_DATA_ENTRY {
    return &IMAGE_RESOURCE_DATA_ENTRY{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) IMAGE_RESOURCE_DIRECTORY(reader io.ReaderAt, offset int64) *IMAGE_RESOURCE_DIRECTORY {
    return &IMAGE_RESOURCE_DIRECTORY{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) IMAGE_RESOURCE_DIRECTORY_ENTRY(reader io.ReaderAt, offset int64) *IMAGE_RESOURCE_DIRECTORY_ENTRY {
    return &IMAGE_RESOURCE_DIRECTORY_ENTRY{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) IMAGE_SECTION_HEADER(reader io.ReaderAt, offset int64) *IMAGE_SECTION_HEADER {
    return &IMAGE_SECTION_HEADER{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) IMAGE_THUNK_DATA32(reader io.ReaderAt, offset int64) *IMAGE_THUNK_DATA32 {
    return &IMAGE_THUNK_DATA32{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) IMAGE_THUNK_DATA64(reader io.ReaderAt, offset int64) *IMAGE_THUNK_DATA64 {
    return &IMAGE_THUNK_DATA64{Reader: reader, Offset: offset, Profile: self}
}

func (self *PeProfile) TagVS_FIXEDFILEINFO(reader io.ReaderAt, offset int64) *TagVS_FIXEDFILEINFO {
    return &TagVS_FIXEDFILEINFO{Reader: reader, Offset: offset, Profile: self}
}


type CV_RSDS_HEADER struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
    _GUID *GUID

    _Age uint32
    _Age_cached bool

}

func (self *CV_RSDS_HEADER) Size() int {
    return 28
}


func (self *CV_RSDS_HEADER) Signature() string {
  return ParseString(self.Reader, self.Profile.Off_CV_RSDS_HEADER_Signature + self.Offset, 4)
}

func (self *CV_RSDS_HEADER) GUID() *GUID {
    if self._GUID != nil {
       return self._GUID
    }
    result := self.Profile.GUID(self.Reader, self.Profile.Off_CV_RSDS_HEADER_GUID + self.Offset)
    self._GUID = result
    return result
}

func (self *CV_RSDS_HEADER) Age() uint32 {
   if self._Age_cached {
      return self._Age
   }
   result := ParseUint32(self.Reader, self.Profile.Off_CV_RSDS_HEADER_Age + self.Offset)
   self._Age = result
   self._Age_cached = true
   return result
}


func (self *CV_RSDS_HEADER) Filename() string {
  return ParseTerminatedString(self.Reader, self.Profile.Off_CV_RSDS_HEADER_Filename + self.Offset)
}
func (self *CV_RSDS_HEADER) DebugString() string {
    result := fmt.Sprintf("struct CV_RSDS_HEADER @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  Signature: %v\n", string(self.Signature()))
    result += fmt.Sprintf("  GUID: {\n%v}\n", indent(self.GUID().DebugString()))
    result += fmt.Sprintf("  Age: %#0x\n", self.Age())
    result += fmt.Sprintf("  Filename: %v\n", string(self.Filename()))
    return result
}

type MESSAGE_RESOURCE_BLOCK struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
    _LowId uint32
    _LowId_cached bool

    _HighId uint32
    _HighId_cached bool

    _OffsetToEntries uint32
    _OffsetToEntries_cached bool

}

func (self *MESSAGE_RESOURCE_BLOCK) Size() int {
    return 12
}

func (self *MESSAGE_RESOURCE_BLOCK) LowId() uint32 {
   if self._LowId_cached {
      return self._LowId
   }
   result := ParseUint32(self.Reader, self.Profile.Off_MESSAGE_RESOURCE_BLOCK_LowId + self.Offset)
   self._LowId = result
   self._LowId_cached = true
   return result
}

func (self *MESSAGE_RESOURCE_BLOCK) HighId() uint32 {
   if self._HighId_cached {
      return self._HighId
   }
   result := ParseUint32(self.Reader, self.Profile.Off_MESSAGE_RESOURCE_BLOCK_HighId + self.Offset)
   self._HighId = result
   self._HighId_cached = true
   return result
}

func (self *MESSAGE_RESOURCE_BLOCK) OffsetToEntries() uint32 {
   if self._OffsetToEntries_cached {
      return self._OffsetToEntries
   }
   result := ParseUint32(self.Reader, self.Profile.Off_MESSAGE_RESOURCE_BLOCK_OffsetToEntries + self.Offset)
   self._OffsetToEntries = result
   self._OffsetToEntries_cached = true
   return result
}
func (self *MESSAGE_RESOURCE_BLOCK) DebugString() string {
    result := fmt.Sprintf("struct MESSAGE_RESOURCE_BLOCK @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  LowId: %#0x\n", self.LowId())
    result += fmt.Sprintf("  HighId: %#0x\n", self.HighId())
    result += fmt.Sprintf("  OffsetToEntries: %#0x\n", self.OffsetToEntries())
    return result
}

type MESSAGE_RESOURCE_DATA struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
    _NumberOfBlocks uint32
    _NumberOfBlocks_cached bool

    __Blocks []*MESSAGE_RESOURCE_BLOCK
    __Blocks_cached bool

}

func (self *MESSAGE_RESOURCE_DATA) Size() int {
    return 0
}

func (self *MESSAGE_RESOURCE_DATA) NumberOfBlocks() uint32 {
   if self._NumberOfBlocks_cached {
      return self._NumberOfBlocks
   }
   result := ParseUint32(self.Reader, self.Profile.Off_MESSAGE_RESOURCE_DATA_NumberOfBlocks + self.Offset)
   self._NumberOfBlocks = result
   self._NumberOfBlocks_cached = true
   return result
}

func (self *MESSAGE_RESOURCE_DATA) _Blocks() []*MESSAGE_RESOURCE_BLOCK {
   return ParseArray_MESSAGE_RESOURCE_BLOCK(self.Profile, self.Reader, self.Profile.Off_MESSAGE_RESOURCE_DATA__Blocks + self.Offset, 0)
}
func (self *MESSAGE_RESOURCE_DATA) DebugString() string {
    result := fmt.Sprintf("struct MESSAGE_RESOURCE_DATA @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  NumberOfBlocks: %#0x\n", self.NumberOfBlocks())
    return result
}

type MESSAGE_RESOURCE_ENTRY struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
    _Length uint16
    _Length_cached bool

    _Flags uint16
    _Flags_cached bool

}

func (self *MESSAGE_RESOURCE_ENTRY) Size() int {
    return 0
}

func (self *MESSAGE_RESOURCE_ENTRY) Length() uint16 {
   if self._Length_cached {
       return self._Length
   }
   result := ParseUint16(self.Reader, self.Profile.Off_MESSAGE_RESOURCE_ENTRY_Length + self.Offset)
   self._Length = result
   self._Length_cached = true
   return result
}

func (self *MESSAGE_RESOURCE_ENTRY) Flags() uint16 {
   if self._Flags_cached {
       return self._Flags
   }
   result := ParseUint16(self.Reader, self.Profile.Off_MESSAGE_RESOURCE_ENTRY_Flags + self.Offset)
   self._Flags = result
   self._Flags_cached = true
   return result
}


func (self *MESSAGE_RESOURCE_ENTRY) Text() string {
  return ParseTerminatedUTF16String(self.Reader, self.Profile.Off_MESSAGE_RESOURCE_ENTRY_Text + self.Offset)
}
func (self *MESSAGE_RESOURCE_ENTRY) DebugString() string {
    result := fmt.Sprintf("struct MESSAGE_RESOURCE_ENTRY @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  Length: %#0x\n", self.Length())
    result += fmt.Sprintf("  Flags: %#0x\n", self.Flags())
    result += fmt.Sprintf("  Text: %v\n", string(self.Text()))
    return result
}

type PrefixedString struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
    _Length uint16
    _Length_cached bool

    __Buffer uint8
    __Buffer_cached bool

}

func (self *PrefixedString) Size() int {
    return 2
}

func (self *PrefixedString) Length() uint16 {
   if self._Length_cached {
       return self._Length
   }
   result := ParseUint16(self.Reader, self.Profile.Off_PrefixedString_Length + self.Offset)
   self._Length = result
   self._Length_cached = true
   return result
}

func (self *PrefixedString) _Buffer() byte {
   if self.__Buffer_cached {
       return self.__Buffer
   }
   result := ParseUint8(self.Reader, self.Profile.Off_PrefixedString__Buffer + self.Offset)
   self.__Buffer = result
   self.__Buffer_cached = true
   return result
}
func (self *PrefixedString) DebugString() string {
    result := fmt.Sprintf("struct PrefixedString @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  Length: %#0x\n", self.Length())
    result += fmt.Sprintf("  _Buffer: %#0x\n", self._Buffer())
    return result
}

type ResourceString struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
    _Length uint16
    _Length_cached bool

    _ValueLength uint16
    _ValueLength_cached bool

    _Type uint16
    _Type_cached bool

}

func (self *ResourceString) Size() int {
    return 0
}

func (self *ResourceString) Length() uint16 {
   if self._Length_cached {
       return self._Length
   }
   result := ParseUint16(self.Reader, self.Profile.Off_ResourceString_Length + self.Offset)
   self._Length = result
   self._Length_cached = true
   return result
}

func (self *ResourceString) ValueLength() uint16 {
   if self._ValueLength_cached {
       return self._ValueLength
   }
   result := ParseUint16(self.Reader, self.Profile.Off_ResourceString_ValueLength + self.Offset)
   self._ValueLength = result
   self._ValueLength_cached = true
   return result
}

func (self *ResourceString) Type() uint16 {
   if self._Type_cached {
       return self._Type
   }
   result := ParseUint16(self.Reader, self.Profile.Off_ResourceString_Type + self.Offset)
   self._Type = result
   self._Type_cached = true
   return result
}


func (self *ResourceString) Key() string {
  return ParseTerminatedUTF16String(self.Reader, self.Profile.Off_ResourceString_Key + self.Offset)
}
func (self *ResourceString) DebugString() string {
    result := fmt.Sprintf("struct ResourceString @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  Length: %#0x\n", self.Length())
    result += fmt.Sprintf("  ValueLength: %#0x\n", self.ValueLength())
    result += fmt.Sprintf("  Type: %#0x\n", self.Type())
    result += fmt.Sprintf("  Key: %v\n", string(self.Key()))
    return result
}

type StringFileInfo struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
    _Length uint16
    _Length_cached bool

    _ValueLength uint16
    _ValueLength_cached bool

    _Type uint16
    _Type_cached bool

}

func (self *StringFileInfo) Size() int {
    return 0
}

func (self *StringFileInfo) Length() uint16 {
   if self._Length_cached {
       return self._Length
   }
   result := ParseUint16(self.Reader, self.Profile.Off_StringFileInfo_Length + self.Offset)
   self._Length = result
   self._Length_cached = true
   return result
}

func (self *StringFileInfo) ValueLength() uint16 {
   if self._ValueLength_cached {
       return self._ValueLength
   }
   result := ParseUint16(self.Reader, self.Profile.Off_StringFileInfo_ValueLength + self.Offset)
   self._ValueLength = result
   self._ValueLength_cached = true
   return result
}

func (self *StringFileInfo) Type() uint16 {
   if self._Type_cached {
       return self._Type
   }
   result := ParseUint16(self.Reader, self.Profile.Off_StringFileInfo_Type + self.Offset)
   self._Type = result
   self._Type_cached = true
   return result
}


func (self *StringFileInfo) Key() string {
  return ParseTerminatedUTF16String(self.Reader, self.Profile.Off_StringFileInfo_Key + self.Offset)
}
func (self *StringFileInfo) DebugString() string {
    result := fmt.Sprintf("struct StringFileInfo @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  Length: %#0x\n", self.Length())
    result += fmt.Sprintf("  ValueLength: %#0x\n", self.ValueLength())
    result += fmt.Sprintf("  Type: %#0x\n", self.Type())
    result += fmt.Sprintf("  Key: %v\n", string(self.Key()))
    return result
}

type StringTable struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
    _Length uint16
    _Length_cached bool

    _ValueLength uint16
    _ValueLength_cached bool

    _Type uint16
    _Type_cached bool

}

func (self *StringTable) Size() int {
    return 0
}

func (self *StringTable) Length() uint16 {
   if self._Length_cached {
       return self._Length
   }
   result := ParseUint16(self.Reader, self.Profile.Off_StringTable_Length + self.Offset)
   self._Length = result
   self._Length_cached = true
   return result
}

func (self *StringTable) ValueLength() uint16 {
   if self._ValueLength_cached {
       return self._ValueLength
   }
   result := ParseUint16(self.Reader, self.Profile.Off_StringTable_ValueLength + self.Offset)
   self._ValueLength = result
   self._ValueLength_cached = true
   return result
}

func (self *StringTable) Type() uint16 {
   if self._Type_cached {
       return self._Type
   }
   result := ParseUint16(self.Reader, self.Profile.Off_StringTable_Type + self.Offset)
   self._Type = result
   self._Type_cached = true
   return result
}


func (self *StringTable) Key() string {
  return ParseUTF16String(self.Reader, self.Profile.Off_StringTable_Key + self.Offset, 16)
}
func (self *StringTable) DebugString() string {
    result := fmt.Sprintf("struct StringTable @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  Length: %#0x\n", self.Length())
    result += fmt.Sprintf("  ValueLength: %#0x\n", self.ValueLength())
    result += fmt.Sprintf("  Type: %#0x\n", self.Type())
    result += fmt.Sprintf("  Key: %v\n", string(self.Key()))
    return result
}

type VS_VERSIONINFO struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
    _Length uint16
    _Length_cached bool

    _ValueLength uint16
    _ValueLength_cached bool

}

func (self *VS_VERSIONINFO) Size() int {
    return 6
}

func (self *VS_VERSIONINFO) Length() uint16 {
   if self._Length_cached {
       return self._Length
   }
   result := ParseUint16(self.Reader, self.Profile.Off_VS_VERSIONINFO_Length + self.Offset)
   self._Length = result
   self._Length_cached = true
   return result
}

func (self *VS_VERSIONINFO) ValueLength() uint16 {
   if self._ValueLength_cached {
       return self._ValueLength
   }
   result := ParseUint16(self.Reader, self.Profile.Off_VS_VERSIONINFO_ValueLength + self.Offset)
   self._ValueLength = result
   self._ValueLength_cached = true
   return result
}

func (self *VS_VERSIONINFO) Type() *Enumeration {
   value := ParseUint16(self.Reader, self.Profile.Off_VS_VERSIONINFO_Type + self.Offset)
   name := "Unknown"
   switch value {

      case 0:
         name = "Binary"

      case 1:
         name = "Text"
}
   return &Enumeration{Value: uint64(value), Name: name}
}



func (self *VS_VERSIONINFO) szKey() string {
  return ParseUTF16String(self.Reader, self.Profile.Off_VS_VERSIONINFO_szKey + self.Offset, 32)
}
func (self *VS_VERSIONINFO) DebugString() string {
    result := fmt.Sprintf("struct VS_VERSIONINFO @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  Length: %#0x\n", self.Length())
    result += fmt.Sprintf("  ValueLength: %#0x\n", self.ValueLength())
    result += fmt.Sprintf("  Type: %v\n", self.Type().DebugString())
    result += fmt.Sprintf("  szKey: %v\n", string(self.szKey()))
    return result
}

type WIN_CERTIFICATE struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
    _Length uint32
    _Length_cached bool

    _Revision uint16
    _Revision_cached bool

    _CertificateType uint16
    _CertificateType_cached bool

}

func (self *WIN_CERTIFICATE) Size() int {
    return 8
}

func (self *WIN_CERTIFICATE) Length() uint32 {
   if self._Length_cached {
      return self._Length
   }
   result := ParseUint32(self.Reader, self.Profile.Off_WIN_CERTIFICATE_Length + self.Offset)
   self._Length = result
   self._Length_cached = true
   return result
}

func (self *WIN_CERTIFICATE) Revision() uint16 {
   if self._Revision_cached {
       return self._Revision
   }
   result := ParseUint16(self.Reader, self.Profile.Off_WIN_CERTIFICATE_Revision + self.Offset)
   self._Revision = result
   self._Revision_cached = true
   return result
}

func (self *WIN_CERTIFICATE) CertificateType() uint16 {
   if self._CertificateType_cached {
       return self._CertificateType
   }
   result := ParseUint16(self.Reader, self.Profile.Off_WIN_CERTIFICATE_CertificateType + self.Offset)
   self._CertificateType = result
   self._CertificateType_cached = true
   return result
}
func (self *WIN_CERTIFICATE) DebugString() string {
    result := fmt.Sprintf("struct WIN_CERTIFICATE @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  Length: %#0x\n", self.Length())
    result += fmt.Sprintf("  Revision: %#0x\n", self.Revision())
    result += fmt.Sprintf("  CertificateType: %#0x\n", self.CertificateType())
    return result
}

type GENERIC_DIRECTORY struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
    _TimeDateStamp *UnixTimeStamp32

}

func (self *GENERIC_DIRECTORY) Size() int {
    return 16
}

func (self *GENERIC_DIRECTORY) TimeDateStamp() *UnixTimeStamp32 {
    if self._TimeDateStamp != nil {
       return self._TimeDateStamp
    }
    result := self.Profile.UnixTimeStamp32(self.Reader, self.Profile.Off_GENERIC_DIRECTORY_TimeDateStamp + self.Offset)
    self._TimeDateStamp = result
    return result
}
func (self *GENERIC_DIRECTORY) DebugString() string {
    result := fmt.Sprintf("struct GENERIC_DIRECTORY @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  TimeDateStamp: {\n%v}\n", indent(self.TimeDateStamp().DebugString()))
    return result
}

type GUID struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
    _Data1 uint32
    _Data1_cached bool

    _Data2 uint16
    _Data2_cached bool

    _Data3 uint16
    _Data3_cached bool

    _Data4 []byte
    _Data4_cached bool

}

func (self *GUID) Size() int {
    return 16
}

func (self *GUID) Data1() uint32 {
   if self._Data1_cached {
      return self._Data1
   }
   result := ParseUint32(self.Reader, self.Profile.Off_GUID_Data1 + self.Offset)
   self._Data1 = result
   self._Data1_cached = true
   return result
}

func (self *GUID) Data2() uint16 {
   if self._Data2_cached {
       return self._Data2
   }
   result := ParseUint16(self.Reader, self.Profile.Off_GUID_Data2 + self.Offset)
   self._Data2 = result
   self._Data2_cached = true
   return result
}

func (self *GUID) Data3() uint16 {
   if self._Data3_cached {
       return self._Data3
   }
   result := ParseUint16(self.Reader, self.Profile.Off_GUID_Data3 + self.Offset)
   self._Data3 = result
   self._Data3_cached = true
   return result
}

func (self *GUID) Data4() []byte {
   return ParseArray_byte(self.Profile, self.Reader, self.Profile.Off_GUID_Data4 + self.Offset, 8)
}
func (self *GUID) DebugString() string {
    result := fmt.Sprintf("struct GUID @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  Data1: %#0x\n", self.Data1())
    result += fmt.Sprintf("  Data2: %#0x\n", self.Data2())
    result += fmt.Sprintf("  Data3: %#0x\n", self.Data3())
    return result
}

type IMAGE_DATA_DIRECTORY struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
    _DirSize uint32
    _DirSize_cached bool

    _VirtualAddress uint32
    _VirtualAddress_cached bool

}

func (self *IMAGE_DATA_DIRECTORY) Size() int {
    return 8
}

func (self *IMAGE_DATA_DIRECTORY) DirSize() uint32 {
   if self._DirSize_cached {
      return self._DirSize
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_DATA_DIRECTORY_DirSize + self.Offset)
   self._DirSize = result
   self._DirSize_cached = true
   return result
}

func (self *IMAGE_DATA_DIRECTORY) VirtualAddress() uint32 {
   if self._VirtualAddress_cached {
      return self._VirtualAddress
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_DATA_DIRECTORY_VirtualAddress + self.Offset)
   self._VirtualAddress = result
   self._VirtualAddress_cached = true
   return result
}
func (self *IMAGE_DATA_DIRECTORY) DebugString() string {
    result := fmt.Sprintf("struct IMAGE_DATA_DIRECTORY @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  DirSize: %#0x\n", self.DirSize())
    result += fmt.Sprintf("  VirtualAddress: %#0x\n", self.VirtualAddress())
    return result
}

type IMAGE_DEBUG_DIRECTORY struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
    _AddressOfRawData uint32
    _AddressOfRawData_cached bool

    _TimeDateStamp *UnixTimeStamp32

}

func (self *IMAGE_DEBUG_DIRECTORY) Size() int {
    return 24
}

func (self *IMAGE_DEBUG_DIRECTORY) AddressOfRawData() uint32 {
   if self._AddressOfRawData_cached {
      return self._AddressOfRawData
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_DEBUG_DIRECTORY_AddressOfRawData + self.Offset)
   self._AddressOfRawData = result
   self._AddressOfRawData_cached = true
   return result
}

func (self *IMAGE_DEBUG_DIRECTORY) TimeDateStamp() *UnixTimeStamp32 {
    if self._TimeDateStamp != nil {
       return self._TimeDateStamp
    }
    result := self.Profile.UnixTimeStamp32(self.Reader, self.Profile.Off_IMAGE_DEBUG_DIRECTORY_TimeDateStamp + self.Offset)
    self._TimeDateStamp = result
    return result
}

func (self *IMAGE_DEBUG_DIRECTORY) Type() *Enumeration {
   value := ParseUint32(self.Reader, self.Profile.Off_IMAGE_DEBUG_DIRECTORY_Type + self.Offset)
   name := "Unknown"
   switch value {

      case 0:
         name = "IMAGE_DEBUG_TYPE_UNKNOWN"

      case 1:
         name = "IMAGE_DEBUG_TYPE_COFF"

      case 2:
         name = "IMAGE_DEBUG_TYPE_CODEVIEW"

      case 3:
         name = "IMAGE_DEBUG_TYPE_FPO"

      case 4:
         name = "IMAGE_DEBUG_TYPE_MISC"

      case 5:
         name = "IMAGE_DEBUG_TYPE_EXCEPTION"

      case 6:
         name = "IMAGE_DEBUG_TYPE_FIXUP"

      case 7:
         name = "IMAGE_DEBUG_TYPE_OMAP_TO_SRC"

      case 8:
         name = "IMAGE_DEBUG_TYPE_OMAP_FROM_SRC"

      case 9:
         name = "IMAGE_DEBUG_TYPE_BORLAND"

      case 10:
         name = "IMAGE_DEBUG_TYPE_RESERVED"
}
   return &Enumeration{Value: uint64(value), Name: name}
}

func (self *IMAGE_DEBUG_DIRECTORY) DebugString() string {
    result := fmt.Sprintf("struct IMAGE_DEBUG_DIRECTORY @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  AddressOfRawData: %#0x\n", self.AddressOfRawData())
    result += fmt.Sprintf("  TimeDateStamp: {\n%v}\n", indent(self.TimeDateStamp().DebugString()))
    result += fmt.Sprintf("  Type: %v\n", self.Type().DebugString())
    return result
}

type IMAGE_DOS_HEADER struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
    _E_lfanew int32
    _E_lfanew_cached bool

    _E_magic uint16
    _E_magic_cached bool

}

func (self *IMAGE_DOS_HEADER) Size() int {
    return 64
}

func (self *IMAGE_DOS_HEADER) E_lfanew() int32 {
   if self._E_lfanew_cached {
     return self._E_lfanew
   }
   result := ParseInt32(self.Reader, self.Profile.Off_IMAGE_DOS_HEADER_E_lfanew + self.Offset)
   self._E_lfanew = result
   self._E_lfanew_cached = true
   return result
}

func (self *IMAGE_DOS_HEADER) E_magic() uint16 {
   if self._E_magic_cached {
       return self._E_magic
   }
   result := ParseUint16(self.Reader, self.Profile.Off_IMAGE_DOS_HEADER_E_magic + self.Offset)
   self._E_magic = result
   self._E_magic_cached = true
   return result
}
func (self *IMAGE_DOS_HEADER) DebugString() string {
    result := fmt.Sprintf("struct IMAGE_DOS_HEADER @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  E_lfanew: %#0x\n", self.E_lfanew())
    result += fmt.Sprintf("  E_magic: %#0x\n", self.E_magic())
    return result
}

type IMAGE_EXPORT_DIRECTORY struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
    _AddressOfFunctions uint32
    _AddressOfFunctions_cached bool

    _AddressOfNameOrdinals uint32
    _AddressOfNameOrdinals_cached bool

    _AddressOfNames uint32
    _AddressOfNames_cached bool

    _Base uint32
    _Base_cached bool

    _Name uint32
    _Name_cached bool

    _NumberOfFunctions uint32
    _NumberOfFunctions_cached bool

    _NumberOfNames uint32
    _NumberOfNames_cached bool

    _TimeDateStamp *UnixTimeStamp32

    _ordinals []uint16
    _ordinals_cached bool

    _names []uint32
    _names_cached bool

    _funcs64 []uint64
    _funcs64_cached bool

}

func (self *IMAGE_EXPORT_DIRECTORY) Size() int {
    return 40
}

func (self *IMAGE_EXPORT_DIRECTORY) AddressOfFunctions() uint32 {
   if self._AddressOfFunctions_cached {
      return self._AddressOfFunctions
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_EXPORT_DIRECTORY_AddressOfFunctions + self.Offset)
   self._AddressOfFunctions = result
   self._AddressOfFunctions_cached = true
   return result
}

func (self *IMAGE_EXPORT_DIRECTORY) AddressOfNameOrdinals() uint32 {
   if self._AddressOfNameOrdinals_cached {
      return self._AddressOfNameOrdinals
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_EXPORT_DIRECTORY_AddressOfNameOrdinals + self.Offset)
   self._AddressOfNameOrdinals = result
   self._AddressOfNameOrdinals_cached = true
   return result
}

func (self *IMAGE_EXPORT_DIRECTORY) AddressOfNames() uint32 {
   if self._AddressOfNames_cached {
      return self._AddressOfNames
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_EXPORT_DIRECTORY_AddressOfNames + self.Offset)
   self._AddressOfNames = result
   self._AddressOfNames_cached = true
   return result
}

func (self *IMAGE_EXPORT_DIRECTORY) Base() uint32 {
   if self._Base_cached {
      return self._Base
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_EXPORT_DIRECTORY_Base + self.Offset)
   self._Base = result
   self._Base_cached = true
   return result
}

func (self *IMAGE_EXPORT_DIRECTORY) Name() uint32 {
   if self._Name_cached {
      return self._Name
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_EXPORT_DIRECTORY_Name + self.Offset)
   self._Name = result
   self._Name_cached = true
   return result
}

func (self *IMAGE_EXPORT_DIRECTORY) NumberOfFunctions() uint32 {
   if self._NumberOfFunctions_cached {
      return self._NumberOfFunctions
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_EXPORT_DIRECTORY_NumberOfFunctions + self.Offset)
   self._NumberOfFunctions = result
   self._NumberOfFunctions_cached = true
   return result
}

func (self *IMAGE_EXPORT_DIRECTORY) NumberOfNames() uint32 {
   if self._NumberOfNames_cached {
      return self._NumberOfNames
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_EXPORT_DIRECTORY_NumberOfNames + self.Offset)
   self._NumberOfNames = result
   self._NumberOfNames_cached = true
   return result
}

func (self *IMAGE_EXPORT_DIRECTORY) TimeDateStamp() *UnixTimeStamp32 {
    if self._TimeDateStamp != nil {
       return self._TimeDateStamp
    }
    result := self.Profile.UnixTimeStamp32(self.Reader, self.Profile.Off_IMAGE_EXPORT_DIRECTORY_TimeDateStamp + self.Offset)
    self._TimeDateStamp = result
    return result
}

func (self *IMAGE_EXPORT_DIRECTORY) ordinals() []uint16 {
   return ParseArray_uint16(self.Profile, self.Reader, self.Profile.Off_IMAGE_EXPORT_DIRECTORY_ordinals + self.Offset, 0)
}

func (self *IMAGE_EXPORT_DIRECTORY) names() []uint32 {
   return ParseArray_uint32(self.Profile, self.Reader, self.Profile.Off_IMAGE_EXPORT_DIRECTORY_names + self.Offset, 0)
}

func (self *IMAGE_EXPORT_DIRECTORY) funcs64() []uint64 {
   return ParseArray_uint64(self.Profile, self.Reader, self.Profile.Off_IMAGE_EXPORT_DIRECTORY_funcs64 + self.Offset, 0)
}
func (self *IMAGE_EXPORT_DIRECTORY) DebugString() string {
    result := fmt.Sprintf("struct IMAGE_EXPORT_DIRECTORY @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  AddressOfFunctions: %#0x\n", self.AddressOfFunctions())
    result += fmt.Sprintf("  AddressOfNameOrdinals: %#0x\n", self.AddressOfNameOrdinals())
    result += fmt.Sprintf("  AddressOfNames: %#0x\n", self.AddressOfNames())
    result += fmt.Sprintf("  Base: %#0x\n", self.Base())
    result += fmt.Sprintf("  Name: %#0x\n", self.Name())
    result += fmt.Sprintf("  NumberOfFunctions: %#0x\n", self.NumberOfFunctions())
    result += fmt.Sprintf("  NumberOfNames: %#0x\n", self.NumberOfNames())
    result += fmt.Sprintf("  TimeDateStamp: {\n%v}\n", indent(self.TimeDateStamp().DebugString()))
    return result
}

type IMAGE_FILE_HEADER struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
    _Characteristics uint16
    _Characteristics_cached bool

    _NumberOfSections uint16
    _NumberOfSections_cached bool

    _SizeOfOptionalHeader uint16
    _SizeOfOptionalHeader_cached bool

    _TimeDateStamp *UnixTimeStamp32

    _TimeDateStampRaw uint32
    _TimeDateStampRaw_cached bool

}

func (self *IMAGE_FILE_HEADER) Size() int {
    return 20
}

func (self *IMAGE_FILE_HEADER) Characteristics() uint16 {
   if self._Characteristics_cached {
       return self._Characteristics
   }
   result := ParseUint16(self.Reader, self.Profile.Off_IMAGE_FILE_HEADER_Characteristics + self.Offset)
   self._Characteristics = result
   self._Characteristics_cached = true
   return result
}

func (self *IMAGE_FILE_HEADER) Machine() *Enumeration {
   value := ParseUint16(self.Reader, self.Profile.Off_IMAGE_FILE_HEADER_Machine + self.Offset)
   name := "Unknown"
   switch value {

      case 332:
         name = "IMAGE_FILE_MACHINE_I386"

      case 448:
         name = "IMAGE_FILE_MACHINE_ARM"

      case 512:
         name = "IMAGE_FILE_MACHINE_IA64"

      case 34404:
         name = "IMAGE_FILE_MACHINE_AMD64"
}
   return &Enumeration{Value: uint64(value), Name: name}
}


func (self *IMAGE_FILE_HEADER) NumberOfSections() uint16 {
   if self._NumberOfSections_cached {
       return self._NumberOfSections
   }
   result := ParseUint16(self.Reader, self.Profile.Off_IMAGE_FILE_HEADER_NumberOfSections + self.Offset)
   self._NumberOfSections = result
   self._NumberOfSections_cached = true
   return result
}

func (self *IMAGE_FILE_HEADER) SizeOfOptionalHeader() uint16 {
   if self._SizeOfOptionalHeader_cached {
       return self._SizeOfOptionalHeader
   }
   result := ParseUint16(self.Reader, self.Profile.Off_IMAGE_FILE_HEADER_SizeOfOptionalHeader + self.Offset)
   self._SizeOfOptionalHeader = result
   self._SizeOfOptionalHeader_cached = true
   return result
}

func (self *IMAGE_FILE_HEADER) TimeDateStamp() *UnixTimeStamp32 {
    if self._TimeDateStamp != nil {
       return self._TimeDateStamp
    }
    result := self.Profile.UnixTimeStamp32(self.Reader, self.Profile.Off_IMAGE_FILE_HEADER_TimeDateStamp + self.Offset)
    self._TimeDateStamp = result
    return result
}

func (self *IMAGE_FILE_HEADER) TimeDateStampRaw() uint32 {
   if self._TimeDateStampRaw_cached {
      return self._TimeDateStampRaw
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_FILE_HEADER_TimeDateStampRaw + self.Offset)
   self._TimeDateStampRaw = result
   self._TimeDateStampRaw_cached = true
   return result
}
func (self *IMAGE_FILE_HEADER) DebugString() string {
    result := fmt.Sprintf("struct IMAGE_FILE_HEADER @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  Characteristics: %#0x\n", self.Characteristics())
    result += fmt.Sprintf("  Machine: %v\n", self.Machine().DebugString())
    result += fmt.Sprintf("  NumberOfSections: %#0x\n", self.NumberOfSections())
    result += fmt.Sprintf("  SizeOfOptionalHeader: %#0x\n", self.SizeOfOptionalHeader())
    result += fmt.Sprintf("  TimeDateStamp: {\n%v}\n", indent(self.TimeDateStamp().DebugString()))
    result += fmt.Sprintf("  TimeDateStampRaw: %#0x\n", self.TimeDateStampRaw())
    return result
}

type IMAGE_IMPORT_BY_NAME struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
}

func (self *IMAGE_IMPORT_BY_NAME) Size() int {
    return 4
}


func (self *IMAGE_IMPORT_BY_NAME) Name() string {
  return ParseTerminatedString(self.Reader, self.Profile.Off_IMAGE_IMPORT_BY_NAME_Name + self.Offset)
}
func (self *IMAGE_IMPORT_BY_NAME) DebugString() string {
    result := fmt.Sprintf("struct IMAGE_IMPORT_BY_NAME @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  Name: %v\n", string(self.Name()))
    return result
}

type IMAGE_IMPORT_DESCRIPTOR struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
    _Characteristics uint32
    _Characteristics_cached bool

    _Name uint32
    _Name_cached bool

    _OriginalFirstThunk uint32
    _OriginalFirstThunk_cached bool

}

func (self *IMAGE_IMPORT_DESCRIPTOR) Size() int {
    return 20
}

func (self *IMAGE_IMPORT_DESCRIPTOR) Characteristics() uint32 {
   if self._Characteristics_cached {
      return self._Characteristics
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_IMPORT_DESCRIPTOR_Characteristics + self.Offset)
   self._Characteristics = result
   self._Characteristics_cached = true
   return result
}

func (self *IMAGE_IMPORT_DESCRIPTOR) Name() uint32 {
   if self._Name_cached {
      return self._Name
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_IMPORT_DESCRIPTOR_Name + self.Offset)
   self._Name = result
   self._Name_cached = true
   return result
}

func (self *IMAGE_IMPORT_DESCRIPTOR) OriginalFirstThunk() uint32 {
   if self._OriginalFirstThunk_cached {
      return self._OriginalFirstThunk
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_IMPORT_DESCRIPTOR_OriginalFirstThunk + self.Offset)
   self._OriginalFirstThunk = result
   self._OriginalFirstThunk_cached = true
   return result
}
func (self *IMAGE_IMPORT_DESCRIPTOR) DebugString() string {
    result := fmt.Sprintf("struct IMAGE_IMPORT_DESCRIPTOR @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  Characteristics: %#0x\n", self.Characteristics())
    result += fmt.Sprintf("  Name: %#0x\n", self.Name())
    result += fmt.Sprintf("  OriginalFirstThunk: %#0x\n", self.OriginalFirstThunk())
    return result
}

type IMAGE_NT_HEADERS struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
    _FileHeader *IMAGE_FILE_HEADER

    _OptionalHeader *IMAGE_OPTIONAL_HEADER

    _Signature uint32
    _Signature_cached bool

}

func (self *IMAGE_NT_HEADERS) Size() int {
    return 248
}

func (self *IMAGE_NT_HEADERS) FileHeader() *IMAGE_FILE_HEADER {
    if self._FileHeader != nil {
       return self._FileHeader
    }
    result := self.Profile.IMAGE_FILE_HEADER(self.Reader, self.Profile.Off_IMAGE_NT_HEADERS_FileHeader + self.Offset)
    self._FileHeader = result
    return result
}

func (self *IMAGE_NT_HEADERS) OptionalHeader() *IMAGE_OPTIONAL_HEADER {
    if self._OptionalHeader != nil {
       return self._OptionalHeader
    }
    result := self.Profile.IMAGE_OPTIONAL_HEADER(self.Reader, self.Profile.Off_IMAGE_NT_HEADERS_OptionalHeader + self.Offset)
    self._OptionalHeader = result
    return result
}

func (self *IMAGE_NT_HEADERS) Signature() uint32 {
   if self._Signature_cached {
      return self._Signature
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_NT_HEADERS_Signature + self.Offset)
   self._Signature = result
   self._Signature_cached = true
   return result
}
func (self *IMAGE_NT_HEADERS) DebugString() string {
    result := fmt.Sprintf("struct IMAGE_NT_HEADERS @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  FileHeader: {\n%v}\n", indent(self.FileHeader().DebugString()))
    result += fmt.Sprintf("  OptionalHeader: {\n%v}\n", indent(self.OptionalHeader().DebugString()))
    result += fmt.Sprintf("  Signature: %#0x\n", self.Signature())
    return result
}

type IMAGE_OPTIONAL_HEADER struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
    _CheckSum uint32
    _CheckSum_cached bool

    _DataDirectory []*IMAGE_DATA_DIRECTORY
    _DataDirectory_cached bool

    _ImageBase uint32
    _ImageBase_cached bool

    _Magic uint16
    _Magic_cached bool

    _SizeOfHeaders uint32
    _SizeOfHeaders_cached bool

}

func (self *IMAGE_OPTIONAL_HEADER) Size() int {
    return 224
}

func (self *IMAGE_OPTIONAL_HEADER) CheckSum() uint32 {
   if self._CheckSum_cached {
      return self._CheckSum
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_OPTIONAL_HEADER_CheckSum + self.Offset)
   self._CheckSum = result
   self._CheckSum_cached = true
   return result
}

func (self *IMAGE_OPTIONAL_HEADER) DataDirectory() []*IMAGE_DATA_DIRECTORY {
   return ParseArray_IMAGE_DATA_DIRECTORY(self.Profile, self.Reader, self.Profile.Off_IMAGE_OPTIONAL_HEADER_DataDirectory + self.Offset, 128)
}

func (self *IMAGE_OPTIONAL_HEADER) ImageBase() uint32 {
   if self._ImageBase_cached {
      return self._ImageBase
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_OPTIONAL_HEADER_ImageBase + self.Offset)
   self._ImageBase = result
   self._ImageBase_cached = true
   return result
}

func (self *IMAGE_OPTIONAL_HEADER) Magic() uint16 {
   if self._Magic_cached {
       return self._Magic
   }
   result := ParseUint16(self.Reader, self.Profile.Off_IMAGE_OPTIONAL_HEADER_Magic + self.Offset)
   self._Magic = result
   self._Magic_cached = true
   return result
}

func (self *IMAGE_OPTIONAL_HEADER) SizeOfHeaders() uint32 {
   if self._SizeOfHeaders_cached {
      return self._SizeOfHeaders
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_OPTIONAL_HEADER_SizeOfHeaders + self.Offset)
   self._SizeOfHeaders = result
   self._SizeOfHeaders_cached = true
   return result
}
func (self *IMAGE_OPTIONAL_HEADER) DebugString() string {
    result := fmt.Sprintf("struct IMAGE_OPTIONAL_HEADER @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  CheckSum: %#0x\n", self.CheckSum())
    result += fmt.Sprintf("  ImageBase: %#0x\n", self.ImageBase())
    result += fmt.Sprintf("  Magic: %#0x\n", self.Magic())
    result += fmt.Sprintf("  SizeOfHeaders: %#0x\n", self.SizeOfHeaders())
    return result
}

type IMAGE_OPTIONAL_HEADER64 struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
    _DataDirectory []*IMAGE_DATA_DIRECTORY
    _DataDirectory_cached bool

    _ImageBase uint64
    _ImageBase_cached bool

    _Magic uint16
    _Magic_cached bool

    _SizeOfHeaders uint32
    _SizeOfHeaders_cached bool

}

func (self *IMAGE_OPTIONAL_HEADER64) Size() int {
    return 240
}

func (self *IMAGE_OPTIONAL_HEADER64) DataDirectory() []*IMAGE_DATA_DIRECTORY {
   return ParseArray_IMAGE_DATA_DIRECTORY(self.Profile, self.Reader, self.Profile.Off_IMAGE_OPTIONAL_HEADER64_DataDirectory + self.Offset, 128)
}

func (self *IMAGE_OPTIONAL_HEADER64) ImageBase() uint64 {
    if self._ImageBase_cached {
        return self._ImageBase
    }
    result := ParseUint64(self.Reader, self.Profile.Off_IMAGE_OPTIONAL_HEADER64_ImageBase + self.Offset)
    self._ImageBase = result
    self._ImageBase_cached = true
    return result
}

func (self *IMAGE_OPTIONAL_HEADER64) Magic() uint16 {
   if self._Magic_cached {
       return self._Magic
   }
   result := ParseUint16(self.Reader, self.Profile.Off_IMAGE_OPTIONAL_HEADER64_Magic + self.Offset)
   self._Magic = result
   self._Magic_cached = true
   return result
}

func (self *IMAGE_OPTIONAL_HEADER64) SizeOfHeaders() uint32 {
   if self._SizeOfHeaders_cached {
      return self._SizeOfHeaders
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_OPTIONAL_HEADER64_SizeOfHeaders + self.Offset)
   self._SizeOfHeaders = result
   self._SizeOfHeaders_cached = true
   return result
}
func (self *IMAGE_OPTIONAL_HEADER64) DebugString() string {
    result := fmt.Sprintf("struct IMAGE_OPTIONAL_HEADER64 @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  ImageBase: %#0x\n", self.ImageBase())
    result += fmt.Sprintf("  Magic: %#0x\n", self.Magic())
    result += fmt.Sprintf("  SizeOfHeaders: %#0x\n", self.SizeOfHeaders())
    return result
}

type IMAGE_RESOURCE_DATA_ENTRY struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
    _OffsetToData uint32
    _OffsetToData_cached bool

    _DataSize uint32
    _DataSize_cached bool

    _CodePage uint32
    _CodePage_cached bool

}

func (self *IMAGE_RESOURCE_DATA_ENTRY) Size() int {
    return 16
}

func (self *IMAGE_RESOURCE_DATA_ENTRY) OffsetToData() uint32 {
   if self._OffsetToData_cached {
      return self._OffsetToData
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_RESOURCE_DATA_ENTRY_OffsetToData + self.Offset)
   self._OffsetToData = result
   self._OffsetToData_cached = true
   return result
}

func (self *IMAGE_RESOURCE_DATA_ENTRY) DataSize() uint32 {
   if self._DataSize_cached {
      return self._DataSize
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_RESOURCE_DATA_ENTRY_DataSize + self.Offset)
   self._DataSize = result
   self._DataSize_cached = true
   return result
}

func (self *IMAGE_RESOURCE_DATA_ENTRY) CodePage() uint32 {
   if self._CodePage_cached {
      return self._CodePage
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_RESOURCE_DATA_ENTRY_CodePage + self.Offset)
   self._CodePage = result
   self._CodePage_cached = true
   return result
}
func (self *IMAGE_RESOURCE_DATA_ENTRY) DebugString() string {
    result := fmt.Sprintf("struct IMAGE_RESOURCE_DATA_ENTRY @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  OffsetToData: %#0x\n", self.OffsetToData())
    result += fmt.Sprintf("  DataSize: %#0x\n", self.DataSize())
    result += fmt.Sprintf("  CodePage: %#0x\n", self.CodePage())
    return result
}

type IMAGE_RESOURCE_DIRECTORY struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
    _NumberOfIdEntries uint16
    _NumberOfIdEntries_cached bool

    _NumberOfNamedEntries uint16
    _NumberOfNamedEntries_cached bool

    _TimeDateStamp *UnixTimeStamp32

    __Entries []*IMAGE_RESOURCE_DIRECTORY_ENTRY
    __Entries_cached bool

}

func (self *IMAGE_RESOURCE_DIRECTORY) Size() int {
    return 16
}

func (self *IMAGE_RESOURCE_DIRECTORY) NumberOfIdEntries() uint16 {
   if self._NumberOfIdEntries_cached {
       return self._NumberOfIdEntries
   }
   result := ParseUint16(self.Reader, self.Profile.Off_IMAGE_RESOURCE_DIRECTORY_NumberOfIdEntries + self.Offset)
   self._NumberOfIdEntries = result
   self._NumberOfIdEntries_cached = true
   return result
}

func (self *IMAGE_RESOURCE_DIRECTORY) NumberOfNamedEntries() uint16 {
   if self._NumberOfNamedEntries_cached {
       return self._NumberOfNamedEntries
   }
   result := ParseUint16(self.Reader, self.Profile.Off_IMAGE_RESOURCE_DIRECTORY_NumberOfNamedEntries + self.Offset)
   self._NumberOfNamedEntries = result
   self._NumberOfNamedEntries_cached = true
   return result
}

func (self *IMAGE_RESOURCE_DIRECTORY) TimeDateStamp() *UnixTimeStamp32 {
    if self._TimeDateStamp != nil {
       return self._TimeDateStamp
    }
    result := self.Profile.UnixTimeStamp32(self.Reader, self.Profile.Off_IMAGE_RESOURCE_DIRECTORY_TimeDateStamp + self.Offset)
    self._TimeDateStamp = result
    return result
}

func (self *IMAGE_RESOURCE_DIRECTORY) _Entries() []*IMAGE_RESOURCE_DIRECTORY_ENTRY {
   return ParseArray_IMAGE_RESOURCE_DIRECTORY_ENTRY(self.Profile, self.Reader, self.Profile.Off_IMAGE_RESOURCE_DIRECTORY__Entries + self.Offset, 0)
}
func (self *IMAGE_RESOURCE_DIRECTORY) DebugString() string {
    result := fmt.Sprintf("struct IMAGE_RESOURCE_DIRECTORY @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  NumberOfIdEntries: %#0x\n", self.NumberOfIdEntries())
    result += fmt.Sprintf("  NumberOfNamedEntries: %#0x\n", self.NumberOfNamedEntries())
    result += fmt.Sprintf("  TimeDateStamp: {\n%v}\n", indent(self.TimeDateStamp().DebugString()))
    return result
}

type IMAGE_RESOURCE_DIRECTORY_ENTRY struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
    _DataIsDirectory uint64
    _DataIsDirectory_cached bool

    _NameIsString uint64
    _NameIsString_cached bool

    _NameOffset uint64
    _NameOffset_cached bool

    _OffsetToData uint64
    _OffsetToData_cached bool

    _OffsetToDirectory uint64
    _OffsetToDirectory_cached bool

}

func (self *IMAGE_RESOURCE_DIRECTORY_ENTRY) Size() int {
    return 8
}

func (self *IMAGE_RESOURCE_DIRECTORY_ENTRY) Type() *Enumeration {
   value := ParseUint8(self.Reader, self.Profile.Off_IMAGE_RESOURCE_DIRECTORY_ENTRY_Type + self.Offset)
   name := "Unknown"
   switch value {

      case 1:
         name = "RT_CURSOR"

      case 2:
         name = "RT_BITMAP"

      case 3:
         name = "RT_ICON"

      case 4:
         name = "RT_MENU"

      case 5:
         name = "RT_DIALOG"

      case 6:
         name = "RT_STRING"

      case 7:
         name = "RT_FONTDIR"

      case 8:
         name = "RT_FONT"

      case 9:
         name = "RT_ACCELERATOR"

      case 10:
         name = "RT_RCDATA"

      case 11:
         name = "RT_MESSAGETABLE"

      case 12:
         name = "RT_GROUP_CURSOR"

      case 14:
         name = "RT_GROUP_ICON"

      case 16:
         name = "RT_VERSION"

      case 17:
         name = "RT_DLGINCLUDE"

      case 19:
         name = "RT_PLUGPLAY"

      case 20:
         name = "RT_VXD"

      case 21:
         name = "RT_ANICURSOR"

      case 22:
         name = "RT_ANIICON"

      case 23:
         name = "RT_HTML"

      case 24:
         name = "RT_MANIFEST"
}
   return &Enumeration{Value: uint64(value), Name: name}
}


func (self *IMAGE_RESOURCE_DIRECTORY_ENTRY) DataIsDirectory() uint64 {
   value := ParseUint32(self.Reader, self.Profile.Off_IMAGE_RESOURCE_DIRECTORY_ENTRY_DataIsDirectory + self.Offset)
   return (uint64(value) & 0xffffffff) >> 0x1f
}

func (self *IMAGE_RESOURCE_DIRECTORY_ENTRY) NameIsString() uint64 {
   value := ParseUint32(self.Reader, self.Profile.Off_IMAGE_RESOURCE_DIRECTORY_ENTRY_NameIsString + self.Offset)
   return (uint64(value) & 0xffffffff) >> 0x1f
}

func (self *IMAGE_RESOURCE_DIRECTORY_ENTRY) NameOffset() uint64 {
   value := ParseUint32(self.Reader, self.Profile.Off_IMAGE_RESOURCE_DIRECTORY_ENTRY_NameOffset + self.Offset)
   return (uint64(value) & 0x7fffffff) >> 0x0
}

func (self *IMAGE_RESOURCE_DIRECTORY_ENTRY) OffsetToData() uint64 {
   value := ParseUint32(self.Reader, self.Profile.Off_IMAGE_RESOURCE_DIRECTORY_ENTRY_OffsetToData + self.Offset)
   return (uint64(value) & 0x7fffffff) >> 0x0
}

func (self *IMAGE_RESOURCE_DIRECTORY_ENTRY) OffsetToDirectory() uint64 {
   value := ParseUint32(self.Reader, self.Profile.Off_IMAGE_RESOURCE_DIRECTORY_ENTRY_OffsetToDirectory + self.Offset)
   return (uint64(value) & 0x7fffffff) >> 0x0
}
func (self *IMAGE_RESOURCE_DIRECTORY_ENTRY) DebugString() string {
    result := fmt.Sprintf("struct IMAGE_RESOURCE_DIRECTORY_ENTRY @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  Type: %v\n", self.Type().DebugString())
    result += fmt.Sprintf("  DataIsDirectory: %#0x\n", self.DataIsDirectory())
    result += fmt.Sprintf("  NameIsString: %#0x\n", self.NameIsString())
    result += fmt.Sprintf("  NameOffset: %#0x\n", self.NameOffset())
    result += fmt.Sprintf("  OffsetToData: %#0x\n", self.OffsetToData())
    result += fmt.Sprintf("  OffsetToDirectory: %#0x\n", self.OffsetToDirectory())
    return result
}

type IMAGE_SECTION_HEADER struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
    _Characteristics uint32
    _Characteristics_cached bool

    _PointerToRawData uint32
    _PointerToRawData_cached bool

    _SizeOfRawData uint32
    _SizeOfRawData_cached bool

    _VirtualAddress uint32
    _VirtualAddress_cached bool

}

func (self *IMAGE_SECTION_HEADER) Size() int {
    return 40
}

func (self *IMAGE_SECTION_HEADER) Characteristics() uint32 {
   if self._Characteristics_cached {
      return self._Characteristics
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_SECTION_HEADER_Characteristics + self.Offset)
   self._Characteristics = result
   self._Characteristics_cached = true
   return result
}


func (self *IMAGE_SECTION_HEADER) Name() string {
  return ParseTerminatedString(self.Reader, self.Profile.Off_IMAGE_SECTION_HEADER_Name + self.Offset)
}

func (self *IMAGE_SECTION_HEADER) PointerToRawData() uint32 {
   if self._PointerToRawData_cached {
      return self._PointerToRawData
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_SECTION_HEADER_PointerToRawData + self.Offset)
   self._PointerToRawData = result
   self._PointerToRawData_cached = true
   return result
}

func (self *IMAGE_SECTION_HEADER) SizeOfRawData() uint32 {
   if self._SizeOfRawData_cached {
      return self._SizeOfRawData
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_SECTION_HEADER_SizeOfRawData + self.Offset)
   self._SizeOfRawData = result
   self._SizeOfRawData_cached = true
   return result
}

func (self *IMAGE_SECTION_HEADER) VirtualAddress() uint32 {
   if self._VirtualAddress_cached {
      return self._VirtualAddress
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_SECTION_HEADER_VirtualAddress + self.Offset)
   self._VirtualAddress = result
   self._VirtualAddress_cached = true
   return result
}
func (self *IMAGE_SECTION_HEADER) DebugString() string {
    result := fmt.Sprintf("struct IMAGE_SECTION_HEADER @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  Characteristics: %#0x\n", self.Characteristics())
    result += fmt.Sprintf("  Name: %v\n", string(self.Name()))
    result += fmt.Sprintf("  PointerToRawData: %#0x\n", self.PointerToRawData())
    result += fmt.Sprintf("  SizeOfRawData: %#0x\n", self.SizeOfRawData())
    result += fmt.Sprintf("  VirtualAddress: %#0x\n", self.VirtualAddress())
    return result
}

type IMAGE_THUNK_DATA32 struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
    _AddressOfData uint32
    _AddressOfData_cached bool

    _ForwarderString uint32
    _ForwarderString_cached bool

    _Function uint32
    _Function_cached bool

    _Ordinal uint32
    _Ordinal_cached bool

}

func (self *IMAGE_THUNK_DATA32) Size() int {
    return 4
}

func (self *IMAGE_THUNK_DATA32) AddressOfData() uint32 {
   if self._AddressOfData_cached {
      return self._AddressOfData
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_THUNK_DATA32_AddressOfData + self.Offset)
   self._AddressOfData = result
   self._AddressOfData_cached = true
   return result
}

func (self *IMAGE_THUNK_DATA32) ForwarderString() uint32 {
   if self._ForwarderString_cached {
      return self._ForwarderString
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_THUNK_DATA32_ForwarderString + self.Offset)
   self._ForwarderString = result
   self._ForwarderString_cached = true
   return result
}

func (self *IMAGE_THUNK_DATA32) Function() uint32 {
   if self._Function_cached {
      return self._Function
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_THUNK_DATA32_Function + self.Offset)
   self._Function = result
   self._Function_cached = true
   return result
}

func (self *IMAGE_THUNK_DATA32) Ordinal() uint32 {
   if self._Ordinal_cached {
      return self._Ordinal
   }
   result := ParseUint32(self.Reader, self.Profile.Off_IMAGE_THUNK_DATA32_Ordinal + self.Offset)
   self._Ordinal = result
   self._Ordinal_cached = true
   return result
}
func (self *IMAGE_THUNK_DATA32) DebugString() string {
    result := fmt.Sprintf("struct IMAGE_THUNK_DATA32 @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  AddressOfData: %#0x\n", self.AddressOfData())
    result += fmt.Sprintf("  ForwarderString: %#0x\n", self.ForwarderString())
    result += fmt.Sprintf("  Function: %#0x\n", self.Function())
    result += fmt.Sprintf("  Ordinal: %#0x\n", self.Ordinal())
    return result
}

type IMAGE_THUNK_DATA64 struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
    _AddressOfData uint64
    _AddressOfData_cached bool

    _ForwarderString uint64
    _ForwarderString_cached bool

    _Function uint64
    _Function_cached bool

    _Ordinal uint64
    _Ordinal_cached bool

}

func (self *IMAGE_THUNK_DATA64) Size() int {
    return 8
}

func (self *IMAGE_THUNK_DATA64) AddressOfData() uint64 {
    if self._AddressOfData_cached {
        return self._AddressOfData
    }
    result := ParseUint64(self.Reader, self.Profile.Off_IMAGE_THUNK_DATA64_AddressOfData + self.Offset)
    self._AddressOfData = result
    self._AddressOfData_cached = true
    return result
}

func (self *IMAGE_THUNK_DATA64) ForwarderString() uint64 {
    if self._ForwarderString_cached {
        return self._ForwarderString
    }
    result := ParseUint64(self.Reader, self.Profile.Off_IMAGE_THUNK_DATA64_ForwarderString + self.Offset)
    self._ForwarderString = result
    self._ForwarderString_cached = true
    return result
}

func (self *IMAGE_THUNK_DATA64) Function() uint64 {
    if self._Function_cached {
        return self._Function
    }
    result := ParseUint64(self.Reader, self.Profile.Off_IMAGE_THUNK_DATA64_Function + self.Offset)
    self._Function = result
    self._Function_cached = true
    return result
}

func (self *IMAGE_THUNK_DATA64) Ordinal() uint64 {
    if self._Ordinal_cached {
        return self._Ordinal
    }
    result := ParseUint64(self.Reader, self.Profile.Off_IMAGE_THUNK_DATA64_Ordinal + self.Offset)
    self._Ordinal = result
    self._Ordinal_cached = true
    return result
}
func (self *IMAGE_THUNK_DATA64) DebugString() string {
    result := fmt.Sprintf("struct IMAGE_THUNK_DATA64 @ %#x:\n", self.Offset)
    result += fmt.Sprintf("  AddressOfData: %#0x\n", self.AddressOfData())
    result += fmt.Sprintf("  ForwarderString: %#0x\n", self.ForwarderString())
    result += fmt.Sprintf("  Function: %#0x\n", self.Function())
    result += fmt.Sprintf("  Ordinal: %#0x\n", self.Ordinal())
    return result
}

type TagVS_FIXEDFILEINFO struct {
    Reader io.ReaderAt
    Offset int64
    Profile *PeProfile
    
}

func (self *TagVS_FIXEDFILEINFO) Size() int {
    return 52
}
func (self *TagVS_FIXEDFILEINFO) DebugString() string {
    result := fmt.Sprintf("struct TagVS_FIXEDFILEINFO @ %#x:\n", self.Offset)
    return result
}

type Enumeration struct {
    Value uint64
    Name  string
}

func (self Enumeration) DebugString() string {
    return fmt.Sprintf("%s (%d)", self.Name, self.Value)
}


func ParseArray_IMAGE_DATA_DIRECTORY(profile *PeProfile, reader io.ReaderAt, offset int64, count int) []*IMAGE_DATA_DIRECTORY {
    result := make([]*IMAGE_DATA_DIRECTORY, 0, count)
    for i:=0; i<count; i++ {
      value := profile.IMAGE_DATA_DIRECTORY(reader, offset)
      result = append(result, value)
      offset += int64(value.Size())
    }
    return result
}

func ParseArray_IMAGE_RESOURCE_DIRECTORY_ENTRY(profile *PeProfile, reader io.ReaderAt, offset int64, count int) []*IMAGE_RESOURCE_DIRECTORY_ENTRY {
    result := make([]*IMAGE_RESOURCE_DIRECTORY_ENTRY, 0, count)
    for i:=0; i<count; i++ {
      value := profile.IMAGE_RESOURCE_DIRECTORY_ENTRY(reader, offset)
      result = append(result, value)
      offset += int64(value.Size())
    }
    return result
}

func ParseArray_MESSAGE_RESOURCE_BLOCK(profile *PeProfile, reader io.ReaderAt, offset int64, count int) []*MESSAGE_RESOURCE_BLOCK {
    result := make([]*MESSAGE_RESOURCE_BLOCK, 0, count)
    for i:=0; i<count; i++ {
      value := profile.MESSAGE_RESOURCE_BLOCK(reader, offset)
      result = append(result, value)
      offset += int64(value.Size())
    }
    return result
}

func ParseArray_byte(profile *PeProfile, reader io.ReaderAt, offset int64, count int) []byte {
    result := make([]byte, 0, count)
    for i:=0; i<count; i++ {
      value := ParseUint8(reader, offset)
      result = append(result, value)
      offset += int64(1)
    }
    return result
}

func ParseArray_uint16(profile *PeProfile, reader io.ReaderAt, offset int64, count int) []uint16 {
    result := make([]uint16, 0, count)
    for i:=0; i<count; i++ {
      value := ParseUint16(reader, offset)
      result = append(result, value)
      offset += int64(2)
    }
    return result
}

func ParseArray_uint32(profile *PeProfile, reader io.ReaderAt, offset int64, count int) []uint32 {
    result := make([]uint32, 0, count)
    for i:=0; i<count; i++ {
      value := ParseUint32(reader, offset)
      result = append(result, value)
      offset += int64(4)
    }
    return result
}

func ParseArray_uint64(profile *PeProfile, reader io.ReaderAt, offset int64, count int) []uint64 {
    result := make([]uint64, 0, count)
    for i:=0; i<count; i++ {
      value := ParseUint64(reader, offset)
      result = append(result, value)
      offset += int64(8)
    }
    return result
}

func ParseInt32(reader io.ReaderAt, offset int64) int32 {
    data := make([]byte, 4)
    _, err := reader.ReadAt(data, offset)
    if err != nil {
       return 0
    }
    return int32(binary.LittleEndian.Uint32(data))
}

func ParseUint16(reader io.ReaderAt, offset int64) uint16 {
    data := make([]byte, 2)
    _, err := reader.ReadAt(data, offset)
    if err != nil {
       return 0
    }
    return binary.LittleEndian.Uint16(data)
}

func ParseUint32(reader io.ReaderAt, offset int64) uint32 {
    data := make([]byte, 4)
    _, err := reader.ReadAt(data, offset)
    if err != nil {
       return 0
    }
    return binary.LittleEndian.Uint32(data)
}

func ParseUint64(reader io.ReaderAt, offset int64) uint64 {
    data := make([]byte, 8)
    _, err := reader.ReadAt(data, offset)
    if err != nil {
       return 0
    }
    return binary.LittleEndian.Uint64(data)
}

func ParseUint8(reader io.ReaderAt, offset int64) byte {
    result := make([]byte, 1)
    _, err := reader.ReadAt(result, offset)
    if err != nil {
       return 0
    }
    return result[0]
}

func ParseTerminatedString(reader io.ReaderAt, offset int64) string {
   data := make([]byte, 1024)
   n, err := reader.ReadAt(data, offset)
   if err != nil && err != io.EOF {
     return ""
   }
   idx := bytes.Index(data[:n], []byte{0})
   if idx < 0 {
      idx = n
   }
   return string(data[0:idx])
}

func ParseString(reader io.ReaderAt, offset int64, length int64) string {
   data := make([]byte, length)
   n, err := reader.ReadAt(data, offset)
   if err != nil && err != io.EOF {
      return ""
   }
   return string(data[:n])
}


func ParseTerminatedUTF16String(reader io.ReaderAt, offset int64) string {
   data := make([]byte, 1024)
   n, err := reader.ReadAt(data, offset)
   if err != nil && err != io.EOF {
     return ""
   }

   idx := bytes.Index(data[:n], []byte{0, 0})
   if idx < 0 {
      idx = n-1
   }
   if idx%2 != 0 {
      idx += 1
   }
   return UTF16BytesToUTF8(data[0:idx], binary.LittleEndian)
}

func ParseUTF16String(reader io.ReaderAt, offset int64, length int64) string {
   data := make([]byte, length)
   n, err := reader.ReadAt(data, offset)
   if err != nil && err != io.EOF {
     return ""
   }
   return UTF16BytesToUTF8(data[:n], binary.LittleEndian)
}

func UTF16BytesToUTF8(b []byte, o binary.ByteOrder) string {
	if len(b) < 2 {
		return ""
	}

	if b[0] == 0xff && b[1] == 0xfe {
		o = binary.BigEndian
		b = b[2:]
	} else if b[0] == 0xfe && b[1] == 0xff {
		o = binary.LittleEndian
		b = b[2:]
	}

	utf := make([]uint16, (len(b)+(2-1))/2)

	for i := 0; i+(2-1) < len(b); i += 2 {
		utf[i/2] = o.Uint16(b[i:])
	}
	if len(b)/2 < len(utf) {
		utf[len(utf)-1] = utf8.RuneError
	}

	return string(utf16.Decode(utf))
}


