// Code generated by 'ccgo -export-externs X -hide __syscall0,__syscall1,__syscall2,__syscall3,__syscall4,__syscall5,__syscall6 -nostdinc -nostdlib -o ../musl_linux_amd64.go -pkgname libc -static-locals-prefix _s -Iarch/x86_64 -Iarch/generic -Iobj/src/internal -Isrc/include -Isrc/internal -Iobj/include -Iinclude copyright.c src/ctype/__ctype_b_loc.c src/ctype/isalnum.c src/ctype/isalpha.c src/ctype/isdigit.c src/ctype/islower.c src/ctype/isprint.c src/ctype/isupper.c src/ctype/isxdigit.c src/dirent/closedir.c src/dirent/opendir.c src/dirent/readdir.c src/internal/floatscan.c src/internal/intscan.c src/internal/shgetc.c src/locale/localeconv.c src/math/__fpclassify.c src/math/__fpclassifyf.c src/math/__fpclassifyl.c src/math/copysignl.c src/math/fabsl.c src/math/fmodl.c src/math/nanf.c src/math/rint.c src/math/scalbn.c src/math/scalbnl.c src/multibyte/internal.c src/multibyte/mbrtowc.c src/multibyte/mbsinit.c src/network/freeaddrinfo.c src/network/getaddrinfo.c src/network/gethostbyaddr.c src/network/gethostbyaddr_r.c src/network/gethostbyname.c src/network/gethostbyname2.c src/network/gethostbyname2_r.c src/network/gethostbyname_r.c src/network/getnameinfo.c src/network/h_errno.c src/network/inet_aton.c src/network/inet_ntop.c src/network/inet_pton.c src/network/lookup_ipliteral.c src/network/lookup_name.c src/network/lookup_serv.c src/prng/rand_r.c src/stdio/__lockfile.c src/stdio/__toread.c src/stdio/__uflow.c src/stdio/sscanf.c src/stdio/vfscanf.c src/stdio/vsscanf.c src/stdlib/bsearch.c src/stdlib/strtod.c src/stdlib/strtol.c src/string/strdup.c src/string/strlcat.c src/string/strlcpy.c src/string/strncasecmp.c src/string/strncat.c src/string/strnlen.c src/string/strspn.c src/string/strtok.c src/thread/pthread_attr_get.c src/thread/pthread_attr_setdetachstate.c src/thread/pthread_mutex_lock.c src/thread/pthread_mutexattr_destroy.c src/thread/pthread_mutexattr_init.c src/thread/pthread_mutexattr_settype.c', DO NOT EDIT.

package libc

import (
	"math"
	"reflect"
	"sync/atomic"
	"unsafe"
)

var _ = math.Pi
var _ reflect.Kind
var _ atomic.Value
var _ unsafe.Pointer

// musl as a whole is licensed under the following standard MIT license:
//
// ----------------------------------------------------------------------
// Copyright © 2005-2020 Rich Felker, et al.
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
// CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
// TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
// SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
// ----------------------------------------------------------------------
//
// Authors/contributors include:
//
// A. Wilcox
// Ada Worcester
// Alex Dowad
// Alex Suykov
// Alexander Monakov
// Andre McCurdy
// Andrew Kelley
// Anthony G. Basile
// Aric Belsito
// Arvid Picciani
// Bartosz Brachaczek
// Benjamin Peterson
// Bobby Bingham
// Boris Brezillon
// Brent Cook
// Chris Spiegel
// Clément Vasseur
// Daniel Micay
// Daniel Sabogal
// Daurnimator
// David Carlier
// David Edelsohn
// Denys Vlasenko
// Dmitry Ivanov
// Dmitry V. Levin
// Drew DeVault
// Emil Renner Berthing
// Fangrui Song
// Felix Fietkau
// Felix Janda
// Gianluca Anzolin
// Hauke Mehrtens
// He X
// Hiltjo Posthuma
// Isaac Dunham
// Jaydeep Patil
// Jens Gustedt
// Jeremy Huntwork
// Jo-Philipp Wich
// Joakim Sindholt
// John Spencer
// Julien Ramseier
// Justin Cormack
// Kaarle Ritvanen
// Khem Raj
// Kylie McClain
// Leah Neukirchen
// Luca Barbato
// Luka Perkov
// M Farkas-Dyck (Strake)
// Mahesh Bodapati
// Markus Wichmann
// Masanori Ogino
// Michael Clark
// Michael Forney
// Mikhail Kremnyov
// Natanael Copa
// Nicholas J. Kain
// orc
// Pascal Cuoq
// Patrick Oppenlander
// Petr Hosek
// Petr Skocik
// Pierre Carrier
// Reini Urban
// Rich Felker
// Richard Pennington
// Ryan Fairfax
// Samuel Holland
// Segev Finer
// Shiz
// sin
// Solar Designer
// Stefan Kristiansson
// Stefan O'Rear
// Szabolcs Nagy
// Timo Teräs
// Trutz Behn
// Valentin Ochs
// Will Dietz
// William Haddon
// William Pitcock
//
// Portions of this software are derived from third-party works licensed
// under terms compatible with the above MIT license:
//
// The TRE regular expression implementation (src/regex/reg* and
// src/regex/tre*) is Copyright © 2001-2008 Ville Laurikari and licensed
// under a 2-clause BSD license (license text in the source files). The
// included version has been heavily modified by Rich Felker in 2012, in
// the interests of size, simplicity, and namespace cleanliness.
//
// Much of the math library code (src/math/* and src/complex/*) is
// Copyright © 1993,2004 Sun Microsystems or
// Copyright © 2003-2011 David Schultz or
// Copyright © 2003-2009 Steven G. Kargl or
// Copyright © 2003-2009 Bruce D. Evans or
// Copyright © 2008 Stephen L. Moshier or
// Copyright © 2017-2018 Arm Limited
// and labelled as such in comments in the individual source files. All
// have been licensed under extremely permissive terms.
//
// The ARM memcpy code (src/string/arm/memcpy.S) is Copyright © 2008
// The Android Open Source Project and is licensed under a two-clause BSD
// license. It was taken from Bionic libc, used on Android.
//
// The AArch64 memcpy and memset code (src/string/aarch64/*) are
// Copyright © 1999-2019, Arm Limited.
//
// The implementation of DES for crypt (src/crypt/crypt_des.c) is
// Copyright © 1994 David Burren. It is licensed under a BSD license.
//
// The implementation of blowfish crypt (src/crypt/crypt_blowfish.c) was
// originally written by Solar Designer and placed into the public
// domain. The code also comes with a fallback permissive license for use
// in jurisdictions that may not recognize the public domain.
//
// The smoothsort implementation (src/stdlib/qsort.c) is Copyright © 2011
// Valentin Ochs and is licensed under an MIT-style license.
//
// The x86_64 port was written by Nicholas J. Kain and is licensed under
// the standard MIT terms.
//
// The mips and microblaze ports were originally written by Richard
// Pennington for use in the ellcc project. The original code was adapted
// by Rich Felker for build system and code conventions during upstream
// integration. It is licensed under the standard MIT terms.
//
// The mips64 port was contributed by Imagination Technologies and is
// licensed under the standard MIT terms.
//
// The powerpc port was also originally written by Richard Pennington,
// and later supplemented and integrated by John Spencer. It is licensed
// under the standard MIT terms.
//
// All other files which have no copyright comments are original works
// produced specifically for use as part of this library, written either
// by Rich Felker, the main author of the library, or by one or more
// contibutors listed above. Details on authorship of individual files
// can be found in the git version control history of the project. The
// omission of copyright and license comments in each file is in the
// interest of source tree size.
//
// In addition, permission is hereby granted for all public header files
// (include/* and arch/*/bits/*) and crt files intended to be linked into
// applications (crt/*, ldso/dlstart.c, and arch/*/crt_arch.h) to omit
// the copyright notice and permission notice otherwise required by the
// license, and to use these files without any requirement of
// attribution. These files include substantial contributions from:
//
// Bobby Bingham
// John Spencer
// Nicholas J. Kain
// Rich Felker
// Richard Pennington
// Stefan Kristiansson
// Szabolcs Nagy
//
// all of whom have explicitly granted such permission.
//
// This file previously contained text expressing a belief that most of
// the files covered by the above exception were sufficiently trivial not
// to be subject to copyright, resulting in confusion over whether it
// negated the permissions granted in the license. In the spirit of
// permissive licensing, and of not having licensing issues being an
// obstacle to adoption, that text has been removed.
const ( /* copyright.c:194:1: */
	__musl__copyright__ = 0
)

const ( /* nameser.h:117:1: */
	ns_uop_delete = 0
	ns_uop_add    = 1
	ns_uop_max    = 2
)

const ( /* nameser.h:147:1: */
	ns_t_invalid  = 0
	ns_t_a        = 1
	ns_t_ns       = 2
	ns_t_md       = 3
	ns_t_mf       = 4
	ns_t_cname    = 5
	ns_t_soa      = 6
	ns_t_mb       = 7
	ns_t_mg       = 8
	ns_t_mr       = 9
	ns_t_null     = 10
	ns_t_wks      = 11
	ns_t_ptr      = 12
	ns_t_hinfo    = 13
	ns_t_minfo    = 14
	ns_t_mx       = 15
	ns_t_txt      = 16
	ns_t_rp       = 17
	ns_t_afsdb    = 18
	ns_t_x25      = 19
	ns_t_isdn     = 20
	ns_t_rt       = 21
	ns_t_nsap     = 22
	ns_t_nsap_ptr = 23
	ns_t_sig      = 24
	ns_t_key      = 25
	ns_t_px       = 26
	ns_t_gpos     = 27
	ns_t_aaaa     = 28
	ns_t_loc      = 29
	ns_t_nxt      = 30
	ns_t_eid      = 31
	ns_t_nimloc   = 32
	ns_t_srv      = 33
	ns_t_atma     = 34
	ns_t_naptr    = 35
	ns_t_kx       = 36
	ns_t_cert     = 37
	ns_t_a6       = 38
	ns_t_dname    = 39
	ns_t_sink     = 40
	ns_t_opt      = 41
	ns_t_apl      = 42
	ns_t_tkey     = 249
	ns_t_tsig     = 250
	ns_t_ixfr     = 251
	ns_t_axfr     = 252
	ns_t_mailb    = 253
	ns_t_maila    = 254
	ns_t_any      = 255
	ns_t_zxfr     = 256
	ns_t_max      = 65536
)

const ( /* nameser.h:210:1: */
	ns_c_invalid = 0
	ns_c_in      = 1
	ns_c_2       = 2
	ns_c_chaos   = 3
	ns_c_hs      = 4
	ns_c_none    = 254
	ns_c_any     = 255
	ns_c_max     = 65536
)

const ( /* nameser.h:221:1: */
	ns_kt_rsa     = 1
	ns_kt_dh      = 2
	ns_kt_dsa     = 3
	ns_kt_private = 254
)

const ( /* nameser.h:228:1: */
	cert_t_pkix = 1
	cert_t_spki = 2
	cert_t_pgp  = 3
	cert_t_url  = 253
	cert_t_oid  = 254
)

const ( /* nameser.h:28:1: */
	ns_s_qd  = 0
	ns_s_zn  = 0
	ns_s_an  = 1
	ns_s_pr  = 1
	ns_s_ns  = 2
	ns_s_ud  = 2
	ns_s_ar  = 3
	ns_s_max = 4
)

const ( /* nameser.h:75:1: */
	ns_f_qr     = 0
	ns_f_opcode = 1
	ns_f_aa     = 2
	ns_f_tc     = 3
	ns_f_rd     = 4
	ns_f_ra     = 5
	ns_f_z      = 6
	ns_f_ad     = 7
	ns_f_cd     = 8
	ns_f_rcode  = 9
	ns_f_max    = 10
)

const ( /* nameser.h:89:1: */
	ns_o_query  = 0
	ns_o_iquery = 1
	ns_o_status = 2
	ns_o_notify = 4
	ns_o_update = 5
	ns_o_max    = 6
)

const ( /* nameser.h:98:1: */
	ns_r_noerror  = 0
	ns_r_formerr  = 1
	ns_r_servfail = 2
	ns_r_nxdomain = 3
	ns_r_notimpl  = 4
	ns_r_refused  = 5
	ns_r_yxdomain = 6
	ns_r_yxrrset  = 7
	ns_r_nxrrset  = 8
	ns_r_notauth  = 9
	ns_r_notzone  = 10
	ns_r_max      = 11
	ns_r_badvers  = 16
	ns_r_badsig   = 16
	ns_r_badkey   = 17
	ns_r_badtime  = 18
)

const ( /* pthread_impl.h:58:1: */
	DT_EXITING  = 0
	DT_JOINABLE = 1
	DT_DETACHED = 2
)

type ptrdiff_t = int64 /* <builtin>:3:26 */

type size_t = uint64 /* <builtin>:9:23 */

type wchar_t = int32 /* <builtin>:15:24 */

type uint16_t = uint16 /* alltypes.h:126:25 */

type uint32_t = uint32 /* alltypes.h:131:25 */

type uint64_t = uint64 /* alltypes.h:136:25 */

func __bswap32(tls *TLS, __x uint32_t) uint32_t { /* endian.h:24:26: */
	return __x>>24 | __x>>8&uint32_t(0xff00) | __x<<8&uint32_t(0xff0000) | __x<<24
}

var table = [384]uint16{
	uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0),
	uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0),
	uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0),
	uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0),
	uint16((0x200/256 | 0x200*256) % 65536), uint16((0x200/256 | 0x200*256) % 65536), uint16((0x200/256 | 0x200*256) % 65536), uint16((0x200/256 | 0x200*256) % 65536), uint16((0x200/256 | 0x200*256) % 65536), uint16((0x200/256 | 0x200*256) % 65536), uint16((0x200/256 | 0x200*256) % 65536), uint16((0x200/256 | 0x200*256) % 65536),
	uint16((0x200/256 | 0x200*256) % 65536), uint16((0x320/256 | 0x320*256) % 65536), uint16((0x220/256 | 0x220*256) % 65536), uint16((0x220/256 | 0x220*256) % 65536), uint16((0x220/256 | 0x220*256) % 65536), uint16((0x220/256 | 0x220*256) % 65536), uint16((0x200/256 | 0x200*256) % 65536), uint16((0x200/256 | 0x200*256) % 65536),
	uint16((0x200/256 | 0x200*256) % 65536), uint16((0x200/256 | 0x200*256) % 65536), uint16((0x200/256 | 0x200*256) % 65536), uint16((0x200/256 | 0x200*256) % 65536), uint16((0x200/256 | 0x200*256) % 65536), uint16((0x200/256 | 0x200*256) % 65536), uint16((0x200/256 | 0x200*256) % 65536), uint16((0x200/256 | 0x200*256) % 65536),
	uint16((0x200/256 | 0x200*256) % 65536), uint16((0x200/256 | 0x200*256) % 65536), uint16((0x200/256 | 0x200*256) % 65536), uint16((0x200/256 | 0x200*256) % 65536), uint16((0x200/256 | 0x200*256) % 65536), uint16((0x200/256 | 0x200*256) % 65536), uint16((0x200/256 | 0x200*256) % 65536), uint16((0x200/256 | 0x200*256) % 65536),
	uint16((0x160/256 | 0x160*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536),
	uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536),
	uint16((0x8d8/256 | 0x8d8*256) % 65536), uint16((0x8d8/256 | 0x8d8*256) % 65536), uint16((0x8d8/256 | 0x8d8*256) % 65536), uint16((0x8d8/256 | 0x8d8*256) % 65536), uint16((0x8d8/256 | 0x8d8*256) % 65536), uint16((0x8d8/256 | 0x8d8*256) % 65536), uint16((0x8d8/256 | 0x8d8*256) % 65536), uint16((0x8d8/256 | 0x8d8*256) % 65536),
	uint16((0x8d8/256 | 0x8d8*256) % 65536), uint16((0x8d8/256 | 0x8d8*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536),
	uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x8d5/256 | 0x8d5*256) % 65536), uint16((0x8d5/256 | 0x8d5*256) % 65536), uint16((0x8d5/256 | 0x8d5*256) % 65536), uint16((0x8d5/256 | 0x8d5*256) % 65536), uint16((0x8d5/256 | 0x8d5*256) % 65536), uint16((0x8d5/256 | 0x8d5*256) % 65536), uint16((0x8c5/256 | 0x8c5*256) % 65536),
	uint16((0x8c5/256 | 0x8c5*256) % 65536), uint16((0x8c5/256 | 0x8c5*256) % 65536), uint16((0x8c5/256 | 0x8c5*256) % 65536), uint16((0x8c5/256 | 0x8c5*256) % 65536), uint16((0x8c5/256 | 0x8c5*256) % 65536), uint16((0x8c5/256 | 0x8c5*256) % 65536), uint16((0x8c5/256 | 0x8c5*256) % 65536), uint16((0x8c5/256 | 0x8c5*256) % 65536),
	uint16((0x8c5/256 | 0x8c5*256) % 65536), uint16((0x8c5/256 | 0x8c5*256) % 65536), uint16((0x8c5/256 | 0x8c5*256) % 65536), uint16((0x8c5/256 | 0x8c5*256) % 65536), uint16((0x8c5/256 | 0x8c5*256) % 65536), uint16((0x8c5/256 | 0x8c5*256) % 65536), uint16((0x8c5/256 | 0x8c5*256) % 65536), uint16((0x8c5/256 | 0x8c5*256) % 65536),
	uint16((0x8c5/256 | 0x8c5*256) % 65536), uint16((0x8c5/256 | 0x8c5*256) % 65536), uint16((0x8c5/256 | 0x8c5*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536),
	uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x8d6/256 | 0x8d6*256) % 65536), uint16((0x8d6/256 | 0x8d6*256) % 65536), uint16((0x8d6/256 | 0x8d6*256) % 65536), uint16((0x8d6/256 | 0x8d6*256) % 65536), uint16((0x8d6/256 | 0x8d6*256) % 65536), uint16((0x8d6/256 | 0x8d6*256) % 65536), uint16((0x8c6/256 | 0x8c6*256) % 65536),
	uint16((0x8c6/256 | 0x8c6*256) % 65536), uint16((0x8c6/256 | 0x8c6*256) % 65536), uint16((0x8c6/256 | 0x8c6*256) % 65536), uint16((0x8c6/256 | 0x8c6*256) % 65536), uint16((0x8c6/256 | 0x8c6*256) % 65536), uint16((0x8c6/256 | 0x8c6*256) % 65536), uint16((0x8c6/256 | 0x8c6*256) % 65536), uint16((0x8c6/256 | 0x8c6*256) % 65536),
	uint16((0x8c6/256 | 0x8c6*256) % 65536), uint16((0x8c6/256 | 0x8c6*256) % 65536), uint16((0x8c6/256 | 0x8c6*256) % 65536), uint16((0x8c6/256 | 0x8c6*256) % 65536), uint16((0x8c6/256 | 0x8c6*256) % 65536), uint16((0x8c6/256 | 0x8c6*256) % 65536), uint16((0x8c6/256 | 0x8c6*256) % 65536), uint16((0x8c6/256 | 0x8c6*256) % 65536),
	uint16((0x8c6/256 | 0x8c6*256) % 65536), uint16((0x8c6/256 | 0x8c6*256) % 65536), uint16((0x8c6/256 | 0x8c6*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x4c0/256 | 0x4c0*256) % 65536), uint16((0x200/256 | 0x200*256) % 65536),
	uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0),
	uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0),
	uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0),
	uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0), uint16(0),
} /* __ctype_b_loc.c:9:29 */

var ptable uintptr = 0 /* __ctype_b_loc.c:36:29 */

func X__ctype_b_loc(tls *TLS) uintptr { /* __ctype_b_loc.c:38:22: */
	return uintptr(unsafe.Pointer(&ptable))
}

func __isspace(tls *TLS, _c int32) int32 { /* ctype.h:26:21: */
	return Bool32(_c == ' ' || uint32(_c)-uint32('\t') < uint32(5))
}

type __locale_struct = struct{ cat [6]uintptr } /* alltypes.h:343:9 */

type locale_t = uintptr /* alltypes.h:343:32 */

func Xisalnum(tls *TLS, c int32) int32 { /* isalnum.c:3:5: */
	return Bool32(func() int32 {
		if 0 != 0 {
			return Xisalpha(tls, c)
		}
		return Bool32(uint32(c)|uint32(32)-uint32('a') < uint32(26))
	}() != 0 || func() int32 {
		if 0 != 0 {
			return Xisdigit(tls, c)
		}
		return Bool32(uint32(c)-uint32('0') < uint32(10))
	}() != 0)
}

func X__isalnum_l(tls *TLS, c int32, l locale_t) int32 { /* isalnum.c:8:5: */
	return Xisalnum(tls, c)
}

func Xisalpha(tls *TLS, c int32) int32 { /* isalpha.c:4:5: */
	return Bool32(uint32(c)|uint32(32)-uint32('a') < uint32(26))
}

func X__isalpha_l(tls *TLS, c int32, l locale_t) int32 { /* isalpha.c:9:5: */
	return Xisalpha(tls, c)
}

func Xisdigit(tls *TLS, c int32) int32 { /* isdigit.c:4:5: */
	return Bool32(uint32(c)-uint32('0') < uint32(10))
}

func X__isdigit_l(tls *TLS, c int32, l locale_t) int32 { /* isdigit.c:9:5: */
	return Xisdigit(tls, c)
}

func Xislower(tls *TLS, c int32) int32 { /* islower.c:4:5: */
	return Bool32(uint32(c)-uint32('a') < uint32(26))
}

func X__islower_l(tls *TLS, c int32, l locale_t) int32 { /* islower.c:9:5: */
	return Xislower(tls, c)
}

func Xisprint(tls *TLS, c int32) int32 { /* isprint.c:4:5: */
	return Bool32(uint32(c)-uint32(0x20) < uint32(0x5f))
}

func X__isprint_l(tls *TLS, c int32, l locale_t) int32 { /* isprint.c:9:5: */
	return Xisprint(tls, c)
}

func Xisupper(tls *TLS, c int32) int32 { /* isupper.c:4:5: */
	return Bool32(uint32(c)-uint32('A') < uint32(26))
}

func X__isupper_l(tls *TLS, c int32, l locale_t) int32 { /* isupper.c:9:5: */
	return Xisupper(tls, c)
}

func Xisxdigit(tls *TLS, c int32) int32 { /* isxdigit.c:3:5: */
	return Bool32(func() int32 {
		if 0 != 0 {
			return Xisdigit(tls, c)
		}
		return Bool32(uint32(c)-uint32('0') < uint32(10))
	}() != 0 || uint32(c)|uint32(32)-uint32('a') < uint32(6))
}

func X__isxdigit_l(tls *TLS, c int32, l locale_t) int32 { /* isxdigit.c:8:5: */
	return Xisxdigit(tls, c)
}

type off_t = int64 /* alltypes.h:162:16 */

type ino_t = uint64 /* alltypes.h:167:25 */

type dirent = struct {
	d_ino    ino_t
	d_off    off_t
	d_reclen uint16
	d_type   uint8
	d_name   [256]int8
	_        [5]byte
} /* dirent.h:5:1 */

type __dirstream = struct {
	tell    off_t
	fd      int32
	buf_pos int32
	buf_end int32
	lock    [1]int32
	buf     [2048]int8
} /* dirent.h:20:9 */

type DIR = __dirstream /* dirent.h:20:28 */

type ssize_t = int64 /* alltypes.h:65:15 */

type intptr_t = int64 /* alltypes.h:70:15 */

type pid_t = int32 /* alltypes.h:235:13 */

type uid_t = uint32 /* alltypes.h:245:18 */

type gid_t = uint32 /* alltypes.h:250:18 */

type useconds_t = uint32 /* alltypes.h:260:18 */

type div_t = struct {
	quot int32
	rem  int32
} /* stdlib.h:62:35 */
type ldiv_t = struct {
	quot int64
	rem  int64
} /* stdlib.h:63:36 */
type lldiv_t = struct {
	quot int64
	rem  int64
} /* stdlib.h:64:41 */

func Xclosedir(tls *TLS, dir uintptr) int32 { /* closedir.c:6:5: */
	var ret int32 = Xclose(tls, (*DIR)(unsafe.Pointer(dir)).fd)
	Xfree(tls, dir)
	return ret
}

type mode_t = uint32 /* alltypes.h:152:18 */

type iovec = struct {
	iov_base uintptr
	iov_len  size_t
} /* alltypes.h:355:1 */

type flock = struct {
	l_type   int16
	l_whence int16
	_        [4]byte
	l_start  off_t
	l_len    off_t
	l_pid    pid_t
	_        [4]byte
} /* fcntl.h:24:1 */

type file_handle = struct {
	_            [0]uint32
	handle_bytes uint32
	handle_type  int32
} /* fcntl.h:167:1 */

type f_owner_ex = struct {
	__type int32
	pid    pid_t
} /* fcntl.h:172:1 */

type syscall_arg_t = int64 /* syscall.h:22:14 */

func Xopendir(tls *TLS, name uintptr) uintptr { /* opendir.c:8:5: */
	var fd int32
	var dir uintptr

	if AssignInt32(&fd, Xopen(tls, name, 00|0200000|02000000, 0)) < 0 {
		return uintptr(0)
	}
	if !(int32(AssignUintptr(&dir, Xcalloc(tls, uint64(1), uint64(unsafe.Sizeof(DIR{}))))) != 0) {
		X__syscall1(tls, int64(3), int64(fd))
		return uintptr(0)
	}
	(*DIR)(unsafe.Pointer(dir)).fd = fd
	return dir
}

type max_align_t = struct {
	__ll int64
	__ld float64
} /* alltypes.h:41:54 */

type dirstream_buf_alignment_check = [1]int8 /* readdir.c:7:14 */

func Xreaddir(tls *TLS, dir uintptr) uintptr { /* readdir.c:10:15: */
	var de uintptr

	if (*DIR)(unsafe.Pointer(dir)).buf_pos >= (*DIR)(unsafe.Pointer(dir)).buf_end {
		var len int32 = int32(X__syscall3(tls, int64(217), int64((*DIR)(unsafe.Pointer(dir)).fd), int64(dir+24), int64(unsafe.Sizeof([2048]int8{}))))
		if len <= 0 {
			if len < 0 && len != -2 {
				*(*int32)(unsafe.Pointer(X___errno_location(tls))) = -len
			}
			return uintptr(0)
		}
		(*DIR)(unsafe.Pointer(dir)).buf_end = len
		(*DIR)(unsafe.Pointer(dir)).buf_pos = 0
	}
	de = dir + 24 + uintptr((*DIR)(unsafe.Pointer(dir)).buf_pos)
	*(*int32)(unsafe.Pointer(dir + 12)) += int32((*dirent)(unsafe.Pointer(de)).d_reclen)
	(*DIR)(unsafe.Pointer(dir)).tell = (*dirent)(unsafe.Pointer(de)).d_off
	return de
}

type uintptr_t = uint64 /* alltypes.h:55:24 */

type int8_t = int8 /* alltypes.h:96:25 */

type int16_t = int16 /* alltypes.h:101:25 */

type int32_t = int32 /* alltypes.h:106:25 */

type int64_t = int64 /* alltypes.h:111:25 */

type intmax_t = int64 /* alltypes.h:116:25 */

type uint8_t = uint8 /* alltypes.h:121:25 */

type uintmax_t = uint64 /* alltypes.h:146:25 */

type int_fast8_t = int8_t   /* stdint.h:22:16 */
type int_fast64_t = int64_t /* stdint.h:23:17 */

type int_least8_t = int8_t   /* stdint.h:25:17 */
type int_least16_t = int16_t /* stdint.h:26:17 */
type int_least32_t = int32_t /* stdint.h:27:17 */
type int_least64_t = int64_t /* stdint.h:28:17 */

type uint_fast8_t = uint8_t   /* stdint.h:30:17 */
type uint_fast64_t = uint64_t /* stdint.h:31:18 */

type uint_least8_t = uint8_t   /* stdint.h:33:18 */
type uint_least16_t = uint16_t /* stdint.h:34:18 */
type uint_least32_t = uint32_t /* stdint.h:35:18 */
type uint_least64_t = uint64_t /* stdint.h:36:18 */

type int_fast16_t = int32_t   /* stdint.h:1:17 */
type int_fast32_t = int32_t   /* stdint.h:2:17 */
type uint_fast16_t = uint32_t /* stdint.h:3:18 */
type uint_fast32_t = uint32_t /* stdint.h:4:18 */

type _IO_FILE = struct {
	flags        uint32
	_            [4]byte
	rpos         uintptr
	rend         uintptr
	close        uintptr
	wend         uintptr
	wpos         uintptr
	mustbezero_1 uintptr
	wbase        uintptr
	read         uintptr
	write        uintptr
	seek         uintptr
	buf          uintptr
	buf_size     size_t
	prev         uintptr
	next         uintptr
	fd           int32
	pipe_pid     int32
	lockcount    int64
	mode         int32
	lock         int32
	lbf          int32
	_            [4]byte
	cookie       uintptr
	off          off_t
	getln_buf    uintptr
	mustbezero_2 uintptr
	shend        uintptr
	shlim        off_t
	shcnt        off_t
	prev_locked  uintptr
	next_locked  uintptr
	locale       uintptr
} /* alltypes.h:320:9 */

type FILE = _IO_FILE /* alltypes.h:320:25 */

type va_list = uintptr /* alltypes.h:326:27 */

type _G_fpos64_t = struct {
	_        [0]uint64
	__opaque [16]int8
} /* stdio.h:54:9 */

type fpos_t = _G_fpos64_t /* stdio.h:58:3 */

type float_t = float32 /* alltypes.h:29:15 */

type double_t = float64 /* alltypes.h:34:16 */

func __FLOAT_BITS(tls *TLS, __f float32) uint32 { /* math.h:55:26: */
	bp := tls.Alloc(4)
	defer tls.Free(4)

	// var __u struct {__f float32;} at bp, 4

	*(*float32)(unsafe.Pointer(bp)) = __f
	return *(*uint32)(unsafe.Pointer(bp))
}

func __DOUBLE_BITS(tls *TLS, __f float64) uint64 { /* math.h:61:36: */
	bp := tls.Alloc(8)
	defer tls.Free(8)

	// var __u struct {__f float64;} at bp, 8

	*(*float64)(unsafe.Pointer(bp)) = __f
	return *(*uint64)(unsafe.Pointer(bp))
}

type __pthread = struct {
	self          uintptr
	dtv           uintptr
	prev          uintptr
	next          uintptr
	sysinfo       uintptr_t
	canary        uintptr_t
	canary2       uintptr_t
	tid           int32
	errno_val     int32
	detach_state  int32
	cancel        int32
	canceldisable uint8
	cancelasync   uint8
	tsd_used      uint8 /* unsigned char tsd_used: 1, unsigned char dlerror_flag: 1 */
	_             [5]byte
	map_base      uintptr
	map_size      size_t
	stack         uintptr
	stack_size    size_t
	guard_size    size_t
	result        uintptr
	cancelbuf     uintptr
	tsd           uintptr
	robust_list   struct {
		head    uintptr
		off     int64
		pending uintptr
	}
	timer_id      int32
	_             [4]byte
	locale        locale_t
	killlock      [1]int32
	_             [4]byte
	dlerror_buf   uintptr
	stdio_locks   uintptr
	canary_at_end uintptr_t
	dtv_copy      uintptr
} /* alltypes.h:273:9 */

func scanexp(tls *TLS, f uintptr, pok int32) int64 { /* floatscan.c:37:18: */
	var c int32
	var x int32
	var y int64
	var neg int32 = 0

	c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	if c == '+' || c == '-' {
		neg = Bool32(c == '-')
		c = func() int32 {
			if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
				return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
			}
			return X__shgetc(tls, f)
		}()
		if uint32(c-'0') >= 10 && pok != 0 {
			if (*FILE)(unsafe.Pointer(f)).shlim >= int64(0) {
				(*FILE)(unsafe.Pointer(f)).rpos--
			} else {
			}
		}
	}
	if uint32(c-'0') >= 10 {
		if (*FILE)(unsafe.Pointer(f)).shlim >= int64(0) {
			(*FILE)(unsafe.Pointer(f)).rpos--
		} else {
		}
		return -0x7fffffffffffffff - int64(1)
	}
	for x = 0; uint32(c-'0') < 10 && x < 0x7fffffff/10; c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}() {
		x = 10*x + c - '0'
	}
	for y = int64(x); uint32(c-'0') < 10 && y < 0x7fffffffffffffff/int64(100); c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}() {
		y = int64(10)*y + int64(c) - int64('0')
	}
	for ; uint32(c-'0') < 10; c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}() {
	}
	if (*FILE)(unsafe.Pointer(f)).shlim >= int64(0) {
		(*FILE)(unsafe.Pointer(f)).rpos--
	} else {
	}
	if neg != 0 {
		return -y
	}
	return y
}

func decfloat(tls *TLS, f uintptr, c int32, bits int32, emin int32, sign int32, pok int32) float64 { /* floatscan.c:64:20: */
	bp := tls.Alloc(512)
	defer tls.Free(512)

	// var x [128]uint32_t at bp, 512

	var i int32
	var j int32
	var k int32
	var a int32
	var z int32
	var lrp int64 = int64(0)
	var dc int64 = int64(0)
	var e10 int64 = int64(0)
	var lnz int32 = 0
	var gotdig int32 = 0
	var gotrad int32 = 0
	var rp int32
	var e2 int32
	var emax int32 = -emin - bits + 3
	var denormal int32 = 0
	var y float64
	var frac float64 = float64(0)
	var bias float64 = float64(0)

	j = 0
	k = 0

	// Don't let leading zeros consume buffer space
	for ; c == '0'; c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}() {
		gotdig = 1
	}
	if c == '.' {
		gotrad = 1
		for c = func() int32 {
			if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
				return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
			}
			return X__shgetc(tls, f)
		}(); c == '0'; c = func() int32 {
			if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
				return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
			}
			return X__shgetc(tls, f)
		}() {
			gotdig = 1
			lrp--
		}
	}

	*(*uint32_t)(unsafe.Pointer(bp)) = uint32_t(0)
	for ; uint32(c-'0') < 10 || c == '.'; c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}() {
		if c == '.' {
			if gotrad != 0 {
				break
			}
			gotrad = 1
			lrp = dc
		} else if k < 128-3 {
			dc++
			if c != '0' {
				lnz = int32(dc)
			}
			if j != 0 {
				*(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4)) = *(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4))*uint32_t(10) + uint32_t(c) - uint32_t('0')
			} else {
				*(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4)) = uint32_t(c - '0')
			}
			if PreIncInt32(&j, 1) == 9 {
				k++
				j = 0
			}
			gotdig = 1
		} else {
			dc++
			if c != '0' {
				lnz = (128 - 4) * 9
				*(*uint32_t)(unsafe.Pointer(bp + 124*4)) |= uint32_t(1)
			}
		}
	}
	if !(gotrad != 0) {
		lrp = dc
	}

	if gotdig != 0 && c|32 == 'e' {
		e10 = scanexp(tls, f, pok)
		if e10 == -0x7fffffffffffffff-int64(1) {
			if pok != 0 {
				if (*FILE)(unsafe.Pointer(f)).shlim >= int64(0) {
					(*FILE)(unsafe.Pointer(f)).rpos--
				} else {
				}
			} else {
				X__shlim(tls, f, int64(0))
				return float64(0)
			}
			e10 = int64(0)
		}
		lrp = lrp + e10
	} else if c >= 0 {
		if (*FILE)(unsafe.Pointer(f)).shlim >= int64(0) {
			(*FILE)(unsafe.Pointer(f)).rpos--
		} else {
		}
	}
	if !(gotdig != 0) {
		*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 22
		X__shlim(tls, f, int64(0))
		return float64(0)
	}

	// Handle zero specially to avoid nasty special cases later
	if !(int32(*(*uint32_t)(unsafe.Pointer(bp))) != 0) {
		return float64(sign) * 0.0
	}

	// Optimize small integers (w/no exponent) and over/under-flow
	if lrp == dc && dc < int64(10) && (bits > 30 || *(*uint32_t)(unsafe.Pointer(bp))>>bits == uint32_t(0)) {
		return float64(sign) * float64(*(*uint32_t)(unsafe.Pointer(bp)))
	}
	if lrp > int64(-emin/2) {
		*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 34
		return float64(sign) * 1.79769313486231570815e+308 * 1.79769313486231570815e+308
	}
	if lrp < int64(emin-2*53) {
		*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 34
		return float64(sign) * 2.22507385850720138309e-308 * 2.22507385850720138309e-308
	}

	// Align incomplete final B1B digit
	if j != 0 {
		for ; j < 9; j++ {
			*(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4)) *= uint32_t(10)
		}
		k++
		j = 0
	}

	a = 0
	z = k
	e2 = 0
	rp = int32(lrp)

	// Optimize small to mid-size integers (even in exp. notation)
	if lnz < 9 && lnz <= rp && rp < 18 {
		if rp == 9 {
			return float64(sign) * float64(*(*uint32_t)(unsafe.Pointer(bp)))
		}
		if rp < 9 {
			return float64(sign) * float64(*(*uint32_t)(unsafe.Pointer(bp))) / float64(_sp10s[8-rp])
		}
		var bitlim int32 = bits - 3*(rp-9)
		if bitlim > 30 || *(*uint32_t)(unsafe.Pointer(bp))>>bitlim == uint32_t(0) {
			return float64(sign) * float64(*(*uint32_t)(unsafe.Pointer(bp))) * float64(_sp10s[rp-10])
		}
	}

	// Drop trailing zeros
	for ; !(int32(*(*uint32_t)(unsafe.Pointer(bp + uintptr(z-1)*4))) != 0); z-- {
	}

	// Align radix point to B1B digit boundary
	if rp%9 != 0 {
		var rpm9 int32
		if rp >= 0 {
			rpm9 = rp % 9
		} else {
			rpm9 = rp%9 + 9
		}
		var p10 int32 = _sp10s[8-rpm9]
		var carry uint32_t = uint32_t(0)
		for k = a; k != z; k++ {
			var tmp uint32_t = *(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4)) % uint32_t(p10)
			*(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4)) = *(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4))/uint32_t(p10) + carry
			carry = uint32_t(1000000000/p10) * tmp
			if k == a && !(int32(*(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4))) != 0) {
				a = (a + 1) & (128 - 1)
				rp = rp - 9
			}
		}
		if carry != 0 {
			*(*uint32_t)(unsafe.Pointer(bp + uintptr(PostIncInt32(&z, 1))*4)) = carry
		}
		rp = rp + (9 - rpm9)
	}

	// Upscale until desired number of bits are left of radix point
	for rp < 9*2 || rp == 9*2 && *(*uint32_t)(unsafe.Pointer(bp + uintptr(a)*4)) < _sth[0] {
		var carry uint32_t = uint32_t(0)
		e2 = e2 - 29
		for k = (z - 1) & (128 - 1); ; k = (k - 1) & (128 - 1) {
			var tmp uint64_t = uint64_t(*(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4)))<<29 + uint64_t(carry)
			if tmp > uint64(1000000000) {
				carry = uint32_t(tmp / uint64(1000000000))
				*(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4)) = uint32_t(tmp % uint64(1000000000))
			} else {
				carry = uint32_t(0)
				*(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4)) = uint32_t(tmp)
			}
			if k == (z-1)&(128-1) && k != a && !(int32(*(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4))) != 0) {
				z = k
			}
			if k == a {
				break
			}
		}
		if carry != 0 {
			rp = rp + 9
			a = (a - 1) & (128 - 1)
			if a == z {
				z = (z - 1) & (128 - 1)
				*(*uint32_t)(unsafe.Pointer(bp + uintptr((z-1)&(128-1))*4)) |= *(*uint32_t)(unsafe.Pointer(bp + uintptr(z)*4))
			}
			*(*uint32_t)(unsafe.Pointer(bp + uintptr(a)*4)) = carry
		}
	}

	// Downscale until exactly number of bits are left of radix point
	for {
		var carry uint32_t = uint32_t(0)
		var sh int32 = 1
		for i = 0; i < 2; i++ {
			k = (a + i) & (128 - 1)
			if k == z || *(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4)) < _sth[i] {
				i = 2
				break
			}
			if *(*uint32_t)(unsafe.Pointer(bp + uintptr((a+i)&(128-1))*4)) > _sth[i] {
				break
			}
		}
		if i == 2 && rp == 9*2 {
			break
		}
		// FIXME: find a way to compute optimal sh
		if rp > 9+9*2 {
			sh = 9
		}
		e2 = e2 + sh
		for k = a; k != z; k = (k + 1) & (128 - 1) {
			var tmp uint32_t = *(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4)) & uint32_t(int32(1)<<sh-1)
			*(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4)) = *(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4))>>sh + carry
			carry = uint32_t(int32(1000000000)>>sh) * tmp
			if k == a && !(int32(*(*uint32_t)(unsafe.Pointer(bp + uintptr(k)*4))) != 0) {
				a = (a + 1) & (128 - 1)
				i--
				rp = rp - 9
			}
		}
		if carry != 0 {
			if (z+1)&(128-1) != a {
				*(*uint32_t)(unsafe.Pointer(bp + uintptr(z)*4)) = carry
				z = (z + 1) & (128 - 1)
			} else {
				*(*uint32_t)(unsafe.Pointer(bp + uintptr((z-1)&(128-1))*4)) |= uint32_t(1)
			}
		}
	}

	// Assemble desired bits into floating point variable
	for y = float64(AssignInt32(&i, 0)); i < 2; i++ {
		if (a+i)&(128-1) == z {
			*(*uint32_t)(unsafe.Pointer(bp + uintptr(AssignInt32(&z, (z+1)&(128-1))-1)*4)) = uint32_t(0)
		}
		y = 1000000000.0*y + float64(*(*uint32_t)(unsafe.Pointer(bp + uintptr((a+i)&(128-1))*4)))
	}

	y = y * float64(sign)

	// Limit precision for denormal results
	if bits > 53+e2-emin {
		bits = 53 + e2 - emin
		if bits < 0 {
			bits = 0
		}
		denormal = 1
	}

	// Calculate bias term to force rounding, move out lower bits
	if bits < 53 {
		bias = Xcopysignl(tls, Xscalbn(tls, float64(1), 2*53-bits-1), y)
		frac = Xfmodl(tls, y, Xscalbn(tls, float64(1), 53-bits))
		y = y - frac
		y = y + bias
	}

	// Process tail of decimal input so it can affect rounding
	if (a+i)&(128-1) != z {
		var t uint32_t = *(*uint32_t)(unsafe.Pointer(bp + uintptr((a+i)&(128-1))*4))
		if t < uint32_t(500000000) && (t != 0 || (a+i+1)&(128-1) != z) {
			frac = frac + 0.25*float64(sign)
		} else if t > uint32_t(500000000) {
			frac = frac + 0.75*float64(sign)
		} else if t == uint32_t(500000000) {
			if (a+i+1)&(128-1) == z {
				frac = frac + 0.5*float64(sign)
			} else {
				frac = frac + 0.75*float64(sign)
			}
		}
		if 53-bits >= 2 && !(Xfmodl(tls, frac, float64(1)) != 0) {
			frac += 1
		}
	}

	y = y + frac
	y = y - bias

	if (e2+53)&0x7fffffff > emax-5 {
		if Xfabsl(tls, y) >= float64(float64(2))/2.22044604925031308085e-16 {
			if denormal != 0 && bits == 53+e2-emin {
				denormal = 0
			}
			y = y * 0.5
			e2++
		}
		if e2+53 > emax || denormal != 0 && frac != 0 {
			*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 34
		}
	}

	return Xscalbnl(tls, y, e2)
}

var _sth = [2]uint32_t{uint32_t(9007199), uint32_t(254740991)} /* floatscan.c:67:24 */
var _sp10s = [8]int32{10, 100, 1000, 10000,
	100000, 1000000, 10000000, 100000000} /* floatscan.c:80:19 */

func hexfloat(tls *TLS, f uintptr, bits int32, emin int32, sign int32, pok int32) float64 { /* floatscan.c:315:20: */
	var x uint32_t = uint32_t(0)
	var y float64 = float64(0)
	var scale float64 = float64(1)
	var bias float64 = float64(0)
	var gottail int32 = 0
	var gotrad int32 = 0
	var gotdig int32 = 0
	var rp int64 = int64(0)
	var dc int64 = int64(0)
	var e2 int64 = int64(0)
	var d int32
	var c int32

	c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}()

	// Skip leading zeros
	for ; c == '0'; c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}() {
		gotdig = 1
	}

	if c == '.' {
		gotrad = 1
		c = func() int32 {
			if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
				return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
			}
			return X__shgetc(tls, f)
		}()
		// Count zeros after the radix point before significand
		rp = int64(0)
	__1:
		if !(c == '0') {
			goto __3
		}
		gotdig = 1
		goto __2
	__2:
		c = func() int32 {
			if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
				return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
			}
			return X__shgetc(tls, f)
		}()
		rp--
		goto __1
		goto __3
	__3:
	}

	for ; uint32(c-'0') < 10 || uint32(c|32-'a') < 6 || c == '.'; c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}() {
		if c == '.' {
			if gotrad != 0 {
				break
			}
			rp = dc
			gotrad = 1
		} else {
			gotdig = 1
			if c > '9' {
				d = c | 32 + 10 - 'a'
			} else {
				d = c - '0'
			}
			if dc < int64(8) {
				x = x*uint32_t(16) + uint32_t(d)
			} else if dc < int64(53/4+1) {
				y = y + float64(d)*AssignDivFloat64(&scale, float64(16))
			} else if d != 0 && !(gottail != 0) {
				y = y + 0.5*scale
				gottail = 1
			}
			dc++
		}
	}
	if !(gotdig != 0) {
		if (*FILE)(unsafe.Pointer(f)).shlim >= int64(0) {
			(*FILE)(unsafe.Pointer(f)).rpos--
		} else {
		}
		if pok != 0 {
			if (*FILE)(unsafe.Pointer(f)).shlim >= int64(0) {
				(*FILE)(unsafe.Pointer(f)).rpos--
			} else {
			}
			if gotrad != 0 {
				if (*FILE)(unsafe.Pointer(f)).shlim >= int64(0) {
					(*FILE)(unsafe.Pointer(f)).rpos--
				} else {
				}
			}
		} else {
			X__shlim(tls, f, int64(0))
		}
		return float64(sign) * 0.0
	}
	if !(gotrad != 0) {
		rp = dc
	}
	for dc < int64(8) {
		x = x * uint32_t(16)
		dc++
	}
	if c|32 == 'p' {
		e2 = scanexp(tls, f, pok)
		if e2 == -0x7fffffffffffffff-int64(1) {
			if pok != 0 {
				if (*FILE)(unsafe.Pointer(f)).shlim >= int64(0) {
					(*FILE)(unsafe.Pointer(f)).rpos--
				} else {
				}
			} else {
				X__shlim(tls, f, int64(0))
				return float64(0)
			}
			e2 = int64(0)
		}
	} else {
		if (*FILE)(unsafe.Pointer(f)).shlim >= int64(0) {
			(*FILE)(unsafe.Pointer(f)).rpos--
		} else {
		}
	}
	e2 = e2 + (int64(4)*rp - int64(32))

	if !(x != 0) {
		return float64(sign) * 0.0
	}
	if e2 > int64(-emin) {
		*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 34
		return float64(sign) * 1.79769313486231570815e+308 * 1.79769313486231570815e+308
	}
	if e2 < int64(emin-2*53) {
		*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 34
		return float64(sign) * 2.22507385850720138309e-308 * 2.22507385850720138309e-308
	}

	for x < 0x80000000 {
		if y >= 0.5 {
			x = x + (x + uint32_t(1))
			y = y + (y - float64(1))
		} else {
			x = x + x
			y = y + y
		}
		e2--
	}

	if int64(bits) > int64(32)+e2-int64(emin) {
		bits = int32(int64(32) + e2 - int64(emin))
		if bits < 0 {
			bits = 0
		}
	}

	if bits < 53 {
		bias = Xcopysignl(tls, Xscalbn(tls, float64(1), 32+53-bits-1), float64(sign))
	}

	if bits < 32 && y != 0 && !(x&uint32_t(1) != 0) {
		x++
		y = float64(0)
	}

	y = bias + float64(sign)*float64(x) + float64(sign)*y
	y = y - bias

	if !(y != 0) {
		*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 34
	}

	return Xscalbnl(tls, y, int32(e2))
}

func X__floatscan(tls *TLS, f uintptr, prec int32, pok int32) float64 { /* floatscan.c:427:13: */
	var sign int32 = 1
	var i size_t
	var bits int32
	var emin int32
	var c int32

	switch prec {
	case 0:
		bits = 24
		emin = -125 - bits
		break
	case 1:
		bits = 53
		emin = -1021 - bits
		break
	case 2:
		bits = 53
		emin = -1021 - bits
		break
	default:
		return float64(0)
	}

	for __isspace(tls, AssignInt32(&c, func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}())) != 0 {
	}

	if c == '+' || c == '-' {
		sign = sign - 2*Bool32(c == '-')
		c = func() int32 {
			if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
				return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
			}
			return X__shgetc(tls, f)
		}()
	}

	for i = uint64(0); i < uint64(8) && c|32 == int32(*(*int8)(unsafe.Pointer(ts /* "infinity" */ + uintptr(i)))); i++ {
		if i < uint64(7) {
			c = func() int32 {
				if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
					return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
				}
				return X__shgetc(tls, f)
			}()
		}
	}
	if i == uint64(3) || i == uint64(8) || i > uint64(3) && pok != 0 {
		if i != uint64(8) {
			if (*FILE)(unsafe.Pointer(f)).shlim >= int64(0) {
				(*FILE)(unsafe.Pointer(f)).rpos--
			} else {
			}
			if pok != 0 {
				for ; i > uint64(3); i-- {
					if (*FILE)(unsafe.Pointer(f)).shlim >= int64(0) {
						(*FILE)(unsafe.Pointer(f)).rpos--
					} else {
					}
				}
			}
		}
		return float64(float32(sign) * X__builtin_inff(tls))
	}
	if !(i != 0) {
		for i = uint64(0); i < uint64(3) && c|32 == int32(*(*int8)(unsafe.Pointer(ts + 9 /* "nan" */ + uintptr(i)))); i++ {
			if i < uint64(2) {
				c = func() int32 {
					if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
						return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
					}
					return X__shgetc(tls, f)
				}()
			}
		}
	}
	if i == uint64(3) {
		if func() int32 {
			if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
				return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
			}
			return X__shgetc(tls, f)
		}() != '(' {
			if (*FILE)(unsafe.Pointer(f)).shlim >= int64(0) {
				(*FILE)(unsafe.Pointer(f)).rpos--
			} else {
			}
			return float64(X__builtin_nanf(tls, ts+13))
		}
		for i = uint64(1); ; i++ {
			c = func() int32 {
				if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
					return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
				}
				return X__shgetc(tls, f)
			}()
			if uint32(c-'0') < 10 || uint32(c-'A') < 26 || uint32(c-'a') < 26 || c == '_' {
				continue
			}
			if c == ')' {
				return float64(X__builtin_nanf(tls, ts+13))
			}
			if (*FILE)(unsafe.Pointer(f)).shlim >= int64(0) {
				(*FILE)(unsafe.Pointer(f)).rpos--
			} else {
			}
			if !(pok != 0) {
				*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 22
				X__shlim(tls, f, int64(0))
				return float64(0)
			}
			for PostDecUint64(&i, 1) != 0 {
				if (*FILE)(unsafe.Pointer(f)).shlim >= int64(0) {
					(*FILE)(unsafe.Pointer(f)).rpos--
				} else {
				}
			}
			return float64(X__builtin_nanf(tls, ts+13))
		}
		return float64(X__builtin_nanf(tls, ts+13))
	}

	if i != 0 {
		if (*FILE)(unsafe.Pointer(f)).shlim >= int64(0) {
			(*FILE)(unsafe.Pointer(f)).rpos--
		} else {
		}
		*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 22
		X__shlim(tls, f, int64(0))
		return float64(0)
	}

	if c == '0' {
		c = func() int32 {
			if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
				return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
			}
			return X__shgetc(tls, f)
		}()
		if c|32 == 'x' {
			return hexfloat(tls, f, bits, emin, sign, pok)
		}
		if (*FILE)(unsafe.Pointer(f)).shlim >= int64(0) {
			(*FILE)(unsafe.Pointer(f)).rpos--
		} else {
		}
		c = '0'
	}

	return decfloat(tls, f, c, bits, emin, sign, pok)
}

// Lookup table for digit values. -1==255>=36 -> invalid
var table1 = [257]uint8{Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	uint8(0), uint8(1), uint8(2), uint8(3), uint8(4), uint8(5), uint8(6), uint8(7), uint8(8), uint8(9), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), uint8(10), uint8(11), uint8(12), uint8(13), uint8(14), uint8(15), uint8(16), uint8(17), uint8(18), uint8(19), uint8(20), uint8(21), uint8(22), uint8(23), uint8(24),
	uint8(25), uint8(26), uint8(27), uint8(28), uint8(29), uint8(30), uint8(31), uint8(32), uint8(33), uint8(34), uint8(35), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), uint8(10), uint8(11), uint8(12), uint8(13), uint8(14), uint8(15), uint8(16), uint8(17), uint8(18), uint8(19), uint8(20), uint8(21), uint8(22), uint8(23), uint8(24),
	uint8(25), uint8(26), uint8(27), uint8(28), uint8(29), uint8(30), uint8(31), uint8(32), uint8(33), uint8(34), uint8(35), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
	Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1), Uint8FromInt32(-1),
} /* intscan.c:7:28 */

func X__intscan(tls *TLS, f uintptr, base uint32, pok int32, lim uint64) uint64 { /* intscan.c:26:20: */
	var val uintptr
	var c int32
	var neg int32
	var x uint32
	var y uint64
	var bs int32
	val = uintptr(unsafe.Pointer(&table1)) + uintptr(1)
	neg = 0
	if !(base > uint32(36) || base == uint32(1)) {
		goto __1
	}
	*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 22
	return uint64(0)
__1:
	;
__2:
	if !(__isspace(tls, AssignInt32(&c, func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}())) != 0) {
		goto __3
	}
	goto __2
__3:
	;
	if !(c == '+' || c == '-') {
		goto __4
	}
	neg = -Bool32(c == '-')
	c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
__4:
	;
	if !((base == uint32(0) || base == uint32(16)) && c == '0') {
		goto __5
	}
	c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	if !(c|32 == 'x') {
		goto __7
	}
	c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	if !(int32(*(*uint8)(unsafe.Pointer(val + uintptr(c)))) >= 16) {
		goto __9
	}
	if (*FILE)(unsafe.Pointer(f)).shlim >= int64(0) {
		(*FILE)(unsafe.Pointer(f)).rpos--
	} else {
	}
	if !(pok != 0) {
		goto __10
	}
	if (*FILE)(unsafe.Pointer(f)).shlim >= int64(0) {
		(*FILE)(unsafe.Pointer(f)).rpos--
	} else {
	}
	goto __11
__10:
	X__shlim(tls, f, int64(0))
__11:
	;
	return uint64(0)
__9:
	;
	base = uint32(16)
	goto __8
__7:
	if !(base == uint32(0)) {
		goto __12
	}
	base = uint32(8)
__12:
	;
__8:
	;
	goto __6
__5:
	if !(base == uint32(0)) {
		goto __13
	}
	base = uint32(10)
__13:
	;
	if !(uint32(*(*uint8)(unsafe.Pointer(val + uintptr(c)))) >= base) {
		goto __14
	}
	if (*FILE)(unsafe.Pointer(f)).shlim >= int64(0) {
		(*FILE)(unsafe.Pointer(f)).rpos--
	} else {
	}
	X__shlim(tls, f, int64(0))
	*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 22
	return uint64(0)
__14:
	;
__6:
	;
	if !(base == uint32(10)) {
		goto __15
	}
	x = uint32(0)
__17:
	if !(uint32(c-'0') < 10 && x <= 0xffffffff/uint32(10)-uint32(1)) {
		goto __19
	}
	x = x*uint32(10) + uint32(c-'0')
	goto __18
__18:
	c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	goto __17
	goto __19
__19:
	;
	y = uint64(x)
__20:
	if !(uint32(c-'0') < 10 && y <= (2*uint64(0x7fffffffffffffff)+uint64(1))/uint64(10) && uint64(10)*y <= 2*uint64(0x7fffffffffffffff)+uint64(1)-uint64(c-'0')) {
		goto __22
	}
	y = y*uint64(10) + uint64(c-'0')
	goto __21
__21:
	c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	goto __20
	goto __22
__22:
	;
	if !(uint32(c-'0') >= 10) {
		goto __23
	}
	goto done
__23:
	;
	goto __16
__15:
	if !!(base&(base-uint32(1)) != 0) {
		goto __24
	}
	bs = int32(*(*int8)(unsafe.Pointer(ts + 14 + uintptr(uint32(0x17)*base>>5&uint32(7)))))
	x = uint32(0)
__26:
	if !(uint32(*(*uint8)(unsafe.Pointer(val + uintptr(c)))) < base && x <= 0xffffffff/uint32(32)) {
		goto __28
	}
	x = x<<bs | uint32(*(*uint8)(unsafe.Pointer(val + uintptr(c))))
	goto __27
__27:
	c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	goto __26
	goto __28
__28:
	;
	y = uint64(x)
__29:
	if !(uint32(*(*uint8)(unsafe.Pointer(val + uintptr(c)))) < base && y <= uint64(2*uint64(0x7fffffffffffffff)+uint64(1))>>bs) {
		goto __31
	}
	y = y<<bs | uint64(*(*uint8)(unsafe.Pointer(val + uintptr(c))))
	goto __30
__30:
	c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	goto __29
	goto __31
__31:
	;
	goto __25
__24:
	x = uint32(0)
__32:
	if !(uint32(*(*uint8)(unsafe.Pointer(val + uintptr(c)))) < base && x <= 0xffffffff/uint32(36)-uint32(1)) {
		goto __34
	}
	x = x*base + uint32(*(*uint8)(unsafe.Pointer(val + uintptr(c))))
	goto __33
__33:
	c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	goto __32
	goto __34
__34:
	;
	y = uint64(x)
__35:
	if !(uint32(*(*uint8)(unsafe.Pointer(val + uintptr(c)))) < base && y <= (2*uint64(0x7fffffffffffffff)+uint64(1))/uint64(base) && uint64(base)*y <= 2*uint64(0x7fffffffffffffff)+uint64(1)-uint64(*(*uint8)(unsafe.Pointer(val + uintptr(c))))) {
		goto __37
	}
	y = y*uint64(base) + uint64(*(*uint8)(unsafe.Pointer(val + uintptr(c))))
	goto __36
__36:
	c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	goto __35
	goto __37
__37:
	;
__25:
	;
__16:
	;
	if !(uint32(*(*uint8)(unsafe.Pointer(val + uintptr(c)))) < base) {
		goto __38
	}
__39:
	if !(uint32(*(*uint8)(unsafe.Pointer(val + uintptr(c)))) < base) {
		goto __41
	}
	goto __40
__40:
	c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
	goto __39
	goto __41
__41:
	;
	*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 34
	y = lim
	if !(lim&uint64(1) != 0) {
		goto __42
	}
	neg = 0
__42:
	;
__38:
	;
done:
	if (*FILE)(unsafe.Pointer(f)).shlim >= int64(0) {
		(*FILE)(unsafe.Pointer(f)).rpos--
	} else {
	}
	if !(y >= lim) {
		goto __43
	}
	if !(!(lim&uint64(1) != 0) && !(neg != 0)) {
		goto __44
	}
	*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 34
	return lim - uint64(1)
	goto __45
__44:
	if !(y > lim) {
		goto __46
	}
	*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 34
	return lim
__46:
	;
__45:
	;
__43:
	;
	return y ^ uint64(neg) - uint64(neg)
}

// The shcnt field stores the number of bytes read so far, offset by
// the value of buf-rpos at the last function call (__shlim or __shgetc),
// so that between calls the inline shcnt macro can add rpos-buf to get
// the actual count.

func X__shlim(tls *TLS, f uintptr, lim off_t) { /* shgetc.c:8:6: */
	(*FILE)(unsafe.Pointer(f)).shlim = lim
	(*FILE)(unsafe.Pointer(f)).shcnt = (int64((*FILE)(unsafe.Pointer(f)).buf) - int64((*FILE)(unsafe.Pointer(f)).rpos)) / 1
	// If lim is nonzero, rend must be a valid pointer.
	if lim != 0 && (int64((*FILE)(unsafe.Pointer(f)).rend)-int64((*FILE)(unsafe.Pointer(f)).rpos))/1 > lim {
		(*FILE)(unsafe.Pointer(f)).shend = (*FILE)(unsafe.Pointer(f)).rpos + uintptr(lim)
	} else {
		(*FILE)(unsafe.Pointer(f)).shend = (*FILE)(unsafe.Pointer(f)).rend
	}
}

func X__shgetc(tls *TLS, f uintptr) int32 { /* shgetc.c:19:5: */
	var c int32
	var cnt off_t = (*FILE)(unsafe.Pointer(f)).shcnt + (int64((*FILE)(unsafe.Pointer(f)).rpos)-int64((*FILE)(unsafe.Pointer(f)).buf))/1
	if (*FILE)(unsafe.Pointer(f)).shlim != 0 && cnt >= (*FILE)(unsafe.Pointer(f)).shlim || AssignInt32(&c, X__uflow(tls, f)) < 0 {
		(*FILE)(unsafe.Pointer(f)).shcnt = (int64((*FILE)(unsafe.Pointer(f)).buf)-int64((*FILE)(unsafe.Pointer(f)).rpos))/1 + cnt
		(*FILE)(unsafe.Pointer(f)).shend = (*FILE)(unsafe.Pointer(f)).rpos
		(*FILE)(unsafe.Pointer(f)).shlim = int64(-1)
		return -1
	}
	cnt++
	if (*FILE)(unsafe.Pointer(f)).shlim != 0 && (int64((*FILE)(unsafe.Pointer(f)).rend)-int64((*FILE)(unsafe.Pointer(f)).rpos))/1 > (*FILE)(unsafe.Pointer(f)).shlim-cnt {
		(*FILE)(unsafe.Pointer(f)).shend = (*FILE)(unsafe.Pointer(f)).rpos + uintptr((*FILE)(unsafe.Pointer(f)).shlim-cnt)
	} else {
		(*FILE)(unsafe.Pointer(f)).shend = (*FILE)(unsafe.Pointer(f)).rend
	}
	(*FILE)(unsafe.Pointer(f)).shcnt = (int64((*FILE)(unsafe.Pointer(f)).buf)-int64((*FILE)(unsafe.Pointer(f)).rpos))/1 + cnt
	if (*FILE)(unsafe.Pointer(f)).rpos <= (*FILE)(unsafe.Pointer(f)).buf {
		*(*uint8)(unsafe.Pointer((*FILE)(unsafe.Pointer(f)).rpos + UintptrFromInt32(-1))) = uint8(c)
	}
	return c
}

type lconv = struct {
	decimal_point      uintptr
	thousands_sep      uintptr
	grouping           uintptr
	int_curr_symbol    uintptr
	currency_symbol    uintptr
	mon_decimal_point  uintptr
	mon_thousands_sep  uintptr
	mon_grouping       uintptr
	positive_sign      uintptr
	negative_sign      uintptr
	int_frac_digits    int8
	frac_digits        int8
	p_cs_precedes      int8
	p_sep_by_space     int8
	n_cs_precedes      int8
	n_sep_by_space     int8
	p_sign_posn        int8
	n_sign_posn        int8
	int_p_cs_precedes  int8
	int_p_sep_by_space int8
	int_n_cs_precedes  int8
	int_n_sep_by_space int8
	int_p_sign_posn    int8
	int_n_sign_posn    int8
	_                  [2]byte
} /* locale.h:24:1 */

// Support signed or unsigned plain-char

// Implementation choices...

// Arbitrary numbers...

// POSIX/SUS requirements follow. These numbers come directly
// from SUS and have nothing to do with the host system.

var posix_lconv = lconv{decimal_point: ts + 23, thousands_sep: ts + 13, grouping: ts + 13, int_curr_symbol: ts + 13, currency_symbol: ts + 13, mon_decimal_point: ts + 13, mon_thousands_sep: ts + 13, mon_grouping: ts + 13, positive_sign: ts + 13, negative_sign: ts + 13, int_frac_digits: Int8FromInt32(255), frac_digits: Int8FromInt32(255), p_cs_precedes: Int8FromInt32(255), p_sep_by_space: Int8FromInt32(255), n_cs_precedes: Int8FromInt32(255), n_sep_by_space: Int8FromInt32(255), p_sign_posn: Int8FromInt32(255), n_sign_posn: Int8FromInt32(255), int_p_cs_precedes: Int8FromInt32(255), int_p_sep_by_space: Int8FromInt32(255), int_n_cs_precedes: Int8FromInt32(255), int_n_sep_by_space: Int8FromInt32(255), int_p_sign_posn: Int8FromInt32(255), int_n_sign_posn: Int8FromInt32(255)} /* localeconv.c:4:27 */

func Xlocaleconv(tls *TLS) uintptr { /* localeconv.c:31:14: */
	return uintptr(unsafe.Pointer(&posix_lconv))
}

func X__fpclassify(tls *TLS, x float64) int32 { /* __fpclassify.c:4:5: */
	bp := tls.Alloc(8)
	defer tls.Free(8)

	*(*struct{ f float64 })(unsafe.Pointer(bp)) = func() (r struct{ f float64 }) {
		*(*float64)(unsafe.Pointer(uintptr(unsafe.Pointer(&r)) + 0)) = x
		return r
	}()
	var e int32 = int32(*(*uint64_t)(unsafe.Pointer(bp)) >> 52 & uint64(0x7ff))
	if !(e != 0) {
		if *(*uint64_t)(unsafe.Pointer(bp))<<1 != 0 {
			return 3
		}
		return 2
	}
	if e == 0x7ff {
		if *(*uint64_t)(unsafe.Pointer(bp))<<12 != 0 {
			return 0
		}
		return 1
	}
	return 4
}

func X__fpclassifyf(tls *TLS, x float32) int32 { /* __fpclassifyf.c:4:5: */
	bp := tls.Alloc(4)
	defer tls.Free(4)

	*(*struct{ f float32 })(unsafe.Pointer(bp)) = func() (r struct{ f float32 }) {
		*(*float32)(unsafe.Pointer(uintptr(unsafe.Pointer(&r)) + 0)) = x
		return r
	}()
	var e int32 = int32(*(*uint32_t)(unsafe.Pointer(bp)) >> 23 & uint32_t(0xff))
	if !(e != 0) {
		if *(*uint32_t)(unsafe.Pointer(bp))<<1 != 0 {
			return 3
		}
		return 2
	}
	if e == 0xff {
		if *(*uint32_t)(unsafe.Pointer(bp))<<9 != 0 {
			return 0
		}
		return 1
	}
	return 4
}

func X__fpclassifyl(tls *TLS, x float64) int32 { /* __fpclassifyl.c:4:5: */
	return X__fpclassify(tls, x)
}

func Xcopysignl(tls *TLS, x float64, y float64) float64 { /* copysignl.c:4:13: */
	return Xcopysign(tls, x, y)
}

func Xfabsl(tls *TLS, x float64) float64 { /* fabsl.c:3:13: */
	return Xfabs(tls, x)
}

func Xfmodl(tls *TLS, x float64, y float64) float64 { /* fmodl.c:4:13: */
	return Xfmod(tls, x, y)
}

func Xnanf(tls *TLS, s uintptr) float32 { /* nanf.c:3:7: */
	return X__builtin_nanf(tls, ts+13)
}

var toint double_t = float64(float64(1)) / 2.22044604925031308085e-16 /* rint.c:10:23 */

func Xrint(tls *TLS, x float64) float64 { /* rint.c:12:8: */
	bp := tls.Alloc(8)
	defer tls.Free(8)

	*(*struct{ f float64 })(unsafe.Pointer(bp)) = func() (r struct{ f float64 }) {
		*(*float64)(unsafe.Pointer(uintptr(unsafe.Pointer(&r)) + 0)) = x
		return r
	}()
	var e int32 = int32(*(*uint64_t)(unsafe.Pointer(bp)) >> 52 & uint64(0x7ff))
	var s int32 = int32(*(*uint64_t)(unsafe.Pointer(bp)) >> 63)
	var y double_t

	if e >= 0x3ff+52 {
		return x
	}
	if s != 0 {
		y = x - toint + toint
	} else {
		y = x + toint - toint
	}
	if y == float64(0) {
		if s != 0 {
			return -Float64FromFloat64(0.0)
		}
		return float64(0)
	}
	return y
}

func Xscalbn(tls *TLS, x float64, n int32) float64 { /* scalbn.c:4:8: */
	bp := tls.Alloc(8)
	defer tls.Free(8)

	// var u struct {f float64;} at bp, 8

	var y double_t = x

	if n > 1023 {
		y = y * 0x1p1023
		n = n - 1023
		if n > 1023 {
			y = y * 0x1p1023
			n = n - 1023
			if n > 1023 {
				n = 1023
			}
		}
	} else if n < -1022 {
		// make sure final n < -53 to avoid double
		// 		   rounding in the subnormal range
		y = y * (float64(0x1p-1022) * 0x1p53)
		n = n + (1022 - 53)
		if n < -1022 {
			y = y * (float64(0x1p-1022) * 0x1p53)
			n = n + (1022 - 53)
			if n < -1022 {
				n = -1022
			}
		}
	}
	*(*uint64_t)(unsafe.Pointer(bp)) = uint64_t(0x3ff+n) << 52
	x = y * *(*float64)(unsafe.Pointer(bp))
	return x
}

func Xscalbnl(tls *TLS, x float64, n int32) float64 { /* scalbnl.c:4:13: */
	return Xscalbn(tls, x, n)
}

// Support signed or unsigned plain-char

// Implementation choices...

// Arbitrary numbers...

// POSIX/SUS requirements follow. These numbers come directly
// from SUS and have nothing to do with the host system.

type __locale_map = struct {
	__map    uintptr
	map_size size_t
	name     [24]int8
	next     uintptr
} /* alltypes.h:343:9 */

type tls_module = struct {
	next   uintptr
	image  uintptr
	len    size_t
	size   size_t
	align  size_t
	offset size_t
} /* libc.h:14:1 */

type __libc = struct {
	can_do_threads  int8
	threaded        int8
	secure          int8
	need_locks      int8
	threads_minus_1 int32
	auxv            uintptr
	tls_head        uintptr
	tls_size        size_t
	tls_align       size_t
	tls_cnt         size_t
	page_size       size_t
	global_locale   struct{ cat [6]uintptr }
} /* libc.h:20:1 */

type time_t = int64 /* alltypes.h:85:16 */

type clockid_t = int32 /* alltypes.h:214:13 */

type timespec = struct {
	tv_sec  time_t
	tv_nsec int64
} /* alltypes.h:229:1 */

type pthread_t = uintptr /* alltypes.h:273:26 */

type pthread_once_t = int32 /* alltypes.h:279:13 */

type pthread_key_t = uint32 /* alltypes.h:284:18 */

type pthread_spinlock_t = int32 /* alltypes.h:289:13 */

type pthread_mutexattr_t = struct{ __attr uint32 } /* alltypes.h:294:37 */

type pthread_condattr_t = struct{ __attr uint32 } /* alltypes.h:299:37 */

type pthread_barrierattr_t = struct{ __attr uint32 } /* alltypes.h:304:37 */

type pthread_rwlockattr_t = struct{ __attr [2]uint32 } /* alltypes.h:309:40 */

type __sigset_t = struct{ __bits [16]uint64 } /* alltypes.h:349:9 */

type sigset_t = __sigset_t /* alltypes.h:349:71 */

type pthread_attr_t = struct {
	__u struct {
		_   [0]uint64
		__i [14]int32
	}
} /* alltypes.h:372:147 */

type pthread_mutex_t = struct {
	__u struct {
		_   [0]uint64
		__i [10]int32
	}
} /* alltypes.h:377:157 */

type pthread_cond_t = struct {
	__u struct {
		_   [0]uint64
		__i [12]int32
	}
} /* alltypes.h:387:112 */

type pthread_rwlock_t = struct {
	__u struct {
		_   [0]uint64
		__i [14]int32
	}
} /* alltypes.h:397:139 */

type pthread_barrier_t = struct {
	__u struct {
		_   [0]uint64
		__i [8]int32
	}
} /* alltypes.h:402:137 */

type sched_param = struct {
	sched_priority int32
	__reserved1    int32
	__reserved2    [2]struct {
		__reserved1 time_t
		__reserved2 int64
	}
	__reserved3 int32
	_           [4]byte
} /* sched.h:19:1 */

type timer_t = uintptr /* alltypes.h:209:14 */

type clock_t = int64 /* alltypes.h:219:14 */

type tm = struct {
	tm_sec    int32
	tm_min    int32
	tm_hour   int32
	tm_mday   int32
	tm_mon    int32
	tm_year   int32
	tm_wday   int32
	tm_yday   int32
	tm_isdst  int32
	_         [4]byte
	tm_gmtoff int64
	tm_zone   uintptr
} /* time.h:38:1 */

type itimerspec = struct {
	it_interval struct {
		tv_sec  time_t
		tv_nsec int64
	}
	it_value struct {
		tv_sec  time_t
		tv_nsec int64
	}
} /* time.h:80:1 */

type sigevent = struct {
	sigev_value struct {
		_         [0]uint64
		sival_int int32
		_         [4]byte
	}
	sigev_signo             int32
	sigev_notify            int32
	sigev_notify_function   uintptr
	sigev_notify_attributes uintptr
	__pad                   [32]int8
} /* time.h:107:1 */

type __ptcb = struct {
	__f    uintptr
	__x    uintptr
	__next uintptr
} /* alltypes.h:273:9 */

type sigaltstack = struct {
	ss_sp    uintptr
	ss_flags int32
	_        [4]byte
	ss_size  size_t
} /* signal.h:44:9 */

type stack_t = sigaltstack /* signal.h:44:28 */

type greg_t = int64        /* signal.h:59:19 */
type gregset_t = [23]int64 /* signal.h:59:27 */
type _fpstate = struct {
	cwd       uint16
	swd       uint16
	ftw       uint16
	fop       uint16
	rip       uint64
	rdp       uint64
	mxcsr     uint32
	mxcr_mask uint32
	_st       [8]struct {
		significand [4]uint16
		exponent    uint16
		padding     [3]uint16
	}
	_xmm    [16]struct{ element [4]uint32 }
	padding [24]uint32
} /* signal.h:60:9 */

type fpregset_t = uintptr /* signal.h:71:3 */
type sigcontext = struct {
	r8          uint64
	r9          uint64
	r10         uint64
	r11         uint64
	r12         uint64
	r13         uint64
	r14         uint64
	r15         uint64
	rdi         uint64
	rsi         uint64
	rbp         uint64
	rbx         uint64
	rdx         uint64
	rax         uint64
	rcx         uint64
	rsp         uint64
	rip         uint64
	eflags      uint64
	cs          uint16
	gs          uint16
	fs          uint16
	__pad0      uint16
	err         uint64
	trapno      uint64
	oldmask     uint64
	cr2         uint64
	fpstate     uintptr
	__reserved1 [8]uint64
} /* signal.h:72:1 */

type mcontext_t = struct {
	gregs       gregset_t
	fpregs      fpregset_t
	__reserved1 [8]uint64
} /* signal.h:84:3 */

type __ucontext = struct {
	uc_flags     uint64
	uc_link      uintptr
	uc_stack     stack_t
	uc_mcontext  mcontext_t
	uc_sigmask   sigset_t
	__fpregs_mem [64]uint64
} /* signal.h:97:9 */

type ucontext_t = __ucontext /* signal.h:104:3 */

type sigval = struct {
	_         [0]uint64
	sival_int int32
	_         [4]byte
} /* time.h:107:1 */

type siginfo_t = struct {
	si_signo    int32
	si_errno    int32
	si_code     int32
	_           [4]byte
	__si_fields struct {
		_     [0]uint64
		__pad [112]int8
	}
} /* signal.h:145:3 */

type sigaction = struct {
	__sa_handler struct{ sa_handler uintptr }
	sa_mask      sigset_t
	sa_flags     int32
	_            [4]byte
	sa_restorer  uintptr
} /* signal.h:167:1 */

type sig_t = uintptr /* signal.h:251:14 */

type sig_atomic_t = int32 /* signal.h:269:13 */

func a_cas(tls *TLS, p uintptr, t int32, s int32) int32 { /* atomic_arch.h:2:19: */
	panic(`arch/x86_64/atomic_arch.h:4:2: assembler statements not supported`)
	return t
}

func a_swap(tls *TLS, p uintptr, v int32) int32 { /* atomic_arch.h:20:19: */
	panic(`arch/x86_64/atomic_arch.h:22:2: assembler statements not supported`)
	return v
}

func a_or(tls *TLS, p uintptr, v int32) { /* atomic_arch.h:46:20: */
	panic(`arch/x86_64/atomic_arch.h:48:2: assembler statements not supported`)
}

func a_or_64(tls *TLS, p uintptr, v uint64_t) { /* atomic_arch.h:62:20: */
	panic(`arch/x86_64/atomic_arch.h:64:2: assembler statements not supported`)
}

func a_ctz_64(tls *TLS, x uint64_t) int32 { /* atomic_arch.h:112:19: */
	panic(`arch/x86_64/atomic_arch.h:114:2: assembler statements not supported`)
	return int32(x)
}

func a_ctz_32(tls *TLS, x uint32_t) int32 { /* atomic.h:256:19: */
	return int32(_sdebruijn328[x&-x*uint32_t(0x076be629)>>27])
}

var _sdebruijn328 = [32]int8{
	int8(0), int8(1), int8(23), int8(2), int8(29), int8(24), int8(19), int8(3), int8(30), int8(27), int8(25), int8(11), int8(20), int8(8), int8(4), int8(13),
	int8(31), int8(22), int8(28), int8(18), int8(26), int8(10), int8(7), int8(12), int8(21), int8(17), int8(9), int8(6), int8(16), int8(5), int8(15), int8(14),
} /* atomic.h:261:20 */

type __timer = struct {
	timerid int32
	_       [4]byte
	thread  pthread_t
} /* pthread_impl.h:64:1 */

func __pthread_self(tls *TLS) uintptr { /* pthread_arch.h:1:30: */
	var self uintptr
	panic(`arch/x86_64/pthread_arch.h:4:2: assembler statements not supported`)
	return self
}

func __wake(tls *TLS, addr uintptr, cnt int32, priv int32) { /* pthread_impl.h:155:20: */
	if priv != 0 {
		priv = 128
	}
	if cnt < 0 {
		cnt = 0x7fffffff
	}
	_ = Bool32(X__syscall3(tls, int64(202), int64(addr), int64(1|priv), int64(cnt)) != int64(-38) || X__syscall3(tls, int64(202), int64(addr), int64(1), int64(cnt)) != 0)
}

func __futexwait(tls *TLS, addr uintptr, val int32, priv int32) { /* pthread_impl.h:162:20: */
	if priv != 0 {
		priv = 128
	}
	_ = Bool32(X__syscall4(tls, int64(202), int64(addr), int64(0|priv), int64(val), int64(0)) != int64(-38) || X__syscall4(tls, int64(202), int64(addr), int64(0), int64(val), int64(0)) != 0)
}

var X__fsmu8 = [51]uint32_t{
	func() uint32 {
		if 0x2 < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0x2)
	}(), func() uint32 {
		if 0x3 < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0x3)
	}(), func() uint32 {
		if 0x4 < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0x4)
	}(), func() uint32 {
		if 0x5 < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0x5)
	}(), func() uint32 {
		if 0x6 < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0x6)
	}(), func() uint32 {
		if 0x7 < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0x7)
	}(),
	func() uint32 {
		if 0x8 < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0x8)
	}(), func() uint32 {
		if 0x9 < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0x9)
	}(), func() uint32 {
		if 0xa < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0xa)
	}(), func() uint32 {
		if 0xb < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0xb)
	}(), func() uint32 {
		if 0xc < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0xc)
	}(), func() uint32 {
		if 0xd < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0xd)
	}(), func() uint32 {
		if 0xe < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0xe)
	}(), func() uint32 {
		if 0xf < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0xf)
	}(),
	func() uint32 {
		if 0x0+16 < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0x0+16)
	}(), func() uint32 {
		if 0x1+16 < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0x1+16)
	}(), func() uint32 {
		if 0x2+16 < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0x2+16)
	}(), func() uint32 {
		if 0x3+16 < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0x3+16)
	}(), func() uint32 {
		if 0x4+16 < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0x4+16)
	}(), func() uint32 {
		if 0x5+16 < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0x5+16)
	}(), func() uint32 {
		if 0x6+16 < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0x6+16)
	}(), func() uint32 {
		if 0x7+16 < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0x7+16)
	}(),
	func() uint32 {
		if 0x8+16 < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0x8+16)
	}(), func() uint32 {
		if 0x9+16 < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0x9+16)
	}(), func() uint32 {
		if 0xa+16 < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0xa+16)
	}(), func() uint32 {
		if 0xb+16 < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0xb+16)
	}(), func() uint32 {
		if 0xc+16 < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0xc+16)
	}(), func() uint32 {
		if 0xd+16 < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0xd+16)
	}(), func() uint32 {
		if 0xe+16 < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0xe+16)
	}(), func() uint32 {
		if 0xf+16 < 2 {
			return Uint32FromInt32(-1)
		}
		return func() uint32 {
			if Int32(0x80) == Int32(0x80) {
				return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
			}
			return Uint32(Uint32(0) - Uint32FromInt32(0x80))
		}()<<23 | uint32_t(0xf+16)
	}(),
	func() uint32 {
		if 0x0 == 0 {
			return func() uint32 {
				if Int32(0xa0) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0xa0))
			}() << 23
		}
		return func() uint32 {
			if 0x0 == 0xd {
				return func() uint32 {
					if Int32(0x80) == Int32(0x80) {
						return Uint32(Uint32(0x40) - Uint32FromInt32(0xa0))
					}
					return Uint32(Uint32(0) - Uint32FromInt32(0x80))
				}() << 23
			}
			return func() uint32 {
				if Int32(0x80) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0x80))
			}() << 23
		}()
	}() | uint32_t(func() uint32 {
		if Int32(0x80) == Int32(0x80) {
			return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
		}
		return Uint32(Uint32(0) - Uint32FromInt32(0x80))
	}()<<23)>>6 | uint32_t(0x0), func() uint32 {
		if 0x1 == 0 {
			return func() uint32 {
				if Int32(0xa0) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0xa0))
			}() << 23
		}
		return func() uint32 {
			if 0x1 == 0xd {
				return func() uint32 {
					if Int32(0x80) == Int32(0x80) {
						return Uint32(Uint32(0x40) - Uint32FromInt32(0xa0))
					}
					return Uint32(Uint32(0) - Uint32FromInt32(0x80))
				}() << 23
			}
			return func() uint32 {
				if Int32(0x80) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0x80))
			}() << 23
		}()
	}() | uint32_t(func() uint32 {
		if Int32(0x80) == Int32(0x80) {
			return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
		}
		return Uint32(Uint32(0) - Uint32FromInt32(0x80))
	}()<<23)>>6 | uint32_t(0x1), func() uint32 {
		if 0x2 == 0 {
			return func() uint32 {
				if Int32(0xa0) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0xa0))
			}() << 23
		}
		return func() uint32 {
			if 0x2 == 0xd {
				return func() uint32 {
					if Int32(0x80) == Int32(0x80) {
						return Uint32(Uint32(0x40) - Uint32FromInt32(0xa0))
					}
					return Uint32(Uint32(0) - Uint32FromInt32(0x80))
				}() << 23
			}
			return func() uint32 {
				if Int32(0x80) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0x80))
			}() << 23
		}()
	}() | uint32_t(func() uint32 {
		if Int32(0x80) == Int32(0x80) {
			return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
		}
		return Uint32(Uint32(0) - Uint32FromInt32(0x80))
	}()<<23)>>6 | uint32_t(0x2), func() uint32 {
		if 0x3 == 0 {
			return func() uint32 {
				if Int32(0xa0) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0xa0))
			}() << 23
		}
		return func() uint32 {
			if 0x3 == 0xd {
				return func() uint32 {
					if Int32(0x80) == Int32(0x80) {
						return Uint32(Uint32(0x40) - Uint32FromInt32(0xa0))
					}
					return Uint32(Uint32(0) - Uint32FromInt32(0x80))
				}() << 23
			}
			return func() uint32 {
				if Int32(0x80) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0x80))
			}() << 23
		}()
	}() | uint32_t(func() uint32 {
		if Int32(0x80) == Int32(0x80) {
			return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
		}
		return Uint32(Uint32(0) - Uint32FromInt32(0x80))
	}()<<23)>>6 | uint32_t(0x3), func() uint32 {
		if 0x4 == 0 {
			return func() uint32 {
				if Int32(0xa0) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0xa0))
			}() << 23
		}
		return func() uint32 {
			if 0x4 == 0xd {
				return func() uint32 {
					if Int32(0x80) == Int32(0x80) {
						return Uint32(Uint32(0x40) - Uint32FromInt32(0xa0))
					}
					return Uint32(Uint32(0) - Uint32FromInt32(0x80))
				}() << 23
			}
			return func() uint32 {
				if Int32(0x80) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0x80))
			}() << 23
		}()
	}() | uint32_t(func() uint32 {
		if Int32(0x80) == Int32(0x80) {
			return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
		}
		return Uint32(Uint32(0) - Uint32FromInt32(0x80))
	}()<<23)>>6 | uint32_t(0x4), func() uint32 {
		if 0x5 == 0 {
			return func() uint32 {
				if Int32(0xa0) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0xa0))
			}() << 23
		}
		return func() uint32 {
			if 0x5 == 0xd {
				return func() uint32 {
					if Int32(0x80) == Int32(0x80) {
						return Uint32(Uint32(0x40) - Uint32FromInt32(0xa0))
					}
					return Uint32(Uint32(0) - Uint32FromInt32(0x80))
				}() << 23
			}
			return func() uint32 {
				if Int32(0x80) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0x80))
			}() << 23
		}()
	}() | uint32_t(func() uint32 {
		if Int32(0x80) == Int32(0x80) {
			return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
		}
		return Uint32(Uint32(0) - Uint32FromInt32(0x80))
	}()<<23)>>6 | uint32_t(0x5), func() uint32 {
		if 0x6 == 0 {
			return func() uint32 {
				if Int32(0xa0) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0xa0))
			}() << 23
		}
		return func() uint32 {
			if 0x6 == 0xd {
				return func() uint32 {
					if Int32(0x80) == Int32(0x80) {
						return Uint32(Uint32(0x40) - Uint32FromInt32(0xa0))
					}
					return Uint32(Uint32(0) - Uint32FromInt32(0x80))
				}() << 23
			}
			return func() uint32 {
				if Int32(0x80) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0x80))
			}() << 23
		}()
	}() | uint32_t(func() uint32 {
		if Int32(0x80) == Int32(0x80) {
			return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
		}
		return Uint32(Uint32(0) - Uint32FromInt32(0x80))
	}()<<23)>>6 | uint32_t(0x6), func() uint32 {
		if 0x7 == 0 {
			return func() uint32 {
				if Int32(0xa0) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0xa0))
			}() << 23
		}
		return func() uint32 {
			if 0x7 == 0xd {
				return func() uint32 {
					if Int32(0x80) == Int32(0x80) {
						return Uint32(Uint32(0x40) - Uint32FromInt32(0xa0))
					}
					return Uint32(Uint32(0) - Uint32FromInt32(0x80))
				}() << 23
			}
			return func() uint32 {
				if Int32(0x80) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0x80))
			}() << 23
		}()
	}() | uint32_t(func() uint32 {
		if Int32(0x80) == Int32(0x80) {
			return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
		}
		return Uint32(Uint32(0) - Uint32FromInt32(0x80))
	}()<<23)>>6 | uint32_t(0x7),
	func() uint32 {
		if 0x8 == 0 {
			return func() uint32 {
				if Int32(0xa0) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0xa0))
			}() << 23
		}
		return func() uint32 {
			if 0x8 == 0xd {
				return func() uint32 {
					if Int32(0x80) == Int32(0x80) {
						return Uint32(Uint32(0x40) - Uint32FromInt32(0xa0))
					}
					return Uint32(Uint32(0) - Uint32FromInt32(0x80))
				}() << 23
			}
			return func() uint32 {
				if Int32(0x80) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0x80))
			}() << 23
		}()
	}() | uint32_t(func() uint32 {
		if Int32(0x80) == Int32(0x80) {
			return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
		}
		return Uint32(Uint32(0) - Uint32FromInt32(0x80))
	}()<<23)>>6 | uint32_t(0x8), func() uint32 {
		if 0x9 == 0 {
			return func() uint32 {
				if Int32(0xa0) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0xa0))
			}() << 23
		}
		return func() uint32 {
			if 0x9 == 0xd {
				return func() uint32 {
					if Int32(0x80) == Int32(0x80) {
						return Uint32(Uint32(0x40) - Uint32FromInt32(0xa0))
					}
					return Uint32(Uint32(0) - Uint32FromInt32(0x80))
				}() << 23
			}
			return func() uint32 {
				if Int32(0x80) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0x80))
			}() << 23
		}()
	}() | uint32_t(func() uint32 {
		if Int32(0x80) == Int32(0x80) {
			return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
		}
		return Uint32(Uint32(0) - Uint32FromInt32(0x80))
	}()<<23)>>6 | uint32_t(0x9), func() uint32 {
		if 0xa == 0 {
			return func() uint32 {
				if Int32(0xa0) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0xa0))
			}() << 23
		}
		return func() uint32 {
			if 0xa == 0xd {
				return func() uint32 {
					if Int32(0x80) == Int32(0x80) {
						return Uint32(Uint32(0x40) - Uint32FromInt32(0xa0))
					}
					return Uint32(Uint32(0) - Uint32FromInt32(0x80))
				}() << 23
			}
			return func() uint32 {
				if Int32(0x80) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0x80))
			}() << 23
		}()
	}() | uint32_t(func() uint32 {
		if Int32(0x80) == Int32(0x80) {
			return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
		}
		return Uint32(Uint32(0) - Uint32FromInt32(0x80))
	}()<<23)>>6 | uint32_t(0xa), func() uint32 {
		if 0xb == 0 {
			return func() uint32 {
				if Int32(0xa0) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0xa0))
			}() << 23
		}
		return func() uint32 {
			if 0xb == 0xd {
				return func() uint32 {
					if Int32(0x80) == Int32(0x80) {
						return Uint32(Uint32(0x40) - Uint32FromInt32(0xa0))
					}
					return Uint32(Uint32(0) - Uint32FromInt32(0x80))
				}() << 23
			}
			return func() uint32 {
				if Int32(0x80) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0x80))
			}() << 23
		}()
	}() | uint32_t(func() uint32 {
		if Int32(0x80) == Int32(0x80) {
			return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
		}
		return Uint32(Uint32(0) - Uint32FromInt32(0x80))
	}()<<23)>>6 | uint32_t(0xb), func() uint32 {
		if 0xc == 0 {
			return func() uint32 {
				if Int32(0xa0) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0xa0))
			}() << 23
		}
		return func() uint32 {
			if 0xc == 0xd {
				return func() uint32 {
					if Int32(0x80) == Int32(0x80) {
						return Uint32(Uint32(0x40) - Uint32FromInt32(0xa0))
					}
					return Uint32(Uint32(0) - Uint32FromInt32(0x80))
				}() << 23
			}
			return func() uint32 {
				if Int32(0x80) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0x80))
			}() << 23
		}()
	}() | uint32_t(func() uint32 {
		if Int32(0x80) == Int32(0x80) {
			return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
		}
		return Uint32(Uint32(0) - Uint32FromInt32(0x80))
	}()<<23)>>6 | uint32_t(0xc), func() uint32 {
		if 0xd == 0 {
			return func() uint32 {
				if Int32(0xa0) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0xa0))
			}() << 23
		}
		return func() uint32 {
			if 0xd == 0xd {
				return func() uint32 {
					if Int32(0x80) == Int32(0x80) {
						return Uint32(Uint32(0x40) - Uint32FromInt32(0xa0))
					}
					return Uint32(Uint32(0) - Uint32FromInt32(0x80))
				}() << 23
			}
			return func() uint32 {
				if Int32(0x80) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0x80))
			}() << 23
		}()
	}() | uint32_t(func() uint32 {
		if Int32(0x80) == Int32(0x80) {
			return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
		}
		return Uint32(Uint32(0) - Uint32FromInt32(0x80))
	}()<<23)>>6 | uint32_t(0xd), func() uint32 {
		if 0xe == 0 {
			return func() uint32 {
				if Int32(0xa0) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0xa0))
			}() << 23
		}
		return func() uint32 {
			if 0xe == 0xd {
				return func() uint32 {
					if Int32(0x80) == Int32(0x80) {
						return Uint32(Uint32(0x40) - Uint32FromInt32(0xa0))
					}
					return Uint32(Uint32(0) - Uint32FromInt32(0x80))
				}() << 23
			}
			return func() uint32 {
				if Int32(0x80) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0x80))
			}() << 23
		}()
	}() | uint32_t(func() uint32 {
		if Int32(0x80) == Int32(0x80) {
			return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
		}
		return Uint32(Uint32(0) - Uint32FromInt32(0x80))
	}()<<23)>>6 | uint32_t(0xe), func() uint32 {
		if 0xf == 0 {
			return func() uint32 {
				if Int32(0xa0) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0xa0))
			}() << 23
		}
		return func() uint32 {
			if 0xf == 0xd {
				return func() uint32 {
					if Int32(0x80) == Int32(0x80) {
						return Uint32(Uint32(0x40) - Uint32FromInt32(0xa0))
					}
					return Uint32(Uint32(0) - Uint32FromInt32(0x80))
				}() << 23
			}
			return func() uint32 {
				if Int32(0x80) == Int32(0x80) {
					return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
				}
				return Uint32(Uint32(0) - Uint32FromInt32(0x80))
			}() << 23
		}()
	}() | uint32_t(func() uint32 {
		if Int32(0x80) == Int32(0x80) {
			return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
		}
		return Uint32(Uint32(0) - Uint32FromInt32(0x80))
	}()<<23)>>6 | uint32_t(0xf),
	func() uint32 {
		if 0x0 >= 5 {
			return uint32(0)
		}
		return func() uint32 {
			if 0x0 == 0 {
				return func() uint32 {
					if Int32(0x90) == Int32(0x80) {
						return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
					}
					return Uint32(Uint32(0) - Uint32FromInt32(0x90))
				}() << 23
			}
			return func() uint32 {
				if 0x0 == 4 {
					return func() uint32 {
						if Int32(0x80) == Int32(0x80) {
							return Uint32(Uint32(0x40) - Uint32FromInt32(0x90))
						}
						return Uint32(Uint32(0) - Uint32FromInt32(0x80))
					}() << 23
				}
				return func() uint32 {
					if Int32(0x80) == Int32(0x80) {
						return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
					}
					return Uint32(Uint32(0) - Uint32FromInt32(0x80))
				}() << 23
			}()
		}()
	}() | uint32_t(func() uint32 {
		if Int32(0x80) == Int32(0x80) {
			return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
		}
		return Uint32(Uint32(0) - Uint32FromInt32(0x80))
	}()<<23)>>6 | uint32_t(func() uint32 {
		if Int32(0x80) == Int32(0x80) {
			return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
		}
		return Uint32(Uint32(0) - Uint32FromInt32(0x80))
	}()<<23)>>12 | uint32_t(0x0), func() uint32 {
		if 0x1 >= 5 {
			return uint32(0)
		}
		return func() uint32 {
			if 0x1 == 0 {
				return func() uint32 {
					if Int32(0x90) == Int32(0x80) {
						return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
					}
					return Uint32(Uint32(0) - Uint32FromInt32(0x90))
				}() << 23
			}
			return func() uint32 {
				if 0x1 == 4 {
					return func() uint32 {
						if Int32(0x80) == Int32(0x80) {
							return Uint32(Uint32(0x40) - Uint32FromInt32(0x90))
						}
						return Uint32(Uint32(0) - Uint32FromInt32(0x80))
					}() << 23
				}
				return func() uint32 {
					if Int32(0x80) == Int32(0x80) {
						return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
					}
					return Uint32(Uint32(0) - Uint32FromInt32(0x80))
				}() << 23
			}()
		}()
	}() | uint32_t(func() uint32 {
		if Int32(0x80) == Int32(0x80) {
			return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
		}
		return Uint32(Uint32(0) - Uint32FromInt32(0x80))
	}()<<23)>>6 | uint32_t(func() uint32 {
		if Int32(0x80) == Int32(0x80) {
			return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
		}
		return Uint32(Uint32(0) - Uint32FromInt32(0x80))
	}()<<23)>>12 | uint32_t(0x1), func() uint32 {
		if 0x2 >= 5 {
			return uint32(0)
		}
		return func() uint32 {
			if 0x2 == 0 {
				return func() uint32 {
					if Int32(0x90) == Int32(0x80) {
						return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
					}
					return Uint32(Uint32(0) - Uint32FromInt32(0x90))
				}() << 23
			}
			return func() uint32 {
				if 0x2 == 4 {
					return func() uint32 {
						if Int32(0x80) == Int32(0x80) {
							return Uint32(Uint32(0x40) - Uint32FromInt32(0x90))
						}
						return Uint32(Uint32(0) - Uint32FromInt32(0x80))
					}() << 23
				}
				return func() uint32 {
					if Int32(0x80) == Int32(0x80) {
						return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
					}
					return Uint32(Uint32(0) - Uint32FromInt32(0x80))
				}() << 23
			}()
		}()
	}() | uint32_t(func() uint32 {
		if Int32(0x80) == Int32(0x80) {
			return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
		}
		return Uint32(Uint32(0) - Uint32FromInt32(0x80))
	}()<<23)>>6 | uint32_t(func() uint32 {
		if Int32(0x80) == Int32(0x80) {
			return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
		}
		return Uint32(Uint32(0) - Uint32FromInt32(0x80))
	}()<<23)>>12 | uint32_t(0x2), func() uint32 {
		if 0x3 >= 5 {
			return uint32(0)
		}
		return func() uint32 {
			if 0x3 == 0 {
				return func() uint32 {
					if Int32(0x90) == Int32(0x80) {
						return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
					}
					return Uint32(Uint32(0) - Uint32FromInt32(0x90))
				}() << 23
			}
			return func() uint32 {
				if 0x3 == 4 {
					return func() uint32 {
						if Int32(0x80) == Int32(0x80) {
							return Uint32(Uint32(0x40) - Uint32FromInt32(0x90))
						}
						return Uint32(Uint32(0) - Uint32FromInt32(0x80))
					}() << 23
				}
				return func() uint32 {
					if Int32(0x80) == Int32(0x80) {
						return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
					}
					return Uint32(Uint32(0) - Uint32FromInt32(0x80))
				}() << 23
			}()
		}()
	}() | uint32_t(func() uint32 {
		if Int32(0x80) == Int32(0x80) {
			return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
		}
		return Uint32(Uint32(0) - Uint32FromInt32(0x80))
	}()<<23)>>6 | uint32_t(func() uint32 {
		if Int32(0x80) == Int32(0x80) {
			return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
		}
		return Uint32(Uint32(0) - Uint32FromInt32(0x80))
	}()<<23)>>12 | uint32_t(0x3), func() uint32 {
		if 0x4 >= 5 {
			return uint32(0)
		}
		return func() uint32 {
			if 0x4 == 0 {
				return func() uint32 {
					if Int32(0x90) == Int32(0x80) {
						return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
					}
					return Uint32(Uint32(0) - Uint32FromInt32(0x90))
				}() << 23
			}
			return func() uint32 {
				if 0x4 == 4 {
					return func() uint32 {
						if Int32(0x80) == Int32(0x80) {
							return Uint32(Uint32(0x40) - Uint32FromInt32(0x90))
						}
						return Uint32(Uint32(0) - Uint32FromInt32(0x80))
					}() << 23
				}
				return func() uint32 {
					if Int32(0x80) == Int32(0x80) {
						return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
					}
					return Uint32(Uint32(0) - Uint32FromInt32(0x80))
				}() << 23
			}()
		}()
	}() | uint32_t(func() uint32 {
		if Int32(0x80) == Int32(0x80) {
			return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
		}
		return Uint32(Uint32(0) - Uint32FromInt32(0x80))
	}()<<23)>>6 | uint32_t(func() uint32 {
		if Int32(0x80) == Int32(0x80) {
			return Uint32(Uint32(0x40) - Uint32FromInt32(0xc0))
		}
		return Uint32(Uint32(0) - Uint32FromInt32(0x80))
	}()<<23)>>12 | uint32_t(0x4),
} /* internal.c:18:16 */

type wint_t = uint32 /* alltypes.h:198:18 */

type wctype_t = uint64 /* alltypes.h:203:23 */

type __mbstate_t = struct {
	__opaque1 uint32
	__opaque2 uint32
} /* alltypes.h:337:9 */

type mbstate_t = __mbstate_t /* alltypes.h:337:63 */

func Xmbrtowc(tls *TLS, wc uintptr, src uintptr, n size_t, st uintptr) size_t { /* mbrtowc.c:6:8: */
	bp := tls.Alloc(4)
	defer tls.Free(4)

	var c uint32
	var s uintptr
	var N uint32
	// var dummy wchar_t at bp, 4
	s = src
	N = uint32(n)

	if !!(st != 0) {
		goto __1
	}
	st = uintptr(unsafe.Pointer(&_sinternal_state))
__1:
	;
	c = *(*uint32)(unsafe.Pointer(st))

	if !!(s != 0) {
		goto __2
	}
	if !(c != 0) {
		goto __4
	}
	goto ilseq
__4:
	;
	return uint64(0)
	goto __3
__2:
	if !!(wc != 0) {
		goto __5
	}
	wc = bp /* &dummy */
__5:
	;
__3:
	;

	if !!(n != 0) {
		goto __6
	}
	return Uint64FromInt32(-2)
__6:
	;
	if !!(c != 0) {
		goto __7
	}
	if !(int32(*(*uint8)(unsafe.Pointer(s))) < 0x80) {
		goto __8
	}
	return BoolUint64(!!(AssignPtrInt32(wc, wchar_t(*(*uint8)(unsafe.Pointer(s)))) != 0))
__8:
	;
	if !(func() int32 {
		if !!(int32(*(*uintptr)(unsafe.Pointer((*__pthread)(unsafe.Pointer(__pthread_self(tls))).locale))) != 0) {
			return 4
		}
		return 1
	}() == 1) {
		goto __9
	}
	*(*wchar_t)(unsafe.Pointer(wc)) = 0xdfff & int32(int8(*(*uint8)(unsafe.Pointer(s))))
	return 1
__9:
	;
	if !(uint32(*(*uint8)(unsafe.Pointer(s)))-0xc2 > 0xf4-0xc2) {
		goto __10
	}
	goto ilseq
__10:
	;
	c = X__fsmu8[uint32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&s, 1))))-0xc2]
	n--
__7:
	;

	if !(n != 0) {
		goto __11
	}
	if !((int32(*(*uint8)(unsafe.Pointer(s)))>>3-0x10|(int32(*(*uint8)(unsafe.Pointer(s)))>>3+int32_t(c)>>26))&CplInt32(7) != 0) {
		goto __12
	}
	goto ilseq
__12:
	;
loop:
	c = c<<6 | uint32(int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&s, 1))))-0x80)
	n--
	if !!(c&(uint32(1)<<31) != 0) {
		goto __13
	}
	*(*uint32)(unsafe.Pointer(st)) = uint32(0)
	*(*wchar_t)(unsafe.Pointer(wc)) = wchar_t(c)
	return size_t(N) - n
__13:
	;
	if !(n != 0) {
		goto __14
	}
	if !(uint32(*(*uint8)(unsafe.Pointer(s)))-0x80 >= uint32(0x40)) {
		goto __15
	}
	goto ilseq
__15:
	;
	goto loop
__14:
	;
__11:
	;

	*(*uint32)(unsafe.Pointer(st)) = c
	return Uint64FromInt32(-2)
ilseq:
	*(*uint32)(unsafe.Pointer(st)) = uint32(0)
	*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 84
	return Uint64FromInt32(-1)
}

var _sinternal_state uint32 /* mbrtowc.c:8:18: */

func Xmbsinit(tls *TLS, st uintptr) int32 { /* mbsinit.c:3:5: */
	return Bool32(!(st != 0) || !(int32(*(*uint32)(unsafe.Pointer(st))) != 0))
}

type imaxdiv_t = struct {
	quot intmax_t
	rem  intmax_t
} /* inttypes.h:14:40 */

type socklen_t = uint32 /* alltypes.h:361:18 */

type sa_family_t = uint16 /* alltypes.h:366:24 */

type msghdr = struct {
	msg_name       uintptr
	msg_namelen    socklen_t
	_              [4]byte
	msg_iov        uintptr
	msg_iovlen     int32
	__pad1         int32
	msg_control    uintptr
	msg_controllen socklen_t
	__pad2         int32
	msg_flags      int32
	_              [4]byte
} /* socket.h:22:1 */

type cmsghdr = struct {
	cmsg_len   socklen_t
	__pad1     int32
	cmsg_level int32
	cmsg_type  int32
} /* socket.h:44:1 */

type linger = struct {
	l_onoff  int32
	l_linger int32
} /* socket.h:74:1 */

type sockaddr = struct {
	sa_family sa_family_t
	sa_data   [14]int8
} /* socket.h:367:1 */

type sockaddr_storage = struct {
	ss_family    sa_family_t
	__ss_padding [118]int8
	__ss_align   uint64
} /* socket.h:372:1 */

type in_port_t = uint16_t                 /* in.h:12:18 */
type in_addr_t = uint32_t                 /* in.h:13:18 */
type in_addr = struct{ s_addr in_addr_t } /* in.h:14:1 */

type sockaddr_in = struct {
	sin_family sa_family_t
	sin_port   in_port_t
	sin_addr   struct{ s_addr in_addr_t }
	sin_zero   [8]uint8_t
} /* in.h:16:1 */

type in6_addr = struct {
	__in6_union struct {
		_         [0]uint32
		__s6_addr [16]uint8_t
	}
} /* in.h:23:1 */

type sockaddr_in6 = struct {
	sin6_family   sa_family_t
	sin6_port     in_port_t
	sin6_flowinfo uint32_t
	sin6_addr     struct {
		__in6_union struct {
			_         [0]uint32
			__s6_addr [16]uint8_t
		}
	}
	sin6_scope_id uint32_t
} /* in.h:34:1 */

type ipv6_mreq = struct {
	ipv6mr_multiaddr struct {
		__in6_union struct {
			_         [0]uint32
			__s6_addr [16]uint8_t
		}
	}
	ipv6mr_interface uint32
} /* in.h:42:1 */

type ip_opts = struct {
	ip_dst  struct{ s_addr in_addr_t }
	ip_opts [40]int8
} /* in.h:229:1 */

type ip_mreq = struct {
	imr_multiaddr struct{ s_addr in_addr_t }
	imr_interface struct{ s_addr in_addr_t }
} /* in.h:247:1 */

type ip_mreqn = struct {
	imr_multiaddr struct{ s_addr in_addr_t }
	imr_address   struct{ s_addr in_addr_t }
	imr_ifindex   int32
} /* in.h:252:1 */

type ip_mreq_source = struct {
	imr_multiaddr  struct{ s_addr in_addr_t }
	imr_interface  struct{ s_addr in_addr_t }
	imr_sourceaddr struct{ s_addr in_addr_t }
} /* in.h:258:1 */

type ip_msfilter = struct {
	imsf_multiaddr struct{ s_addr in_addr_t }
	imsf_interface struct{ s_addr in_addr_t }
	imsf_fmode     uint32_t
	imsf_numsrc    uint32_t
	imsf_slist     [1]struct{ s_addr in_addr_t }
} /* in.h:264:1 */

type group_req = struct {
	gr_interface uint32_t
	_            [4]byte
	gr_group     struct {
		ss_family    sa_family_t
		__ss_padding [118]int8
		__ss_align   uint64
	}
} /* in.h:275:1 */

type group_source_req = struct {
	gsr_interface uint32_t
	_             [4]byte
	gsr_group     struct {
		ss_family    sa_family_t
		__ss_padding [118]int8
		__ss_align   uint64
	}
	gsr_source struct {
		ss_family    sa_family_t
		__ss_padding [118]int8
		__ss_align   uint64
	}
} /* in.h:280:1 */

type group_filter = struct {
	gf_interface uint32_t
	_            [4]byte
	gf_group     struct {
		ss_family    sa_family_t
		__ss_padding [118]int8
		__ss_align   uint64
	}
	gf_fmode  uint32_t
	gf_numsrc uint32_t
	gf_slist  [1]struct {
		ss_family    sa_family_t
		__ss_padding [118]int8
		__ss_align   uint64
	}
} /* in.h:286:1 */

type in_pktinfo = struct {
	ipi_ifindex  int32
	ipi_spec_dst struct{ s_addr in_addr_t }
	ipi_addr     struct{ s_addr in_addr_t }
} /* in.h:297:1 */

type in6_pktinfo = struct {
	ipi6_addr struct {
		__in6_union struct {
			_         [0]uint32
			__s6_addr [16]uint8_t
		}
	}
	ipi6_ifindex uint32
} /* in.h:303:1 */

type ip6_mtuinfo = struct {
	ip6m_addr struct {
		sin6_family   sa_family_t
		sin6_port     in_port_t
		sin6_flowinfo uint32_t
		sin6_addr     struct {
			__in6_union struct {
				_         [0]uint32
				__s6_addr [16]uint8_t
			}
		}
		sin6_scope_id uint32_t
	}
	ip6m_mtu uint32_t
} /* in.h:308:1 */

type addrinfo = struct {
	ai_flags     int32
	ai_family    int32
	ai_socktype  int32
	ai_protocol  int32
	ai_addrlen   socklen_t
	_            [4]byte
	ai_addr      uintptr
	ai_canonname uintptr
	ai_next      uintptr
} /* netdb.h:16:1 */

// Legacy functions follow (marked OBsolete in SUS)

type netent = struct {
	n_name     uintptr
	n_aliases  uintptr
	n_addrtype int32
	n_net      uint32_t
} /* netdb.h:62:1 */

type hostent = struct {
	h_name      uintptr
	h_aliases   uintptr
	h_addrtype  int32
	h_length    int32
	h_addr_list uintptr
} /* netdb.h:69:1 */

type servent = struct {
	s_name    uintptr
	s_aliases uintptr
	s_port    int32
	_         [4]byte
	s_proto   uintptr
} /* netdb.h:78:1 */

type protoent = struct {
	p_name    uintptr
	p_aliases uintptr
	p_proto   int32
	_         [4]byte
} /* netdb.h:85:1 */

type aibuf = struct {
	ai struct {
		ai_flags     int32
		ai_family    int32
		ai_socktype  int32
		ai_protocol  int32
		ai_addrlen   socklen_t
		_            [4]byte
		ai_addr      uintptr
		ai_canonname uintptr
		ai_next      uintptr
	}
	sa struct {
		sin struct {
			sin_family sa_family_t
			sin_port   in_port_t
			sin_addr   struct{ s_addr in_addr_t }
			sin_zero   [8]uint8_t
		}
		_ [12]byte
	}
	lock [1]int32
	slot int16
	ref  int16
	_    [4]byte
} /* lookup.h:10:1 */

type sa = struct {
	sin struct {
		sin_family sa_family_t
		sin_port   in_port_t
		sin_addr   struct{ s_addr in_addr_t }
		sin_zero   [8]uint8_t
	}
	_ [12]byte
} /* lookup.h:10:1 */

type address = struct {
	family  int32
	scopeid uint32
	addr    [16]uint8_t
	sortkey int32
} /* lookup.h:20:1 */

type service = struct {
	port     uint16_t
	proto    uint8
	socktype uint8
} /* lookup.h:27:1 */

type resolvconf = struct {
	ns [3]struct {
		family  int32
		scopeid uint32
		addr    [16]uint8_t
		sortkey int32
	}
	nns      uint32
	attempts uint32
	ndots    uint32
	timeout  uint32
} /* lookup.h:34:1 */

func Xfreeaddrinfo(tls *TLS, p uintptr) { /* freeaddrinfo.c:7:6: */
	var cnt size_t
	cnt = uint64(1)
__1:
	if !((*addrinfo)(unsafe.Pointer(p)).ai_next != 0) {
		goto __3
	}
	goto __2
__2:
	cnt++
	p = (*addrinfo)(unsafe.Pointer(p)).ai_next
	goto __1
	goto __3
__3:
	;
	var b uintptr = p - uintptr(uint64(uintptr(0)))
	b -= 88 * uintptr((*aibuf)(unsafe.Pointer(b)).slot)
	//TODO LOCK(b->lock);
	if !(int32(AssignSubPtrInt16(b+82, int16(cnt))) != 0) {
		Xfree(tls, b)
	}
	//TODO else UNLOCK(b->lock);
}

func Xgetaddrinfo(tls *TLS, host uintptr, serv uintptr, hint uintptr, res uintptr) int32 { /* getaddrinfo.c:12:5: */
	bp := tls.Alloc(1608)
	defer tls.Free(1608)

	// var ports [2]service at bp, 8

	// var addrs [48]address at bp+8, 1344

	// var canon [256]int8 at bp+1352, 256

	var outcanon uintptr
	var nservs int32
	var naddrs int32
	var nais int32
	var canon_len int32
	var i int32
	var j int32
	var k int32
	var family int32 = 0
	var flags int32 = 0
	var proto int32 = 0
	var socktype int32 = 0
	var out uintptr

	if !(host != 0) && !(serv != 0) {
		return -2
	}

	if hint != 0 {
		family = (*addrinfo)(unsafe.Pointer(hint)).ai_family
		flags = (*addrinfo)(unsafe.Pointer(hint)).ai_flags
		proto = (*addrinfo)(unsafe.Pointer(hint)).ai_protocol
		socktype = (*addrinfo)(unsafe.Pointer(hint)).ai_socktype

		var mask int32 = 0x01 | 0x02 | 0x04 | 0x08 | 0x10 | 0x20 | 0x400
		if flags&mask != flags {
			return -1
		}

		switch family {
		case 2:
			fallthrough
		case 10:
			fallthrough
		case 0:
			break
			fallthrough
		default:
			return -6
		}
	}

	if flags&0x20 != 0 {
		Xabort(tls) //TODO-
		// 	/* Define the "an address is configured" condition for address
		// 	 * families via ability to create a socket for the family plus
		// 	 * routability of the loopback address for the family. */
		// 	static const struct sockaddr_in lo4 = {
		// 		.sin_family = AF_INET, .sin_port = 65535,
		// 		.sin_addr.s_addr = __BYTE_ORDER == __BIG_ENDIAN
		// 			? 0x7f000001 : 0x0100007f
		// 	};
		// 	static const struct sockaddr_in6 lo6 = {
		// 		.sin6_family = AF_INET6, .sin6_port = 65535,
		// 		.sin6_addr = IN6ADDR_LOOPBACK_INIT
		// 	};
		// 	int tf[2] = { AF_INET, AF_INET6 };
		// 	const void *ta[2] = { &lo4, &lo6 };
		// 	socklen_t tl[2] = { sizeof lo4, sizeof lo6 };
		// 	for (i=0; i<2; i++) {
		// 		if (family==tf[1-i]) continue;
		// 		int s = socket(tf[i], SOCK_CLOEXEC|SOCK_DGRAM,
		// 			IPPROTO_UDP);
		// 		if (s>=0) {
		// 			int cs;
		// 			pthread_setcancelstate(
		// 				PTHREAD_CANCEL_DISABLE, &cs);
		// 			int r = connect(s, ta[i], tl[i]);
		// 			pthread_setcancelstate(cs, 0);
		// 			close(s);
		// 			if (!r) continue;
		// 		}
		// 		switch (errno) {
		// 		case EADDRNOTAVAIL:
		// 		case EAFNOSUPPORT:
		// 		case EHOSTUNREACH:
		// 		case ENETDOWN:
		// 		case ENETUNREACH:
		// 			break;
		// 		default:
		// 			return EAI_SYSTEM;
		// 		}
		// 		if (family == tf[i]) return EAI_NONAME;
		// 		family = tf[1-i];
		// 	}
	}

	nservs = X__lookup_serv(tls, bp, serv, proto, socktype, flags)
	if nservs < 0 {
		return nservs
	}

	naddrs = X__lookup_name(tls, bp+8, bp+1352, host, family, flags)
	if naddrs < 0 {
		return naddrs
	}

	nais = nservs * naddrs
	canon_len = int32(Xstrlen(tls, bp+1352))
	out = Xcalloc(tls, uint64(1), uint64(nais)*uint64(unsafe.Sizeof(aibuf{}))+uint64(canon_len)+uint64(1))
	if !(out != 0) {
		return -10
	}

	if canon_len != 0 {
		outcanon = out + uintptr(nais)*88
		Xmemcpy(tls, outcanon, bp+1352, uint64(canon_len+1))
	} else {
		outcanon = uintptr(0)
	}

	for k = AssignInt32(&i, 0); i < naddrs; i++ {
		j = 0
	__1:
		if !(j < nservs) {
			goto __3
		}
		{
			(*aibuf)(unsafe.Pointer(out + uintptr(k)*88)).slot = int16(k)
			//TODO out[k].ai = (struct addrinfo){
			//TODO 	.ai_family = addrs[i].family,
			//TODO 	.ai_socktype = ports[j].socktype,
			//TODO 	.ai_protocol = ports[j].proto,
			//TODO 	.ai_addrlen = addrs[i].family == AF_INET
			//TODO 		? sizeof(struct sockaddr_in)
			//TODO 		: sizeof(struct sockaddr_in6),
			//TODO 	.ai_addr = (void *)&out[k].sa,
			//TODO 	.ai_canonname = outcanon };
			(*aibuf)(unsafe.Pointer(out + uintptr(k)*88)).ai.ai_family = (*address)(unsafe.Pointer(bp + 8 + uintptr(i)*28)).family
			(*aibuf)(unsafe.Pointer(out + uintptr(k)*88)).ai.ai_socktype = int32((*service)(unsafe.Pointer(bp + uintptr(j)*4)).socktype)
			(*aibuf)(unsafe.Pointer(out + uintptr(k)*88)).ai.ai_protocol = int32((*service)(unsafe.Pointer(bp + uintptr(j)*4)).proto)
			(*aibuf)(unsafe.Pointer(out + uintptr(k)*88)).ai.ai_addrlen = func() uint32 {
				if (*address)(unsafe.Pointer(bp+8+uintptr(i)*28)).family == 2 {
					return uint32(unsafe.Sizeof(sockaddr_in{}))
				}
				return uint32(unsafe.Sizeof(sockaddr_in6{}))
			}()
			(*aibuf)(unsafe.Pointer(out + uintptr(k)*88)).ai.ai_addr = out + uintptr(k)*88 + 48
			(*aibuf)(unsafe.Pointer(out + uintptr(k)*88)).ai.ai_canonname = outcanon
			if k != 0 {
				(*aibuf)(unsafe.Pointer(out + uintptr(k-1)*88)).ai.ai_next = out + uintptr(k)*88
			}
			switch (*address)(unsafe.Pointer(bp + 8 + uintptr(i)*28)).family {
			case 2:
				(*sockaddr_in)(unsafe.Pointer(out + uintptr(k)*88 + 48)).sin_family = sa_family_t(2)
				(*sockaddr_in)(unsafe.Pointer(out + uintptr(k)*88 + 48)).sin_port = Xhtons(tls, (*service)(unsafe.Pointer(bp+uintptr(j)*4)).port)
				Xmemcpy(tls, out+uintptr(k)*88+48+4, bp+8+uintptr(i)*28+8, uint64(4))
				break
			case 10:
				(*sockaddr_in6)(unsafe.Pointer(out + uintptr(k)*88 + 48)).sin6_family = sa_family_t(10)
				(*sockaddr_in6)(unsafe.Pointer(out + uintptr(k)*88 + 48)).sin6_port = Xhtons(tls, (*service)(unsafe.Pointer(bp+uintptr(j)*4)).port)
				(*sockaddr_in6)(unsafe.Pointer(out + uintptr(k)*88 + 48)).sin6_scope_id = (*address)(unsafe.Pointer(bp + 8 + uintptr(i)*28)).scopeid
				Xmemcpy(tls, out+uintptr(k)*88+48+8, bp+8+uintptr(i)*28+8, uint64(16))
				break
			}

		}
		goto __2
	__2:
		j++
		k++
		goto __1
		goto __3
	__3:
	}
	(*aibuf)(unsafe.Pointer(out)).ref = int16(nais)
	*(*uintptr)(unsafe.Pointer(res)) = out
	return 0
}

type ucred = struct {
	pid pid_t
	uid uid_t
	gid gid_t
} /* socket.h:57:1 */

type mmsghdr = struct {
	msg_hdr struct {
		msg_name       uintptr
		msg_namelen    socklen_t
		_              [4]byte
		msg_iov        uintptr
		msg_iovlen     int32
		__pad1         int32
		msg_control    uintptr
		msg_controllen socklen_t
		__pad2         int32
		msg_flags      int32
		_              [4]byte
	}
	msg_len uint32
	_       [4]byte
} /* socket.h:63:1 */

func Xgethostbyaddr(tls *TLS, a uintptr, l socklen_t, af int32) uintptr { /* gethostbyaddr.c:7:16: */
	bp := tls.Alloc(8)
	defer tls.Free(8)

	var size size_t = uint64(63)
	// var res uintptr at bp, 8

	var err int32
	for ok := true; ok; ok = err == 34 {
		Xfree(tls, _sh)
		_sh = Xmalloc(tls, AssignAddUint64(&size, size+uint64(1)))
		if !(_sh != 0) {
			*(*int32)(unsafe.Pointer(X__h_errno_location(tls))) = 3
			return uintptr(0)
		}
		err = Xgethostbyaddr_r(tls, a, l, af, _sh,
			_sh+uintptr(1)*32, size-size_t(unsafe.Sizeof(hostent{})), bp, X__h_errno_location(tls))
	}
	if err != 0 {
		return uintptr(0)
	}
	return _sh
}

var _sh uintptr /* gethostbyaddr.c:9:24: */

func Xgethostbyaddr_r(tls *TLS, a uintptr, l socklen_t, af int32, h uintptr, buf uintptr, buflen size_t, res uintptr, err uintptr) int32 { /* gethostbyaddr_r.c:10:5: */
	bp := tls.Alloc(28)
	defer tls.Free(28)

	//TODO union {
	//TODO 	struct sockaddr_in sin;
	//TODO 	struct sockaddr_in6 sin6;
	//TODO } sa = { .sin.sin_family = af };
	*(*struct {
		sin sockaddr_in
		_   [12]byte
	})(unsafe.Pointer(bp)) = struct {
		sin sockaddr_in
		_   [12]byte
	}{} //TODO-
	(*sockaddr_in)(unsafe.Pointer(bp)).sin_family = sa_family_t(af) //TODO-
	var sl socklen_t
	if af == 10 {
		sl = uint32(unsafe.Sizeof(sockaddr_in6{}))
	} else {
		sl = uint32(unsafe.Sizeof(sockaddr_in{}))
	}
	var i int32

	*(*uintptr)(unsafe.Pointer(res)) = uintptr(0)

	// Load address argument into sockaddr structure
	if af == 10 && l == socklen_t(16) {
		Xmemcpy(tls, bp+8, a, uint64(16))
	} else if af == 2 && l == socklen_t(4) {
		Xmemcpy(tls, bp+4, a, uint64(4))
	} else {
		*(*int32)(unsafe.Pointer(err)) = 3
		return 22
	}

	// Align buffer and check for space for pointers and ip address
	i = int32(uintptr_t(buf) & (uint64(unsafe.Sizeof(uintptr(0))) - uint64(1)))
	if !(i != 0) {
		i = int32(unsafe.Sizeof(uintptr(0)))
	}
	if buflen <= uint64(5)*uint64(unsafe.Sizeof(uintptr(0)))-uint64(i)+uint64(l) {
		return 34
	}
	buf += uintptr(uint64(unsafe.Sizeof(uintptr(0))) - uint64(i))
	buflen = buflen - (uint64(5)*uint64(unsafe.Sizeof(uintptr(0))) - uint64(i) + uint64(l))

	(*hostent)(unsafe.Pointer(h)).h_addr_list = buf
	buf += uintptr(uint64(2) * uint64(unsafe.Sizeof(uintptr(0))))
	(*hostent)(unsafe.Pointer(h)).h_aliases = buf
	buf += uintptr(uint64(2) * uint64(unsafe.Sizeof(uintptr(0))))

	*(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_addr_list)) = buf
	Xmemcpy(tls, *(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_addr_list)), a, uint64(l))
	buf += uintptr(l)
	*(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_addr_list + 1*8)) = uintptr(0)
	*(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_aliases)) = buf
	*(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_aliases + 1*8)) = uintptr(0)

	switch Xgetnameinfo(tls, bp, sl, buf, uint32(buflen), uintptr(0), uint32(0), 0) {
	case -3:
		*(*int32)(unsafe.Pointer(err)) = 2
		return 11
	case -12:
		return 34
	default:
		fallthrough
	case -10:
		fallthrough
	case -11:
		fallthrough
	case -4:
		*(*int32)(unsafe.Pointer(err)) = 3
		return *(*int32)(unsafe.Pointer(X___errno_location(tls)))
	case 0:
		break
	}

	(*hostent)(unsafe.Pointer(h)).h_addrtype = af
	(*hostent)(unsafe.Pointer(h)).h_length = int32(l)
	(*hostent)(unsafe.Pointer(h)).h_name = *(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_aliases))
	*(*uintptr)(unsafe.Pointer(res)) = h
	return 0
}

func Xgethostbyname(tls *TLS, name uintptr) uintptr { /* gethostbyname.c:8:16: */
	return Xgethostbyname2(tls, name, 2)
}

func Xgethostbyname2(tls *TLS, name uintptr, af int32) uintptr { /* gethostbyname2.c:8:16: */
	bp := tls.Alloc(8)
	defer tls.Free(8)

	var size size_t = uint64(63)
	// var res uintptr at bp, 8

	var err int32
	for ok := true; ok; ok = err == 34 {
		Xfree(tls, _sh1)
		_sh1 = Xmalloc(tls, AssignAddUint64(&size, size+uint64(1)))
		if !(_sh1 != 0) {
			*(*int32)(unsafe.Pointer(X__h_errno_location(tls))) = 3
			return uintptr(0)
		}
		err = Xgethostbyname2_r(tls, name, af, _sh1,
			_sh1+uintptr(1)*32, size-size_t(unsafe.Sizeof(hostent{})), bp, X__h_errno_location(tls))
	}
	if err != 0 {
		return uintptr(0)
	}
	return _sh1
}

var _sh1 uintptr /* gethostbyname2.c:10:24: */

func Xgethostbyname2_r(tls *TLS, name uintptr, af int32, h uintptr, buf uintptr, buflen size_t, res uintptr, err uintptr) int32 { /* gethostbyname2_r.c:11:5: */
	bp := tls.Alloc(1600)
	defer tls.Free(1600)

	// var addrs [48]address at bp, 1344

	// var canon [256]int8 at bp+1344, 256

	var i int32
	var cnt int32
	var align size_t
	var need size_t

	*(*uintptr)(unsafe.Pointer(res)) = uintptr(0)
	cnt = X__lookup_name(tls, bp, bp+1344, name, af, 0x02)
	if cnt < 0 {
		switch cnt {
		case -2:
			*(*int32)(unsafe.Pointer(err)) = 1
			return 2
			fallthrough
		case -3:
			*(*int32)(unsafe.Pointer(err)) = 2
			return 11
			fallthrough
		default:
			fallthrough
		case -4:
			*(*int32)(unsafe.Pointer(err)) = 3
			return 74
			fallthrough
		case -10:
			fallthrough
		case -11:
			*(*int32)(unsafe.Pointer(err)) = 3
			return *(*int32)(unsafe.Pointer(X___errno_location(tls)))
		}
	}

	(*hostent)(unsafe.Pointer(h)).h_addrtype = af
	(*hostent)(unsafe.Pointer(h)).h_length = func() int32 {
		if af == 10 {
			return 16
		}
		return 4
	}()

	// Align buffer
	align = -uintptr_t(buf) & (uint64(unsafe.Sizeof(uintptr(0))) - uint64(1))

	need = uint64(4) * uint64(unsafe.Sizeof(uintptr(0)))
	need = need + uint64(cnt+1)*(uint64(unsafe.Sizeof(uintptr(0)))+uint64((*hostent)(unsafe.Pointer(h)).h_length))
	need = need + (Xstrlen(tls, name) + uint64(1))
	need = need + (Xstrlen(tls, bp+1344) + uint64(1))
	need = need + align

	if need > buflen {
		return 34
	}

	buf += uintptr(align)
	(*hostent)(unsafe.Pointer(h)).h_aliases = buf
	buf += uintptr(uint64(3) * uint64(unsafe.Sizeof(uintptr(0))))
	(*hostent)(unsafe.Pointer(h)).h_addr_list = buf
	buf += uintptr(uint64(cnt+1) * uint64(unsafe.Sizeof(uintptr(0))))

	for i = 0; i < cnt; i++ {
		*(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_addr_list + uintptr(i)*8)) = buf
		buf += uintptr((*hostent)(unsafe.Pointer(h)).h_length)
		Xmemcpy(tls, *(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_addr_list + uintptr(i)*8)), bp+uintptr(i)*28+8, uint64((*hostent)(unsafe.Pointer(h)).h_length))
	}
	*(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_addr_list + uintptr(i)*8)) = uintptr(0)

	(*hostent)(unsafe.Pointer(h)).h_name = AssignPtrUintptr((*hostent)(unsafe.Pointer(h)).h_aliases, buf)
	Xstrcpy(tls, (*hostent)(unsafe.Pointer(h)).h_name, bp+1344)
	buf += uintptr(Xstrlen(tls, (*hostent)(unsafe.Pointer(h)).h_name) + uint64(1))

	if Xstrcmp(tls, (*hostent)(unsafe.Pointer(h)).h_name, name) != 0 {
		*(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_aliases + 1*8)) = buf
		Xstrcpy(tls, *(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_aliases + 1*8)), name)
		buf += uintptr(Xstrlen(tls, *(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_aliases + 1*8))) + uint64(1))
	} else {
		*(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_aliases + 1*8)) = uintptr(0)
	}

	*(*uintptr)(unsafe.Pointer((*hostent)(unsafe.Pointer(h)).h_aliases + 2*8)) = uintptr(0)

	*(*uintptr)(unsafe.Pointer(res)) = h
	return 0
}

func Xgethostbyname_r(tls *TLS, name uintptr, h uintptr, buf uintptr, buflen size_t, res uintptr, err uintptr) int32 { /* gethostbyname_r.c:6:5: */
	return Xgethostbyname2_r(tls, name, 2, h, buf, buflen, res, err)
}

type if_nameindex = struct {
	if_index uint32
	_        [4]byte
	if_name  uintptr
} /* if.h:12:1 */

type ifaddr = struct {
	ifa_addr struct {
		sa_family sa_family_t
		sa_data   [14]int8
	}
	ifa_ifu struct {
		ifu_broadaddr struct {
			sa_family sa_family_t
			sa_data   [14]int8
		}
	}
	ifa_ifp  uintptr
	ifa_next uintptr
} /* if.h:51:1 */

type ifmap = struct {
	mem_start uint64
	mem_end   uint64
	base_addr uint16
	irq       uint8
	dma       uint8
	port      uint8
	_         [3]byte
} /* if.h:64:1 */

type ifreq = struct {
	ifr_ifrn struct{ ifrn_name [16]int8 }
	ifr_ifru struct {
		_         [0]uint64
		ifru_addr struct {
			sa_family sa_family_t
			sa_data   [14]int8
		}
		_ [8]byte
	}
} /* if.h:76:1 */

type ifconf = struct {
	ifc_len  int32
	_        [4]byte
	ifc_ifcu struct{ ifcu_buf uintptr }
} /* if.h:116:1 */

type ns_sect = uint32 /* nameser.h:37:3 */

type __ns_msg = struct {
	_msg      uintptr
	_eom      uintptr
	_id       uint16_t
	_flags    uint16_t
	_counts   [4]uint16_t
	_         [4]byte
	_sections [4]uintptr
	_sect     ns_sect
	_rrnum    int32
	_msg_ptr  uintptr
} /* nameser.h:39:9 */

type ns_msg = __ns_msg /* nameser.h:46:3 */

type _ns_flagdata = struct {
	mask  int32
	shift int32
} /* nameser.h:48:1 */

type __ns_rr = struct {
	name     [1025]int8
	_        [1]byte
	__type   uint16_t
	rr_class uint16_t
	_        [2]byte
	ttl      uint32_t
	rdlength uint16_t
	_        [2]byte
	rdata    uintptr
} /* nameser.h:59:9 */

type ns_rr = __ns_rr /* nameser.h:66:3 */

type ns_flag = uint32 /* nameser.h:87:3 */

type ns_opcode = uint32 /* nameser.h:96:3 */

type ns_rcode = uint32 /* nameser.h:115:3 */

type ns_update_operation = uint32 /* nameser.h:121:3 */

type ns_tsig_key1 = struct {
	name [1025]int8
	alg  [1025]int8
	_    [6]byte
	data uintptr
	len  int32
	_    [4]byte
} /* nameser.h:123:1 */

type ns_tsig_key = ns_tsig_key1 /* nameser.h:128:28 */

type ns_tcp_tsig_state1 = struct {
	counter int32
	_       [4]byte
	key     uintptr
	ctx     uintptr
	sig     [512]uint8
	siglen  int32
	_       [4]byte
} /* nameser.h:130:1 */

type ns_tcp_tsig_state = ns_tcp_tsig_state1 /* nameser.h:137:34 */

type ns_type = uint32 /* nameser.h:200:3 */

type ns_class = uint32 /* nameser.h:219:3 */

type ns_key_types = uint32 /* nameser.h:226:3 */

type ns_cert_types = uint32 /* nameser.h:234:3 */

type HEADER = struct {
	_       [0]uint32
	id      uint32 /* unsigned id: 16, unsigned rd: 1, unsigned tc: 1, unsigned aa: 1, unsigned opcode: 4, unsigned qr: 1, unsigned rcode: 4, unsigned cd: 1, unsigned ad: 1, unsigned unused: 1, unsigned ra: 1 */
	qdcount uint32 /* unsigned qdcount: 16, unsigned ancount: 16 */
	nscount uint32 /* unsigned nscount: 16, unsigned arcount: 16 */
} /* nameser.h:353:3 */

// unused; purely for broken apps
type __res_state = struct {
	retrans     int32
	retry       int32
	options     uint64
	nscount     int32
	nsaddr_list [3]struct {
		sin_family sa_family_t
		sin_port   in_port_t
		sin_addr   struct{ s_addr in_addr_t }
		sin_zero   [8]uint8_t
	}
	id        uint16
	_         [2]byte
	dnsrch    [7]uintptr
	defdname  [256]int8
	pfcode    uint64
	ndots     uint32 /* unsigned ndots: 4, unsigned nsort: 4, unsigned ipv6_unavail: 1, unsigned unused: 23 */
	_         [4]byte
	sort_list [10]struct {
		addr struct{ s_addr in_addr_t }
		mask uint32_t
	}
	qhook       uintptr
	rhook       uintptr
	res_h_errno int32
	_vcsock     int32
	_flags      uint32
	_           [4]byte
	_u          struct {
		_   [0]uint64
		pad [52]int8
		_   [4]byte
	}
} /* resolv.h:26:9 */

// unused; purely for broken apps
type res_state = uintptr /* resolv.h:62:3 */

type res_sym = struct {
	number    int32
	_         [4]byte
	name      uintptr
	humanname uintptr
} /* resolv.h:70:1 */

func itoa(tls *TLS, p uintptr, x uint32) uintptr { /* getnameinfo.c:18:13: */
	p += uintptr(uint64(3) * uint64(unsafe.Sizeof(int32(0))))
	*(*int8)(unsafe.Pointer(PreDecUintptr(&p, 1))) = int8(0)
	for ok := true; ok; ok = x != 0 {
		*(*int8)(unsafe.Pointer(PreDecUintptr(&p, 1))) = int8(uint32('0') + x%uint32(10))
		x = x / uint32(10)
	}
	return p
}

func mkptr4(tls *TLS, s uintptr, ip uintptr) { /* getnameinfo.c:28:13: */
	bp := tls.Alloc(32)
	defer tls.Free(32)

	Xsprintf(tls, s, ts+25,
		VaList(bp, int32(*(*uint8)(unsafe.Pointer(ip + 3))), int32(*(*uint8)(unsafe.Pointer(ip + 2))), int32(*(*uint8)(unsafe.Pointer(ip + 1))), int32(*(*uint8)(unsafe.Pointer(ip)))))
}

func mkptr6(tls *TLS, s uintptr, ip uintptr) { /* getnameinfo.c:34:13: */
	var i int32
	for i = 15; i >= 0; i-- {
		*(*int8)(unsafe.Pointer(PostIncUintptr(&s, 1))) = _sxdigits[int32(*(*uint8)(unsafe.Pointer(ip + uintptr(i))))&15]
		*(*int8)(unsafe.Pointer(PostIncUintptr(&s, 1))) = int8('.')
		*(*int8)(unsafe.Pointer(PostIncUintptr(&s, 1))) = _sxdigits[int32(*(*uint8)(unsafe.Pointer(ip + uintptr(i))))>>4]
		*(*int8)(unsafe.Pointer(PostIncUintptr(&s, 1))) = int8('.')
	}
	Xstrcpy(tls, s, ts+50)
}

var _sxdigits = *(*[17]int8)(unsafe.Pointer(ts + 59)) /* getnameinfo.c:36:20 */

func reverse_hosts(tls *TLS, buf uintptr, a uintptr, scopeid uint32, family int32) { /* getnameinfo.c:45:13: */
	bp := tls.Alloc(556)
	defer tls.Free(556)

	// var line [512]int8 at bp+16, 512

	var p uintptr
	var z uintptr
	var _buf [1032]uint8
	_ = _buf
	// var atmp [16]uint8 at bp, 16

	// var iplit address at bp+528, 28

	//TODO FILE _f, *f = __fopen_rb_ca("/etc/hosts", &_f, _buf, sizeof _buf);
	var f uintptr = Xfopen(tls, ts+76, ts+87)
	if !(f != 0) {
		return
	}
	if family == 2 {
		Xmemcpy(tls, bp+uintptr(12), a, uint64(4))
		Xmemcpy(tls, bp, ts+90, uint64(12))
		a = bp /* &atmp[0] */
	}
	for Xfgets(tls, bp+16, int32(unsafe.Sizeof([512]int8{})), f) != 0 {
		if AssignUintptr(&p, Xstrchr(tls, bp+16, '#')) != 0 {
			*(*int8)(unsafe.Pointer(PostIncUintptr(&p, 1))) = int8('\n')
			*(*int8)(unsafe.Pointer(p)) = int8(0)
		}

		for p = bp + 16; /* &line[0] */ *(*int8)(unsafe.Pointer(p)) != 0 && !(__isspace(tls, int32(*(*int8)(unsafe.Pointer(p)))) != 0); p++ {
		}
		*(*int8)(unsafe.Pointer(PostIncUintptr(&p, 1))) = int8(0)
		if X__lookup_ipliteral(tls, bp+528, bp+16, 0) <= 0 {
			continue
		}

		if (*address)(unsafe.Pointer(bp+528)).family == 2 {
			Xmemcpy(tls, bp+528+8+uintptr(12), bp+528+8, uint64(4))
			Xmemcpy(tls, bp+528+8, ts+90, uint64(12))
			(*address)(unsafe.Pointer(bp + 528 /* &iplit */)).scopeid = uint32(0)
		}

		if Xmemcmp(tls, a, bp+528+8, uint64(16)) != 0 || (*address)(unsafe.Pointer(bp+528)).scopeid != scopeid {
			continue
		}

		for ; *(*int8)(unsafe.Pointer(p)) != 0 && __isspace(tls, int32(*(*int8)(unsafe.Pointer(p)))) != 0; p++ {
		}
		for z = p; *(*int8)(unsafe.Pointer(z)) != 0 && !(__isspace(tls, int32(*(*int8)(unsafe.Pointer(z)))) != 0); z++ {
		}
		*(*int8)(unsafe.Pointer(z)) = int8(0)
		if (int64(z)-int64(p))/1 < int64(256) {
			Xmemcpy(tls, buf, p, uint64((int64(z)-int64(p))/1+int64(1)))
			break
		}
	}
	//TODO __fclose_ca(f);
	Xfclose(tls, f)
}

func reverse_services(tls *TLS, buf uintptr, port int32, dgram int32) { /* getnameinfo.c:87:13: */
	Xabort(tls) //TODO-
	// unsigned long svport;
	// char line[128], *p, *z;
	// unsigned char _buf[1032];
	// FILE _f, *f = __fopen_rb_ca("/etc/services", &_f, _buf, sizeof _buf);
	// if (!f) return;
	// while (fgets(line, sizeof line, f)) {
	// 	if ((p=strchr(line, '#'))) *p++='\n', *p=0;

	// 	for (p=line; *p && !isspace(*p); p++);
	// 	if (!*p) continue;
	// 	*p++ = 0;
	// 	svport = strtoul(p, &z, 10);

	// 	if (svport != port || z==p) continue;
	// 	if (dgram && strncmp(z, "/udp", 4)) continue;
	// 	if (!dgram && strncmp(z, "/tcp", 4)) continue;
	// 	if (p-line > 32) continue;

	// 	memcpy(buf, line, p-line);
	// 	break;
	// }
	// __fclose_ca(f);
}

func Xgetnameinfo(tls *TLS, sa1 uintptr, sl socklen_t, node uintptr, nodelen socklen_t, serv uintptr, servlen socklen_t, flags int32) int32 { /* getnameinfo.c:125:5: */
	bp := tls.Alloc(347)
	defer tls.Free(347)

	// var ptr [78]int8 at bp, 78

	// var buf [256]int8 at bp+78, 256

	// var num [13]int8 at bp+334, 13

	var af int32 = int32((*sockaddr)(unsafe.Pointer(sa1)).sa_family)
	var a uintptr
	var scopeid uint32

	switch af {
	case 2:
		a = sa1 + 4
		if uint64(sl) < uint64(unsafe.Sizeof(sockaddr_in{})) {
			return -6
		}
		mkptr4(tls, bp, a)
		scopeid = uint32(0)
		break
	case 10:
		a = sa1 + 8
		if uint64(sl) < uint64(unsafe.Sizeof(sockaddr_in6{})) {
			return -6
		}
		if Xmemcmp(tls, a, ts+90, uint64(12)) != 0 {
			mkptr6(tls, bp, a)
		} else {
			mkptr4(tls, bp, a+uintptr(12))
		}
		scopeid = (*sockaddr_in6)(unsafe.Pointer(sa1)).sin6_scope_id
		break
	default:
		return -6
	}

	if node != 0 && nodelen != 0 {
		*(*int8)(unsafe.Pointer(bp + 78)) = int8(0)
		if !(flags&0x01 != 0) {
			reverse_hosts(tls, bp+78, a, scopeid, af)
		}
		if !(int32(*(*int8)(unsafe.Pointer(bp + 78))) != 0) && !(flags&0x01 != 0) {
			Xabort(tls) //TODO-
			// unsigned char query[18+PTR_MAX], reply[512];
			// int qlen = __res_mkquery(0, ptr, 1, RR_PTR,
			// 	0, 0, 0, query, sizeof query);
			// query[3] = 0; /* don't need AD flag */
			// int rlen = __res_send(query, qlen, reply, sizeof reply);
			// buf[0] = 0;
			// if (rlen > 0)
			// 	__dns_parse(reply, rlen, dns_parse_callback, buf);
		}
		if !(int32(*(*int8)(unsafe.Pointer(bp + 78))) != 0) {
			if flags&0x08 != 0 {
				return -2
			}
			Xinet_ntop(tls, af, a, bp+78, uint32(unsafe.Sizeof([256]int8{})))
			if scopeid != 0 {
				Xabort(tls) //TODO-
				// char *p = 0, tmp[IF_NAMESIZE+1];
				// if (!(flags & NI_NUMERICSCOPE) &&
				//     (IN6_IS_ADDR_LINKLOCAL(a) ||
				//      IN6_IS_ADDR_MC_LINKLOCAL(a)))
				// 	p = if_indextoname(scopeid, tmp+1);
				// if (!p)
				// 	p = itoa(num, scopeid);
				// *--p = '%';
				// strcat(buf, p);
			}
		}
		if Xstrlen(tls, bp+78) >= size_t(nodelen) {
			return -12
		}
		Xstrcpy(tls, node, bp+78)
	}

	if serv != 0 && servlen != 0 {
		var p uintptr = bp + 78 /* buf */
		var port int32 = int32(Xntohs(tls, (*sockaddr_in)(unsafe.Pointer(sa1)).sin_port))
		*(*int8)(unsafe.Pointer(bp + 78)) = int8(0)
		if !(flags&0x02 != 0) {
			reverse_services(tls, bp+78, port, flags&0x10)
		}
		if !(int32(*(*int8)(unsafe.Pointer(p))) != 0) {
			p = itoa(tls, bp+334, uint32(port))
		}
		if Xstrlen(tls, p) >= size_t(servlen) {
			return -12
		}
		Xstrcpy(tls, serv, p)
	}

	return 0
}

var Xh_errno int32 /* h_errno.c:4:5: */

func X__h_errno_location(tls *TLS) uintptr { /* h_errno.c:6:5: */
	return uintptr(unsafe.Pointer(&Xh_errno))
}

func X__inet_aton(tls *TLS, s0 uintptr, dest uintptr) int32 { /* inet_aton.c:7:5: */
	bp := tls.Alloc(40)
	defer tls.Free(40)

	var s uintptr = s0
	var d uintptr = dest
	*(*[4]uint64)(unsafe.Pointer(bp /* a */)) = [4]uint64{0: uint64(0)}
	// var z uintptr at bp+32, 8

	var i int32

	for i = 0; i < 4; i++ {
		*(*uint64)(unsafe.Pointer(bp + uintptr(i)*8)) = Xstrtoul(tls, s, bp+32, 0)
		if *(*uintptr)(unsafe.Pointer(bp + 32)) == s || *(*int8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(bp + 32)))) != 0 && int32(*(*int8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(bp + 32))))) != '.' || !(func() int32 {
			if 0 != 0 {
				return Xisdigit(tls, int32(*(*int8)(unsafe.Pointer(s))))
			}
			return Bool32(uint32(*(*int8)(unsafe.Pointer(s)))-uint32('0') < uint32(10))
		}() != 0) {
			return 0
		}
		if !(int32(*(*int8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(bp + 32))))) != 0) {
			break
		}
		s = *(*uintptr)(unsafe.Pointer(bp + 32)) + uintptr(1)
	}
	if i == 4 {
		return 0
	}
	switch i {
	case 0:
		*(*uint64)(unsafe.Pointer(bp + 1*8)) = *(*uint64)(unsafe.Pointer(bp)) & uint64(0xffffff)
		AssignShrPtrUint64(bp, int(24))
		fallthrough
	case 1:
		*(*uint64)(unsafe.Pointer(bp + 2*8)) = *(*uint64)(unsafe.Pointer(bp + 1*8)) & uint64(0xffff)
		AssignShrPtrUint64(bp+1*8, int(16))
		fallthrough
	case 2:
		*(*uint64)(unsafe.Pointer(bp + 3*8)) = *(*uint64)(unsafe.Pointer(bp + 2*8)) & uint64(0xff)
		AssignShrPtrUint64(bp+2*8, int(8))
	}
	for i = 0; i < 4; i++ {
		if *(*uint64)(unsafe.Pointer(bp + uintptr(i)*8)) > uint64(255) {
			return 0
		}
		*(*uint8)(unsafe.Pointer(d + uintptr(i))) = uint8(*(*uint64)(unsafe.Pointer(bp + uintptr(i)*8)))
	}
	return 1
}

func Xinet_ntop(tls *TLS, af int32, a0 uintptr, s uintptr, l socklen_t) uintptr { /* inet_ntop.c:7:12: */
	bp := tls.Alloc(276)
	defer tls.Free(276)

	var a uintptr = a0
	var i int32
	var j int32
	var max int32
	var best int32
	// var buf [100]int8 at bp+176, 100

	switch af {
	case 2:
		if socklen_t(Xsnprintf(tls, s, uint64(l), ts+103, VaList(bp, int32(*(*uint8)(unsafe.Pointer(a))), int32(*(*uint8)(unsafe.Pointer(a + 1))), int32(*(*uint8)(unsafe.Pointer(a + 2))), int32(*(*uint8)(unsafe.Pointer(a + 3)))))) < l {
			return s
		}
		break
	case 10:
		if Xmemcmp(tls, a, ts+90, uint64(12)) != 0 {
			Xsnprintf(tls, bp+176, uint64(unsafe.Sizeof([100]int8{})),
				ts+115,
				VaList(bp+32, 256*int32(*(*uint8)(unsafe.Pointer(a)))+int32(*(*uint8)(unsafe.Pointer(a + 1))), 256*int32(*(*uint8)(unsafe.Pointer(a + 2)))+int32(*(*uint8)(unsafe.Pointer(a + 3))),
					256*int32(*(*uint8)(unsafe.Pointer(a + 4)))+int32(*(*uint8)(unsafe.Pointer(a + 5))), 256*int32(*(*uint8)(unsafe.Pointer(a + 6)))+int32(*(*uint8)(unsafe.Pointer(a + 7))),
					256*int32(*(*uint8)(unsafe.Pointer(a + 8)))+int32(*(*uint8)(unsafe.Pointer(a + 9))), 256*int32(*(*uint8)(unsafe.Pointer(a + 10)))+int32(*(*uint8)(unsafe.Pointer(a + 11))),
					256*int32(*(*uint8)(unsafe.Pointer(a + 12)))+int32(*(*uint8)(unsafe.Pointer(a + 13))), 256*int32(*(*uint8)(unsafe.Pointer(a + 14)))+int32(*(*uint8)(unsafe.Pointer(a + 15)))))
		} else {
			Xsnprintf(tls, bp+176, uint64(unsafe.Sizeof([100]int8{})),
				ts+139,
				VaList(bp+96, 256*int32(*(*uint8)(unsafe.Pointer(a)))+int32(*(*uint8)(unsafe.Pointer(a + 1))), 256*int32(*(*uint8)(unsafe.Pointer(a + 2)))+int32(*(*uint8)(unsafe.Pointer(a + 3))),
					256*int32(*(*uint8)(unsafe.Pointer(a + 4)))+int32(*(*uint8)(unsafe.Pointer(a + 5))), 256*int32(*(*uint8)(unsafe.Pointer(a + 6)))+int32(*(*uint8)(unsafe.Pointer(a + 7))),
					256*int32(*(*uint8)(unsafe.Pointer(a + 8)))+int32(*(*uint8)(unsafe.Pointer(a + 9))), 256*int32(*(*uint8)(unsafe.Pointer(a + 10)))+int32(*(*uint8)(unsafe.Pointer(a + 11))),
					int32(*(*uint8)(unsafe.Pointer(a + 12))), int32(*(*uint8)(unsafe.Pointer(a + 13))), int32(*(*uint8)(unsafe.Pointer(a + 14))), int32(*(*uint8)(unsafe.Pointer(a + 15)))))
		}
		// Replace longest /(^0|:)[:0]{2,}/ with "::"
		i = AssignInt32(&best, 0)
		max = 2
		for ; *(*int8)(unsafe.Pointer(bp + 176 + uintptr(i))) != 0; i++ {
			if i != 0 && int32(*(*int8)(unsafe.Pointer(bp + 176 + uintptr(i)))) != ':' {
				continue
			}
			j = int32(Xstrspn(tls, bp+176+uintptr(i), ts+169))
			if j > max {
				best = i
				max = j
			}
		}
		if max > 3 {
			*(*int8)(unsafe.Pointer(bp + 176 + uintptr(best))) = AssignPtrInt8(bp+176+uintptr(best+1), int8(':'))
			Xmemmove(tls, bp+176+uintptr(best)+uintptr(2), bp+176+uintptr(best)+uintptr(max), uint64(i-best-max+1))
		}
		if Xstrlen(tls, bp+176) < size_t(l) {
			Xstrcpy(tls, s, bp+176)
			return s
		}
		break
	default:
		*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 97
		return uintptr(0)
	}
	*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 28
	return uintptr(0)
}

func hexval(tls *TLS, c uint32) int32 { /* inet_pton.c:7:12: */
	if c-uint32('0') < uint32(10) {
		return int32(c - uint32('0'))
	}
	c = c | uint32(32)
	if c-uint32('a') < uint32(6) {
		return int32(c - uint32('a') + uint32(10))
	}
	return -1
}

func Xinet_pton(tls *TLS, af int32, s uintptr, a0 uintptr) int32 { /* inet_pton.c:15:5: */
	bp := tls.Alloc(16)
	defer tls.Free(16)

	// var ip [8]uint16_t at bp, 16

	var a uintptr = a0
	var i int32
	var j int32
	var v int32
	var d int32
	var brk int32 = -1
	var need_v4 int32 = 0

	if af == 2 {
		for i = 0; i < 4; i++ {
			for v = AssignInt32(&j, 0); j < 3 && func() int32 {
				if 0 != 0 {
					return Xisdigit(tls, int32(*(*int8)(unsafe.Pointer(s + uintptr(j)))))
				}
				return Bool32(uint32(*(*int8)(unsafe.Pointer(s + uintptr(j))))-uint32('0') < uint32(10))
			}() != 0; j++ {
				v = 10*v + int32(*(*int8)(unsafe.Pointer(s + uintptr(j)))) - '0'
			}
			if j == 0 || j > 1 && int32(*(*int8)(unsafe.Pointer(s))) == '0' || v > 255 {
				return 0
			}
			*(*uint8)(unsafe.Pointer(a + uintptr(i))) = uint8(v)
			if int32(*(*int8)(unsafe.Pointer(s + uintptr(j)))) == 0 && i == 3 {
				return 1
			}
			if int32(*(*int8)(unsafe.Pointer(s + uintptr(j)))) != '.' {
				return 0
			}
			s += uintptr(j + 1)
		}
		return 0
	} else if af != 10 {
		*(*int32)(unsafe.Pointer(X___errno_location(tls))) = 97
		return -1
	}

	if int32(*(*int8)(unsafe.Pointer(s))) == ':' && int32(*(*int8)(unsafe.Pointer(PreIncUintptr(&s, 1)))) != ':' {
		return 0
	}

	for i = 0; ; i++ {
		if int32(*(*int8)(unsafe.Pointer(s))) == ':' && brk < 0 {
			brk = i
			*(*uint16_t)(unsafe.Pointer(bp + uintptr(i&7)*2)) = uint16_t(0)
			if !(int32(*(*int8)(unsafe.Pointer(PreIncUintptr(&s, 1)))) != 0) {
				break
			}
			if i == 7 {
				return 0
			}
			continue
		}
		for v = AssignInt32(&j, 0); j < 4 && AssignInt32(&d, hexval(tls, uint32(*(*int8)(unsafe.Pointer(s + uintptr(j)))))) >= 0; j++ {
			v = 16*v + d
		}
		if j == 0 {
			return 0
		}
		*(*uint16_t)(unsafe.Pointer(bp + uintptr(i&7)*2)) = uint16_t(v)
		if !(int32(*(*int8)(unsafe.Pointer(s + uintptr(j)))) != 0) && (brk >= 0 || i == 7) {
			break
		}
		if i == 7 {
			return 0
		}
		if int32(*(*int8)(unsafe.Pointer(s + uintptr(j)))) != ':' {
			if int32(*(*int8)(unsafe.Pointer(s + uintptr(j)))) != '.' || i < 6 && brk < 0 {
				return 0
			}
			need_v4 = 1
			i++
			break
		}
		s += uintptr(j + 1)
	}
	if brk >= 0 {
		Xmemmove(tls, bp+uintptr(brk)*2+uintptr(7)*2-uintptr(i)*2, bp+uintptr(brk)*2, uint64(2*(i+1-brk)))
		for j = 0; j < 7-i; j++ {
			*(*uint16_t)(unsafe.Pointer(bp + uintptr(brk+j)*2)) = uint16_t(0)
		}
	}
	for j = 0; j < 8; j++ {
		*(*uint8)(unsafe.Pointer(PostIncUintptr(&a, 1))) = uint8(int32(*(*uint16_t)(unsafe.Pointer(bp + uintptr(j)*2))) >> 8)
		*(*uint8)(unsafe.Pointer(PostIncUintptr(&a, 1))) = uint8(*(*uint16_t)(unsafe.Pointer(bp + uintptr(j)*2)))
	}
	if need_v4 != 0 && Xinet_pton(tls, 2, s, a-uintptr(4)) <= 0 {
		return 0
	}
	return 1
}

func X__lookup_ipliteral(tls *TLS, buf uintptr, name uintptr, family int32) int32 { /* lookup_ipliteral.c:12:5: */
	bp := tls.Alloc(96)
	defer tls.Free(96)

	// var a4 in_addr at bp, 4

	// var a6 in6_addr at bp+68, 16

	if X__inet_aton(tls, name, bp) > 0 {
		if family == 10 { // wrong family
			return -2
		}
		Xmemcpy(tls, buf+8, bp, uint64(unsafe.Sizeof(in_addr{})))
		(*address)(unsafe.Pointer(buf)).family = 2
		(*address)(unsafe.Pointer(buf)).scopeid = uint32(0)
		return 1
	}
	// var tmp [64]int8 at bp+4, 64

	var p uintptr = Xstrchr(tls, name, '%')
	// var z uintptr at bp+88, 8

	var scopeid uint64 = uint64(0)
	if p != 0 && (int64(p)-int64(name))/1 < int64(64) {
		Xmemcpy(tls, bp+4, name, uint64((int64(p)-int64(name))/1))
		*(*int8)(unsafe.Pointer(bp + 4 + uintptr((int64(p)-int64(name))/1))) = int8(0)
		name = bp + 4 /* &tmp[0] */
	}

	if Xinet_pton(tls, 10, name, bp+68) <= 0 {
		return 0
	}
	if family == 2 { // wrong family
		return -2
	}

	Xmemcpy(tls, buf+8, bp+68, uint64(unsafe.Sizeof(in6_addr{})))
	(*address)(unsafe.Pointer(buf)).family = 10
	if p != 0 {
		if func() int32 {
			if 0 != 0 {
				return Xisdigit(tls, int32(*(*int8)(unsafe.Pointer(PreIncUintptr(&p, 1)))))
			}
			return Bool32(uint32(*(*int8)(unsafe.Pointer(PreIncUintptr(&p, 1))))-uint32('0') < uint32(10))
		}() != 0 {
			scopeid = Xstrtoull(tls, p, bp+88, 10)
		} else {
			*(*uintptr)(unsafe.Pointer(bp + 88 /* z */)) = p - uintptr(1)
		}
		if *(*int8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(bp + 88)))) != 0 {
			Xabort(tls) //TODO-
			// if (!IN6_IS_ADDR_LINKLOCAL(&a6) &&
			//     !IN6_IS_ADDR_MC_LINKLOCAL(&a6))
			// 	return EAI_NONAME;
			// scopeid = if_nametoindex(p);
			// if (!scopeid) return EAI_NONAME;
		}
		if scopeid > uint64(0xffffffff) {
			return -2
		}
	}
	(*address)(unsafe.Pointer(buf)).scopeid = uint32(scopeid)
	return 1
}

func is_valid_hostname(tls *TLS, host uintptr) int32 { /* lookup_name.c:18:12: */
	var s uintptr
	//TODO if (strnlen(host, 255)-1 >= 254 || mbstowcs(0, host, 0) == -1) return 0;
	if Xstrnlen(tls, host, uint64(255))-uint64(1) >= uint64(254) {
		return 0
	}
	for s = host; int32(*(*uint8)(unsafe.Pointer(s))) >= 0x80 || int32(*(*uint8)(unsafe.Pointer(s))) == '.' || int32(*(*uint8)(unsafe.Pointer(s))) == '-' || Xisalnum(tls, int32(*(*uint8)(unsafe.Pointer(s)))) != 0; s++ {
	}
	return BoolInt32(!(*(*uint8)(unsafe.Pointer(s)) != 0))
}

var Xzero_struct_address address /* lookup_name.c:27:16: */

func name_from_null(tls *TLS, buf uintptr, name uintptr, family int32, flags int32) int32 { /* lookup_name.c:29:12: */
	var cnt int32 = 0
	if name != 0 {
		return 0
	}
	if flags&0x01 != 0 {
		//TODO if (family != AF_INET6)
		//TODO 	buf[cnt++] = (struct address){ .family = AF_INET };
		if family != 10 {
			var x = Xzero_struct_address
			x.family = 2
			*(*address)(unsafe.Pointer(buf + uintptr(PostIncInt32(&cnt, 1))*28)) = x
		}
		//TODO if (family != AF_INET)
		//TODO 	buf[cnt++] = (struct address){ .family = AF_INET6 };
		if family != 2 {
			var x = Xzero_struct_address
			x.family = 10
			*(*address)(unsafe.Pointer(buf + uintptr(PostIncInt32(&cnt, 1))*28)) = x
		}
	} else {
		Xabort(tls) //TODO-
		// 	if (family != AF_INET6)
		// 		buf[cnt++] = (struct address){ .family = AF_INET, .addr = { 127,0,0,1 } };
		// 	if (family != AF_INET)
		// 		buf[cnt++] = (struct address){ .family = AF_INET6, .addr = { [15] = 1 } };
	}
	return cnt
}

func name_from_numeric(tls *TLS, buf uintptr, name uintptr, family int32) int32 { /* lookup_name.c:58:12: */
	return X__lookup_ipliteral(tls, buf, name, family)
}

func name_from_hosts(tls *TLS, buf uintptr, canon uintptr, name uintptr, family int32) int32 { /* lookup_name.c:63:12: */
	bp := tls.Alloc(512)
	defer tls.Free(512)

	// var line [512]int8 at bp, 512

	var l size_t = Xstrlen(tls, name)
	var cnt int32 = 0
	var badfam int32 = 0
	var _buf [1032]uint8
	_ = _buf
	//TODO FILE _f, *f = __fopen_rb_ca("/etc/hosts", &_f, _buf, sizeof _buf);
	var _f FILE
	_ = _f
	var f uintptr = Xfopen(tls, ts+76, ts+87)
	if !(f != 0) {
		switch *(*int32)(unsafe.Pointer(X___errno_location(tls))) {
		case 2:
			fallthrough
		case 20:
			fallthrough
		case 13:
			return 0
			fallthrough
		default:
			return -11
		}
	}
	for Xfgets(tls, bp, int32(unsafe.Sizeof([512]int8{})), f) != 0 && cnt < 48 {
		var p uintptr
		var z uintptr

		if AssignUintptr(&p, Xstrchr(tls, bp, '#')) != 0 {
			*(*int8)(unsafe.Pointer(PostIncUintptr(&p, 1))) = int8('\n')
			*(*int8)(unsafe.Pointer(p)) = int8(0)
		}
		for p = bp + uintptr(1); AssignUintptr(&p, Xstrstr(tls, p, name)) != 0 && (!(__isspace(tls, int32(*(*int8)(unsafe.Pointer(p + UintptrFromInt32(-1))))) != 0) || !(__isspace(tls, int32(*(*int8)(unsafe.Pointer(p + uintptr(l))))) != 0)); p++ {
		}
		if !(p != 0) {
			continue
		}

		// Isolate IP address to parse
		for p = bp; /* &line[0] */ *(*int8)(unsafe.Pointer(p)) != 0 && !(__isspace(tls, int32(*(*int8)(unsafe.Pointer(p)))) != 0); p++ {
		}
		*(*int8)(unsafe.Pointer(PostIncUintptr(&p, 1))) = int8(0)
		switch name_from_numeric(tls, buf+uintptr(cnt)*28, bp, family) {
		case 1:
			cnt++
			break
		case 0:
			continue
		default:
			badfam = -2
			continue
		}

		// Extract first name as canonical name
		for ; *(*int8)(unsafe.Pointer(p)) != 0 && __isspace(tls, int32(*(*int8)(unsafe.Pointer(p)))) != 0; p++ {
		}
		for z = p; *(*int8)(unsafe.Pointer(z)) != 0 && !(__isspace(tls, int32(*(*int8)(unsafe.Pointer(z)))) != 0); z++ {
		}
		*(*int8)(unsafe.Pointer(z)) = int8(0)
		if is_valid_hostname(tls, p) != 0 {
			Xmemcpy(tls, canon, p, uint64((int64(z)-int64(p))/1+int64(1)))
		}
	}
	//TODO __fclose_ca(f);
	Xfclose(tls, f)
	if cnt != 0 {
		return cnt
	}
	return badfam
}

type dpc_ctx = struct {
	addrs uintptr
	canon uintptr
	cnt   int32
	_     [4]byte
} /* lookup_name.c:112:1 */

func name_from_dns_search(tls *TLS, buf uintptr, canon uintptr, name uintptr, family int32) int32 { /* lookup_name.c:191:12: */
	return -1 //TODO-
	Xabort(tls)
	return int32(0) //TODO-
	// char search[256];
	// struct resolvconf conf;
	// size_t l, dots;
	// char *p, *z;

	// if (__get_resolv_conf(&conf, search, sizeof search) < 0) return -1;

	// /* Count dots, suppress search when >=ndots or name ends in
	//  * a dot, which is an explicit request for global scope. */
	// for (dots=l=0; name[l]; l++) if (name[l]=='.') dots++;
	// if (dots >= conf.ndots || name[l-1]=='.') *search = 0;

	// /* Strip final dot for canon, fail if multiple trailing dots. */
	// if (name[l-1]=='.') l--;
	// if (!l || name[l-1]=='.') return EAI_NONAME;

	// /* This can never happen; the caller already checked length. */
	// if (l >= 256) return EAI_NONAME;

	// /* Name with search domain appended is setup in canon[]. This both
	//  * provides the desired default canonical name (if the requested
	//  * name is not a CNAME record) and serves as a buffer for passing
	//  * the full requested name to name_from_dns. */
	// memcpy(canon, name, l);
	// canon[l] = '.';

	// for (p=search; *p; p=z) {
	// 	for (; isspace(*p); p++);
	// 	for (z=p; *z && !isspace(*z); z++);
	// 	if (z==p) break;
	// 	if (z-p < 256 - l - 1) {
	// 		memcpy(canon+l+1, p, z-p);
	// 		canon[z-p+1+l] = 0;
	// 		int cnt = name_from_dns(buf, canon, canon, family, &conf);
	// 		if (cnt) return cnt;
	// 	}
	// }

	// canon[l] = 0;
	// return name_from_dns(buf, canon, name, family, &conf);
}

type policy = struct {
	addr  [16]uint8
	len   uint8
	mask  uint8
	prec  uint8
	label uint8
} /* lookup_name.c:237:14 */

var defpolicy = [6]policy{
	{addr: *(*[16]uint8)(unsafe.Pointer(ts + 172)), len: uint8(15), mask: uint8(0xff), prec: uint8(50)},
	{addr: *(*[16]uint8)(unsafe.Pointer(ts + 189)), len: uint8(11), mask: uint8(0xff), prec: uint8(35), label: uint8(4)},
	{addr: *(*[16]uint8)(unsafe.Pointer(ts + 205)), len: uint8(1), mask: uint8(0xff), prec: uint8(30), label: uint8(2)},
	{addr: *(*[16]uint8)(unsafe.Pointer(ts + 221)), len: uint8(3), mask: uint8(0xff), prec: uint8(5), label: uint8(5)},
	{addr: *(*[16]uint8)(unsafe.Pointer(ts + 237)), mask: uint8(0xfe), prec: uint8(3), label: uint8(13)},
	// Last rule must match all addresses to stop loop.
	{addr: *(*[16]uint8)(unsafe.Pointer(ts + 253)), prec: uint8(40), label: uint8(1)},
} /* lookup_name.c:241:3 */

func policyof(tls *TLS, a uintptr) uintptr { /* lookup_name.c:259:28: */
	var i int32
	for i = 0; ; i++ {
		if Xmemcmp(tls, a, uintptr(unsafe.Pointer(&defpolicy))+uintptr(i)*20, uint64(defpolicy[i].len)) != 0 {
			continue
		}
		if int32(*(*uint8_t)(unsafe.Pointer(a + uintptr(defpolicy[i].len))))&int32(defpolicy[i].mask) !=
			int32(*(*uint8)(unsafe.Pointer(uintptr(unsafe.Pointer(&defpolicy)) + uintptr(i)*20 + uintptr(defpolicy[i].len)))) {
			continue
		}
		return uintptr(unsafe.Pointer(&defpolicy)) + uintptr(i)*20
	}
	return uintptr(0)
}

func labelof(tls *TLS, a uintptr) int32 { /* lookup_name.c:272:12: */
	return int32((*policy)(unsafe.Pointer(policyof(tls, a))).label)
}

func scopeof(tls *TLS, a uintptr) int32 { /* lookup_name.c:277:12: */
	if int32(*(*uint8_t)(unsafe.Pointer(a))) == 0xff {
		return int32(*(*uint8_t)(unsafe.Pointer(a + 1))) & 15
	}
	if int32(*(*uint8_t)(unsafe.Pointer(a))) == 0xfe && int32(*(*uint8_t)(unsafe.Pointer(a + 1)))&0xc0 == 0x80 {
		return 2
	}
	if *(*uint32_t)(unsafe.Pointer(a)) == uint32_t(0) && *(*uint32_t)(unsafe.Pointer(a + 1*4)) == uint32_t(0) && *(*uint32_t)(unsafe.Pointer(a + 2*4)) == uint32_t(0) && int32(*(*uint8_t)(unsafe.Pointer(a + 12))) == 0 && int32(*(*uint8_t)(unsafe.Pointer(a + 13))) == 0 && int32(*(*uint8_t)(unsafe.Pointer(a + 14))) == 0 && int32(*(*uint8_t)(unsafe.Pointer(a + 15))) == 1 {
		return 2
	}
	if int32(*(*uint8_t)(unsafe.Pointer(a))) == 0xfe && int32(*(*uint8_t)(unsafe.Pointer(a + 1)))&0xc0 == 0xc0 {
		return 5
	}
	return 14
}

func prefixmatch(tls *TLS, s uintptr, d uintptr) int32 { /* lookup_name.c:286:12: */
	// FIXME: The common prefix length should be limited to no greater
	// than the nominal length of the prefix portion of the source
	// address. However the definition of the source prefix length is
	// not clear and thus this limiting is not yet implemented.
	var i uint32
	for i = uint32(0); i < uint32(128) && !((int32(*(*uint8_t)(unsafe.Pointer(s /* &.__in6_union */ /* &.__s6_addr */ + uintptr(i/uint32(8)))))^int32(*(*uint8_t)(unsafe.Pointer(d /* &.__in6_union */ /* &.__s6_addr */ + uintptr(i/uint32(8))))))&(int32(128)>>(i%uint32(8))) != 0); i++ {
	}
	return int32(i)
}

func addrcmp(tls *TLS, _a uintptr, _b uintptr) int32 { /* lookup_name.c:305:12: */
	var a uintptr = _a
	var b uintptr = _b
	return (*address)(unsafe.Pointer(b)).sortkey - (*address)(unsafe.Pointer(a)).sortkey
}

func X__lookup_name(tls *TLS, buf uintptr, canon uintptr, name uintptr, family int32, flags int32) int32 { /* lookup_name.c:311:5: */
	bp := tls.Alloc(92)
	defer tls.Free(92)

	var cnt int32 = 0
	var i int32
	var j int32
	_ = j

	*(*int8)(unsafe.Pointer(canon)) = int8(0)
	if name != 0 {
		// reject empty name and check len so it fits into temp bufs
		var l size_t = Xstrnlen(tls, name, uint64(255))
		if l-uint64(1) >= uint64(254) {
			return -2
		}
		Xmemcpy(tls, canon, name, l+uint64(1))
	}

	// Procedurally, a request for v6 addresses with the v4-mapped
	// flag set is like a request for unspecified family, followed
	// by filtering of the results.
	if flags&0x08 != 0 {
		if family == 10 {
			family = 0
		} else {
			flags = flags - 0x08
		}
	}

	// Try each backend until there's at least one result.
	cnt = name_from_null(tls, buf, name, family, flags)
	if !(cnt != 0) {
		cnt = name_from_numeric(tls, buf, name, family)
	}
	if !(cnt != 0) && !(flags&0x04 != 0) {
		cnt = name_from_hosts(tls, buf, canon, name, family)
		if !(cnt != 0) {
			cnt = name_from_dns_search(tls, buf, canon, name, family)
		}
	}
	if cnt <= 0 {
		if cnt != 0 {
			return cnt
		}
		return -2
	}

	// Filter/transform results for v4-mapped lookup, if requested.
	if flags&0x08 != 0 {
		Xabort(tls) //TODO-
		// 	if (!(flags & AI_ALL)) {
		// 		/* If any v6 results exist, remove v4 results. */
		// 		for (i=0; i<cnt && buf[i].family != AF_INET6; i++);
		// 		if (i<cnt) {
		// 			for (j=0; i<cnt; i++) {
		// 				if (buf[i].family == AF_INET6)
		// 					buf[j++] = buf[i];
		// 			}
		// 			cnt = i = j;
		// 		}
		// 	}
		// 	/* Translate any remaining v4 results to v6 */
		// 	for (i=0; i<cnt; i++) {
		// 		if (buf[i].family != AF_INET) continue;
		// 		memcpy(buf[i].addr+12, buf[i].addr, 4);
		// 		memcpy(buf[i].addr, "\0\0\0\0\0\0\0\0\0\0\xff\xff", 12);
		// 		buf[i].family = AF_INET6;
		// 	}
	}

	// No further processing is needed if there are fewer than 2
	// results or if there are only IPv4 results.
	if cnt < 2 || family == 2 {
		return cnt
	}
	for i = 0; i < cnt; i++ {
		if (*address)(unsafe.Pointer(buf+uintptr(i)*28)).family != 2 {
			break
		}
	}
	if i == cnt {
		return cnt
	}
	var cs int32
	_ = cs
	//TODO pthread_setcancelstate(PTHREAD_CANCEL_DISABLE, &cs);

	// The following implements a subset of RFC 3484/6724 destination
	// address selection by generating a single 31-bit sort key for
	// each address. Rules 3, 4, and 7 are omitted for having
	// excessive runtime and code size cost and dubious benefit.
	// So far the label/precedence table cannot be customized.
	for i = 0; i < cnt; i++ {
		var family int32 = (*address)(unsafe.Pointer(buf + uintptr(i)*28)).family
		var key int32 = 0
		*(*sockaddr_in6)(unsafe.Pointer(bp + 28 /* sa6 */)) = sockaddr_in6{}
		*(*sockaddr_in6)(unsafe.Pointer(bp /* da6 */)) = sockaddr_in6{sin6_family: sa_family_t(10), sin6_port: in_port_t(65535), sin6_scope_id: (*address)(unsafe.Pointer(buf + uintptr(i)*28)).scopeid}
		*(*sockaddr_in)(unsafe.Pointer(bp + 72 /* sa4 */)) = sockaddr_in{}
		*(*sockaddr_in)(unsafe.Pointer(bp + 56 /* da4 */)) = sockaddr_in{sin_family: sa_family_t(2), sin_port: in_port_t(65535)}
		var sa1 uintptr
		var da uintptr
		// var salen socklen_t at bp+88, 4

		var dalen socklen_t
		if family == 10 {
			Xmemcpy(tls, bp+8, buf+uintptr(i)*28+8, uint64(16))
			da = bp /* &da6 */
			dalen = socklen_t(unsafe.Sizeof(sockaddr_in6{}))
			sa1 = bp + 28 /* &sa6 */
			*(*socklen_t)(unsafe.Pointer(bp + 88 /* salen */)) = socklen_t(unsafe.Sizeof(sockaddr_in6{}))
		} else {
			Xmemcpy(tls, bp+28+8,
				ts+90, uint64(12))
			Xmemcpy(tls, bp+8+uintptr(12), buf+uintptr(i)*28+8, uint64(4))
			Xmemcpy(tls, bp+8,
				ts+90, uint64(12))
			Xmemcpy(tls, bp+8+uintptr(12), buf+uintptr(i)*28+8, uint64(4))
			Xmemcpy(tls, bp+56+4, buf+uintptr(i)*28+8, uint64(4))
			da = bp + 56 /* &da4 */
			dalen = socklen_t(unsafe.Sizeof(sockaddr_in{}))
			sa1 = bp + 72 /* &sa4 */
			*(*socklen_t)(unsafe.Pointer(bp + 88 /* salen */)) = socklen_t(unsafe.Sizeof(sockaddr_in{}))
		}
		var dpolicy uintptr = policyof(tls, bp+8)
		var dscope int32 = scopeof(tls, bp+8)
		var dlabel int32 = int32((*policy)(unsafe.Pointer(dpolicy)).label)
		var dprec int32 = int32((*policy)(unsafe.Pointer(dpolicy)).prec)
		var prefixlen int32 = 0
		var fd int32 = Xsocket(tls, family, 2|02000000, 17)
		if fd >= 0 {
			if !(Xconnect(tls, fd, da, dalen) != 0) {
				key = key | 0x40000000
				if !(Xgetsockname(tls, fd, sa1, bp+88) != 0) {
					if family == 2 {
						Xmemcpy(tls,
							bp+28+8+uintptr(12),
							bp+72+4, uint64(4))
					}
					if dscope == scopeof(tls, bp+28+8) {
						key = key | 0x20000000
					}
					if dlabel == labelof(tls, bp+28+8) {
						key = key | 0x10000000
					}
					prefixlen = prefixmatch(tls, bp+28+8,
						bp+8)
				}
			}
			Xclose(tls, fd)
		}
		key = key | dprec<<20
		key = key | (15-dscope)<<16
		key = key | prefixlen<<8
		key = key | (48-i)<<0
		(*address)(unsafe.Pointer(buf + uintptr(i)*28)).sortkey = key
	}
	Xqsort(tls, buf, uint64(cnt), uint64(unsafe.Sizeof(address{})), *(*uintptr)(unsafe.Pointer(&struct {
		f func(*TLS, uintptr, uintptr) int32
	}{addrcmp})))

	//TODO pthread_setcancelstate(cs, 0);

	return cnt
}

func X__lookup_serv(tls *TLS, buf uintptr, name uintptr, proto int32, socktype int32, flags int32) int32 { /* lookup_serv.c:12:5: */
	bp := tls.Alloc(8)
	defer tls.Free(8)

	var line [128]int8
	_ = line
	var cnt int32 = 0
	var p uintptr
	_ = p
	*(*uintptr)(unsafe.Pointer(bp /* z */)) = ts + 13 /* "" */
	var port uint64 = uint64(0)

	switch socktype {
	case 1:
		switch proto {
		case 0:
			proto = 6
			fallthrough
		case 6:
			break
		default:
			return -8
		}
		break
	case 2:
		switch proto {
		case 0:
			proto = 17
			fallthrough
		case 17:
			break
		default:
			return -8
		}
		fallthrough
	case 0:
		break
	default:
		if name != 0 {
			return -8
		}
		(*service)(unsafe.Pointer(buf)).port = uint16_t(0)
		(*service)(unsafe.Pointer(buf)).proto = uint8(proto)
		(*service)(unsafe.Pointer(buf)).socktype = uint8(socktype)
		return 1
	}

	if name != 0 {
		if !(int32(*(*int8)(unsafe.Pointer(name))) != 0) {
			return -8
		}
		port = Xstrtoul(tls, name, bp, 10)
	}
	if !(int32(*(*int8)(unsafe.Pointer(*(*uintptr)(unsafe.Pointer(bp))))) != 0) {
		if port > uint64(65535) {
			return -8
		}
		if proto != 17 {
			(*service)(unsafe.Pointer(buf + uintptr(cnt)*4)).port = uint16_t(port)
			(*service)(unsafe.Pointer(buf + uintptr(cnt)*4)).socktype = uint8(1)
			(*service)(unsafe.Pointer(buf + uintptr(PostIncInt32(&cnt, 1))*4)).proto = uint8(6)
		}
		if proto != 6 {
			(*service)(unsafe.Pointer(buf + uintptr(cnt)*4)).port = uint16_t(port)
			(*service)(unsafe.Pointer(buf + uintptr(cnt)*4)).socktype = uint8(2)
			(*service)(unsafe.Pointer(buf + uintptr(PostIncInt32(&cnt, 1))*4)).proto = uint8(17)
		}
		return cnt
	}

	if flags&0x400 != 0 {
		return -2
	}

	var l size_t = Xstrlen(tls, name)
	_ = l

	Xabort(tls) //TODO-
	// unsigned char _buf[1032];
	// FILE _f, *f = __fopen_rb_ca("/etc/services", &_f, _buf, sizeof _buf);
	// if (!f) switch (errno) {
	// case ENOENT:
	// case ENOTDIR:
	// case EACCES:
	// 	return EAI_SERVICE;
	// default:
	// 	return EAI_SYSTEM;
	// }

	Xabort(tls) //TODO-
	// while (fgets(line, sizeof line, f) && cnt < MAXSERVS) {
	// 	if ((p=strchr(line, '#'))) *p++='\n', *p=0;

	// 	/* Find service name */
	// 	for(p=line; (p=strstr(p, name)); p++) {
	// 		if (p>line && !isspace(p[-1])) continue;
	// 		if (p[l] && !isspace(p[l])) continue;
	// 		break;
	// 	}
	// 	if (!p) continue;

	// 	/* Skip past canonical name at beginning of line */
	// 	for (p=line; *p && !isspace(*p); p++);

	// 	port = strtoul(p, &z, 10);
	// 	if (port > 65535 || z==p) continue;
	// 	if (!strncmp(z, "/udp", 4)) {
	// 		if (proto == IPPROTO_TCP) continue;
	// 		buf[cnt].port = port;
	// 		buf[cnt].socktype = SOCK_DGRAM;
	// 		buf[cnt++].proto = IPPROTO_UDP;
	// 	}
	// 	if (!strncmp(z, "/tcp", 4)) {
	// 		if (proto == IPPROTO_UDP) continue;
	// 		buf[cnt].port = port;
	// 		buf[cnt].socktype = SOCK_STREAM;
	// 		buf[cnt++].proto = IPPROTO_TCP;
	// 	}
	// }
	// __fclose_ca(f);
	// return cnt > 0 ? cnt : EAI_SERVICE;
	Xabort(tls)
	return int32(0) //TODO-
}

func temper(tls *TLS, x uint32) uint32 { /* rand_r.c:3:17: */
	x = x ^ x>>11
	x = x ^ x<<7&0x9D2C5680
	x = x ^ x<<15&0xEFC60000
	x = x ^ x>>18
	return x
}

func Xrand_r(tls *TLS, seed uintptr) int32 { /* rand_r.c:12:5: */
	return int32(temper(tls, AssignPtrUint32(seed, *(*uint32)(unsafe.Pointer(seed))*uint32(1103515245)+uint32(12345))) / uint32(2))
}

func X__lockfile(tls *TLS, f uintptr) int32 { /* __lockfile.c:4:5: */
	var owner int32 = (*FILE)(unsafe.Pointer(f)).lock
	var tid int32 = (*__pthread)(unsafe.Pointer(__pthread_self(tls))).tid
	if owner&CplInt32(0x40000000) == tid {
		return 0
	}
	owner = a_cas(tls, f+140, 0, tid)
	if !(owner != 0) {
		return 1
	}
	for AssignInt32(&owner, a_cas(tls, f+140, 0, tid|0x40000000)) != 0 {
		if owner&0x40000000 != 0 || a_cas(tls, f+140, owner, owner|0x40000000) == owner {
			__futexwait(tls, f+140, owner|0x40000000, 1)
		}
	}
	return 1
}

func X__unlockfile(tls *TLS, f uintptr) { /* __lockfile.c:19:6: */
	if a_swap(tls, f+140, 0)&0x40000000 != 0 {
		__wake(tls, f+140, 1, 1)
	}
}

func X__toread(tls *TLS, f uintptr) int32 { /* __toread.c:3:5: */
	*(*int32)(unsafe.Pointer(f + 136)) |= (*FILE)(unsafe.Pointer(f)).mode - 1
	if (*FILE)(unsafe.Pointer(f)).wpos != (*FILE)(unsafe.Pointer(f)).wbase {
		(*struct {
			f func(*TLS, uintptr, uintptr, size_t) size_t
		})(unsafe.Pointer(&struct{ uintptr }{(*FILE)(unsafe.Pointer(f)).write})).f(tls, f, uintptr(0), uint64(0))
	}
	(*FILE)(unsafe.Pointer(f)).wpos = AssignPtrUintptr(f+56, AssignPtrUintptr(f+32, uintptr(0)))
	if (*FILE)(unsafe.Pointer(f)).flags&uint32(4) != 0 {
		*(*uint32)(unsafe.Pointer(f)) |= uint32(32)
		return -1
	}
	(*FILE)(unsafe.Pointer(f)).rpos = AssignPtrUintptr(f+16, (*FILE)(unsafe.Pointer(f)).buf+uintptr((*FILE)(unsafe.Pointer(f)).buf_size))
	if (*FILE)(unsafe.Pointer(f)).flags&uint32(16) != 0 {
		return -1
	}
	return 0
}

func X__toread_needs_stdio_exit(tls *TLS) { /* __toread.c:16:13: */
	X__builtin_abort(tls) //TODO-
	// __stdio_exit_needed();
}

// This function assumes it will never be called if there is already
// data buffered for reading.

func X__uflow(tls *TLS, f uintptr) int32 { /* __uflow.c:6:5: */
	bp := tls.Alloc(1)
	defer tls.Free(1)

	// var c uint8 at bp, 1

	if !(X__toread(tls, f) != 0) && (*struct {
		f func(*TLS, uintptr, uintptr, size_t) size_t
	})(unsafe.Pointer(&struct{ uintptr }{(*FILE)(unsafe.Pointer(f)).read})).f(tls, f, bp, uint64(1)) == uint64(1) {
		return int32(*(*uint8)(unsafe.Pointer(bp)))
	}
	return -1
}

func Xsscanf(tls *TLS, s uintptr, fmt uintptr, va uintptr) int32 { /* sscanf.c:4:5: */
	var ret int32
	var ap va_list
	_ = ap
	ap = va
	ret = Xvsscanf(tls, s, fmt, ap)
	_ = ap
	return ret
}

type wctrans_t = uintptr /* wctype.h:20:19 */

func store_int(tls *TLS, dest uintptr, size int32, i uint64) { /* vfscanf.c:22:13: */
	if !(dest != 0) {
		return
	}
	switch size {
	case -2:
		*(*int8)(unsafe.Pointer(dest)) = int8(i)
		break
	case -1:
		*(*int16)(unsafe.Pointer(dest)) = int16(i)
		break
	case 0:
		*(*int32)(unsafe.Pointer(dest)) = int32(i)
		break
	case 1:
		*(*int64)(unsafe.Pointer(dest)) = int64(i)
		break
	case 3:
		*(*int64)(unsafe.Pointer(dest)) = int64(i)
		break
	}
}

func arg_n(tls *TLS, ap va_list, n uint32) uintptr { /* vfscanf.c:44:13: */
	var p uintptr
	var i uint32
	var ap2 va_list
	_ = ap2
	ap2 = ap
	for i = n; i > uint32(1); i-- {
		VaUintptr(&ap2)
	}
	p = VaUintptr(&ap2)
	_ = ap2
	return p
}

func Xvfscanf(tls *TLS, f uintptr, fmt uintptr, ap va_list) int32 { /* vfscanf.c:56:5: */
	bp := tls.Alloc(276)
	defer tls.Free(276)

	var width int32
	var size int32
	var alloc int32
	var base int32
	var p uintptr
	var c int32
	var t int32
	var s uintptr
	var wcs uintptr
	// var st mbstate_t at bp+268, 8

	var dest uintptr
	var invert int32
	var matches int32
	var x uint64
	var y float64
	var pos off_t
	// var scanset [257]uint8 at bp, 257

	var i size_t
	var k size_t
	// var wc wchar_t at bp+260, 4

	var __need_unlock int32
	var tmp uintptr
	var tmp1 uintptr
	alloc = 0
	dest = uintptr(0)
	matches = 0
	pos = int64(0)
	__need_unlock = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).lock >= 0 {
			return X__lockfile(tls, f)
		}
		return 0
	}()

	if !!(int32((*FILE)(unsafe.Pointer(f)).rpos) != 0) {
		goto __1
	}
	X__toread(tls, f)
__1:
	;
	if !!(int32((*FILE)(unsafe.Pointer(f)).rpos) != 0) {
		goto __2
	}
	goto input_fail
__2:
	;

	p = fmt
__3:
	if !(*(*uint8)(unsafe.Pointer(p)) != 0) {
		goto __5
	}

	alloc = 0

	if !(__isspace(tls, int32(*(*uint8)(unsafe.Pointer(p)))) != 0) {
		goto __6
	}
__7:
	if !(__isspace(tls, int32(*(*uint8)(unsafe.Pointer(p + 1)))) != 0) {
		goto __8
	}
	p++
	goto __7
__8:
	;
	X__shlim(tls, f, int64(0))
__9:
	if !(__isspace(tls, func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}()) != 0) {
		goto __10
	}
	goto __9
__10:
	;
	if (*FILE)(unsafe.Pointer(f)).shlim >= int64(0) {
		(*FILE)(unsafe.Pointer(f)).rpos--
	} else {
	}
	pos = pos + ((*FILE)(unsafe.Pointer(f)).shcnt + (int64((*FILE)(unsafe.Pointer(f)).rpos)-int64((*FILE)(unsafe.Pointer(f)).buf))/1)
	goto __4
__6:
	;
	if !(int32(*(*uint8)(unsafe.Pointer(p))) != '%' || int32(*(*uint8)(unsafe.Pointer(p + 1))) == '%') {
		goto __11
	}
	X__shlim(tls, f, int64(0))
	if !(int32(*(*uint8)(unsafe.Pointer(p))) == '%') {
		goto __12
	}
	p++
__14:
	if !(__isspace(tls, AssignInt32(&c, func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}())) != 0) {
		goto __15
	}
	goto __14
__15:
	;
	goto __13
__12:
	c = func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}()
__13:
	;
	if !(c != int32(*(*uint8)(unsafe.Pointer(p)))) {
		goto __16
	}
	if (*FILE)(unsafe.Pointer(f)).shlim >= int64(0) {
		(*FILE)(unsafe.Pointer(f)).rpos--
	} else {
	}
	if !(c < 0) {
		goto __17
	}
	goto input_fail
__17:
	;
	goto match_fail
__16:
	;
	pos = pos + ((*FILE)(unsafe.Pointer(f)).shcnt + (int64((*FILE)(unsafe.Pointer(f)).rpos)-int64((*FILE)(unsafe.Pointer(f)).buf))/1)
	goto __4
__11:
	;

	p++
	if !(int32(*(*uint8)(unsafe.Pointer(p))) == '*') {
		goto __18
	}
	dest = uintptr(0)
	p++
	goto __19
__18:
	if !(func() int32 {
		if 0 != 0 {
			return Xisdigit(tls, int32(*(*uint8)(unsafe.Pointer(p))))
		}
		return Bool32(uint32(*(*uint8)(unsafe.Pointer(p)))-uint32('0') < uint32(10))
	}() != 0 && int32(*(*uint8)(unsafe.Pointer(p + 1))) == '$') {
		goto __20
	}
	dest = arg_n(tls, ap, uint32(int32(*(*uint8)(unsafe.Pointer(p)))-'0'))
	p += uintptr(2)
	goto __21
__20:
	dest = VaUintptr(&ap)
__21:
	;
__19:
	;

	width = 0
__22:
	if !(func() int32 {
		if 0 != 0 {
			return Xisdigit(tls, int32(*(*uint8)(unsafe.Pointer(p))))
		}
		return Bool32(uint32(*(*uint8)(unsafe.Pointer(p)))-uint32('0') < uint32(10))
	}() != 0) {
		goto __24
	}
	width = 10*width + int32(*(*uint8)(unsafe.Pointer(p))) - '0'
	goto __23
__23:
	p++
	goto __22
	goto __24
__24:
	;

	if !(int32(*(*uint8)(unsafe.Pointer(p))) == 'm') {
		goto __25
	}
	wcs = uintptr(0)
	s = uintptr(0)
	alloc = BoolInt32(!!(dest != 0))
	p++
	goto __26
__25:
	alloc = 0
__26:
	;

	size = 0
	switch int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&p, 1)))) {
	case 'h':
		goto __28
	case 'l':
		goto __29
	case 'j':
		goto __30
	case 'z':
		goto __31
	case 't':
		goto __32
	case 'L':
		goto __33
	case 'd':
		goto __34
	case 'i':
		goto __35
	case 'o':
		goto __36
	case 'u':
		goto __37
	case 'x':
		goto __38
	case 'a':
		goto __39
	case 'e':
		goto __40
	case 'f':
		goto __41
	case 'g':
		goto __42
	case 'A':
		goto __43
	case 'E':
		goto __44
	case 'F':
		goto __45
	case 'G':
		goto __46
	case 'X':
		goto __47
	case 's':
		goto __48
	case 'c':
		goto __49
	case '[':
		goto __50
	case 'S':
		goto __51
	case 'C':
		goto __52
	case 'p':
		goto __53
	case 'n':
		goto __54
	default:
		goto __55
	}
	goto __27
__28:
	if !(int32(*(*uint8)(unsafe.Pointer(p))) == 'h') {
		goto __56
	}
	p++
	size = -2
	goto __57
__56:
	size = -1
__57:
	;
	goto __27
__29:
	if !(int32(*(*uint8)(unsafe.Pointer(p))) == 'l') {
		goto __58
	}
	p++
	size = 3
	goto __59
__58:
	size = 1
__59:
	;
	goto __27
__30:
	size = 3
	goto __27
__31:
__32:
	size = 1
	goto __27
__33:
	size = 2
	goto __27
__34:
__35:
__36:
__37:
__38:
__39:
__40:
__41:
__42:
__43:
__44:
__45:
__46:
__47:
__48:
__49:
__50:
__51:
__52:
__53:
__54:
	p--
	goto __27
__55:
	goto fmt_fail
__27:
	;

	t = int32(*(*uint8)(unsafe.Pointer(p)))

	// C or S
	if !(t&0x2f == 3) {
		goto __60
	}
	t = t | 32
	size = 1
__60:
	;

	switch t {
	case 'c':
		goto __62
	case '[':
		goto __63
	case 'n':
		goto __64
	default:
		goto __65
	}
	goto __61
__62:
	if !(width < 1) {
		goto __66
	}
	width = 1
__66:
	;
__63:
	goto __61
__64:
	store_int(tls, dest, size, uint64(pos))
	// do not increment match count, etc!
	goto __4
__65:
	X__shlim(tls, f, int64(0))
__67:
	if !(__isspace(tls, func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}()) != 0) {
		goto __68
	}
	goto __67
__68:
	;
	if (*FILE)(unsafe.Pointer(f)).shlim >= int64(0) {
		(*FILE)(unsafe.Pointer(f)).rpos--
	} else {
	}
	pos = pos + ((*FILE)(unsafe.Pointer(f)).shcnt + (int64((*FILE)(unsafe.Pointer(f)).rpos)-int64((*FILE)(unsafe.Pointer(f)).buf))/1)
__61:
	;

	X__shlim(tls, f, int64(width))
	if !(func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}() < 0) {
		goto __69
	}
	goto input_fail
__69:
	;
	if (*FILE)(unsafe.Pointer(f)).shlim >= int64(0) {
		(*FILE)(unsafe.Pointer(f)).rpos--
	} else {
	}

	switch t {
	case 's':
		goto __71
	case 'c':
		goto __72
	case '[':
		goto __73
	case 'p':
		goto __74
	case 'X':
		goto __75
	case 'x':
		goto __76
	case 'o':
		goto __77
	case 'd':
		goto __78
	case 'u':
		goto __79
	case 'i':
		goto __80
	case 'a':
		goto __81
	case 'A':
		goto __82
	case 'e':
		goto __83
	case 'E':
		goto __84
	case 'f':
		goto __85
	case 'F':
		goto __86
	case 'g':
		goto __87
	case 'G':
		goto __88
	}
	goto __70
__71:
__72:
__73:
	if !(t == 'c' || t == 's') {
		goto __89
	}
	Xmemset(tls, bp, -1, uint64(unsafe.Sizeof([257]uint8{})))
	*(*uint8)(unsafe.Pointer(bp)) = uint8(0)
	if !(t == 's') {
		goto __91
	}
	*(*uint8)(unsafe.Pointer(bp + 10)) = uint8(0)
	*(*uint8)(unsafe.Pointer(bp + 11)) = uint8(0)
	*(*uint8)(unsafe.Pointer(bp + 12)) = uint8(0)
	*(*uint8)(unsafe.Pointer(bp + 13)) = uint8(0)
	*(*uint8)(unsafe.Pointer(bp + 14)) = uint8(0)
	*(*uint8)(unsafe.Pointer(bp + 33)) = uint8(0)
__91:
	;
	goto __90
__89:
	if !(int32(*(*uint8)(unsafe.Pointer(PreIncUintptr(&p, 1)))) == '^') {
		goto __92
	}
	p++
	invert = 1
	goto __93
__92:
	invert = 0
__93:
	;
	Xmemset(tls, bp, invert, uint64(unsafe.Sizeof([257]uint8{})))
	*(*uint8)(unsafe.Pointer(bp)) = uint8(0)
	if !(int32(*(*uint8)(unsafe.Pointer(p))) == '-') {
		goto __94
	}
	p++
	*(*uint8)(unsafe.Pointer(bp + 46)) = uint8(1 - invert)
	goto __95
__94:
	if !(int32(*(*uint8)(unsafe.Pointer(p))) == ']') {
		goto __96
	}
	p++
	*(*uint8)(unsafe.Pointer(bp + 94)) = uint8(1 - invert)
__96:
	;
__95:
	;
__97:
	if !(int32(*(*uint8)(unsafe.Pointer(p))) != ']') {
		goto __99
	}
	if !!(int32(*(*uint8)(unsafe.Pointer(p))) != 0) {
		goto __100
	}
	goto fmt_fail
__100:
	;
	if !(int32(*(*uint8)(unsafe.Pointer(p))) == '-' && *(*uint8)(unsafe.Pointer(p + 1)) != 0 && int32(*(*uint8)(unsafe.Pointer(p + 1))) != ']') {
		goto __101
	}
	c = int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&p, 1) + UintptrFromInt32(-1))))
__102:
	if !(c < int32(*(*uint8)(unsafe.Pointer(p)))) {
		goto __104
	}
	*(*uint8)(unsafe.Pointer(bp + uintptr(1+c))) = uint8(1 - invert)
	goto __103
__103:
	c++
	goto __102
	goto __104
__104:
	;
__101:
	;
	*(*uint8)(unsafe.Pointer(bp + uintptr(1+int32(*(*uint8)(unsafe.Pointer(p)))))) = uint8(1 - invert)
	goto __98
__98:
	p++
	goto __97
	goto __99
__99:
	;
__90:
	;
	wcs = uintptr(0)
	s = uintptr(0)
	i = uint64(0)
	if t == 'c' {
		k = uint64(uint32(width) + 1)
	} else {
		k = uint64(31)
	}
	if !(size == 1) {
		goto __105
	}
	if !(alloc != 0) {
		goto __107
	}
	wcs = Xmalloc(tls, k*size_t(unsafe.Sizeof(wchar_t(0))))
	if !!(wcs != 0) {
		goto __109
	}
	goto alloc_fail
__109:
	;
	goto __108
__107:
	wcs = dest
__108:
	;
	*(*mbstate_t)(unsafe.Pointer(bp + 268 /* st */)) = mbstate_t{}
__110:
	if !(*(*uint8)(unsafe.Pointer(bp + uintptr(AssignInt32(&c, func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}())+1))) != 0) {
		goto __111
	}
	switch Xmbrtowc(tls, bp+260, func() uintptr { *(*int8)(unsafe.Pointer(bp + 264)) = int8(c); return bp + 264 }(), uint64(1), bp+268 /* &st */) {
	case Uint64FromInt32(-1):
		goto __113
	case Uint64FromInt32(-2):
		goto __114
	}
	goto __112
__113:
	goto input_fail
__114:
	goto __110
__112:
	;
	if !(wcs != 0) {
		goto __115
	}
	*(*wchar_t)(unsafe.Pointer(wcs + uintptr(PostIncUint64(&i, 1))*4)) = *(*wchar_t)(unsafe.Pointer(bp + 260 /* wc */))
__115:
	;
	if !(alloc != 0 && i == k) {
		goto __116
	}
	k = k + (k + uint64(1))
	tmp = Xrealloc(tls, wcs, k*size_t(unsafe.Sizeof(wchar_t(0))))
	if !!(tmp != 0) {
		goto __117
	}
	goto alloc_fail
__117:
	;
	wcs = tmp
__116:
	;
	goto __110
__111:
	;
	if !!(Xmbsinit(tls, bp+268) != 0) {
		goto __118
	}
	goto input_fail
__118:
	;
	goto __106
__105:
	if !(alloc != 0) {
		goto __119
	}
	s = Xmalloc(tls, k)
	if !!(s != 0) {
		goto __121
	}
	goto alloc_fail
__121:
	;
__122:
	if !(*(*uint8)(unsafe.Pointer(bp + uintptr(AssignInt32(&c, func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}())+1))) != 0) {
		goto __123
	}
	*(*int8)(unsafe.Pointer(s + uintptr(PostIncUint64(&i, 1)))) = int8(c)
	if !(i == k) {
		goto __124
	}
	k = k + (k + uint64(1))
	tmp1 = Xrealloc(tls, s, k)
	if !!(tmp1 != 0) {
		goto __125
	}
	goto alloc_fail
__125:
	;
	s = tmp1
__124:
	;
	goto __122
__123:
	;
	goto __120
__119:
	if !(AssignUintptr(&s, dest) != 0) {
		goto __126
	}
__128:
	if !(*(*uint8)(unsafe.Pointer(bp + uintptr(AssignInt32(&c, func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}())+1))) != 0) {
		goto __129
	}
	*(*int8)(unsafe.Pointer(s + uintptr(PostIncUint64(&i, 1)))) = int8(c)
	goto __128
__129:
	;
	goto __127
__126:
__130:
	if !(*(*uint8)(unsafe.Pointer(bp + uintptr(AssignInt32(&c, func() int32 {
		if (*FILE)(unsafe.Pointer(f)).rpos != (*FILE)(unsafe.Pointer(f)).shend {
			return int32(*(*uint8)(unsafe.Pointer(PostIncUintptr(&(*FILE)(unsafe.Pointer(f)).rpos, 1))))
		}
		return X__shgetc(tls, f)
	}())+1))) != 0) {
		goto __131
	}
	goto __130
__131:
	;
__127:
	;
__120:
	;
__106:
	;
	if (*FILE)(unsafe.Pointer(f)).shlim >= int64(0) {
		(*FILE)(unsafe.Pointer(f)).rpos--
	} else {
	}
	if !!((*FILE)(unsafe.Pointer(f)).shcnt+(int64((*FILE)(unsafe.Pointer(f)).rpos)-int64((*FILE)(unsafe.Pointer(f)).buf))/1 != 0) {
		goto __132
	}
	goto match_fail
__132:
	;
	if !(t == 'c' && (*FILE)(unsafe.Pointer(f)).shcnt+(int64((*FILE)(unsafe.Pointer(f)).rpos)-int64((*FILE)(unsafe.Pointer(f)).buf))/1 != off_t(width)) {
		goto __133
	}
	goto match_fail
__133:
	;
	if !(alloc != 0) {
		goto __134
	}
	if !(size == 1) {
		goto __135
	}
	*(*uintptr)(unsafe.Pointer(dest)) = wcs
	goto __136
__135:
	*(*uintptr)(unsafe.Pointer(dest)) = s
__136:
	;
__134:
	;
	if !(t != 'c') {
		goto __137
	}
	if !(wcs != 0) {
		goto __138
	}
	*(*wchar_t)(unsafe.Pointer(wcs + uintptr(i)*4)) = 0
__138:
	;
	if !(s != 0) {
		goto __139
	}
	*(*int8)(unsafe.Pointer(s + uintptr(i))) = int8(0)
__139:
	;
__137:
	;
	goto __70
__74:
__75:
__76:
	base = 16
	goto int_common
__77:
	base = 8
	goto int_common
__78:
__79:
	base = 10
	goto int_common
__80:
	base = 0
int_common:
	x = X__intscan(tls, f, uint32(base), 0, 2*uint64(0x7fffffffffffffff)+uint64(1))
	if !!((*FILE)(unsafe.Pointer(f)).shcnt+(int64((*FILE)(unsafe.Pointer(f)).rpos)-int64((*FILE)(unsafe.Pointer(f)).buf))/1 != 0) {
		goto __140
	}
	goto match_fail
__140:
	;
	if !(t == 'p' && dest != 0) {
		goto __141
	}
	*(*uintptr)(unsafe.Pointer(dest)) = uintptr(uintptr_t(x))
	goto __142
__141:
	store_int(tls, dest, size, x)
__142:
	;
	goto __70
__81:
__82:
__83:
__84:
__85:
__86:
__87:
__88:
	y = X__floatscan(tls, f, size, 0)
	if !!((*FILE)(unsafe.Pointer(f)).shcnt+(int64((*FILE)(unsafe.Pointer(f)).rpos)-int64((*FILE)(unsafe.Pointer(f)).buf))/1 != 0) {
		goto __143
	}
	goto match_fail
__143:
	;
	if !(dest != 0) {
		goto __144
	}
	switch size {
	case 0:
		goto __146
	case 1:
		goto __147
	case 2:
		goto __148
	}
	goto __145
__146:
	*(*float32)(unsafe.Pointer(dest)) = float32(y)
	goto __145
__147:
	*(*float64)(unsafe.Pointer(dest)) = y
	goto __145
__148:
	*(*float64)(unsafe.Pointer(dest)) = y
	goto __145
__145:
	;
__144:
	;
	goto __70
__70:
	;

	pos = pos + ((*FILE)(unsafe.Pointer(f)).shcnt + (int64((*FILE)(unsafe.Pointer(f)).rpos)-int64((*FILE)(unsafe.Pointer(f)).buf))/1)
	if !(dest != 0) {
		goto __149
	}
	matches++
__149:
	;
	goto __4
__4:
	p++
	goto __3
	goto __5
__5:
	;
	if !(0 != 0) {
		goto __150
	}
fmt_fail:
alloc_fail:
input_fail:
	if !!(matches != 0) {
		goto __151
	}
	matches--
__151:
	;
match_fail:
	if !(alloc != 0) {
		goto __152
	}
	Xfree(tls, s)
	Xfree(tls, wcs)
__152:
	;
__150:
	;
__153:
	if !(__need_unlock != 0) {
		goto __156
	}
	X__unlockfile(tls, f)
__156:
	;
	goto __154
__154:
	if 0 != 0 {
		goto __153
	}
	goto __155
__155:
	;
	return matches
}

func string_read(tls *TLS, f uintptr, buf uintptr, len size_t) size_t { /* vsscanf.c:4:15: */
	var src uintptr = (*FILE)(unsafe.Pointer(f)).cookie
	var k size_t = len + uint64(256)
	var end uintptr = Xmemchr(tls, src, 0, k)
	if end != 0 {
		k = size_t((int64(end) - int64(src)) / 1)
	}
	if k < len {
		len = k
	}
	Xmemcpy(tls, buf, src, len)
	(*FILE)(unsafe.Pointer(f)).rpos = src + uintptr(len)
	(*FILE)(unsafe.Pointer(f)).rend = src + uintptr(k)
	(*FILE)(unsafe.Pointer(f)).cookie = src + uintptr(k)
	return len
}

func Xvsscanf(tls *TLS, s uintptr, fmt uintptr, ap va_list) int32 { /* vsscanf.c:18:5: */
	bp := tls.Alloc(232)
	defer tls.Free(232)

	*(*FILE)(unsafe.Pointer(bp /* f */)) = FILE{read: *(*uintptr)(unsafe.Pointer(&struct {
		f func(*TLS, uintptr, uintptr, size_t) size_t
	}{string_read})), buf: s, lock: -1, cookie: s}
	return Xvfscanf(tls, bp, fmt, ap)
}

func Xbsearch(tls *TLS, key uintptr, base uintptr, nel size_t, width size_t, cmp uintptr) uintptr { /* bsearch.c:3:6: */
	var try uintptr
	var sign int32
	for nel > uint64(0) {
		try = base + uintptr(width*(nel/uint64(2)))
		sign = (*struct {
			f func(*TLS, uintptr, uintptr) int32
		})(unsafe.Pointer(&struct{ uintptr }{cmp})).f(tls, key, try)
		if sign < 0 {
			nel = nel / uint64(2)
		} else if sign > 0 {
			base = try + uintptr(width)
			nel = nel - (nel/uint64(2) + uint64(1))
		} else {
			return try
		}
	}
	return uintptr(0)
}

func strtox(tls *TLS, s uintptr, p uintptr, prec int32) float64 { /* strtod.c:6:20: */
	bp := tls.Alloc(232)
	defer tls.Free(232)

	// var f FILE at bp, 232

	(*FILE)(unsafe.Pointer(bp)).buf = AssignPtrUintptr(bp+8, s)
	(*FILE)(unsafe.Pointer(bp)).rend = UintptrFromInt32(-1)
	X__shlim(tls, bp, int64(0))
	var y float64 = X__floatscan(tls, bp, prec, 1)
	var cnt off_t = (*FILE)(unsafe.Pointer(bp)).shcnt + (int64((*FILE)(unsafe.Pointer(bp)).rpos)-int64((*FILE)(unsafe.Pointer(bp)).buf))/1
	if p != 0 {
		*(*uintptr)(unsafe.Pointer(p)) = func() uintptr {
			if cnt != 0 {
				return s + uintptr(cnt)
			}
			return s
		}()
	}
	return y
}

func Xstrtof(tls *TLS, s uintptr, p uintptr) float32 { /* strtod.c:17:7: */
	return float32(strtox(tls, s, p, 0))
}

func Xstrtod(tls *TLS, s uintptr, p uintptr) float64 { /* strtod.c:22:8: */
	return strtox(tls, s, p, 1)
}

func Xstrtold(tls *TLS, s uintptr, p uintptr) float64 { /* strtod.c:27:13: */
	return strtox(tls, s, p, 2)
}

func strtox1(tls *TLS, s uintptr, p uintptr, base int32, lim uint64) uint64 { /* strtol.c:8:27: */
	bp := tls.Alloc(232)
	defer tls.Free(232)

	// var f FILE at bp, 232

	(*FILE)(unsafe.Pointer(bp)).buf = AssignPtrUintptr(bp+8, s)
	(*FILE)(unsafe.Pointer(bp)).rend = UintptrFromInt32(-1)
	X__shlim(tls, bp, int64(0))
	var y uint64 = X__intscan(tls, bp, uint32(base), 1, lim)
	if p != 0 {
		var cnt size_t = size_t((*FILE)(unsafe.Pointer(bp)).shcnt + (int64((*FILE)(unsafe.Pointer(bp)).rpos)-int64((*FILE)(unsafe.Pointer(bp)).buf))/1)
		*(*uintptr)(unsafe.Pointer(p)) = s + uintptr(cnt)
	}
	return y
}

func Xstrtoull(tls *TLS, s uintptr, p uintptr, base int32) uint64 { /* strtol.c:21:20: */
	return strtox1(tls, s, p, base, 2*uint64(0x7fffffffffffffff)+uint64(1))
}

func Xstrtoll(tls *TLS, s uintptr, p uintptr, base int32) int64 { /* strtol.c:26:11: */
	return int64(strtox1(tls, s, p, base, Uint64FromInt64(-0x7fffffffffffffff-int64(1))))
}

func Xstrtoul(tls *TLS, s uintptr, p uintptr, base int32) uint64 { /* strtol.c:31:15: */
	return uint64(strtox1(tls, s, p, base, 2*uint64(0x7fffffffffffffff)+uint64(1)))
}

func Xstrtol(tls *TLS, s uintptr, p uintptr, base int32) int64 { /* strtol.c:36:6: */
	return int64(strtox1(tls, s, p, base, 0+Uint64FromInt64(Int64(-Int64(0x7fffffffffffffff))-Int64FromInt32(1))))
}

func Xstrtoimax(tls *TLS, s uintptr, p uintptr, base int32) intmax_t { /* strtol.c:41:10: */
	return intmax_t(Xstrtoll(tls, s, p, base))
}

func Xstrtoumax(tls *TLS, s uintptr, p uintptr, base int32) uintmax_t { /* strtol.c:46:11: */
	return uintmax_t(Xstrtoull(tls, s, p, base))
}

func Xstrdup(tls *TLS, s uintptr) uintptr { /* strdup.c:4:6: */
	var l size_t = Xstrlen(tls, s)
	var d uintptr = Xmalloc(tls, l+uint64(1))
	if !(d != 0) {
		return uintptr(0)
	}
	return Xmemcpy(tls, d, s, l+uint64(1))
}

func Xstrlcat(tls *TLS, d uintptr, s uintptr, n size_t) size_t { /* strlcat.c:4:8: */
	var l size_t = Xstrnlen(tls, d, n)
	if l == n {
		return l + Xstrlen(tls, s)
	}
	return l + Xstrlcpy(tls, d+uintptr(l), s, n-l)
}

// Support signed or unsigned plain-char

// Implementation choices...

// Arbitrary numbers...

// POSIX/SUS requirements follow. These numbers come directly
// from SUS and have nothing to do with the host system.

func Xstrlcpy(tls *TLS, d uintptr, s uintptr, n size_t) size_t { /* strlcpy.c:11:8: */
	var d0 uintptr
	var wd uintptr
	var ws uintptr
	d0 = d

	if !!(int32(PostDecUint64(&n, 1)) != 0) {
		goto __1
	}
	goto finish
__1:
	;
	if !(uintptr_t(s)&(uint64(unsafe.Sizeof(size_t(0)))-uint64(1)) == uintptr_t(d)&(uint64(unsafe.Sizeof(size_t(0)))-uint64(1))) {
		goto __2
	}
__3:
	if !(uintptr_t(s)&(uint64(unsafe.Sizeof(size_t(0)))-uint64(1)) != 0 && n != 0 && AssignPtrInt8(d, *(*int8)(unsafe.Pointer(s))) != 0) {
		goto __5
	}
	goto __4
__4:
	n--
	s++
	d++
	goto __3
	goto __5
__5:
	;
	if !(n != 0 && *(*int8)(unsafe.Pointer(s)) != 0) {
		goto __6
	}
	wd = d
	ws = s
__7:
	if !(n >= size_t(unsafe.Sizeof(size_t(0))) && !((*(*uint64)(unsafe.Pointer(ws))-Uint64(Uint64FromInt32(-1))/uint64(255)) & ^*(*uint64)(unsafe.Pointer(ws)) & (Uint64(Uint64FromInt32(-1))/uint64(255)*uint64(255/2+1)) != 0)) {
		goto __9
	}
	*(*size_t)(unsafe.Pointer(wd)) = *(*uint64)(unsafe.Pointer(ws))
	goto __8
__8:
	n = n - size_t(unsafe.Sizeof(size_t(0)))
	ws += 8
	wd += 8
	goto __7
	goto __9
__9:
	;
	d = wd
	s = ws
__6:
	;
__2:
	;
__10:
	if !(n != 0 && AssignPtrInt8(d, *(*int8)(unsafe.Pointer(s))) != 0) {
		goto __12
	}
	goto __11
__11:
	n--
	s++
	d++
	goto __10
	goto __12
__12:
	;
	*(*int8)(unsafe.Pointer(d)) = int8(0)
finish:
	return size_t((int64(d)-int64(d0))/1) + Xstrlen(tls, s)
}

func Xstrncasecmp(tls *TLS, _l uintptr, _r uintptr, n size_t) int32 { /* strncasecmp.c:4:5: */
	var l uintptr = _l
	var r uintptr = _r
	if !(int32(PostDecUint64(&n, 1)) != 0) {
		return 0
	}
__1:
	if !(*(*uint8)(unsafe.Pointer(l)) != 0 && *(*uint8)(unsafe.Pointer(r)) != 0 && n != 0 && (int32(*(*uint8)(unsafe.Pointer(l))) == int32(*(*uint8)(unsafe.Pointer(r))) || Xtolower(tls, int32(*(*uint8)(unsafe.Pointer(l)))) == Xtolower(tls, int32(*(*uint8)(unsafe.Pointer(r)))))) {
		goto __3
	}
	goto __2
__2:
	l++
	r++
	n--
	goto __1
	goto __3
__3:
	;
	return Xtolower(tls, int32(*(*uint8)(unsafe.Pointer(l)))) - Xtolower(tls, int32(*(*uint8)(unsafe.Pointer(r))))
}

func X__strncasecmp_l(tls *TLS, l uintptr, r uintptr, n size_t, loc locale_t) int32 { /* strncasecmp.c:12:5: */
	return Xstrncasecmp(tls, l, r, n)
}

func Xstrncat(tls *TLS, d uintptr, s uintptr, n size_t) uintptr { /* strncat.c:3:6: */
	var a uintptr = d
	d += uintptr(Xstrlen(tls, d))
	for n != 0 && *(*int8)(unsafe.Pointer(s)) != 0 {
		n--
		*(*int8)(unsafe.Pointer(PostIncUintptr(&d, 1))) = *(*int8)(unsafe.Pointer(PostIncUintptr(&s, 1)))
	}
	*(*int8)(unsafe.Pointer(PostIncUintptr(&d, 1))) = int8(0)
	return a
}

func Xstrnlen(tls *TLS, s uintptr, n size_t) size_t { /* strnlen.c:3:8: */
	var p uintptr = Xmemchr(tls, s, 0, n)
	if p != 0 {
		return uint64((int64(p) - int64(s)) / 1)
	}
	return n
}

func Xstrspn(tls *TLS, s uintptr, c uintptr) size_t { /* strspn.c:6:8: */
	bp := tls.Alloc(32)
	defer tls.Free(32)

	var a uintptr = s
	*(*[4]size_t)(unsafe.Pointer(bp /* byteset */)) = [4]size_t{0: uint64(0)}

	if !(int32(*(*int8)(unsafe.Pointer(c))) != 0) {
		return uint64(0)
	}
	if !(int32(*(*int8)(unsafe.Pointer(c + 1))) != 0) {
		for ; int32(*(*int8)(unsafe.Pointer(s))) == int32(*(*int8)(unsafe.Pointer(c))); s++ {
		}
		return size_t((int64(s) - int64(a)) / 1)
	}

	for ; *(*int8)(unsafe.Pointer(c)) != 0 && AssignOrPtrUint64(bp+uintptr(size_t(*(*uint8)(unsafe.Pointer(c)))/(uint64(8)*uint64(unsafe.Sizeof(size_t(0)))))*8, size_t(uint64(1))<<(size_t(*(*uint8)(unsafe.Pointer(c)))%(uint64(8)*uint64(unsafe.Sizeof(size_t(0)))))) != 0; c++ {
	}
	for ; *(*int8)(unsafe.Pointer(s)) != 0 && *(*size_t)(unsafe.Pointer(bp + uintptr(size_t(*(*uint8)(unsafe.Pointer(s)))/(uint64(8)*uint64(unsafe.Sizeof(size_t(0)))))*8))&(size_t(uint64(1))<<(size_t(*(*uint8)(unsafe.Pointer(s)))%(uint64(8)*uint64(unsafe.Sizeof(size_t(0)))))) != 0; s++ {
	}
	return size_t((int64(s) - int64(a)) / 1)
}

func Xstrtok(tls *TLS, s uintptr, sep uintptr) uintptr { /* strtok.c:3:6: */
	if !(s != 0) && !(int32(AssignUintptr(&s, _sp)) != 0) {
		return uintptr(0)
	}
	s += uintptr(Xstrspn(tls, s, sep))
	if !(int32(*(*int8)(unsafe.Pointer(s))) != 0) {
		return AssignPtrUintptr(uintptr(unsafe.Pointer(&_sp)), uintptr(0))
	}
	_sp = s + uintptr(Xstrcspn(tls, s, sep))
	if *(*int8)(unsafe.Pointer(_sp)) != 0 {
		*(*int8)(unsafe.Pointer(PostIncUintptr(&_sp, 1))) = int8(0)
	} else {
		_sp = uintptr(0)
	}
	return s
}

var _sp uintptr /* strtok.c:5:14: */

func X__ccgo_pthreadAttrGetDetachState(tls *TLS, a uintptr) int32 { /* pthread_attr_get.c:3:5: */
	return *(*int32)(unsafe.Pointer(a + 6*4))
}

func Xpthread_attr_getdetachstate(tls *TLS, a uintptr, state uintptr) int32 { /* pthread_attr_get.c:7:5: */
	*(*int32)(unsafe.Pointer(state)) = *(*int32)(unsafe.Pointer(a + 6*4))
	return 0
}

//
// int pthread_attr_getguardsize(const pthread_attr_t *restrict a, size_t *restrict size)
// {
// 	*size = a->_a_guardsize;
// 	return 0;
// }
//
// int pthread_attr_getinheritsched(const pthread_attr_t *restrict a, int *restrict inherit)
// {
// 	*inherit = a->_a_sched;
// 	return 0;
// }
//
// int pthread_attr_getschedparam(const pthread_attr_t *restrict a, struct sched_param *restrict param)
// {
// 	param->sched_priority = a->_a_prio;
// 	return 0;
// }
//
// int pthread_attr_getschedpolicy(const pthread_attr_t *restrict a, int *restrict policy)
// {
// 	*policy = a->_a_policy;
// 	return 0;
// }
//
// int pthread_attr_getscope(const pthread_attr_t *restrict a, int *restrict scope)
// {
// 	*scope = PTHREAD_SCOPE_SYSTEM;
// 	return 0;
// }
//
// int pthread_attr_getstack(const pthread_attr_t *restrict a, void **restrict addr, size_t *restrict size)
// {
// 	if (!a->_a_stackaddr)
// 		return EINVAL;
// 	*size = a->_a_stacksize;
// 	*addr = (void *)(a->_a_stackaddr - *size);
// 	return 0;
// }
//
// int pthread_attr_getstacksize(const pthread_attr_t *restrict a, size_t *restrict size)
// {
// 	*size = a->_a_stacksize;
// 	return 0;
// }
//
// int pthread_barrierattr_getpshared(const pthread_barrierattr_t *restrict a, int *restrict pshared)
// {
// 	*pshared = !!a->__attr;
// 	return 0;
// }
//
// int pthread_condattr_getclock(const pthread_condattr_t *restrict a, clockid_t *restrict clk)
// {
// 	*clk = a->__attr & 0x7fffffff;
// 	return 0;
// }
//
// int pthread_condattr_getpshared(const pthread_condattr_t *restrict a, int *restrict pshared)
// {
// 	*pshared = a->__attr>>31;
// 	return 0;
// }
//
// int pthread_mutexattr_getprotocol(const pthread_mutexattr_t *restrict a, int *restrict protocol)
// {
// 	*protocol = PTHREAD_PRIO_NONE;
// 	return 0;
// }
// int pthread_mutexattr_getpshared(const pthread_mutexattr_t *restrict a, int *restrict pshared)
// {
// 	*pshared = a->__attr / 128U % 2;
// 	return 0;
// }
//
// int pthread_mutexattr_getrobust(const pthread_mutexattr_t *restrict a, int *restrict robust)
// {
// 	*robust = a->__attr / 4U % 2;
// 	return 0;
// }

func X__ccgo_pthreadMutexattrGettype(tls *TLS, a uintptr) int32 { /* pthread_attr_get.c:93:5: */
	return int32((*pthread_mutexattr_t)(unsafe.Pointer(a)).__attr & uint32(3))
}

// int pthread_mutexattr_gettype(const pthread_mutexattr_t *restrict a, int *restrict type)
// {
// 	*type = a->__attr & 3;
// 	return 0;
// }
//
// int pthread_rwlockattr_getpshared(const pthread_rwlockattr_t *restrict a, int *restrict pshared)
// {
// 	*pshared = a->__attr[0];
// 	return 0;
// }

func Xpthread_attr_setdetachstate(tls *TLS, a uintptr, state int32) int32 { /* pthread_attr_setdetachstate.c:3:5: */
	if uint32(state) > 1 {
		return 22
	}
	*(*int32)(unsafe.Pointer(a + 6*4)) = state
	return 0
}

func X__ccgo_getMutexType(tls *TLS, m uintptr) int32 { /* pthread_mutex_lock.c:3:5: */
	return *(*int32)(unsafe.Pointer(m)) & 15
}

// int __pthread_mutex_lock(pthread_mutex_t *m)
// {
// 	if ((m->_m_type&15) == PTHREAD_MUTEX_NORMAL
// 	    && !a_cas(&m->_m_lock, 0, EBUSY))
// 		return 0;
//
// 	return __pthread_mutex_timedlock(m, 0);
// }
//
// weak_alias(__pthread_mutex_lock, pthread_mutex_lock);

func Xpthread_mutexattr_destroy(tls *TLS, a uintptr) int32 { /* pthread_mutexattr_destroy.c:3:5: */
	return 0
}

func Xpthread_mutexattr_init(tls *TLS, a uintptr) int32 { /* pthread_mutexattr_init.c:3:5: */
	*(*pthread_mutexattr_t)(unsafe.Pointer(a)) = pthread_mutexattr_t{}
	return 0
}

func Xpthread_mutexattr_settype(tls *TLS, a uintptr, type1 int32) int32 { /* pthread_mutexattr_settype.c:3:5: */
	if uint32(type1) > uint32(2) {
		return 22
	}
	(*pthread_mutexattr_t)(unsafe.Pointer(a)).__attr = (*pthread_mutexattr_t)(unsafe.Pointer(a)).__attr&Uint32FromInt32(CplInt32(3)) | uint32(type1)
	return 0
}

func init() {
	*(*uintptr)(unsafe.Pointer(uintptr(unsafe.Pointer(&ptable)) + 0)) = uintptr(unsafe.Pointer(&table)) + uintptr(128)*2 // __ctype_b_loc.c:36:45:
}

var ts1 = "infinity\x00nan\x00\x00\x00\x01\x02\x04\a\x03\x06\x05\x00.\x00%d.%d.%d.%d.in-addr.arpa\x00ip6.arpa\x000123456789abcdef\x00/etc/hosts\x00rb\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\x00%d.%d.%d.%d\x00%x:%x:%x:%x:%x:%x:%x:%x\x00%x:%x:%x:%x:%x:%x:%d.%d.%d.%d\x00:0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\xff\x00\x00\x00\x00 \x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00 \x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
var ts = (*reflect.StringHeader)(unsafe.Pointer(&ts1)).Data
