/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import org.apache.log4j.Level;
import org.apache.log4j.Log4jLoggerFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class Category {
    private String name;
    private org.slf4j.Logger lbLogger;
    private LocationAwareLogger locationAwareLogger;
    private static Marker TRACE_MARKER = MarkerFactory.getMarker((String)"TRACE");
    private static Marker FATAL_MARKER = MarkerFactory.getMarker((String)"FATAL");

    Category(String name) {
        this.name = name;
        this.lbLogger = LoggerFactory.getLogger((String)name);
        if (this.lbLogger instanceof LocationAwareLogger) {
            this.locationAwareLogger = (LocationAwareLogger)this.lbLogger;
        }
    }

    public static Logger getLogger(String name) {
        return Log4jLoggerFactory.getLogger(name);
    }

    public static Logger getLogger(Class clazz) {
        return Category.getLogger(clazz.getName());
    }

    public static Logger getRootLogger() {
        return Category.getLogger("root");
    }

    public String getName() {
        return this.name;
    }

    public boolean isTraceEnabled() {
        return this.lbLogger.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.lbLogger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.lbLogger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.lbLogger.isWarnEnabled();
    }

    public boolean isEnabledFor(Priority p) {
        return this.isEnabledFor(Level.toLevel(p.level));
    }

    public boolean isEnabledFor(Level l) {
        switch (l.level) {
            case 5000: {
                return this.lbLogger.isTraceEnabled();
            }
            case 10000: {
                return this.lbLogger.isDebugEnabled();
            }
            case 20000: {
                return this.lbLogger.isInfoEnabled();
            }
            case 30000: {
                return this.lbLogger.isWarnEnabled();
            }
            case 40000: {
                return this.lbLogger.isErrorEnabled();
            }
            case 50000: {
                return this.lbLogger.isErrorEnabled();
            }
        }
        return false;
    }

    public boolean isErrorEnabled() {
        return this.lbLogger.isErrorEnabled();
    }

    public void trace(Object message) {
        this.lbLogger.debug(TRACE_MARKER, this.convertToString(message));
    }

    public void trace(Object message, Throwable t) {
        this.lbLogger.debug(TRACE_MARKER, this.convertToString(message), t);
    }

    public void trace(Object message, Object o) {
        this.lbLogger.debug(TRACE_MARKER, this.convertToString(message), o);
    }

    public void trace(String message, Object arg1, Object arg2) {
        this.lbLogger.debug(TRACE_MARKER, message, arg1, arg2);
    }

    public void debug(Object message) {
        this.lbLogger.debug(this.convertToString(message));
    }

    public void debug(Object message, Throwable t) {
        this.lbLogger.debug(this.convertToString(message), t);
    }

    public void debug(Object message, Object o) {
        this.lbLogger.debug(this.convertToString(message), o);
    }

    public void debug(String message, Object arg1, Object arg2) {
        this.lbLogger.debug(message, arg1, arg2);
    }

    public void info(Object message) {
        this.lbLogger.info(this.convertToString(message));
    }

    public void info(Object message, Throwable t) {
        this.lbLogger.info(this.convertToString(message), t);
    }

    public void info(Object message, Object o) {
        this.lbLogger.info(this.convertToString(message), o);
    }

    public void info(String message, Object arg1, Object arg2) {
        this.lbLogger.info(message, arg1, arg2);
    }

    public void warn(Object message) {
        this.lbLogger.warn(this.convertToString(message));
    }

    public void warn(Object message, Throwable t) {
        this.lbLogger.warn(this.convertToString(message), t);
    }

    public void warn(Object message, Object o) {
        this.lbLogger.warn(this.convertToString(message), o);
    }

    public void warn(String message, Object arg1, Object arg2) {
        this.lbLogger.warn(message, arg1, arg2);
    }

    public void error(Object message) {
        this.lbLogger.error(this.convertToString(message));
    }

    public void error(Object message, Throwable t) {
        this.lbLogger.error(this.convertToString(message), t);
    }

    public void error(Object message, Object o) {
        this.lbLogger.error(this.convertToString(message), o);
    }

    public void error(String message, Object arg1, Object arg2) {
        this.lbLogger.error(message, arg1, arg2);
    }

    public void fatal(Object message) {
        this.lbLogger.error(FATAL_MARKER, this.convertToString(message));
    }

    public void fatal(Object message, Throwable t) {
        this.lbLogger.error(FATAL_MARKER, this.convertToString(message), t);
    }

    public void fatal(Object message, Object o) {
        this.lbLogger.error(FATAL_MARKER, this.convertToString(message), o);
    }

    public void fatal(String message, Object arg1, Object arg2) {
        this.lbLogger.error(FATAL_MARKER, message, arg1, arg2);
    }

    public void log(String FQCN, Priority p, Object msg, Throwable t) {
        int levelInt = this.priorityToLevelInt(p);
        if (this.locationAwareLogger != null) {
            if (msg != null) {
                this.locationAwareLogger.log(null, FQCN, levelInt, msg.toString(), t);
            } else {
                this.locationAwareLogger.log(null, FQCN, levelInt, null, t);
            }
        } else {
            throw new UnsupportedOperationException("The logger [" + this.lbLogger + "] does not seem to be location aware.");
        }
    }

    private int priorityToLevelInt(Priority p) {
        switch (p.level) {
            case 5000: {
                return 0;
            }
            case 10000: {
                return 10;
            }
            case 20000: {
                return 20;
            }
            case 30000: {
                return 30;
            }
            case 40000: {
                return 40;
            }
            case 50000: {
                return 40;
            }
        }
        throw new IllegalStateException("Unknown Priority " + p);
    }

    private final String convertToString(Object message) {
        if (message == null) {
            return (String)message;
        }
        return message.toString();
    }
}

