sys.version_info(major=3, minor=8, micro=16, releaselevel='final', serial=0)

### Timing comparison of `int` functions

| Input type        | builtin (ms)       | fastnumbers (ms)   |
| ----------------: | -----------------: | -----------------: |
|  Small Int String |   15.699 ± 0.372   | **12.087 ± 0.298** |
|        Int String |   16.992 ± 1.436   | **13.965 ± 0.545** |
| Medium Int String |   18.444 ± 0.238   | **14.619 ± 0.688** |
|  Large Int String |   28.029 ± 1.302   | **26.856 ± 0.455** |
|               Int | **10.091 ± 1.185** |   10.664 ± 0.181   |
|             Float | **22.599 ± 0.418** |   25.529 ± 0.505   |

### Timing comparison of `float` functions

| Input type         | builtin (ms)       | fastnumbers (ms)   |
| -----------------: | -----------------: | -----------------: |
|   Small Int String |   16.993 ± 0.446   | **16.016 ± 1.509** |
|         Int String |   18.518 ± 1.232   | **15.296 ± 0.504** |
|  Medium Int String |   19.425 ± 1.324   | **15.711 ± 1.562** |
|   Large Int String |   40.501 ± 1.102   | **21.050 ± 3.920** |
| Small Float String |   16.780 ± 0.319   | **15.226 ± 0.966** |
|       Float String |   37.526 ± 0.704   | **17.334 ± 1.002** |
| Large Float String |   62.962 ± 1.156   | **17.301 ± 0.343** |
|                Int | **11.047 ± 0.260** |   12.657 ± 0.210   |
|              Float |  **9.704 ± 0.258** |   11.227 ± 0.179   |

### Timing comparison of `int` functions with error handling

| Input type         | try/except (ms)    | regex (ms)     | fastnumbers (ms)   |
| -----------------: | -----------------: | -------------: | -----------------: |
|  Non-number String |  154.718 ± 3.795   | 33.646 ± 0.082 | **26.439 ± 0.056** |
|   Small Int String |   25.688 ± 0.500   | 54.210 ± 0.078 | **25.010 ± 0.684** |
|         Int String | **26.541 ± 0.090** | 59.609 ± 0.167 |   28.501 ± 2.297   |
|  Medium Int String |   28.746 ± 0.090   | 71.828 ± 1.553 | **28.465 ± 0.063** |
|   Large Int String | **36.052 ± 0.577** | 94.547 ± 0.176 |   40.398 ± 0.656   |
| Small Float String |  146.968 ± 1.049   | 37.084 ± 0.684 | **25.669 ± 0.070** |
|       Float String |  153.535 ± 2.963   | 44.585 ± 0.915 | **25.594 ± 0.444** |
| Large Float String |  156.294 ± 1.972   | 44.134 ± 0.393 | **26.173 ± 0.033** |
|                Int | **17.203 ± 0.223** | 83.751 ± 1.266 |   23.596 ± 3.102   |
|              Float | **29.878 ± 0.484** | 96.626 ± 1.196 |   37.453 ± 1.410   |

### Timing comparison of `float` functions with error handling

| Input type         | try/except (ms)    | regex (ms)      | fastnumbers (ms)   |
| -----------------: | -----------------: | --------------: | -----------------: |
|  Non-number String |   86.598 ± 2.188   |  43.265 ± 0.441 | **30.301 ± 0.510** |
|   Small Int String | **24.443 ± 0.129** |  68.611 ± 1.074 |   28.205 ± 0.410   |
|         Int String | **25.091 ± 0.156** |  72.713 ± 1.277 |   28.181 ± 0.020   |
|  Medium Int String | **26.476 ± 0.443** |  84.210 ± 1.338 |   30.385 ± 0.527   |
|   Large Int String |   59.798 ± 0.776   | 129.196 ± 4.016 | **34.264 ± 0.042** |
| Small Float String | **24.669 ± 0.037** |  66.836 ± 0.335 |   28.762 ± 0.140   |
|       Float String |   44.446 ± 0.272   | 106.354 ± 0.922 | **29.988 ± 0.477** |
| Large Float String |   70.419 ± 0.834   | 140.578 ± 2.404 | **29.939 ± 0.013** |
|                Int | **18.365 ± 0.520** |  89.661 ± 0.248 |   25.445 ± 0.201   |
|              Float | **16.224 ± 0.053** |  84.569 ± 0.986 |   24.075 ± 0.176   |

### Timing comparison of `float` (but coerce to `int` if possible) functions with error handling

| Input type         | try/except (ms) | regex (ms)      | fastnumbers (ms)   |
| -----------------: | --------------: | --------------: | -----------------: |
|  Non-number String |  86.217 ± 1.811 |  70.659 ± 0.354 | **30.530 ± 0.538** |
|   Small Int String |  46.760 ± 4.406 |  59.077 ± 0.471 | **26.990 ± 0.039** |
|         Int String |  47.629 ± 0.241 |  62.973 ± 0.450 | **30.402 ± 0.019** |
|  Medium Int String |  53.415 ± 1.036 |  76.074 ± 0.202 | **30.801 ± 0.401** |
|   Large Int String |  88.056 ± 1.019 |  97.279 ± 0.166 | **42.355 ± 0.724** |
| Small Float String |  43.477 ± 0.078 |  97.574 ± 0.320 | **30.048 ± 0.500** |
|       Float String |  83.666 ± 1.579 | 144.446 ± 1.547 | **39.453 ± 0.069** |
| Large Float String | 145.068 ± 1.037 | 179.341 ± 2.940 | **55.203 ± 0.013** |
|                Int |  39.833 ± 0.133 |  91.357 ± 1.353 | **24.287 ± 0.013** |
|              Float |  64.045 ± 0.957 |  89.551 ± 0.903 | **41.075 ± 0.589** |

### Timing comparison of forced `int` functions with error handling

| Input type         | try/except (ms)    | regex (ms)      | fastnumbers (ms)   |
| -----------------: | -----------------: | --------------: | -----------------: |
|  Non-number String |  241.228 ± 4.085   |  58.840 ± 0.878 | **27.949 ± 0.018** |
|   Small Int String | **25.317 ± 0.071** |  53.246 ± 0.184 |   25.702 ± 0.132   |
|         Int String | **26.905 ± 0.116** |  61.087 ± 1.090 |   29.805 ± 0.170   |
|  Medium Int String |   29.459 ± 0.509   | 111.707 ± 1.462 | **28.635 ± 0.012** |
|   Large Int String | **35.647 ± 0.124** | 158.334 ± 1.366 |   41.489 ± 0.705   |
| Small Float String |  176.308 ± 2.195   |  99.908 ± 0.989 | **32.062 ± 0.445** |
|       Float String |  215.008 ± 2.630   | 157.185 ± 1.461 | **36.764 ± 0.405** |
| Large Float String |  263.093 ± 3.012   | 206.830 ± 2.568 | **53.842 ± 0.325** |
|                Int | **16.723 ± 0.003** |  83.224 ± 1.513 |   21.989 ± 0.276   |
|              Float | **30.218 ± 0.013** |  97.981 ± 0.229 |   37.607 ± 0.312   |

### Timing comparison to check if value can be converted to `int`

| Input type         | try/except (ms) | regex (ms)     | fastnumbers (ms)   |
| -----------------: | --------------: | -------------: | -----------------: |
|  Non-number String | 164.645 ± 1.707 | 64.340 ± 0.903 | **14.118 ± 0.384** |
|   Small Int String |  37.913 ± 0.113 | 66.241 ± 1.006 | **13.837 ± 0.037** |
|         Int String |  40.621 ± 3.173 | 72.188 ± 0.797 | **14.947 ± 0.181** |
|  Medium Int String |  42.431 ± 0.528 | 81.629 ± 0.474 | **14.319 ± 0.041** |
|   Large Int String |  48.527 ± 0.365 | 94.601 ± 0.260 | **14.354 ± 0.053** |
| Small Float String | 148.304 ± 1.714 | 65.467 ± 1.071 | **15.505 ± 0.582** |
|       Float String | 164.616 ± 5.853 | 74.629 ± 0.317 | **16.089 ± 0.054** |
| Large Float String | 159.169 ± 1.457 | 73.413 ± 1.076 | **16.226 ± 0.033** |
|                Int |  29.581 ± 0.058 | 26.854 ± 0.013 | **11.504 ± 0.160** |
|              Float |  40.705 ± 0.248 | 24.453 ± 0.009 | **12.093 ± 0.025** |

### Timing comparison to check if value can be converted to `float`

| Input type         | try/except (ms) | regex (ms)      | fastnumbers (ms)   |
| -----------------: | --------------: | --------------: | -----------------: |
|  Non-number String |  87.710 ± 1.956 |  66.969 ± 0.854 | **15.223 ± 0.168** |
|   Small Int String |  39.015 ± 2.992 |  76.541 ± 1.941 | **15.327 ± 0.005** |
|         Int String |  38.059 ± 0.257 |  79.302 ± 0.555 | **15.884 ± 0.269** |
|  Medium Int String |  40.134 ± 0.556 |  88.587 ± 0.732 | **16.505 ± 0.174** |
|   Large Int String |  66.063 ± 0.600 | 104.385 ± 0.943 | **15.703 ± 0.005** |
| Small Float String |  37.502 ± 0.037 |  71.543 ± 0.026 | **16.306 ± 0.231** |
|       Float String |  57.383 ± 0.776 |  90.858 ± 0.776 | **16.919 ± 0.004** |
| Large Float String |  82.948 ± 0.342 |  98.796 ± 0.982 | **17.069 ± 0.010** |
|                Int |  30.717 ± 1.323 |  27.535 ± 0.263 | **13.278 ± 0.230** |
|              Float |  29.024 ± 0.026 |  24.608 ± 0.003 | **13.467 ± 0.008** |

### Timing comparison to check if value can be converted to `float` or `int`

| Input type         | try/except (ms) | regex (ms)      | fastnumbers (ms)   |
| -----------------: | --------------: | --------------: | -----------------: |
|  Non-number String |  87.172 ± 0.288 |  65.933 ± 1.711 | **15.998 ± 0.549** |
|   Small Int String |  26.965 ± 0.410 |  75.435 ± 0.989 | **14.834 ± 0.039** |
|         Int String |  25.788 ± 0.182 |  78.696 ± 0.833 | **15.114 ± 0.006** |
|  Medium Int String |  28.390 ± 0.627 |  91.569 ± 2.343 | **16.813 ± 0.623** |
|   Large Int String |  56.259 ± 0.737 | 106.234 ± 3.437 | **15.900 ± 0.194** |
| Small Float String |  26.501 ± 0.597 |  72.269 ± 1.234 | **15.918 ± 0.005** |
|       Float String |  50.542 ± 4.783 |  92.018 ± 1.521 | **16.862 ± 0.011** |
| Large Float String |  72.821 ± 0.048 |  96.372 ± 1.293 | **16.956 ± 0.083** |
|                Int |  18.639 ± 0.004 |  24.510 ± 0.346 | **12.780 ± 0.038** |
|              Float |  17.284 ± 0.003 |  22.192 ± 0.001 | **13.135 ± 0.011** |

### Timing comparison to check if value can be coerced losslessly to `int`

| Input type         | try/except (ms) | regex (ms)      | fastnumbers (ms)   |
| -----------------: | --------------: | --------------: | -----------------: |
|  Non-number String | 249.393 ± 6.900 |  59.222 ± 0.532 | **13.682 ± 0.008** |
|   Small Int String |  49.834 ± 0.057 |  39.322 ± 0.723 | **14.296 ± 0.548** |
|         Int String |  52.818 ± 0.769 |  45.349 ± 2.574 | **14.701 ± 0.516** |
|  Medium Int String |  61.189 ± 3.687 |  52.700 ± 0.832 | **14.423 ± 0.226** |
|   Large Int String |  96.325 ± 1.027 |  67.781 ± 0.023 | **14.429 ± 0.498** |
| Small Float String | 178.351 ± 5.251 |  95.877 ± 1.635 | **14.881 ± 0.010** |
|       Float String | 207.616 ± 3.939 | 144.261 ± 2.057 | **15.826 ± 0.018** |
| Large Float String | 241.559 ± 3.013 | 180.959 ± 1.631 | **15.916 ± 0.125** |
|                Int |  33.442 ± 0.147 |  86.692 ± 0.302 | **11.631 ± 0.024** |
|              Float |  61.315 ± 0.411 | 119.964 ± 2.047 | **11.790 ± 0.014** |

### Timing comparison of `map` option vs. iterating over `try_float` for a 50 element list

| Input type         | [try_float(x) for x in iterable] (ms) | list(map(try_float, iterable)) (ms) | list(try_float(iterable, map=True)) (ms) | try_float(iterable, map=list) (ms) |
| -----------------: | ------------------------------------: | ----------------------------------: | ---------------------------------------: | ---------------------------------: |
|  Non-number String |                    1580.005 ± 23.429  |                   1427.914 ± 9.359  |                         615.306 ± 8.174  |               **540.761 ± 3.381**  |
|   Small Int String |                    1515.484 ± 10.359  |                   1383.118 ± 4.676  |                         569.520 ± 26.396 |               **485.451 ± 5.911**  |
|         Int String |                    1537.196 ± 9.088   |                   1393.319 ± 2.614  |                         568.305 ± 1.022  |               **498.157 ± 4.374**  |
|  Medium Int String |                    1564.477 ± 23.196  |                   1326.677 ± 43.593 |                         530.775 ± 1.146  |               **472.142 ± 5.132**  |
|   Large Int String |                    1642.801 ± 6.905   |                   1521.271 ± 4.209  |                         759.358 ± 2.331  |               **687.438 ± 7.948**  |
| Small Float String |                    1404.051 ± 5.686   |                   1277.956 ± 2.678  |                         528.224 ± 1.799  |               **479.139 ± 14.680** |
|       Float String |                    1830.355 ± 241.915 |                   1529.138 ± 26.605 |                         659.732 ± 6.407  |               **584.900 ± 3.662**  |
| Large Float String |                    1690.406 ± 31.057  |                   1555.036 ± 11.756 |                         675.239 ± 12.731 |               **598.319 ± 12.562** |
|                Int |                    1435.160 ± 32.353  |                   1280.176 ± 13.279 |                         466.837 ± 15.609 |               **382.573 ± 1.323**  |
|              Float |                    1327.409 ± 20.466  |                   1182.671 ± 35.221 |                         366.099 ± 2.272  |               **302.390 ± 0.241**  |

### Timing comparison of `try_array` vs. `map` option for a 50 element list to a numpy array

| Input type         | np.array(try_float(iterable, map=True)) (ms) | try_array(iterable) (ms) | try_array(iterable, output) (ms) |
| -----------------: | -------------------------------------------: | -----------------------: | -------------------------------: |
|   Small Int String |                             662.536 ± 10.492 |          304.161 ± 3.486 |              **285.220 ± 8.227** |
|         Int String |                             671.805 ± 3.570  |          320.196 ± 5.383 |              **297.441 ± 0.427** |
|  Medium Int String |                             686.088 ± 7.358  |          326.836 ± 0.707 |              **306.003 ± 1.717** |
|   Large Int String |                             901.139 ± 3.296  |          549.774 ± 1.708 |              **524.948 ± 0.696** |
| Small Float String |                             676.264 ± 0.818  |          337.833 ± 9.456 |              **316.153 ± 7.326** |
|       Float String |                             781.376 ± 8.174  |          432.953 ± 5.851 |              **421.327 ± 5.367** |
| Large Float String |                             828.351 ± 6.087  |          457.716 ± 1.902 |              **434.577 ± 4.817** |
|                Int |                             615.707 ± 0.547  |          367.986 ± 2.431 |              **341.711 ± 5.491** |
|              Float |                             567.293 ± 2.903  |          305.593 ± 4.210 |              **281.619 ± 2.427** |

