/**
 * npm_install_proxy -- localhost NPM registry to `npm install` without network
 *
 * Copyright (C) 2020  SUSE LLC
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
*/
/// <reference types="node" />
import { URL } from 'url';
export type PkgJsonRW = {
    name: string;
    version: string;
    dist: {
        tarball: string;
        integrity: string;
    };
};
export type PkgJson = Readonly<PkgJsonRW>;
export interface RegistryBackend {
    extractPkgJson(path: string): Promise<PkgJson[]>;
}
export interface RequestHandler {
    readonly url: URL;
}
export declare class Registry {
    private pkgs;
    private backends;
    private requestHandler;
    constructor();
    addBackend(backend: RegistryBackend): void;
    set serviceProvider(service: RequestHandler);
    fetchPackages(): any[];
    fetchVersions(pkg_name: string): Object;
    fetchPkgVersion(pkg_name: string, version: string): Object;
    private static verifyPkgJsonType;
    private commitPkgJson;
    private processPathWithBackend;
    register(path: string): Promise<number>;
    archiveFile(file: string): (string | null);
}
