; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=verify,iroutliner -ir-outlining-no-cost < %s | FileCheck %s

; This test looks at the constants in the regions, and if it they are the
; same it outlines them as constants rather than elevating them to arguments.

define void @outline_constants1() {
; CHECK-LABEL: @outline_constants1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[B:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[C:%.*]] = alloca i32, align 4
; CHECK-NEXT:    call void @[[FUNCTION_0:.*]](ptr [[A]], ptr [[B]], ptr [[C]])
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca i32, align 4
  %b = alloca i32, align 4
  %c = alloca i32, align 4
  store i32 2, ptr %a, align 4
  store i32 3, ptr %b, align 4
  store i32 4, ptr %c, align 4
  %al = load i32, ptr %a
  %bl = load i32, ptr %b
  %cl = load i32, ptr %c
  ret void
}

define void @outline_constants2() {
; CHECK-LABEL: @outline_constants2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[B:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[C:%.*]] = alloca i32, align 4
; CHECK-NEXT:    call void @[[FUNCTION_0]](ptr [[A]], ptr [[B]], ptr [[C]])
; CHECK-NEXT:    ret void
;
entry:
  %a = alloca i32, align 4
  %b = alloca i32, align 4
  %c = alloca i32, align 4
  store i32 2, ptr %a, align 4
  store i32 3, ptr %b, align 4
  store i32 4, ptr %c, align 4
  %al = load i32, ptr %a
  %bl = load i32, ptr %b
  %cl = load i32, ptr %c
  ret void
}

; CHECK: define internal void @[[FUNCTION_0]](ptr [[ARG0:%.*]], ptr [[ARG1:%.*]], ptr [[ARG2:%.*]])
; CHECK: entry_to_outline:
; CHECK-NEXT:    store i32 2, ptr [[ARG0]], align 4
; CHECK-NEXT:    store i32 3, ptr [[ARG1]], align 4
; CHECK-NEXT:    store i32 4, ptr [[ARG2]], align 4
; CHECK-NEXT:    [[AL:%.*]] = load i32, ptr [[ARG0]], align 4
; CHECK-NEXT:    [[BL:%.*]] = load i32, ptr [[ARG1]], align 4
; CHECK-NEXT:    [[CL:%.*]] = load i32, ptr [[ARG2]], align 4
