; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -vector-library=sleefgnuabi -replace-with-veclib -S < %s | FileCheck %s

target triple = "aarch64-unknown-linux-gnu"

define <2 x double> @llvm_sqrt_f64(<2 x double> %in) {
; CHECK-LABEL: define {{[^@]+}}@llvm_sqrt_f64
; CHECK-SAME: (<2 x double> [[IN:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <2 x double> @llvm.sqrt.v2f64(<2 x double> [[IN]])
; CHECK-NEXT:    ret <2 x double> [[TMP1]]
;
  %1 = call fast <2 x double> @llvm.sqrt.v2f64(<2 x double> %in)
  ret <2 x double> %1
}

define <4 x float> @llvm_sqrt_f32(<4 x float> %in) {
; CHECK-LABEL: define {{[^@]+}}@llvm_sqrt_f32
; CHECK-SAME: (<4 x float> [[IN:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <4 x float> @llvm.sqrt.v4f32(<4 x float> [[IN]])
; CHECK-NEXT:    ret <4 x float> [[TMP1]]
;
  %1 = call fast <4 x float> @llvm.sqrt.v4f32(<4 x float> %in)
  ret <4 x float> %1
}

define <vscale x 2 x double> @llvm_sqrt_vscale_f64(<vscale x 2 x double> %in) {
; CHECK-LABEL: define {{[^@]+}}@llvm_sqrt_vscale_f64
; CHECK-SAME: (<vscale x 2 x double> [[IN:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 2 x double> @llvm.sqrt.nxv2f64(<vscale x 2 x double> [[IN]])
; CHECK-NEXT:    ret <vscale x 2 x double> [[TMP1]]
;
  %1 = call fast <vscale x 2 x double> @llvm.sqrt.nxv2f64(<vscale x 2 x double> %in)
  ret <vscale x 2 x double> %1
}

define <vscale x 4 x float> @llvm_sqrt_vscale_f32(<vscale x 4 x float> %in) {
; CHECK-LABEL: define {{[^@]+}}@llvm_sqrt_vscale_f32
; CHECK-SAME: (<vscale x 4 x float> [[IN:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <vscale x 4 x float> @llvm.sqrt.nxv4f32(<vscale x 4 x float> [[IN]])
; CHECK-NEXT:    ret <vscale x 4 x float> [[TMP1]]
;
  %1 = call fast <vscale x 4 x float> @llvm.sqrt.nxv4f32(<vscale x 4 x float> %in)
  ret <vscale x 4 x float> %1
}


declare <2 x double> @llvm.sqrt.v2f64(<2 x double>)
declare <4 x float> @llvm.sqrt.v4f32(<4 x float>)
declare <vscale x 2 x double> @llvm.sqrt.nxv2f64(<vscale x 2 x double>)
declare <vscale x 4 x float> @llvm.sqrt.nxv4f32(<vscale x 4 x float>)
