/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.mozilla;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.OptimizationEnum;
import net.sf.antcontrib.cpptasks.VersionInfo;
import net.sf.antcontrib.cpptasks.compiler.CommandLineCompiler;
import net.sf.antcontrib.cpptasks.compiler.CommandLineCompilerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.compiler.Processor;
import net.sf.antcontrib.cpptasks.compiler.ProgressMonitor;
import net.sf.antcontrib.cpptasks.gcc.LdLinker;
import net.sf.antcontrib.cpptasks.parser.CParser;
import net.sf.antcontrib.cpptasks.parser.Parser;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Environment;

public final class XpidlCompiler
extends CommandLineCompiler {
    private static final XpidlCompiler INSTANCE = new XpidlCompiler(false, null);

    public static XpidlCompiler getInstance() {
        return INSTANCE;
    }

    private XpidlCompiler(boolean newEnvironment, Environment env) {
        super("xpidl", null, new String[]{".idl", ".xpidl"}, new String[0], ".xpt", false, null, newEnvironment, env);
    }

    protected void addImpliedArgs(Vector args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
    }

    protected void addWarningSwitch(Vector args, int level) {
    }

    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        return this;
    }

    protected Parser createParser(File source) {
        return new CParser();
    }

    protected int getArgumentCountPerInputFile() {
        return 3;
    }

    public String[] getOutputFileNames(String inputFile, VersionInfo versionInfo) {
        String baseName = this.getBaseOutputName(inputFile);
        return new String[]{String.valueOf(baseName) + ".xpt", String.valueOf(baseName) + ".h"};
    }

    protected String getInputFileArgument(File outputDir, String filename, int index) {
        return "";
    }

    public int getMaximumCommandLength() {
        return 1024;
    }

    protected int getMaximumInputFilesPerCommand() {
        return 1;
    }

    protected void addIncludes(String baseDirPath, File[] includeDirs, Vector args, Vector relativeArgs, StringBuffer includePathId) {
        int i = 0;
        while (i < includeDirs.length) {
            args.addElement("-I");
            args.addElement(includeDirs[i].getAbsolutePath());
            if (relativeArgs != null) {
                String relative = CUtil.getRelativePath(baseDirPath, includeDirs[i]);
                relativeArgs.addElement("-I");
                relativeArgs.addElement(relative);
                if (includePathId != null) {
                    if (includePathId.length() == 0) {
                        includePathId.append("-I ");
                    } else {
                        includePathId.append(" -I ");
                    }
                    includePathId.append(relative);
                }
            }
            ++i;
        }
    }

    protected String getIncludeDirSwitch(String includeDir) {
        return "-I" + includeDir;
    }

    protected void getDefineSwitch(StringBuffer buffer, String define, String value) {
    }

    protected void getUndefineSwitch(StringBuffer buffer, String define) {
    }

    protected File[] getEnvironmentIncludePath() {
        return new File[0];
    }

    public Linker getLinker(LinkType type) {
        return LdLinker.getInstance();
    }

    public void compile(CCTask task, File outputDir, String[] sourceFiles, String[] args, String[] endArgs, boolean relentless, CommandLineCompilerConfiguration config, ProgressMonitor monitor) {
        BuildException exc = null;
        String[] thisSource = new String[1];
        String[] tlbCommand = new String[args.length + endArgs.length + 6];
        tlbCommand[0] = "xpidl";
        tlbCommand[1] = "-m";
        tlbCommand[2] = "typelib";
        String[] headerCommand = new String[args.length + endArgs.length + 6];
        headerCommand[0] = "xpidl";
        headerCommand[1] = "-m";
        headerCommand[2] = "header";
        int i = 0;
        while (i < args.length) {
            tlbCommand[i + 3] = args[i];
            headerCommand[i + 3] = args[i];
            ++i;
        }
        tlbCommand[args.length + 3] = "-e";
        headerCommand[args.length + 3] = "-e";
        int tlbIndex = args.length + 6;
        int headerIndex = args.length + 6;
        int i2 = 0;
        while (i2 < endArgs.length) {
            tlbCommand[tlbIndex++] = endArgs[i2];
            headerCommand[headerIndex++] = endArgs[i2];
            ++i2;
        }
        int j = 0;
        while (j < sourceFiles.length) {
            tlbIndex = args.length + 4;
            headerIndex = args.length + 4;
            String[] outputFileNames = this.getOutputFileNames(sourceFiles[j], null);
            tlbCommand[tlbIndex++] = outputFileNames[0];
            tlbCommand[tlbIndex++] = sourceFiles[j];
            headerCommand[headerIndex++] = outputFileNames[1];
            headerCommand[headerIndex++] = sourceFiles[j];
            int retval = this.runCommand(task, outputDir, tlbCommand);
            if (retval == 0) {
                retval = this.runCommand(task, outputDir, headerCommand);
            }
            if (monitor != null) {
                thisSource[0] = sourceFiles[j];
                monitor.progress(thisSource);
            }
            if (retval != 0 && exc == null) {
                exc = new BuildException(String.valueOf(this.getCommand()) + " failed with return code " + retval, task.getLocation());
                if (!relentless) {
                    throw exc;
                }
            }
            ++j;
        }
        if (exc != null) {
            throw exc;
        }
    }

    protected int getTotalArgumentLengthForInputFile(File outputDir, String inputFile) {
        return 0;
    }

    public String getIdentifier() {
        return "Mozilla xpidl";
    }
}

