/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.Action;
import JFlex.EOFActions;
import JFlex.ErrorMessages;
import JFlex.GeneratorException;
import JFlex.LexParse;
import JFlex.LexScan;
import JFlex.Main;
import JFlex.Out;
import JFlex.StatePairList;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public final class DFA
implements ErrorMessages {
    private static final int STATES = 500;
    public static final int NO_TARGET = -1;
    int[][] table;
    boolean[] isFinal;
    boolean[] isPushback;
    boolean[] isLookEnd;
    Action[] action;
    int[] lexState;
    int numStates;
    int numInput;
    Hashtable usedActions = new Hashtable();

    public DFA(int numLexStates, int numInp) {
        this.numInput = numInp;
        int statesNeeded = Math.max(numLexStates, 500);
        this.table = new int[statesNeeded][this.numInput];
        this.action = new Action[statesNeeded];
        this.isFinal = new boolean[statesNeeded];
        this.isPushback = new boolean[statesNeeded];
        this.isLookEnd = new boolean[statesNeeded];
        this.lexState = new int[numLexStates];
        this.numStates = 0;
        int i = 0;
        while (i < statesNeeded) {
            int j = 0;
            while (j < this.numInput) {
                this.table[i][j] = -1;
                j = (char)(j + 1);
            }
            ++i;
        }
    }

    public void setLexState(int lState, int trueState) {
        this.lexState[lState] = trueState;
    }

    private void ensureStateCapacity(int newNumStates) {
        int oldLength = this.isFinal.length;
        if (newNumStates < oldLength) {
            return;
        }
        int newLength = oldLength * 2;
        while (newLength <= newNumStates) {
            newLength *= 2;
        }
        boolean[] newFinal = new boolean[newLength];
        boolean[] newPushback = new boolean[newLength];
        boolean[] newLookEnd = new boolean[newLength];
        Action[] newAction = new Action[newLength];
        int[][] newTable = new int[newLength][this.numInput];
        System.arraycopy(this.isFinal, 0, newFinal, 0, this.numStates);
        System.arraycopy(this.isPushback, 0, newPushback, 0, this.numStates);
        System.arraycopy(this.isLookEnd, 0, newLookEnd, 0, this.numStates);
        System.arraycopy(this.action, 0, newAction, 0, this.numStates);
        System.arraycopy(this.table, 0, newTable, 0, oldLength);
        int i = oldLength;
        while (i < newLength) {
            int j = 0;
            while (j < this.numInput) {
                newTable[i][j] = -1;
                ++j;
            }
            ++i;
        }
        this.isFinal = newFinal;
        this.isPushback = newPushback;
        this.isLookEnd = newLookEnd;
        this.action = newAction;
        this.table = newTable;
    }

    public void setAction(int state, Action stateAction) {
        this.action[state] = stateAction;
        if (stateAction != null) {
            this.isLookEnd[state] = stateAction.isLookAction;
            this.usedActions.put(stateAction, stateAction);
        }
    }

    public void setFinal(int state, boolean isFinalState) {
        this.isFinal[state] = isFinalState;
    }

    public void setPushback(int state, boolean isPushbackState) {
        this.isPushback[state] = isPushbackState;
    }

    public void addTransition(int start, char input, int dest) {
        int max = Math.max(start, dest) + 1;
        this.ensureStateCapacity(max);
        if (max > this.numStates) {
            this.numStates = max;
        }
        this.table[start][input] = dest;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.numStates) {
            result.append("State ");
            if (this.isFinal[i]) {
                result.append("[FINAL] ");
            }
            if (this.isPushback[i]) {
                result.append("[PUSH] ");
            }
            result.append(i + ":" + Out.NL);
            int j = 0;
            while (j < this.numInput) {
                if (this.table[i][j] >= 0) {
                    result.append("  with " + j + " in " + this.table[i][j] + Out.NL);
                }
                j = (char)(j + 1);
            }
            ++i;
        }
        return result.toString();
    }

    public void writeDot(File file) {
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(file));
            writer.println(this.dotFormat());
            writer.close();
        }
        catch (IOException e) {
            Out.error(41, file);
            throw new GeneratorException();
        }
    }

    public String dotFormat() {
        StringBuffer result = new StringBuffer();
        result.append("digraph DFA {" + Out.NL);
        result.append("rankdir = LR" + Out.NL);
        int i = 0;
        while (i < this.numStates) {
            if (this.isFinal[i] || this.isPushback[i]) {
                result.append(i);
            }
            if (this.isFinal[i]) {
                result.append(" [shape = doublecircle]");
            }
            if (this.isPushback[i]) {
                result.append(" [shape = box]");
            }
            if (this.isFinal[i] || this.isPushback[i]) {
                result.append(Out.NL);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.numStates) {
            int input = 0;
            while (input < this.numInput) {
                if (this.table[i2][input] >= 0) {
                    result.append(i2 + " -> " + this.table[i2][input]);
                    result.append(" [label=\"[" + input + "]\"]" + Out.NL);
                }
                ++input;
            }
            ++i2;
        }
        result.append("}" + Out.NL);
        return result.toString();
    }

    public void checkActions(LexScan scanner, LexParse parser) {
        EOFActions eofActions = parser.getEOFActions();
        Enumeration l = scanner.actions.elements();
        while (l.hasMoreElements()) {
            Object next = l.nextElement();
            if (this.usedActions.get(next) == next || eofActions.isEOFAction(next)) continue;
            Out.warning(scanner.file, 43, ((Action)next).priority - 1, -1);
        }
    }

    public void minimize() {
        int last;
        int s;
        int n = this.numStates + 1;
        int[] block = new int[2 * n];
        int[] b_forward = new int[2 * n];
        int[] b_backward = new int[2 * n];
        int lastBlock = n;
        int b0 = n;
        int[] l_forward = new int[n * this.numInput + 1];
        int[] l_backward = new int[n * this.numInput + 1];
        int anchorL = n * this.numInput;
        int[][] inv_delta = new int[n][this.numInput];
        int[] inv_delta_set = new int[2 * n * this.numInput];
        int[] twin = new int[2 * n];
        int[] SD = new int[2 * n];
        int[] D = new int[n];
        Out.print(this.numStates + " states before minimization, ");
        int lastDelta = 0;
        int[] inv_lists = new int[n];
        int[] inv_list_last = new int[n];
        int c = 0;
        while (c < this.numInput) {
            s = 0;
            while (s < n) {
                inv_list_last[s] = -1;
                inv_delta[s][c] = -1;
                ++s;
            }
            inv_delta[0][c] = 0;
            inv_list_last[0] = 0;
            int s2 = 1;
            while (s2 < n) {
                int t = this.table[s2 - 1][c] + 1;
                if (inv_list_last[t] == -1) {
                    inv_delta[t][c] = s2;
                    inv_list_last[t] = s2;
                } else {
                    inv_lists[inv_list_last[t]] = s2;
                    inv_list_last[t] = s2;
                }
                ++s2;
            }
            int s3 = 0;
            while (s3 < n) {
                int i = inv_delta[s3][c];
                inv_delta[s3][c] = lastDelta;
                int j = inv_list_last[s3];
                boolean go_on = i != -1;
                while (go_on) {
                    go_on = i != j;
                    inv_delta_set[lastDelta++] = i;
                    i = inv_lists[i];
                }
                inv_delta_set[lastDelta++] = -1;
                ++s3;
            }
            ++c;
        }
        b_forward[b0] = 0;
        b_backward[b0] = 0;
        b_forward[0] = b0;
        b_backward[0] = b0;
        block[0] = b0;
        block[b0] = 1;
        s = 1;
        while (s < n) {
            int b = b0 + 1;
            boolean found = false;
            while (!found && b <= lastBlock) {
                int t = b_forward[b];
                boolean bl = found = this.isPushback[s - 1] == this.isPushback[t - 1] && this.isLookEnd[s - 1] == this.isLookEnd[t - 1];
                if (found) {
                    if (this.isFinal[s - 1]) {
                        found = this.isFinal[t - 1] && this.action[s - 1].isEquiv(this.action[t - 1]);
                    } else {
                        boolean bl2 = found = !this.isFinal[t - 1];
                    }
                    if (found) {
                        block[s] = b;
                        int n2 = b;
                        block[n2] = block[n2] + 1;
                        last = b_backward[b];
                        b_forward[last] = s;
                        b_forward[s] = b;
                        b_backward[b] = s;
                        b_backward[s] = last;
                    }
                }
                ++b;
            }
            if (!found) {
                block[s] = b;
                int n3 = b;
                block[n3] = block[n3] + 1;
                b_forward[b] = s;
                b_forward[s] = b;
                b_backward[b] = s;
                b_backward[s] = b;
                ++lastBlock;
            }
            ++s;
        }
        int B_max = b0;
        int B_i = b0 + 1;
        while (B_i <= lastBlock) {
            if (block[B_max] < block[B_i]) {
                B_max = B_i;
            }
            ++B_i;
        }
        l_forward[anchorL] = anchorL;
        l_backward[anchorL] = anchorL;
        B_i = B_max == b0 ? b0 + 1 : b0;
        int index = (B_i - b0) * this.numInput;
        while (index < (B_i + 1 - b0) * this.numInput) {
            last = l_backward[anchorL];
            l_forward[last] = index;
            l_forward[index] = anchorL;
            l_backward[index] = last;
            l_backward[anchorL] = index++;
        }
        while (B_i <= lastBlock) {
            if (B_i != B_max) {
                index = (B_i - b0) * this.numInput;
                while (index < (B_i + 1 - b0) * this.numInput) {
                    last = l_backward[anchorL];
                    l_forward[last] = index;
                    l_forward[index] = anchorL;
                    l_backward[index] = last;
                    l_backward[anchorL] = index++;
                }
            }
            ++B_i;
        }
        while (l_forward[anchorL] != anchorL) {
            int B_j_a = l_forward[anchorL];
            l_forward[anchorL] = l_forward[B_j_a];
            l_backward[l_forward[anchorL]] = anchorL;
            l_forward[B_j_a] = 0;
            int B_j = b0 + B_j_a / this.numInput;
            int a = B_j_a % this.numInput;
            int numD = 0;
            int s4 = b_forward[B_j];
            while (s4 != B_j) {
                int t = inv_delta[s4][a];
                while (inv_delta_set[t] != -1) {
                    D[numD++] = inv_delta_set[t++];
                }
                s4 = b_forward[s4];
            }
            int numSplit = 0;
            int indexD = 0;
            while (indexD < numD) {
                s4 = D[indexD];
                B_i = block[s4];
                SD[B_i] = -1;
                twin[B_i] = 0;
                ++indexD;
            }
            int indexD2 = 0;
            while (indexD2 < numD) {
                s4 = D[indexD2];
                B_i = block[s4];
                if (SD[B_i] < 0) {
                    SD[B_i] = 0;
                    int t = b_forward[B_i];
                    while (!(t == B_i || t == 0 && block[0] != B_j || t != 0 && block[this.table[t - 1][a] + 1] != B_j)) {
                        int n4 = B_i;
                        SD[n4] = SD[n4] + 1;
                        t = b_forward[t];
                    }
                }
                ++indexD2;
            }
            int indexD3 = 0;
            while (indexD3 < numD) {
                s4 = D[indexD3];
                B_i = block[s4];
                if (SD[B_i] != block[B_i]) {
                    int B_k = twin[B_i];
                    if (B_k == 0) {
                        b_forward[B_k] = B_k = ++lastBlock;
                        b_backward[B_k] = B_k;
                        twin[B_i] = B_k;
                        twin[numSplit++] = B_i;
                    }
                    b_forward[b_backward[s4]] = b_forward[s4];
                    b_backward[b_forward[s4]] = b_backward[s4];
                    int last2 = b_backward[B_k];
                    b_forward[last2] = s4;
                    b_forward[s4] = B_k;
                    b_backward[s4] = last2;
                    b_backward[B_k] = s4;
                    block[s4] = B_k;
                    int n5 = B_k;
                    block[n5] = block[n5] + 1;
                    int n6 = B_i;
                    block[n6] = block[n6] - 1;
                    int n7 = B_i;
                    SD[n7] = SD[n7] - 1;
                }
                ++indexD3;
            }
            int indexTwin = 0;
            while (indexTwin < numSplit) {
                B_i = twin[indexTwin];
                int B_k = twin[B_i];
                int c2 = 0;
                while (c2 < this.numInput) {
                    int last3;
                    int B_i_c = (B_i - b0) * this.numInput + c2;
                    int B_k_c = (B_k - b0) * this.numInput + c2;
                    if (l_forward[B_i_c] > 0) {
                        last3 = l_backward[anchorL];
                        l_backward[anchorL] = B_k_c;
                        l_forward[last3] = B_k_c;
                        l_backward[B_k_c] = last3;
                        l_forward[B_k_c] = anchorL;
                    } else if (block[B_i] <= block[B_k]) {
                        last3 = l_backward[anchorL];
                        l_backward[anchorL] = B_i_c;
                        l_forward[last3] = B_i_c;
                        l_backward[B_i_c] = last3;
                        l_forward[B_i_c] = anchorL;
                    } else {
                        last3 = l_backward[anchorL];
                        l_backward[anchorL] = B_k_c;
                        l_forward[last3] = B_k_c;
                        l_backward[B_k_c] = last3;
                        l_forward[B_k_c] = anchorL;
                    }
                    ++c2;
                }
                ++indexTwin;
            }
        }
        int[] trans = new int[this.numStates];
        boolean[] kill = new boolean[this.numStates];
        int[] move = new int[this.numStates];
        int b = b0 + 1;
        while (b <= lastBlock) {
            int s5;
            int min_s = s5 = b_forward[b];
            while (s5 != b) {
                if (min_s > s5) {
                    min_s = s5;
                }
                s5 = b_forward[s5];
            }
            --min_s;
            s5 = b_forward[b] - 1;
            while (s5 != b - 1) {
                trans[s5] = min_s;
                kill[s5] = s5 != min_s;
                s5 = b_forward[s5 + 1] - 1;
            }
            ++b;
        }
        int amount = 0;
        int i = 0;
        while (i < this.numStates) {
            if (kill[i]) {
                ++amount;
            } else {
                move[i] = amount;
            }
            ++i;
        }
        int i2 = 0;
        int j = 0;
        while (i2 < this.numStates) {
            if (!kill[i2]) {
                int c3 = 0;
                while (c3 < this.numInput) {
                    if (this.table[i2][c3] >= 0) {
                        this.table[j][c3] = trans[this.table[i2][c3]];
                        int[] nArray = this.table[j];
                        int n8 = c3;
                        nArray[n8] = nArray[n8] - move[this.table[j][c3]];
                    } else {
                        this.table[j][c3] = this.table[i2][c3];
                    }
                    ++c3;
                }
                this.isFinal[j] = this.isFinal[i2];
                this.isPushback[j] = this.isPushback[i2];
                this.isLookEnd[j] = this.isLookEnd[i2];
                this.action[j] = this.action[i2];
                ++j;
            }
            ++i2;
        }
        this.numStates = j;
        i2 = 0;
        while (i2 < this.lexState.length) {
            this.lexState[i2] = trans[this.lexState[i2]];
            int n9 = i2;
            this.lexState[n9] = this.lexState[n9] - move[this.lexState[i2]];
            ++i2;
        }
        Out.println(this.numStates + " states in minimized DFA");
    }

    public String toString(int[] a) {
        String r = "{";
        int i = 0;
        while (i < a.length - 1) {
            r = r + a[i] + ",";
            ++i;
        }
        return r + a[i] + "}";
    }

    public void printBlocks(int[] b, int[] b_f, int[] b_b, int last) {
        int n;
        Out.dump("block     : " + this.toString(b));
        Out.dump("b_forward : " + this.toString(b_f));
        Out.dump("b_backward: " + this.toString(b_b));
        Out.dump("lastBlock : " + last);
        int i = n = this.numStates + 1;
        while (i <= last) {
            Out.dump("Block " + (i - n) + " (size " + b[i] + "):");
            String line = "{";
            int s = b_f[i];
            while (s != i) {
                line = line + (s - 1);
                int t = s;
                if ((s = b_f[s]) != i) {
                    line = line + ",";
                    if (b[s] != i) {
                        Out.dump("consistency error for state " + (s - 1) + " (block " + b[s] + ")");
                    }
                }
                if (b_b[s] == t) continue;
                Out.dump("consistency error for b_back in state " + (s - 1) + " (back = " + b_b[s] + ", should be = " + t + ")");
            }
            Out.dump(line + "}");
            ++i;
        }
    }

    public void printL(int[] l_f, int[] l_b, int anchor) {
        String l = "L = {";
        int bc = l_f[anchor];
        while (bc != anchor) {
            int b = bc / this.numInput;
            int c = bc % this.numInput;
            l = l + "(" + b + "," + c + ")";
            int old_bc = bc;
            if ((bc = l_f[bc]) != anchor) {
                l = l + ",";
            }
            if (l_b[bc] == old_bc) continue;
            Out.dump("consistency error for (" + b + "," + c + ")");
        }
        Out.dump(l + "}");
    }

    public boolean[][] old_minimize() {
        int j;
        Out.print(this.numStates + " states before minimization, ");
        if (this.numStates == 0) {
            Out.error(37);
            throw new GeneratorException();
        }
        if (Main.no_minimize) {
            Out.println("minimization skipped.");
            return null;
        }
        boolean[][] equiv = new boolean[this.numStates][];
        StatePairList[][] list = new StatePairList[this.numStates][];
        int i = 1;
        while (i < this.numStates) {
            list[i] = new StatePairList[i];
            equiv[i] = new boolean[i];
            j = 0;
            while (j < i) {
                equiv[i][j] = this.isFinal[i] && this.isFinal[j] && this.isPushback[i] == this.isPushback[j] && this.isLookEnd[i] == this.isLookEnd[j] ? this.action[i].isEquiv(this.action[j]) : !this.isFinal[j] && !this.isFinal[i] && this.isPushback[i] == this.isPushback[j] && this.isLookEnd[i] == this.isLookEnd[j];
                ++j;
            }
            ++i;
        }
        i = 1;
        while (i < this.numStates) {
            Out.debug("Testing state " + i);
            j = 0;
            while (j < i) {
                if (equiv[i][j]) {
                    int t;
                    int q;
                    int p;
                    int c = 0;
                    while (c < this.numInput) {
                        if (equiv[i][j]) {
                            p = this.table[i][c];
                            q = this.table[j][c];
                            if (p < q) {
                                t = p;
                                p = q;
                                q = t;
                            }
                            if (!(p < 0 && q < 0 || p == q || p != -1 && q != -1 && equiv[p][q])) {
                                equiv[i][j] = false;
                                if (list[i][j] != null) {
                                    list[i][j].markAll(list, equiv);
                                }
                            }
                        }
                        c = (char)(c + 1);
                    }
                    if (equiv[i][j]) {
                        c = 0;
                        while (c < this.numInput) {
                            p = this.table[i][c];
                            q = this.table[j][c];
                            if (p < q) {
                                t = p;
                                p = q;
                                q = t;
                            }
                            if (p != q && p >= 0 && q >= 0) {
                                if (list[p][q] == null) {
                                    list[p][q] = new StatePairList();
                                }
                                list[p][q].addPair(i, j);
                            }
                            c = (char)(c + 1);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return equiv;
    }

    public void printInvDelta(int[][] inv_delta, int[] inv_delta_set) {
        Out.dump("Inverse of transition table: ");
        int s = 0;
        while (s < this.numStates + 1) {
            Out.dump("State [" + (s - 1) + "]");
            int c = 0;
            while (c < this.numInput) {
                String line = "With <" + c + "> in {";
                int t = inv_delta[s][c];
                while (inv_delta_set[t] != -1) {
                    line = line + (inv_delta_set[t++] - 1);
                    if (inv_delta_set[t] == -1) continue;
                    line = line + ",";
                }
                if (inv_delta_set[inv_delta[s][c]] != -1) {
                    Out.dump(line + "}");
                }
                ++c;
            }
            ++s;
        }
    }

    public void printTable(boolean[][] equiv) {
        Out.dump("Equivalence table is : ");
        int i = 1;
        while (i < this.numStates) {
            String line = i + " :";
            int j = 0;
            while (j < i) {
                line = equiv[i][j] ? line + " E" : line + " x";
                ++j;
            }
            Out.dump(line);
            ++i;
        }
    }
}

