// Copyright 2023 LiveKit, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.23.4
// source: livekit_agent.proto

package livekit

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type JobType int32

const (
	JobType_JT_ROOM      JobType = 0
	JobType_JT_PUBLISHER JobType = 1
)

// Enum value maps for JobType.
var (
	JobType_name = map[int32]string{
		0: "JT_ROOM",
		1: "JT_PUBLISHER",
	}
	JobType_value = map[string]int32{
		"JT_ROOM":      0,
		"JT_PUBLISHER": 1,
	}
)

func (x JobType) Enum() *JobType {
	p := new(JobType)
	*p = x
	return p
}

func (x JobType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JobType) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_agent_proto_enumTypes[0].Descriptor()
}

func (JobType) Type() protoreflect.EnumType {
	return &file_livekit_agent_proto_enumTypes[0]
}

func (x JobType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JobType.Descriptor instead.
func (JobType) EnumDescriptor() ([]byte, []int) {
	return file_livekit_agent_proto_rawDescGZIP(), []int{0}
}

type WorkerStatus int32

const (
	WorkerStatus_WS_AVAILABLE WorkerStatus = 0
	WorkerStatus_WS_FULL      WorkerStatus = 1
)

// Enum value maps for WorkerStatus.
var (
	WorkerStatus_name = map[int32]string{
		0: "WS_AVAILABLE",
		1: "WS_FULL",
	}
	WorkerStatus_value = map[string]int32{
		"WS_AVAILABLE": 0,
		"WS_FULL":      1,
	}
)

func (x WorkerStatus) Enum() *WorkerStatus {
	p := new(WorkerStatus)
	*p = x
	return p
}

func (x WorkerStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WorkerStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_agent_proto_enumTypes[1].Descriptor()
}

func (WorkerStatus) Type() protoreflect.EnumType {
	return &file_livekit_agent_proto_enumTypes[1]
}

func (x WorkerStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WorkerStatus.Descriptor instead.
func (WorkerStatus) EnumDescriptor() ([]byte, []int) {
	return file_livekit_agent_proto_rawDescGZIP(), []int{1}
}

type JobStatus int32

const (
	JobStatus_JS_UNKNOWN JobStatus = 0
	JobStatus_JS_SUCCESS JobStatus = 1
	JobStatus_JS_FAILED  JobStatus = 2
)

// Enum value maps for JobStatus.
var (
	JobStatus_name = map[int32]string{
		0: "JS_UNKNOWN",
		1: "JS_SUCCESS",
		2: "JS_FAILED",
	}
	JobStatus_value = map[string]int32{
		"JS_UNKNOWN": 0,
		"JS_SUCCESS": 1,
		"JS_FAILED":  2,
	}
)

func (x JobStatus) Enum() *JobStatus {
	p := new(JobStatus)
	*p = x
	return p
}

func (x JobStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JobStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_livekit_agent_proto_enumTypes[2].Descriptor()
}

func (JobStatus) Type() protoreflect.EnumType {
	return &file_livekit_agent_proto_enumTypes[2]
}

func (x JobStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JobStatus.Descriptor instead.
func (JobStatus) EnumDescriptor() ([]byte, []int) {
	return file_livekit_agent_proto_rawDescGZIP(), []int{2}
}

type AgentInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id      string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Name    string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *AgentInfo) Reset() {
	*x = AgentInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_agent_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AgentInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentInfo) ProtoMessage() {}

func (x *AgentInfo) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_agent_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentInfo.ProtoReflect.Descriptor instead.
func (*AgentInfo) Descriptor() ([]byte, []int) {
	return file_livekit_agent_proto_rawDescGZIP(), []int{0}
}

func (x *AgentInfo) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *AgentInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AgentInfo) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type Job struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id          string           `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Type        JobType          `protobuf:"varint,2,opt,name=type,proto3,enum=livekit.JobType" json:"type,omitempty"`
	Room        *Room            `protobuf:"bytes,3,opt,name=room,proto3" json:"room,omitempty"`
	Participant *ParticipantInfo `protobuf:"bytes,4,opt,name=participant,proto3,oneof" json:"participant,omitempty"`
}

func (x *Job) Reset() {
	*x = Job{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_agent_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Job) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Job) ProtoMessage() {}

func (x *Job) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_agent_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Job.ProtoReflect.Descriptor instead.
func (*Job) Descriptor() ([]byte, []int) {
	return file_livekit_agent_proto_rawDescGZIP(), []int{1}
}

func (x *Job) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Job) GetType() JobType {
	if x != nil {
		return x.Type
	}
	return JobType_JT_ROOM
}

func (x *Job) GetRoom() *Room {
	if x != nil {
		return x.Room
	}
	return nil
}

func (x *Job) GetParticipant() *ParticipantInfo {
	if x != nil {
		return x.Participant
	}
	return nil
}

// from Worker to Server
type WorkerMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Message:
	//
	//	*WorkerMessage_Register
	//	*WorkerMessage_Availability
	//	*WorkerMessage_Status
	//	*WorkerMessage_JobUpdate
	Message isWorkerMessage_Message `protobuf_oneof:"message"`
}

func (x *WorkerMessage) Reset() {
	*x = WorkerMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_agent_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WorkerMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkerMessage) ProtoMessage() {}

func (x *WorkerMessage) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_agent_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkerMessage.ProtoReflect.Descriptor instead.
func (*WorkerMessage) Descriptor() ([]byte, []int) {
	return file_livekit_agent_proto_rawDescGZIP(), []int{2}
}

func (m *WorkerMessage) GetMessage() isWorkerMessage_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (x *WorkerMessage) GetRegister() *RegisterWorkerRequest {
	if x, ok := x.GetMessage().(*WorkerMessage_Register); ok {
		return x.Register
	}
	return nil
}

func (x *WorkerMessage) GetAvailability() *AvailabilityResponse {
	if x, ok := x.GetMessage().(*WorkerMessage_Availability); ok {
		return x.Availability
	}
	return nil
}

func (x *WorkerMessage) GetStatus() *UpdateWorkerStatus {
	if x, ok := x.GetMessage().(*WorkerMessage_Status); ok {
		return x.Status
	}
	return nil
}

func (x *WorkerMessage) GetJobUpdate() *JobStatusUpdate {
	if x, ok := x.GetMessage().(*WorkerMessage_JobUpdate); ok {
		return x.JobUpdate
	}
	return nil
}

type isWorkerMessage_Message interface {
	isWorkerMessage_Message()
}

type WorkerMessage_Register struct {
	// agent workers need to register themselves with the server first
	Register *RegisterWorkerRequest `protobuf:"bytes,1,opt,name=register,proto3,oneof"`
}

type WorkerMessage_Availability struct {
	// worker confirms to server that it's available for a job, or declines it
	Availability *AvailabilityResponse `protobuf:"bytes,2,opt,name=availability,proto3,oneof"`
}

type WorkerMessage_Status struct {
	// worker can update its status to the server, including taking itself out of the pool
	Status *UpdateWorkerStatus `protobuf:"bytes,3,opt,name=status,proto3,oneof"`
}

type WorkerMessage_JobUpdate struct {
	JobUpdate *JobStatusUpdate `protobuf:"bytes,4,opt,name=job_update,json=jobUpdate,proto3,oneof"`
}

func (*WorkerMessage_Register) isWorkerMessage_Message() {}

func (*WorkerMessage_Availability) isWorkerMessage_Message() {}

func (*WorkerMessage_Status) isWorkerMessage_Message() {}

func (*WorkerMessage_JobUpdate) isWorkerMessage_Message() {}

// from Server to Worker
type ServerMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Message:
	//
	//	*ServerMessage_Register
	//	*ServerMessage_Availability
	//	*ServerMessage_Assignment
	Message isServerMessage_Message `protobuf_oneof:"message"`
}

func (x *ServerMessage) Reset() {
	*x = ServerMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_agent_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServerMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerMessage) ProtoMessage() {}

func (x *ServerMessage) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_agent_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerMessage.ProtoReflect.Descriptor instead.
func (*ServerMessage) Descriptor() ([]byte, []int) {
	return file_livekit_agent_proto_rawDescGZIP(), []int{3}
}

func (m *ServerMessage) GetMessage() isServerMessage_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (x *ServerMessage) GetRegister() *RegisterWorkerResponse {
	if x, ok := x.GetMessage().(*ServerMessage_Register); ok {
		return x.Register
	}
	return nil
}

func (x *ServerMessage) GetAvailability() *AvailabilityRequest {
	if x, ok := x.GetMessage().(*ServerMessage_Availability); ok {
		return x.Availability
	}
	return nil
}

func (x *ServerMessage) GetAssignment() *JobAssignment {
	if x, ok := x.GetMessage().(*ServerMessage_Assignment); ok {
		return x.Assignment
	}
	return nil
}

type isServerMessage_Message interface {
	isServerMessage_Message()
}

type ServerMessage_Register struct {
	// server confirms the registration, from this moment on, the worker is considered active
	Register *RegisterWorkerResponse `protobuf:"bytes,1,opt,name=register,proto3,oneof"`
}

type ServerMessage_Availability struct {
	// server asks worker to confirm availability for a job
	Availability *AvailabilityRequest `protobuf:"bytes,2,opt,name=availability,proto3,oneof"`
}

type ServerMessage_Assignment struct {
	Assignment *JobAssignment `protobuf:"bytes,3,opt,name=assignment,proto3,oneof"`
}

func (*ServerMessage_Register) isServerMessage_Message() {}

func (*ServerMessage_Availability) isServerMessage_Message() {}

func (*ServerMessage_Assignment) isServerMessage_Message() {}

type RegisterWorkerRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type     JobType `protobuf:"varint,1,opt,name=type,proto3,enum=livekit.JobType" json:"type,omitempty"`
	WorkerId string  `protobuf:"bytes,2,opt,name=worker_id,json=workerId,proto3" json:"worker_id,omitempty"`
	Version  string  `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	Name     string  `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *RegisterWorkerRequest) Reset() {
	*x = RegisterWorkerRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_agent_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterWorkerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterWorkerRequest) ProtoMessage() {}

func (x *RegisterWorkerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_agent_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterWorkerRequest.ProtoReflect.Descriptor instead.
func (*RegisterWorkerRequest) Descriptor() ([]byte, []int) {
	return file_livekit_agent_proto_rawDescGZIP(), []int{4}
}

func (x *RegisterWorkerRequest) GetType() JobType {
	if x != nil {
		return x.Type
	}
	return JobType_JT_ROOM
}

func (x *RegisterWorkerRequest) GetWorkerId() string {
	if x != nil {
		return x.WorkerId
	}
	return ""
}

func (x *RegisterWorkerRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *RegisterWorkerRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type RegisterWorkerResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	WorkerId      string `protobuf:"bytes,1,opt,name=worker_id,json=workerId,proto3" json:"worker_id,omitempty"`
	ServerVersion string `protobuf:"bytes,2,opt,name=server_version,json=serverVersion,proto3" json:"server_version,omitempty"`
}

func (x *RegisterWorkerResponse) Reset() {
	*x = RegisterWorkerResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_agent_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterWorkerResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterWorkerResponse) ProtoMessage() {}

func (x *RegisterWorkerResponse) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_agent_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterWorkerResponse.ProtoReflect.Descriptor instead.
func (*RegisterWorkerResponse) Descriptor() ([]byte, []int) {
	return file_livekit_agent_proto_rawDescGZIP(), []int{5}
}

func (x *RegisterWorkerResponse) GetWorkerId() string {
	if x != nil {
		return x.WorkerId
	}
	return ""
}

func (x *RegisterWorkerResponse) GetServerVersion() string {
	if x != nil {
		return x.ServerVersion
	}
	return ""
}

type AvailabilityRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Job *Job `protobuf:"bytes,1,opt,name=job,proto3" json:"job,omitempty"`
}

func (x *AvailabilityRequest) Reset() {
	*x = AvailabilityRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_agent_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AvailabilityRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AvailabilityRequest) ProtoMessage() {}

func (x *AvailabilityRequest) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_agent_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AvailabilityRequest.ProtoReflect.Descriptor instead.
func (*AvailabilityRequest) Descriptor() ([]byte, []int) {
	return file_livekit_agent_proto_rawDescGZIP(), []int{6}
}

func (x *AvailabilityRequest) GetJob() *Job {
	if x != nil {
		return x.Job
	}
	return nil
}

type AvailabilityResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	JobId     string `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	Available bool   `protobuf:"varint,2,opt,name=available,proto3" json:"available,omitempty"`
}

func (x *AvailabilityResponse) Reset() {
	*x = AvailabilityResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_agent_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AvailabilityResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AvailabilityResponse) ProtoMessage() {}

func (x *AvailabilityResponse) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_agent_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AvailabilityResponse.ProtoReflect.Descriptor instead.
func (*AvailabilityResponse) Descriptor() ([]byte, []int) {
	return file_livekit_agent_proto_rawDescGZIP(), []int{7}
}

func (x *AvailabilityResponse) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

func (x *AvailabilityResponse) GetAvailable() bool {
	if x != nil {
		return x.Available
	}
	return false
}

type JobStatusUpdate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	JobId    string    `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	Status   JobStatus `protobuf:"varint,2,opt,name=status,proto3,enum=livekit.JobStatus" json:"status,omitempty"`
	Error    string    `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
	UserData string    `protobuf:"bytes,4,opt,name=user_data,json=userData,proto3" json:"user_data,omitempty"`
}

func (x *JobStatusUpdate) Reset() {
	*x = JobStatusUpdate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_agent_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobStatusUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobStatusUpdate) ProtoMessage() {}

func (x *JobStatusUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_agent_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobStatusUpdate.ProtoReflect.Descriptor instead.
func (*JobStatusUpdate) Descriptor() ([]byte, []int) {
	return file_livekit_agent_proto_rawDescGZIP(), []int{8}
}

func (x *JobStatusUpdate) GetJobId() string {
	if x != nil {
		return x.JobId
	}
	return ""
}

func (x *JobStatusUpdate) GetStatus() JobStatus {
	if x != nil {
		return x.Status
	}
	return JobStatus_JS_UNKNOWN
}

func (x *JobStatusUpdate) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

func (x *JobStatusUpdate) GetUserData() string {
	if x != nil {
		return x.UserData
	}
	return ""
}

type JobAssignment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Job *Job `protobuf:"bytes,1,opt,name=job,proto3" json:"job,omitempty"`
}

func (x *JobAssignment) Reset() {
	*x = JobAssignment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_agent_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobAssignment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobAssignment) ProtoMessage() {}

func (x *JobAssignment) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_agent_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobAssignment.ProtoReflect.Descriptor instead.
func (*JobAssignment) Descriptor() ([]byte, []int) {
	return file_livekit_agent_proto_rawDescGZIP(), []int{9}
}

func (x *JobAssignment) GetJob() *Job {
	if x != nil {
		return x.Job
	}
	return nil
}

type UpdateWorkerStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Status WorkerStatus `protobuf:"varint,1,opt,name=status,proto3,enum=livekit.WorkerStatus" json:"status,omitempty"`
}

func (x *UpdateWorkerStatus) Reset() {
	*x = UpdateWorkerStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_livekit_agent_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateWorkerStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateWorkerStatus) ProtoMessage() {}

func (x *UpdateWorkerStatus) ProtoReflect() protoreflect.Message {
	mi := &file_livekit_agent_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateWorkerStatus.ProtoReflect.Descriptor instead.
func (*UpdateWorkerStatus) Descriptor() ([]byte, []int) {
	return file_livekit_agent_proto_rawDescGZIP(), []int{10}
}

func (x *UpdateWorkerStatus) GetStatus() WorkerStatus {
	if x != nil {
		return x.Status
	}
	return WorkerStatus_WS_AVAILABLE
}

var File_livekit_agent_proto protoreflect.FileDescriptor

var file_livekit_agent_proto_rawDesc = []byte{
	0x0a, 0x13, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x07, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x1a, 0x14,
	0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x49, 0x0a, 0x09, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0xaf, 0x01, 0x0a, 0x03, 0x4a, 0x6f, 0x62, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x24, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e,
	0x4a, 0x6f, 0x62, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a,
	0x04, 0x72, 0x6f, 0x6f, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e, 0x6c, 0x69,
	0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x52, 0x6f, 0x6f, 0x6d, 0x52, 0x04, 0x72, 0x6f, 0x6f, 0x6d,
	0x12, 0x3f, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x48,
	0x00, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x88, 0x01,
	0x01, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e,
	0x74, 0x22, 0x8f, 0x02, 0x0a, 0x0d, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x12, 0x3c, 0x0a, 0x08, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e,
	0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x08, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65,
	0x72, 0x12, 0x43, 0x0a, 0x0c, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69,
	0x74, 0x2e, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x0c, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x35, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x48, 0x00, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x39, 0x0a,
	0x0a, 0x6a, 0x6f, 0x62, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x18, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x4a, 0x6f, 0x62, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x09, 0x6a,
	0x6f, 0x62, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x09, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x22, 0xd7, 0x01, 0x0a, 0x0d, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3d, 0x0a, 0x08, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69,
	0x74, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x08, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x65, 0x72, 0x12, 0x42, 0x0a, 0x0c, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x6b, 0x69, 0x74, 0x2e, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0c, 0x61, 0x76, 0x61, 0x69,
	0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x38, 0x0a, 0x0a, 0x61, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x6c,
	0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x4a, 0x6f, 0x62, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x42, 0x09, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x88, 0x01,
	0x0a, 0x15, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e,
	0x4a, 0x6f, 0x62, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a,
	0x09, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x49, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x5c, 0x0a, 0x16, 0x52, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x65, 0x72, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x25, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x35, 0x0a, 0x13, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1e, 0x0a,
	0x03, 0x6a, 0x6f, 0x62, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x6c, 0x69, 0x76,
	0x65, 0x6b, 0x69, 0x74, 0x2e, 0x4a, 0x6f, 0x62, 0x52, 0x03, 0x6a, 0x6f, 0x62, 0x22, 0x4b, 0x0a,
	0x14, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x15, 0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6a, 0x6f, 0x62, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x09,
	0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x09, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x87, 0x01, 0x0a, 0x0f, 0x4a,
	0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x15,
	0x0a, 0x06, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x6a, 0x6f, 0x62, 0x49, 0x64, 0x12, 0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x12, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e,
	0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72,
	0x44, 0x61, 0x74, 0x61, 0x22, 0x2f, 0x0a, 0x0d, 0x4a, 0x6f, 0x62, 0x41, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1e, 0x0a, 0x03, 0x6a, 0x6f, 0x62, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x0c, 0x2e, 0x6c, 0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x4a, 0x6f, 0x62,
	0x52, 0x03, 0x6a, 0x6f, 0x62, 0x22, 0x43, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x57,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x2d, 0x0a, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x6c, 0x69,
	0x76, 0x65, 0x6b, 0x69, 0x74, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2a, 0x28, 0x0a, 0x07, 0x4a, 0x6f,
	0x62, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x4a, 0x54, 0x5f, 0x52, 0x4f, 0x4f, 0x4d,
	0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x4a, 0x54, 0x5f, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x53, 0x48,
	0x45, 0x52, 0x10, 0x01, 0x2a, 0x2d, 0x0a, 0x0c, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x10, 0x0a, 0x0c, 0x57, 0x53, 0x5f, 0x41, 0x56, 0x41, 0x49, 0x4c,
	0x41, 0x42, 0x4c, 0x45, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x57, 0x53, 0x5f, 0x46, 0x55, 0x4c,
	0x4c, 0x10, 0x01, 0x2a, 0x3a, 0x0a, 0x09, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x0e, 0x0a, 0x0a, 0x4a, 0x53, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00,
	0x12, 0x0e, 0x0a, 0x0a, 0x4a, 0x53, 0x5f, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x01,
	0x12, 0x0d, 0x0a, 0x09, 0x4a, 0x53, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x42,
	0x46, 0x5a, 0x23, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x6c, 0x69,
	0x76, 0x65, 0x6b, 0x69, 0x74, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x2f, 0x6c,
	0x69, 0x76, 0x65, 0x6b, 0x69, 0x74, 0xaa, 0x02, 0x0d, 0x4c, 0x69, 0x76, 0x65, 0x4b, 0x69, 0x74,
	0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0xea, 0x02, 0x0e, 0x4c, 0x69, 0x76, 0x65, 0x4b, 0x69, 0x74,
	0x3a, 0x3a, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_livekit_agent_proto_rawDescOnce sync.Once
	file_livekit_agent_proto_rawDescData = file_livekit_agent_proto_rawDesc
)

func file_livekit_agent_proto_rawDescGZIP() []byte {
	file_livekit_agent_proto_rawDescOnce.Do(func() {
		file_livekit_agent_proto_rawDescData = protoimpl.X.CompressGZIP(file_livekit_agent_proto_rawDescData)
	})
	return file_livekit_agent_proto_rawDescData
}

var file_livekit_agent_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_livekit_agent_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_livekit_agent_proto_goTypes = []interface{}{
	(JobType)(0),                   // 0: livekit.JobType
	(WorkerStatus)(0),              // 1: livekit.WorkerStatus
	(JobStatus)(0),                 // 2: livekit.JobStatus
	(*AgentInfo)(nil),              // 3: livekit.AgentInfo
	(*Job)(nil),                    // 4: livekit.Job
	(*WorkerMessage)(nil),          // 5: livekit.WorkerMessage
	(*ServerMessage)(nil),          // 6: livekit.ServerMessage
	(*RegisterWorkerRequest)(nil),  // 7: livekit.RegisterWorkerRequest
	(*RegisterWorkerResponse)(nil), // 8: livekit.RegisterWorkerResponse
	(*AvailabilityRequest)(nil),    // 9: livekit.AvailabilityRequest
	(*AvailabilityResponse)(nil),   // 10: livekit.AvailabilityResponse
	(*JobStatusUpdate)(nil),        // 11: livekit.JobStatusUpdate
	(*JobAssignment)(nil),          // 12: livekit.JobAssignment
	(*UpdateWorkerStatus)(nil),     // 13: livekit.UpdateWorkerStatus
	(*Room)(nil),                   // 14: livekit.Room
	(*ParticipantInfo)(nil),        // 15: livekit.ParticipantInfo
}
var file_livekit_agent_proto_depIdxs = []int32{
	0,  // 0: livekit.Job.type:type_name -> livekit.JobType
	14, // 1: livekit.Job.room:type_name -> livekit.Room
	15, // 2: livekit.Job.participant:type_name -> livekit.ParticipantInfo
	7,  // 3: livekit.WorkerMessage.register:type_name -> livekit.RegisterWorkerRequest
	10, // 4: livekit.WorkerMessage.availability:type_name -> livekit.AvailabilityResponse
	13, // 5: livekit.WorkerMessage.status:type_name -> livekit.UpdateWorkerStatus
	11, // 6: livekit.WorkerMessage.job_update:type_name -> livekit.JobStatusUpdate
	8,  // 7: livekit.ServerMessage.register:type_name -> livekit.RegisterWorkerResponse
	9,  // 8: livekit.ServerMessage.availability:type_name -> livekit.AvailabilityRequest
	12, // 9: livekit.ServerMessage.assignment:type_name -> livekit.JobAssignment
	0,  // 10: livekit.RegisterWorkerRequest.type:type_name -> livekit.JobType
	4,  // 11: livekit.AvailabilityRequest.job:type_name -> livekit.Job
	2,  // 12: livekit.JobStatusUpdate.status:type_name -> livekit.JobStatus
	4,  // 13: livekit.JobAssignment.job:type_name -> livekit.Job
	1,  // 14: livekit.UpdateWorkerStatus.status:type_name -> livekit.WorkerStatus
	15, // [15:15] is the sub-list for method output_type
	15, // [15:15] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_livekit_agent_proto_init() }
func file_livekit_agent_proto_init() {
	if File_livekit_agent_proto != nil {
		return
	}
	file_livekit_models_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_livekit_agent_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AgentInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_agent_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Job); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_agent_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WorkerMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_agent_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServerMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_agent_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterWorkerRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_agent_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterWorkerResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_agent_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AvailabilityRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_agent_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AvailabilityResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_agent_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobStatusUpdate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_agent_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobAssignment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_livekit_agent_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateWorkerStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_livekit_agent_proto_msgTypes[1].OneofWrappers = []interface{}{}
	file_livekit_agent_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*WorkerMessage_Register)(nil),
		(*WorkerMessage_Availability)(nil),
		(*WorkerMessage_Status)(nil),
		(*WorkerMessage_JobUpdate)(nil),
	}
	file_livekit_agent_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*ServerMessage_Register)(nil),
		(*ServerMessage_Availability)(nil),
		(*ServerMessage_Assignment)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_livekit_agent_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_livekit_agent_proto_goTypes,
		DependencyIndexes: file_livekit_agent_proto_depIdxs,
		EnumInfos:         file_livekit_agent_proto_enumTypes,
		MessageInfos:      file_livekit_agent_proto_msgTypes,
	}.Build()
	File_livekit_agent_proto = out.File
	file_livekit_agent_proto_rawDesc = nil
	file_livekit_agent_proto_goTypes = nil
	file_livekit_agent_proto_depIdxs = nil
}
