// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Contains details about a Amazon Web Services HealthScribe streaming session.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct MedicalScribeStreamDetails {
    /// <p>The identifier of the HealthScribe streaming session.</p>
    pub session_id: ::std::option::Option<::std::string::String>,
    /// <p>The date and time when the HealthScribe streaming session was created.</p>
    pub stream_created_at: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>The date and time when the HealthScribe streaming session was ended.</p>
    pub stream_ended_at: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>The Language Code of the HealthScribe streaming session.</p>
    pub language_code: ::std::option::Option<crate::types::MedicalScribeLanguageCode>,
    /// <p>The sample rate (in hertz) of the HealthScribe streaming session.</p>
    pub media_sample_rate_hertz: ::std::option::Option<i32>,
    /// <p>The Media Encoding of the HealthScribe streaming session.</p>
    pub media_encoding: ::std::option::Option<crate::types::MedicalScribeMediaEncoding>,
    /// <p>The vocabulary name of the HealthScribe streaming session.</p>
    pub vocabulary_name: ::std::option::Option<::std::string::String>,
    /// <p>The name of the vocabulary filter used for the HealthScribe streaming session .</p>
    pub vocabulary_filter_name: ::std::option::Option<::std::string::String>,
    /// <p>The method of the vocabulary filter for the HealthScribe streaming session.</p>
    pub vocabulary_filter_method: ::std::option::Option<crate::types::MedicalScribeVocabularyFilterMethod>,
    /// <p>The Amazon Resource Name (ARN) of the role used in the HealthScribe streaming session.</p>
    pub resource_access_role_arn: ::std::option::Option<::std::string::String>,
    /// <p>The Channel Definitions of the HealthScribe streaming session.</p>
    pub channel_definitions: ::std::option::Option<::std::vec::Vec<crate::types::MedicalScribeChannelDefinition>>,
    /// <p>The Encryption Settings of the HealthScribe streaming session.</p>
    pub encryption_settings: ::std::option::Option<crate::types::MedicalScribeEncryptionSettings>,
    /// <p>The streaming status of the HealthScribe streaming session.</p>
    /// <p>Possible Values:</p>
    /// <ul>
    /// <li>
    /// <p><code>IN_PROGRESS</code></p></li>
    /// <li>
    /// <p><code>PAUSED</code></p></li>
    /// <li>
    /// <p><code>FAILED</code></p></li>
    /// <li>
    /// <p><code>COMPLETED</code></p></li>
    /// </ul><note>
    /// <p>This status is specific to real-time streaming. A <code>COMPLETED</code> status doesn't mean that the post-stream analytics is complete. To get status of an analytics result, check the <code>Status</code> field for the analytics result within the <code>MedicalScribePostStreamAnalyticsResult</code>. For example, you can view the status of the <code>ClinicalNoteGenerationResult</code>.</p>
    /// </note>
    pub stream_status: ::std::option::Option<crate::types::MedicalScribeStreamStatus>,
    /// <p>The post-stream analytics settings of the HealthScribe streaming session.</p>
    pub post_stream_analytics_settings: ::std::option::Option<crate::types::MedicalScribePostStreamAnalyticsSettings>,
    /// <p>The result of post-stream analytics for the HealthScribe streaming session.</p>
    pub post_stream_analytics_result: ::std::option::Option<crate::types::MedicalScribePostStreamAnalyticsResult>,
}
impl MedicalScribeStreamDetails {
    /// <p>The identifier of the HealthScribe streaming session.</p>
    pub fn session_id(&self) -> ::std::option::Option<&str> {
        self.session_id.as_deref()
    }
    /// <p>The date and time when the HealthScribe streaming session was created.</p>
    pub fn stream_created_at(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.stream_created_at.as_ref()
    }
    /// <p>The date and time when the HealthScribe streaming session was ended.</p>
    pub fn stream_ended_at(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.stream_ended_at.as_ref()
    }
    /// <p>The Language Code of the HealthScribe streaming session.</p>
    pub fn language_code(&self) -> ::std::option::Option<&crate::types::MedicalScribeLanguageCode> {
        self.language_code.as_ref()
    }
    /// <p>The sample rate (in hertz) of the HealthScribe streaming session.</p>
    pub fn media_sample_rate_hertz(&self) -> ::std::option::Option<i32> {
        self.media_sample_rate_hertz
    }
    /// <p>The Media Encoding of the HealthScribe streaming session.</p>
    pub fn media_encoding(&self) -> ::std::option::Option<&crate::types::MedicalScribeMediaEncoding> {
        self.media_encoding.as_ref()
    }
    /// <p>The vocabulary name of the HealthScribe streaming session.</p>
    pub fn vocabulary_name(&self) -> ::std::option::Option<&str> {
        self.vocabulary_name.as_deref()
    }
    /// <p>The name of the vocabulary filter used for the HealthScribe streaming session .</p>
    pub fn vocabulary_filter_name(&self) -> ::std::option::Option<&str> {
        self.vocabulary_filter_name.as_deref()
    }
    /// <p>The method of the vocabulary filter for the HealthScribe streaming session.</p>
    pub fn vocabulary_filter_method(&self) -> ::std::option::Option<&crate::types::MedicalScribeVocabularyFilterMethod> {
        self.vocabulary_filter_method.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the role used in the HealthScribe streaming session.</p>
    pub fn resource_access_role_arn(&self) -> ::std::option::Option<&str> {
        self.resource_access_role_arn.as_deref()
    }
    /// <p>The Channel Definitions of the HealthScribe streaming session.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.channel_definitions.is_none()`.
    pub fn channel_definitions(&self) -> &[crate::types::MedicalScribeChannelDefinition] {
        self.channel_definitions.as_deref().unwrap_or_default()
    }
    /// <p>The Encryption Settings of the HealthScribe streaming session.</p>
    pub fn encryption_settings(&self) -> ::std::option::Option<&crate::types::MedicalScribeEncryptionSettings> {
        self.encryption_settings.as_ref()
    }
    /// <p>The streaming status of the HealthScribe streaming session.</p>
    /// <p>Possible Values:</p>
    /// <ul>
    /// <li>
    /// <p><code>IN_PROGRESS</code></p></li>
    /// <li>
    /// <p><code>PAUSED</code></p></li>
    /// <li>
    /// <p><code>FAILED</code></p></li>
    /// <li>
    /// <p><code>COMPLETED</code></p></li>
    /// </ul><note>
    /// <p>This status is specific to real-time streaming. A <code>COMPLETED</code> status doesn't mean that the post-stream analytics is complete. To get status of an analytics result, check the <code>Status</code> field for the analytics result within the <code>MedicalScribePostStreamAnalyticsResult</code>. For example, you can view the status of the <code>ClinicalNoteGenerationResult</code>.</p>
    /// </note>
    pub fn stream_status(&self) -> ::std::option::Option<&crate::types::MedicalScribeStreamStatus> {
        self.stream_status.as_ref()
    }
    /// <p>The post-stream analytics settings of the HealthScribe streaming session.</p>
    pub fn post_stream_analytics_settings(&self) -> ::std::option::Option<&crate::types::MedicalScribePostStreamAnalyticsSettings> {
        self.post_stream_analytics_settings.as_ref()
    }
    /// <p>The result of post-stream analytics for the HealthScribe streaming session.</p>
    pub fn post_stream_analytics_result(&self) -> ::std::option::Option<&crate::types::MedicalScribePostStreamAnalyticsResult> {
        self.post_stream_analytics_result.as_ref()
    }
}
impl MedicalScribeStreamDetails {
    /// Creates a new builder-style object to manufacture [`MedicalScribeStreamDetails`](crate::types::MedicalScribeStreamDetails).
    pub fn builder() -> crate::types::builders::MedicalScribeStreamDetailsBuilder {
        crate::types::builders::MedicalScribeStreamDetailsBuilder::default()
    }
}

/// A builder for [`MedicalScribeStreamDetails`](crate::types::MedicalScribeStreamDetails).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct MedicalScribeStreamDetailsBuilder {
    pub(crate) session_id: ::std::option::Option<::std::string::String>,
    pub(crate) stream_created_at: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) stream_ended_at: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) language_code: ::std::option::Option<crate::types::MedicalScribeLanguageCode>,
    pub(crate) media_sample_rate_hertz: ::std::option::Option<i32>,
    pub(crate) media_encoding: ::std::option::Option<crate::types::MedicalScribeMediaEncoding>,
    pub(crate) vocabulary_name: ::std::option::Option<::std::string::String>,
    pub(crate) vocabulary_filter_name: ::std::option::Option<::std::string::String>,
    pub(crate) vocabulary_filter_method: ::std::option::Option<crate::types::MedicalScribeVocabularyFilterMethod>,
    pub(crate) resource_access_role_arn: ::std::option::Option<::std::string::String>,
    pub(crate) channel_definitions: ::std::option::Option<::std::vec::Vec<crate::types::MedicalScribeChannelDefinition>>,
    pub(crate) encryption_settings: ::std::option::Option<crate::types::MedicalScribeEncryptionSettings>,
    pub(crate) stream_status: ::std::option::Option<crate::types::MedicalScribeStreamStatus>,
    pub(crate) post_stream_analytics_settings: ::std::option::Option<crate::types::MedicalScribePostStreamAnalyticsSettings>,
    pub(crate) post_stream_analytics_result: ::std::option::Option<crate::types::MedicalScribePostStreamAnalyticsResult>,
}
impl MedicalScribeStreamDetailsBuilder {
    /// <p>The identifier of the HealthScribe streaming session.</p>
    pub fn session_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.session_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The identifier of the HealthScribe streaming session.</p>
    pub fn set_session_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.session_id = input;
        self
    }
    /// <p>The identifier of the HealthScribe streaming session.</p>
    pub fn get_session_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.session_id
    }
    /// <p>The date and time when the HealthScribe streaming session was created.</p>
    pub fn stream_created_at(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.stream_created_at = ::std::option::Option::Some(input);
        self
    }
    /// <p>The date and time when the HealthScribe streaming session was created.</p>
    pub fn set_stream_created_at(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.stream_created_at = input;
        self
    }
    /// <p>The date and time when the HealthScribe streaming session was created.</p>
    pub fn get_stream_created_at(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.stream_created_at
    }
    /// <p>The date and time when the HealthScribe streaming session was ended.</p>
    pub fn stream_ended_at(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.stream_ended_at = ::std::option::Option::Some(input);
        self
    }
    /// <p>The date and time when the HealthScribe streaming session was ended.</p>
    pub fn set_stream_ended_at(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.stream_ended_at = input;
        self
    }
    /// <p>The date and time when the HealthScribe streaming session was ended.</p>
    pub fn get_stream_ended_at(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.stream_ended_at
    }
    /// <p>The Language Code of the HealthScribe streaming session.</p>
    pub fn language_code(mut self, input: crate::types::MedicalScribeLanguageCode) -> Self {
        self.language_code = ::std::option::Option::Some(input);
        self
    }
    /// <p>The Language Code of the HealthScribe streaming session.</p>
    pub fn set_language_code(mut self, input: ::std::option::Option<crate::types::MedicalScribeLanguageCode>) -> Self {
        self.language_code = input;
        self
    }
    /// <p>The Language Code of the HealthScribe streaming session.</p>
    pub fn get_language_code(&self) -> &::std::option::Option<crate::types::MedicalScribeLanguageCode> {
        &self.language_code
    }
    /// <p>The sample rate (in hertz) of the HealthScribe streaming session.</p>
    pub fn media_sample_rate_hertz(mut self, input: i32) -> Self {
        self.media_sample_rate_hertz = ::std::option::Option::Some(input);
        self
    }
    /// <p>The sample rate (in hertz) of the HealthScribe streaming session.</p>
    pub fn set_media_sample_rate_hertz(mut self, input: ::std::option::Option<i32>) -> Self {
        self.media_sample_rate_hertz = input;
        self
    }
    /// <p>The sample rate (in hertz) of the HealthScribe streaming session.</p>
    pub fn get_media_sample_rate_hertz(&self) -> &::std::option::Option<i32> {
        &self.media_sample_rate_hertz
    }
    /// <p>The Media Encoding of the HealthScribe streaming session.</p>
    pub fn media_encoding(mut self, input: crate::types::MedicalScribeMediaEncoding) -> Self {
        self.media_encoding = ::std::option::Option::Some(input);
        self
    }
    /// <p>The Media Encoding of the HealthScribe streaming session.</p>
    pub fn set_media_encoding(mut self, input: ::std::option::Option<crate::types::MedicalScribeMediaEncoding>) -> Self {
        self.media_encoding = input;
        self
    }
    /// <p>The Media Encoding of the HealthScribe streaming session.</p>
    pub fn get_media_encoding(&self) -> &::std::option::Option<crate::types::MedicalScribeMediaEncoding> {
        &self.media_encoding
    }
    /// <p>The vocabulary name of the HealthScribe streaming session.</p>
    pub fn vocabulary_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.vocabulary_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The vocabulary name of the HealthScribe streaming session.</p>
    pub fn set_vocabulary_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.vocabulary_name = input;
        self
    }
    /// <p>The vocabulary name of the HealthScribe streaming session.</p>
    pub fn get_vocabulary_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.vocabulary_name
    }
    /// <p>The name of the vocabulary filter used for the HealthScribe streaming session .</p>
    pub fn vocabulary_filter_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.vocabulary_filter_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name of the vocabulary filter used for the HealthScribe streaming session .</p>
    pub fn set_vocabulary_filter_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.vocabulary_filter_name = input;
        self
    }
    /// <p>The name of the vocabulary filter used for the HealthScribe streaming session .</p>
    pub fn get_vocabulary_filter_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.vocabulary_filter_name
    }
    /// <p>The method of the vocabulary filter for the HealthScribe streaming session.</p>
    pub fn vocabulary_filter_method(mut self, input: crate::types::MedicalScribeVocabularyFilterMethod) -> Self {
        self.vocabulary_filter_method = ::std::option::Option::Some(input);
        self
    }
    /// <p>The method of the vocabulary filter for the HealthScribe streaming session.</p>
    pub fn set_vocabulary_filter_method(mut self, input: ::std::option::Option<crate::types::MedicalScribeVocabularyFilterMethod>) -> Self {
        self.vocabulary_filter_method = input;
        self
    }
    /// <p>The method of the vocabulary filter for the HealthScribe streaming session.</p>
    pub fn get_vocabulary_filter_method(&self) -> &::std::option::Option<crate::types::MedicalScribeVocabularyFilterMethod> {
        &self.vocabulary_filter_method
    }
    /// <p>The Amazon Resource Name (ARN) of the role used in the HealthScribe streaming session.</p>
    pub fn resource_access_role_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.resource_access_role_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the role used in the HealthScribe streaming session.</p>
    pub fn set_resource_access_role_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.resource_access_role_arn = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the role used in the HealthScribe streaming session.</p>
    pub fn get_resource_access_role_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.resource_access_role_arn
    }
    /// Appends an item to `channel_definitions`.
    ///
    /// To override the contents of this collection use [`set_channel_definitions`](Self::set_channel_definitions).
    ///
    /// <p>The Channel Definitions of the HealthScribe streaming session.</p>
    pub fn channel_definitions(mut self, input: crate::types::MedicalScribeChannelDefinition) -> Self {
        let mut v = self.channel_definitions.unwrap_or_default();
        v.push(input);
        self.channel_definitions = ::std::option::Option::Some(v);
        self
    }
    /// <p>The Channel Definitions of the HealthScribe streaming session.</p>
    pub fn set_channel_definitions(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::MedicalScribeChannelDefinition>>) -> Self {
        self.channel_definitions = input;
        self
    }
    /// <p>The Channel Definitions of the HealthScribe streaming session.</p>
    pub fn get_channel_definitions(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::MedicalScribeChannelDefinition>> {
        &self.channel_definitions
    }
    /// <p>The Encryption Settings of the HealthScribe streaming session.</p>
    pub fn encryption_settings(mut self, input: crate::types::MedicalScribeEncryptionSettings) -> Self {
        self.encryption_settings = ::std::option::Option::Some(input);
        self
    }
    /// <p>The Encryption Settings of the HealthScribe streaming session.</p>
    pub fn set_encryption_settings(mut self, input: ::std::option::Option<crate::types::MedicalScribeEncryptionSettings>) -> Self {
        self.encryption_settings = input;
        self
    }
    /// <p>The Encryption Settings of the HealthScribe streaming session.</p>
    pub fn get_encryption_settings(&self) -> &::std::option::Option<crate::types::MedicalScribeEncryptionSettings> {
        &self.encryption_settings
    }
    /// <p>The streaming status of the HealthScribe streaming session.</p>
    /// <p>Possible Values:</p>
    /// <ul>
    /// <li>
    /// <p><code>IN_PROGRESS</code></p></li>
    /// <li>
    /// <p><code>PAUSED</code></p></li>
    /// <li>
    /// <p><code>FAILED</code></p></li>
    /// <li>
    /// <p><code>COMPLETED</code></p></li>
    /// </ul><note>
    /// <p>This status is specific to real-time streaming. A <code>COMPLETED</code> status doesn't mean that the post-stream analytics is complete. To get status of an analytics result, check the <code>Status</code> field for the analytics result within the <code>MedicalScribePostStreamAnalyticsResult</code>. For example, you can view the status of the <code>ClinicalNoteGenerationResult</code>.</p>
    /// </note>
    pub fn stream_status(mut self, input: crate::types::MedicalScribeStreamStatus) -> Self {
        self.stream_status = ::std::option::Option::Some(input);
        self
    }
    /// <p>The streaming status of the HealthScribe streaming session.</p>
    /// <p>Possible Values:</p>
    /// <ul>
    /// <li>
    /// <p><code>IN_PROGRESS</code></p></li>
    /// <li>
    /// <p><code>PAUSED</code></p></li>
    /// <li>
    /// <p><code>FAILED</code></p></li>
    /// <li>
    /// <p><code>COMPLETED</code></p></li>
    /// </ul><note>
    /// <p>This status is specific to real-time streaming. A <code>COMPLETED</code> status doesn't mean that the post-stream analytics is complete. To get status of an analytics result, check the <code>Status</code> field for the analytics result within the <code>MedicalScribePostStreamAnalyticsResult</code>. For example, you can view the status of the <code>ClinicalNoteGenerationResult</code>.</p>
    /// </note>
    pub fn set_stream_status(mut self, input: ::std::option::Option<crate::types::MedicalScribeStreamStatus>) -> Self {
        self.stream_status = input;
        self
    }
    /// <p>The streaming status of the HealthScribe streaming session.</p>
    /// <p>Possible Values:</p>
    /// <ul>
    /// <li>
    /// <p><code>IN_PROGRESS</code></p></li>
    /// <li>
    /// <p><code>PAUSED</code></p></li>
    /// <li>
    /// <p><code>FAILED</code></p></li>
    /// <li>
    /// <p><code>COMPLETED</code></p></li>
    /// </ul><note>
    /// <p>This status is specific to real-time streaming. A <code>COMPLETED</code> status doesn't mean that the post-stream analytics is complete. To get status of an analytics result, check the <code>Status</code> field for the analytics result within the <code>MedicalScribePostStreamAnalyticsResult</code>. For example, you can view the status of the <code>ClinicalNoteGenerationResult</code>.</p>
    /// </note>
    pub fn get_stream_status(&self) -> &::std::option::Option<crate::types::MedicalScribeStreamStatus> {
        &self.stream_status
    }
    /// <p>The post-stream analytics settings of the HealthScribe streaming session.</p>
    pub fn post_stream_analytics_settings(mut self, input: crate::types::MedicalScribePostStreamAnalyticsSettings) -> Self {
        self.post_stream_analytics_settings = ::std::option::Option::Some(input);
        self
    }
    /// <p>The post-stream analytics settings of the HealthScribe streaming session.</p>
    pub fn set_post_stream_analytics_settings(
        mut self,
        input: ::std::option::Option<crate::types::MedicalScribePostStreamAnalyticsSettings>,
    ) -> Self {
        self.post_stream_analytics_settings = input;
        self
    }
    /// <p>The post-stream analytics settings of the HealthScribe streaming session.</p>
    pub fn get_post_stream_analytics_settings(&self) -> &::std::option::Option<crate::types::MedicalScribePostStreamAnalyticsSettings> {
        &self.post_stream_analytics_settings
    }
    /// <p>The result of post-stream analytics for the HealthScribe streaming session.</p>
    pub fn post_stream_analytics_result(mut self, input: crate::types::MedicalScribePostStreamAnalyticsResult) -> Self {
        self.post_stream_analytics_result = ::std::option::Option::Some(input);
        self
    }
    /// <p>The result of post-stream analytics for the HealthScribe streaming session.</p>
    pub fn set_post_stream_analytics_result(mut self, input: ::std::option::Option<crate::types::MedicalScribePostStreamAnalyticsResult>) -> Self {
        self.post_stream_analytics_result = input;
        self
    }
    /// <p>The result of post-stream analytics for the HealthScribe streaming session.</p>
    pub fn get_post_stream_analytics_result(&self) -> &::std::option::Option<crate::types::MedicalScribePostStreamAnalyticsResult> {
        &self.post_stream_analytics_result
    }
    /// Consumes the builder and constructs a [`MedicalScribeStreamDetails`](crate::types::MedicalScribeStreamDetails).
    pub fn build(self) -> crate::types::MedicalScribeStreamDetails {
        crate::types::MedicalScribeStreamDetails {
            session_id: self.session_id,
            stream_created_at: self.stream_created_at,
            stream_ended_at: self.stream_ended_at,
            language_code: self.language_code,
            media_sample_rate_hertz: self.media_sample_rate_hertz,
            media_encoding: self.media_encoding,
            vocabulary_name: self.vocabulary_name,
            vocabulary_filter_name: self.vocabulary_filter_name,
            vocabulary_filter_method: self.vocabulary_filter_method,
            resource_access_role_arn: self.resource_access_role_arn,
            channel_definitions: self.channel_definitions,
            encryption_settings: self.encryption_settings,
            stream_status: self.stream_status,
            post_stream_analytics_settings: self.post_stream_analytics_settings,
            post_stream_analytics_result: self.post_stream_analytics_result,
        }
    }
}
