// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Makes it possible to specify which speaker is on which channel. For example, if the clinician is the first participant to speak, you would set the <code>ChannelId</code> of the first <code>ChannelDefinition</code> in the list to <code>0</code> (to indicate the first channel) and <code>ParticipantRole</code> to <code>CLINICIAN</code> (to indicate that it's the clinician speaking). Then you would set the <code>ChannelId</code> of the second <code>ChannelDefinition</code> in the list to <code>1</code> (to indicate the second channel) and <code>ParticipantRole</code> to <code>PATIENT</code> (to indicate that it's the patient speaking).</p>
/// <p>If you don't specify a channel definition, HealthScribe will diarize the transcription and identify speaker roles for each speaker.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct MedicalScribeChannelDefinition {
    /// <p>Specify the audio channel you want to define.</p>
    pub channel_id: i32,
    /// <p>Specify the participant that you want to flag. The allowed options are <code>CLINICIAN</code> and <code>PATIENT</code>.</p>
    pub participant_role: crate::types::MedicalScribeParticipantRole,
}
impl MedicalScribeChannelDefinition {
    /// <p>Specify the audio channel you want to define.</p>
    pub fn channel_id(&self) -> i32 {
        self.channel_id
    }
    /// <p>Specify the participant that you want to flag. The allowed options are <code>CLINICIAN</code> and <code>PATIENT</code>.</p>
    pub fn participant_role(&self) -> &crate::types::MedicalScribeParticipantRole {
        &self.participant_role
    }
}
impl MedicalScribeChannelDefinition {
    /// Creates a new builder-style object to manufacture [`MedicalScribeChannelDefinition`](crate::types::MedicalScribeChannelDefinition).
    pub fn builder() -> crate::types::builders::MedicalScribeChannelDefinitionBuilder {
        crate::types::builders::MedicalScribeChannelDefinitionBuilder::default()
    }
}

/// A builder for [`MedicalScribeChannelDefinition`](crate::types::MedicalScribeChannelDefinition).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct MedicalScribeChannelDefinitionBuilder {
    pub(crate) channel_id: ::std::option::Option<i32>,
    pub(crate) participant_role: ::std::option::Option<crate::types::MedicalScribeParticipantRole>,
}
impl MedicalScribeChannelDefinitionBuilder {
    /// <p>Specify the audio channel you want to define.</p>
    /// This field is required.
    pub fn channel_id(mut self, input: i32) -> Self {
        self.channel_id = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specify the audio channel you want to define.</p>
    pub fn set_channel_id(mut self, input: ::std::option::Option<i32>) -> Self {
        self.channel_id = input;
        self
    }
    /// <p>Specify the audio channel you want to define.</p>
    pub fn get_channel_id(&self) -> &::std::option::Option<i32> {
        &self.channel_id
    }
    /// <p>Specify the participant that you want to flag. The allowed options are <code>CLINICIAN</code> and <code>PATIENT</code>.</p>
    /// This field is required.
    pub fn participant_role(mut self, input: crate::types::MedicalScribeParticipantRole) -> Self {
        self.participant_role = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specify the participant that you want to flag. The allowed options are <code>CLINICIAN</code> and <code>PATIENT</code>.</p>
    pub fn set_participant_role(mut self, input: ::std::option::Option<crate::types::MedicalScribeParticipantRole>) -> Self {
        self.participant_role = input;
        self
    }
    /// <p>Specify the participant that you want to flag. The allowed options are <code>CLINICIAN</code> and <code>PATIENT</code>.</p>
    pub fn get_participant_role(&self) -> &::std::option::Option<crate::types::MedicalScribeParticipantRole> {
        &self.participant_role
    }
    /// Consumes the builder and constructs a [`MedicalScribeChannelDefinition`](crate::types::MedicalScribeChannelDefinition).
    /// This method will fail if any of the following fields are not set:
    /// - [`participant_role`](crate::types::builders::MedicalScribeChannelDefinitionBuilder::participant_role)
    pub fn build(self) -> ::std::result::Result<crate::types::MedicalScribeChannelDefinition, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::MedicalScribeChannelDefinition {
            channel_id: self.channel_id.unwrap_or_default(),
            participant_role: self.participant_role.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "participant_role",
                    "participant_role was not specified but it is required when building MedicalScribeChannelDefinition",
                )
            })?,
        })
    }
}
