// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::fmt::Debug)]
pub struct StartMedicalStreamTranscriptionOutput {
    /// <p>Provides the identifier for your streaming request.</p>
    pub request_id: ::std::option::Option<::std::string::String>,
    /// <p>Provides the language code that you specified in your request. This must be <code>en-US</code>.</p>
    pub language_code: ::std::option::Option<crate::types::LanguageCode>,
    /// <p>Provides the sample rate that you specified in your request.</p>
    pub media_sample_rate_hertz: ::std::option::Option<i32>,
    /// <p>Provides the media encoding you specified in your request.</p>
    pub media_encoding: ::std::option::Option<crate::types::MediaEncoding>,
    /// <p>Provides the name of the custom vocabulary that you specified in your request.</p>
    pub vocabulary_name: ::std::option::Option<::std::string::String>,
    /// <p>Provides the medical specialty that you specified in your request.</p>
    pub specialty: ::std::option::Option<crate::types::Specialty>,
    /// <p>Provides the type of audio you specified in your request.</p>
    pub r#type: ::std::option::Option<crate::types::Type>,
    /// <p>Shows whether speaker partitioning was enabled for your transcription.</p>
    pub show_speaker_label: bool,
    /// <p>Provides the identifier for your transcription session.</p>
    pub session_id: ::std::option::Option<::std::string::String>,
    /// <p>Provides detailed information about your streaming session.</p>
    pub transcript_result_stream:
        crate::event_receiver::EventReceiver<crate::types::MedicalTranscriptResultStream, crate::types::error::MedicalTranscriptResultStreamError>,
    /// <p>Shows whether channel identification was enabled for your transcription.</p>
    pub enable_channel_identification: bool,
    /// <p>Provides the number of channels that you specified in your request.</p>
    pub number_of_channels: ::std::option::Option<i32>,
    /// <p>Shows whether content identification was enabled for your transcription.</p>
    pub content_identification_type: ::std::option::Option<crate::types::MedicalContentIdentificationType>,
    _request_id: Option<String>,
}
impl StartMedicalStreamTranscriptionOutput {
    /// <p>Provides the identifier for your streaming request.</p>
    pub fn request_id(&self) -> ::std::option::Option<&str> {
        self.request_id.as_deref()
    }
    /// <p>Provides the language code that you specified in your request. This must be <code>en-US</code>.</p>
    pub fn language_code(&self) -> ::std::option::Option<&crate::types::LanguageCode> {
        self.language_code.as_ref()
    }
    /// <p>Provides the sample rate that you specified in your request.</p>
    pub fn media_sample_rate_hertz(&self) -> ::std::option::Option<i32> {
        self.media_sample_rate_hertz
    }
    /// <p>Provides the media encoding you specified in your request.</p>
    pub fn media_encoding(&self) -> ::std::option::Option<&crate::types::MediaEncoding> {
        self.media_encoding.as_ref()
    }
    /// <p>Provides the name of the custom vocabulary that you specified in your request.</p>
    pub fn vocabulary_name(&self) -> ::std::option::Option<&str> {
        self.vocabulary_name.as_deref()
    }
    /// <p>Provides the medical specialty that you specified in your request.</p>
    pub fn specialty(&self) -> ::std::option::Option<&crate::types::Specialty> {
        self.specialty.as_ref()
    }
    /// <p>Provides the type of audio you specified in your request.</p>
    pub fn r#type(&self) -> ::std::option::Option<&crate::types::Type> {
        self.r#type.as_ref()
    }
    /// <p>Shows whether speaker partitioning was enabled for your transcription.</p>
    pub fn show_speaker_label(&self) -> bool {
        self.show_speaker_label
    }
    /// <p>Provides the identifier for your transcription session.</p>
    pub fn session_id(&self) -> ::std::option::Option<&str> {
        self.session_id.as_deref()
    }
    /// <p>Provides detailed information about your streaming session.</p>
    pub fn transcript_result_stream(
        &self,
    ) -> &crate::event_receiver::EventReceiver<crate::types::MedicalTranscriptResultStream, crate::types::error::MedicalTranscriptResultStreamError>
    {
        &self.transcript_result_stream
    }
    /// <p>Shows whether channel identification was enabled for your transcription.</p>
    pub fn enable_channel_identification(&self) -> bool {
        self.enable_channel_identification
    }
    /// <p>Provides the number of channels that you specified in your request.</p>
    pub fn number_of_channels(&self) -> ::std::option::Option<i32> {
        self.number_of_channels
    }
    /// <p>Shows whether content identification was enabled for your transcription.</p>
    pub fn content_identification_type(&self) -> ::std::option::Option<&crate::types::MedicalContentIdentificationType> {
        self.content_identification_type.as_ref()
    }
}
impl ::aws_types::request_id::RequestId for StartMedicalStreamTranscriptionOutput {
    fn request_id(&self) -> Option<&str> {
        self._request_id.as_deref()
    }
}
impl StartMedicalStreamTranscriptionOutput {
    /// Creates a new builder-style object to manufacture [`StartMedicalStreamTranscriptionOutput`](crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionOutput).
    pub fn builder() -> crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionOutputBuilder {
        crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionOutputBuilder::default()
    }
}

/// A builder for [`StartMedicalStreamTranscriptionOutput`](crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionOutput).
#[derive(::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct StartMedicalStreamTranscriptionOutputBuilder {
    pub(crate) request_id: ::std::option::Option<::std::string::String>,
    pub(crate) language_code: ::std::option::Option<crate::types::LanguageCode>,
    pub(crate) media_sample_rate_hertz: ::std::option::Option<i32>,
    pub(crate) media_encoding: ::std::option::Option<crate::types::MediaEncoding>,
    pub(crate) vocabulary_name: ::std::option::Option<::std::string::String>,
    pub(crate) specialty: ::std::option::Option<crate::types::Specialty>,
    pub(crate) r#type: ::std::option::Option<crate::types::Type>,
    pub(crate) show_speaker_label: ::std::option::Option<bool>,
    pub(crate) session_id: ::std::option::Option<::std::string::String>,
    pub(crate) transcript_result_stream: ::std::option::Option<
        crate::event_receiver::EventReceiver<crate::types::MedicalTranscriptResultStream, crate::types::error::MedicalTranscriptResultStreamError>,
    >,
    pub(crate) enable_channel_identification: ::std::option::Option<bool>,
    pub(crate) number_of_channels: ::std::option::Option<i32>,
    pub(crate) content_identification_type: ::std::option::Option<crate::types::MedicalContentIdentificationType>,
    _request_id: Option<String>,
}
impl StartMedicalStreamTranscriptionOutputBuilder {
    /// <p>Provides the identifier for your streaming request.</p>
    pub fn request_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.request_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Provides the identifier for your streaming request.</p>
    pub fn set_request_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.request_id = input;
        self
    }
    /// <p>Provides the identifier for your streaming request.</p>
    pub fn get_request_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.request_id
    }
    /// <p>Provides the language code that you specified in your request. This must be <code>en-US</code>.</p>
    pub fn language_code(mut self, input: crate::types::LanguageCode) -> Self {
        self.language_code = ::std::option::Option::Some(input);
        self
    }
    /// <p>Provides the language code that you specified in your request. This must be <code>en-US</code>.</p>
    pub fn set_language_code(mut self, input: ::std::option::Option<crate::types::LanguageCode>) -> Self {
        self.language_code = input;
        self
    }
    /// <p>Provides the language code that you specified in your request. This must be <code>en-US</code>.</p>
    pub fn get_language_code(&self) -> &::std::option::Option<crate::types::LanguageCode> {
        &self.language_code
    }
    /// <p>Provides the sample rate that you specified in your request.</p>
    pub fn media_sample_rate_hertz(mut self, input: i32) -> Self {
        self.media_sample_rate_hertz = ::std::option::Option::Some(input);
        self
    }
    /// <p>Provides the sample rate that you specified in your request.</p>
    pub fn set_media_sample_rate_hertz(mut self, input: ::std::option::Option<i32>) -> Self {
        self.media_sample_rate_hertz = input;
        self
    }
    /// <p>Provides the sample rate that you specified in your request.</p>
    pub fn get_media_sample_rate_hertz(&self) -> &::std::option::Option<i32> {
        &self.media_sample_rate_hertz
    }
    /// <p>Provides the media encoding you specified in your request.</p>
    pub fn media_encoding(mut self, input: crate::types::MediaEncoding) -> Self {
        self.media_encoding = ::std::option::Option::Some(input);
        self
    }
    /// <p>Provides the media encoding you specified in your request.</p>
    pub fn set_media_encoding(mut self, input: ::std::option::Option<crate::types::MediaEncoding>) -> Self {
        self.media_encoding = input;
        self
    }
    /// <p>Provides the media encoding you specified in your request.</p>
    pub fn get_media_encoding(&self) -> &::std::option::Option<crate::types::MediaEncoding> {
        &self.media_encoding
    }
    /// <p>Provides the name of the custom vocabulary that you specified in your request.</p>
    pub fn vocabulary_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.vocabulary_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Provides the name of the custom vocabulary that you specified in your request.</p>
    pub fn set_vocabulary_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.vocabulary_name = input;
        self
    }
    /// <p>Provides the name of the custom vocabulary that you specified in your request.</p>
    pub fn get_vocabulary_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.vocabulary_name
    }
    /// <p>Provides the medical specialty that you specified in your request.</p>
    pub fn specialty(mut self, input: crate::types::Specialty) -> Self {
        self.specialty = ::std::option::Option::Some(input);
        self
    }
    /// <p>Provides the medical specialty that you specified in your request.</p>
    pub fn set_specialty(mut self, input: ::std::option::Option<crate::types::Specialty>) -> Self {
        self.specialty = input;
        self
    }
    /// <p>Provides the medical specialty that you specified in your request.</p>
    pub fn get_specialty(&self) -> &::std::option::Option<crate::types::Specialty> {
        &self.specialty
    }
    /// <p>Provides the type of audio you specified in your request.</p>
    pub fn r#type(mut self, input: crate::types::Type) -> Self {
        self.r#type = ::std::option::Option::Some(input);
        self
    }
    /// <p>Provides the type of audio you specified in your request.</p>
    pub fn set_type(mut self, input: ::std::option::Option<crate::types::Type>) -> Self {
        self.r#type = input;
        self
    }
    /// <p>Provides the type of audio you specified in your request.</p>
    pub fn get_type(&self) -> &::std::option::Option<crate::types::Type> {
        &self.r#type
    }
    /// <p>Shows whether speaker partitioning was enabled for your transcription.</p>
    pub fn show_speaker_label(mut self, input: bool) -> Self {
        self.show_speaker_label = ::std::option::Option::Some(input);
        self
    }
    /// <p>Shows whether speaker partitioning was enabled for your transcription.</p>
    pub fn set_show_speaker_label(mut self, input: ::std::option::Option<bool>) -> Self {
        self.show_speaker_label = input;
        self
    }
    /// <p>Shows whether speaker partitioning was enabled for your transcription.</p>
    pub fn get_show_speaker_label(&self) -> &::std::option::Option<bool> {
        &self.show_speaker_label
    }
    /// <p>Provides the identifier for your transcription session.</p>
    pub fn session_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.session_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Provides the identifier for your transcription session.</p>
    pub fn set_session_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.session_id = input;
        self
    }
    /// <p>Provides the identifier for your transcription session.</p>
    pub fn get_session_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.session_id
    }
    /// <p>Provides detailed information about your streaming session.</p>
    pub fn transcript_result_stream(
        mut self,
        input: crate::event_receiver::EventReceiver<
            crate::types::MedicalTranscriptResultStream,
            crate::types::error::MedicalTranscriptResultStreamError,
        >,
    ) -> Self {
        self.transcript_result_stream = ::std::option::Option::Some(input);
        self
    }
    /// <p>Provides detailed information about your streaming session.</p>
    pub fn set_transcript_result_stream(
        mut self,
        input: ::std::option::Option<
            crate::event_receiver::EventReceiver<
                crate::types::MedicalTranscriptResultStream,
                crate::types::error::MedicalTranscriptResultStreamError,
            >,
        >,
    ) -> Self {
        self.transcript_result_stream = input;
        self
    }
    /// <p>Provides detailed information about your streaming session.</p>
    pub fn get_transcript_result_stream(
        &self,
    ) -> &::std::option::Option<
        crate::event_receiver::EventReceiver<crate::types::MedicalTranscriptResultStream, crate::types::error::MedicalTranscriptResultStreamError>,
    > {
        &self.transcript_result_stream
    }
    /// <p>Shows whether channel identification was enabled for your transcription.</p>
    pub fn enable_channel_identification(mut self, input: bool) -> Self {
        self.enable_channel_identification = ::std::option::Option::Some(input);
        self
    }
    /// <p>Shows whether channel identification was enabled for your transcription.</p>
    pub fn set_enable_channel_identification(mut self, input: ::std::option::Option<bool>) -> Self {
        self.enable_channel_identification = input;
        self
    }
    /// <p>Shows whether channel identification was enabled for your transcription.</p>
    pub fn get_enable_channel_identification(&self) -> &::std::option::Option<bool> {
        &self.enable_channel_identification
    }
    /// <p>Provides the number of channels that you specified in your request.</p>
    pub fn number_of_channels(mut self, input: i32) -> Self {
        self.number_of_channels = ::std::option::Option::Some(input);
        self
    }
    /// <p>Provides the number of channels that you specified in your request.</p>
    pub fn set_number_of_channels(mut self, input: ::std::option::Option<i32>) -> Self {
        self.number_of_channels = input;
        self
    }
    /// <p>Provides the number of channels that you specified in your request.</p>
    pub fn get_number_of_channels(&self) -> &::std::option::Option<i32> {
        &self.number_of_channels
    }
    /// <p>Shows whether content identification was enabled for your transcription.</p>
    pub fn content_identification_type(mut self, input: crate::types::MedicalContentIdentificationType) -> Self {
        self.content_identification_type = ::std::option::Option::Some(input);
        self
    }
    /// <p>Shows whether content identification was enabled for your transcription.</p>
    pub fn set_content_identification_type(mut self, input: ::std::option::Option<crate::types::MedicalContentIdentificationType>) -> Self {
        self.content_identification_type = input;
        self
    }
    /// <p>Shows whether content identification was enabled for your transcription.</p>
    pub fn get_content_identification_type(&self) -> &::std::option::Option<crate::types::MedicalContentIdentificationType> {
        &self.content_identification_type
    }
    pub(crate) fn _request_id(mut self, request_id: impl Into<String>) -> Self {
        self._request_id = Some(request_id.into());
        self
    }

    pub(crate) fn _set_request_id(&mut self, request_id: Option<String>) -> &mut Self {
        self._request_id = request_id;
        self
    }
    /// Consumes the builder and constructs a [`StartMedicalStreamTranscriptionOutput`](crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionOutput).
    /// This method will fail if any of the following fields are not set:
    /// - [`transcript_result_stream`](crate::operation::start_medical_stream_transcription::builders::StartMedicalStreamTranscriptionOutputBuilder::transcript_result_stream)
    pub fn build(
        self,
    ) -> ::std::result::Result<
        crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionOutput,
        ::aws_smithy_types::error::operation::BuildError,
    > {
        ::std::result::Result::Ok(
            crate::operation::start_medical_stream_transcription::StartMedicalStreamTranscriptionOutput {
                request_id: self.request_id,
                language_code: self.language_code,
                media_sample_rate_hertz: self.media_sample_rate_hertz,
                media_encoding: self.media_encoding,
                vocabulary_name: self.vocabulary_name,
                specialty: self.specialty,
                r#type: self.r#type,
                show_speaker_label: self.show_speaker_label.unwrap_or_default(),
                session_id: self.session_id,
                transcript_result_stream: self.transcript_result_stream.ok_or_else(|| {
                    ::aws_smithy_types::error::operation::BuildError::missing_field(
                        "transcript_result_stream",
                        "transcript_result_stream was not specified but it is required when building StartMedicalStreamTranscriptionOutput",
                    )
                })?,
                enable_channel_identification: self.enable_channel_identification.unwrap_or_default(),
                number_of_channels: self.number_of_channels,
                content_identification_type: self.content_identification_type,
                _request_id: self._request_id,
            },
        )
    }
}
