// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Description of the voice.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct Voice {
    /// <p>Gender of the voice.</p>
    pub gender: ::std::option::Option<crate::types::Gender>,
    /// <p>Amazon Polly assigned voice ID. This is the ID that you specify when calling the <code>SynthesizeSpeech</code> operation.</p>
    pub id: ::std::option::Option<crate::types::VoiceId>,
    /// <p>Language code of the voice.</p>
    pub language_code: ::std::option::Option<crate::types::LanguageCode>,
    /// <p>Human readable name of the language in English.</p>
    pub language_name: ::std::option::Option<::std::string::String>,
    /// <p>Name of the voice (for example, Salli, Kendra, etc.). This provides a human readable voice name that you might display in your application.</p>
    pub name: ::std::option::Option<::std::string::String>,
    /// <p>Additional codes for languages available for the specified voice in addition to its default language.</p>
    /// <p>For example, the default language for Aditi is Indian English (en-IN) because it was first used for that language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter would show the code <code>hi-IN</code>.</p>
    pub additional_language_codes: ::std::option::Option<::std::vec::Vec<crate::types::LanguageCode>>,
    /// <p>Specifies which engines (<code>standard</code>, <code>neural</code>, <code>long-form</code> or <code>generative</code>) are supported by a given voice.</p>
    pub supported_engines: ::std::option::Option<::std::vec::Vec<crate::types::Engine>>,
}
impl Voice {
    /// <p>Gender of the voice.</p>
    pub fn gender(&self) -> ::std::option::Option<&crate::types::Gender> {
        self.gender.as_ref()
    }
    /// <p>Amazon Polly assigned voice ID. This is the ID that you specify when calling the <code>SynthesizeSpeech</code> operation.</p>
    pub fn id(&self) -> ::std::option::Option<&crate::types::VoiceId> {
        self.id.as_ref()
    }
    /// <p>Language code of the voice.</p>
    pub fn language_code(&self) -> ::std::option::Option<&crate::types::LanguageCode> {
        self.language_code.as_ref()
    }
    /// <p>Human readable name of the language in English.</p>
    pub fn language_name(&self) -> ::std::option::Option<&str> {
        self.language_name.as_deref()
    }
    /// <p>Name of the voice (for example, Salli, Kendra, etc.). This provides a human readable voice name that you might display in your application.</p>
    pub fn name(&self) -> ::std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>Additional codes for languages available for the specified voice in addition to its default language.</p>
    /// <p>For example, the default language for Aditi is Indian English (en-IN) because it was first used for that language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter would show the code <code>hi-IN</code>.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.additional_language_codes.is_none()`.
    pub fn additional_language_codes(&self) -> &[crate::types::LanguageCode] {
        self.additional_language_codes.as_deref().unwrap_or_default()
    }
    /// <p>Specifies which engines (<code>standard</code>, <code>neural</code>, <code>long-form</code> or <code>generative</code>) are supported by a given voice.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.supported_engines.is_none()`.
    pub fn supported_engines(&self) -> &[crate::types::Engine] {
        self.supported_engines.as_deref().unwrap_or_default()
    }
}
impl Voice {
    /// Creates a new builder-style object to manufacture [`Voice`](crate::types::Voice).
    pub fn builder() -> crate::types::builders::VoiceBuilder {
        crate::types::builders::VoiceBuilder::default()
    }
}

/// A builder for [`Voice`](crate::types::Voice).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct VoiceBuilder {
    pub(crate) gender: ::std::option::Option<crate::types::Gender>,
    pub(crate) id: ::std::option::Option<crate::types::VoiceId>,
    pub(crate) language_code: ::std::option::Option<crate::types::LanguageCode>,
    pub(crate) language_name: ::std::option::Option<::std::string::String>,
    pub(crate) name: ::std::option::Option<::std::string::String>,
    pub(crate) additional_language_codes: ::std::option::Option<::std::vec::Vec<crate::types::LanguageCode>>,
    pub(crate) supported_engines: ::std::option::Option<::std::vec::Vec<crate::types::Engine>>,
}
impl VoiceBuilder {
    /// <p>Gender of the voice.</p>
    pub fn gender(mut self, input: crate::types::Gender) -> Self {
        self.gender = ::std::option::Option::Some(input);
        self
    }
    /// <p>Gender of the voice.</p>
    pub fn set_gender(mut self, input: ::std::option::Option<crate::types::Gender>) -> Self {
        self.gender = input;
        self
    }
    /// <p>Gender of the voice.</p>
    pub fn get_gender(&self) -> &::std::option::Option<crate::types::Gender> {
        &self.gender
    }
    /// <p>Amazon Polly assigned voice ID. This is the ID that you specify when calling the <code>SynthesizeSpeech</code> operation.</p>
    pub fn id(mut self, input: crate::types::VoiceId) -> Self {
        self.id = ::std::option::Option::Some(input);
        self
    }
    /// <p>Amazon Polly assigned voice ID. This is the ID that you specify when calling the <code>SynthesizeSpeech</code> operation.</p>
    pub fn set_id(mut self, input: ::std::option::Option<crate::types::VoiceId>) -> Self {
        self.id = input;
        self
    }
    /// <p>Amazon Polly assigned voice ID. This is the ID that you specify when calling the <code>SynthesizeSpeech</code> operation.</p>
    pub fn get_id(&self) -> &::std::option::Option<crate::types::VoiceId> {
        &self.id
    }
    /// <p>Language code of the voice.</p>
    pub fn language_code(mut self, input: crate::types::LanguageCode) -> Self {
        self.language_code = ::std::option::Option::Some(input);
        self
    }
    /// <p>Language code of the voice.</p>
    pub fn set_language_code(mut self, input: ::std::option::Option<crate::types::LanguageCode>) -> Self {
        self.language_code = input;
        self
    }
    /// <p>Language code of the voice.</p>
    pub fn get_language_code(&self) -> &::std::option::Option<crate::types::LanguageCode> {
        &self.language_code
    }
    /// <p>Human readable name of the language in English.</p>
    pub fn language_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.language_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Human readable name of the language in English.</p>
    pub fn set_language_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.language_name = input;
        self
    }
    /// <p>Human readable name of the language in English.</p>
    pub fn get_language_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.language_name
    }
    /// <p>Name of the voice (for example, Salli, Kendra, etc.). This provides a human readable voice name that you might display in your application.</p>
    pub fn name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Name of the voice (for example, Salli, Kendra, etc.). This provides a human readable voice name that you might display in your application.</p>
    pub fn set_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.name = input;
        self
    }
    /// <p>Name of the voice (for example, Salli, Kendra, etc.). This provides a human readable voice name that you might display in your application.</p>
    pub fn get_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.name
    }
    /// Appends an item to `additional_language_codes`.
    ///
    /// To override the contents of this collection use [`set_additional_language_codes`](Self::set_additional_language_codes).
    ///
    /// <p>Additional codes for languages available for the specified voice in addition to its default language.</p>
    /// <p>For example, the default language for Aditi is Indian English (en-IN) because it was first used for that language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter would show the code <code>hi-IN</code>.</p>
    pub fn additional_language_codes(mut self, input: crate::types::LanguageCode) -> Self {
        let mut v = self.additional_language_codes.unwrap_or_default();
        v.push(input);
        self.additional_language_codes = ::std::option::Option::Some(v);
        self
    }
    /// <p>Additional codes for languages available for the specified voice in addition to its default language.</p>
    /// <p>For example, the default language for Aditi is Indian English (en-IN) because it was first used for that language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter would show the code <code>hi-IN</code>.</p>
    pub fn set_additional_language_codes(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::LanguageCode>>) -> Self {
        self.additional_language_codes = input;
        self
    }
    /// <p>Additional codes for languages available for the specified voice in addition to its default language.</p>
    /// <p>For example, the default language for Aditi is Indian English (en-IN) because it was first used for that language. Since Aditi is bilingual and fluent in both Indian English and Hindi, this parameter would show the code <code>hi-IN</code>.</p>
    pub fn get_additional_language_codes(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::LanguageCode>> {
        &self.additional_language_codes
    }
    /// Appends an item to `supported_engines`.
    ///
    /// To override the contents of this collection use [`set_supported_engines`](Self::set_supported_engines).
    ///
    /// <p>Specifies which engines (<code>standard</code>, <code>neural</code>, <code>long-form</code> or <code>generative</code>) are supported by a given voice.</p>
    pub fn supported_engines(mut self, input: crate::types::Engine) -> Self {
        let mut v = self.supported_engines.unwrap_or_default();
        v.push(input);
        self.supported_engines = ::std::option::Option::Some(v);
        self
    }
    /// <p>Specifies which engines (<code>standard</code>, <code>neural</code>, <code>long-form</code> or <code>generative</code>) are supported by a given voice.</p>
    pub fn set_supported_engines(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::Engine>>) -> Self {
        self.supported_engines = input;
        self
    }
    /// <p>Specifies which engines (<code>standard</code>, <code>neural</code>, <code>long-form</code> or <code>generative</code>) are supported by a given voice.</p>
    pub fn get_supported_engines(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::Engine>> {
        &self.supported_engines
    }
    /// Consumes the builder and constructs a [`Voice`](crate::types::Voice).
    pub fn build(self) -> crate::types::Voice {
        crate::types::Voice {
            gender: self.gender,
            id: self.id,
            language_code: self.language_code,
            language_name: self.language_name,
            name: self.name,
            additional_language_codes: self.additional_language_codes,
            supported_engines: self.supported_engines,
        }
    }
}
