// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A structure that encapsulates, or contains, the media storage configuration properties.</p>
/// <ul>
/// <li>
/// <p>If <code>StorageStatus</code> is enabled, the data will be stored in the <code>StreamARN</code> provided. In order for WebRTC Ingestion to work, the stream must have data retention enabled.</p></li>
/// <li>
/// <p>If <code>StorageStatus</code> is disabled, no data will be stored, and the <code>StreamARN</code> parameter will not be needed.</p></li>
/// </ul>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct MediaStorageConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the stream.</p>
    pub stream_arn: ::std::option::Option<::std::string::String>,
    /// <p>The status of the media storage configuration.</p>
    pub status: crate::types::MediaStorageConfigurationStatus,
}
impl MediaStorageConfiguration {
    /// <p>The Amazon Resource Name (ARN) of the stream.</p>
    pub fn stream_arn(&self) -> ::std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
    /// <p>The status of the media storage configuration.</p>
    pub fn status(&self) -> &crate::types::MediaStorageConfigurationStatus {
        &self.status
    }
}
impl MediaStorageConfiguration {
    /// Creates a new builder-style object to manufacture [`MediaStorageConfiguration`](crate::types::MediaStorageConfiguration).
    pub fn builder() -> crate::types::builders::MediaStorageConfigurationBuilder {
        crate::types::builders::MediaStorageConfigurationBuilder::default()
    }
}

/// A builder for [`MediaStorageConfiguration`](crate::types::MediaStorageConfiguration).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct MediaStorageConfigurationBuilder {
    pub(crate) stream_arn: ::std::option::Option<::std::string::String>,
    pub(crate) status: ::std::option::Option<crate::types::MediaStorageConfigurationStatus>,
}
impl MediaStorageConfigurationBuilder {
    /// <p>The Amazon Resource Name (ARN) of the stream.</p>
    pub fn stream_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.stream_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the stream.</p>
    pub fn set_stream_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.stream_arn = input;
        self
    }
    /// <p>The Amazon Resource Name (ARN) of the stream.</p>
    pub fn get_stream_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.stream_arn
    }
    /// <p>The status of the media storage configuration.</p>
    /// This field is required.
    pub fn status(mut self, input: crate::types::MediaStorageConfigurationStatus) -> Self {
        self.status = ::std::option::Option::Some(input);
        self
    }
    /// <p>The status of the media storage configuration.</p>
    pub fn set_status(mut self, input: ::std::option::Option<crate::types::MediaStorageConfigurationStatus>) -> Self {
        self.status = input;
        self
    }
    /// <p>The status of the media storage configuration.</p>
    pub fn get_status(&self) -> &::std::option::Option<crate::types::MediaStorageConfigurationStatus> {
        &self.status
    }
    /// Consumes the builder and constructs a [`MediaStorageConfiguration`](crate::types::MediaStorageConfiguration).
    /// This method will fail if any of the following fields are not set:
    /// - [`status`](crate::types::builders::MediaStorageConfigurationBuilder::status)
    pub fn build(self) -> ::std::result::Result<crate::types::MediaStorageConfiguration, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::MediaStorageConfiguration {
            stream_arn: self.stream_arn,
            status: self.status.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "status",
                    "status was not specified but it is required when building MediaStorageConfiguration",
                )
            })?,
        })
    }
}
