// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::create_signaling_channel::_create_signaling_channel_output::CreateSignalingChannelOutputBuilder;

pub use crate::operation::create_signaling_channel::_create_signaling_channel_input::CreateSignalingChannelInputBuilder;

impl crate::operation::create_signaling_channel::builders::CreateSignalingChannelInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::create_signaling_channel::CreateSignalingChannelOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::create_signaling_channel::CreateSignalingChannelError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.create_signaling_channel();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `CreateSignalingChannel`.
///
/// <p>Creates a signaling channel.</p>
/// <p><code>CreateSignalingChannel</code> is an asynchronous operation.</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct CreateSignalingChannelFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::create_signaling_channel::builders::CreateSignalingChannelInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::create_signaling_channel::CreateSignalingChannelOutput,
        crate::operation::create_signaling_channel::CreateSignalingChannelError,
    > for CreateSignalingChannelFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::create_signaling_channel::CreateSignalingChannelOutput,
            crate::operation::create_signaling_channel::CreateSignalingChannelError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl CreateSignalingChannelFluentBuilder {
    /// Creates a new `CreateSignalingChannelFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the CreateSignalingChannel as a reference.
    pub fn as_input(&self) -> &crate::operation::create_signaling_channel::builders::CreateSignalingChannelInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::create_signaling_channel::CreateSignalingChannelOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::create_signaling_channel::CreateSignalingChannelError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::create_signaling_channel::CreateSignalingChannel::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::create_signaling_channel::CreateSignalingChannel::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::create_signaling_channel::CreateSignalingChannelOutput,
        crate::operation::create_signaling_channel::CreateSignalingChannelError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>A name for the signaling channel that you are creating. It must be unique for each Amazon Web Services account and Amazon Web Services Region.</p>
    pub fn channel_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.channel_name(input.into());
        self
    }
    /// <p>A name for the signaling channel that you are creating. It must be unique for each Amazon Web Services account and Amazon Web Services Region.</p>
    pub fn set_channel_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_channel_name(input);
        self
    }
    /// <p>A name for the signaling channel that you are creating. It must be unique for each Amazon Web Services account and Amazon Web Services Region.</p>
    pub fn get_channel_name(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_channel_name()
    }
    /// <p>A type of the signaling channel that you are creating. Currently, <code>SINGLE_MASTER</code> is the only supported channel type.</p>
    pub fn channel_type(mut self, input: crate::types::ChannelType) -> Self {
        self.inner = self.inner.channel_type(input);
        self
    }
    /// <p>A type of the signaling channel that you are creating. Currently, <code>SINGLE_MASTER</code> is the only supported channel type.</p>
    pub fn set_channel_type(mut self, input: ::std::option::Option<crate::types::ChannelType>) -> Self {
        self.inner = self.inner.set_channel_type(input);
        self
    }
    /// <p>A type of the signaling channel that you are creating. Currently, <code>SINGLE_MASTER</code> is the only supported channel type.</p>
    pub fn get_channel_type(&self) -> &::std::option::Option<crate::types::ChannelType> {
        self.inner.get_channel_type()
    }
    /// <p>A structure containing the configuration for the <code>SINGLE_MASTER</code> channel type.</p>
    pub fn single_master_configuration(mut self, input: crate::types::SingleMasterConfiguration) -> Self {
        self.inner = self.inner.single_master_configuration(input);
        self
    }
    /// <p>A structure containing the configuration for the <code>SINGLE_MASTER</code> channel type.</p>
    pub fn set_single_master_configuration(mut self, input: ::std::option::Option<crate::types::SingleMasterConfiguration>) -> Self {
        self.inner = self.inner.set_single_master_configuration(input);
        self
    }
    /// <p>A structure containing the configuration for the <code>SINGLE_MASTER</code> channel type.</p>
    pub fn get_single_master_configuration(&self) -> &::std::option::Option<crate::types::SingleMasterConfiguration> {
        self.inner.get_single_master_configuration()
    }
    ///
    /// Appends an item to `Tags`.
    ///
    /// To override the contents of this collection use [`set_tags`](Self::set_tags).
    ///
    /// <p>A set of tags (key-value pairs) that you want to associate with this channel.</p>
    pub fn tags(mut self, input: crate::types::Tag) -> Self {
        self.inner = self.inner.tags(input);
        self
    }
    /// <p>A set of tags (key-value pairs) that you want to associate with this channel.</p>
    pub fn set_tags(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::Tag>>) -> Self {
        self.inner = self.inner.set_tags(input);
        self
    }
    /// <p>A set of tags (key-value pairs) that you want to associate with this channel.</p>
    pub fn get_tags(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::Tag>> {
        self.inner.get_tags()
    }
}
