// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/aiplatform/v1beta1/metadata_service.proto

package aiplatformpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for
// [MetadataService.CreateMetadataStore][google.cloud.aiplatform.v1beta1.MetadataService.CreateMetadataStore].
type CreateMetadataStoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Location where the MetadataStore should
	// be created.
	// Format: `projects/{project}/locations/{location}/`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The MetadataStore to create.
	MetadataStore *MetadataStore `protobuf:"bytes,2,opt,name=metadata_store,json=metadataStore,proto3" json:"metadata_store,omitempty"`
	// The {metadatastore} portion of the resource name with the format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
	// If not provided, the MetadataStore's ID will be a UUID generated by the
	// service.
	// Must be 4-128 characters in length. Valid characters are `/[a-z][0-9]-/`.
	// Must be unique across all MetadataStores in the parent Location.
	// (Otherwise the request will fail with ALREADY_EXISTS, or PERMISSION_DENIED
	// if the caller can't view the preexisting MetadataStore.)
	MetadataStoreId string `protobuf:"bytes,3,opt,name=metadata_store_id,json=metadataStoreId,proto3" json:"metadata_store_id,omitempty"`
}

func (x *CreateMetadataStoreRequest) Reset() {
	*x = CreateMetadataStoreRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateMetadataStoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMetadataStoreRequest) ProtoMessage() {}

func (x *CreateMetadataStoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMetadataStoreRequest.ProtoReflect.Descriptor instead.
func (*CreateMetadataStoreRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreateMetadataStoreRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateMetadataStoreRequest) GetMetadataStore() *MetadataStore {
	if x != nil {
		return x.MetadataStore
	}
	return nil
}

func (x *CreateMetadataStoreRequest) GetMetadataStoreId() string {
	if x != nil {
		return x.MetadataStoreId
	}
	return ""
}

// Details of operations that perform
// [MetadataService.CreateMetadataStore][google.cloud.aiplatform.v1beta1.MetadataService.CreateMetadataStore].
type CreateMetadataStoreOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation metadata for creating a MetadataStore.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *CreateMetadataStoreOperationMetadata) Reset() {
	*x = CreateMetadataStoreOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateMetadataStoreOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMetadataStoreOperationMetadata) ProtoMessage() {}

func (x *CreateMetadataStoreOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMetadataStoreOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateMetadataStoreOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{1}
}

func (x *CreateMetadataStoreOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Request message for
// [MetadataService.GetMetadataStore][google.cloud.aiplatform.v1beta1.MetadataService.GetMetadataStore].
type GetMetadataStoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the MetadataStore to retrieve.
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetMetadataStoreRequest) Reset() {
	*x = GetMetadataStoreRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadataStoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadataStoreRequest) ProtoMessage() {}

func (x *GetMetadataStoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadataStoreRequest.ProtoReflect.Descriptor instead.
func (*GetMetadataStoreRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{2}
}

func (x *GetMetadataStoreRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [MetadataService.ListMetadataStores][google.cloud.aiplatform.v1beta1.MetadataService.ListMetadataStores].
type ListMetadataStoresRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Location whose MetadataStores should be listed.
	// Format:
	// `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of Metadata Stores to return. The service may return
	// fewer.
	// Must be in range 1-1000, inclusive. Defaults to 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous
	// [MetadataService.ListMetadataStores][google.cloud.aiplatform.v1beta1.MetadataService.ListMetadataStores]
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other provided parameters must match the call that
	// provided the page token. (Otherwise the request will fail with
	// INVALID_ARGUMENT error.)
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListMetadataStoresRequest) Reset() {
	*x = ListMetadataStoresRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListMetadataStoresRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMetadataStoresRequest) ProtoMessage() {}

func (x *ListMetadataStoresRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMetadataStoresRequest.ProtoReflect.Descriptor instead.
func (*ListMetadataStoresRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListMetadataStoresRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMetadataStoresRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListMetadataStoresRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [MetadataService.ListMetadataStores][google.cloud.aiplatform.v1beta1.MetadataService.ListMetadataStores].
type ListMetadataStoresResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The MetadataStores found for the Location.
	MetadataStores []*MetadataStore `protobuf:"bytes,1,rep,name=metadata_stores,json=metadataStores,proto3" json:"metadata_stores,omitempty"`
	// A token, which can be sent as
	// [ListMetadataStoresRequest.page_token][google.cloud.aiplatform.v1beta1.ListMetadataStoresRequest.page_token]
	// to retrieve the next page. If this field is not populated, there are no
	// subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListMetadataStoresResponse) Reset() {
	*x = ListMetadataStoresResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListMetadataStoresResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMetadataStoresResponse) ProtoMessage() {}

func (x *ListMetadataStoresResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMetadataStoresResponse.ProtoReflect.Descriptor instead.
func (*ListMetadataStoresResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListMetadataStoresResponse) GetMetadataStores() []*MetadataStore {
	if x != nil {
		return x.MetadataStores
	}
	return nil
}

func (x *ListMetadataStoresResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [MetadataService.DeleteMetadataStore][google.cloud.aiplatform.v1beta1.MetadataService.DeleteMetadataStore].
type DeleteMetadataStoreRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the MetadataStore to delete.
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Deprecated: Field is no longer supported.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/metadata_service.proto.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteMetadataStoreRequest) Reset() {
	*x = DeleteMetadataStoreRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteMetadataStoreRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteMetadataStoreRequest) ProtoMessage() {}

func (x *DeleteMetadataStoreRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteMetadataStoreRequest.ProtoReflect.Descriptor instead.
func (*DeleteMetadataStoreRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteMetadataStoreRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/metadata_service.proto.
func (x *DeleteMetadataStoreRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Details of operations that perform
// [MetadataService.DeleteMetadataStore][google.cloud.aiplatform.v1beta1.MetadataService.DeleteMetadataStore].
type DeleteMetadataStoreOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation metadata for deleting a MetadataStore.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *DeleteMetadataStoreOperationMetadata) Reset() {
	*x = DeleteMetadataStoreOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteMetadataStoreOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteMetadataStoreOperationMetadata) ProtoMessage() {}

func (x *DeleteMetadataStoreOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteMetadataStoreOperationMetadata.ProtoReflect.Descriptor instead.
func (*DeleteMetadataStoreOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteMetadataStoreOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Request message for
// [MetadataService.CreateArtifact][google.cloud.aiplatform.v1beta1.MetadataService.CreateArtifact].
type CreateArtifactRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the MetadataStore where the Artifact should
	// be created.
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Artifact to create.
	Artifact *Artifact `protobuf:"bytes,2,opt,name=artifact,proto3" json:"artifact,omitempty"`
	// The {artifact} portion of the resource name with the format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
	// If not provided, the Artifact's ID will be a UUID generated by the service.
	// Must be 4-128 characters in length. Valid characters are `/[a-z][0-9]-/`.
	// Must be unique across all Artifacts in the parent MetadataStore. (Otherwise
	// the request will fail with ALREADY_EXISTS, or PERMISSION_DENIED if the
	// caller can't view the preexisting Artifact.)
	ArtifactId string `protobuf:"bytes,3,opt,name=artifact_id,json=artifactId,proto3" json:"artifact_id,omitempty"`
}

func (x *CreateArtifactRequest) Reset() {
	*x = CreateArtifactRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateArtifactRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateArtifactRequest) ProtoMessage() {}

func (x *CreateArtifactRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateArtifactRequest.ProtoReflect.Descriptor instead.
func (*CreateArtifactRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{7}
}

func (x *CreateArtifactRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateArtifactRequest) GetArtifact() *Artifact {
	if x != nil {
		return x.Artifact
	}
	return nil
}

func (x *CreateArtifactRequest) GetArtifactId() string {
	if x != nil {
		return x.ArtifactId
	}
	return ""
}

// Request message for
// [MetadataService.GetArtifact][google.cloud.aiplatform.v1beta1.MetadataService.GetArtifact].
type GetArtifactRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Artifact to retrieve.
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetArtifactRequest) Reset() {
	*x = GetArtifactRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetArtifactRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetArtifactRequest) ProtoMessage() {}

func (x *GetArtifactRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetArtifactRequest.ProtoReflect.Descriptor instead.
func (*GetArtifactRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{8}
}

func (x *GetArtifactRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [MetadataService.ListArtifacts][google.cloud.aiplatform.v1beta1.MetadataService.ListArtifacts].
type ListArtifactsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The MetadataStore whose Artifacts should be listed.
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of Artifacts to return. The service may return fewer.
	// Must be in range 1-1000, inclusive. Defaults to 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous
	// [MetadataService.ListArtifacts][google.cloud.aiplatform.v1beta1.MetadataService.ListArtifacts]
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other provided parameters must match the call that
	// provided the page token. (Otherwise the request will fail with
	// INVALID_ARGUMENT error.)
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filter specifying the boolean condition for the Artifacts to satisfy in
	// order to be part of the result set.
	// The syntax to define filter query is based on https://google.aip.dev/160.
	// The supported set of filters include the following:
	//
	//   - **Attribute filtering**:
	//     For example: `display_name = "test"`.
	//     Supported fields include: `name`, `display_name`, `uri`, `state`,
	//     `schema_title`, `create_time`, and `update_time`.
	//     Time fields, such as `create_time` and `update_time`, require values
	//     specified in RFC-3339 format.
	//     For example: `create_time = "2020-11-19T11:30:00-04:00"`
	//   - **Metadata field**:
	//     To filter on metadata fields use traversal operation as follows:
	//     `metadata.<field_name>.<type_value>`.
	//     For example: `metadata.field_1.number_value = 10.0`
	//     In case the field name contains special characters (such as colon), one
	//     can embed it inside double quote.
	//     For example: `metadata."field:1".number_value = 10.0`
	//   - **Context based filtering**:
	//     To filter Artifacts based on the contexts to which they belong, use the
	//     function operator with the full resource name
	//     `in_context(<context-name>)`.
	//     For example:
	//     `in_context("projects/<project_number>/locations/<location>/metadataStores/<metadatastore_name>/contexts/<context-id>")`
	//
	// Each of the above supported filter types can be combined together using
	// logical operators (`AND` & `OR`). Maximum nested expression depth allowed
	// is 5.
	//
	// For example: `display_name = "test" AND metadata.field1.bool_value = true`.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// How the list of messages is ordered. Specify the values to order by and an
	// ordering operation. The default sorting order is ascending. To specify
	// descending order for a field, users append a " desc" suffix; for example:
	// "foo desc, bar".
	// Subfields are specified with a `.` character, such as foo.bar.
	// see https://google.aip.dev/132#ordering for more details.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListArtifactsRequest) Reset() {
	*x = ListArtifactsRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListArtifactsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListArtifactsRequest) ProtoMessage() {}

func (x *ListArtifactsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListArtifactsRequest.ProtoReflect.Descriptor instead.
func (*ListArtifactsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{9}
}

func (x *ListArtifactsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListArtifactsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListArtifactsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListArtifactsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListArtifactsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for
// [MetadataService.ListArtifacts][google.cloud.aiplatform.v1beta1.MetadataService.ListArtifacts].
type ListArtifactsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Artifacts retrieved from the MetadataStore.
	Artifacts []*Artifact `protobuf:"bytes,1,rep,name=artifacts,proto3" json:"artifacts,omitempty"`
	// A token, which can be sent as
	// [ListArtifactsRequest.page_token][google.cloud.aiplatform.v1beta1.ListArtifactsRequest.page_token]
	// to retrieve the next page.
	// If this field is not populated, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListArtifactsResponse) Reset() {
	*x = ListArtifactsResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListArtifactsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListArtifactsResponse) ProtoMessage() {}

func (x *ListArtifactsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListArtifactsResponse.ProtoReflect.Descriptor instead.
func (*ListArtifactsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{10}
}

func (x *ListArtifactsResponse) GetArtifacts() []*Artifact {
	if x != nil {
		return x.Artifacts
	}
	return nil
}

func (x *ListArtifactsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [MetadataService.UpdateArtifact][google.cloud.aiplatform.v1beta1.MetadataService.UpdateArtifact].
type UpdateArtifactRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Artifact containing updates.
	// The Artifact's
	// [Artifact.name][google.cloud.aiplatform.v1beta1.Artifact.name] field is
	// used to identify the Artifact to be updated. Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
	Artifact *Artifact `protobuf:"bytes,1,opt,name=artifact,proto3" json:"artifact,omitempty"`
	// Optional. A FieldMask indicating which fields should be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// If set to true, and the
	// [Artifact][google.cloud.aiplatform.v1beta1.Artifact] is not found, a new
	// [Artifact][google.cloud.aiplatform.v1beta1.Artifact] is created.
	AllowMissing bool `protobuf:"varint,3,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
}

func (x *UpdateArtifactRequest) Reset() {
	*x = UpdateArtifactRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateArtifactRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateArtifactRequest) ProtoMessage() {}

func (x *UpdateArtifactRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateArtifactRequest.ProtoReflect.Descriptor instead.
func (*UpdateArtifactRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{11}
}

func (x *UpdateArtifactRequest) GetArtifact() *Artifact {
	if x != nil {
		return x.Artifact
	}
	return nil
}

func (x *UpdateArtifactRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateArtifactRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

// Request message for
// [MetadataService.DeleteArtifact][google.cloud.aiplatform.v1beta1.MetadataService.DeleteArtifact].
type DeleteArtifactRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Artifact to delete.
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The etag of the Artifact to delete.
	// If this is provided, it must match the server's etag. Otherwise, the
	// request will fail with a FAILED_PRECONDITION.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteArtifactRequest) Reset() {
	*x = DeleteArtifactRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteArtifactRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteArtifactRequest) ProtoMessage() {}

func (x *DeleteArtifactRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteArtifactRequest.ProtoReflect.Descriptor instead.
func (*DeleteArtifactRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{12}
}

func (x *DeleteArtifactRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteArtifactRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Request message for
// [MetadataService.PurgeArtifacts][google.cloud.aiplatform.v1beta1.MetadataService.PurgeArtifacts].
type PurgeArtifactsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The metadata store to purge Artifacts from.
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. A required filter matching the Artifacts to be purged.
	// E.g., `update_time <= 2020-11-19T11:30:00-04:00`.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Flag to indicate to actually perform the purge.
	// If `force` is set to false, the method will return a sample of
	// Artifact names that would be deleted.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *PurgeArtifactsRequest) Reset() {
	*x = PurgeArtifactsRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PurgeArtifactsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PurgeArtifactsRequest) ProtoMessage() {}

func (x *PurgeArtifactsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PurgeArtifactsRequest.ProtoReflect.Descriptor instead.
func (*PurgeArtifactsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{13}
}

func (x *PurgeArtifactsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *PurgeArtifactsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *PurgeArtifactsRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Response message for
// [MetadataService.PurgeArtifacts][google.cloud.aiplatform.v1beta1.MetadataService.PurgeArtifacts].
type PurgeArtifactsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of Artifacts that this request deleted (or, if `force` is false,
	// the number of Artifacts that will be deleted). This can be an estimate.
	PurgeCount int64 `protobuf:"varint,1,opt,name=purge_count,json=purgeCount,proto3" json:"purge_count,omitempty"`
	// A sample of the Artifact names that will be deleted.
	// Only populated if `force` is set to false. The maximum number of samples is
	// 100 (it is possible to return fewer).
	PurgeSample []string `protobuf:"bytes,2,rep,name=purge_sample,json=purgeSample,proto3" json:"purge_sample,omitempty"`
}

func (x *PurgeArtifactsResponse) Reset() {
	*x = PurgeArtifactsResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PurgeArtifactsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PurgeArtifactsResponse) ProtoMessage() {}

func (x *PurgeArtifactsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PurgeArtifactsResponse.ProtoReflect.Descriptor instead.
func (*PurgeArtifactsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{14}
}

func (x *PurgeArtifactsResponse) GetPurgeCount() int64 {
	if x != nil {
		return x.PurgeCount
	}
	return 0
}

func (x *PurgeArtifactsResponse) GetPurgeSample() []string {
	if x != nil {
		return x.PurgeSample
	}
	return nil
}

// Details of operations that perform
// [MetadataService.PurgeArtifacts][google.cloud.aiplatform.v1beta1.MetadataService.PurgeArtifacts].
type PurgeArtifactsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation metadata for purging Artifacts.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *PurgeArtifactsMetadata) Reset() {
	*x = PurgeArtifactsMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PurgeArtifactsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PurgeArtifactsMetadata) ProtoMessage() {}

func (x *PurgeArtifactsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PurgeArtifactsMetadata.ProtoReflect.Descriptor instead.
func (*PurgeArtifactsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{15}
}

func (x *PurgeArtifactsMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Request message for
// [MetadataService.CreateContext][google.cloud.aiplatform.v1beta1.MetadataService.CreateContext].
type CreateContextRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the MetadataStore where the Context should
	// be created. Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Context to create.
	Context *Context `protobuf:"bytes,2,opt,name=context,proto3" json:"context,omitempty"`
	// The {context} portion of the resource name with the format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`.
	// If not provided, the Context's ID will be a UUID generated by the service.
	// Must be 4-128 characters in length. Valid characters are `/[a-z][0-9]-/`.
	// Must be unique across all Contexts in the parent MetadataStore. (Otherwise
	// the request will fail with ALREADY_EXISTS, or PERMISSION_DENIED if the
	// caller can't view the preexisting Context.)
	ContextId string `protobuf:"bytes,3,opt,name=context_id,json=contextId,proto3" json:"context_id,omitempty"`
}

func (x *CreateContextRequest) Reset() {
	*x = CreateContextRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateContextRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateContextRequest) ProtoMessage() {}

func (x *CreateContextRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateContextRequest.ProtoReflect.Descriptor instead.
func (*CreateContextRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{16}
}

func (x *CreateContextRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateContextRequest) GetContext() *Context {
	if x != nil {
		return x.Context
	}
	return nil
}

func (x *CreateContextRequest) GetContextId() string {
	if x != nil {
		return x.ContextId
	}
	return ""
}

// Request message for
// [MetadataService.GetContext][google.cloud.aiplatform.v1beta1.MetadataService.GetContext].
type GetContextRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Context to retrieve.
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetContextRequest) Reset() {
	*x = GetContextRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetContextRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetContextRequest) ProtoMessage() {}

func (x *GetContextRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetContextRequest.ProtoReflect.Descriptor instead.
func (*GetContextRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{17}
}

func (x *GetContextRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [MetadataService.ListContexts][google.cloud.aiplatform.v1beta1.MetadataService.ListContexts]
type ListContextsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The MetadataStore whose Contexts should be listed.
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of Contexts to return. The service may return fewer.
	// Must be in range 1-1000, inclusive. Defaults to 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous
	// [MetadataService.ListContexts][google.cloud.aiplatform.v1beta1.MetadataService.ListContexts]
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other provided parameters must match the call that
	// provided the page token. (Otherwise the request will fail with
	// INVALID_ARGUMENT error.)
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filter specifying the boolean condition for the Contexts to satisfy in
	// order to be part of the result set.
	// The syntax to define filter query is based on https://google.aip.dev/160.
	// Following are the supported set of filters:
	//
	//   - **Attribute filtering**:
	//     For example: `display_name = "test"`.
	//     Supported fields include: `name`, `display_name`, `schema_title`,
	//     `create_time`, and `update_time`.
	//     Time fields, such as `create_time` and `update_time`, require values
	//     specified in RFC-3339 format.
	//     For example: `create_time = "2020-11-19T11:30:00-04:00"`.
	//
	//   - **Metadata field**:
	//     To filter on metadata fields use traversal operation as follows:
	//     `metadata.<field_name>.<type_value>`.
	//     For example: `metadata.field_1.number_value = 10.0`.
	//     In case the field name contains special characters (such as colon), one
	//     can embed it inside double quote.
	//     For example: `metadata."field:1".number_value = 10.0`
	//
	//   - **Parent Child filtering**:
	//     To filter Contexts based on parent-child relationship use the HAS
	//     operator as follows:
	//
	//     ```
	//     parent_contexts:
	//     "projects/<project_number>/locations/<location>/metadataStores/<metadatastore_name>/contexts/<context_id>"
	//     child_contexts:
	//     "projects/<project_number>/locations/<location>/metadataStores/<metadatastore_name>/contexts/<context_id>"
	//     ```
	//
	// Each of the above supported filters can be combined together using
	// logical operators (`AND` & `OR`). Maximum nested expression depth allowed
	// is 5.
	//
	// For example: `display_name = "test" AND metadata.field1.bool_value = true`.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// How the list of messages is ordered. Specify the values to order by and an
	// ordering operation. The default sorting order is ascending. To specify
	// descending order for a field, users append a " desc" suffix; for example:
	// "foo desc, bar".
	// Subfields are specified with a `.` character, such as foo.bar.
	// see https://google.aip.dev/132#ordering for more details.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListContextsRequest) Reset() {
	*x = ListContextsRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListContextsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListContextsRequest) ProtoMessage() {}

func (x *ListContextsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListContextsRequest.ProtoReflect.Descriptor instead.
func (*ListContextsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{18}
}

func (x *ListContextsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListContextsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListContextsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListContextsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListContextsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for
// [MetadataService.ListContexts][google.cloud.aiplatform.v1beta1.MetadataService.ListContexts].
type ListContextsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Contexts retrieved from the MetadataStore.
	Contexts []*Context `protobuf:"bytes,1,rep,name=contexts,proto3" json:"contexts,omitempty"`
	// A token, which can be sent as
	// [ListContextsRequest.page_token][google.cloud.aiplatform.v1beta1.ListContextsRequest.page_token]
	// to retrieve the next page.
	// If this field is not populated, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListContextsResponse) Reset() {
	*x = ListContextsResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListContextsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListContextsResponse) ProtoMessage() {}

func (x *ListContextsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListContextsResponse.ProtoReflect.Descriptor instead.
func (*ListContextsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{19}
}

func (x *ListContextsResponse) GetContexts() []*Context {
	if x != nil {
		return x.Contexts
	}
	return nil
}

func (x *ListContextsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [MetadataService.UpdateContext][google.cloud.aiplatform.v1beta1.MetadataService.UpdateContext].
type UpdateContextRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Context containing updates.
	// The Context's [Context.name][google.cloud.aiplatform.v1beta1.Context.name]
	// field is used to identify the Context to be updated. Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
	Context *Context `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	// Optional. A FieldMask indicating which fields should be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// If set to true, and the [Context][google.cloud.aiplatform.v1beta1.Context]
	// is not found, a new [Context][google.cloud.aiplatform.v1beta1.Context] is
	// created.
	AllowMissing bool `protobuf:"varint,3,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
}

func (x *UpdateContextRequest) Reset() {
	*x = UpdateContextRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateContextRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateContextRequest) ProtoMessage() {}

func (x *UpdateContextRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateContextRequest.ProtoReflect.Descriptor instead.
func (*UpdateContextRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{20}
}

func (x *UpdateContextRequest) GetContext() *Context {
	if x != nil {
		return x.Context
	}
	return nil
}

func (x *UpdateContextRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateContextRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

// Request message for
// [MetadataService.DeleteContext][google.cloud.aiplatform.v1beta1.MetadataService.DeleteContext].
type DeleteContextRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Context to delete.
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The force deletion semantics is still undefined.
	// Users should not use this field.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
	// Optional. The etag of the Context to delete.
	// If this is provided, it must match the server's etag. Otherwise, the
	// request will fail with a FAILED_PRECONDITION.
	Etag string `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteContextRequest) Reset() {
	*x = DeleteContextRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteContextRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteContextRequest) ProtoMessage() {}

func (x *DeleteContextRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteContextRequest.ProtoReflect.Descriptor instead.
func (*DeleteContextRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{21}
}

func (x *DeleteContextRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteContextRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

func (x *DeleteContextRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Request message for
// [MetadataService.PurgeContexts][google.cloud.aiplatform.v1beta1.MetadataService.PurgeContexts].
type PurgeContextsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The metadata store to purge Contexts from.
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. A required filter matching the Contexts to be purged.
	// E.g., `update_time <= 2020-11-19T11:30:00-04:00`.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Flag to indicate to actually perform the purge.
	// If `force` is set to false, the method will return a sample of
	// Context names that would be deleted.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *PurgeContextsRequest) Reset() {
	*x = PurgeContextsRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PurgeContextsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PurgeContextsRequest) ProtoMessage() {}

func (x *PurgeContextsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PurgeContextsRequest.ProtoReflect.Descriptor instead.
func (*PurgeContextsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{22}
}

func (x *PurgeContextsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *PurgeContextsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *PurgeContextsRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Response message for
// [MetadataService.PurgeContexts][google.cloud.aiplatform.v1beta1.MetadataService.PurgeContexts].
type PurgeContextsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of Contexts that this request deleted (or, if `force` is false,
	// the number of Contexts that will be deleted). This can be an estimate.
	PurgeCount int64 `protobuf:"varint,1,opt,name=purge_count,json=purgeCount,proto3" json:"purge_count,omitempty"`
	// A sample of the Context names that will be deleted.
	// Only populated if `force` is set to false. The maximum number of samples is
	// 100 (it is possible to return fewer).
	PurgeSample []string `protobuf:"bytes,2,rep,name=purge_sample,json=purgeSample,proto3" json:"purge_sample,omitempty"`
}

func (x *PurgeContextsResponse) Reset() {
	*x = PurgeContextsResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PurgeContextsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PurgeContextsResponse) ProtoMessage() {}

func (x *PurgeContextsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PurgeContextsResponse.ProtoReflect.Descriptor instead.
func (*PurgeContextsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{23}
}

func (x *PurgeContextsResponse) GetPurgeCount() int64 {
	if x != nil {
		return x.PurgeCount
	}
	return 0
}

func (x *PurgeContextsResponse) GetPurgeSample() []string {
	if x != nil {
		return x.PurgeSample
	}
	return nil
}

// Details of operations that perform
// [MetadataService.PurgeContexts][google.cloud.aiplatform.v1beta1.MetadataService.PurgeContexts].
type PurgeContextsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation metadata for purging Contexts.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *PurgeContextsMetadata) Reset() {
	*x = PurgeContextsMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PurgeContextsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PurgeContextsMetadata) ProtoMessage() {}

func (x *PurgeContextsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PurgeContextsMetadata.ProtoReflect.Descriptor instead.
func (*PurgeContextsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{24}
}

func (x *PurgeContextsMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Request message for
// [MetadataService.AddContextArtifactsAndExecutions][google.cloud.aiplatform.v1beta1.MetadataService.AddContextArtifactsAndExecutions].
type AddContextArtifactsAndExecutionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Context that the Artifacts and
	// Executions belong to. Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
	Context string `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	// The resource names of the Artifacts to attribute to the Context.
	//
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
	Artifacts []string `protobuf:"bytes,2,rep,name=artifacts,proto3" json:"artifacts,omitempty"`
	// The resource names of the Executions to associate with the
	// Context.
	//
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
	Executions []string `protobuf:"bytes,3,rep,name=executions,proto3" json:"executions,omitempty"`
}

func (x *AddContextArtifactsAndExecutionsRequest) Reset() {
	*x = AddContextArtifactsAndExecutionsRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddContextArtifactsAndExecutionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddContextArtifactsAndExecutionsRequest) ProtoMessage() {}

func (x *AddContextArtifactsAndExecutionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddContextArtifactsAndExecutionsRequest.ProtoReflect.Descriptor instead.
func (*AddContextArtifactsAndExecutionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{25}
}

func (x *AddContextArtifactsAndExecutionsRequest) GetContext() string {
	if x != nil {
		return x.Context
	}
	return ""
}

func (x *AddContextArtifactsAndExecutionsRequest) GetArtifacts() []string {
	if x != nil {
		return x.Artifacts
	}
	return nil
}

func (x *AddContextArtifactsAndExecutionsRequest) GetExecutions() []string {
	if x != nil {
		return x.Executions
	}
	return nil
}

// Response message for
// [MetadataService.AddContextArtifactsAndExecutions][google.cloud.aiplatform.v1beta1.MetadataService.AddContextArtifactsAndExecutions].
type AddContextArtifactsAndExecutionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AddContextArtifactsAndExecutionsResponse) Reset() {
	*x = AddContextArtifactsAndExecutionsResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddContextArtifactsAndExecutionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddContextArtifactsAndExecutionsResponse) ProtoMessage() {}

func (x *AddContextArtifactsAndExecutionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddContextArtifactsAndExecutionsResponse.ProtoReflect.Descriptor instead.
func (*AddContextArtifactsAndExecutionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{26}
}

// Request message for
// [MetadataService.AddContextChildren][google.cloud.aiplatform.v1beta1.MetadataService.AddContextChildren].
type AddContextChildrenRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent Context.
	//
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
	Context string `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	// The resource names of the child Contexts.
	ChildContexts []string `protobuf:"bytes,2,rep,name=child_contexts,json=childContexts,proto3" json:"child_contexts,omitempty"`
}

func (x *AddContextChildrenRequest) Reset() {
	*x = AddContextChildrenRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddContextChildrenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddContextChildrenRequest) ProtoMessage() {}

func (x *AddContextChildrenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddContextChildrenRequest.ProtoReflect.Descriptor instead.
func (*AddContextChildrenRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{27}
}

func (x *AddContextChildrenRequest) GetContext() string {
	if x != nil {
		return x.Context
	}
	return ""
}

func (x *AddContextChildrenRequest) GetChildContexts() []string {
	if x != nil {
		return x.ChildContexts
	}
	return nil
}

// Response message for
// [MetadataService.AddContextChildren][google.cloud.aiplatform.v1beta1.MetadataService.AddContextChildren].
type AddContextChildrenResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AddContextChildrenResponse) Reset() {
	*x = AddContextChildrenResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddContextChildrenResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddContextChildrenResponse) ProtoMessage() {}

func (x *AddContextChildrenResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddContextChildrenResponse.ProtoReflect.Descriptor instead.
func (*AddContextChildrenResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{28}
}

// Request message for
// [MetadataService.DeleteContextChildrenRequest][].
type RemoveContextChildrenRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent Context.
	//
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
	Context string `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
	// The resource names of the child Contexts.
	ChildContexts []string `protobuf:"bytes,2,rep,name=child_contexts,json=childContexts,proto3" json:"child_contexts,omitempty"`
}

func (x *RemoveContextChildrenRequest) Reset() {
	*x = RemoveContextChildrenRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RemoveContextChildrenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveContextChildrenRequest) ProtoMessage() {}

func (x *RemoveContextChildrenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveContextChildrenRequest.ProtoReflect.Descriptor instead.
func (*RemoveContextChildrenRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{29}
}

func (x *RemoveContextChildrenRequest) GetContext() string {
	if x != nil {
		return x.Context
	}
	return ""
}

func (x *RemoveContextChildrenRequest) GetChildContexts() []string {
	if x != nil {
		return x.ChildContexts
	}
	return nil
}

// Response message for
// [MetadataService.RemoveContextChildren][google.cloud.aiplatform.v1beta1.MetadataService.RemoveContextChildren].
type RemoveContextChildrenResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RemoveContextChildrenResponse) Reset() {
	*x = RemoveContextChildrenResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RemoveContextChildrenResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveContextChildrenResponse) ProtoMessage() {}

func (x *RemoveContextChildrenResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveContextChildrenResponse.ProtoReflect.Descriptor instead.
func (*RemoveContextChildrenResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{30}
}

// Request message for
// [MetadataService.QueryContextLineageSubgraph][google.cloud.aiplatform.v1beta1.MetadataService.QueryContextLineageSubgraph].
type QueryContextLineageSubgraphRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Context whose Artifacts and Executions
	// should be retrieved as a LineageSubgraph.
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/contexts/{context}`
	//
	// The request may error with FAILED_PRECONDITION if the number of Artifacts,
	// the number of Executions, or the number of Events that would be returned
	// for the Context exceeds 1000.
	Context string `protobuf:"bytes,1,opt,name=context,proto3" json:"context,omitempty"`
}

func (x *QueryContextLineageSubgraphRequest) Reset() {
	*x = QueryContextLineageSubgraphRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryContextLineageSubgraphRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryContextLineageSubgraphRequest) ProtoMessage() {}

func (x *QueryContextLineageSubgraphRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryContextLineageSubgraphRequest.ProtoReflect.Descriptor instead.
func (*QueryContextLineageSubgraphRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{31}
}

func (x *QueryContextLineageSubgraphRequest) GetContext() string {
	if x != nil {
		return x.Context
	}
	return ""
}

// Request message for
// [MetadataService.CreateExecution][google.cloud.aiplatform.v1beta1.MetadataService.CreateExecution].
type CreateExecutionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the MetadataStore where the Execution should
	// be created.
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Execution to create.
	Execution *Execution `protobuf:"bytes,2,opt,name=execution,proto3" json:"execution,omitempty"`
	// The {execution} portion of the resource name with the format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
	// If not provided, the Execution's ID will be a UUID generated by the
	// service.
	// Must be 4-128 characters in length. Valid characters are `/[a-z][0-9]-/`.
	// Must be unique across all Executions in the parent MetadataStore.
	// (Otherwise the request will fail with ALREADY_EXISTS, or PERMISSION_DENIED
	// if the caller can't view the preexisting Execution.)
	ExecutionId string `protobuf:"bytes,3,opt,name=execution_id,json=executionId,proto3" json:"execution_id,omitempty"`
}

func (x *CreateExecutionRequest) Reset() {
	*x = CreateExecutionRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateExecutionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateExecutionRequest) ProtoMessage() {}

func (x *CreateExecutionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateExecutionRequest.ProtoReflect.Descriptor instead.
func (*CreateExecutionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{32}
}

func (x *CreateExecutionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateExecutionRequest) GetExecution() *Execution {
	if x != nil {
		return x.Execution
	}
	return nil
}

func (x *CreateExecutionRequest) GetExecutionId() string {
	if x != nil {
		return x.ExecutionId
	}
	return ""
}

// Request message for
// [MetadataService.GetExecution][google.cloud.aiplatform.v1beta1.MetadataService.GetExecution].
type GetExecutionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Execution to retrieve.
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetExecutionRequest) Reset() {
	*x = GetExecutionRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetExecutionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetExecutionRequest) ProtoMessage() {}

func (x *GetExecutionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetExecutionRequest.ProtoReflect.Descriptor instead.
func (*GetExecutionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{33}
}

func (x *GetExecutionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [MetadataService.ListExecutions][google.cloud.aiplatform.v1beta1.MetadataService.ListExecutions].
type ListExecutionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The MetadataStore whose Executions should be listed.
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of Executions to return. The service may return fewer.
	// Must be in range 1-1000, inclusive. Defaults to 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous
	// [MetadataService.ListExecutions][google.cloud.aiplatform.v1beta1.MetadataService.ListExecutions]
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other provided parameters must match the call that
	// provided the page token. (Otherwise the request will fail with an
	// INVALID_ARGUMENT error.)
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filter specifying the boolean condition for the Executions to satisfy in
	// order to be part of the result set.
	// The syntax to define filter query is based on https://google.aip.dev/160.
	// Following are the supported set of filters:
	//
	//   - **Attribute filtering**:
	//     For example: `display_name = "test"`.
	//     Supported fields include: `name`, `display_name`, `state`,
	//     `schema_title`, `create_time`, and `update_time`.
	//     Time fields, such as `create_time` and `update_time`, require values
	//     specified in RFC-3339 format.
	//     For example: `create_time = "2020-11-19T11:30:00-04:00"`.
	//   - **Metadata field**:
	//     To filter on metadata fields use traversal operation as follows:
	//     `metadata.<field_name>.<type_value>`
	//     For example: `metadata.field_1.number_value = 10.0`
	//     In case the field name contains special characters (such as colon), one
	//     can embed it inside double quote.
	//     For example: `metadata."field:1".number_value = 10.0`
	//   - **Context based filtering**:
	//     To filter Executions based on the contexts to which they belong use
	//     the function operator with the full resource name:
	//     `in_context(<context-name>)`.
	//     For example:
	//     `in_context("projects/<project_number>/locations/<location>/metadataStores/<metadatastore_name>/contexts/<context-id>")`
	//
	// Each of the above supported filters can be combined together using
	// logical operators (`AND` & `OR`). Maximum nested expression depth allowed
	// is 5.
	//
	// For example: `display_name = "test" AND metadata.field1.bool_value = true`.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// How the list of messages is ordered. Specify the values to order by and an
	// ordering operation. The default sorting order is ascending. To specify
	// descending order for a field, users append a " desc" suffix; for example:
	// "foo desc, bar".
	// Subfields are specified with a `.` character, such as foo.bar.
	// see https://google.aip.dev/132#ordering for more details.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListExecutionsRequest) Reset() {
	*x = ListExecutionsRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListExecutionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListExecutionsRequest) ProtoMessage() {}

func (x *ListExecutionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListExecutionsRequest.ProtoReflect.Descriptor instead.
func (*ListExecutionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{34}
}

func (x *ListExecutionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListExecutionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListExecutionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListExecutionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListExecutionsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for
// [MetadataService.ListExecutions][google.cloud.aiplatform.v1beta1.MetadataService.ListExecutions].
type ListExecutionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Executions retrieved from the MetadataStore.
	Executions []*Execution `protobuf:"bytes,1,rep,name=executions,proto3" json:"executions,omitempty"`
	// A token, which can be sent as
	// [ListExecutionsRequest.page_token][google.cloud.aiplatform.v1beta1.ListExecutionsRequest.page_token]
	// to retrieve the next page.
	// If this field is not populated, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListExecutionsResponse) Reset() {
	*x = ListExecutionsResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListExecutionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListExecutionsResponse) ProtoMessage() {}

func (x *ListExecutionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListExecutionsResponse.ProtoReflect.Descriptor instead.
func (*ListExecutionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{35}
}

func (x *ListExecutionsResponse) GetExecutions() []*Execution {
	if x != nil {
		return x.Executions
	}
	return nil
}

func (x *ListExecutionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [MetadataService.UpdateExecution][google.cloud.aiplatform.v1beta1.MetadataService.UpdateExecution].
type UpdateExecutionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Execution containing updates.
	// The Execution's
	// [Execution.name][google.cloud.aiplatform.v1beta1.Execution.name] field is
	// used to identify the Execution to be updated. Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
	Execution *Execution `protobuf:"bytes,1,opt,name=execution,proto3" json:"execution,omitempty"`
	// Optional. A FieldMask indicating which fields should be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// If set to true, and the
	// [Execution][google.cloud.aiplatform.v1beta1.Execution] is not found, a new
	// [Execution][google.cloud.aiplatform.v1beta1.Execution] is created.
	AllowMissing bool `protobuf:"varint,3,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
}

func (x *UpdateExecutionRequest) Reset() {
	*x = UpdateExecutionRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateExecutionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateExecutionRequest) ProtoMessage() {}

func (x *UpdateExecutionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateExecutionRequest.ProtoReflect.Descriptor instead.
func (*UpdateExecutionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{36}
}

func (x *UpdateExecutionRequest) GetExecution() *Execution {
	if x != nil {
		return x.Execution
	}
	return nil
}

func (x *UpdateExecutionRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateExecutionRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

// Request message for
// [MetadataService.DeleteExecution][google.cloud.aiplatform.v1beta1.MetadataService.DeleteExecution].
type DeleteExecutionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Execution to delete.
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The etag of the Execution to delete.
	// If this is provided, it must match the server's etag. Otherwise, the
	// request will fail with a FAILED_PRECONDITION.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteExecutionRequest) Reset() {
	*x = DeleteExecutionRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteExecutionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteExecutionRequest) ProtoMessage() {}

func (x *DeleteExecutionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteExecutionRequest.ProtoReflect.Descriptor instead.
func (*DeleteExecutionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{37}
}

func (x *DeleteExecutionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteExecutionRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Request message for
// [MetadataService.PurgeExecutions][google.cloud.aiplatform.v1beta1.MetadataService.PurgeExecutions].
type PurgeExecutionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The metadata store to purge Executions from.
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. A required filter matching the Executions to be purged.
	// E.g., `update_time <= 2020-11-19T11:30:00-04:00`.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Flag to indicate to actually perform the purge.
	// If `force` is set to false, the method will return a sample of
	// Execution names that would be deleted.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *PurgeExecutionsRequest) Reset() {
	*x = PurgeExecutionsRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PurgeExecutionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PurgeExecutionsRequest) ProtoMessage() {}

func (x *PurgeExecutionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PurgeExecutionsRequest.ProtoReflect.Descriptor instead.
func (*PurgeExecutionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{38}
}

func (x *PurgeExecutionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *PurgeExecutionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *PurgeExecutionsRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Response message for
// [MetadataService.PurgeExecutions][google.cloud.aiplatform.v1beta1.MetadataService.PurgeExecutions].
type PurgeExecutionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of Executions that this request deleted (or, if `force` is
	// false, the number of Executions that will be deleted). This can be an
	// estimate.
	PurgeCount int64 `protobuf:"varint,1,opt,name=purge_count,json=purgeCount,proto3" json:"purge_count,omitempty"`
	// A sample of the Execution names that will be deleted.
	// Only populated if `force` is set to false. The maximum number of samples is
	// 100 (it is possible to return fewer).
	PurgeSample []string `protobuf:"bytes,2,rep,name=purge_sample,json=purgeSample,proto3" json:"purge_sample,omitempty"`
}

func (x *PurgeExecutionsResponse) Reset() {
	*x = PurgeExecutionsResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PurgeExecutionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PurgeExecutionsResponse) ProtoMessage() {}

func (x *PurgeExecutionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PurgeExecutionsResponse.ProtoReflect.Descriptor instead.
func (*PurgeExecutionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{39}
}

func (x *PurgeExecutionsResponse) GetPurgeCount() int64 {
	if x != nil {
		return x.PurgeCount
	}
	return 0
}

func (x *PurgeExecutionsResponse) GetPurgeSample() []string {
	if x != nil {
		return x.PurgeSample
	}
	return nil
}

// Details of operations that perform
// [MetadataService.PurgeExecutions][google.cloud.aiplatform.v1beta1.MetadataService.PurgeExecutions].
type PurgeExecutionsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation metadata for purging Executions.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *PurgeExecutionsMetadata) Reset() {
	*x = PurgeExecutionsMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PurgeExecutionsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PurgeExecutionsMetadata) ProtoMessage() {}

func (x *PurgeExecutionsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PurgeExecutionsMetadata.ProtoReflect.Descriptor instead.
func (*PurgeExecutionsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{40}
}

func (x *PurgeExecutionsMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Request message for
// [MetadataService.AddExecutionEvents][google.cloud.aiplatform.v1beta1.MetadataService.AddExecutionEvents].
type AddExecutionEventsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Execution that the Events connect
	// Artifacts with.
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
	Execution string `protobuf:"bytes,1,opt,name=execution,proto3" json:"execution,omitempty"`
	// The Events to create and add.
	Events []*Event `protobuf:"bytes,2,rep,name=events,proto3" json:"events,omitempty"`
}

func (x *AddExecutionEventsRequest) Reset() {
	*x = AddExecutionEventsRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddExecutionEventsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddExecutionEventsRequest) ProtoMessage() {}

func (x *AddExecutionEventsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddExecutionEventsRequest.ProtoReflect.Descriptor instead.
func (*AddExecutionEventsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{41}
}

func (x *AddExecutionEventsRequest) GetExecution() string {
	if x != nil {
		return x.Execution
	}
	return ""
}

func (x *AddExecutionEventsRequest) GetEvents() []*Event {
	if x != nil {
		return x.Events
	}
	return nil
}

// Response message for
// [MetadataService.AddExecutionEvents][google.cloud.aiplatform.v1beta1.MetadataService.AddExecutionEvents].
type AddExecutionEventsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AddExecutionEventsResponse) Reset() {
	*x = AddExecutionEventsResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddExecutionEventsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddExecutionEventsResponse) ProtoMessage() {}

func (x *AddExecutionEventsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddExecutionEventsResponse.ProtoReflect.Descriptor instead.
func (*AddExecutionEventsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{42}
}

// Request message for
// [MetadataService.QueryExecutionInputsAndOutputs][google.cloud.aiplatform.v1beta1.MetadataService.QueryExecutionInputsAndOutputs].
type QueryExecutionInputsAndOutputsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Execution whose input and output
	// Artifacts should be retrieved as a LineageSubgraph. Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/executions/{execution}`
	Execution string `protobuf:"bytes,1,opt,name=execution,proto3" json:"execution,omitempty"`
}

func (x *QueryExecutionInputsAndOutputsRequest) Reset() {
	*x = QueryExecutionInputsAndOutputsRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryExecutionInputsAndOutputsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryExecutionInputsAndOutputsRequest) ProtoMessage() {}

func (x *QueryExecutionInputsAndOutputsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryExecutionInputsAndOutputsRequest.ProtoReflect.Descriptor instead.
func (*QueryExecutionInputsAndOutputsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{43}
}

func (x *QueryExecutionInputsAndOutputsRequest) GetExecution() string {
	if x != nil {
		return x.Execution
	}
	return ""
}

// Request message for
// [MetadataService.CreateMetadataSchema][google.cloud.aiplatform.v1beta1.MetadataService.CreateMetadataSchema].
type CreateMetadataSchemaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the MetadataStore where the MetadataSchema
	// should be created. Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The MetadataSchema to create.
	MetadataSchema *MetadataSchema `protobuf:"bytes,2,opt,name=metadata_schema,json=metadataSchema,proto3" json:"metadata_schema,omitempty"`
	// The {metadata_schema} portion of the resource name with the format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/metadataSchemas/{metadataschema}`
	// If not provided, the MetadataStore's ID will be a UUID generated by the
	// service.
	// Must be 4-128 characters in length. Valid characters are `/[a-z][0-9]-/`.
	// Must be unique across all MetadataSchemas in the parent Location.
	// (Otherwise the request will fail with ALREADY_EXISTS, or PERMISSION_DENIED
	// if the caller can't view the preexisting MetadataSchema.)
	MetadataSchemaId string `protobuf:"bytes,3,opt,name=metadata_schema_id,json=metadataSchemaId,proto3" json:"metadata_schema_id,omitempty"`
}

func (x *CreateMetadataSchemaRequest) Reset() {
	*x = CreateMetadataSchemaRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateMetadataSchemaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMetadataSchemaRequest) ProtoMessage() {}

func (x *CreateMetadataSchemaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMetadataSchemaRequest.ProtoReflect.Descriptor instead.
func (*CreateMetadataSchemaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{44}
}

func (x *CreateMetadataSchemaRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateMetadataSchemaRequest) GetMetadataSchema() *MetadataSchema {
	if x != nil {
		return x.MetadataSchema
	}
	return nil
}

func (x *CreateMetadataSchemaRequest) GetMetadataSchemaId() string {
	if x != nil {
		return x.MetadataSchemaId
	}
	return ""
}

// Request message for
// [MetadataService.GetMetadataSchema][google.cloud.aiplatform.v1beta1.MetadataService.GetMetadataSchema].
type GetMetadataSchemaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the MetadataSchema to retrieve.
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/metadataSchemas/{metadataschema}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetMetadataSchemaRequest) Reset() {
	*x = GetMetadataSchemaRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadataSchemaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadataSchemaRequest) ProtoMessage() {}

func (x *GetMetadataSchemaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadataSchemaRequest.ProtoReflect.Descriptor instead.
func (*GetMetadataSchemaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{45}
}

func (x *GetMetadataSchemaRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [MetadataService.ListMetadataSchemas][google.cloud.aiplatform.v1beta1.MetadataService.ListMetadataSchemas].
type ListMetadataSchemasRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The MetadataStore whose MetadataSchemas should be listed.
	// Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of MetadataSchemas to return. The service may return
	// fewer.
	// Must be in range 1-1000, inclusive. Defaults to 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous
	// [MetadataService.ListMetadataSchemas][google.cloud.aiplatform.v1beta1.MetadataService.ListMetadataSchemas]
	// call. Provide this to retrieve the next page.
	//
	// When paginating, all other provided parameters must match the call that
	// provided the page token. (Otherwise the request will fail with
	// INVALID_ARGUMENT error.)
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A query to filter available MetadataSchemas for matching results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListMetadataSchemasRequest) Reset() {
	*x = ListMetadataSchemasRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListMetadataSchemasRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMetadataSchemasRequest) ProtoMessage() {}

func (x *ListMetadataSchemasRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMetadataSchemasRequest.ProtoReflect.Descriptor instead.
func (*ListMetadataSchemasRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{46}
}

func (x *ListMetadataSchemasRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMetadataSchemasRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListMetadataSchemasRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListMetadataSchemasRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for
// [MetadataService.ListMetadataSchemas][google.cloud.aiplatform.v1beta1.MetadataService.ListMetadataSchemas].
type ListMetadataSchemasResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The MetadataSchemas found for the MetadataStore.
	MetadataSchemas []*MetadataSchema `protobuf:"bytes,1,rep,name=metadata_schemas,json=metadataSchemas,proto3" json:"metadata_schemas,omitempty"`
	// A token, which can be sent as
	// [ListMetadataSchemasRequest.page_token][google.cloud.aiplatform.v1beta1.ListMetadataSchemasRequest.page_token]
	// to retrieve the next page. If this field is not populated, there are no
	// subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListMetadataSchemasResponse) Reset() {
	*x = ListMetadataSchemasResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListMetadataSchemasResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMetadataSchemasResponse) ProtoMessage() {}

func (x *ListMetadataSchemasResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMetadataSchemasResponse.ProtoReflect.Descriptor instead.
func (*ListMetadataSchemasResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{47}
}

func (x *ListMetadataSchemasResponse) GetMetadataSchemas() []*MetadataSchema {
	if x != nil {
		return x.MetadataSchemas
	}
	return nil
}

func (x *ListMetadataSchemasResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [MetadataService.QueryArtifactLineageSubgraph][google.cloud.aiplatform.v1beta1.MetadataService.QueryArtifactLineageSubgraph].
type QueryArtifactLineageSubgraphRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Artifact whose Lineage needs to be
	// retrieved as a LineageSubgraph. Format:
	// `projects/{project}/locations/{location}/metadataStores/{metadatastore}/artifacts/{artifact}`
	//
	// The request may error with FAILED_PRECONDITION if the number of Artifacts,
	// the number of Executions, or the number of Events that would be returned
	// for the Context exceeds 1000.
	Artifact string `protobuf:"bytes,1,opt,name=artifact,proto3" json:"artifact,omitempty"`
	// Specifies the size of the lineage graph in terms of number of hops from the
	// specified artifact.
	// Negative Value: INVALID_ARGUMENT error is returned
	// 0: Only input artifact is returned.
	// No value: Transitive closure is performed to return the complete graph.
	MaxHops int32 `protobuf:"varint,2,opt,name=max_hops,json=maxHops,proto3" json:"max_hops,omitempty"`
	// Filter specifying the boolean condition for the Artifacts to satisfy in
	// order to be part of the Lineage Subgraph.
	// The syntax to define filter query is based on https://google.aip.dev/160.
	// The supported set of filters include the following:
	//
	//   - **Attribute filtering**:
	//     For example: `display_name = "test"`
	//     Supported fields include: `name`, `display_name`, `uri`, `state`,
	//     `schema_title`, `create_time`, and `update_time`.
	//     Time fields, such as `create_time` and `update_time`, require values
	//     specified in RFC-3339 format.
	//     For example: `create_time = "2020-11-19T11:30:00-04:00"`
	//   - **Metadata field**:
	//     To filter on metadata fields use traversal operation as follows:
	//     `metadata.<field_name>.<type_value>`.
	//     For example: `metadata.field_1.number_value = 10.0`
	//     In case the field name contains special characters (such as colon), one
	//     can embed it inside double quote.
	//     For example: `metadata."field:1".number_value = 10.0`
	//
	// Each of the above supported filter types can be combined together using
	// logical operators (`AND` & `OR`). Maximum nested expression depth allowed
	// is 5.
	//
	// For example: `display_name = "test" AND metadata.field1.bool_value = true`.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *QueryArtifactLineageSubgraphRequest) Reset() {
	*x = QueryArtifactLineageSubgraphRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QueryArtifactLineageSubgraphRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryArtifactLineageSubgraphRequest) ProtoMessage() {}

func (x *QueryArtifactLineageSubgraphRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryArtifactLineageSubgraphRequest.ProtoReflect.Descriptor instead.
func (*QueryArtifactLineageSubgraphRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP(), []int{48}
}

func (x *QueryArtifactLineageSubgraphRequest) GetArtifact() string {
	if x != nil {
		return x.Artifact
	}
	return ""
}

func (x *QueryArtifactLineageSubgraphRequest) GetMaxHops() int32 {
	if x != nil {
		return x.MaxHops
	}
	return 0
}

func (x *QueryArtifactLineageSubgraphRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

var File_google_cloud_aiplatform_v1beta1_metadata_service_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6c, 0x69, 0x6e, 0x65, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x75, 0x62, 0x67, 0x72, 0x61, 0x70, 0x68, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xe7, 0x01, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5a, 0x0a, 0x0e, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0d, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x12, 0x2a, 0x0a, 0x11, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x22, 0x8c, 0x01,
	0x0a, 0x24, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x64, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69,
	0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x5e, 0x0a, 0x17,
	0x47, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9a, 0x01, 0x0a,
	0x19, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9d, 0x01, 0x0a, 0x1a, 0x4c, 0x69,
	0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x57, 0x0a, 0x0f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x52, 0x0e, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x7b, 0x0a, 0x1a, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x05,
	0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x52,
	0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0x8c, 0x01, 0x0a, 0x24, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x64, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xcd, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x47, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4a, 0x0a, 0x08, 0x61, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x61, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x49, 0x64, 0x22, 0x54, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x41, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x24, 0x0a, 0x22, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc9, 0x01, 0x0a, 0x14,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12, 0x22, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x88, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x47, 0x0a, 0x09, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52,
	0x09, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0xca, 0x01, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x08,
	0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x22,
	0x70, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61,
	0x63, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61,
	0x67, 0x22, 0x93, 0x01, 0x0a, 0x15, 0x50, 0x75, 0x72, 0x67, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x24, 0x12, 0x22, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x05,
	0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0x85, 0x01, 0x0a, 0x16, 0x50, 0x75, 0x72, 0x67,
	0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x75, 0x72, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x70, 0x75, 0x72, 0x67, 0x65, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x4a, 0x0a, 0x0c, 0x70, 0x75, 0x72, 0x67, 0x65, 0x5f, 0x73, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x27, 0xfa, 0x41, 0x24, 0x0a, 0x22,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61,
	0x63, 0x74, 0x52, 0x0b, 0x70, 0x75, 0x72, 0x67, 0x65, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x22,
	0x7e, 0x0a, 0x16, 0x50, 0x75, 0x72, 0x67, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x64, 0x0a, 0x10, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22,
	0xc7, 0x01, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29,
	0x0a, 0x27, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x47, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x49, 0x64, 0x22, 0x52, 0x0a, 0x11, 0x47, 0x65, 0x74,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc7, 0x01,
	0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x12, 0x21, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x84, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x44, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x08, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xc6,
	0x01, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x22, 0x84, 0x01, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05,
	0x66, 0x6f, 0x72, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x91,
	0x01, 0x0a, 0x14, 0x50, 0x75, 0x72, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x12,
	0x21, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x66, 0x6f, 0x72,
	0x63, 0x65, 0x22, 0x83, 0x01, 0x0a, 0x15, 0x50, 0x75, 0x72, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x0a, 0x0b,
	0x70, 0x75, 0x72, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0a, 0x70, 0x75, 0x72, 0x67, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x49, 0x0a,
	0x0c, 0x70, 0x75, 0x72, 0x67, 0x65, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x0b, 0x70, 0x75, 0x72,
	0x67, 0x65, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x22, 0x7d, 0x0a, 0x15, 0x50, 0x75, 0x72, 0x67,
	0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x64, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xff, 0x01, 0x0a, 0x27, 0x41, 0x64, 0x64, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x41,
	0x6e, 0x64, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52,
	0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x45, 0x0a, 0x09, 0x61, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x27, 0xfa, 0x41, 0x24,
	0x0a, 0x22, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x52, 0x09, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x12,
	0x48, 0x0a, 0x0a, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x28, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x2a, 0x0a, 0x28, 0x41, 0x64, 0x64,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73,
	0x41, 0x6e, 0x64, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xaf, 0x01, 0x0a, 0x19, 0x41, 0x64, 0x64, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52,
	0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x4d, 0x0a, 0x0e, 0x63, 0x68, 0x69, 0x6c,
	0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x0d, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x22, 0x1c, 0x0a, 0x1a, 0x41, 0x64, 0x64, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xb2, 0x01, 0x0a, 0x1c, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x4d, 0x0a, 0x0e, 0x63,
	0x68, 0x69, 0x6c, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x0d, 0x63, 0x68, 0x69,
	0x6c, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x22, 0x1f, 0x0a, 0x1d, 0x52, 0x65,
	0x6d, 0x6f, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x43, 0x68, 0x69, 0x6c, 0x64,
	0x72, 0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x69, 0x0a, 0x22, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x4c, 0x69, 0x6e, 0x65, 0x61,
	0x67, 0x65, 0x53, 0x75, 0x62, 0x67, 0x72, 0x61, 0x70, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x43, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x07, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0xd3, 0x01, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x47, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4d, 0x0a, 0x09, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0x56, 0x0a, 0x13,
	0x47, 0x65, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xcb, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x12, 0x23, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x42, 0x79, 0x22, 0x8c, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a,
	0x0a, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0xce, 0x01, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x09,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x23, 0x0a,
	0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69,
	0x6e, 0x67, 0x22, 0x72, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x25, 0x0a, 0x23, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a,
	0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x95, 0x01, 0x0a, 0x16, 0x50, 0x75, 0x72, 0x67, 0x65,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x12, 0x23, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0x87,
	0x01, 0x0a, 0x17, 0x50, 0x75, 0x72, 0x67, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x75,
	0x72, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0a, 0x70, 0x75, 0x72, 0x67, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4b, 0x0a, 0x0c, 0x70,
	0x75, 0x72, 0x67, 0x65, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x28, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x70, 0x75, 0x72,
	0x67, 0x65, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x22, 0x7f, 0x0a, 0x17, 0x50, 0x75, 0x72, 0x67,
	0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x64, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69,
	0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xa6, 0x01, 0x0a, 0x19, 0x41, 0x64,
	0x64, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x09, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x25, 0x0a, 0x23, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x3e, 0x0a, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x73, 0x22, 0x1c, 0x0a, 0x1a, 0x41, 0x64, 0x64, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x72, 0x0a, 0x25, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x41, 0x6e, 0x64, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x09, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xf3, 0x01, 0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5d, 0x0a,
	0x0f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x2c, 0x0a, 0x12,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x49, 0x64, 0x22, 0x60, 0x0a, 0x18, 0x47, 0x65,
	0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xba, 0x01, 0x0a,
	0x1a, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2a, 0x12, 0x28, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xa1, 0x01, 0x0a, 0x1b, 0x4c, 0x69,
	0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5a, 0x0a, 0x10, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x52, 0x0f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa0, 0x01,
	0x0a, 0x23, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x4c,
	0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x53, 0x75, 0x62, 0x67, 0x72, 0x61, 0x70, 0x68, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x08, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a,
	0x22, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x52, 0x08, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x12, 0x19, 0x0a,
	0x08, 0x6d, 0x61, 0x78, 0x5f, 0x68, 0x6f, 0x70, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x07, 0x6d, 0x61, 0x78, 0x48, 0x6f, 0x70, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x32, 0xea, 0x3d, 0x0a, 0x0f, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0xa5, 0x02, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb1, 0x01, 0xca, 0x41, 0x35, 0x0a, 0x0d,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x24, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x27, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2c, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x49, 0x3a, 0x0e, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x22, 0x37, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0xc4, 0x01, 0x0a,
	0x10, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x22, 0x46, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x12, 0x37, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xd7, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x48, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x39, 0x12, 0x37, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x12, 0xfa, 0x01,
	0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x86, 0x01, 0xca, 0x41, 0x3d, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x24,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x39, 0x2a, 0x37, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe8, 0x01, 0x0a, 0x0e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x12, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x22, 0x73, 0xda, 0x41, 0x1b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x2c, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4f, 0x3a, 0x08, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x22, 0x43, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x73, 0x12, 0xc1, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x41, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x22, 0x52, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x45, 0x12, 0x43, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd4, 0x01, 0x0a, 0x0d, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x54, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x12, 0x43, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73,
	0x12, 0xea, 0x01, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x22, 0x75, 0xda, 0x41, 0x14, 0x61, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x58, 0x3a, 0x08, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x32,
	0x4c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x61, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xef, 0x01,
	0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x85, 0x01, 0xca, 0x41, 0x30, 0x0a, 0x15, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x12, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x2a, 0x43, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xfa, 0x01, 0x0a, 0x0e, 0x50, 0x75, 0x72, 0x67, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x72, 0x67, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61,
	0x63, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x90, 0x01, 0xca, 0x41, 0x30, 0x0a,
	0x16, 0x50, 0x75, 0x72, 0x67, 0x65, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x50, 0x75, 0x72, 0x67, 0x65, 0x41, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x3a, 0x01,
	0x2a, 0x22, 0x49, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x3a, 0x70, 0x75, 0x72, 0x67, 0x65, 0x12, 0xe1, 0x01, 0x0a,
	0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22,
	0x6f, 0xda, 0x41, 0x19, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x2c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x4d, 0x3a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0x42, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73,
	0x12, 0xbd, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0x51, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x12, 0x42, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xd0, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x53,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x12,
	0x42, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x73, 0x12, 0xe3, 0x01, 0x0a, 0x0d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0x71, 0xda, 0x41, 0x13, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x55, 0x3a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x32, 0x4a, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xec, 0x01, 0x0a, 0x0d, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x84, 0x01, 0xca, 0x41, 0x30, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x17,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x44, 0x2a, 0x42, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf5, 0x01, 0x0a, 0x0d, 0x50, 0x75, 0x72,
	0x67, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x72,
	0x67, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x8d, 0x01, 0xca, 0x41, 0x2e, 0x0a, 0x15, 0x50, 0x75, 0x72, 0x67, 0x65, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x15, 0x50,
	0x75, 0x72, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x4d, 0x3a, 0x01, 0x2a, 0x22, 0x48, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x3a, 0x70, 0x75, 0x72, 0x67, 0x65,
	0x12, 0xca, 0x02, 0x0a, 0x20, 0x41, 0x64, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x41,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x41, 0x6e, 0x64, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x41, 0x6e, 0x64, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x41, 0x64, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x41, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x73, 0x41, 0x6e, 0x64, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x90, 0x01, 0xda, 0x41, 0x1c,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2c, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x73, 0x2c, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x6b, 0x3a, 0x01, 0x2a, 0x22, 0x66, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x64, 0x64,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73,
	0x41, 0x6e, 0x64, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x8b, 0x02,
	0x0a, 0x12, 0x41, 0x64, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x43, 0x68, 0x69, 0x6c,
	0x64, 0x72, 0x65, 0x6e, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x43, 0x68, 0x69,
	0x6c, 0x64, 0x72, 0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x7c, 0xda,
	0x41, 0x16, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2c, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5d, 0x3a, 0x01,
	0x2a, 0x22, 0x58, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x64, 0x64, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e, 0x12, 0x97, 0x02, 0x0a, 0x15,
	0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x43, 0x68, 0x69,
	0x6c, 0x64, 0x72, 0x65, 0x6e, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x7f, 0xda, 0x41, 0x16, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x2c, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x60, 0x3a, 0x01, 0x2a, 0x22, 0x5b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x43, 0x68, 0x69,
	0x6c, 0x64, 0x72, 0x65, 0x6e, 0x12, 0x89, 0x02, 0x0a, 0x1b, 0x51, 0x75, 0x65, 0x72, 0x79, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x4c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x53, 0x75, 0x62,
	0x67, 0x72, 0x61, 0x70, 0x68, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x4c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x53, 0x75, 0x62, 0x67, 0x72,
	0x61, 0x70, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x6e,
	0x65, 0x61, 0x67, 0x65, 0x53, 0x75, 0x62, 0x67, 0x72, 0x61, 0x70, 0x68, 0x22, 0x73, 0xda, 0x41,
	0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x63, 0x12, 0x61,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x4c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x53, 0x75, 0x62, 0x67, 0x72, 0x61, 0x70,
	0x68, 0x12, 0xef, 0x01, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x77, 0xda, 0x41, 0x1d, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2c,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x51, 0x3a, 0x09, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x44, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0xc5, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x53, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x46, 0x12, 0x44, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd8, 0x01, 0x0a, 0x0e,
	0x4c, 0x69, 0x73, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x55, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46,
	0x12, 0x44, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xf1, 0x01, 0x0a, 0x0f, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x79, 0xda, 0x41, 0x15, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5b, 0x3a,
	0x09, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x32, 0x4e, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf2, 0x01, 0x0a, 0x0f, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x86, 0x01, 0xca, 0x41, 0x30, 0x0a, 0x15, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x12, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x2a, 0x44, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xff, 0x01, 0x0a, 0x0f, 0x50, 0x75, 0x72, 0x67, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x72, 0x67, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x93, 0x01, 0xca, 0x41,
	0x32, 0x0a, 0x17, 0x50, 0x75, 0x72, 0x67, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x17, 0x50, 0x75, 0x72, 0x67,
	0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x4f, 0x3a, 0x01, 0x2a, 0x22, 0x4a, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x70, 0x75, 0x72, 0x67,
	0x65, 0x12, 0x89, 0x02, 0x0a, 0x12, 0x41, 0x64, 0x64, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x7a, 0xda, 0x41, 0x10, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2c,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x61, 0x3a, 0x01, 0x2a, 0x22,
	0x5c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x64, 0x64, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x98, 0x02,
	0x0a, 0x1e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x41, 0x6e, 0x64, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73,
	0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x41, 0x6e, 0x64, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x65, 0x61,
	0x67, 0x65, 0x53, 0x75, 0x62, 0x67, 0x72, 0x61, 0x70, 0x68, 0x22, 0x7c, 0xda, 0x41, 0x09, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6a, 0x12, 0x68,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x41, 0x6e,
	0x64, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x12, 0x96, 0x02, 0x0a, 0x14, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x22, 0x8e, 0x01, 0xda, 0x41, 0x29, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2c, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x69, 0x64, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x5c, 0x3a, 0x0f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0x49, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x73, 0x12, 0xd9, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x22, 0x58, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x4b, 0x12, 0x49, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xec, 0x01,
	0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x5a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x4b, 0x12, 0x49, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x12, 0x8f, 0x02, 0x0a,
	0x1c, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x4c, 0x69,
	0x6e, 0x65, 0x61, 0x67, 0x65, 0x53, 0x75, 0x62, 0x67, 0x72, 0x61, 0x70, 0x68, 0x12, 0x44, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x4c, 0x69, 0x6e,
	0x65, 0x61, 0x67, 0x65, 0x53, 0x75, 0x62, 0x67, 0x72, 0x61, 0x70, 0x68, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x53, 0x75, 0x62,
	0x67, 0x72, 0x61, 0x70, 0x68, 0x22, 0x77, 0xda, 0x41, 0x08, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61,
	0x63, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x66, 0x12, 0x64, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x4c,
	0x69, 0x6e, 0x65, 0x61, 0x67, 0x65, 0x53, 0x75, 0x62, 0x67, 0x72, 0x61, 0x70, 0x68, 0x1a, 0x4d,
	0xca, 0x41, 0x19, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xeb, 0x01,
	0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x14, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42,
	0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes = make([]protoimpl.MessageInfo, 49)
var file_google_cloud_aiplatform_v1beta1_metadata_service_proto_goTypes = []any{
	(*CreateMetadataStoreRequest)(nil),               // 0: google.cloud.aiplatform.v1beta1.CreateMetadataStoreRequest
	(*CreateMetadataStoreOperationMetadata)(nil),     // 1: google.cloud.aiplatform.v1beta1.CreateMetadataStoreOperationMetadata
	(*GetMetadataStoreRequest)(nil),                  // 2: google.cloud.aiplatform.v1beta1.GetMetadataStoreRequest
	(*ListMetadataStoresRequest)(nil),                // 3: google.cloud.aiplatform.v1beta1.ListMetadataStoresRequest
	(*ListMetadataStoresResponse)(nil),               // 4: google.cloud.aiplatform.v1beta1.ListMetadataStoresResponse
	(*DeleteMetadataStoreRequest)(nil),               // 5: google.cloud.aiplatform.v1beta1.DeleteMetadataStoreRequest
	(*DeleteMetadataStoreOperationMetadata)(nil),     // 6: google.cloud.aiplatform.v1beta1.DeleteMetadataStoreOperationMetadata
	(*CreateArtifactRequest)(nil),                    // 7: google.cloud.aiplatform.v1beta1.CreateArtifactRequest
	(*GetArtifactRequest)(nil),                       // 8: google.cloud.aiplatform.v1beta1.GetArtifactRequest
	(*ListArtifactsRequest)(nil),                     // 9: google.cloud.aiplatform.v1beta1.ListArtifactsRequest
	(*ListArtifactsResponse)(nil),                    // 10: google.cloud.aiplatform.v1beta1.ListArtifactsResponse
	(*UpdateArtifactRequest)(nil),                    // 11: google.cloud.aiplatform.v1beta1.UpdateArtifactRequest
	(*DeleteArtifactRequest)(nil),                    // 12: google.cloud.aiplatform.v1beta1.DeleteArtifactRequest
	(*PurgeArtifactsRequest)(nil),                    // 13: google.cloud.aiplatform.v1beta1.PurgeArtifactsRequest
	(*PurgeArtifactsResponse)(nil),                   // 14: google.cloud.aiplatform.v1beta1.PurgeArtifactsResponse
	(*PurgeArtifactsMetadata)(nil),                   // 15: google.cloud.aiplatform.v1beta1.PurgeArtifactsMetadata
	(*CreateContextRequest)(nil),                     // 16: google.cloud.aiplatform.v1beta1.CreateContextRequest
	(*GetContextRequest)(nil),                        // 17: google.cloud.aiplatform.v1beta1.GetContextRequest
	(*ListContextsRequest)(nil),                      // 18: google.cloud.aiplatform.v1beta1.ListContextsRequest
	(*ListContextsResponse)(nil),                     // 19: google.cloud.aiplatform.v1beta1.ListContextsResponse
	(*UpdateContextRequest)(nil),                     // 20: google.cloud.aiplatform.v1beta1.UpdateContextRequest
	(*DeleteContextRequest)(nil),                     // 21: google.cloud.aiplatform.v1beta1.DeleteContextRequest
	(*PurgeContextsRequest)(nil),                     // 22: google.cloud.aiplatform.v1beta1.PurgeContextsRequest
	(*PurgeContextsResponse)(nil),                    // 23: google.cloud.aiplatform.v1beta1.PurgeContextsResponse
	(*PurgeContextsMetadata)(nil),                    // 24: google.cloud.aiplatform.v1beta1.PurgeContextsMetadata
	(*AddContextArtifactsAndExecutionsRequest)(nil),  // 25: google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest
	(*AddContextArtifactsAndExecutionsResponse)(nil), // 26: google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsResponse
	(*AddContextChildrenRequest)(nil),                // 27: google.cloud.aiplatform.v1beta1.AddContextChildrenRequest
	(*AddContextChildrenResponse)(nil),               // 28: google.cloud.aiplatform.v1beta1.AddContextChildrenResponse
	(*RemoveContextChildrenRequest)(nil),             // 29: google.cloud.aiplatform.v1beta1.RemoveContextChildrenRequest
	(*RemoveContextChildrenResponse)(nil),            // 30: google.cloud.aiplatform.v1beta1.RemoveContextChildrenResponse
	(*QueryContextLineageSubgraphRequest)(nil),       // 31: google.cloud.aiplatform.v1beta1.QueryContextLineageSubgraphRequest
	(*CreateExecutionRequest)(nil),                   // 32: google.cloud.aiplatform.v1beta1.CreateExecutionRequest
	(*GetExecutionRequest)(nil),                      // 33: google.cloud.aiplatform.v1beta1.GetExecutionRequest
	(*ListExecutionsRequest)(nil),                    // 34: google.cloud.aiplatform.v1beta1.ListExecutionsRequest
	(*ListExecutionsResponse)(nil),                   // 35: google.cloud.aiplatform.v1beta1.ListExecutionsResponse
	(*UpdateExecutionRequest)(nil),                   // 36: google.cloud.aiplatform.v1beta1.UpdateExecutionRequest
	(*DeleteExecutionRequest)(nil),                   // 37: google.cloud.aiplatform.v1beta1.DeleteExecutionRequest
	(*PurgeExecutionsRequest)(nil),                   // 38: google.cloud.aiplatform.v1beta1.PurgeExecutionsRequest
	(*PurgeExecutionsResponse)(nil),                  // 39: google.cloud.aiplatform.v1beta1.PurgeExecutionsResponse
	(*PurgeExecutionsMetadata)(nil),                  // 40: google.cloud.aiplatform.v1beta1.PurgeExecutionsMetadata
	(*AddExecutionEventsRequest)(nil),                // 41: google.cloud.aiplatform.v1beta1.AddExecutionEventsRequest
	(*AddExecutionEventsResponse)(nil),               // 42: google.cloud.aiplatform.v1beta1.AddExecutionEventsResponse
	(*QueryExecutionInputsAndOutputsRequest)(nil),    // 43: google.cloud.aiplatform.v1beta1.QueryExecutionInputsAndOutputsRequest
	(*CreateMetadataSchemaRequest)(nil),              // 44: google.cloud.aiplatform.v1beta1.CreateMetadataSchemaRequest
	(*GetMetadataSchemaRequest)(nil),                 // 45: google.cloud.aiplatform.v1beta1.GetMetadataSchemaRequest
	(*ListMetadataSchemasRequest)(nil),               // 46: google.cloud.aiplatform.v1beta1.ListMetadataSchemasRequest
	(*ListMetadataSchemasResponse)(nil),              // 47: google.cloud.aiplatform.v1beta1.ListMetadataSchemasResponse
	(*QueryArtifactLineageSubgraphRequest)(nil),      // 48: google.cloud.aiplatform.v1beta1.QueryArtifactLineageSubgraphRequest
	(*MetadataStore)(nil),                            // 49: google.cloud.aiplatform.v1beta1.MetadataStore
	(*GenericOperationMetadata)(nil),                 // 50: google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	(*Artifact)(nil),                                 // 51: google.cloud.aiplatform.v1beta1.Artifact
	(*fieldmaskpb.FieldMask)(nil),                    // 52: google.protobuf.FieldMask
	(*Context)(nil),                                  // 53: google.cloud.aiplatform.v1beta1.Context
	(*Execution)(nil),                                // 54: google.cloud.aiplatform.v1beta1.Execution
	(*Event)(nil),                                    // 55: google.cloud.aiplatform.v1beta1.Event
	(*MetadataSchema)(nil),                           // 56: google.cloud.aiplatform.v1beta1.MetadataSchema
	(*longrunningpb.Operation)(nil),                  // 57: google.longrunning.Operation
	(*LineageSubgraph)(nil),                          // 58: google.cloud.aiplatform.v1beta1.LineageSubgraph
}
var file_google_cloud_aiplatform_v1beta1_metadata_service_proto_depIdxs = []int32{
	49, // 0: google.cloud.aiplatform.v1beta1.CreateMetadataStoreRequest.metadata_store:type_name -> google.cloud.aiplatform.v1beta1.MetadataStore
	50, // 1: google.cloud.aiplatform.v1beta1.CreateMetadataStoreOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	49, // 2: google.cloud.aiplatform.v1beta1.ListMetadataStoresResponse.metadata_stores:type_name -> google.cloud.aiplatform.v1beta1.MetadataStore
	50, // 3: google.cloud.aiplatform.v1beta1.DeleteMetadataStoreOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	51, // 4: google.cloud.aiplatform.v1beta1.CreateArtifactRequest.artifact:type_name -> google.cloud.aiplatform.v1beta1.Artifact
	51, // 5: google.cloud.aiplatform.v1beta1.ListArtifactsResponse.artifacts:type_name -> google.cloud.aiplatform.v1beta1.Artifact
	51, // 6: google.cloud.aiplatform.v1beta1.UpdateArtifactRequest.artifact:type_name -> google.cloud.aiplatform.v1beta1.Artifact
	52, // 7: google.cloud.aiplatform.v1beta1.UpdateArtifactRequest.update_mask:type_name -> google.protobuf.FieldMask
	50, // 8: google.cloud.aiplatform.v1beta1.PurgeArtifactsMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	53, // 9: google.cloud.aiplatform.v1beta1.CreateContextRequest.context:type_name -> google.cloud.aiplatform.v1beta1.Context
	53, // 10: google.cloud.aiplatform.v1beta1.ListContextsResponse.contexts:type_name -> google.cloud.aiplatform.v1beta1.Context
	53, // 11: google.cloud.aiplatform.v1beta1.UpdateContextRequest.context:type_name -> google.cloud.aiplatform.v1beta1.Context
	52, // 12: google.cloud.aiplatform.v1beta1.UpdateContextRequest.update_mask:type_name -> google.protobuf.FieldMask
	50, // 13: google.cloud.aiplatform.v1beta1.PurgeContextsMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	54, // 14: google.cloud.aiplatform.v1beta1.CreateExecutionRequest.execution:type_name -> google.cloud.aiplatform.v1beta1.Execution
	54, // 15: google.cloud.aiplatform.v1beta1.ListExecutionsResponse.executions:type_name -> google.cloud.aiplatform.v1beta1.Execution
	54, // 16: google.cloud.aiplatform.v1beta1.UpdateExecutionRequest.execution:type_name -> google.cloud.aiplatform.v1beta1.Execution
	52, // 17: google.cloud.aiplatform.v1beta1.UpdateExecutionRequest.update_mask:type_name -> google.protobuf.FieldMask
	50, // 18: google.cloud.aiplatform.v1beta1.PurgeExecutionsMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	55, // 19: google.cloud.aiplatform.v1beta1.AddExecutionEventsRequest.events:type_name -> google.cloud.aiplatform.v1beta1.Event
	56, // 20: google.cloud.aiplatform.v1beta1.CreateMetadataSchemaRequest.metadata_schema:type_name -> google.cloud.aiplatform.v1beta1.MetadataSchema
	56, // 21: google.cloud.aiplatform.v1beta1.ListMetadataSchemasResponse.metadata_schemas:type_name -> google.cloud.aiplatform.v1beta1.MetadataSchema
	0,  // 22: google.cloud.aiplatform.v1beta1.MetadataService.CreateMetadataStore:input_type -> google.cloud.aiplatform.v1beta1.CreateMetadataStoreRequest
	2,  // 23: google.cloud.aiplatform.v1beta1.MetadataService.GetMetadataStore:input_type -> google.cloud.aiplatform.v1beta1.GetMetadataStoreRequest
	3,  // 24: google.cloud.aiplatform.v1beta1.MetadataService.ListMetadataStores:input_type -> google.cloud.aiplatform.v1beta1.ListMetadataStoresRequest
	5,  // 25: google.cloud.aiplatform.v1beta1.MetadataService.DeleteMetadataStore:input_type -> google.cloud.aiplatform.v1beta1.DeleteMetadataStoreRequest
	7,  // 26: google.cloud.aiplatform.v1beta1.MetadataService.CreateArtifact:input_type -> google.cloud.aiplatform.v1beta1.CreateArtifactRequest
	8,  // 27: google.cloud.aiplatform.v1beta1.MetadataService.GetArtifact:input_type -> google.cloud.aiplatform.v1beta1.GetArtifactRequest
	9,  // 28: google.cloud.aiplatform.v1beta1.MetadataService.ListArtifacts:input_type -> google.cloud.aiplatform.v1beta1.ListArtifactsRequest
	11, // 29: google.cloud.aiplatform.v1beta1.MetadataService.UpdateArtifact:input_type -> google.cloud.aiplatform.v1beta1.UpdateArtifactRequest
	12, // 30: google.cloud.aiplatform.v1beta1.MetadataService.DeleteArtifact:input_type -> google.cloud.aiplatform.v1beta1.DeleteArtifactRequest
	13, // 31: google.cloud.aiplatform.v1beta1.MetadataService.PurgeArtifacts:input_type -> google.cloud.aiplatform.v1beta1.PurgeArtifactsRequest
	16, // 32: google.cloud.aiplatform.v1beta1.MetadataService.CreateContext:input_type -> google.cloud.aiplatform.v1beta1.CreateContextRequest
	17, // 33: google.cloud.aiplatform.v1beta1.MetadataService.GetContext:input_type -> google.cloud.aiplatform.v1beta1.GetContextRequest
	18, // 34: google.cloud.aiplatform.v1beta1.MetadataService.ListContexts:input_type -> google.cloud.aiplatform.v1beta1.ListContextsRequest
	20, // 35: google.cloud.aiplatform.v1beta1.MetadataService.UpdateContext:input_type -> google.cloud.aiplatform.v1beta1.UpdateContextRequest
	21, // 36: google.cloud.aiplatform.v1beta1.MetadataService.DeleteContext:input_type -> google.cloud.aiplatform.v1beta1.DeleteContextRequest
	22, // 37: google.cloud.aiplatform.v1beta1.MetadataService.PurgeContexts:input_type -> google.cloud.aiplatform.v1beta1.PurgeContextsRequest
	25, // 38: google.cloud.aiplatform.v1beta1.MetadataService.AddContextArtifactsAndExecutions:input_type -> google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsRequest
	27, // 39: google.cloud.aiplatform.v1beta1.MetadataService.AddContextChildren:input_type -> google.cloud.aiplatform.v1beta1.AddContextChildrenRequest
	29, // 40: google.cloud.aiplatform.v1beta1.MetadataService.RemoveContextChildren:input_type -> google.cloud.aiplatform.v1beta1.RemoveContextChildrenRequest
	31, // 41: google.cloud.aiplatform.v1beta1.MetadataService.QueryContextLineageSubgraph:input_type -> google.cloud.aiplatform.v1beta1.QueryContextLineageSubgraphRequest
	32, // 42: google.cloud.aiplatform.v1beta1.MetadataService.CreateExecution:input_type -> google.cloud.aiplatform.v1beta1.CreateExecutionRequest
	33, // 43: google.cloud.aiplatform.v1beta1.MetadataService.GetExecution:input_type -> google.cloud.aiplatform.v1beta1.GetExecutionRequest
	34, // 44: google.cloud.aiplatform.v1beta1.MetadataService.ListExecutions:input_type -> google.cloud.aiplatform.v1beta1.ListExecutionsRequest
	36, // 45: google.cloud.aiplatform.v1beta1.MetadataService.UpdateExecution:input_type -> google.cloud.aiplatform.v1beta1.UpdateExecutionRequest
	37, // 46: google.cloud.aiplatform.v1beta1.MetadataService.DeleteExecution:input_type -> google.cloud.aiplatform.v1beta1.DeleteExecutionRequest
	38, // 47: google.cloud.aiplatform.v1beta1.MetadataService.PurgeExecutions:input_type -> google.cloud.aiplatform.v1beta1.PurgeExecutionsRequest
	41, // 48: google.cloud.aiplatform.v1beta1.MetadataService.AddExecutionEvents:input_type -> google.cloud.aiplatform.v1beta1.AddExecutionEventsRequest
	43, // 49: google.cloud.aiplatform.v1beta1.MetadataService.QueryExecutionInputsAndOutputs:input_type -> google.cloud.aiplatform.v1beta1.QueryExecutionInputsAndOutputsRequest
	44, // 50: google.cloud.aiplatform.v1beta1.MetadataService.CreateMetadataSchema:input_type -> google.cloud.aiplatform.v1beta1.CreateMetadataSchemaRequest
	45, // 51: google.cloud.aiplatform.v1beta1.MetadataService.GetMetadataSchema:input_type -> google.cloud.aiplatform.v1beta1.GetMetadataSchemaRequest
	46, // 52: google.cloud.aiplatform.v1beta1.MetadataService.ListMetadataSchemas:input_type -> google.cloud.aiplatform.v1beta1.ListMetadataSchemasRequest
	48, // 53: google.cloud.aiplatform.v1beta1.MetadataService.QueryArtifactLineageSubgraph:input_type -> google.cloud.aiplatform.v1beta1.QueryArtifactLineageSubgraphRequest
	57, // 54: google.cloud.aiplatform.v1beta1.MetadataService.CreateMetadataStore:output_type -> google.longrunning.Operation
	49, // 55: google.cloud.aiplatform.v1beta1.MetadataService.GetMetadataStore:output_type -> google.cloud.aiplatform.v1beta1.MetadataStore
	4,  // 56: google.cloud.aiplatform.v1beta1.MetadataService.ListMetadataStores:output_type -> google.cloud.aiplatform.v1beta1.ListMetadataStoresResponse
	57, // 57: google.cloud.aiplatform.v1beta1.MetadataService.DeleteMetadataStore:output_type -> google.longrunning.Operation
	51, // 58: google.cloud.aiplatform.v1beta1.MetadataService.CreateArtifact:output_type -> google.cloud.aiplatform.v1beta1.Artifact
	51, // 59: google.cloud.aiplatform.v1beta1.MetadataService.GetArtifact:output_type -> google.cloud.aiplatform.v1beta1.Artifact
	10, // 60: google.cloud.aiplatform.v1beta1.MetadataService.ListArtifacts:output_type -> google.cloud.aiplatform.v1beta1.ListArtifactsResponse
	51, // 61: google.cloud.aiplatform.v1beta1.MetadataService.UpdateArtifact:output_type -> google.cloud.aiplatform.v1beta1.Artifact
	57, // 62: google.cloud.aiplatform.v1beta1.MetadataService.DeleteArtifact:output_type -> google.longrunning.Operation
	57, // 63: google.cloud.aiplatform.v1beta1.MetadataService.PurgeArtifacts:output_type -> google.longrunning.Operation
	53, // 64: google.cloud.aiplatform.v1beta1.MetadataService.CreateContext:output_type -> google.cloud.aiplatform.v1beta1.Context
	53, // 65: google.cloud.aiplatform.v1beta1.MetadataService.GetContext:output_type -> google.cloud.aiplatform.v1beta1.Context
	19, // 66: google.cloud.aiplatform.v1beta1.MetadataService.ListContexts:output_type -> google.cloud.aiplatform.v1beta1.ListContextsResponse
	53, // 67: google.cloud.aiplatform.v1beta1.MetadataService.UpdateContext:output_type -> google.cloud.aiplatform.v1beta1.Context
	57, // 68: google.cloud.aiplatform.v1beta1.MetadataService.DeleteContext:output_type -> google.longrunning.Operation
	57, // 69: google.cloud.aiplatform.v1beta1.MetadataService.PurgeContexts:output_type -> google.longrunning.Operation
	26, // 70: google.cloud.aiplatform.v1beta1.MetadataService.AddContextArtifactsAndExecutions:output_type -> google.cloud.aiplatform.v1beta1.AddContextArtifactsAndExecutionsResponse
	28, // 71: google.cloud.aiplatform.v1beta1.MetadataService.AddContextChildren:output_type -> google.cloud.aiplatform.v1beta1.AddContextChildrenResponse
	30, // 72: google.cloud.aiplatform.v1beta1.MetadataService.RemoveContextChildren:output_type -> google.cloud.aiplatform.v1beta1.RemoveContextChildrenResponse
	58, // 73: google.cloud.aiplatform.v1beta1.MetadataService.QueryContextLineageSubgraph:output_type -> google.cloud.aiplatform.v1beta1.LineageSubgraph
	54, // 74: google.cloud.aiplatform.v1beta1.MetadataService.CreateExecution:output_type -> google.cloud.aiplatform.v1beta1.Execution
	54, // 75: google.cloud.aiplatform.v1beta1.MetadataService.GetExecution:output_type -> google.cloud.aiplatform.v1beta1.Execution
	35, // 76: google.cloud.aiplatform.v1beta1.MetadataService.ListExecutions:output_type -> google.cloud.aiplatform.v1beta1.ListExecutionsResponse
	54, // 77: google.cloud.aiplatform.v1beta1.MetadataService.UpdateExecution:output_type -> google.cloud.aiplatform.v1beta1.Execution
	57, // 78: google.cloud.aiplatform.v1beta1.MetadataService.DeleteExecution:output_type -> google.longrunning.Operation
	57, // 79: google.cloud.aiplatform.v1beta1.MetadataService.PurgeExecutions:output_type -> google.longrunning.Operation
	42, // 80: google.cloud.aiplatform.v1beta1.MetadataService.AddExecutionEvents:output_type -> google.cloud.aiplatform.v1beta1.AddExecutionEventsResponse
	58, // 81: google.cloud.aiplatform.v1beta1.MetadataService.QueryExecutionInputsAndOutputs:output_type -> google.cloud.aiplatform.v1beta1.LineageSubgraph
	56, // 82: google.cloud.aiplatform.v1beta1.MetadataService.CreateMetadataSchema:output_type -> google.cloud.aiplatform.v1beta1.MetadataSchema
	56, // 83: google.cloud.aiplatform.v1beta1.MetadataService.GetMetadataSchema:output_type -> google.cloud.aiplatform.v1beta1.MetadataSchema
	47, // 84: google.cloud.aiplatform.v1beta1.MetadataService.ListMetadataSchemas:output_type -> google.cloud.aiplatform.v1beta1.ListMetadataSchemasResponse
	58, // 85: google.cloud.aiplatform.v1beta1.MetadataService.QueryArtifactLineageSubgraph:output_type -> google.cloud.aiplatform.v1beta1.LineageSubgraph
	54, // [54:86] is the sub-list for method output_type
	22, // [22:54] is the sub-list for method input_type
	22, // [22:22] is the sub-list for extension type_name
	22, // [22:22] is the sub-list for extension extendee
	0,  // [0:22] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_metadata_service_proto_init() }
func file_google_cloud_aiplatform_v1beta1_metadata_service_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_metadata_service_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_artifact_proto_init()
	file_google_cloud_aiplatform_v1beta1_context_proto_init()
	file_google_cloud_aiplatform_v1beta1_event_proto_init()
	file_google_cloud_aiplatform_v1beta1_execution_proto_init()
	file_google_cloud_aiplatform_v1beta1_lineage_subgraph_proto_init()
	file_google_cloud_aiplatform_v1beta1_metadata_schema_proto_init()
	file_google_cloud_aiplatform_v1beta1_metadata_store_proto_init()
	file_google_cloud_aiplatform_v1beta1_operation_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   49,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_metadata_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_metadata_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_metadata_service_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_metadata_service_proto = out.File
	file_google_cloud_aiplatform_v1beta1_metadata_service_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_metadata_service_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_metadata_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// MetadataServiceClient is the client API for MetadataService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type MetadataServiceClient interface {
	// Initializes a MetadataStore, including allocation of resources.
	CreateMetadataStore(ctx context.Context, in *CreateMetadataStoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Retrieves a specific MetadataStore.
	GetMetadataStore(ctx context.Context, in *GetMetadataStoreRequest, opts ...grpc.CallOption) (*MetadataStore, error)
	// Lists MetadataStores for a Location.
	ListMetadataStores(ctx context.Context, in *ListMetadataStoresRequest, opts ...grpc.CallOption) (*ListMetadataStoresResponse, error)
	// Deletes a single MetadataStore and all its child resources (Artifacts,
	// Executions, and Contexts).
	DeleteMetadataStore(ctx context.Context, in *DeleteMetadataStoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates an Artifact associated with a MetadataStore.
	CreateArtifact(ctx context.Context, in *CreateArtifactRequest, opts ...grpc.CallOption) (*Artifact, error)
	// Retrieves a specific Artifact.
	GetArtifact(ctx context.Context, in *GetArtifactRequest, opts ...grpc.CallOption) (*Artifact, error)
	// Lists Artifacts in the MetadataStore.
	ListArtifacts(ctx context.Context, in *ListArtifactsRequest, opts ...grpc.CallOption) (*ListArtifactsResponse, error)
	// Updates a stored Artifact.
	UpdateArtifact(ctx context.Context, in *UpdateArtifactRequest, opts ...grpc.CallOption) (*Artifact, error)
	// Deletes an Artifact.
	DeleteArtifact(ctx context.Context, in *DeleteArtifactRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Purges Artifacts.
	PurgeArtifacts(ctx context.Context, in *PurgeArtifactsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a Context associated with a MetadataStore.
	CreateContext(ctx context.Context, in *CreateContextRequest, opts ...grpc.CallOption) (*Context, error)
	// Retrieves a specific Context.
	GetContext(ctx context.Context, in *GetContextRequest, opts ...grpc.CallOption) (*Context, error)
	// Lists Contexts on the MetadataStore.
	ListContexts(ctx context.Context, in *ListContextsRequest, opts ...grpc.CallOption) (*ListContextsResponse, error)
	// Updates a stored Context.
	UpdateContext(ctx context.Context, in *UpdateContextRequest, opts ...grpc.CallOption) (*Context, error)
	// Deletes a stored Context.
	DeleteContext(ctx context.Context, in *DeleteContextRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Purges Contexts.
	PurgeContexts(ctx context.Context, in *PurgeContextsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Adds a set of Artifacts and Executions to a Context. If any of the
	// Artifacts or Executions have already been added to a Context, they are
	// simply skipped.
	AddContextArtifactsAndExecutions(ctx context.Context, in *AddContextArtifactsAndExecutionsRequest, opts ...grpc.CallOption) (*AddContextArtifactsAndExecutionsResponse, error)
	// Adds a set of Contexts as children to a parent Context. If any of the
	// child Contexts have already been added to the parent Context, they are
	// simply skipped. If this call would create a cycle or cause any Context to
	// have more than 10 parents, the request will fail with an INVALID_ARGUMENT
	// error.
	AddContextChildren(ctx context.Context, in *AddContextChildrenRequest, opts ...grpc.CallOption) (*AddContextChildrenResponse, error)
	// Remove a set of children contexts from a parent Context. If any of the
	// child Contexts were NOT added to the parent Context, they are
	// simply skipped.
	RemoveContextChildren(ctx context.Context, in *RemoveContextChildrenRequest, opts ...grpc.CallOption) (*RemoveContextChildrenResponse, error)
	// Retrieves Artifacts and Executions within the specified Context, connected
	// by Event edges and returned as a LineageSubgraph.
	QueryContextLineageSubgraph(ctx context.Context, in *QueryContextLineageSubgraphRequest, opts ...grpc.CallOption) (*LineageSubgraph, error)
	// Creates an Execution associated with a MetadataStore.
	CreateExecution(ctx context.Context, in *CreateExecutionRequest, opts ...grpc.CallOption) (*Execution, error)
	// Retrieves a specific Execution.
	GetExecution(ctx context.Context, in *GetExecutionRequest, opts ...grpc.CallOption) (*Execution, error)
	// Lists Executions in the MetadataStore.
	ListExecutions(ctx context.Context, in *ListExecutionsRequest, opts ...grpc.CallOption) (*ListExecutionsResponse, error)
	// Updates a stored Execution.
	UpdateExecution(ctx context.Context, in *UpdateExecutionRequest, opts ...grpc.CallOption) (*Execution, error)
	// Deletes an Execution.
	DeleteExecution(ctx context.Context, in *DeleteExecutionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Purges Executions.
	PurgeExecutions(ctx context.Context, in *PurgeExecutionsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Adds Events to the specified Execution. An Event indicates whether an
	// Artifact was used as an input or output for an Execution. If an Event
	// already exists between the Execution and the Artifact, the Event is
	// skipped.
	AddExecutionEvents(ctx context.Context, in *AddExecutionEventsRequest, opts ...grpc.CallOption) (*AddExecutionEventsResponse, error)
	// Obtains the set of input and output Artifacts for this Execution, in the
	// form of LineageSubgraph that also contains the Execution and connecting
	// Events.
	QueryExecutionInputsAndOutputs(ctx context.Context, in *QueryExecutionInputsAndOutputsRequest, opts ...grpc.CallOption) (*LineageSubgraph, error)
	// Creates a MetadataSchema.
	CreateMetadataSchema(ctx context.Context, in *CreateMetadataSchemaRequest, opts ...grpc.CallOption) (*MetadataSchema, error)
	// Retrieves a specific MetadataSchema.
	GetMetadataSchema(ctx context.Context, in *GetMetadataSchemaRequest, opts ...grpc.CallOption) (*MetadataSchema, error)
	// Lists MetadataSchemas.
	ListMetadataSchemas(ctx context.Context, in *ListMetadataSchemasRequest, opts ...grpc.CallOption) (*ListMetadataSchemasResponse, error)
	// Retrieves lineage of an Artifact represented through Artifacts and
	// Executions connected by Event edges and returned as a LineageSubgraph.
	QueryArtifactLineageSubgraph(ctx context.Context, in *QueryArtifactLineageSubgraphRequest, opts ...grpc.CallOption) (*LineageSubgraph, error)
}

type metadataServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewMetadataServiceClient(cc grpc.ClientConnInterface) MetadataServiceClient {
	return &metadataServiceClient{cc}
}

func (c *metadataServiceClient) CreateMetadataStore(ctx context.Context, in *CreateMetadataStoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/CreateMetadataStore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) GetMetadataStore(ctx context.Context, in *GetMetadataStoreRequest, opts ...grpc.CallOption) (*MetadataStore, error) {
	out := new(MetadataStore)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/GetMetadataStore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) ListMetadataStores(ctx context.Context, in *ListMetadataStoresRequest, opts ...grpc.CallOption) (*ListMetadataStoresResponse, error) {
	out := new(ListMetadataStoresResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/ListMetadataStores", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) DeleteMetadataStore(ctx context.Context, in *DeleteMetadataStoreRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/DeleteMetadataStore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) CreateArtifact(ctx context.Context, in *CreateArtifactRequest, opts ...grpc.CallOption) (*Artifact, error) {
	out := new(Artifact)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/CreateArtifact", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) GetArtifact(ctx context.Context, in *GetArtifactRequest, opts ...grpc.CallOption) (*Artifact, error) {
	out := new(Artifact)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/GetArtifact", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) ListArtifacts(ctx context.Context, in *ListArtifactsRequest, opts ...grpc.CallOption) (*ListArtifactsResponse, error) {
	out := new(ListArtifactsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/ListArtifacts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) UpdateArtifact(ctx context.Context, in *UpdateArtifactRequest, opts ...grpc.CallOption) (*Artifact, error) {
	out := new(Artifact)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/UpdateArtifact", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) DeleteArtifact(ctx context.Context, in *DeleteArtifactRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/DeleteArtifact", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) PurgeArtifacts(ctx context.Context, in *PurgeArtifactsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/PurgeArtifacts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) CreateContext(ctx context.Context, in *CreateContextRequest, opts ...grpc.CallOption) (*Context, error) {
	out := new(Context)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/CreateContext", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) GetContext(ctx context.Context, in *GetContextRequest, opts ...grpc.CallOption) (*Context, error) {
	out := new(Context)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/GetContext", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) ListContexts(ctx context.Context, in *ListContextsRequest, opts ...grpc.CallOption) (*ListContextsResponse, error) {
	out := new(ListContextsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/ListContexts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) UpdateContext(ctx context.Context, in *UpdateContextRequest, opts ...grpc.CallOption) (*Context, error) {
	out := new(Context)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/UpdateContext", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) DeleteContext(ctx context.Context, in *DeleteContextRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/DeleteContext", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) PurgeContexts(ctx context.Context, in *PurgeContextsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/PurgeContexts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) AddContextArtifactsAndExecutions(ctx context.Context, in *AddContextArtifactsAndExecutionsRequest, opts ...grpc.CallOption) (*AddContextArtifactsAndExecutionsResponse, error) {
	out := new(AddContextArtifactsAndExecutionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/AddContextArtifactsAndExecutions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) AddContextChildren(ctx context.Context, in *AddContextChildrenRequest, opts ...grpc.CallOption) (*AddContextChildrenResponse, error) {
	out := new(AddContextChildrenResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/AddContextChildren", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) RemoveContextChildren(ctx context.Context, in *RemoveContextChildrenRequest, opts ...grpc.CallOption) (*RemoveContextChildrenResponse, error) {
	out := new(RemoveContextChildrenResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/RemoveContextChildren", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) QueryContextLineageSubgraph(ctx context.Context, in *QueryContextLineageSubgraphRequest, opts ...grpc.CallOption) (*LineageSubgraph, error) {
	out := new(LineageSubgraph)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/QueryContextLineageSubgraph", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) CreateExecution(ctx context.Context, in *CreateExecutionRequest, opts ...grpc.CallOption) (*Execution, error) {
	out := new(Execution)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/CreateExecution", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) GetExecution(ctx context.Context, in *GetExecutionRequest, opts ...grpc.CallOption) (*Execution, error) {
	out := new(Execution)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/GetExecution", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) ListExecutions(ctx context.Context, in *ListExecutionsRequest, opts ...grpc.CallOption) (*ListExecutionsResponse, error) {
	out := new(ListExecutionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/ListExecutions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) UpdateExecution(ctx context.Context, in *UpdateExecutionRequest, opts ...grpc.CallOption) (*Execution, error) {
	out := new(Execution)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/UpdateExecution", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) DeleteExecution(ctx context.Context, in *DeleteExecutionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/DeleteExecution", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) PurgeExecutions(ctx context.Context, in *PurgeExecutionsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/PurgeExecutions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) AddExecutionEvents(ctx context.Context, in *AddExecutionEventsRequest, opts ...grpc.CallOption) (*AddExecutionEventsResponse, error) {
	out := new(AddExecutionEventsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/AddExecutionEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) QueryExecutionInputsAndOutputs(ctx context.Context, in *QueryExecutionInputsAndOutputsRequest, opts ...grpc.CallOption) (*LineageSubgraph, error) {
	out := new(LineageSubgraph)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/QueryExecutionInputsAndOutputs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) CreateMetadataSchema(ctx context.Context, in *CreateMetadataSchemaRequest, opts ...grpc.CallOption) (*MetadataSchema, error) {
	out := new(MetadataSchema)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/CreateMetadataSchema", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) GetMetadataSchema(ctx context.Context, in *GetMetadataSchemaRequest, opts ...grpc.CallOption) (*MetadataSchema, error) {
	out := new(MetadataSchema)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/GetMetadataSchema", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) ListMetadataSchemas(ctx context.Context, in *ListMetadataSchemasRequest, opts ...grpc.CallOption) (*ListMetadataSchemasResponse, error) {
	out := new(ListMetadataSchemasResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/ListMetadataSchemas", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metadataServiceClient) QueryArtifactLineageSubgraph(ctx context.Context, in *QueryArtifactLineageSubgraphRequest, opts ...grpc.CallOption) (*LineageSubgraph, error) {
	out := new(LineageSubgraph)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.MetadataService/QueryArtifactLineageSubgraph", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MetadataServiceServer is the server API for MetadataService service.
type MetadataServiceServer interface {
	// Initializes a MetadataStore, including allocation of resources.
	CreateMetadataStore(context.Context, *CreateMetadataStoreRequest) (*longrunningpb.Operation, error)
	// Retrieves a specific MetadataStore.
	GetMetadataStore(context.Context, *GetMetadataStoreRequest) (*MetadataStore, error)
	// Lists MetadataStores for a Location.
	ListMetadataStores(context.Context, *ListMetadataStoresRequest) (*ListMetadataStoresResponse, error)
	// Deletes a single MetadataStore and all its child resources (Artifacts,
	// Executions, and Contexts).
	DeleteMetadataStore(context.Context, *DeleteMetadataStoreRequest) (*longrunningpb.Operation, error)
	// Creates an Artifact associated with a MetadataStore.
	CreateArtifact(context.Context, *CreateArtifactRequest) (*Artifact, error)
	// Retrieves a specific Artifact.
	GetArtifact(context.Context, *GetArtifactRequest) (*Artifact, error)
	// Lists Artifacts in the MetadataStore.
	ListArtifacts(context.Context, *ListArtifactsRequest) (*ListArtifactsResponse, error)
	// Updates a stored Artifact.
	UpdateArtifact(context.Context, *UpdateArtifactRequest) (*Artifact, error)
	// Deletes an Artifact.
	DeleteArtifact(context.Context, *DeleteArtifactRequest) (*longrunningpb.Operation, error)
	// Purges Artifacts.
	PurgeArtifacts(context.Context, *PurgeArtifactsRequest) (*longrunningpb.Operation, error)
	// Creates a Context associated with a MetadataStore.
	CreateContext(context.Context, *CreateContextRequest) (*Context, error)
	// Retrieves a specific Context.
	GetContext(context.Context, *GetContextRequest) (*Context, error)
	// Lists Contexts on the MetadataStore.
	ListContexts(context.Context, *ListContextsRequest) (*ListContextsResponse, error)
	// Updates a stored Context.
	UpdateContext(context.Context, *UpdateContextRequest) (*Context, error)
	// Deletes a stored Context.
	DeleteContext(context.Context, *DeleteContextRequest) (*longrunningpb.Operation, error)
	// Purges Contexts.
	PurgeContexts(context.Context, *PurgeContextsRequest) (*longrunningpb.Operation, error)
	// Adds a set of Artifacts and Executions to a Context. If any of the
	// Artifacts or Executions have already been added to a Context, they are
	// simply skipped.
	AddContextArtifactsAndExecutions(context.Context, *AddContextArtifactsAndExecutionsRequest) (*AddContextArtifactsAndExecutionsResponse, error)
	// Adds a set of Contexts as children to a parent Context. If any of the
	// child Contexts have already been added to the parent Context, they are
	// simply skipped. If this call would create a cycle or cause any Context to
	// have more than 10 parents, the request will fail with an INVALID_ARGUMENT
	// error.
	AddContextChildren(context.Context, *AddContextChildrenRequest) (*AddContextChildrenResponse, error)
	// Remove a set of children contexts from a parent Context. If any of the
	// child Contexts were NOT added to the parent Context, they are
	// simply skipped.
	RemoveContextChildren(context.Context, *RemoveContextChildrenRequest) (*RemoveContextChildrenResponse, error)
	// Retrieves Artifacts and Executions within the specified Context, connected
	// by Event edges and returned as a LineageSubgraph.
	QueryContextLineageSubgraph(context.Context, *QueryContextLineageSubgraphRequest) (*LineageSubgraph, error)
	// Creates an Execution associated with a MetadataStore.
	CreateExecution(context.Context, *CreateExecutionRequest) (*Execution, error)
	// Retrieves a specific Execution.
	GetExecution(context.Context, *GetExecutionRequest) (*Execution, error)
	// Lists Executions in the MetadataStore.
	ListExecutions(context.Context, *ListExecutionsRequest) (*ListExecutionsResponse, error)
	// Updates a stored Execution.
	UpdateExecution(context.Context, *UpdateExecutionRequest) (*Execution, error)
	// Deletes an Execution.
	DeleteExecution(context.Context, *DeleteExecutionRequest) (*longrunningpb.Operation, error)
	// Purges Executions.
	PurgeExecutions(context.Context, *PurgeExecutionsRequest) (*longrunningpb.Operation, error)
	// Adds Events to the specified Execution. An Event indicates whether an
	// Artifact was used as an input or output for an Execution. If an Event
	// already exists between the Execution and the Artifact, the Event is
	// skipped.
	AddExecutionEvents(context.Context, *AddExecutionEventsRequest) (*AddExecutionEventsResponse, error)
	// Obtains the set of input and output Artifacts for this Execution, in the
	// form of LineageSubgraph that also contains the Execution and connecting
	// Events.
	QueryExecutionInputsAndOutputs(context.Context, *QueryExecutionInputsAndOutputsRequest) (*LineageSubgraph, error)
	// Creates a MetadataSchema.
	CreateMetadataSchema(context.Context, *CreateMetadataSchemaRequest) (*MetadataSchema, error)
	// Retrieves a specific MetadataSchema.
	GetMetadataSchema(context.Context, *GetMetadataSchemaRequest) (*MetadataSchema, error)
	// Lists MetadataSchemas.
	ListMetadataSchemas(context.Context, *ListMetadataSchemasRequest) (*ListMetadataSchemasResponse, error)
	// Retrieves lineage of an Artifact represented through Artifacts and
	// Executions connected by Event edges and returned as a LineageSubgraph.
	QueryArtifactLineageSubgraph(context.Context, *QueryArtifactLineageSubgraphRequest) (*LineageSubgraph, error)
}

// UnimplementedMetadataServiceServer can be embedded to have forward compatible implementations.
type UnimplementedMetadataServiceServer struct {
}

func (*UnimplementedMetadataServiceServer) CreateMetadataStore(context.Context, *CreateMetadataStoreRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMetadataStore not implemented")
}
func (*UnimplementedMetadataServiceServer) GetMetadataStore(context.Context, *GetMetadataStoreRequest) (*MetadataStore, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMetadataStore not implemented")
}
func (*UnimplementedMetadataServiceServer) ListMetadataStores(context.Context, *ListMetadataStoresRequest) (*ListMetadataStoresResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMetadataStores not implemented")
}
func (*UnimplementedMetadataServiceServer) DeleteMetadataStore(context.Context, *DeleteMetadataStoreRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMetadataStore not implemented")
}
func (*UnimplementedMetadataServiceServer) CreateArtifact(context.Context, *CreateArtifactRequest) (*Artifact, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateArtifact not implemented")
}
func (*UnimplementedMetadataServiceServer) GetArtifact(context.Context, *GetArtifactRequest) (*Artifact, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetArtifact not implemented")
}
func (*UnimplementedMetadataServiceServer) ListArtifacts(context.Context, *ListArtifactsRequest) (*ListArtifactsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListArtifacts not implemented")
}
func (*UnimplementedMetadataServiceServer) UpdateArtifact(context.Context, *UpdateArtifactRequest) (*Artifact, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateArtifact not implemented")
}
func (*UnimplementedMetadataServiceServer) DeleteArtifact(context.Context, *DeleteArtifactRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteArtifact not implemented")
}
func (*UnimplementedMetadataServiceServer) PurgeArtifacts(context.Context, *PurgeArtifactsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PurgeArtifacts not implemented")
}
func (*UnimplementedMetadataServiceServer) CreateContext(context.Context, *CreateContextRequest) (*Context, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateContext not implemented")
}
func (*UnimplementedMetadataServiceServer) GetContext(context.Context, *GetContextRequest) (*Context, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetContext not implemented")
}
func (*UnimplementedMetadataServiceServer) ListContexts(context.Context, *ListContextsRequest) (*ListContextsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListContexts not implemented")
}
func (*UnimplementedMetadataServiceServer) UpdateContext(context.Context, *UpdateContextRequest) (*Context, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateContext not implemented")
}
func (*UnimplementedMetadataServiceServer) DeleteContext(context.Context, *DeleteContextRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteContext not implemented")
}
func (*UnimplementedMetadataServiceServer) PurgeContexts(context.Context, *PurgeContextsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PurgeContexts not implemented")
}
func (*UnimplementedMetadataServiceServer) AddContextArtifactsAndExecutions(context.Context, *AddContextArtifactsAndExecutionsRequest) (*AddContextArtifactsAndExecutionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddContextArtifactsAndExecutions not implemented")
}
func (*UnimplementedMetadataServiceServer) AddContextChildren(context.Context, *AddContextChildrenRequest) (*AddContextChildrenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddContextChildren not implemented")
}
func (*UnimplementedMetadataServiceServer) RemoveContextChildren(context.Context, *RemoveContextChildrenRequest) (*RemoveContextChildrenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveContextChildren not implemented")
}
func (*UnimplementedMetadataServiceServer) QueryContextLineageSubgraph(context.Context, *QueryContextLineageSubgraphRequest) (*LineageSubgraph, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryContextLineageSubgraph not implemented")
}
func (*UnimplementedMetadataServiceServer) CreateExecution(context.Context, *CreateExecutionRequest) (*Execution, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateExecution not implemented")
}
func (*UnimplementedMetadataServiceServer) GetExecution(context.Context, *GetExecutionRequest) (*Execution, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetExecution not implemented")
}
func (*UnimplementedMetadataServiceServer) ListExecutions(context.Context, *ListExecutionsRequest) (*ListExecutionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListExecutions not implemented")
}
func (*UnimplementedMetadataServiceServer) UpdateExecution(context.Context, *UpdateExecutionRequest) (*Execution, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateExecution not implemented")
}
func (*UnimplementedMetadataServiceServer) DeleteExecution(context.Context, *DeleteExecutionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteExecution not implemented")
}
func (*UnimplementedMetadataServiceServer) PurgeExecutions(context.Context, *PurgeExecutionsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PurgeExecutions not implemented")
}
func (*UnimplementedMetadataServiceServer) AddExecutionEvents(context.Context, *AddExecutionEventsRequest) (*AddExecutionEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddExecutionEvents not implemented")
}
func (*UnimplementedMetadataServiceServer) QueryExecutionInputsAndOutputs(context.Context, *QueryExecutionInputsAndOutputsRequest) (*LineageSubgraph, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryExecutionInputsAndOutputs not implemented")
}
func (*UnimplementedMetadataServiceServer) CreateMetadataSchema(context.Context, *CreateMetadataSchemaRequest) (*MetadataSchema, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMetadataSchema not implemented")
}
func (*UnimplementedMetadataServiceServer) GetMetadataSchema(context.Context, *GetMetadataSchemaRequest) (*MetadataSchema, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMetadataSchema not implemented")
}
func (*UnimplementedMetadataServiceServer) ListMetadataSchemas(context.Context, *ListMetadataSchemasRequest) (*ListMetadataSchemasResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMetadataSchemas not implemented")
}
func (*UnimplementedMetadataServiceServer) QueryArtifactLineageSubgraph(context.Context, *QueryArtifactLineageSubgraphRequest) (*LineageSubgraph, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryArtifactLineageSubgraph not implemented")
}

func RegisterMetadataServiceServer(s *grpc.Server, srv MetadataServiceServer) {
	s.RegisterService(&_MetadataService_serviceDesc, srv)
}

func _MetadataService_CreateMetadataStore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMetadataStoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).CreateMetadataStore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/CreateMetadataStore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).CreateMetadataStore(ctx, req.(*CreateMetadataStoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_GetMetadataStore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMetadataStoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).GetMetadataStore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/GetMetadataStore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).GetMetadataStore(ctx, req.(*GetMetadataStoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_ListMetadataStores_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMetadataStoresRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).ListMetadataStores(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/ListMetadataStores",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).ListMetadataStores(ctx, req.(*ListMetadataStoresRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_DeleteMetadataStore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMetadataStoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).DeleteMetadataStore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/DeleteMetadataStore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).DeleteMetadataStore(ctx, req.(*DeleteMetadataStoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_CreateArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).CreateArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/CreateArtifact",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).CreateArtifact(ctx, req.(*CreateArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_GetArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).GetArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/GetArtifact",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).GetArtifact(ctx, req.(*GetArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_ListArtifacts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListArtifactsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).ListArtifacts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/ListArtifacts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).ListArtifacts(ctx, req.(*ListArtifactsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_UpdateArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).UpdateArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/UpdateArtifact",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).UpdateArtifact(ctx, req.(*UpdateArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_DeleteArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).DeleteArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/DeleteArtifact",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).DeleteArtifact(ctx, req.(*DeleteArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_PurgeArtifacts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PurgeArtifactsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).PurgeArtifacts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/PurgeArtifacts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).PurgeArtifacts(ctx, req.(*PurgeArtifactsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_CreateContext_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateContextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).CreateContext(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/CreateContext",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).CreateContext(ctx, req.(*CreateContextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_GetContext_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetContextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).GetContext(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/GetContext",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).GetContext(ctx, req.(*GetContextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_ListContexts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListContextsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).ListContexts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/ListContexts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).ListContexts(ctx, req.(*ListContextsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_UpdateContext_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateContextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).UpdateContext(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/UpdateContext",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).UpdateContext(ctx, req.(*UpdateContextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_DeleteContext_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteContextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).DeleteContext(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/DeleteContext",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).DeleteContext(ctx, req.(*DeleteContextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_PurgeContexts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PurgeContextsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).PurgeContexts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/PurgeContexts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).PurgeContexts(ctx, req.(*PurgeContextsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_AddContextArtifactsAndExecutions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddContextArtifactsAndExecutionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).AddContextArtifactsAndExecutions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/AddContextArtifactsAndExecutions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).AddContextArtifactsAndExecutions(ctx, req.(*AddContextArtifactsAndExecutionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_AddContextChildren_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddContextChildrenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).AddContextChildren(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/AddContextChildren",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).AddContextChildren(ctx, req.(*AddContextChildrenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_RemoveContextChildren_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveContextChildrenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).RemoveContextChildren(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/RemoveContextChildren",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).RemoveContextChildren(ctx, req.(*RemoveContextChildrenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_QueryContextLineageSubgraph_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryContextLineageSubgraphRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).QueryContextLineageSubgraph(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/QueryContextLineageSubgraph",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).QueryContextLineageSubgraph(ctx, req.(*QueryContextLineageSubgraphRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_CreateExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).CreateExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/CreateExecution",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).CreateExecution(ctx, req.(*CreateExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_GetExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).GetExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/GetExecution",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).GetExecution(ctx, req.(*GetExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_ListExecutions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListExecutionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).ListExecutions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/ListExecutions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).ListExecutions(ctx, req.(*ListExecutionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_UpdateExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).UpdateExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/UpdateExecution",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).UpdateExecution(ctx, req.(*UpdateExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_DeleteExecution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteExecutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).DeleteExecution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/DeleteExecution",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).DeleteExecution(ctx, req.(*DeleteExecutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_PurgeExecutions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PurgeExecutionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).PurgeExecutions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/PurgeExecutions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).PurgeExecutions(ctx, req.(*PurgeExecutionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_AddExecutionEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddExecutionEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).AddExecutionEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/AddExecutionEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).AddExecutionEvents(ctx, req.(*AddExecutionEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_QueryExecutionInputsAndOutputs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryExecutionInputsAndOutputsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).QueryExecutionInputsAndOutputs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/QueryExecutionInputsAndOutputs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).QueryExecutionInputsAndOutputs(ctx, req.(*QueryExecutionInputsAndOutputsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_CreateMetadataSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMetadataSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).CreateMetadataSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/CreateMetadataSchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).CreateMetadataSchema(ctx, req.(*CreateMetadataSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_GetMetadataSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMetadataSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).GetMetadataSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/GetMetadataSchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).GetMetadataSchema(ctx, req.(*GetMetadataSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_ListMetadataSchemas_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMetadataSchemasRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).ListMetadataSchemas(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/ListMetadataSchemas",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).ListMetadataSchemas(ctx, req.(*ListMetadataSchemasRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetadataService_QueryArtifactLineageSubgraph_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryArtifactLineageSubgraphRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetadataServiceServer).QueryArtifactLineageSubgraph(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.MetadataService/QueryArtifactLineageSubgraph",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetadataServiceServer).QueryArtifactLineageSubgraph(ctx, req.(*QueryArtifactLineageSubgraphRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _MetadataService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.MetadataService",
	HandlerType: (*MetadataServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateMetadataStore",
			Handler:    _MetadataService_CreateMetadataStore_Handler,
		},
		{
			MethodName: "GetMetadataStore",
			Handler:    _MetadataService_GetMetadataStore_Handler,
		},
		{
			MethodName: "ListMetadataStores",
			Handler:    _MetadataService_ListMetadataStores_Handler,
		},
		{
			MethodName: "DeleteMetadataStore",
			Handler:    _MetadataService_DeleteMetadataStore_Handler,
		},
		{
			MethodName: "CreateArtifact",
			Handler:    _MetadataService_CreateArtifact_Handler,
		},
		{
			MethodName: "GetArtifact",
			Handler:    _MetadataService_GetArtifact_Handler,
		},
		{
			MethodName: "ListArtifacts",
			Handler:    _MetadataService_ListArtifacts_Handler,
		},
		{
			MethodName: "UpdateArtifact",
			Handler:    _MetadataService_UpdateArtifact_Handler,
		},
		{
			MethodName: "DeleteArtifact",
			Handler:    _MetadataService_DeleteArtifact_Handler,
		},
		{
			MethodName: "PurgeArtifacts",
			Handler:    _MetadataService_PurgeArtifacts_Handler,
		},
		{
			MethodName: "CreateContext",
			Handler:    _MetadataService_CreateContext_Handler,
		},
		{
			MethodName: "GetContext",
			Handler:    _MetadataService_GetContext_Handler,
		},
		{
			MethodName: "ListContexts",
			Handler:    _MetadataService_ListContexts_Handler,
		},
		{
			MethodName: "UpdateContext",
			Handler:    _MetadataService_UpdateContext_Handler,
		},
		{
			MethodName: "DeleteContext",
			Handler:    _MetadataService_DeleteContext_Handler,
		},
		{
			MethodName: "PurgeContexts",
			Handler:    _MetadataService_PurgeContexts_Handler,
		},
		{
			MethodName: "AddContextArtifactsAndExecutions",
			Handler:    _MetadataService_AddContextArtifactsAndExecutions_Handler,
		},
		{
			MethodName: "AddContextChildren",
			Handler:    _MetadataService_AddContextChildren_Handler,
		},
		{
			MethodName: "RemoveContextChildren",
			Handler:    _MetadataService_RemoveContextChildren_Handler,
		},
		{
			MethodName: "QueryContextLineageSubgraph",
			Handler:    _MetadataService_QueryContextLineageSubgraph_Handler,
		},
		{
			MethodName: "CreateExecution",
			Handler:    _MetadataService_CreateExecution_Handler,
		},
		{
			MethodName: "GetExecution",
			Handler:    _MetadataService_GetExecution_Handler,
		},
		{
			MethodName: "ListExecutions",
			Handler:    _MetadataService_ListExecutions_Handler,
		},
		{
			MethodName: "UpdateExecution",
			Handler:    _MetadataService_UpdateExecution_Handler,
		},
		{
			MethodName: "DeleteExecution",
			Handler:    _MetadataService_DeleteExecution_Handler,
		},
		{
			MethodName: "PurgeExecutions",
			Handler:    _MetadataService_PurgeExecutions_Handler,
		},
		{
			MethodName: "AddExecutionEvents",
			Handler:    _MetadataService_AddExecutionEvents_Handler,
		},
		{
			MethodName: "QueryExecutionInputsAndOutputs",
			Handler:    _MetadataService_QueryExecutionInputsAndOutputs_Handler,
		},
		{
			MethodName: "CreateMetadataSchema",
			Handler:    _MetadataService_CreateMetadataSchema_Handler,
		},
		{
			MethodName: "GetMetadataSchema",
			Handler:    _MetadataService_GetMetadataSchema_Handler,
		},
		{
			MethodName: "ListMetadataSchemas",
			Handler:    _MetadataService_ListMetadataSchemas_Handler,
		},
		{
			MethodName: "QueryArtifactLineageSubgraph",
			Handler:    _MetadataService_QueryArtifactLineageSubgraph_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1beta1/metadata_service.proto",
}
