```toml
[advisory]
id = "CVE-2022-21658"
package = "std"
categories = ["file-disclosure"]
date = "2022-01-16"
url = "https://blog.rust-lang.org/2022/01/20/cve-2022-21658.html"
cvss = "CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:C/C:N/I:L/A:H"

[affected]
[affected.functions]
"std::fs::remove_dir_all" = ["< 1.58.1"]

[versions]
patched = [">= 1.58.1"]
```

# Time-of-check time-of-use race condition can allow attacker to delete files they do not have access to delete

In the standard library in Rust before 1.58.1, an attacker with unprivileged access to a system could trick a privileged program using `std::fs::remove_dir_all` into deleting files they don't have access to delete by creating a symlink in a directory that would be removed by a `std::fs::remove_dir_all` call due to a Time-of-check time-of-use race condition around this function's check for symbolic links. The function should remove the symbolic links rather than recursively deleting the linked file or directory.
