```toml
[advisory]
id = "CVE-2019-1010299"
package = "std"
categories = ["memory-exposure"]
date = "2018-08-21"
url = "https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2019-1010299"

[versions]
patched = [">= 1.30.0"]
unaffected = ["< 1.18.0"]
```

# vec_deque::Iter has unsound Debug implementation

The Rust Programming Language Standard Library 1.18.0 and later is affected by: CWE-200: Information Exposure. The impact is: Contents of uninitialized memory could be printed to string or to log file. The component is: Debug trait implementation for std::collections::vec_deque::Iter. The attack vector is: The program needs to invoke debug printing for iterator over an empty VecDeque. The fixed version is: 1.30.0, nightly versions after commit b85e4cc8fadaabd41da5b9645c08c68b8f89908d.
