```toml
[advisory]
id = "CVE-2018-1000622"
package = "rustdoc"
categories = ["code-execution"]
cvss = "CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:H/I:H/A:H"
date = "2018-07-05"
url = "https://groups.google.com/forum/#!topic/rustlang-security-announcements/4ybxYLTtXuM"

[versions]
patched = ["> 1.27.0"]
```

# Uncontrolled search path element vulnerability in rustdoc plugins

Rustdoc, if not passed the `--plugin-path` argument, defaults to
`/tmp/rustdoc/plugins`. `/tmp` is world-writable on many systems, and so an
attacker could craft a malicious plugin, place it in that directory, and the
victim would end up executing their code. This only occurs when the
`--plugin` argument is also passed. If you're not using that argument, then
the loading, and therefore the bug, will not happen.

Because this feature is very difficult to use, and has been deprecated for
almost a year[2] with no comments on its usage, we don't expect this to
affect many users. For more details, read on.

## Background

Rustdoc has a "plugins" feature that lets you extend rustdoc. To write a
plugin, you create a library with a specific exposed symbol. You instruct
rustdoc to use this plugin, and it will load it, and execute the function as
a callback to modify rustdoc's AST.

This feature is quite hard to use, because the function needs to take as
input and return as output Rustdoc's AST type. The Rust project does not ship
a copy of `librustdoc` to end users, and so they would have to synthesize
this type on their own. Furthermore, Rust's ABI is unstable, and so
dynamically loading a plugin is only guaranteed to work if the plugin is
compiled with the same compiler revision as the rustdoc that you're using.
Beyond that, the feature and how to use it are completely undocumented.

Given all of this, we're not aware of any usage of plugins in the wild,
though the functionality still exists in the codebase.

## Description of the attack

If you pass the `--plugins` parameter, let's say with "foo", and *do not*
pass the `--plugin-path` parameter, rustdoc will look for the "foo" plugin
in /tmp/rustdoc/plugins. Given that /tmp is world-writable on many systems,
an attacker with access to your machine could place a maliciously crafted
plugin into /tmp/rustdoc/plugins, and rustdoc would then load the plugin,
and execute the attacker's callback, running arbitrary Rust code as your
user instead of theirs.

## Affected Versions

This functionality was introduced into rustdoc on December 31, 2013, in commit
14f59e890207f3b7a70bcfffaea7ad8865604111 [3]. That change was to rename
`/tmp/rustdoc_ng/plugins` to `/tmp/rustdoc/plugins`; The addition of this
search path generally came with the first commit to this iteration of rustdoc,
on September 22, 2013, in commit 7b24efd6f333620ed2559d70b32da8f6f9957385 [4].

## Mitigations

To prevent this bug from happening on any version of Rust, you can always
pass the `--plugin-path` flag to control the path. This only applies if
you use the `--plugin` flag in the first place.

For Rust 1.27, we'll be releasing a 1.27.1 on Tuesday with the fix, which
consists of requiring `--plugin-path` to be passed whenever `--plugin`
is passed.

We will not be releasing our own fixes for previous versions of Rust, given
the low severity and impact of this bug. The patch to fix 1.27 should be
trivially applicable to previous versions, as this code has not changed in
a very long time. The patch is included at the end of this email. If you
need assistance patching an older version of Rust on your own, please reach
out to Steve Klabnik, st...@steveklabnik.com, and he'll be happy to help.

On beta and nightly we will be removing plugins entirely.

## Timeline of events

* Tue, Jul 3, 2018 at 11:57 PM UTC - Bug reported to security@rust-lang.org
* Tue, Jul 3, 2018 at 12:13 PM UTC - Steve responds, confirming the bug
* Weds, Jul 4, 2018 - Steve works up an initial patch
* Thu, Jul 5, 2018 at 6:00 PM UTC - Rust team decides to not embargo this bug
* Fri, Jul 6, 2018 at 12:38 AM - Final patch created after feedback from Red Hat

## Acknowledgements

Thanks to Red Hat Product Security, which found this bug. And specifically to
Josh Stone, who took their findings and reported it to us in accordance with
our security policy https://www.rust-lang.org/security.html, as well as providing
feedback on the patch itself. You can find their bug at [5].

[1]: https://cwe.mitre.org/data/definitions/427.html
[2]: https://github.com/rust-lang/rust/issues/44136
[3]: https://github.com/rust-lang/rust/commit/14f59e890207f3b7a70bcfffaea7ad8865604111
[4]: https://github.com/rust-lang/rust/commit/7b24efd6f333620ed2559d70b32da8f6f9957385
[5]: https://bugzilla.redhat.com/show_bug.cgi?id=1597063
