```toml
[advisory]
id = "RUSTSEC-2020-0001"
package = "trust-dns-server"
aliases = ["CVE-2020-35857", "GHSA-4cww-f7w5-x525"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"
categories = ["denial-of-service"]
date = "2020-01-06"
keywords = ["stack-overflow", "crash"]
url = "https://github.com/bluejekyll/trust-dns/issues/980"

[versions]
patched = [">= 0.18.1"]
unaffected = ["< 0.16.0"]
```

# Stack overflow when resolving additional records from MX or SRV null targets

There's a stack overflow leading to a crash and potential DOS when processing
additional records for return of MX or SRV record types from the server.

This is only possible when a zone is configured with a null target for MX or SRV records, i.e. '.'.

Example effected zone record:
```text
no-service 86400 IN MX 0 .
```

Prior to 0.16.0 the additional record processing was not supported by trust-dns-server. There
Are no known issues with upgrading from 0.16 or 0.17 to 0.18.1. The remidy should be to upgrade to
0.18.1. If unable to do so, MX, SRV or other record types with a target to the null type, should be avoided.
